#!/bin/sh
# Register an Axyl website in our CSV database
# Paul Waite
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e
set -f

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# This script requires that Axyl is properly installed. If it isn't
# then the following vars will not be defined, which is an error.
if [ "$AXUSER" = "" -o "$AXYL_DATA" = "" ]
then
  echo "ERROR: Axyl is not configured properly and one of AXUSER, and/or"
  echo "AXYL_DATA are undefined. Check /etc/axyl/axyl.conf exists and"
  echo "contains these settings. Otherwise, do you need to run script"
  echo "./setup-axyl.sh first?"
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# INCOMING PARAMETERS
#  $1  - APP_NAME
#  $2  - DBTYPE
#  $3  - DBNAME
#  $4  - DBUSER
#  $5  - DBPASSWD ('none' means a blank password)
#  $6  - DBHOST ('direct' means a local database server)
#  $7  - DBPORT
#  $8  - DOCROOT (site docroot of website)
#  $9  - VHOST (Apache virtual host)
#  $10 - VSERVERNAME (Virtual host server name)
#  $11 - ADMIN_EMAIL (e-mail for admin)
APP_NAME=""
DBTYPE=""
DBNAME=""
DBUSER=""
DBPASSWD=""
DBHOST=""
DBPORT=5432
DOCROOT=""
VHOST=""
VSERVERNAME=""
ADMIN_EMAIL=""

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  APP_NAME=$1
        ;;
    2)  DBTYPE=$1
        ;;
    3)  DBNAME=$1
        ;;
    4)  DBUSER=$1
        ;;
    5)  DBPASSWD=$1
        ;;
    6)  DBHOST=$1
        ;;
    7)  DBPORT=$1
        ;;
    8)  DOCROOT=$1
        ;;
    9)  VHOST=$1
        ;;
   10)  VSERVERNAME=$1
        ;;
   11)  ADMIN_EMAIL=$1
        ;;
  esac
  shift
done

if [ "$APP_NAME" = "" ]
then
  echo "ERROR: register-axyl-website.sh: parameters."
  echo "usage: register-axyl-website.sh app_name dbtype dbname dbuser dbpasswd dbhost dbport docroot vhost vservername admin_email"
  exit 0
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Update Axyl websites database

# Remove any existing entry, then append new/updated entry..
if [ -x ${AXYL_HOME}/install/unregister-axyl-website.sh ]
then
  AXYL_SYSTEM=${AXYL_DATA}/system
  AXYL_DB=${AXYL_SYSTEM}/axyl_websites.csv
  ${AXYL_HOME}/install/unregister-axyl-website.sh $APP_NAME
  VHOST=`echo $VHOST | sed -e "s;ASTERISK;*;g"`
  echo "$APP_NAME,$DBTYPE,$DBNAME,$DBUSER,$DBPASSWD,$DBHOST,$DBPORT,$DOCROOT,$VHOST,$VSERVERNAME,$ADMIN_EMAIL" >>${AXYL_DB}
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# END