<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    wysiwyg-editor-defs.php                                 */
/* Author:      Paul Waite                                              */
/* Description: Common include for various UI wysiwyg editors.          */
/*                                                                      */
/* ******************************************************************** */
/** @package form */

/**
 * According to the UI toolkit in force, we include the appropriate
 * definitions files. In each case the same classes and functions
 * will be defined and made available, so that higher level code
 * can remain the same.
 */
debugbr("Page UI toolkit is set to: " . $RESPONSE->ui_toolkit);

switch ($RESPONSE->ui_toolkit) {
  case "dojo":
    include_once("dojo-editor-defs.php");
    break;
    
  case "axyl":
    include_once("htmlarea-defs.php");
    break;
  
  default:
    include_once("htmlarea-defs.php");
    break;
} // switch

?>