#!/usr/bin/perl -w
#
# Inject lines into a file
#
# The lines to be injected are expected to be supplied on STDIN.
# This script takes two mandatory parameters on the command line. The
# first is the full path to the file to inject the lines into. The second
# is a perl regex to match the line below which to inject the new lines.
# A third optional parameter -a can be used to make it inject the lines
# after the pattern-matched line, nstead of before (the default).
#
# Parameters:
#  -f <target file>   - File into which lines are to be inserted
#  -e <regex pattern> - Pattern to identify line to insert at
#  -a                 - Insert AFTER pattern, defaults to BEFORE
#
# example of usage:
#   cat myfile | inject-lines.pl -f "foo" -e "^bar" -a
#
# Would inject lines contained in file 'myfile' into file 'foo' AFTER
# a line matching the regex '/^bar/'.
#
# NOTE: If the regex is omitted, then the lines will be injected before
# the very first line (or after if -a is set).
#
# Return codes:
#     0 - Successful
#     1 - Regex not satified, no match was found
#     2 - Failed to update/write the target file
#
use Getopt::Std;
getopts('f:e:a');

# options
$opt_f = "" unless defined $opt_f;
$opt_e = "" unless defined $opt_e;
$opt_a = 0  unless defined $opt_a;

# vars..
my $line = "";
my $done = 0;
my $tmp = "/tmp/" . "inj" . $$;

if (open TARG, "<$opt_f") {
  if (open TMP, ">$tmp" ) {
    while (<TARG>) {
      $line = $_;
      if ($done == 0) {
        if (/$opt_e/) {
          print TMP $line unless !$opt_a;
          while (<>) {
            print TMP;
          }
          print TMP $line unless $opt_a;
          $done = 1;
        }
        else {
          print TMP $line;
        }
      }
      else {
        print TMP $line;
      }
    } # while
    close TMP;
  }
  close TARG;
  # Copy over original if done
  if ($done == 1) {
    my @copycmd = ("cp", $tmp, $opt_f);
    if (system(@copycmd) == 0) {
      $ret = 0;
    }
    else {
      $ret = 2;
    }
  }
  else {
    $ret = 1;
  }
  # Tidy up..
  unlink $tmp;
}

# exit with return code
exit $ret;