<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-rpc-processor.php                                  */
/* Author:      Paul Waite                                              */
/* Description: Processor for RPC calls from client web-browsers which  */
/*              are requesting services.                                */
/*                                                                      */
/*              To set up RPC you need to include Axyl json-rpc classes */
/*                eg: include_once('json-rpc-defs.php');                */
/*              (as this very example script does, in fact)             */
/*                                                                      */
/*              Do this in the webpage that you will be executing the   */
/*              RPC calls from, and also the server-side Php script     */
/*              which will be the RPC processor (this script is an      */
/*              example of that - feel free to hack and use it)         */
/*                                                                      */
/*              Next define the services in a services definition file. */
/*              See 'axyl-rpc-services.smd' for an example of that.     */
/*              That file names the script providing the services (the  */
/*              RPC 'processor' script) of which this is an example.    */
/*              It also details the parameters to be passed for each.   */
/*                                                                      */
/*              Then, in your webpage, instantiate a 'jsonRPC' object,  */
/*              with the URL to the services (.smd) file you created.   */
/*              Use the 'addRPC()' method to add functions which will   */
/*              perform your RPC calls. These must be named the same as */
/*              the RPC methods you defined in your .smd file.          */
/*                                                                      */
/*              Finally, to your webpage, add the custom javascript     */
/*              which will call the RPC functions. Typically this might */
/*              involve calling them from events etc.                   */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("json-rpc-defs.php");

// RPC will send us the request as JSON
$jsonRequest = file_get_contents('php://input');

$conv = new JSONconverter();
$request = $conv->fromJSON($jsonRequest);

$rpc_id     = $request->id;
$rpc_method = $request->method;
$rpc_params = $request->params;
$rpc_result = "";
$rpc_error  = "";

// Add a case for each of your RPC services here
switch ($rpc_method) {
  case "MyRPCServiceName" :
    /**
     * The 'YourRPCFunctionName' will be one defined in the .smd
     * service definitions file. If that RPC call is made then this
     * switch case will be executed.
     * 
     * You then use the $rpc_params to do your processing. If you
     * need to return data, then do that by defining the '$rpc_result'
     * as a scalar (ie. a string or numeric value) in the scope of
     * this case statement. Then it will be passed back (see below).
     * 
     * In your callback function (javascript in the client webspage)
     * this response will then arrive as a three-element array in the
     * first argument to the function. So a callback function might
     * look something like this:
     *     mycallback(response, ioargs) {
     *       result = response[0];
     *       error  = response[1];
     *       rpcid  = response[2];
     *       -- your processing --
     *     }
     */
    break;

  default:
    log_sys(
      "RPC: unsupported method=[$rpc_method] "
    . "id=[$rpc_id] "
    . "params=[" . implode(", ", $rpc_params) . "]"
    );
} // switch

// ----------------------------------------------------------------------
// The RPC callback function will receive this response and store it in
// the relevant '<funcname>_response', and '<funcname>_ioargs'
// variables
$RESPONSE->discard();
echo jsonRPCresponse($rpc_result, $rpc_error, $rpc_id);
?>