#---------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#---------------------------------------------------------------------------------------------
#pylint: skip-file

# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DeploymentVnet(Model):
    """
    Deployment operation parameters.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar uri: URI referencing the template. Default value:
     "https://azuresdkci.blob.core.windows.net/templatehost/CreateVnet_2016-09-07/azuredeploy.json"
     .
    :vartype uri: str
    :param content_version: If included it must match the ContentVersion in
     the template.
    :type content_version: str
    :param dns_servers: List of DNS server IP addresses.
    :type dns_servers: list of object
    :param location: Virtual network location.
    :type location: str
    :param subnet_name: Name of the subnet. Default value: "Subnet1" .
    :type subnet_name: str
    :param subnet_prefix: IP address for the subnet. Default value:
     "10.0.0.0/24" .
    :type subnet_prefix: str
    :param tags: Tags object.
    :type tags: object
    :param virtual_network_name: Name of the virtual network.
    :type virtual_network_name: str
    :param virtual_network_prefix: IP address prefix for the virtual network.
     Default value: "10.0.0.0/16" .
    :type virtual_network_prefix: str
    :ivar mode: Gets or sets the deployment mode. Default value:
     "Incremental" .
    :vartype mode: str
    """ 

    _validation = {
        'uri': {'required': True, 'constant': True},
        'virtual_network_name': {'required': True},
        'mode': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'uri': {'key': 'properties.templateLink.uri', 'type': 'str'},
        'content_version': {'key': 'properties.templateLink.contentVersion', 'type': 'str'},
        'dns_servers': {'key': 'properties.parameters.dnsServers.value', 'type': '[object]'},
        'location': {'key': 'properties.parameters.location.value', 'type': 'str'},
        'subnet_name': {'key': 'properties.parameters.subnetName.value', 'type': 'str'},
        'subnet_prefix': {'key': 'properties.parameters.subnetPrefix.value', 'type': 'str'},
        'tags': {'key': 'properties.parameters.tags.value', 'type': 'object'},
        'virtual_network_name': {'key': 'properties.parameters.virtualNetworkName.value', 'type': 'str'},
        'virtual_network_prefix': {'key': 'properties.parameters.virtualNetworkPrefix.value', 'type': 'str'},
        'mode': {'key': 'properties.mode', 'type': 'str'},
    }

    uri = "https://azuresdkci.blob.core.windows.net/templatehost/CreateVnet_2016-09-07/azuredeploy.json"

    mode = "Incremental"

    def __init__(self, virtual_network_name, content_version=None, dns_servers=None, location=None, subnet_name="Subnet1", subnet_prefix="10.0.0.0/24", tags=None, virtual_network_prefix="10.0.0.0/16"):
        self.content_version = content_version
        self.dns_servers = dns_servers
        self.location = location
        self.subnet_name = subnet_name
        self.subnet_prefix = subnet_prefix
        self.tags = tags
        self.virtual_network_name = virtual_network_name
        self.virtual_network_prefix = virtual_network_prefix
