/*
 * Created on 2004-2-18
 */
package org.jibble.lz.pircbot;
import java.util.*;
/**
 * @author Leon
 */
public class IrcUser {
	private String nick;
	private String login;
	private String host;
	private Date ignoredTime;
	private long ignoreDuration;
	private int ignoredType;
	/**
	 * @param nick
	 * @param login
	 * @param host
	 */
	public IrcUser(String nick, String login, String host) {
		super();
		this.nick = nick;
		this.login = login;
		this.host = host;
	}
	/**
	 * @param user
	 */
	public IrcUser(IrcUser user) {
		this.nick = user.getNick();
		this.login = user.getLogin();
		this.host = user.getHost();
	}
	/**
	 * Comment for <code>HOST_TYPE_1</code> mask: nick!login@host
	 */
	public static final int HOST_TYPE_1 = 1;
	/**
	 * Comment for <code>HOST_TYPE_2</code> mask: nick!login@*
	 */
	public static final int HOST_TYPE_2 = 2;
	/**
	 * Comment for <code>HOST_TYPE_3</code> mask: nick!*@*
	 */
	public static final int HOST_TYPE_3 = 3;
	/**
	 * Comment for <code>HOST_TYPE_4</code> mask: nick!*@host
	 */
	public static final int HOST_TYPE_4 = 4;
	/**
	 * Comment for <code>HOST_TYPE_5</code> mask: *!login@host
	 */
	public static final int HOST_TYPE_5 = 5;
	/**
	 * Comment for <code>HOST_TYPE_6</code> mask: *!*@host
	 */
	public static final int HOST_TYPE_6 = 6;
	/**
	 * Comment for <code>HOST_TYPE_7</code> mask: *!login@*
	 */
	public String getHost() {
		return host;
	}
	/**
	 * @param host The host to set.
	 */
	public void setHost(String host) {
		this.host = host;
	}
	/**
	 * @return Returns the ignoredTime.
	 */
	protected Date getIgnoredTime() {
		return ignoredTime;
	}
	/**
	 * @param ignoredTime The ignoredTime to set.
	 */
	protected void setIgnoredTime(Date ignoredTime) {
		this.ignoredTime = ignoredTime;
	}
	/**
	 * @return Returns the ignoreDuration.
	 */
	protected long getIgnoreDuration() {
		return ignoreDuration;
	}
	/**
	 * @param ignoreDuration The ignoreDuration to set.
	 */
	protected void setIgnoreDuration(long ignoreDuration) {
		this.ignoreDuration = ignoreDuration;
	}
	/**
	 * @return Returns the login.
	 */
	public String getLogin() {
		return login;
	}
	/**
	 * @param login The login to set.
	 */
	public void setLogin(String login) {
		this.login = login;
	}
	/**
	 * @return Returns the nick.
	 */
	public String getNick() {
		return nick;
	}
	/**
	 * @param nick The nick to set.
	 */
	public void setNick(String nick) {
		this.nick = nick;
	}
	/*
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		return mask(HOST_TYPE_1);
	}
	public String mask(int type) {
		switch (type) {
			case HOST_TYPE_1 :
				return nick + "!" + login + "@" + host;
			case HOST_TYPE_2 :
				return nick + "!" + login + "@*";
			case HOST_TYPE_3 :
				return nick + "!*@" + host;
			case HOST_TYPE_4 :
				return "*!" + login + "@" + host;
			case HOST_TYPE_5 :
				return "*!*@" + host;
			case HOST_TYPE_6 :
				return "*!" + login + "@*";
			default :
				return null;
		}
	}
	/**
	 * @return Returns the ignoredType.
	 */
	protected int getIgnoredType() {
		return ignoredType;
	}
	/**
	 * @param ignoredType The ignoredType to set.
	 */
	protected void setIgnoredType(int ignoredType) {
		this.ignoredType = ignoredType;
	}
	/**
	 * @param duration
	 */
	protected void ignore(long duration, int type) {
		setIgnoredTime(new Date());
		setIgnoredType(type);
		setIgnoreDuration(duration);
	}
	/**
	 * @return
	 */
	protected boolean isIgnored() {
		return (new Date()).getTime() < ignoredTime.getTime() + ignoreDuration;
	}
}
