/*
 * Created on 2004-3-11
 */
package org.cneclipse.bdcc.ui;

import org.cneclipse.bdcc.*;
import org.eclipse.swt.*;
import org.eclipse.swt.events.*;
import org.eclipse.swt.widgets.*;
import org.gudy.azureus2.core3.util.*;

/**
 * @author Leon
 */
public class BDCCDisconnectListener implements SelectionListener {

	private BDCCIrcClient client;
	private Shell parent;

	/**
	 * @param client
	 */
	public BDCCDisconnectListener(BDCCIrcClient client, Shell parent) {
		this.client = client;
		this.parent = parent;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetSelected(SelectionEvent e) {
		MessageBox mb = new MessageBox(parent, SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
		mb.setMessage("Do you really want to disconnect from IRC Server?");
		mb.setText("Really disconnect?");
		if (mb.open() == SWT.CANCEL) {
			return;
		}
		if (client.isConnected()) {
			client.setQuit(true);
			client.quitServer(BDCCIrcClient.VERSION_INFO + " on " + Constants.AZUREUS_NAME + " "
					+ Constants.AZUREUS_VERSION + " running " + client.getRunningTime());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {
	}
}
