<?php
/**
 * This file initializes everything BUT the blog!
 *
 * It is useful when you want to do very customized templates!
 * It is also called by more complete initializers.
 * 
 * b2evolution - {@link http://b2evolution.net/}
 * Released under GNU GPL License - {@link http://b2evolution.net/about/license.html}
 * @copyright (c)2003-2005 by Francois PLANQUE - {@link http://fplanque.net/}
 *
 * @package evocore
 */
if( isset( $main_init ) )
{	// Prevent double loading since require_once won't work in all situations
	// on windows when some subfolders have caps :(
	// (Check it out on static page generation)
	return;
}
$main_init = true;


/**
 * Load configuration:
 */
require_once( dirname(__FILE__).'/../conf/_config.php' );
if( !$config_is_done )
{	// base config is not done.
	$error_message = 'Base configuration is not done.';
	require dirname(__FILE__).'/_conf_error.page.php';	// error & exit
}


/**
 * Start timers:
 */
require_once( dirname(__FILE__).'/_functions.php' );
timer_start();
require_once dirname(__FILE__).'/_timer.class.php';
$Timer = & new Timer('main');


/**
 * Set various arrays and vars for use in b2
 */
require_once( dirname(__FILE__).'/_vars.php' );


/**
 * Connecting to the db:
 */
require_once( dirname(__FILE__).'/_class_db.php' );
$DB = new DB( DB_USER, DB_PASSWORD, DB_NAME, DB_HOST, $db_aliases );


/**
 * Check for referer spam:
 *
 * (Inspired by Isaac's hack. Note: this is done differently in phoenix)
 */
if( empty($HTTP_REFERER) )
{	// There is no referer:
	if( $debug >= 2 ) echo '<!-- ash:no_ref -->';
}
else
{	// we have a referrer:
	if( strpos($HTTP_REFERER,$baseurl) === 0 )
	{	// We are referring from our own site:
		if( $debug >= 2 ) echo '<!-- ash:self_ref -->';
	}
	else
	{	// We're not referring from ourselves!
	 if( ! $DB->get_row( "SELECT aspm_ID, aspm_string
	  		 	FROM  $tableantispam
	       WHERE ".$DB->quote($HTTP_REFERER)." LIKE CONCAT('%',aspm_string,'%')
	       LIMIT 0, 1", OBJECT, 0, 'Advanced check for referer spam' ) )
		{	// Referer is not matched by antispam blacklist:
			if( $debug >= 2 ) echo '<!-- ash:ref_not_spam -->';
		}
		else
	  {	// THIS LOOKS LIKE REFERER SPAM!!
			require dirname(__FILE__).'/_referer_spam.page.php';	// error & exit
	  }
	}
}


require_once( dirname(__FILE__).'/_class_settings.php' );
require_once( dirname(__FILE__).'/_functions_template.php' );	// function to be called from templates
require_once( dirname(__FILE__).'/_functions_xmlrpc.php' );
require_once( dirname(__FILE__).'/_functions_xmlrpcs.php' );
require_once( dirname(__FILE__).'/_class_blog.php' );
require_once( dirname(__FILE__).'/_class_itemlist.php' );
require_once( dirname(__FILE__).'/_class_itemcache.php' );
require_once( dirname(__FILE__).'/_class_commentlist.php' );
require_once( dirname(__FILE__).'/_class_archivelist.php' );
require_once( dirname(__FILE__).'/_class_dataobjectcache.php' );
require_once( dirname(__FILE__).'/_class_calendar.php' );
require_once( dirname(__FILE__).'/_functions_hitlogs.php' ); // referer logging
require_once( dirname(__FILE__).'/_functions_forms.php' );
require_once( dirname(__FILE__).'/_class_renderer.php' );
require_once( dirname(__FILE__).'/_class_toolbars.php' );




if( !function_exists( 'gzencode' ) )
{ // when there is no function to gzip, we won't do it
	$use_gzipcompression = false;
}

if( $use_obhandler )
{ // register output buffer handler
	ob_start( 'obhandler' );
}



$Settings = & new Settings();

$servertimenow = time();
$localtimenow = $servertimenow + ($Settings->get('time_difference') * 3600);


// Locale stuff:
debug_log('default_locale from conf: '.$default_locale);

locale_overwritefromDB();
debug_log('default_locale from DB: '.$default_locale);

$default_locale = locale_from_httpaccept(); // set default locale by autodetect
debug_log('default_locale from HTTP_ACCEPT: '.$default_locale);

// Activate default locale:
locale_activate( $default_locale );


// Object caches init:
$GroupCache = & new DataObjectCache( 'Group', true, $tablegroups, 'grp_', 'grp_ID' );
$BlogCache = & new BlogCache();
$ItemCache = & new ItemCache();


// Plug-ins init:
$Renderer = & new Renderer();
$Toolbars = & new Toolbars();


// Login procedure:
if( !isset($login_required) ) $login_required = false;
if( $error = veriflog( $login_required ) )
{	// Login failed:
	require(dirname(__FILE__) . "/$core_dirout/$htsrv_subdir/login.php");
}

if( is_logged_in() && $current_User->get('locale') != $default_locale )
{ // change locale to users preference
	$default_locale = $current_User->get('locale');
	locale_activate( $default_locale );
	debug_log('default_locale from user profile: '.$default_locale);
}


// Load hacks file if it exists
@include_once( dirname(__FILE__) . '/../conf/hacks.php' );
?>