/*
 * File:          sidlx_rmi_Statistics_Impl.c
 * Symbol:        sidlx.rmi.Statistics-v0.1
 * Symbol Type:   class
 * Babel Version: 1.2.0
 * Description:   Server-side implementation for sidlx.rmi.Statistics
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "sidlx.rmi.Statistics" (version 0.1)
 * 
 *  A read-only class of statistics 
 */

#include "sidlx_rmi_Statistics_Impl.h"
#include "sidl_NotImplementedException.h"
#include "sidl_Exception.h"
#ifndef included_sidl_MemAllocException_h
#include "sidl_MemAllocException.h"
#endif

#line 31 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
/* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics._includes) */
#include "sidlx_common.h"
#include "sidl_MemAllocException.h"
/* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics._includes) */
#line 35 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"

#define SIDL_IOR_MAJOR_VERSION 2
#define SIDL_IOR_MINOR_VERSION 0
/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics__load"

#ifdef __cplusplus
extern "C"
#endif
void
impl_sidlx_rmi_Statistics__load(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 56 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics._load) */
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics._load) */
#line 58 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics__ctor"

#ifdef __cplusplus
extern "C"
#endif
void
impl_sidlx_rmi_Statistics__ctor(
  /* in */ sidlx_rmi_Statistics self,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 79 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics._ctor) */
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics._ctor) */
#line 81 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 * Special Class constructor called when the user wants to wrap his own private data.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics__ctor2"

#ifdef __cplusplus
extern "C"
#endif
void
impl_sidlx_rmi_Statistics__ctor2(
  /* in */ sidlx_rmi_Statistics self,
  /* in */ void* private_data,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 104 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics._ctor2) */
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics._ctor2) */
#line 106 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}
/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics__dtor"

#ifdef __cplusplus
extern "C"
#endif
void
impl_sidlx_rmi_Statistics__dtor(
  /* in */ sidlx_rmi_Statistics self,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 127 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics._dtor) */
    /* Insert-Code-Here {sidlx.rmi.Statistics._dtor} (destructor method) */
    /*
     * // boilerplate destructor
     * struct sidlx_rmi_Statistics__data *dptr = sidlx_rmi_Statistics__get_data(self);
     * if (dptr) {
     *   // free contained in dtor before next line
     *   free(dptr);
     *   sidlx_rmi_Statistics__set_data(self, NULL);
     * }
     */

    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics._dtor) */
#line 140 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of acceptions that succeed on first try 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalAcceptsFirstTry"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalAcceptsFirstTry(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 161 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalAcceptsFirstTry) */
    return get_sidlx_stats_struct()->totalAcceptsFirstTry;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalAcceptsFirstTry) */
#line 164 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of acceptions requested 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalAcceptRequests"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalAcceptRequests(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 185 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalAcceptRequests) */
    return get_sidlx_stats_struct()->totalAcceptsRequested;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalAcceptRequests) */
#line 188 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of acceptions granted (regardless of retries) 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalAcceptSucceded"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalAcceptSucceded(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 209 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalAcceptSucceded) */
    return get_sidlx_stats_struct()->totalAcceptsGranted;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalAcceptSucceded) */
#line 212 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  maximum number of retries needed to succeed 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getMaxAcceptRetries"

#ifdef __cplusplus
extern "C"
#endif
int32_t
impl_sidlx_rmi_Statistics_getMaxAcceptRetries(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 233 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getMaxAcceptRetries) */
     return get_sidlx_stats_struct()->maxAcceptRetries;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getMaxAcceptRetries) */
#line 236 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of retries /#successful accepts retried at least once 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getAvgAcceptRetries"

#ifdef __cplusplus
extern "C"
#endif
double
impl_sidlx_rmi_Statistics_getAvgAcceptRetries(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 257 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getAvgAcceptRetries) */
    struct sidlx_stats * stats = get_sidlx_stats_struct(); 
    long nGrantedOnRetry = stats->totalAcceptsGranted - stats->totalAcceptsFirstTry;
    if ( nGrantedOnRetry ) { 
      return (double) stats->totalAcceptRetries / nGrantedOnRetry; 
    } else {
      return 0.0; 
    }
      
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getAvgAcceptRetries) */
#line 267 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of connections that succeed on first try 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalConnectsFirstTry"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalConnectsFirstTry(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 288 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalConnectsFirstTry) */
    return get_sidlx_stats_struct()->totalConnectsFirstTry;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalConnectsFirstTry) */
#line 291 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of connections requested 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalConnectRequests"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalConnectRequests(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 312 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalConnectRequests) */
    return get_sidlx_stats_struct()->totalConnectsRequested;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalConnectRequests) */
#line 315 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of connections granted (regardless of retries) 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getTotalConnectSucceded"

#ifdef __cplusplus
extern "C"
#endif
int64_t
impl_sidlx_rmi_Statistics_getTotalConnectSucceded(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 336 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getTotalConnectSucceded) */
    return get_sidlx_stats_struct()->totalConnectsGranted;

    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getTotalConnectSucceded) */
#line 340 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  maximum number of retries needed to succeed 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getMaxConnectRetries"

#ifdef __cplusplus
extern "C"
#endif
int32_t
impl_sidlx_rmi_Statistics_getMaxConnectRetries(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 361 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getMaxConnectRetries) */
    return get_sidlx_stats_struct()->maxConnectRetries;
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getMaxConnectRetries) */
#line 364 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}

/*
 *  total number of retries /#successful connects retried at least once 
 */

#undef __FUNC__
#define __FUNC__ "impl_sidlx_rmi_Statistics_getAvgConnectRetries"

#ifdef __cplusplus
extern "C"
#endif
double
impl_sidlx_rmi_Statistics_getAvgConnectRetries(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 385 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
    /* DO-NOT-DELETE splicer.begin(sidlx.rmi.Statistics.getAvgConnectRetries) */
    struct sidlx_stats * stats = get_sidlx_stats_struct(); 
    long nGrantedOnRetry = stats->totalConnectsGranted - stats->totalConnectsFirstTry;
    if ( nGrantedOnRetry ) { 
      return (double) stats->totalConnectRetries / nGrantedOnRetry; 
    } else {
      return 0.0; 
    }
      
    /* DO-NOT-DELETE splicer.end(sidlx.rmi.Statistics.getAvgConnectRetries) */
#line 395 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
  }
}
/* Babel internal methods, Users should not edit below this line. */

#line 401 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/runtime/sidlx/sidlx_rmi_Statistics_Impl.c"
/* DO-NOT-DELETE splicer.begin(_misc) */
/* Insert-Code-Here {_misc} (miscellaneous code) */
/* DO-NOT-DELETE splicer.end(_misc) */
#line 404 "../runtime/sidlx/sidlx_rmi_Statistics_Impl.c"

