/*
 * Includes specific to the Director User Agent Server
 *
 *     Kern Sibbald, August MMI
 *
 *     Version $Id: ua.h,v 1.17 2003/06/02 14:26:37 kerns Exp $
 */
/*
   Copyright (C) 2000-2003 Kern Sibbald and John Walker

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

 */

#ifndef __UA_H_
#define __UA_H_ 1


struct UAContext {
   BSOCK *UA_sock;
   BSOCK *sd;
   JCR *jcr;
   B_DB *db;
   CAT *catalog;
   POOLMEM *cmd;		      /* return command/name buffer */
   POOLMEM *args;		      /* command line arguments */
   char *argk[MAX_CMD_ARGS];	      /* argument keywords */
   char *argv[MAX_CMD_ARGS];	      /* argument values */
   int argc;			      /* number of arguments */
   char **prompt;		      /* list of prompts */
   int max_prompts;		      /* max size of list */
   int num_prompts;		      /* current number in list */
   int auto_display_messages;	      /* if set, display messages */
   int user_notified_msg_pending;     /* set when user notified */
   int automount;		      /* if set, mount after label */
   int quit;			      /* if set, quit */
   int verbose; 		      /* set for normal UA verbosity */
   uint32_t pint32_val; 	      /* positive integer */
   int32_t  int32_val;		      /* positive/negative */
};	    

/* Context for insert_tree_handler() */
struct TREE_CTX {
   TREE_ROOT *root;		      /* root */
   TREE_NODE *node;		      /* current node */
   TREE_NODE *avail_node;	      /* unused node last insert */
   int cnt;			      /* count for user feedback */
   UAContext *ua;
};


#endif
