/*
 *   Version $Id: htable.h,v 1.2.6.1 2004/03/04 09:58:42 kerns Exp $
 */

/*
   Copyright (C) 2000-2003 Kern Sibbald and John Walker

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with this program; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA.

 */

/* ========================================================================
 * 
 *   Hash table class -- htable
 *
 */

/*
 * Loop var through each member of table
 */
#define foreach_htable(var, tbl) \
        for(((void *)(var))=(tbl)->first(); \
            (var); \
	    ((void *)(var))=(tbl)->next())

struct hlink {
   void *next;			      /* next hash item */
   char *key;			      /* key this item */
   uint32_t hash;		      /* hash for this key */
};

class htable {
   hlink **table;		      /* hash table */
   int loffset; 		      /* link offset in item */
   uint32_t num_items;		      /* current number of items */
   uint32_t max_items;		      /* maximum items before growing */
   uint32_t buckets;		      /* size of hash table */
   uint32_t hash;		      /* temp storage */
   uint32_t index;		      /* temp storage */
   uint32_t mask;                     /* "remainder" mask */
   uint32_t rshift;		      /* amount to shift down */
   hlink *walkptr;		      /* table walk pointer */
   uint32_t walk_index; 	      /* table walk index */
   void hash_index(char *key);	      /* produce hash key,index */
   void grow_table();		      /* grow the table */
public:
   htable(void *item, void *link, int tsize = 31);
   void init(void *item, void *link, int tsize = 31);
   bool  insert(char *key, void *item);
   void *lookup(char *key);
   void *first();		      /* get first item in table */
   void *next();		      /* get next item in table */
   void destroy();
   void stats();		      /* print stats about the table */
   uint32_t size();		      /* return size of table */
   void * operator new(size_t);
   void operator delete(void *);
};
