proc CreateMainWindow {} {
   . configure -menu .mbar
   menu .mbar
   .mbar add cascade -label "File" -underline 0 -menu .mbar.file
   menu .mbar.file

   .mbar.file add command -label "Connect" -underline 0 -command {ConnectCmd}
   .mbar.file add command -label "Backup" -underline 0 -command {BackupCmd}
   .mbar.file add command -label "Restore" -underline 0 -command {RestoreCmd}
   .mbar.file add command -label "Job" -underline 0 -command {JobCmd}
   .mbar.file add command -label "Schedule" -underline 0 -command {ScheduleCmd}
   .mbar.file add separator
   .mbar.file add command -label "Exit" -underline 0 -command {ExitCmd}

   .mbar add cascade -label "Options" -underline 0 -menu .mbar.options
   menu .mbar.options
   .mbar add cascade -label "Help" -underline 0 -menu .mbar.help
   menu .mbar.help
   .mbar.help add command -label "About Bacula" -underline 0 -command {AboutCmd}
   .mbar.help add command -label "Help" -underline 0 -command {HelpCmd}

   frame .main -borderwidth 0
   pack .main -side top 

   frame .logo -borderwidth 1 -relief raised
   pack .logo -in .main -side top -fill both -expand true
   image create photo BaculaLogo -file "bclogo.gif"
   label .logo.logo -image BaculaLogo
   pack .logo.logo -side top -expand true
   label .logo.msg1 -text "It comes in the night and sucks"
   pack .logo.msg1 -side top -fill x -expand true
   label .logo.msg2 -text "the vital essence from your computers."
   pack .logo.msg2 -side top -fill x -expand true
   label .logo.msg3 -text " "
   pack .logo.msg3 -side top -fill x -expand true
   label .logo.msg4 -text "Copyright 2000-2003 Kern Sibbald and John Walker"
   pack .logo.msg4 -side top -fill x -expand true
   label .logo.msg5 -text " " 
   pack .logo.msg5 -side top -fill x -expand true

   frame .status -borderwidth 1 -relief raised
   pack .status  -side bottom -fill x -pady 2
   label .statusLabel -text "Status:" -anchor e -fg magenta
   label .statusText -relief sunken -text "Ready ..." \
      -borderwidth 1 -textvariable StatusText -anchor w
   grid columnconfigure .status 1 -weight 1
   grid .statusLabel -in .status -row 0 -column 0
   grid .statusText -in .status -row 0 -column 1 -sticky ew -padx 3
}
