//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_11.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot11(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[11] = {5.483986957881850e-02,4.951741233503565e-01,1.384655740084600e+00,2.741919940106704e+00,4.597737700485708e+00,
    6.999397469528837e+00,1.001890827595723e+01,1.376930586610168e+01,1.844111968097818e+01,2.440196124238707e+01,3.259498009144084e+01};
  static constexpr double aw[11] = {4.435452264349594e-01,2.869714332469075e-01,1.191023609587828e-01,3.114037088442390e-02,4.978399335051669e-03,
    4.648850508842522e-04,2.365512855251061e-05,5.884287563300994e-07,5.966990986059663e-09,1.744339007547982e-11,6.167183424404054e-15};
  static constexpr double xr[48620] = {   1.017589213909947e-02,  -2.299517079871033e-04,   3.876056092356518e-06,  -5.766329796359856e-08,   7.968635053072134e-10,
  -1.045324290946777e-11,   1.314836825485282e-13,  -1.593049957142987e-15,   1.860766136148916e-17,  -2.091090574289721e-19,   2.247954613572350e-21,  -2.286225307788057e-23,
   2.151354940963147e-25,  -1.781958903557827e-27,   1.017625642057925e-02,  -2.299679603753937e-04,   3.876505374480415e-06,  -5.767312433501888e-08,   7.970489841461000e-10,
  -1.045639050220995e-11,   1.315327244440172e-13,  -1.593758787031230e-15,   1.861718786320368e-17,  -2.092274477999145e-19,   2.249290102385147e-21,  -2.287528587617711e-23,
   2.152293329228075e-25,  -1.782004719493706e-27,   1.017689923535981e-02,  -2.299966402221248e-04,   3.877298224827029e-06,  -5.769046552478409e-08,   7.973763206266284e-10,
  -1.046194561528110e-11,   1.316192799983384e-13,  -1.595009853761826e-15,   1.863400210995168e-17,  -2.094364041112924e-19,   2.251647064238929e-21,  -2.289828267966201e-23,
   2.153947998551233e-25,  -1.782082093000731e-27,   1.017767659248377e-02,  -2.300313240393063e-04,   3.878257092837796e-06,  -5.771143877431569e-08,   7.977722351551654e-10,
  -1.046866485496656e-11,   1.317239786186041e-13,  -1.596523211686555e-15,   1.865434189501105e-17,  -2.096891694808884e-19,   2.254497930115250e-21,  -2.292609103107949e-23,
   2.155946909384530e-25,  -1.782169730333424e-27,   1.017843129871900e-02,  -2.300649985104327e-04,   3.879188097065531e-06,  -5.773180353362555e-08,   7.981566824243335e-10,
  -1.047518980604161e-11,   1.318256545929774e-13,  -1.597992934336802e-15,   1.867409559486035e-17,  -2.099346472888365e-19,   2.257266341144948e-21,  -2.295308726759297e-23,
   2.157885388568082e-25,  -1.782248594018090e-27,   1.017903932424130e-02,  -2.300921291083949e-04,   3.879938210716413e-06,  -5.774821219442873e-08,   7.984664600225774e-10,
  -1.048044767622562e-11,   1.319075894979738e-13,  -1.599177340148913e-15,   1.869001478667090e-17,  -2.101324709223628e-19,   2.259497138419117e-21,  -2.297483533720648e-23,
   2.159445545248060e-25,  -1.782307666806205e-27,   1.017944111821708e-02,  -2.301100579354311e-04,   3.880433925708642e-06,  -5.775905625126068e-08,   7.986711907401131e-10,
  -1.048392269544639e-11,   1.319617433868159e-13,  -1.599960178307609e-15,   1.870053677860972e-17,  -2.102632234822574e-19,   2.260971503812205e-21,  -2.298920619267015e-23,
   2.160475754308318e-25,  -1.782344515054801e-27,   1.017964746531127e-02,  -2.301192656824385e-04,   3.880688515547070e-06,  -5.776462565912925e-08,   7.987763406464616e-10,
  -1.048570750439323e-11,   1.319895579475746e-13,  -1.600362266224678e-15,   1.870594121369609e-17,  -2.103303817630896e-19,   2.261728751970175e-21,  -2.299658635011323e-23,
   2.161004594650534e-25,  -1.782362761742678e-27,   1.017971928736778e-02,  -2.301224705925943e-04,   3.880777130494096e-06,  -5.776656421670368e-08,   7.988129407676175e-10,
  -1.048632875856703e-11,   1.319992396886853e-13,  -1.600502226647189e-15,   1.870782241832072e-17,  -2.103537585029074e-19,   2.261992333608097e-21,  -2.299915508705695e-23,
   2.161188627117592e-25,  -1.782369004891347e-27,   1.017973068458935e-02,  -2.301229791709961e-04,   3.880791192590255e-06,  -5.776687184261330e-08,   7.988187487850680e-10,
  -1.048642734471353e-11,   1.320007760774993e-13,  -1.600524436915356e-15,   1.870812094630391e-17,  -2.103574681495666e-19,   2.262034161071374e-21,  -2.299956271049465e-23,
   2.161217828861301e-25,  -1.782369990475378e-27,   9.023181676987349e-02,  -1.953559329858683e-03,   3.017695249846360e-05,  -3.848531380157532e-07,   4.100253924179719e-09,
  -3.392229854053134e-11,   1.433649039246076e-13,   1.786134781459082e-15,  -5.788974730724484e-17,   9.447336507266082e-19,  -1.100675373780173e-20,   8.410044562504338e-23,
  -4.271585488699859e-27,  -1.414885459549324e-26,   9.023465048585444e-02,  -1.953667681496447e-03,   3.017926001356794e-05,  -3.848849100641669e-07,   4.100453720775410e-09,
  -3.391873117497699e-11,   1.432119847214524e-13,   1.789334431127448e-15,  -5.793617812930135e-17,   9.451631559355370e-19,  -1.100665426887532e-20,   8.399451114572817e-23,
  -1.559754982525466e-27,  -1.419360755944563e-26,   9.023965079836833e-02,  -1.953858876928394e-03,   3.018333175127508e-05,  -3.849409696095531e-07,   4.100806089809180e-09,
  -3.391243137537652e-11,   1.429420572907556e-13,   1.794981438851358e-15,  -5.801810559445613e-17,   9.459205780285624e-19,  -1.100646507343539e-20,   8.380732174263131e-23,
   3.228858143405155e-27,  -1.427259603762201e-26,   9.024569752993340e-02,  -1.954090084870394e-03,   3.018825549513080e-05,  -3.850087527466597e-07,   4.101231879397380e-09,
  -3.390480484721000e-11,   1.426154891997482e-13,   1.801811864492729e-15,  -5.811717235984657e-17,   9.468356986524597e-19,  -1.100621295691948e-20,   8.358051608575074e-23,
   9.025343508226814e-27,  -1.436814573674013e-26,   9.025156790669045e-02,  -1.954314550504959e-03,   3.019303554280176e-05,  -3.850745505551769e-07,   4.101644915546826e-09,
  -3.389739198826682e-11,   1.422982856199373e-13,   1.808444820510498e-15,  -5.821334378112803e-17,   9.477232827017194e-19,  -1.100594375024116e-20,   8.335986130538959e-23,
   1.465879670544219e-26,  -1.446094127834981e-26,   9.025629723115304e-02,  -1.954495386391351e-03,   3.019688640332963e-05,  -3.851275529096645e-07,   4.101977427755479e-09,
  -3.389141372308771e-11,   1.420426237720466e-13,   1.813789745384770e-15,  -5.829081756817545e-17,   9.484377355483395e-19,  -1.100570934699232e-20,   8.318176371636333e-23,
   1.920156355861812e-26,  -1.453572296535838e-26,   9.025942239481767e-02,  -1.954614884072227e-03,   3.019943104028327e-05,  -3.851625742045006e-07,   4.102197036027508e-09,
  -3.388746017835551e-11,   1.418736249081632e-13,   1.817322311523417e-15,  -5.834201053201665e-17,   9.489095522707795e-19,  -1.100554586803334e-20,   8.306391302464882e-23,
   2.220556026986026e-26,  -1.458515045727823e-26,   9.026102735000774e-02,  -1.954676253255784e-03,   3.020073785071340e-05,  -3.851805587839611e-07,   4.102309781398141e-09,
  -3.388542885003001e-11,   1.417868167098329e-13,   1.819136680502339e-15,  -5.836830046250203e-17,   9.491517657749994e-19,  -1.100545925644961e-20,   8.300333940958704e-23,
   2.374894186400673e-26,  -1.461053787776733e-26,   9.026158597479050e-02,  -1.954697613586064e-03,   3.020119270085225e-05,  -3.851868183969626e-07,   4.102349018045899e-09,
  -3.388472166935926e-11,   1.417565992655064e-13,   1.819768224411979e-15,  -5.837745089647530e-17,   9.492360565541038e-19,  -1.100542868736241e-20,   8.298224798546552e-23,
   2.428623908621118e-26,  -1.461937484412618e-26,   9.026167462110786e-02,  -1.954701003186931e-03,   3.020126487943797e-05,  -3.851878117073216e-07,   4.102355244104635e-09,
  -3.388460944201370e-11,   1.417518040281785e-13,   1.819868443449709e-15,  -5.837890294350924e-17,   9.492494316823035e-19,  -1.100542381638010e-20,   8.297890067656396e-23,
   2.437150593577649e-26,  -1.462077717945321e-26,   2.433188313138246e-01,  -4.829394956359542e-03,   6.167280640183601e-05,  -5.210190879212253e-07,   1.267670204424740e-09,
   4.770560043918393e-11,  -9.804897978866176e-13,   9.236866747887771e-15,   2.816244132779448e-18,  -1.671346593201535e-18,   2.972310619166852e-20,  -2.318450464377027e-22,
  -1.400671093121610e-24,   7.141214207056173e-26,   2.433246145437120e-01,  -4.829541334589531e-03,   6.167351168277576e-05,  -5.209742119617747e-07,   1.266291515341453e-09,
   4.772369520675937e-11,  -9.804798224940547e-13,   9.231195415616738e-15,   2.941344094379898e-18,  -1.672521590843800e-18,   2.971402266753435e-20,  -2.313198958697139e-22,
  -1.409680770857661e-24,   7.146609214010521e-26,   2.433348191968099e-01,  -4.829799610995405e-03,   6.167475553164366e-05,  -5.208950138603323e-07,   1.263858809148805e-09,
   4.775561461673498e-11,  -9.804619539560520e-13,   9.221185051442196e-15,   3.162053426592244e-18,  -1.674592688241881e-18,   2.969794942041056e-20,  -2.303929431668398e-22,
  -1.425569717987931e-24,   7.156095521488752e-26,   2.433471588626744e-01,  -4.830111904048238e-03,   6.167625853202699e-05,  -5.207992232041164e-07,   1.260917176152405e-09,
   4.779419640207955e-11,  -9.804398922576690e-13,   9.209074944381413e-15,   3.428883662288347e-18,  -1.677093321713135e-18,   2.967843639470307e-20,  -2.292715241525322e-22,
  -1.444767823109114e-24,   7.167509736698533e-26,   2.433591380912233e-01,  -4.830415054371149e-03,   6.167771649310257e-05,  -5.207062067261431e-07,   1.258061512355672e-09,
   4.783163468898766e-11,  -9.804179988652740e-13,   9.197312941594287e-15,   3.687861312889647e-18,  -1.679516955204322e-18,   2.965941280476100e-20,  -2.281823084286908e-22,
  -1.463389293880525e-24,   7.178531045629658e-26,   2.433687884696605e-01,  -4.830659255167230e-03,   6.167889020104360e-05,  -5.206312562631626e-07,   1.255761043114908e-09,
   4.786178284525045e-11,  -9.804000206237456e-13,   9.187833530132974e-15,   3.896449746196512e-18,  -1.681466580315209e-18,   2.964402986683940e-20,  -2.273044492718655e-22,
  -1.478379225331880e-24,   7.187367093974005e-26,   2.433751653009547e-01,  -4.830820612257919e-03,   6.167966537143977e-05,  -5.205817217177064e-07,   1.254240942116274e-09,
   4.788169850892454e-11,  -9.803879738737745e-13,   9.181567700405369e-15,   4.034261352616419e-18,  -1.682753475555365e-18,   2.963383681532144e-20,  -2.267241796655230e-22,
  -1.488278771630528e-24,   7.193184949499008e-26,   2.433784401191903e-01,  -4.830903474851276e-03,   6.168006333640187e-05,  -5.205562806946614e-07,   1.253460300038678e-09,
   4.789192439181968e-11,  -9.803817356336468e-13,   9.178349277750319e-15,   4.105028039629774e-18,  -1.683413930278015e-18,   2.962859345210187e-20,  -2.264261229744690e-22,
  -1.493360949211837e-24,   7.196166248872040e-26,   2.433795799512980e-01,  -4.830932315618366e-03,   6.168020183230864e-05,  -5.205474252895590e-07,   1.253188590817192e-09,
   4.789548332325833e-11,  -9.803795561334035e-13,   9.177228977710021e-15,   4.129658050593319e-18,  -1.683643739518388e-18,   2.962676705974200e-20,  -2.263223719939395e-22,
  -1.495129574762616e-24,   7.197202890881684e-26,   2.433797608270329e-01,  -4.830936892235835e-03,   6.168022380877864e-05,  -5.205460200385975e-07,   1.253145474324923e-09,
   4.789604806333466e-11,  -9.803792098863351e-13,   9.177051196844185e-15,   4.133566447465119e-18,  -1.683680203848024e-18,   2.962647717036017e-20,  -2.263059076857228e-22,
  -1.495410218320892e-24,   7.197367342957794e-26,   4.562164517088004e-01,  -7.920313337885591e-03,   7.195769102181970e-05,  -1.041034208839498e-07,  -7.295155352491163e-09,
   9.862386948908868e-11,  -1.684149027507705e-14,  -1.679626285935073e-14,   2.141642624746288e-16,   4.685775172480653e-19,  -4.849507755858987e-20,   5.422425291008028e-22,
   2.914466559304466e-24,  -1.546100662199617e-25,   4.562231894913472e-01,  -7.920342292281515e-03,   7.195358741209159e-05,  -1.040112389628249e-07,  -7.295172443851766e-09,
   9.859082836493884e-11,  -1.628352127439749e-14,  -1.679460983950457e-14,   2.139602747771487e-16,   4.713298152163433e-19,  -4.847648729980459e-20,   5.411198480043703e-22,
   2.926546035992771e-24,  -1.544673976829626e-25,   4.562350781020447e-01,  -7.920393361739638e-03,   7.194634652179493e-05,  -1.038486076857924e-07,  -7.295201965564890e-09,
   9.853252946171573e-11,  -1.529941115147905e-14,  -1.679168554000062e-14,   2.136003995204120e-16,   4.761815901421002e-19,  -4.844362417020141e-20,   5.391397127886591e-22,
   2.947820625863731e-24,  -1.542152782071187e-25,   4.562494534041118e-01,  -7.920455079621825e-03,   7.193759074921096e-05,  -1.036519951285365e-07,  -7.295236578997229e-09,
   9.846203838309876e-11,  -1.411015621875787e-14,  -1.678813663242066e-14,   2.131653441981791e-16,   4.820403999636435e-19,  -4.840378299971893e-20,   5.367467685047520e-22,
   2.973478202739546e-24,  -1.539097686868332e-25,   4.562634081403578e-01,  -7.920514956734443e-03,   7.192909078582605e-05,  -1.034611720054917e-07,  -7.295269045834127e-09,
   9.839361166874840e-11,  -1.295642453169089e-14,  -1.678467800758270e-14,   2.127431150612798e-16,   4.877196480919258e-19,  -4.836499848525358e-20,   5.344252666667488e-22,
   2.998315097978745e-24,  -1.536125130088581e-25,   4.562746494944839e-01,  -7.920563166064635e-03,   7.192224331821122e-05,  -1.033074795801503e-07,  -7.295294387574611e-09,
   9.833849144734849e-11,  -1.202754950209654e-14,  -1.678188218639956e-14,   2.124030553111627e-16,   4.922887723312261e-19,  -4.833367735916966e-20,   5.325561904732263e-22,
   3.018272517053632e-24,  -1.533725674057581e-25,   4.562820773852234e-01,  -7.920595008765085e-03,   7.191771862992015e-05,  -1.032059381293564e-07,  -7.295310734943078e-09,
   9.830207067907642e-11,  -1.141403773243141e-14,  -1.678003006133527e-14,   2.121783903567639e-16,   4.953050293130976e-19,  -4.831294335083991e-20,   5.313216751576403e-22,
   3.031435136021906e-24,  -1.532137810347976e-25,   4.562858919019739e-01,  -7.920611357443944e-03,   7.191539498486322e-05,  -1.031537966114448e-07,  -7.295319007039443e-09,
   9.828336739583001e-11,  -1.109905428800131e-14,  -1.677907745482249e-14,   2.120630266796184e-16,   4.968531128986761e-19,  -4.830228383837403e-20,   5.306878586438881e-22,
   3.038187076960812e-24,  -1.531321642085458e-25,   4.562872195698206e-01,  -7.920617047103186e-03,   7.191458621874475e-05,  -1.031356490548386e-07,  -7.295321866629435e-09,
   9.827685763028364e-11,  -1.098943482049474e-14,  -1.677874566035465e-14,   2.120228752905645e-16,   4.973917929187145e-19,  -4.829857185051895e-20,   5.304672794669348e-22,
   3.040535927267857e-24,  -1.531037452051306e-25,   4.562874302519653e-01,  -7.920617949942980e-03,   7.191445787869189e-05,  -1.031327693243862e-07,  -7.295322319477081e-09,
   9.827582462410904e-11,  -1.097204035706557e-14,  -1.677869299817481e-14,   2.120165039128363e-16,   4.974772671524574e-19,  -4.829798272150819e-20,   5.304322778460103e-22,
   3.040908599334023e-24,  -1.530992349540279e-25,   7.109900089067073e-01,  -1.024842169060249e-02,   4.850930836933467e-05,   5.850783520547994e-07,  -9.217447504604269e-09,
  -3.166139902720267e-11,   1.724295056364237e-12,  -5.239101009494367e-15,  -2.948496073423405e-16,   2.989365049768293e-18,   4.092326750148840e-20,  -9.135649309679055e-22,
  -2.663412405101771e-24,   2.216939827737438e-25,   7.109945462649460e-01,  -1.024825724250892e-02,   4.850413719599612e-05,   5.850485843173807e-07,  -9.215031824899164e-09,
  -3.167155520136484e-11,   1.723524630391204e-12,  -5.229132854847610e-15,  -2.946775056207892e-16,   2.984716501327488e-18,   4.090643487159785e-20,  -9.119674948755006e-22,
  -2.671084284514602e-24,   2.212635396048035e-25,   7.110025521125418e-01,  -1.024796707807775e-02,   4.849501368173271e-05,   5.849960509833460e-07,  -9.210770199412452e-09,
  -3.168946003515866e-11,   1.722165568579065e-12,  -5.211556598468715e-15,  -2.943738874630353e-16,   2.976520736644833e-18,   4.087669527787470e-20,  -9.091513436434668e-22,
  -2.684581581332344e-24,   2.205046904918539e-25,   7.110122321999826e-01,  -1.024761621977199e-02,   4.848398331028728e-05,   5.849325140054836e-07,  -9.205618495427472e-09,
  -3.171108366259087e-11,   1.720522802088366e-12,  -5.190324859384577e-15,  -2.940068481901699e-16,   2.966621699722132e-18,   4.084066892522222e-20,  -9.057503685035165e-22,
  -2.700834804606051e-24,   2.195882319796650e-25,   7.110216287607999e-01,  -1.024727562477685e-02,   4.847327718444779e-05,   5.848708196900636e-07,  -9.200618879837446e-09,
  -3.173204715629244e-11,   1.718928687801094e-12,  -5.169736118612969e-15,  -2.936506366524707e-16,   2.957023782529626e-18,   4.080562735824335e-20,  -9.024533072689317e-22,
  -2.716542230785676e-24,   2.186997536716973e-25,   7.110291980061391e-01,  -1.024700125460218e-02,   4.846465387838867e-05,   5.848211097309974e-07,  -9.196592378790825e-09,
  -3.174891477436736e-11,   1.717644959279817e-12,  -5.153166324233039e-15,  -2.933637517471549e-16,   2.949300342488436e-18,   4.077734986645160e-20,  -8.998004927417915e-22,
  -2.729145207297394e-24,   2.179848692614614e-25,   7.110341993829169e-01,  -1.024681995995044e-02,   4.845895644148391e-05,   5.847882574700299e-07,  -9.193932288989228e-09,
  -3.176005066160874e-11,   1.716796924052163e-12,  -5.142225240135182e-15,  -2.931742198104852e-16,   2.944200998510838e-18,   4.075864092522093e-20,  -8.980491529609803e-22,
  -2.737448232585889e-24,   2.175129083841002e-25,   7.110367677532187e-01,  -1.024672685779338e-02,   4.845603074842576e-05,   5.847713847765720e-07,  -9.192566375777310e-09,
  -3.176576640134031e-11,   1.716361488419219e-12,  -5.136608924753550e-15,  -2.930768973864519e-16,   2.941583529692198e-18,   4.074902567647755e-20,  -8.971502485610800e-22,
  -2.741704572647130e-24,   2.172706643722907e-25,   7.110376616859267e-01,  -1.024669445294536e-02,   4.845501246813663e-05,   5.847655118446575e-07,  -9.192090984266449e-09,
  -3.176775532805343e-11,   1.716209942367609e-12,  -5.134654505476090e-15,  -2.930430252241790e-16,   2.940672700750052e-18,   4.074567783791842e-20,  -8.968374550208326e-22,
  -2.743184811901498e-24,   2.171863698958723e-25,   7.110378035401618e-01,  -1.024668931075226e-02,   4.845485088269148e-05,   5.847645798800225e-07,  -9.192015547466946e-09,
  -3.176807092012577e-11,   1.716185894633163e-12,  -5.134344384600673e-15,  -2.930376502639223e-16,   2.940528174474472e-18,   4.074514652684526e-20,  -8.967878227138671e-22,
  -2.743419647635042e-24,   2.171729945093714e-25,   9.868393453083460e-01,  -1.111228390948587e-02,   1.038121699651180e-06,   9.152569917280193e-07,  -1.032423893596340e-10,
  -1.359048415947260e-10,   7.081594173655890e-15,   2.457370566926643e-14,   8.548698114311864e-19,  -4.930957291528414e-18,  -6.995226521899036e-22,   1.055437509718041e-21,
   2.697621534539578e-25,  -2.363075472994061e-25,   9.868394425155994e-01,  -1.111202694123042e-02,   1.038063682292367e-06,   9.151299854870479e-07,  -1.032324051484607e-10,
  -1.358567243800580e-10,   7.083778494982882e-15,   2.455720360541137e-14,   8.519711010345378e-19,  -4.925581136359610e-18,  -6.978877874418980e-22,   1.053738455175919e-21,
   2.690192343939104e-25,  -2.357812133638915e-25,   9.868396140349146e-01,  -1.111157354566495e-02,   1.037961314320439e-06,   9.149059175672689e-07,  -1.032147853766346e-10,
  -1.357718471409363e-10,   7.087626609839917e-15,   2.452810015687599e-14,   8.468618581615226e-19,  -4.916101918798082e-18,  -6.950067572758139e-22,   1.050743558546199e-21,
   2.677104048321131e-25,  -2.348537670209093e-25,   9.868398214303793e-01,  -1.111102534428281e-02,   1.037837537668706e-06,   9.146350346206119e-07,  -1.031934751464598e-10,
  -1.356692575776523e-10,   7.092269305647998e-15,   2.449293301205393e-14,   8.406932080271662e-19,  -4.904651632565237e-18,  -6.915293111013456e-22,   1.047127398302701e-21,
   2.661312665416308e-25,  -2.337344656467723e-25,   9.868400227584280e-01,  -1.111049321157328e-02,   1.037717385600204e-06,   9.143721314470023e-07,  -1.031727831373276e-10,
  -1.355697124049580e-10,   7.096765384110428e-15,   2.445881957815523e-14,   8.347147274614938e-19,  -4.893548536750326e-18,  -6.881600823503535e-22,   1.043622436829158e-21,
   2.646019383835379e-25,  -2.326501431419428e-25,   9.868401849400411e-01,  -1.111006456942226e-02,   1.037620598505345e-06,   9.141603868455479e-07,  -1.031561107708811e-10,
  -1.354895537688900e-10,   7.100379513590816e-15,   2.443135701513420e-14,   8.299056541476561e-19,  -4.884613078428343e-18,  -6.854506093278197e-22,   1.040802853259698e-21,
   2.633725580949395e-25,  -2.317782552560650e-25,   9.868402921039984e-01,  -1.110978134845833e-02,   1.037556646181355e-06,   9.140204926829069e-07,  -1.031450924260951e-10,
  -1.354366028453948e-10,   7.102763823942352e-15,   2.441321943097724e-14,   8.267313836799426e-19,  -4.878713115265963e-18,  -6.836625530756279e-22,   1.038941663535624e-21,
   2.625614897905698e-25,  -2.312029235076837e-25,   9.868403471369633e-01,  -1.110963590654922e-02,   1.037523804488785e-06,   9.139486574170278e-07,  -1.031394335023175e-10,
  -1.354094151064500e-10,   7.103987093837857e-15,   2.440390775418847e-14,   8.251023193107441e-19,  -4.875684570751663e-18,  -6.827450161027080e-22,   1.037986453389722e-21,
   2.621453642123949e-25,  -2.309077091590464e-25,   9.868403662915547e-01,  -1.110958528505352e-02,   1.037512373777958e-06,   9.139236556219946e-07,  -1.031374637862439e-10,
  -1.353999529757743e-10,   7.104412675122752e-15,   2.440066719193285e-14,   8.245354796838804e-19,  -4.874630675964082e-18,  -6.824257728116606e-22,   1.037654079209405e-21,
   2.620005910326533e-25,  -2.308049962515737e-25,   9.868403693311181e-01,  -1.110957725216171e-02,   1.037510559888271e-06,   9.139196882349587e-07,  -1.031371512158312e-10,
  -1.353984515044418e-10,   7.104480200039920e-15,   2.440015298079464e-14,   8.244455381653689e-19,  -4.874463447717314e-18,  -6.823751187021496e-22,   1.037601340535533e-21,
   2.619776205195972e-25,  -2.307886989859478e-25,   1.262018768268615e+00,  -1.028797565835494e-02,  -4.588656998083618e-05,   5.916264065929809e-07,   8.777069730664115e-09,
  -3.363923768792414e-11,  -1.633362362527882e-12,  -4.470984446275880e-15,   2.755227945735750e-16,   2.700562403255182e-18,  -3.750751095160859e-20,  -8.184903279625436e-22,
   2.340371948996052e-24,   1.944430595714382e-25,   1.262014476295809e+00,  -1.028780937510878e-02,  -4.588164580139485e-05,   5.915947972063352e-07,   8.774781328809212e-09,
  -3.364789691182064e-11,  -1.632642373281209e-12,  -4.461978447448430e-15,   2.753650375105199e-16,   2.696396487822512e-18,  -3.749271130559137e-20,  -8.170886260855988e-22,
   2.347298698611841e-24,   1.940769182238632e-25,   1.262006903415937e+00,  -1.028751597294087e-02,  -4.587295805368955e-05,   5.915390153894829e-07,   8.770744229547678e-09,
  -3.366316188713784e-11,  -1.631372277293945e-12,  -4.446098611456093e-15,   2.750867237260685e-16,   2.689051519776845e-18,  -3.746656263478822e-20,  -8.146174704364991e-22,
   2.359486412361817e-24,   1.934314004646292e-25,   1.261997746845754e+00,  -1.028716120024330e-02,  -4.586245451684453e-05,   5.914715522480337e-07,   8.765863926980097e-09,
  -3.368159598333854e-11,  -1.629837037111299e-12,  -4.426915955078435e-15,   2.747502708237110e-16,   2.680179883447761e-18,  -3.743488473992750e-20,  -8.116330193533545e-22,
   2.374164940998356e-24,   1.926517615372721e-25,   1.261988858472986e+00,  -1.028681680597186e-02,  -4.585225972929015e-05,   5.914060485078788e-07,   8.761127680496579e-09,
  -3.369946587068539e-11,  -1.628347252938318e-12,  -4.408314077296455e-15,   2.744237394822304e-16,   2.671577892887902e-18,  -3.740407112932079e-20,  -8.087396342569970e-22,
   2.388352945382390e-24,   1.918958731219650e-25,   1.261981698593372e+00,  -1.028653937568503e-02,  -4.584404827647285e-05,   5.913532711773448e-07,   8.757313272620597e-09,
  -3.371384327828803e-11,  -1.627147532314492e-12,  -4.393343190772072e-15,   2.741607555767696e-16,   2.664655716093850e-18,  -3.737920430039520e-20,  -8.064115305205288e-22,
   2.399738518552342e-24,   1.912876351661887e-25,   1.261976967706443e+00,  -1.028635605922780e-02,  -4.583862294851449e-05,   5.913183927623870e-07,   8.754793294201308e-09,
  -3.372333463725914e-11,  -1.626354988875197e-12,  -4.383457812951129e-15,   2.739870125949624e-16,   2.660085322654901e-18,  -3.736275134756305e-20,  -8.048745163451026e-22,
   2.407240342243957e-24,   1.908860630220224e-25,   1.261974538241994e+00,  -1.028626191885791e-02,  -4.583583698518352e-05,   5.913004797615533e-07,   8.753499323754782e-09,
  -3.372820612933381e-11,  -1.625948045014273e-12,  -4.378383398683987e-15,   2.738977971933062e-16,   2.657739337627366e-18,  -3.735429536151390e-20,  -8.040856049903058e-22,
   2.411086226695508e-24,   1.906799418471225e-25,   1.261973692656163e+00,  -1.028622915266332e-02,  -4.583486733731675e-05,   5.912942447760922e-07,   8.753048970809942e-09,
  -3.372990125507967e-11,  -1.625806414842992e-12,  -4.376617552534252e-15,   2.738667465376151e-16,   2.656922976019081e-18,  -3.735135112701971e-20,  -8.038110838536190e-22,
   2.412423762163436e-24,   1.906082162526509e-25,   1.261973558473884e+00,  -1.028622395313010e-02,  -4.583471346908234e-05,   5.912932553602054e-07,   8.752977507201896e-09,
  -3.373017022722348e-11,  -1.625783940577479e-12,  -4.376337353693834e-15,   2.738618193013013e-16,   2.656793439217605e-18,  -3.735088386767089e-20,  -8.037675242954421e-22,
   2.412635960319623e-24,   1.905968351846334e-25,   1.515598119447127e+00,  -8.064024517434638e-03,  -6.926829734253399e-05,  -6.006479745112277e-08,   7.176064316742499e-09,
   8.805078908530823e-11,  -7.855468681483953e-14,  -1.552923067398910e-14,  -1.759465943959305e-16,   6.605195697141636e-19,   4.179016248663241e-20,   4.052573169683977e-22,
  -3.136156391899746e-24,  -1.238416083175941e-25,   1.515591633658744e+00,  -8.064041120827323e-03,  -6.926426147132173e-05,  -5.998250670689095e-08,   7.175948436051461e-09,
   8.802025240069642e-11,  -7.901291970518081e-14,  -1.552694800142213e-14,  -1.757709302305281e-16,   6.625742658878912e-19,   4.177038569814067e-20,   4.043590191181611e-22,
  -3.144224542056284e-24,  -1.237097734524733e-25,   1.515580189690468e+00,  -8.064070399003620e-03,  -6.925714016723642e-05,  -5.983732665543575e-08,   7.175743440280696e-09,
   8.796637361939896e-11,  -7.982110435805133e-14,  -1.552291457749551e-14,  -1.754610361997436e-16,   6.661960514430417e-19,   4.173544898265477e-20,   4.027747451068729e-22,
  -3.158431425557263e-24,  -1.234769307763528e-25,   1.515566352045821e+00,  -8.064105770484241e-03,  -6.924852910275771e-05,  -5.966181304656008e-08,   7.175494666645137e-09,
   8.790122910066910e-11,  -8.079773143722229e-14,  -1.551802775584966e-14,  -1.750864253265046e-16,   6.705691475088312e-19,   4.169313458593708e-20,   4.008603662746091e-22,
  -3.175560284066865e-24,  -1.231950043287900e-25,   1.515552919248718e+00,  -8.064140074996786e-03,  -6.924016972750108e-05,  -5.949146900283463e-08,   7.175252229294759e-09,
   8.783799451295709e-11,  -8.174515566171993e-14,  -1.551327370939663e-14,  -1.747228814832924e-16,   6.748077683484147e-19,   4.165198484959233e-20,   3.990033271315345e-22,
  -3.192136097793685e-24,  -1.229209283099898e-25,   1.515542098355260e+00,  -8.064167686260490e-03,  -6.923343559320709e-05,  -5.935427181050359e-08,   7.175056257255273e-09,
   8.778705827392162e-11,  -8.250790945248399e-14,  -1.550943674948368e-14,  -1.744301027219668e-16,   6.782175440168987e-19,   4.161878390950231e-20,   3.975083292231038e-22,
  -3.205451710567906e-24,  -1.226998601339773e-25,   1.515534948294149e+00,  -8.064185919539266e-03,  -6.922898583141664e-05,  -5.926362891754495e-08,   7.174926435623528e-09,
   8.775340282903605e-11,  -8.301168915128722e-14,  -1.550689785062095e-14,  -1.742366825747416e-16,   6.804683125944769e-19,   4.159682026431226e-20,   3.965209554289779e-22,
  -3.214232009406071e-24,  -1.225536474279746e-25,   1.515531276455188e+00,  -8.064195279566089e-03,  -6.922670067640908e-05,  -5.921708395993796e-08,   7.174859664960883e-09,
   8.773611986397856e-11,  -8.327033164336777e-14,  -1.550559292144144e-14,  -1.741373653310464e-16,   6.816234632342140e-19,   4.158553314079540e-20,   3.960140446423247e-22,
  -3.218735418756065e-24,  -1.224785186048269e-25,   1.515529998447491e+00,  -8.064198536830589e-03,  -6.922590530896817e-05,  -5.920088427839064e-08,   7.174836408736116e-09,
   8.773010448378704e-11,  -8.336034299177830e-14,  -1.550513855650284e-14,  -1.741027991659915e-16,   6.820254083137088e-19,   4.158160332244390e-20,   3.958376340488872e-22,
  -3.220301965324393e-24,  -1.224523627141643e-25,   1.515529795645720e+00,  -8.064199053686140e-03,  -6.922577909518937e-05,  -5.919831364608213e-08,   7.174832717530007e-09,
   8.772914993121196e-11,  -8.337462600530829e-14,  -1.550506644686189e-14,  -1.740973140918860e-16,   6.820891859707883e-19,   4.158097965593765e-20,   3.958096412732772e-22,
  -3.220550511669741e-24,  -1.224482118206197e-25,   1.728931900044767e+00,  -5.123273054906672e-03,  -6.155287901331234e-05,  -4.703805985389611e-07,  -4.832989414640367e-10,
   5.102802027909047e-11,   8.777151313571443e-13,   6.660528383971293e-15,  -2.870219998870369e-17,  -1.599720922557524e-18,  -2.269511193177180e-20,  -1.130436767509508e-22,
   2.125837641661145e-24,   5.884624234706924e-26,   1.728926128942083e+00,  -5.123405180277678e-03,  -6.155314390700640e-05,  -4.703326504235695e-07,  -4.820655743089644e-10,
   5.104104702334525e-11,   8.776378210794522e-13,   6.655114645098932e-15,  -2.879751240489409e-17,  -1.600287050721828e-18,  -2.268170337635321e-20,  -1.126131624283850e-22,
   2.131353444732109e-24,   5.885023390234771e-26,   1.728915945721093e+00,  -5.123638306594212e-03,  -6.155361075228441e-05,  -4.702480353160712e-07,  -4.798893676893153e-10,
   5.106402424641915e-11,   8.775012027296182e-13,   6.645560476474829e-15,  -2.896564645199342e-17,  -1.601284187860106e-18,  -2.265801612424982e-20,  -1.118534924586831e-22,
   2.141076927081079e-24,   5.885704963156745e-26,   1.728903632028224e+00,  -5.123920186705114e-03,  -6.155417430526384e-05,  -4.701457009420934e-07,  -4.772580275230718e-10,
   5.109179376173830e-11,   8.773356560437189e-13,   6.634004849180810e-15,  -2.916887708032940e-17,  -1.602486859158932e-18,  -2.262932614056337e-20,  -1.109348570873607e-22,
   2.152818901868913e-24,   5.886490360643156e-26,   1.728891678073561e+00,  -5.124193811430100e-03,  -6.155472038609354e-05,  -4.700463388304347e-07,  -4.747037275497128e-10,
   5.111873643819314e-11,   8.771745836127649e-13,   6.622784102195949e-15,  -2.936608719459284e-17,  -1.603651168754763e-18,  -2.260142511347214e-20,  -1.100430270036432e-22,
   2.164201286119456e-24,   5.887212228316583e-26,   1.728882048098246e+00,  -5.124414225900290e-03,  -6.155515958047437e-05,  -4.699662813469801e-07,  -4.726461311403037e-10,
   5.114043000913399e-11,   8.770445660350787e-13,   6.613742851301735e-15,  -2.952489781293866e-17,  -1.604586812192596e-18,  -2.257891312323910e-20,  -1.093245562074518e-22,
   2.173358939485492e-24,   5.887764688568506e-26,   1.728875684769930e+00,  -5.124559864975914e-03,  -6.155544943917216e-05,  -4.699133745918020e-07,  -4.712865641739259e-10,
   5.115475929946441e-11,   8.769585255937626e-13,   6.607767593847191e-15,  -2.962980798940380e-17,  -1.605203938028909e-18,  -2.256402033593525e-20,  -1.088497920505918e-22,
   2.179404349005930e-24,   5.888115516693843e-26,   1.728872416892601e+00,  -5.124634655482081e-03,  -6.155559818627768e-05,  -4.698862025256145e-07,  -4.705883788412490e-10,
   5.116211639476098e-11,   8.769143003956279e-13,   6.604698716634658e-15,  -2.968367539548244e-17,  -1.605520511997261e-18,  -2.255636684011317e-20,  -1.086059744687567e-22,
   2.182507160073211e-24,   5.888291284548952e-26,   1.728871279477371e+00,  -5.124660686663914e-03,  -6.155564994168457e-05,  -4.698767447341597e-07,  -4.703453718068468e-10,
   5.116467683153700e-11,   8.768989011519398e-13,   6.603630518620512e-15,  -2.970242300791603e-17,  -1.605630642796650e-18,  -2.255370212137458e-20,  -1.085211109804199e-22,
   2.183586835882921e-24,   5.888351761885904e-26,   1.728871098985211e+00,  -5.124664817437881e-03,  -6.155565815372950e-05,  -4.698752438984328e-07,  -4.703068100684949e-10,
   5.116508312488557e-11,   8.768964572069476e-13,   6.603461008067044e-15,  -2.970539792784317e-17,  -1.605648116394951e-18,  -2.255327922688916e-20,  -1.085076442877811e-22,
   2.183758151985671e-24,   5.888361325563653e-26,   1.886792499503576e+00,  -2.326784746559611e-03,  -3.378316776133364e-05,  -3.978216255101128e-07,  -3.772785935304043e-09,
  -2.478279772871977e-11,  -4.544437550172416e-15,   3.165921520891494e-15,   6.276883994809226e-17,   7.943436972010685e-19,   6.668401023040221e-21,   1.405786030039921e-23,
  -7.631259948881186e-25,  -1.821904087853504e-26,   1.886789328077589e+00,  -2.326896715311921e-03,  -3.378528997322381e-05,  -3.978448065316003e-07,  -3.772790369648435e-09,
  -2.477652215831089e-11,  -4.379092347366374e-15,   3.168604157661431e-15,   6.279681657526972e-17,   7.944109396986473e-19,   6.663576577195434e-21,   1.392331205099449e-23,
  -7.653395544419766e-25,  -1.824303028778525e-26,   1.886783731884703e+00,  -2.327094291231126e-03,  -3.378903465111320e-05,  -3.978857050129744e-07,  -3.772798004855079e-09,
  -2.476544452075677e-11,  -4.087278520232076e-15,   3.173337893161294e-15,   6.284616513735721e-17,   7.945290247594738e-19,   6.655052624312835e-21,   1.368575725720126e-23,
  -7.692460453213792e-25,  -1.828533544246984e-26,   1.886776964632522e+00,  -2.327333211170123e-03,  -3.379356275833601e-05,  -3.979351517142987e-07,  -3.772806914671385e-09,
  -2.475204199980673e-11,  -3.734312497332625e-15,   3.179062283779378e-15,   6.290580955278710e-17,   7.946708500419500e-19,   6.644726368727463e-21,   1.339826094483505e-23,
  -7.739708863241743e-25,  -1.833644936216206e-26,   1.886770394812270e+00,  -2.327565159962710e-03,  -3.379795856920771e-05,  -3.979831451478451e-07,  -3.772815226119181e-09,
  -2.473902339536938e-11,  -3.391552802316654e-15,   3.184619743309139e-15,   6.296368155243648e-17,   7.948075211039222e-19,   6.634681918485688e-21,   1.311891066784734e-23,
  -7.785587959667856e-25,  -1.838602585115674e-26,   1.886765102043462e+00,  -2.327752021664995e-03,  -3.380149977920681e-05,  -3.980218018927041e-07,  -3.772821679461508e-09,
  -2.472853028187527e-11,  -3.115353843379112e-15,   3.189096988904910e-15,   6.301028113168104e-17,   7.949168971708951e-19,   6.626575979740075e-21,   1.289368793738260e-23,
  -7.822555520813835e-25,  -1.842593240465390e-26,   1.886761604574743e+00,  -2.327875499864234e-03,  -3.380383974861189e-05,  -3.980473425734190e-07,  -3.772825825085234e-09,
  -2.472159392880693e-11,  -2.932809187949459e-15,   3.192055584514428e-15,   6.304106283994304e-17,   7.949888161119337e-19,   6.621212736844811e-21,   1.274477580156966e-23,
  -7.846986908080425e-25,  -1.845228642873984e-26,   1.886759808425855e+00,  -2.327938912852955e-03,  -3.380504143514541e-05,  -3.980604580047281e-07,  -3.772827917370369e-09,
  -2.471803094750615e-11,  -2.839052238330902e-15,   3.193574999317029e-15,   6.305686748200585e-17,   7.950256401678094e-19,   6.618456295282414e-21,   1.266827478838562e-23,
  -7.859534791628734e-25,  -1.846581567575504e-26,   1.886759183254795e+00,  -2.327960984487606e-03,  -3.380545969319239e-05,  -3.980650228025799e-07,  -3.772828639767791e-09,
  -2.471679068676158e-11,  -2.806417437258376e-15,   3.194103851021605e-15,   6.306236791673898e-17,   7.950384396406870e-19,   6.617496546709891e-21,   1.264164353183568e-23,
  -7.863902387718941e-25,  -1.847052388843334e-26,   1.886759084048521e+00,  -2.327964486959797e-03,  -3.380552606498619e-05,  -3.980657471660993e-07,  -3.772828754124988e-09,
  -2.471659386817358e-11,  -2.801238656617229e-15,   3.194187772763095e-15,   6.306324073549361e-17,   7.950404699110085e-19,   6.617344231505616e-21,   1.263741731035322e-23,
  -7.864595474095886e-25,  -1.847127098058260e-26,   1.978204100245561e+00,  -4.687200667318467e-04,  -7.480015963508953e-06,  -1.045759068576251e-07,  -1.344987485692541e-09,
  -1.620810248169271e-11,  -1.840206371960640e-13,  -1.962738120174709e-15,  -1.942670295686124e-17,  -1.732854220946359e-19,  -1.290661976714194e-21,  -5.860781978113333e-24,
   3.882295756497134e-26,   1.605000986966657e-27,   1.978203397473726e+00,  -4.687495322919077e-04,  -7.480773981944364e-06,  -1.045911345001881e-07,  -1.345246868771628e-09,
  -1.621197593141919e-11,  -1.840717444515517e-13,  -1.963323731039311e-15,  -1.943213975474143e-17,  -1.733151740496030e-19,  -1.290409707955976e-21,  -5.848801381609141e-24,
   3.908239288074667e-26,   1.609413869040301e-27,   1.978202157363797e+00,  -4.688015282245466e-04,  -7.482111636180992e-06,  -1.046180068706339e-07,  -1.345704612776534e-09,
  -1.621881163221061e-11,  -1.841619356070976e-13,  -1.964357131929414e-15,  -1.944173219441083e-17,  -1.733676213691643e-19,  -1.289963265681130e-21,  -5.827635103719260e-24,
   3.954062209497164e-26,   1.617207255403689e-27,   1.978200657710772e+00,  -4.688644082102744e-04,  -7.483729344528586e-06,  -1.046505062681105e-07,  -1.346258221442711e-09,
  -1.622707903378310e-11,  -1.842710154924155e-13,  -1.965606869867088e-15,  -1.945332997869067e-17,  -1.734309550919177e-19,  -1.289421187554726e-21,  -5.801995697141152e-24,
   4.009548805531951e-26,   1.626642678312656e-27,   1.978199201770052e+00,  -4.689254572417016e-04,  -7.485299999924432e-06,  -1.046820613990994e-07,  -1.346795759595217e-09,
  -1.623510655883826e-11,  -1.843769290649060e-13,  -1.966820238780329e-15,  -1.946458733610632e-17,  -1.734923480757322e-19,  -1.288892604658763e-21,  -5.777058332864742e-24,
   4.063494951330421e-26,   1.635814553427301e-27,   1.978198028808964e+00,  -4.689746420115244e-04,  -7.486565451496321e-06,  -1.047074855847297e-07,  -1.347228868181357e-09,
  -1.624157462864000e-11,  -1.844622664976237e-13,  -1.967797816772872e-15,  -1.947365498859171e-17,  -1.735417406987582e-19,  -1.288465105115653e-21,  -5.756935364515272e-24,
   4.107011137656461e-26,   1.643211992500076e-27,   1.978197253700850e+00,  -4.690071446171059e-04,  -7.487401713787101e-06,  -1.047242872858557e-07,  -1.347515095266987e-09,
  -1.624584920153114e-11,  -1.845186632166101e-13,  -1.968443833672083e-15,  -1.947964617827643e-17,  -1.735743467252879e-19,  -1.288181797876076e-21,  -5.743621929571895e-24,
   4.135794209797229e-26,   1.648104348044518e-27,   1.978196855634513e+00,  -4.690238369363038e-04,  -7.487831197508331e-06,  -1.047329163361568e-07,  -1.347662097905195e-09,
  -1.624804458096634e-11,  -1.845476278765537e-13,  -1.968775609956381e-15,  -1.948272276941988e-17,  -1.735910816586402e-19,  -1.288036051363015e-21,  -5.736779727667395e-24,
   4.150584465776314e-26,   1.650618124430901e-27,   1.978196717082090e+00,  -4.690296469584939e-04,  -7.487980686915736e-06,  -1.047359198473371e-07,  -1.347713265324127e-09,
  -1.624880873181488e-11,  -1.845577096492962e-13,  -1.968891090228578e-15,  -1.948379357782913e-17,  -1.735969048413424e-19,  -1.287985282396722e-21,  -5.734397421964599e-24,
   4.155733746495645e-26,   1.651493277142299e-27,   1.978196695095644e+00,  -4.690305689341080e-04,  -7.488004408999887e-06,  -1.047363964675260e-07,  -1.347721384974488e-09,
  -1.624892999340397e-11,  -1.845593095047581e-13,  -1.968909415475936e-15,  -1.948396349907920e-17,  -1.735978288259753e-19,  -1.287977224135349e-21,  -5.734019344180275e-24,
   4.156550932739611e-26,   1.651632161786351e-27,   9.314006158168943e-03,  -2.015091963457767e-04,   3.254212952942977e-06,  -4.642858467153508e-08,   6.160620285677986e-10,
  -7.771994909257328e-12,   9.419598766677328e-14,  -1.102495908097789e-15,   1.248121980607045e-17,  -1.365774124646542e-19,   1.439306133852679e-21,  -1.450754479236636e-23,
   1.379642695136874e-25,  -1.205760924137182e-27,   9.314311937206741e-03,  -2.015222800926678e-04,   3.254560237270800e-06,  -4.643588922107052e-08,   6.161948805575106e-10,
  -7.774172811374932e-12,   9.422887686347692e-14,  -1.102958816294548e-15,   1.248731944767718e-17,  -1.366525610404258e-19,   1.440163370971794e-21,  -1.451638695772855e-23,
   1.380416507941853e-25,  -1.206216342580750e-27,   9.314851515696831e-03,  -2.015453682436637e-04,   3.255173086786812e-06,  -4.644877987608330e-08,   6.164293376383054e-10,
  -7.778016495879645e-12,   9.428692340353781e-14,  -1.103775831554853e-15,   1.249808530476734e-17,  -1.367851989790078e-19,   1.441676368515334e-21,  -1.453199179285708e-23,
   1.381781800294242e-25,  -1.207019010940616e-27,   9.315504025075210e-03,  -2.015732895367273e-04,   3.255914254746369e-06,  -4.646437022885136e-08,   6.167129098605611e-10,
  -7.782665585574739e-12,   9.435713613018053e-14,  -1.104764127246558e-15,   1.251110851404666e-17,  -1.369456494483249e-19,   1.443506564823456e-21,  -1.455086591805957e-23,
   1.383432533401932e-25,  -1.207988026882149e-27,   9.316137517329827e-03,  -2.016003980339354e-04,   3.256633876461086e-06,  -4.647950804272654e-08,   6.169882641237882e-10,
  -7.787180166699701e-12,   9.442532071457701e-14,  -1.105723916411458e-15,   1.252375647809741e-17,  -1.371014782383196e-19,   1.445283982492494e-21,  -1.456919339578632e-23,
   1.385034832967186e-25,  -1.208927073707754e-27,   9.316647884449131e-03,  -2.016222384287615e-04,   3.257213672242404e-06,  -4.649170499655461e-08,   6.172101341371539e-10,
  -7.790818004339865e-12,   9.448026601640112e-14,  -1.106497374398693e-15,   1.253394928155964e-17,  -1.372270593612173e-19,   1.446716344819995e-21,  -1.458396121192309e-23,
   1.386325477777345e-25,  -1.209682367973521e-27,   9.316985142596894e-03,  -2.016366712214719e-04,   3.257596829105577e-06,  -4.649976556834827e-08,   6.173567654931443e-10,
  -7.793222287774922e-12,   9.451658106517059e-14,  -1.107008591100378e-15,   1.254068634980649e-17,  -1.373100643784877e-19,   1.447663068035441e-21,  -1.459372120391150e-23,
   1.387178240541581e-25,  -1.210180869535779e-27,   9.317158345941530e-03,  -2.016440834755095e-04,   3.257793610284136e-06,  -4.650390537992219e-08,   6.174320750109334e-10,
  -7.794457146222349e-12,   9.453523310796889e-14,  -1.107271165374178e-15,   1.254414672745426e-17,  -1.373526986168828e-19,   1.448149331070878e-21,  -1.459873394672674e-23,
   1.387616152565245e-25,  -1.210436693305245e-27,   9.317218631771457e-03,  -2.016466634300529e-04,   3.257862103653411e-06,  -4.650534633056082e-08,   6.174582883405732e-10,
  -7.794886972918181e-12,   9.454172552470913e-14,  -1.107362563129129e-15,   1.254535123445360e-17,  -1.373675389987606e-19,   1.448318591371399e-21,  -1.460047876051635e-23,
   1.387768568271940e-25,  -1.210525706335531e-27,   9.317228198341309e-03,  -2.016470728357590e-04,   3.257872972696966e-06,  -4.650557499201793e-08,   6.174624480901510e-10,
  -7.794955181582530e-12,   9.454275580093619e-14,  -1.107377066996711e-15,   1.254554237743967e-17,  -1.373698940173265e-19,   1.448345451219577e-21,  -1.460075564236255e-23,
   1.387792754375211e-25,  -1.210539830111100e-27,   8.287266998540052e-02,  -1.729551668299493e-03,   2.593059429105332e-05,  -3.244760831905291e-07,   3.459307504797519e-09,
  -3.006216340737833e-11,   1.719906700820690e-13,   4.000022362540364e-16,  -3.092862042150418e-17,   5.763621232138256e-19,  -7.502085314200955e-21,   7.216686451397663e-23,
  -3.951115138060087e-25,  -2.675753440235607e-27,   8.287510488280588e-02,  -1.729643026263615e-03,   2.593254150693520e-05,  -3.245042594997981e-07,   3.459548397312791e-09,
  -3.006134478770929e-11,   1.719088271440651e-13,   4.019571302369344e-16,  -3.096034659445947e-17,   5.767334181130946e-19,  -7.504481807655829e-21,   7.214611018192045e-23,
  -3.940733358063591e-25,  -2.697243594718412e-27,   8.287940144622467e-02,  -1.729804235272467e-03,   2.593597750997872e-05,  -3.245539764079737e-07,   3.459973362124107e-09,
  -3.005989718663147e-11,   1.717643462358528e-13,   4.054075896636394e-16,  -3.101633610369445e-17,   5.773884855915451e-19,  -7.508705211495289e-21,   7.210936072431874e-23,
  -3.922392744756538e-25,  -2.735189325156167e-27,   8.288459715007070e-02,  -1.729999181915792e-03,   2.594013254907889e-05,  -3.246140935439492e-07,   3.460487074087950e-09,
  -3.005814138744639e-11,   1.715895228353967e-13,   4.095816580863331e-16,  -3.108405314821626e-17,   5.781804494078078e-19,  -7.513803243203729e-21,   7.206470433979795e-23,
  -3.900177903601566e-25,  -2.781118046792968e-27,   8.288964131484836e-02,  -1.730188444248371e-03,   2.594416638543277e-05,  -3.246724530852556e-07,   3.460985609124135e-09,
  -3.005643128986314e-11,   1.714196862941948e-13,   4.136355891851537e-16,  -3.114980625625670e-17,   5.789491158085174e-19,  -7.518742938698959e-21,   7.202112369866321e-23,
  -3.878573182590292e-25,  -2.825751262516789e-27,   8.289370501857649e-02,  -1.730340919766035e-03,   2.594741613217794e-05,  -3.247194659590640e-07,   3.461387102300675e-09,
  -3.005504964544545e-11,   1.712827814710712e-13,   4.169026856044577e-16,  -3.120278653568338e-17,   5.795682296666049e-19,  -7.522715561754081e-21,   7.198585153088515e-23,
  -3.861140796011357e-25,  -2.861740435058852e-27,   8.289639033472768e-02,  -1.730441676908222e-03,   2.594956357578416e-05,  -3.247505308295597e-07,   3.461652342983977e-09,
  -3.005413471461856e-11,   1.711922747409167e-13,   4.190621622705792e-16,  -3.123780006316606e-17,   5.799772732224332e-19,  -7.525337301698058e-21,   7.196246389036136e-23,
  -3.849608120600638e-25,  -2.885537704861424e-27,   8.289776940185765e-02,  -1.730493421770066e-03,   2.595066641211734e-05,  -3.247664840034338e-07,   3.461788538560464e-09,
  -3.005366424613942e-11,   1.711457820717353e-13,   4.201713540221133e-16,  -3.125578276194662e-17,   5.801873193589196e-19,  -7.526682669900060e-21,   7.195042833895914e-23,
  -3.843681313487941e-25,  -2.897763770446273e-27,   8.289824940338619e-02,  -1.730511432241823e-03,   2.595105026779176e-05,  -3.247720366320189e-07,   3.461835939779365e-09,
  -3.005350039851903e-11,   1.711295977816408e-13,   4.205574497552978e-16,  -3.126204205592605e-17,   5.802604250833118e-19,  -7.527150775073867e-21,   7.194623529358705e-23,
  -3.841617761094416e-25,  -2.902019965012932e-27,   8.289832557323573e-02,  -1.730514290265081e-03,   2.595111118056163e-05,  -3.247729177567689e-07,   3.461843461562364e-09,
  -3.005347439356466e-11,   1.711270294584369e-13,   4.206187193207453e-16,  -3.126303533158964e-17,   5.802720258240107e-19,  -7.527225049200296e-21,   7.194556972695454e-23,
  -3.841290271803583e-25,  -2.902695402472028e-27,   2.249489913942989e-01,  -4.360611974189531e-03,   5.556985710531027e-05,  -4.942945445609334e-07,   2.007258826221082e-09,
   2.723971535099531e-11,  -7.281245312843843e-13,   8.573092438659375e-15,  -3.850606456613664e-17,  -6.951046172092562e-19,   1.909878576826804e-20,  -2.324482784434043e-22,
   9.630026133201501e-25,   2.366230188631579e-26,   2.249542033129964e-01,  -4.360750903777610e-03,   5.557098039923614e-05,  -4.942688658258630e-07,   2.006233730094732e-09,
   2.725655571468367e-11,  -7.282239411298652e-13,   8.570715428951989e-15,  -3.842530934064265e-17,  -6.962962628526928e-19,   1.910449660640801e-20,  -2.322712247587036e-22,
   9.576591138157337e-25,   2.373535697025898e-26,   2.249633999105953e-01,  -4.360996041328845e-03,   5.557296200000279e-05,  -4.942235424693038e-07,   2.004424818828778e-09,
   2.728626698186354e-11,  -7.283991789162540e-13,   8.566517893222628e-15,  -3.828279610324489e-17,  -6.983981940347577e-19,   1.911454656959232e-20,  -2.319583777300352e-22,
   9.482285670300530e-25,   2.386416706489263e-26,   2.249745206796922e-01,  -4.361292454225753e-03,   5.557535737304052e-05,  -4.941687151173508e-07,   2.002237271417266e-09,
   2.732218764749390e-11,  -7.286107842504685e-13,   8.561436622980689e-15,  -3.811043460690737e-17,  -7.009385979297338e-19,   1.912665321845284e-20,  -2.315793418265067e-22,
   9.368218955610574e-25,   2.401976040391457e-26,   2.249853166816635e-01,  -4.361580196209184e-03,   5.557768192215330e-05,  -4.941154667789301e-07,   2.000113436759502e-09,
   2.735705197975257e-11,  -7.288158990636026e-13,   8.556497987771162e-15,  -3.794307460779895e-17,  -7.034034426164188e-19,   1.913835809675838e-20,  -2.312106080807701e-22,
   9.257452121867557e-25,   2.417063442289862e-26,   2.249940139092230e-01,  -4.361811989865536e-03,   5.557955394854306e-05,  -4.940725542081331e-07,   1.998402358927633e-09,
   2.738513333687551e-11,  -7.289809161961181e-13,   8.552515314417221e-15,  -3.780822694819030e-17,  -7.053881314884630e-19,   1.914775296346488e-20,  -2.309130080113500e-22,
   9.168196398391054e-25,   2.429205218844372e-26,   2.249997609355069e-01,  -4.361965151290177e-03,   5.558079065637258e-05,  -4.940441903157572e-07,   1.997271638597787e-09,
   2.740368659912526e-11,  -7.290898485100440e-13,   8.549881592087173e-15,  -3.771910998491273e-17,  -7.066991090497022e-19,   1.915394406339807e-20,  -2.307160885876881e-22,
   9.109206399541650e-25,   2.437222189848220e-26,   2.250027123249545e-01,  -4.362043805867610e-03,   5.558142567413574e-05,  -4.940296216166462e-07,   1.996690937788261e-09,
   2.741321384506320e-11,  -7.291457570424075e-13,   8.548528418028807e-15,  -3.767334044405626e-17,  -7.073722134655032e-19,   1.915711827466078e-20,  -2.306148773867890e-22,
   9.078908695939417e-25,   2.441337400169088e-26,   2.250037395857009e-01,  -4.362071182131662e-03,   5.558164668341481e-05,  -4.940245504521873e-07,   1.996488816081216e-09,
   2.741652977211281e-11,  -7.291652111979028e-13,   8.548057332860302e-15,  -3.765740934504029e-17,  -7.076064704826452e-19,   1.915822225771537e-20,  -2.305796365862647e-22,
   9.068362743873605e-25,   2.442769436090562e-26,   2.250039025979582e-01,  -4.362075526359098e-03,   5.558168175385673e-05,  -4.940237457094622e-07,   1.996456741985148e-09,
   2.741705595845854e-11,  -7.291682980518345e-13,   8.547982573358928e-15,  -3.765488127097699e-17,  -7.076436427463725e-19,   1.915839740520656e-20,  -2.305740437245059e-22,
   9.066689220010580e-25,   2.442996666189681e-26,   4.256760047762337e-01,  -7.351484027523632e-03,   7.007273249637626e-05,  -2.052139388913796e-07,  -5.360790334894052e-09,
   9.335393428447839e-11,  -3.910467439663728e-13,  -9.999429957788192e-15,   2.020509024385529e-16,  -9.782435113833669e-19,  -2.399054192677143e-20,   5.261132936544428e-22,
  -2.802676260666341e-24,  -6.496971236021546e-26,   4.256825680224803e-01,  -7.351541436181002e-03,   7.006971399232935e-05,  -2.051265857489688e-07,  -5.361333999186828e-09,
   9.333419670276914e-11,  -3.905184643428229e-13,  -1.000266136828465e-14,   2.019491569152040e-16,  -9.755494310961670e-19,  -2.400729230741217e-20,   5.256337390922495e-22,
  -2.789896864548583e-24,  -6.505129420195437e-26,   4.256941487434767e-01,  -7.351642714716562e-03,   7.006438754721647e-05,  -2.049724648121774e-07,  -5.362292700252035e-09,
   9.329936429114797e-11,  -3.895865240842272e-13,  -1.000835586453201e-14,   2.017695684036069e-16,  -9.707976988345634e-19,  -2.403678449792877e-20,   5.247870787645739e-22,
  -2.767362432342784e-24,  -6.519478180018469e-26,   4.257081518824222e-01,  -7.351765147800914e-03,   7.005794633150540e-05,  -2.047861258051313e-07,  -5.363450943603400e-09,
   9.325723581387814e-11,  -3.884599828155147e-13,  -1.001522913322750e-14,   2.015523111279663e-16,  -9.650552901584287e-19,  -2.407233749231469e-20,   5.237624736155847e-22,
  -2.740139171282665e-24,  -6.536749647764573e-26,   4.257217454761558e-01,  -7.351883968115340e-03,   7.005169286977590e-05,  -2.046052580141095e-07,  -5.364574269675427e-09,
   9.321632906166431e-11,  -3.873667445074005e-13,  -1.002188841781867e-14,   2.013413002146285e-16,  -9.594842598803848e-19,  -2.410673735567104e-20,   5.227669542137618e-22,
  -2.713738145264415e-24,  -6.553433614941317e-26,   4.257326960038867e-01,  -7.351979662707061e-03,   7.004665484651227e-05,  -2.044595725437673e-07,  -5.365478435378421e-09,
   9.318336856125955e-11,  -3.864863243441319e-13,  -1.002724362113259e-14,   2.011712401131748e-16,  -9.549988914221285e-19,  -2.413436754050320e-20,   5.219643690758993e-22,
  -2.692489070615437e-24,  -6.566814671109398e-26,   4.257399317732863e-01,  -7.352042883499822e-03,   7.004332565592387e-05,  -2.043633156163124e-07,  -5.366075514443381e-09,
   9.316158564426642e-11,  -3.859046947265726e-13,  -1.003077762840414e-14,   2.010588320068832e-16,  -9.520363041092489e-19,  -2.415258499396503e-20,   5.214337382754643e-22,
  -2.678457491091577e-24,  -6.575627604352520e-26,   4.257436476424808e-01,  -7.352075346539842e-03,   7.004161590947470e-05,  -2.043138859967309e-07,  -5.366382026372701e-09,
   9.315039808341114e-11,  -3.856060422594554e-13,  -1.003259108308658e-14,   2.010010941231956e-16,  -9.505152648585976e-19,  -2.416192813675565e-20,   5.211611423154129e-22,
  -2.671254521323110e-24,  -6.580144493558605e-26,   4.257449409776807e-01,  -7.352086644983379e-03,   7.004102080895936e-05,  -2.042966820296030e-07,  -5.366488692072705e-09,
   9.314650399273690e-11,  -3.855021002476186e-13,  -1.003322204541824e-14,   2.009809961829920e-16,  -9.499859154894016e-19,  -2.416517813082209e-20,   5.210662482166564e-22,
  -2.668747926345419e-24,  -6.581715209959469e-26,   4.257451462118276e-01,  -7.352088437861576e-03,   7.004092637434236e-05,  -2.042939520190147e-07,  -5.366505617568054e-09,
   9.314588604669341e-11,  -3.854856064006159e-13,  -1.003332215966617e-14,   2.009778068340433e-16,  -9.499019179912414e-19,  -2.416569376649438e-20,   5.210511891382604e-22,
  -2.668350186302805e-24,  -6.581964393223771e-26,   6.708133520962528e-01,  -9.834804446373194e-03,   5.463158105074977e-05,   4.347141597073194e-07,  -9.453780329450478e-09,
   7.003936658060927e-12,   1.463478926671304e-12,  -1.271576336141153e-14,  -1.675124508613540e-16,   3.822981146294919e-18,   1.618853808289150e-21,  -7.997329068591636e-22,
   6.476423653488434e-24,   1.160831646991134e-25,   6.708184631454108e-01,  -9.834682160907623e-03,   5.462627489433919e-05,   4.347205173149682e-07,  -9.451727514037864e-09,
   6.979105846829455e-12,   1.463039378094962e-12,  -1.270296733119076e-14,  -1.675043676530027e-16,   3.818890437678429e-18,   1.657990162807677e-21,  -7.988867660235953e-22,
   6.456149167133773e-24,   1.160345266294174e-25,   6.708274812691427e-01,  -9.834466384859091e-03,   5.461691303529383e-05,   4.347317165505919e-07,  -9.448105791354361e-09,
   6.935311918033826e-12,   1.462263805714100e-12,  -1.268039973447666e-14,  -1.674899712937293e-16,   3.811675862116249e-18,   1.726945381103104e-21,  -7.973940316878945e-22,
   6.420419222977948e-24,   1.159483067530713e-25,   6.708383853937637e-01,  -9.834205463736104e-03,   5.460559417352278e-05,   4.347452266334664e-07,  -9.443727222218585e-09,
   6.882390651026744e-12,   1.461326006184856e-12,  -1.265312984553184e-14,  -1.674723358231499e-16,   3.802957962470371e-18,   1.810153864174077e-21,  -7.955895050980827e-22,
   6.377290359924083e-24,   1.158433730243515e-25,   6.708489702098911e-01,  -9.833952163496355e-03,   5.459460769187698e-05,   4.347583083318444e-07,  -9.439477480129612e-09,
   6.831052048199312e-12,   1.460415639220248e-12,  -1.262667669188450e-14,  -1.674549779541136e-16,   3.794501102649956e-18,   1.890750352168698e-21,  -7.938382314549593e-22,
   6.335501290931092e-24,   1.157407995817198e-25,   6.708574966847805e-01,  -9.833748106307027e-03,   5.458575832400094e-05,   4.347688226729365e-07,  -9.436054585876743e-09,
   6.789720440596646e-12,   1.459682282953683e-12,  -1.260538068671527e-14,  -1.674408246118887e-16,   3.787692898317894e-18,   1.955548382253557e-21,  -7.924278090304592e-22,
   6.301893600062329e-24,   1.156576636198005e-25,   6.708631305751921e-01,  -9.833613268066163e-03,   5.457991140629165e-05,   4.347757585636343e-07,  -9.433793113012304e-09,
   6.762422026958304e-12,   1.459197705783876e-12,  -1.259131567069652e-14,  -1.674313891514794e-16,   3.783196376835033e-18,   1.998302438505671e-21,  -7.914960140711206e-22,
   6.279714142921704e-24,   1.156024825964123e-25,   6.708660237694675e-01,  -9.833544021904143e-03,   5.457690891578674e-05,   4.347793168273771e-07,  -9.432631835805804e-09,
   6.748406935636336e-12,   1.458948855819337e-12,  -1.258409477777557e-14,  -1.674265178840181e-16,   3.780887883976085e-18,   2.020239119289533e-21,  -7.910175507460362e-22,
   6.268332556053399e-24,   1.155740684645811e-25,   6.708670307598090e-01,  -9.833519920099785e-03,   5.457586390036506e-05,   4.347805547329649e-07,  -9.432227658132306e-09,
   6.743529483558220e-12,   1.458862241884471e-12,  -1.258158182461854e-14,  -1.674248183038007e-16,   3.780084501113826e-18,   2.027871266964628e-21,  -7.908510264441899e-22,
   6.264372463310824e-24,   1.155641665716415e-25,   6.708671905547181e-01,  -9.833516095473302e-03,   5.457569807218153e-05,   4.347807511439670e-07,  -9.432163521437447e-09,
   6.742755528936452e-12,   1.458848497473160e-12,  -1.258118306992702e-14,  -1.674245484096486e-16,   3.779957020502770e-18,   2.029082235832859e-21,  -7.908246017697771e-22,
   6.263744116294659e-24,   1.155625947036745e-25,   9.424760686340922e-01,  -1.106028004315958e-02,   1.192226183872526e-05,   8.921014857544658e-07,  -2.764580046496569e-09,
  -1.276370158709919e-10,   6.693230990643220e-13,   2.184472360650738e-14,  -1.662537411766680e-16,  -4.069151908766274e-18,   4.183347594134847e-20,   7.901739334942422e-22,
  -1.061984583606047e-23,  -1.561835796883979e-25,   9.424771832329568e-01,  -1.106002956024301e-02,   1.192071204679493e-05,   8.919821858415803e-07,  -2.763643925631922e-09,
  -1.275942256991620e-10,   6.688902796223474e-13,   2.183109514281387e-14,  -1.660793305381488e-16,  -4.065121284209068e-18,   4.176881021938210e-20,   7.890482139937697e-22,
  -1.059722947655796e-23,  -1.558860491777487e-25,   9.424791498427230e-01,  -1.105958760640586e-02,   1.191797784141054e-05,   8.917717118129566e-07,  -2.761992619038723e-09,
  -1.275187435287864e-10,   6.681269338569020e-13,   2.180705853136586e-14,  -1.657718010963131e-16,  -4.058013885999472e-18,   4.165481972749881e-20,   7.870636251027790e-22,
  -1.055737480495973e-23,  -1.553616410146541e-25,   9.424815276879991e-01,  -1.105905323749348e-02,   1.191467233871934e-05,   8.915172598483704e-07,  -2.759996682459769e-09,
  -1.274275067740894e-10,   6.672045201781136e-13,   2.177801199735258e-14,  -1.654003095522357e-16,  -4.049427556795467e-18,   4.151717402887294e-20,   7.846668390617206e-22,
  -1.050927109635337e-23,  -1.547285245794287e-25,   9.424838358493451e-01,  -1.105853452997546e-02,   1.191146417574069e-05,   8.912703003689758e-07,  -2.758059942092851e-09,
  -1.273389745391487e-10,   6.663097185444660e-13,   2.174983379391446e-14,  -1.650400657562373e-16,  -4.041100481370758e-18,   4.138375165998540e-20,   7.823432192350535e-22,
  -1.046266589975541e-23,  -1.541149557643279e-25,   9.424856951238890e-01,  -1.105811670074158e-02,   1.190888026706479e-05,   8.910713946301709e-07,  -2.756500359720997e-09,
  -1.272676819306992e-10,   6.655893517286197e-13,   2.172714788450018e-14,  -1.647501399316871e-16,  -4.034398300514148e-18,   4.127641268571500e-20,   7.804735879487305e-22,
  -1.042518793559849e-23,  -1.536214239293632e-25,   9.424869236258424e-01,  -1.105784062366289e-02,   1.190717313337502e-05,   8.909399816287144e-07,  -2.755470124067845e-09,
  -1.272205866565630e-10,   6.651135780103352e-13,   2.171216433280276e-14,  -1.645587000377535e-16,  -4.029972556108793e-18,   4.120555561680967e-20,   7.792392680433018e-22,
  -1.040045572383239e-23,  -1.532956743587529e-25,   9.424875544976349e-01,  -1.105769885014122e-02,   1.190629652114328e-05,   8.908725010625043e-07,  -2.754941144178515e-09,
  -1.271964051884159e-10,   6.648693171150889e-13,   2.170447169314584e-14,  -1.644604291266121e-16,  -4.027700632593264e-18,   4.116918894546270e-20,   7.786057254471406e-22,
  -1.038776461084006e-23,  -1.531284999389630e-25,   9.424877740747191e-01,  -1.105764950540733e-02,   1.190599142137743e-05,   8.908490148360257e-07,  -2.754757043071755e-09,
  -1.271879892769037e-10,   6.647843112820153e-13,   2.170179453867583e-14,  -1.644262318216945e-16,  -4.026910013328337e-18,   4.115653466563153e-20,   7.783852692146390e-22,
  -1.038334895376633e-23,  -1.530703314253816e-25,   9.424878089184064e-01,  -1.105764167511746e-02,   1.190594300687070e-05,   8.908452879429345e-07,  -2.754727829482578e-09,
  -1.271866538194545e-10,   6.647708225685756e-13,   2.170136972723400e-14,  -1.644208055024772e-16,  -4.026784559799737e-18,   4.115452677055775e-20,   7.783502884132586e-22,
  -1.038264832579348e-23,  -1.530611017412941e-25,   1.220180929506132e+00,  -1.062434789207337e-02,  -3.797362649717073e-05,   7.245237357188246e-07,   7.707624830651717e-09,
  -7.326810146488133e-11,  -1.622956486258599e-12,   5.544754532658163e-15,   3.376308596848382e-16,   5.499781100157193e-19,  -6.739358887208245e-20,  -4.587463796101247e-22,
   1.241437722499572e-23,   1.666039016453423e-25,   1.220177378162915e+00,  -1.062414436177182e-02,  -3.796930378498882e-05,   7.244551390562854e-07,   7.705352955834169e-09,
  -7.325715681942732e-11,  -1.622076021079397e-12,   5.546550432223450e-15,   3.373489848551206e-16,   5.476589480117173e-19,  -6.731754181955762e-20,  -4.575538547232922e-22,
   1.239780671215135e-23,   1.661351944627680e-25,   1.220171112089792e+00,  -1.062378524501652e-02,  -3.796167732773808e-05,   7.243341075148815e-07,   7.701345201256553e-09,
  -7.323784197515053e-11,  -1.620523026475943e-12,   5.549712995701406e-15,   3.368518724333452e-16,   5.435717229186218e-19,  -6.718343877849514e-20,  -4.554523954969459e-22,
   1.236858367131162e-23,   1.653093986704246e-25,   1.220163535646182e+00,  -1.062335102390552e-02,  -3.795245710097533e-05,   7.241877691186830e-07,   7.696500693509242e-09,
  -7.321448141469310e-11,  -1.618646151574913e-12,   5.553526418139731e-15,   3.362512021631090e-16,   5.386378776886102e-19,  -6.702142172151528e-20,  -4.529160060594851e-22,
   1.233327396111839e-23,   1.643129585108086e-25,   1.220156181151140e+00,  -1.062292951753241e-02,  -3.794350811424239e-05,   7.240457212473033e-07,   7.691799521342424e-09,
  -7.319179832278667e-11,  -1.616825184456478e-12,   5.557217142541177e-15,   3.356685459182625e-16,   5.338570468106803e-19,  -6.686428676056490e-20,  -4.504586567905056e-22,
   1.229902429997169e-23,   1.633478493821302e-25,   1.220150256884868e+00,  -1.062258997751532e-02,  -3.793630025200309e-05,   7.239313000140106e-07,   7.688013601789150e-09,
  -7.317352149665967e-11,  -1.615359003728122e-12,   5.560182268342426e-15,   3.351994979434635e-16,   5.300120131461998e-19,  -6.673780715352478e-20,  -4.484825786131168e-22,
   1.227145357136573e-23,   1.625719566954214e-25,   1.220146342440529e+00,  -1.062236562533014e-02,  -3.793153807372605e-05,   7.238556977333857e-07,   7.685512561910032e-09,
  -7.316144272448703e-11,  -1.614390552881452e-12,   5.562137620887262e-15,   3.348897220388173e-16,   5.274743855022638e-19,  -6.665428369700987e-20,  -4.471785481224431e-22,
   1.225324529388596e-23,   1.620600365738393e-25,   1.220144332249541e+00,  -1.062225041278175e-02,  -3.792909266790714e-05,   7.238168739630033e-07,   7.684228352538604e-09,
  -7.315523914984566e-11,  -1.613893323056157e-12,   5.563140567197399e-15,   3.347306875727895e-16,   5.261721510291275e-19,  -6.661140648740822e-20,  -4.465093996987649e-22,
   1.224389755585141e-23,   1.617973808655384e-25,   1.220143632594265e+00,  -1.062221031248214e-02,  -3.792824155394928e-05,   7.238033612518069e-07,   7.683781402632361e-09,
  -7.315307985181637e-11,  -1.613720276130401e-12,   5.563489457559182e-15,   3.346753421743127e-16,   5.257190489740393e-19,  -6.659648524181036e-20,  -4.462765813818039e-22,
   1.224064448101648e-23,   1.617059992947057e-25,   1.220143521569088e+00,  -1.062220394913979e-02,  -3.792810649540177e-05,   7.238012169828706e-07,   7.683710479305827e-09,
  -7.315273719682518e-11,  -1.613692816843230e-12,   5.563544812432491e-15,   3.346665600017445e-16,   5.256471551604388e-19,  -6.659411756715022e-20,  -4.462396403520495e-22,
   1.224012828615259e-23,   1.616915001088692e-25,   1.482232093970776e+00,  -8.618969724393721e-03,  -6.924282167787277e-05,   6.857903896268623e-08,   8.879856433828290e-09,
   8.034573852763797e-11,  -5.861376249104855e-13,  -2.042520884985768e-14,  -1.183647907025302e-16,   2.619801518395639e-18,   5.383900374668310e-20,   8.385771790719129e-23,
  -1.042276359020896e-23,  -1.418075571775960e-25,   1.482225612486465e+00,  -8.618950172521306e-03,  -6.923783144340432e-05,   6.865402617548824e-08,   8.879028567130640e-09,
   8.030566729969681e-11,  -5.864436898584147e-13,  -2.041635694877417e-14,  -1.181397221962809e-16,   2.620194496980445e-18,   5.377476125305075e-20,   8.284155792454953e-23,
  -1.041744277160146e-23,  -1.414297840289891e-25,   1.482214176185052e+00,  -8.618915655846476e-03,  -6.922902647549074e-05,   6.878631179563632e-08,   8.877567435200988e-09,
   8.023497515979630e-11,  -5.869832672072051e-13,  -2.040073658043893e-14,  -1.177428053935801e-16,   2.620883675378318e-18,   5.366143140052928e-20,   8.105076679701654e-23,
  -1.040802930497716e-23,  -1.407636952928855e-25,   1.482200347934453e+00,  -8.618873888782142e-03,  -6.921838006107639e-05,   6.894622098924606e-08,   8.875800025664171e-09,
   8.014951763479729e-11,  -5.876349133753459e-13,  -2.038184648240237e-14,  -1.172632246092333e-16,   2.621709816687648e-18,   5.352443791918814e-20,   7.888913893448370e-23,
  -1.039660423937917e-23,  -1.399591031192552e-25,   1.482186924385918e+00,  -8.618833311538052e-03,  -6.920804538377887e-05,   6.910140363064645e-08,   8.874083634367911e-09,
   8.006658225649932e-11,  -5.882666655463496e-13,  -2.036350644650864e-14,  -1.167980487663473e-16,   2.622504267243387e-18,   5.339149549388873e-20,   7.679466140704976e-23,
  -1.038546889575380e-23,  -1.391789090456164e-25,   1.482176111035389e+00,  -8.618800601188291e-03,  -6.919972038768546e-05,   6.922637775216689e-08,   8.872700487458612e-09,
   7.999978872814409e-11,  -5.887749848158455e-13,  -2.034873062961553e-14,  -1.164235905968534e-16,   2.623138860259030e-18,   5.328443361326980e-20,   7.511023696576449e-23,
  -1.037646689296272e-23,  -1.385510329736331e-25,   1.482168966003749e+00,  -8.618778976075457e-03,  -6.919421961634285e-05,   6.930893933440329e-08,   8.871786311165429e-09,
   7.995566163371092e-11,  -5.891105735677693e-13,  -2.033896638838792e-14,  -1.161762930864208e-16,   2.623555543415212e-18,   5.321370610358679e-20,   7.399859861015223e-23,
  -1.037050312922406e-23,  -1.381364562505944e-25,   1.482165296761651e+00,  -8.618767867237693e-03,  -6.919139478059748e-05,   6.935133275383529e-08,   8.871316770675978e-09,
   7.993300300538207e-11,  -5.892828218305379e-13,  -2.033395178456570e-14,  -1.160493365859732e-16,   2.623768712781296e-18,   5.317738942994265e-20,   7.342815171621506e-23,
  -1.036743569474284e-23,  -1.379236479741379e-25,   1.482164019660042e+00,  -8.618764000178435e-03,  -6.919041158235586e-05,   6.936608723190580e-08,   8.871153332109576e-09,
   7.992511689947597e-11,  -5.893427596729908e-13,  -2.033220637419628e-14,  -1.160051549955178e-16,   2.623842778248685e-18,   5.316474992134448e-20,   7.322967130594574e-23,
  -1.036636728941331e-23,  -1.378495935035993e-25,   1.482163817002161e+00,  -8.618763386504392e-03,  -6.919025556289162e-05,   6.936842851975961e-08,   8.871127396152131e-09,
   7.992386550383271e-11,  -5.893522702832656e-13,  -2.033192940011043e-14,  -1.159981443075539e-16,   2.623854525243758e-18,   5.316274424539993e-20,   7.319817846685101e-23,
  -1.036619771229177e-23,  -1.378378428101168e-25,   1.707418139247597e+00,  -5.638320509804232e-03,  -6.720628978791760e-05,  -4.687435614759469e-07,   7.622335030938540e-10,
   7.416765591763253e-11,   1.041399074019099e-12,   4.637968666479591e-15,  -1.034690985955388e-16,  -2.564694302670061e-18,  -2.417686284285650e-20,   7.732370486076514e-23,
   6.089158693266302e-24,   9.095690482338455e-26,   1.707411839547736e+00,  -5.638452098475471e-03,  -6.720585278607455e-05,  -4.686739539560314e-07,   7.636947278799097e-10,
   7.417664942127645e-11,   1.041125390488974e-12,   4.629324001213756e-15,  -1.035698782527328e-16,  -2.564270034768609e-18,  -2.413905516318409e-20,   7.798191317359765e-23,
   6.092021363129378e-24,   9.083201308039864e-26,   1.707400723662351e+00,  -5.638684272830156e-03,  -6.720508102196136e-05,  -4.685511235778307e-07,   7.662727683267379e-10,
   7.419250476906707e-11,   1.040642257248042e-12,   4.614071536046838e-15,  -1.037475757567425e-16,  -2.563518655230487e-18,  -2.407232877129092e-20,   7.914258606189860e-23,
   6.097049505685768e-24,   9.061137526168034e-26,   1.707387282273190e+00,  -5.638964993384623e-03,  -6.720414665852838e-05,  -4.684025841604345e-07,   7.693896273700108e-10,
   7.421165364354783e-11,   1.040057682082127e-12,   4.595630113947292e-15,  -1.039622281474995e-16,  -2.562605388564536e-18,  -2.399161846405206e-20,   8.054481099842035e-23,
   6.103090240719537e-24,   9.034412765736950e-26,   1.707374233666269e+00,  -5.639237483600925e-03,  -6.720323840308224e-05,  -4.682583725147883e-07,   7.724148597057340e-10,
   7.423021834681410e-11,   1.039489804345223e-12,   4.577729624331822e-15,  -1.041703771566702e-16,  -2.561713895989523e-18,  -2.391324122052909e-20,   8.190473212964232e-23,
   6.108913289670821e-24,   9.008421807567010e-26,   1.707363721921963e+00,  -5.639456977798463e-03,  -6.720250587061785e-05,  -4.681421887891507e-07,   7.748515458087512e-10,
   7.424515613935625e-11,   1.039032055690205e-12,   4.563310748972914e-15,  -1.043378931667335e-16,  -2.560992205742065e-18,  -2.385008363815899e-20,   8.299930973654551e-23,
   6.113574757755005e-24,   8.987450207991016e-26,   1.707356775970011e+00,  -5.639602005676519e-03,  -6.720202140826211e-05,  -4.680654123961797e-07,   7.764614678220190e-10,
   7.425501810506505e-11,   1.038729449574343e-12,   4.553783762181283e-15,  -1.044485034110211e-16,  -2.560513605219838e-18,  -2.380834150017435e-20,   8.372211807633044e-23,
   6.116640530535779e-24,   8.973576114941043e-26,   1.707353208897962e+00,  -5.639676481345507e-03,  -6.720177248441359e-05,  -4.680259827288735e-07,   7.772881789463676e-10,
   7.426008001778881e-11,   1.038574005441271e-12,   4.548891430704840e-15,  -1.045052819029089e-16,  -2.560267289048935e-18,  -2.378690222051908e-20,   8.409316960537972e-23,
   6.118210485964589e-24,   8.966446028110498e-26,   1.707351967346924e+00,  -5.639702402792868e-03,  -6.720168582361273e-05,  -4.680122586626383e-07,   7.775759136336188e-10,
   7.426184143644893e-11,   1.038519895095478e-12,   4.547188646916515e-15,  -1.045250401710732e-16,  -2.560181471785184e-18,  -2.377943965447710e-20,   8.422229437446539e-23,
   6.118756212475022e-24,   8.963963528495404e-26,   1.707351770329924e+00,  -5.639706516146246e-03,  -6.720167207076037e-05,  -4.680100808323958e-07,   7.776215727056797e-10,
   7.426212092908831e-11,   1.038511308215915e-12,   4.546918440336944e-15,  -1.045281753459377e-16,  -2.560167849748308e-18,  -2.377825542769484e-20,   8.424278359955706e-23,
   6.118842778011286e-24,   8.963569551667615e-26,   1.876913097130208e+00,  -2.617209265351048e-03,  -3.893549760214075e-05,  -4.621227943893852e-07,  -4.261060335410562e-09,
  -2.357286305968785e-11,   1.168909970332782e-13,   5.683955175340871e-15,   9.618883283830485e-17,   1.058691979919106e-18,   6.071648300167840e-21,  -5.224759550511792e-23,
  -2.161335625609719e-24,  -3.695525209604561e-26,   1.876909442124866e+00,  -2.617339314619743e-03,  -3.893789349749772e-05,  -4.621447992871686e-07,  -4.260892964840137e-09,
  -2.356161609377386e-11,   1.171440109075283e-13,   5.687520913769634e-15,   9.621401162761398e-17,   1.058412015935914e-18,   6.058115293068685e-21,  -5.251890264215488e-23,
  -2.164787223804175e-24,  -3.697484366639321e-26,   1.876902992627843e+00,  -2.617568793618824e-03,  -3.894212101536394e-05,  -4.621836186862654e-07,  -4.260597347360253e-09,
  -2.354176494149685e-11,   1.175905113458029e-13,   5.693811939456218e-15,   9.625839344143551e-17,   1.057916876651249e-18,   6.034218753178260e-21,  -5.299774337398740e-23,
  -2.170875141577051e-24,  -3.700930512909268e-26,   1.876895193515793e+00,  -2.617846290632151e-03,  -3.894723284344380e-05,  -4.622305448701211e-07,  -4.260239389923735e-09,
  -2.351775099114298e-11,   1.181305155607237e-13,   5.701417789877067e-15,   9.631198098234107e-17,   1.057316207488521e-18,   6.005293251161736e-21,  -5.357695838093792e-23,
  -2.178232474816283e-24,  -3.705079169596097e-26,   1.876887621946791e+00,  -2.618115688887032e-03,  -3.895219517963502e-05,  -4.622760846537659e-07,  -4.259891374071929e-09,
  -2.349442848107114e-11,   1.186548376321183e-13,   5.708800027490963e-15,   9.636391961700555e-17,   1.056731054778082e-18,   5.977181940351711e-21,  -5.413945463148808e-23,
  -2.185370390695864e-24,  -3.709087261837857e-26,   1.876881522155672e+00,  -2.618332719034875e-03,  -3.895619267416457e-05,  -4.623127599151238e-07,  -4.259610646583600e-09,
  -2.347563287511570e-11,   1.190772929145144e-13,   5.714746064028033e-15,   9.640570104047822e-17,   1.056258206084963e-18,   5.954513677492780e-21,  -5.459274031287861e-23,
  -2.191117400615750e-24,  -3.712302248835214e-26,   1.876877491407990e+00,  -2.618476131831841e-03,  -3.895883409884452e-05,  -4.623369888894123e-07,  -4.259424965465934e-09,
  -2.346320950194709e-11,   1.193564772268534e-13,   5.718674609582279e-15,   9.643328023237965e-17,   1.055945042450778e-18,   5.939524047974123e-21,  -5.489233474927341e-23,
  -2.194913350562497e-24,  -3.714419853128510e-26,   1.876875421390820e+00,  -2.618549782136577e-03,  -3.896019058180150e-05,  -4.623494299614105e-07,  -4.259329553226387e-09,
  -2.345682840090913e-11,   1.194998620498305e-13,   5.720691954161182e-15,   9.644743442473086e-17,   1.055783997214897e-18,   5.931822802668674e-21,  -5.504621285359066e-23,
  -2.196862265554753e-24,  -3.715505239482337e-26,   1.876874700896756e+00,  -2.618575416954256e-03,  -3.896066271572774e-05,  -4.623537599252629e-07,  -4.259296335190994e-09,
  -2.345460722442785e-11,   1.195497700930515e-13,   5.721394085276464e-15,   9.645235948117140e-17,   1.055727908803714e-18,   5.929141779920945e-21,  -5.509977504051451e-23,
  -2.197540525670640e-24,  -3.715882682948997e-26,   1.876874586564004e+00,  -2.618579484854114e-03,  -3.896073763676605e-05,  -4.623544470183033e-07,  -4.259291063522243e-09,
  -2.345425474596378e-11,   1.195576898901310e-13,   5.721505502668258e-15,   9.645314095144050e-17,   1.055719006676970e-18,   5.928716313194842e-21,  -5.510827478817139e-23,
  -2.197648152524698e-24,  -3.715942562113952e-26,   1.976201040914669e+00,  -5.339719680712215e-04,  -8.875574560697494e-06,  -1.289489924380101e-07,  -1.718154820122626e-09,
  -2.136045682184209e-11,  -2.486920258824344e-13,  -2.694626186276413e-15,  -2.664876949306794e-17,  -2.291493960432509e-19,  -1.468707154960437e-21,  -1.109043887023667e-24,
   1.819398562549343e-25,   4.274774064318491e-27,   1.976200206887051e+00,  -5.340083056075867e-04,  -8.876543000083319e-06,  -1.289690625461260e-07,  -1.718505371556484e-09,
  -2.136577416033310e-11,  -2.487621058488081e-13,  -2.695399675761083e-15,  -2.665492833412472e-17,  -2.291538736874613e-19,  -1.467552918084713e-21,  -1.077238472232666e-24,
   1.825532011700151e-25,   4.284652572282491e-27,   1.976198735158125e+00,  -5.340724283600841e-04,  -8.878251987148355e-06,  -1.290044806247884e-07,  -1.719124005257089e-09,
  -2.137515792599398e-11,  -2.488857761749433e-13,  -2.696764521517390e-15,  -2.666579172225863e-17,  -2.291616406706892e-19,  -1.465513152846959e-21,  -1.021058404808830e-24,
   1.836364226253216e-25,   4.302096933781393e-27,   1.976196955401476e+00,  -5.341499741180239e-04,  -8.880318786315567e-06,  -1.290473154623708e-07,  -1.719872200462948e-09,
  -2.138650698701225e-11,  -2.490353420246288e-13,  -2.698414926761387e-15,  -2.667892104726346e-17,  -2.291708041260498e-19,  -1.463041364469762e-21,  -9.530243606698963e-25,
   1.849479112227054e-25,   4.323214001235350e-27,   1.976195227512249e+00,  -5.342252624088290e-04,  -8.882325485869809e-06,  -1.290889060269756e-07,  -1.720598678608089e-09,
  -2.139752666996637e-11,  -2.491805613806730e-13,  -2.700017131359254e-15,  -2.669165963851423e-17,  -2.291794603885533e-19,  -1.460636259112223e-21,  -8.868727683706737e-25,
   1.862228058933253e-25,   4.343738344683925e-27,   1.976193835452373e+00,  -5.342859195607860e-04,  -8.883942262376592e-06,  -1.291224160371051e-07,  -1.721184022559294e-09,
  -2.140640556741437e-11,  -2.492975649791929e-13,  -2.701307860475335e-15,  -2.670191656664519e-17,  -2.291862620352363e-19,  -1.458694767999751e-21,  -8.335063946909139e-25,
   1.872510805399507e-25,   4.360289876536560e-27,   1.976192915557592e+00,  -5.343260036074204e-04,  -8.885010700089691e-06,  -1.291445613972934e-07,  -1.721570857656661e-09,
  -2.141227336033130e-11,  -2.493748870835363e-13,  -2.702160758009609e-15,  -2.670869165478634e-17,  -2.291906722990452e-19,  -1.457409920469106e-21,  -7.982058532417310e-25,
   1.879311515944514e-25,   4.371235349634901e-27,   1.976192443133253e+00,  -5.343465895744027e-04,  -8.885559425091450e-06,  -1.291559348856946e-07,  -1.721769531527124e-09,
  -2.141528699263723e-11,  -2.494145982226521e-13,  -2.702598763764206e-15,  -2.671217021076831e-17,  -2.291929111453476e-19,  -1.456749488082116e-21,  -7.800658916058049e-25,
   1.882805879305589e-25,   4.376859007828488e-27,   1.976192278699350e+00,  -5.343537548505978e-04,  -8.885750418806822e-06,  -1.291598936576768e-07,  -1.721838684260973e-09,
  -2.141633595314854e-11,  -2.494284204524263e-13,  -2.702751216004616e-15,  -2.671338083045014e-17,  -2.291936862502991e-19,  -1.456519522726975e-21,  -7.737502894708587e-25,
   1.884022422723897e-25,   4.378816792947026e-27,   1.976192252605846e+00,  -5.343548918879830e-04,  -8.885780727114201e-06,  -1.291605218662124e-07,  -1.721849657964889e-09,
  -2.141650241054813e-11,  -2.494306138691136e-13,  -2.702775408091021e-15,  -2.671357293325279e-17,  -2.291938090519318e-19,  -1.456483025843145e-21,  -7.727480038705469e-25,
   1.884215485569801e-25,   4.379127486392669e-27,   8.556730145764684e-03,  -1.775475603199719e-04,   2.751453415830029e-06,  -3.770201812798319e-08,   4.809440301427280e-10,
  -5.840772478392572e-12,   6.825105571542282e-14,  -7.717945221709411e-16,   8.463112091987490e-18,  -9.002798956551661e-20,   9.267323761235815e-22,  -9.194805296514109e-24,
   8.709900936468672e-26,  -7.766131071011654e-28,   8.556988638195158e-03,  -1.775581833270227e-04,   2.751724489711646e-06,  -3.770750666240924e-08,   4.810402718083089e-10,
  -5.842296801462667e-12,   6.827335249923494e-14,  -7.720996086051698e-16,   8.467039157244583e-18,  -9.007562219895933e-20,   9.272737931675460e-22,  -9.200507534559298e-24,
   8.715279168659889e-26,  -7.770349504269983e-28,   8.557444772888074e-03,  -1.775769290475906e-04,   2.752202847922378e-06,  -3.771719243121722e-08,   4.812101172674105e-10,
  -5.844986982475100e-12,   6.831270391709291e-14,  -7.726380692879680e-16,   8.473970384952029e-18,  -9.015969465918204e-20,   9.282294027619368e-22,  -9.210571729378920e-24,
   8.724770399636173e-26,  -7.777791544480559e-28,   8.557996371185889e-03,  -1.775995987175332e-04,   2.752781358953669e-06,  -3.772890655041661e-08,   4.814155397420698e-10,
  -5.848240811985829e-12,   6.836030238389655e-14,  -7.732894048882552e-16,   8.482354870420326e-18,  -9.026139678479096e-20,   9.293853977079123e-22,  -9.222745733770284e-24,
   8.736249435228926e-26,  -7.786788055310064e-28,   8.558531890290148e-03,  -1.776216082864719e-04,   2.753343046178321e-06,  -3.774028049258911e-08,   4.816150059180505e-10,
  -5.851400446773256e-12,   6.840652514227692e-14,  -7.739219439937243e-16,   8.490497705092001e-18,  -9.036017019125205e-20,   9.305081010441246e-22,  -9.234568519842448e-24,
   8.747395318592818e-26,  -7.795519100457858e-28,   8.558963324046820e-03,  -1.776393405182423e-04,   2.753795590518815e-06,  -3.774944468162182e-08,   4.817757259489844e-10,
  -5.853946433402670e-12,   6.844377233859681e-14,  -7.744316768140019e-16,   8.497059847095210e-18,  -9.043977139498448e-20,   9.314128826829277e-22,  -9.244096007149280e-24,
   8.756375895162634e-26,  -7.802550837806063e-28,   8.559248420778430e-03,  -1.776510584491119e-04,   2.754094651383359e-06,  -3.775550094369293e-08,   4.818819428825426e-10,
  -5.855629082538862e-12,   6.846838988357647e-14,  -7.747685812309074e-16,   8.501397159313708e-18,  -9.049238545322640e-20,   9.320109159094824e-22,  -9.250393169874123e-24,
   8.762310881329100e-26,  -7.807196361416777e-28,   8.559394835609233e-03,  -1.776570764110077e-04,   2.754248241991103e-06,  -3.775861134958355e-08,   4.819364953089526e-10,
  -5.856493298189442e-12,   6.848103379811153e-14,  -7.749416231474337e-16,   8.503624937218312e-18,  -9.051940992933620e-20,   9.323180870515280e-22,  -9.253627549372760e-24,
   8.765359022024231e-26,  -7.809581773909448e-28,   8.559445797271565e-03,  -1.776591710565569e-04,   2.754301701968982e-06,  -3.775969399074534e-08,   4.819554835684311e-10,
  -5.856794111455321e-12,   6.848543488743914e-14,  -7.750018560116986e-16,   8.504400393123440e-18,  -9.052881678442693e-20,   9.324250091333589e-22,  -9.254753382006205e-24,
   8.766419993702632e-26,  -7.810411992955936e-28,   8.559453884215890e-03,  -1.776595034497996e-04,   2.754310185395787e-06,  -3.775986579269201e-08,   4.819584967811043e-10,
  -5.856841847094349e-12,   6.848613329200256e-14,  -7.750114143295407e-16,   8.504523450021073e-18,  -9.053030955784585e-20,   9.324419765917329e-22,  -9.254932039806151e-24,
   8.766588357118336e-26,  -7.810543735117880e-28,   7.634596261778420e-02,  -1.536785060178459e-03,   2.234986633220586e-05,  -2.737108111186356e-07,   2.899745501261025e-09,
  -2.589457558640123e-11,   1.720753375380185e-13,  -3.097819938010881e-16,  -1.486897065527761e-17,   3.339174643175782e-19,  -4.768161416995992e-21,   5.199958183652464e-23,
  -4.120929990072661e-25,   1.230862892798829e-27,   7.634806119076079e-02,  -1.536862126720136e-03,   2.235149879885612e-05,  -2.737350921936692e-07,   2.899987014565886e-09,
  -2.589516741556802e-11,   1.720358891908009e-13,  -3.086480253211695e-16,  -1.488916777761940e-17,   3.341859150883450e-19,  -4.770697686818594e-21,   5.200809900819133e-23,
  -4.118021307342676e-25,   1.222124612611283e-27,   7.635176428043577e-02,  -1.536998117400270e-03,   2.235437942232277e-05,  -2.737779369787135e-07,   2.900413123333061e-09,
  -2.589620988897831e-11,   1.719662388077239e-13,  -3.066463832303738e-16,  -1.492481460534906e-17,   3.346596359115328e-19,  -4.775171499853846e-21,   5.202307552120897e-23,
  -4.112878196964401e-25,   1.206689416733441e-27,   7.635624230857063e-02,  -1.537162568255436e-03,   2.235786289119135e-05,  -2.738297461103692e-07,   2.900928301403544e-09,
  -2.589746735752235e-11,   1.718819432267697e-13,  -3.042247197391677e-16,  -1.496793393995287e-17,   3.352325240868354e-19,  -4.780578763747369e-21,   5.204109625927763e-23,
  -4.106640850618420e-25,   1.187997108621906e-27,   7.636058972334073e-02,  -1.537322224217817e-03,   2.236124477952786e-05,  -2.738800423130145e-07,   2.901428346466698e-09,
  -2.589868483738694e-11,   1.718000334532806e-13,  -3.018724948746197e-16,  -1.500980894766206e-17,   3.357887365399323e-19,  -4.785825399741968e-21,   5.205849717234138e-23,
  -4.100566629027232e-25,   1.169821713198408e-27,   7.636409210362151e-02,  -1.537450848091776e-03,   2.236396932597123e-05,  -2.739205608481663e-07,   2.901831118279055e-09,
  -2.589966329482977e-11,   1.717339927640581e-13,  -2.999766302400919e-16,  -1.504355401479541e-17,   3.362368587257579e-19,  -4.790050125026276e-21,   5.207244820711477e-23,
  -4.095659612754205e-25,   1.155158906883755e-27,   7.636640649220568e-02,  -1.537535843936113e-03,   2.236576972684531e-05,  -2.739473350523361e-07,   2.902097234312994e-09,
  -2.590030870168676e-11,   1.716903272010630e-13,  -2.987234149834239e-16,  -1.506585759028870e-17,   3.365329916986796e-19,  -4.792840818343627e-21,   5.208163401502724e-23,
  -4.092410431781421e-25,   1.145459729432131e-27,   7.636759506563276e-02,  -1.537579494445242e-03,   2.236669434021520e-05,  -2.739610849731623e-07,   2.902233888842622e-09,
  -2.590063979625048e-11,   1.716678944780717e-13,  -2.980796862011651e-16,  -1.507731322444053e-17,   3.366850768847318e-19,  -4.794273685028911e-21,   5.208634122196533e-23,
  -4.090739745486416e-25,   1.140475565575525e-27,   7.636800876334338e-02,  -1.537594687576010e-03,   2.236701616376878e-05,  -2.739658707726905e-07,   2.902281451303970e-09,
  -2.590075498058337e-11,   1.716600852312651e-13,  -2.978556077715848e-16,  -1.508130073039988e-17,   3.367380125976777e-19,  -4.794772361546890e-21,   5.208797799289813e-23,
  -4.090157917199538e-25,   1.138740276664326e-27,   7.636807441165504e-02,  -1.537597098524753e-03,   2.236706723289605e-05,  -2.739666302138131e-07,   2.902288998745119e-09,
  -2.590077325608434e-11,   1.716588459481051e-13,  -2.978200485317074e-16,  -1.508193350538143e-17,   3.367464128171110e-19,  -4.794851492465067e-21,   5.208823764919847e-23,
  -4.090065573366615e-25,   1.138464886236595e-27,   2.083589129119872e-01,  -3.939197651245467e-03,   4.984613845590867e-05,  -4.586906606580911e-07,   2.395946951775047e-09,
   1.248771904304925e-11,  -5.081506047863895e-13,   7.068913134943739e-15,  -5.209475855374069e-17,  -1.188771598054125e-19,   1.018329378910502e-20,  -1.687755183334381e-22,
   1.487022752974332e-24,  -2.919249225392598e-29,   2.083635886755558e-01,  -3.939326616066569e-03,   4.984748212990434e-05,  -4.586788364984963e-07,   2.395230761181214e-09,
   1.250162914507120e-11,  -5.082864590788388e-13,   7.068489243082368e-15,  -5.205150576936782e-17,  -1.197472987783987e-19,   1.019239408285960e-20,  -1.687731444915371e-22,
   1.484856205720099e-24,   1.768553790532899e-29,   2.083718392359858e-01,  -3.939554173801662e-03,   4.984985273594170e-05,  -4.586579619825211e-07,   2.393966876624275e-09,
   1.252617304963084e-11,  -5.085260836345241e-13,   7.067738891738657e-15,  -5.197515442569054e-17,  -1.212826601051515e-19,   1.020844075517134e-20,  -1.687686770219691e-22,
   1.481029616703704e-24,   1.004096168880927e-28,   2.083818160758081e-01,  -3.939829334405844e-03,   4.985271873900348e-05,  -4.586327022206425e-07,   2.392438309720235e-09,
   1.255585062335809e-11,  -5.088156824751095e-13,   7.066827488041335e-15,  -5.188277651980254e-17,  -1.231392131760821e-19,   1.022782589790849e-20,  -1.687627995252107e-22,
   1.476396190057617e-24,   2.004523566254607e-28,   2.083915016013957e-01,  -3.940096450695840e-03,   4.985550041963295e-05,  -4.586081615544711e-07,   2.390954126860554e-09,
   1.258465986138454e-11,  -5.090966547828295e-13,   7.065938450203973e-15,  -5.179304213214129e-17,  -1.249414984389082e-19,   1.024662509709864e-20,  -1.687565958996095e-22,
   1.471891574772458e-24,   2.975844070584933e-28,   2.083993042653770e-01,  -3.940311632620664e-03,   4.985774088579887e-05,  -4.585883783524307e-07,   2.389758290354186e-09,
   1.260786732035770e-11,  -5.093228839898383e-13,   7.065219198552119e-15,  -5.172071352276148e-17,  -1.263933778626865e-19,   1.026175546013810e-20,  -1.687512416046362e-22,
   1.468258015435431e-24,   3.758414094724786e-28,   2.084044601906392e-01,  -3.940453819296495e-03,   4.985922114047660e-05,  -4.585752993254901e-07,   2.388968005927102e-09,
   1.262320195982559e-11,  -5.094723142166889e-13,   7.064742434401842e-15,  -5.167290061109177e-17,  -1.273527447462136e-19,   1.027174646174201e-20,  -1.687475289052011e-22,
   1.465854724556903e-24,   4.275564467660199e-28,   2.084071080247245e-01,  -3.940526838429959e-03,   4.985998125853945e-05,  -4.585685805660622e-07,   2.388562127077819e-09,
   1.263107689588988e-11,  -5.095490358466737e-13,   7.064497130712118e-15,  -5.164834037851878e-17,  -1.278454226453790e-19,   1.027687519267639e-20,  -1.687455682339313e-22,
   1.464619808860581e-24,   4.541158827214523e-28,   2.084080296307719e-01,  -3.940552253323987e-03,   4.986024581447592e-05,  -4.585662417134314e-07,   2.388420852454684e-09,
   1.263381781798727e-11,  -5.095757366559654e-13,   7.064411676888254e-15,  -5.163979100729066e-17,  -1.280169032328627e-19,   1.027865995582625e-20,  -1.687448772037069e-22,
   1.464189872007094e-24,   4.633603420508180e-28,   2.084081758771084e-01,  -3.940556286313658e-03,   4.986028779537925e-05,  -4.585658705542119e-07,   2.388398433891094e-09,
   1.263425276355370e-11,  -5.095799735710509e-13,   7.064398113047928e-15,  -5.163843429437502e-17,  -1.280441148181382e-19,   1.027894315708083e-20,  -1.687447671384234e-22,
   1.464121641579286e-24,   4.648273201154491e-28,   3.973737599766485e-01,  -6.802072407408862e-03,   6.715526168589225e-05,  -2.766424028506667e-07,  -3.606624379720963e-09,
   8.130152949342703e-11,  -5.868778301706083e-13,  -4.239968454919068e-15,   1.547093599567698e-16,  -1.523549526019894e-18,  -4.634327452872710e-21,   3.421382474980575e-22,
  -4.292809759106775e-24,   9.408591146472234e-28,   3.973800516881426e-01,  -6.802149944725782e-03,   6.715322833484178e-05,  -2.765662537601130e-07,  -3.607444878088101e-09,
   8.129310111686206e-11,  -5.864721426349697e-13,  -4.245064438010929e-15,   1.546889667330976e-16,  -1.521785413313209e-18,  -4.660570315951601e-21,   3.421384150709293e-22,
  -4.285932438762404e-24,   8.189267792623934e-28,   3.973911533566897e-01,  -6.802286743143676e-03,   6.714964008077524e-05,  -2.764318939387855e-07,  -3.608892196737431e-09,
   8.127822097962110e-11,  -5.857563446172706e-13,  -4.254051540003857e-15,   1.546528928397331e-16,  -1.518672614805035e-18,  -4.706841637811402e-21,   3.421379885210020e-22,
  -4.273794797473905e-24,   6.039726263177112e-28,   3.974045773479876e-01,  -6.802452131588895e-03,   6.714530048780699e-05,  -2.762694356039965e-07,  -3.610641519423946e-09,
   8.126021389449830e-11,  -5.848908691966857e-13,  -4.264910586592980e-15,   1.546091189877475e-16,  -1.514908598086019e-18,  -4.762734371208845e-21,   3.421362420664359e-22,
  -4.259113589772589e-24,   3.443844664320532e-28,   3.974176088489198e-01,  -6.802612656766805e-03,   6.714108701834584e-05,  -2.761117353857943e-07,  -3.612338903860318e-09,
   8.124271841629409e-11,  -5.840507595452582e-13,  -4.275443718446902e-15,   1.545664640630213e-16,  -1.511254571535052e-18,  -4.816932228853159e-21,   3.421332589247123e-22,
  -4.244856914238835e-24,   9.273357105601524e-29,   3.974281066577962e-01,  -6.802741951507834e-03,   6.713769222384808e-05,  -2.759847023993890e-07,  -3.613705701642558e-09,
   8.122861389377913e-11,  -5.833740347882231e-13,  -4.283922880116670e-15,   1.545319872248097e-16,  -1.508310948389993e-18,  -4.860549002138788e-21,   3.421299338265240e-22,
  -4.233368780287227e-24,  -1.097401929040834e-28,   3.974350433255435e-01,  -6.802827376273276e-03,   6.713544876998682e-05,  -2.759007653101147e-07,  -3.614608566910176e-09,
   8.121928878990046e-11,  -5.829268949103530e-13,  -4.289522727156461e-15,   1.545091494697156e-16,  -1.506365861831102e-18,  -4.889348487583517e-21,   3.421272855578875e-22,
  -4.225776096121767e-24,  -2.434073512982882e-28,   3.974386056062325e-01,  -6.802871242608106e-03,   6.713429657668703e-05,  -2.758576608498506e-07,  -3.615072141632352e-09,
   8.121449833018156e-11,  -5.826972757914445e-13,  -4.292397578900579e-15,   1.544974038544436e-16,  -1.505366969193416e-18,  -4.904131689378638e-21,   3.421257860998372e-22,
  -4.221876418133265e-24,  -3.120135037098339e-28,   3.974398454858555e-01,  -6.802886510151214e-03,   6.713389553373294e-05,  -2.758426581469581e-07,  -3.615233478764726e-09,
   8.121283071646929e-11,  -5.826173561248670e-13,  -4.293398048101663e-15,   1.544933129262449e-16,  -1.505019295856299e-18,  -4.909276049529261e-21,   3.421252420053892e-22,
  -4.220519024610961e-24,  -3.358864001586299e-28,   3.974400422374482e-01,  -6.802888932874571e-03,   6.713383189319229e-05,  -2.758402774340889e-07,  -3.615259080067037e-09,
   8.121256607725631e-11,  -5.826046740395359e-13,  -4.293556801698586e-15,   1.544926636213022e-16,  -1.504964124904881e-18,  -4.910092337904045e-21,   3.421251546115679e-22,
  -4.220303621401389e-24,  -3.396744102816945e-28,   6.323776765073371e-01,  -9.379434541594093e-03,   5.895103893139013e-05,   2.863523492713631e-07,  -8.993900380273753e-09,
   3.737523165723334e-11,   1.052802508300474e-12,  -1.592425271357013e-14,  -3.624023796722745e-17,   3.291880192289659e-18,  -2.522333543345301e-20,  -3.998143511467584e-22,
   9.091198829750707e-24,  -9.574812309276426e-27,   6.323831930175957e-01,  -9.379353882714306e-03,   5.894598822211274e-05,   2.863871265441314e-07,  -8.992421033492491e-09,
   3.734405658964643e-11,   1.052705222407050e-12,  -1.591319644670948e-14,  -3.634486636941095e-17,   3.289816415924167e-18,  -2.516779247997163e-20,  -3.998735434746750e-22,
   9.075883262341768e-24,  -9.377750978147571e-27,   6.323929266029138e-01,  -9.379211550943288e-03,   5.893707684225541e-05,   2.864484678827255e-07,  -8.989810814856406e-09,
   3.728906536177302e-11,   1.052533337703232e-12,  -1.589369315398122e-14,  -3.652929495191499e-17,   3.286174612915658e-18,  -2.506986295204734e-20,  -3.999768262324122e-22,
   9.048872761098057e-24,  -9.030664651442246e-27,   6.324046959038757e-01,  -9.379039428363649e-03,   5.892630225932031e-05,   2.865226020727394e-07,  -8.986654701789629e-09,
   3.722259950291822e-11,   1.052325114265670e-12,  -1.587011922219042e-14,  -3.675198438508420e-17,   3.281770504780076e-18,  -2.495157657122904e-20,  -4.000997363368433e-22,
   9.016235360079419e-24,  -8.612039890683908e-27,   6.324161206522839e-01,  -9.378872320629913e-03,   5.891584368787208e-05,   2.865945279538260e-07,  -8.983591002296993e-09,
   3.715810713262005e-11,   1.052122578425762e-12,  -1.584724417175002e-14,  -3.696782881306904e-17,   3.277494657125420e-18,  -2.483688337330733e-20,  -4.002169846373800e-22,
   8.984576672724883e-24,  -8.206771425337348e-27,   6.324253237900915e-01,  -9.378737690704231e-03,   5.890741926361135e-05,   2.866524402035196e-07,  -8.981123069597311e-09,
   3.710617550688397e-11,   1.051959134609271e-12,  -1.582882357596093e-14,  -3.714146782018644e-17,   3.274049794988842e-18,  -2.474458626488599e-20,  -4.003099569960860e-22,
   8.959090869551811e-24,  -7.881097715547821e-27,   6.324314048192453e-01,  -9.378648724699599e-03,   5.890185297759435e-05,   2.866906927517860e-07,  -8.979492374089932e-09,
   3.707187107168082e-11,   1.051850995100169e-12,  -1.581665512306980e-14,  -3.725608673483719e-17,   3.271773348283821e-18,  -2.468364606326030e-20,  -4.003706670963219e-22,
   8.942259135067089e-24,  -7.666292256411866e-27,   6.324345276443510e-01,  -9.378603034869395e-03,   5.889899455434333e-05,   2.867103326785945e-07,  -8.978654955723485e-09,
   3.705425752209074e-11,   1.051795417400619e-12,  -1.581040713775808e-14,  -3.731491235278464e-17,   3.270604239955606e-18,  -2.465236522031899e-20,  -4.004016208149069e-22,
   8.933617966017380e-24,  -7.556101122227206e-27,   6.324356145603938e-01,  -9.378587131862032e-03,   5.889799967480226e-05,   2.867171678047770e-07,  -8.978363488064379e-09,
   3.704812750916933e-11,   1.051776066247506e-12,  -1.580823264397734e-14,  -3.733538130970820e-17,   3.270197314110179e-18,  -2.464148000290006e-20,  -4.004123589248462e-22,
   8.930610763032356e-24,  -7.517767464216577e-27,   6.324357870384387e-01,  -9.378584608262222e-03,   5.889784180211052e-05,   2.867182524105035e-07,  -8.978317236325899e-09,
   3.704715478638214e-11,   1.051772995162011e-12,  -1.580788759005676e-14,  -3.733862917413953e-17,   3.270132740251627e-18,  -2.463975278114475e-20,  -4.004140612245877e-22,
   8.930133581989177e-24,  -7.511685360300419e-27,   8.984921953234980e-01,  -1.092302039776720e-02,   2.228120543071944e-05,   8.285146178147034e-07,  -5.110773369733357e-09,
  -1.049569147194595e-10,   1.187119312651132e-12,   1.456175263386041e-14,  -2.757848717396353e-16,  -1.873211423064320e-18,   6.329290262989621e-20,   1.562311870457338e-22,
  -1.424944360966035e-23,   2.029913113442370e-26,   8.984942784304433e-01,  -1.092278772417547e-02,   2.227833999689419e-05,   8.284164609953834e-07,  -5.109112474750390e-09,
  -1.049283465018382e-10,   1.186400827324474e-12,   1.455545171855250e-14,  -2.755206454330203e-16,  -1.872400476240739e-18,   6.320593990540219e-20,   1.563708539237784e-22,
  -1.422335467550789e-23,   2.013927567312349e-26,   8.984979538881898e-01,  -1.092237719035885e-02,   2.227328465130924e-05,   8.282432834844823e-07,  -5.106182618673882e-09,
  -1.048779475064702e-10,   1.185133610848632e-12,   1.454433588327183e-14,  -2.750547111632813e-16,  -1.870968971244173e-18,   6.305262349920371e-20,   1.566163565009785e-22,
  -1.417736991835662e-23,   1.985784130977331e-26,   8.985023979206135e-01,  -1.092188080666561e-02,   2.226717296472027e-05,   8.280339124528543e-07,  -5.102641201851449e-09,
  -1.048170216774242e-10,   1.183602237286968e-12,   1.453089829802136e-14,  -2.744918049190607e-16,  -1.869236999699849e-18,   6.286745432839240e-20,   1.569116175126669e-22,
  -1.412184911567948e-23,   1.951860560322333e-26,   8.985067117225835e-01,  -1.092139896595031e-02,   2.226124119708966e-05,   8.278306974868173e-07,  -5.099204717490029e-09,
  -1.047578939192033e-10,   1.182116609143996e-12,   1.451785730516385e-14,  -2.739458752431995e-16,  -1.867554608461102e-18,   6.268792825872735e-20,   1.571965760713675e-22,
  -1.406803882597337e-23,   1.919040777718509e-26,   8.985101865875444e-01,  -1.092101082997975e-02,   2.225646361063843e-05,   8.276670179533784e-07,  -5.096437377348761e-09,
  -1.047102742479268e-10,   1.180920524546734e-12,   1.450735450517089e-14,  -2.735064608366621e-16,  -1.866198565221053e-18,   6.254347115081935e-20,   1.574249366337569e-22,
  -1.402475318578000e-23,   1.892682129047390e-26,   8.985124825804011e-01,  -1.092075437066817e-02,   2.225330714068805e-05,   8.275588750434578e-07,  -5.094609280746776e-09,
  -1.046788143238469e-10,   1.180130524603189e-12,   1.450041583994417e-14,  -2.732162892979584e-16,  -1.865302159190168e-18,   6.244809805529982e-20,   1.575752474106226e-22,
  -1.399618173678161e-23,   1.875304174494374e-26,   8.985136616405338e-01,  -1.092062267087714e-02,   2.225168628892677e-05,   8.275033426933542e-07,  -5.093670624121023e-09,
  -1.046626600976480e-10,   1.179724930488007e-12,   1.449685293574557e-14,  -2.730673297261557e-16,  -1.864841701660820e-18,   6.239914462600056e-20,   1.576522582155966e-22,
  -1.398151849036956e-23,   1.866391925464818e-26,   8.985140720165150e-01,  -1.092057683224917e-02,   2.225112215996347e-05,   8.274840148203277e-07,  -5.093343941309000e-09,
  -1.046570377817282e-10,   1.179583777037093e-12,   1.449561290315687e-14,  -2.730154921187183e-16,  -1.864681417684824e-18,   6.238210995030991e-20,   1.576790337382462e-22,
  -1.397641633456977e-23,   1.863291870585870e-26,   8.985141371372136e-01,  -1.092056955832298e-02,   2.225103264157409e-05,   8.274809477848717e-07,  -5.093292102443219e-09,
  -1.046561456123610e-10,   1.179561378749431e-12,   1.449541613033154e-14,  -2.730072666379947e-16,  -1.864655981994125e-18,   6.237940697240216e-20,   1.576832812783765e-22,
  -1.397560676492739e-23,   1.862800026408002e-26,   1.177133819722225e+00,  -1.089138805647054e-02,  -2.859442476355621e-05,   8.340812977971481e-07,   5.871645741955813e-09,
  -1.091362202950545e-10,  -1.317349809259754e-12,   1.611758216501394e-14,   3.058352199644239e-16,  -2.348326551895135e-18,  -7.206126193816878e-20,   2.836425088752347e-22,
   1.697479195942537e-23,  -1.026719506211084e-26,   1.177131145609205e+00,  -1.089115383095847e-02,  -2.859113236789094e-05,   8.339792484029564e-07,   5.869802633494503e-09,
  -1.091046142438747e-10,  -1.316553193347950e-12,   1.610969460837316e-14,   3.055345321574174e-16,  -2.346867187554959e-18,  -7.195776616923662e-20,   2.835620182266303e-22,
   1.694155245980611e-23,  -1.036604690767881e-26,   1.177126427344345e+00,  -1.089074055963958e-02,  -2.858532372452286e-05,   8.337992046900110e-07,   5.866551347894680e-09,
  -1.090488574746040e-10,  -1.315148191716564e-12,   1.609578089237013e-14,   3.050043174123672e-16,  -2.344292459109210e-18,  -7.177531270035921e-20,   2.834194107196510e-22,
   1.688296996489822e-23,  -1.053993812132856e-26,   1.177120722393666e+00,  -1.089024086723900e-02,  -2.857830128387125e-05,   8.335815349067627e-07,   5.862621406794147e-09,
  -1.089814572820806e-10,  -1.313450338919197e-12,   1.607896310102321e-14,   3.043637786404283e-16,  -2.341179656275034e-18,  -7.155497157906822e-20,   2.832459805754307e-22,
   1.681224912722293e-23,  -1.074929975286522e-26,   1.177115184571929e+00,  -1.088975581606833e-02,  -2.857148552027682e-05,   8.333702677734882e-07,   5.858807908608027e-09,
  -1.089160488389427e-10,  -1.311803233789030e-12,   1.606264382413660e-14,   3.037425851890593e-16,  -2.338158417255313e-18,  -7.134136487397191e-20,   2.830765861204141e-22,
   1.674371770278419e-23,  -1.095159423455598e-26,   1.177110723694007e+00,  -1.088936509492872e-02,  -2.856599590441512e-05,   8.332001044676001e-07,   5.855736964771390e-09,
  -1.088633727628670e-10,  -1.310477164357493e-12,   1.604950234484367e-14,   3.032426112241266e-16,  -2.335724989299773e-18,  -7.116949841942321e-20,   2.829393870433002e-22,
   1.668859779790588e-23,  -1.111388082001236e-26,   1.177107776181641e+00,  -1.088910692793764e-02,  -2.856236899012340e-05,   8.330876786396634e-07,   5.853708307923654e-09,
  -1.088285732389751e-10,  -1.309601321158397e-12,   1.604082119507522e-14,   3.029124582114666e-16,  -2.334117240914493e-18,  -7.105603600395519e-20,   2.828483682119722e-22,
   1.665221864778808e-23,  -1.122078497511151e-26,   1.177106262541341e+00,  -1.088897435134283e-02,  -2.856050655876495e-05,   8.330299472524850e-07,   5.852666671226312e-09,
  -1.088107044577016e-10,  -1.309151657388113e-12,   1.603636378413321e-14,   3.027429771202653e-16,  -2.333291652568836e-18,  -7.099779973092947e-20,   2.828015144813925e-22,
   1.663354953345759e-23,  -1.127558285656536e-26,   1.177105735712668e+00,  -1.088892820756254e-02,  -2.855985834837063e-05,   8.330098540555020e-07,   5.852304147996919e-09,
  -1.088044854530582e-10,  -1.308995167471901e-12,   1.603481246478647e-14,   3.026839985416902e-16,  -2.333004309722631e-18,  -7.097753517252691e-20,   2.827851889221145e-22,
   1.662705369695640e-23,  -1.129463945212396e-26,   1.177105652112578e+00,  -1.088892088521418e-02,  -2.855975548753766e-05,   8.330066655770463e-07,   5.852246621880553e-09,
  -1.088034986011050e-10,  -1.308970335611470e-12,   1.603456629762707e-14,   3.026746399693882e-16,  -2.332958712880288e-18,  -7.097431970873958e-20,   2.827825974412279e-22,
   1.662602299777827e-23,  -1.129766269739257e-26,   1.446657105346556e+00,  -9.167089015556176e-03,  -6.751740175732067e-05,   2.225468504552663e-07,   1.029798578080899e-08,
   5.908956439394128e-11,  -1.193935151491525e-12,  -2.229085212128765e-14,   1.407988411553969e-17,   4.675785792000194e-18,   4.420633029541534e-20,  -5.645295275443271e-22,
  -1.567696294326218e-23,  -3.530022658131835e-26,   1.446650787211625e+00,  -9.167026230624941e-03,  -6.751161862584422e-05,   2.226018801848642e-07,   1.029630730043427e-08,
   5.904592899581987e-11,  -1.193894412989257e-12,  -2.227514752595602e-14,   1.426330760418434e-17,   4.672865903979603e-18,   4.411060195286736e-20,  -5.647652964622635e-22,
  -1.564945990845261e-23,  -3.489297137696631e-26,   1.446639639202630e+00,  -9.166915433105119e-03,  -6.750141496669759e-05,   2.226989478282806e-07,   1.029334564342185e-08,
   5.896895874745959e-11,  -1.193822139669485e-12,  -2.224744453842389e-14,   1.458663402358784e-17,   4.667712750021911e-18,   4.394182585264845e-20,  -5.651789116089999e-22,
  -1.560095604144656e-23,  -3.417572458152769e-26,   1.446626159660361e+00,  -9.166781434216231e-03,  -6.748907790136715e-05,   2.228162664979627e-07,   1.028976445828994e-08,
   5.887592828626938e-11,  -1.193734082189917e-12,  -2.221395946303118e-14,   1.497704618497120e-17,   4.661479861619467e-18,   4.373797531460833e-20,  -5.656749679845899e-22,
  -1.554234845660659e-23,  -3.331074108807021e-26,   1.446613074738684e+00,  -9.166651328069673e-03,  -6.747710266194929e-05,   2.229300982173743e-07,   1.028628799219045e-08,
   5.878566071825028e-11,  -1.193647902987176e-12,  -2.218146705210037e-14,   1.535546805363777e-17,   4.655427373256959e-18,   4.354032705840884e-20,  -5.661522534164981e-22,
  -1.548549915400257e-23,  -3.247345553114280e-26,   1.446602534258086e+00,  -9.166546500244656e-03,  -6.746745654642553e-05,   2.230217571551324e-07,   1.028348745851382e-08,
   5.871297442568503e-11,  -1.193577980945554e-12,  -2.215530185067696e-14,   1.565990200569726e-17,   4.650550349593032e-18,   4.338128059924166e-20,  -5.665336884950763e-22,
  -1.543973503590228e-23,  -3.180068489589166e-26,   1.446595569571504e+00,  -9.166477224050559e-03,  -6.746108304574659e-05,   2.230823029855688e-07,   1.028163694631619e-08,
   5.866496032554198e-11,  -1.193531534438389e-12,  -2.213801737701459e-14,   1.586086209724798e-17,   4.647327105481025e-18,   4.327627187297746e-20,  -5.667842378138878e-22,
  -1.540951106459533e-23,  -3.135697905173002e-26,   1.446591992956808e+00,  -9.166441644987571e-03,  -6.745781009682195e-05,   2.231133897464373e-07,   1.028068662923526e-08,
   5.864030764462027e-11,  -1.193507606738661e-12,  -2.212914252702102e-14,   1.596400151972130e-17,   4.645671632308022e-18,   4.322237156231873e-20,  -5.669124445945036e-22,
  -1.539399460441329e-23,  -3.112937725257139e-26,   1.446590748096859e+00,  -9.166429260983234e-03,  -6.745667094063874e-05,   2.231242087562474e-07,   1.028035586418324e-08,
   5.863172782642627e-11,  -1.193499266515636e-12,  -2.212605380166038e-14,   1.599989008091820e-17,   4.645095400607952e-18,   4.320361531481947e-20,  -5.669569945804498e-22,
  -1.538859475386630e-23,  -3.105020011759977e-26,   1.446590550555373e+00,  -9.166427295793993e-03,  -6.745649017336453e-05,   2.231259255355867e-07,   1.028030337639661e-08,
   5.863036636414549e-11,  -1.193497942469011e-12,  -2.212556367523195e-14,   1.600558462381086e-17,   4.645003959192540e-18,   4.320063915836920e-20,  -5.669640605583884e-22,
  -1.538773790972352e-23,  -3.103763777867267e-26,   1.683754384734651e+00,  -6.198141446098696e-03,  -7.270458666089459e-05,  -4.432867499899504e-07,   2.503722192098277e-09,
   1.002537319447625e-10,   1.109764095846590e-12,  -3.244430864614139e-16,  -2.114752094430878e-16,  -3.360416212028902e-18,  -1.263209741890167e-20,   4.856355925684592e-22,
   1.082416780437653e-23,   7.812487939173334e-26,   1.683747571537991e+00,  -6.198265789223850e-03,  -7.270316955158523e-05,  -4.431927693552235e-07,   2.505276215936870e-09,
   1.002529139959279e-10,   1.109207924536323e-12,  -3.357185522575113e-16,  -2.115263635576949e-16,  -3.357890795091661e-18,  -1.256555319151828e-20,   4.861876474257557e-22,
   1.081492553895212e-23,   7.777608026743836e-26,   1.683735549654174e+00,  -6.198485173139571e-03,  -7.270066833075073e-05,  -4.430269397228682e-07,   2.508017679215430e-09,
   1.002514526973201e-10,   1.108226443620659e-12,  -3.556073442378658e-16,  -2.116163979412736e-16,  -3.353432362563005e-18,  -1.244818165941811e-20,   4.871596857501721e-22,
   1.079858907892304e-23,   7.716080102646863e-26,   1.683721012849488e+00,  -6.198750417881354e-03,  -7.269764261880768e-05,  -4.428264179217737e-07,   2.511331600991229e-09,
   1.002496549699440e-10,   1.107039442783242e-12,  -3.796452382568434e-16,  -2.117248800761542e-16,  -3.348037271747024e-18,  -1.230633465059836e-20,   4.883315541372232e-22,
   1.077878661076899e-23,   7.641711105760914e-26,   1.683706900965612e+00,  -6.199007874523621e-03,  -7.269470404424461e-05,  -4.426317560572650e-07,   2.514547562671729e-09,
   1.002478776183833e-10,   1.105886931048598e-12,  -4.029683994599134e-16,  -2.118297860632699e-16,  -3.342795727635493e-18,  -1.216871582615766e-20,   4.894654872890654e-22,
   1.075951228557522e-23,   7.569547852462989e-26,   1.683695532754854e+00,  -6.199215250760705e-03,  -7.269233586004010e-05,  -4.424749398796358e-07,   2.517137485410807e-09,
   1.002464227793340e-10,   1.104958345408607e-12,  -4.217483390990173e-16,  -2.119140057402521e-16,  -3.338570287509186e-18,  -1.205791201787079e-20,   4.903763213190094e-22,
   1.074394906972271e-23,   7.511437761461291e-26,   1.683688020911955e+00,  -6.199352267826175e-03,  -7.269077056220798e-05,  -4.423713189816697e-07,   2.518848461550406e-09,
   1.002454501753811e-10,   1.104344685516208e-12,  -4.341534315293362e-16,  -2.119695140526542e-16,  -3.335776764220683e-18,  -1.198472431020829e-20,   4.909768880773088e-22,
   1.073364753893602e-23,   7.473051298073670e-26,   1.683684163242309e+00,  -6.199422628483408e-03,  -7.268996656961045e-05,  -4.423181048288616e-07,   2.519727006366930e-09,
   1.002449472112644e-10,   1.104029521090763e-12,  -4.405226922408749e-16,  -2.119979761507684e-16,  -3.334341715268847e-18,  -1.194714804331407e-20,   4.912849070586521e-22,
   1.072835176169963e-23,   7.453341626113916e-26,   1.683682820548422e+00,  -6.199447117491919e-03,  -7.268968671077290e-05,  -4.422995831774321e-07,   2.520032772305951e-09,
   1.002447715951618e-10,   1.103919821931823e-12,  -4.427393571563383e-16,  -2.120078756284249e-16,  -3.333842163160074e-18,  -1.193407073255205e-20,   4.913920520855904e-22,
   1.072650765105501e-23,   7.446482070577929e-26,   1.683682607481554e+00,  -6.199451003528847e-03,  -7.268964229999234e-05,  -4.422966440474698e-07,   2.520081292217490e-09,
   1.002447437009662e-10,   1.103902414029748e-12,  -4.430911011614909e-16,  -2.120094462061226e-16,  -3.333762887789544e-18,  -1.193199561243208e-20,   4.914090514970381e-22,
   1.072621497494952e-23,   7.445393580963658e-26,   1.865784488894749e+00,  -2.952068693484639e-03,  -4.490493333872262e-05,  -5.338581567468991e-07,  -4.689619894775456e-09,
  -1.847310868009739e-11,   3.251618304019067e-13,   9.412046328948864e-15,   1.377853275883085e-16,   1.217299578313911e-18,   7.013959220611332e-22,  -2.121602841908617e-22,
  -4.714915292300527e-24,  -6.140367069155909e-26,   1.865780273775355e+00,  -2.952218901212924e-03,  -4.490756863719857e-05,  -5.338753188479428e-07,  -4.689158359067467e-09,
  -1.845451392838249e-11,   3.255235549183203e-13,   9.416125667826968e-15,   1.377873427108525e-16,   1.216188242250513e-18,   6.720644170272217e-22,  -2.126074315787844e-22,
  -4.718343538720731e-24,  -6.137026426557667e-26,   1.865772835930215e+00,  -2.952483949013523e-03,  -4.491221845081231e-05,  -5.339055874529781e-07,  -4.688343558468903e-09,
  -1.842169668090675e-11,   3.261618272552897e-13,   9.423320663401118e-15,   1.377907976850038e-16,   1.214225399721344e-18,   6.202914042242144e-22,  -2.133962277715897e-22,
  -4.724380474964599e-24,  -6.131103528514354e-26,   1.865763841666270e+00,  -2.952804454295288e-03,  -4.491784069350044e-05,  -5.339421643712436e-07,  -4.687357587686526e-09,
  -1.838200260843318e-11,   3.269336392097686e-13,   9.432015704356747e-15,   1.377948036643941e-16,   1.211848717275534e-18,   5.576577910735649e-22,  -2.143497022822812e-22,
  -4.731659482981105e-24,  -6.123893268710047e-26,   1.865755109832258e+00,  -2.953115602235221e-03,  -4.492329829053687e-05,  -5.339776472615567e-07,  -4.686399685843761e-09,
  -1.834345666398216e-11,   3.276829072257962e-13,   9.440451224002061e-15,   1.377985126287070e-16,   1.209538132915872e-18,   4.968237099880255e-22,  -2.152749547481482e-22,
  -4.738703887962020e-24,  -6.116843162006275e-26,   1.865748075323644e+00,  -2.953366263954445e-03,  -4.492769458818035e-05,  -5.340062136511880e-07,  -4.685627483459397e-09,
  -1.831239622543734e-11,   3.282865121991061e-13,   9.447242842516373e-15,   1.378013715375041e-16,   1.207674362072185e-18,   4.477947835906675e-22,  -2.160200642005404e-22,
  -4.744363040033189e-24,  -6.111127491540894e-26,   1.865743426919989e+00,  -2.953531899193214e-03,  -4.493059945033862e-05,  -5.340250809170889e-07,  -4.685116966809402e-09,
  -1.829186796508460e-11,   3.286853657152147e-13,   9.451728699290609e-15,   1.378031974847234e-16,   1.206441643484577e-18,   4.153866929017365e-22,  -2.165122906006248e-22,
  -4.748094799049124e-24,  -6.107332953695225e-26,   1.865741039703428e+00,  -2.953616961568125e-03,  -4.493209119490572e-05,  -5.340347674096242e-07,  -4.684854711962100e-09,
  -1.828132446090819e-11,   3.288901967190083e-13,   9.454031806174495e-15,   1.378041156573737e-16,   1.205808221095487e-18,   3.987402974777749e-22,  -2.167650325330916e-22,
  -4.750008850743132e-24,  -6.105378795021427e-26,   1.865740208804655e+00,  -2.953646568426784e-03,  -4.493261040371224e-05,  -5.340381384440279e-07,  -4.684763419005577e-09,
  -1.827765449711578e-11,   3.289614901263508e-13,   9.454833328834180e-15,   1.378044321249245e-16,   1.205587694940033e-18,   3.929458435980174e-22,  -2.168529953209505e-22,
  -4.750674674125562e-24,  -6.104697759431395e-26,   1.865740076952169e+00,  -2.953651266633201e-03,  -4.493269279468816e-05,  -5.340386733599659e-07,  -4.684748931465150e-09,
  -1.827707211488241e-11,   3.289728034129861e-13,   9.454960514941392e-15,   1.378044821962787e-16,   1.205552697737544e-18,   3.920263187230769e-22,  -2.168669535020260e-22,
  -4.750780313091820e-24,  -6.104589647028726e-26,   1.973912638330066e+00,  -6.116681638696597e-04,  -1.060312819640073e-05,  -1.602089251512863e-07,  -2.211693287259373e-09,
  -2.833884858674604e-11,  -3.374008402159581e-13,  -3.690619420782721e-15,  -3.593708525440434e-17,  -2.853371450063795e-19,  -1.224950541586605e-21,   1.502790283438491e-23,
   5.430645812172556e-25,   1.043797566283754e-26,   1.973911641785882e+00,  -6.117133163505440e-04,  -1.060437495656402e-05,  -1.602355540032405e-07,  -2.212168873247922e-09,
  -2.834612975907918e-11,  -3.374952789903146e-13,  -3.691580321017563e-15,  -3.594214256952806e-17,  -2.852566350533028e-19,  -1.221525925855472e-21,   1.510540002384136e-23,
   5.444517957363954e-25,   1.045913824091458e-26,   1.973909883272617e+00,  -6.117929947141328e-04,  -1.060657510227477e-05,  -1.602825465864921e-07,  -2.213008160230582e-09,
  -2.835897903937263e-11,  -3.376619284216999e-13,  -3.693275621486988e-15,  -3.595105447908050e-17,  -2.851142479000770e-19,  -1.215476137837650e-21,   1.524227116546057e-23,
   5.469014799601622e-25,   1.049650338887472e-26,   1.973907756696956e+00,  -6.118893530458682e-04,  -1.060923591335821e-05,  -1.603393799929046e-07,  -2.214023219215945e-09,
  -2.837451914714413e-11,  -3.378634609701494e-13,  -3.695325215890375e-15,  -3.596181071454001e-17,  -2.849415154863017e-19,  -1.208148727852591e-21,   1.540799237271035e-23,
   5.498669429232026e-25,   1.054172569338484e-26,   1.973905692083793e+00,  -6.119829069415618e-04,  -1.061181937165098e-05,  -1.603945628007610e-07,  -2.215008813809950e-09,
  -2.838960795888238e-11,  -3.380591243954444e-13,  -3.697314526855613e-15,  -3.597223156946163e-17,  -2.847732467851061e-19,  -1.201022891409476e-21,   1.556909708770494e-23,
   5.527491974068797e-25,   1.058566856668487e-26,   1.973904028736233e+00,  -6.120582805504990e-04,  -1.061390085076870e-05,  -1.604390244620271e-07,  -2.215802934218888e-09,
  -2.840176527532557e-11,  -3.382167619872130e-13,  -3.698916802888949e-15,  -3.598061133296484e-17,  -2.846372736178048e-19,  -1.195273438270933e-21,   1.569904256073299e-23,
   5.550735655746846e-25,   1.062109834602350e-26,   1.973902929566034e+00,  -6.121080899114873e-04,  -1.061527639156771e-05,  -1.604684074167317e-07,  -2.216327742518284e-09,
  -2.840979957593980e-11,  -3.383209327918780e-13,  -3.699975417597197e-15,  -3.598614111163660e-17,  -2.845472201313237e-19,  -1.191469906735786e-21,   1.578498737748584e-23,
   5.566106721296934e-25,   1.064452438483861e-26,   1.973902365071062e+00,  -6.121336705839915e-04,  -1.061598283979501e-05,  -1.604834980464880e-07,  -2.216597277622474e-09,
  -2.841392587137023e-11,  -3.383744315527583e-13,  -3.700519023326543e-15,  -3.598897862166457e-17,  -2.845009099803969e-19,  -1.189515251491989e-21,   1.582914864249165e-23,
   5.574004227603630e-25,   1.065655931333702e-26,   1.973902168590474e+00,  -6.121425743595545e-04,  -1.061622873229008e-05,  -1.604887506497710e-07,  -2.216691095116163e-09,
  -2.841536211366491e-11,  -3.383930526155652e-13,  -3.700708223337203e-15,  -3.598996587738920e-17,  -2.844847812161093e-19,  -1.188834699305173e-21,   1.584452327457941e-23,
   5.576753620660968e-25,   1.066074890259405e-26,   1.973902137411572e+00,  -6.121439872750478e-04,  -1.061626775236158e-05,  -1.604895841737090e-07,  -2.216705982818533e-09,
  -2.841559002778618e-11,  -3.383960075374027e-13,  -3.700738246443560e-15,  -3.599012252391623e-17,  -2.844822213241874e-19,  -1.188726694765582e-21,   1.584696320207863e-23,
   5.577189939658179e-25,   1.066141376699213e-26,   7.887871469771502e-03,  -1.572231472064360e-04,   2.341614378374012e-06,  -3.085927076059482e-08,   3.789047267865685e-10,
  -4.434224708136760e-12,   4.999181392449165e-14,  -5.463998824533221e-16,   5.802072876677531e-18,  -5.995114858733300e-20,   6.013807938338611e-22,  -5.850763627648580e-24,
   5.470163063238363e-26,  -4.901114673269913e-28,   7.888091424350846e-03,  -1.572318410358742e-04,   2.341827909808407e-06,  -3.086343691291574e-08,   3.789752084556023e-10,
  -4.435303663542587e-12,   5.000709699297314e-14,  -5.466030078104850e-16,   5.804620889519447e-18,  -5.998145674399355e-20,   6.017208707787673e-22,  -5.854364619299488e-24,
   5.473638312352633e-26,  -4.904205551626469e-28,   7.888479553994937e-03,  -1.572471823891194e-04,   2.342204721664244e-06,  -3.087078897770487e-08,   3.790995919649505e-10,
  -4.437207822871282e-12,   5.003406965258984e-14,  -5.469615089694709e-16,   5.809118066165171e-18,  -6.003495107704977e-20,   6.023211168799179e-22,  -5.860720463864721e-24,
   5.479771816496465e-26,  -4.909659826728727e-28,   7.888948912350884e-03,  -1.572657349448977e-04,   2.342660421633092e-06,  -3.087968057727137e-08,   3.792500276690749e-10,
  -4.439510907843276e-12,   5.006669456642776e-14,  -5.473951544133968e-16,   5.814558091996770e-18,  -6.009966277176745e-20,   6.030472392848138e-22,  -5.868409153364968e-24,
   5.487190855297377e-26,  -4.916255822678205e-28,   7.889404586477718e-03,  -1.572837471493915e-04,   2.343102864926119e-06,  -3.088831385897307e-08,   3.793960992956541e-10,
  -4.441747284349724e-12,   5.009837599405985e-14,  -5.478162786539399e-16,   5.819841261206877e-18,  -6.016251076356713e-20,   6.037524588946375e-22,  -5.875876482481493e-24,
   5.494395580203794e-26,  -4.922659752320852e-28,   7.889771692522786e-03,  -1.572982587684734e-04,   2.343459332801339e-06,  -3.089526977238763e-08,   3.795137950921612e-10,
  -4.443549296893101e-12,   5.012390511036250e-14,  -5.481556374701658e-16,   5.824098808815741e-18,  -6.021315963771733e-20,   6.043207986238369e-22,  -5.881894417699396e-24,
   5.500201368627445e-26,  -4.927819136294752e-28,   7.890014279888686e-03,  -1.573078483859176e-04,   2.343694900652597e-06,  -3.089986663216032e-08,   3.795915773439501e-10,
  -4.444740238747201e-12,   5.014077770905241e-14,  -5.483799319372783e-16,   5.826912852669133e-18,  -6.024663698731822e-20,   6.046964570773694e-22,  -5.885872113736257e-24,
   5.504038589838937e-26,  -4.931228589327340e-28,   7.890138863272646e-03,  -1.573127732982904e-04,   2.343815882272332e-06,  -3.090222749922831e-08,   3.796315256436976e-10,
  -4.445351907490506e-12,   5.014944365156886e-14,  -5.484951340258818e-16,   5.828358225318478e-18,  -6.026383213907109e-20,   6.048894095926507e-22,  -5.887915207146723e-24,
   5.506009452387859e-26,  -4.932979575455335e-28,   7.890182226164088e-03,  -1.573144874885909e-04,   2.343857992029096e-06,  -3.090304924604486e-08,   3.796454305552544e-10,
  -4.445564814447009e-12,   5.015246008031302e-14,  -5.485352337387322e-16,   5.828861336564732e-18,  -6.026981753574681e-20,   6.049565738837995e-22,  -5.888626381222016e-24,
   5.506695471470572e-26,  -4.933589033137460e-28,   7.890189107281672e-03,  -1.573147595083814e-04,   2.343864674314838e-06,  -3.090317964715384e-08,   3.796476370988527e-10,
  -4.445598600325868e-12,   5.015293875399183e-14,  -5.485415971329531e-16,   5.828941175102460e-18,  -6.027076735792064e-20,   6.049672321882218e-22,  -5.888739237445241e-24,
   5.506804335260238e-26,  -4.933685746195923e-28,   7.053668164067939e-02,  -1.370373437723995e-03,   1.932733849254731e-05,  -2.312374152281096e-07,   2.422214293829447e-09,
  -2.191272451948563e-11,   1.583091192097135e-13,  -6.259249587726039e-16,  -5.780607123352487e-18,   1.834096833860416e-19,  -2.886575209211474e-21,   3.427003260797677e-23,
  -3.201991493202098e-25,   2.008516027873561e-27,   7.053849631278750e-02,  -1.370438545517603e-03,   1.932870224090714e-05,  -2.312579686344846e-07,   2.422436732757703e-09,
  -2.191394687681899e-11,   1.582936921321797e-13,  -6.253013290433669e-16,  -5.792848524298209e-18,   1.835869520723705e-19,  -2.888555984593470e-21,   3.428455779467600e-23,
  -3.201900281287616e-25,   2.005590882025401e-27,   7.054169843441199e-02,  -1.370553433946887e-03,   1.933110869805989e-05,  -2.312942363725273e-07,   2.422829212014672e-09,
  -2.191610274513442e-11,   1.582664446473368e-13,  -6.242004377391184e-16,  -5.814455462533637e-18,   1.838998061865518e-19,  -2.892051043139963e-21,   3.431017021647142e-23,
  -3.201734868958291e-25,   2.000421354074889e-27,   7.054557065166983e-02,  -1.370692366282624e-03,   1.933401878519279e-05,  -2.313380932926387e-07,   2.423303771871888e-09,
  -2.191870793778734e-11,   1.582334520760784e-13,  -6.228683980010802e-16,  -5.840594386789627e-18,   1.842782162207616e-19,  -2.896277217158022e-21,   3.434111116107617e-23,
  -3.201527227278239e-25,   1.994156555743888e-27,   7.054932991911902e-02,  -1.370827247787400e-03,   1.933684402901721e-05,  -2.313806704893607e-07,   2.423764434659055e-09,
  -2.192123522616586e-11,   1.582013767191659e-13,  -6.215744073471973e-16,  -5.865981732151338e-18,   1.846456784480278e-19,  -2.900379819492401e-21,   3.437111677354364e-23,
  -3.201317661709656e-25,   1.988060394897175e-27,   7.055235846933654e-02,  -1.370935912591000e-03,   1.933912013881948e-05,  -2.314149713127221e-07,   2.424135515872982e-09,
  -2.192326989556177e-11,   1.581755037308829e-13,  -6.205313621833190e-16,  -5.886442138533006e-18,   1.849417788026015e-19,  -2.903684753664225e-21,   3.439526643381107e-23,
  -3.201143107837452e-25,   1.983139084203758e-27,   7.055435974661267e-02,  -1.371007719303781e-03,   1.934062421533703e-05,  -2.314376372669386e-07,   2.424380708588666e-09,
  -2.192461374132160e-11,   1.581583909160722e-13,  -6.198418313821687e-16,  -5.899966265934461e-18,   1.851374746006418e-19,  -2.905868560985543e-21,   3.441121308480524e-23,
  -3.201024957756543e-25,   1.979882114224743e-27,   7.055538751842935e-02,  -1.371044596397820e-03,   1.934139665029798e-05,  -2.314492774986519e-07,   2.424506623333506e-09,
  -2.192530367630892e-11,   1.581495975926617e-13,  -6.194876299473560e-16,  -5.906912868458298e-18,   1.852379854917652e-19,  -2.906990039807852e-21,   3.441939904429102e-23,
  -3.200963413181079e-25,   1.978207940564933e-27,   7.055574524703456e-02,  -1.371057431953176e-03,   1.934166550649640e-05,  -2.314533290165021e-07,   2.424550448564678e-09,
  -2.192554378359307e-11,   1.581465361880360e-13,  -6.193643318687856e-16,  -5.909330906589448e-18,   1.852729710957717e-19,  -2.907380379063496e-21,   3.442224769953963e-23,
  -3.200941853664194e-25,   1.977624980118923e-27,   7.055580201378998e-02,  -1.371059468785924e-03,   1.934170817042123e-05,  -2.314539719379444e-07,   2.424557402999235e-09,
  -2.192558188384495e-11,   1.581460503469299e-13,  -6.193447654484805e-16,  -5.909714625885075e-18,   1.852785229179659e-19,  -2.907442320445718e-21,   3.442269971611671e-23,
  -3.200938425896380e-25,   1.977532460504816e-27,   1.933657400689988e-01,  -3.561779001216292e-03,   4.457813255995793e-05,  -4.189562215388309e-07,   2.538796300131238e-09,
   2.477404420445649e-12,  -3.337203680650464e-13,   5.398740768301855e-15,  -5.064356816871453e-17,   1.605020937761094e-19,   4.275657725511495e-21,  -1.018024934690454e-22,
   1.238912531962645e-24,  -7.664552704661552e-27,   1.933699221220997e-01,  -3.561896823907031e-03,   4.457955797137851e-05,  -4.189538095341850e-07,   2.538325439721819e-09,
   2.488041537298883e-12,  -3.338529288146338e-13,   5.399268714373132e-15,  -5.062528456745344e-17,   1.599750470330862e-19,   4.283302720453163e-21,  -1.018573828813442e-22,
   1.238468226964681e-24,  -7.643616769251952e-27,   1.933773015290244e-01,  -3.562104723334452e-03,   4.458207291659192e-05,  -4.189495454038970e-07,   2.537494447703701e-09,
   2.506811735862800e-12,  -3.340867951775674e-13,   5.400198835817392e-15,  -5.059299666202558e-17,   1.590448358385570e-19,   4.296790171154144e-21,  -1.019541112675735e-22,
   1.237681685955330e-24,  -7.606646734280353e-27,   1.933862249716079e-01,  -3.562356116580594e-03,   4.458511364744570e-05,  -4.189443753430850e-07,   2.536489345126532e-09,
   2.529510288705982e-12,  -3.343695220643423e-13,   5.401321079721205e-15,  -5.055390910822377e-17,   1.579196245457504e-19,   4.313095472993549e-21,  -1.020708632793595e-22,
   1.236726230998632e-24,  -7.561894042170621e-27,   1.933948878887992e-01,  -3.562600163782494e-03,   4.458806515113893e-05,  -4.189393418554902e-07,   2.535513338649835e-09,
   2.551547144454822e-12,  -3.346439184119976e-13,   5.402407948738312e-15,  -5.051591681270417e-17,   1.568268809776931e-19,   4.328920316360300e-21,  -1.021839809278167e-22,
   1.235794125134975e-24,  -7.518398544254273e-27,   1.934018667609344e-01,  -3.562796764310007e-03,   4.459044256810604e-05,  -4.189352765666084e-07,   2.534726886888032e-09,
   2.569300817575245e-12,  -3.348649183378040e-13,   5.403281663082973e-15,  -5.048527720427583e-17,   1.559462890178277e-19,   4.341665686469763e-21,  -1.022749470209576e-22,
   1.235039960896165e-24,  -7.483323085039872e-27,   1.934064783432267e-01,  -3.562926674081047e-03,   4.459201338771955e-05,  -4.189325852152527e-07,   2.534207118775372e-09,
   2.581032651196140e-12,  -3.350109265569784e-13,   5.403858090425249e-15,  -5.046501469179124e-17,   1.553642667208688e-19,   4.350086168101797e-21,  -1.023349774063704e-22,
   1.234540020673940e-24,  -7.460128206834720e-27,   1.934088466323908e-01,  -3.562993388854476e-03,   4.459282003694701e-05,  -4.189312015062114e-07,   2.533940163664563e-09,
   2.587057670632988e-12,  -3.350859011546230e-13,   5.404153832750762e-15,  -5.045460384910494e-17,   1.550653262829639e-19,   4.354410044819302e-21,  -1.023657816304143e-22,
   1.234282782052484e-24,  -7.448211074453763e-27,   1.934096709404658e-01,  -3.563016609524810e-03,   4.459310079194196e-05,  -4.189307196434449e-07,   2.533847242826776e-09,
   2.589154759527473e-12,  -3.351119955382809e-13,   5.404256723885387e-15,  -5.045097945237707e-17,   1.549612703013196e-19,   4.355914939040266e-21,  -1.023764994610742e-22,
   1.234193168928185e-24,  -7.444062339568892e-27,   1.934098017469635e-01,  -3.563020294324560e-03,   4.459314534357705e-05,  -4.189306431665841e-07,   2.533832497348004e-09,
   2.589487539873465e-12,  -3.351161363000632e-13,   5.404273049169766e-15,  -5.045040427219414e-17,   1.549447577166843e-19,   4.356153741671338e-21,  -1.023782000498520e-22,
   1.234178944815513e-24,  -7.443403951286192e-27,   3.712177012343481e-01,  -6.278971706593360e-03,   6.354040945576314e-05,  -3.221363928795187e-07,  -2.128387070261500e-09,
   6.629996547552905e-11,  -6.446347654376471e-13,  -1.767428908947980e-16,   9.961103741744846e-17,  -1.466884144489566e-18,   6.073854152466004e-21,   1.518226484037151e-22,
  -3.414548857183428e-24,   2.700395164322372e-26,   3.712236557223588e-01,  -6.279062088355890e-03,   6.353920714259897e-05,  -3.220742404459636e-07,  -2.129290487034873e-09,
   6.629953914051579e-11,  -6.443727738015110e-13,  -1.816729833505626e-16,   9.963598485110025e-17,  -1.466093816984255e-18,   6.052799969075730e-21,   1.520158960783460e-22,
  -3.412977201894094e-24,   2.692750644386924e-26,   3.712341624180402e-01,  -6.279221554189204e-03,   6.353708522965925e-05,  -3.219645718466177e-07,  -2.130884280435325e-09,
   6.629877898473657e-11,  -6.439104326000257e-13,  -1.903700351141316e-16,   9.967993284279640e-17,  -1.464698465865630e-18,   6.015657513521569e-21,   1.523564301631932e-22,
  -3.410197052808746e-24,   2.679261687113459e-26,   3.712468670696800e-01,  -6.279414357752027e-03,   6.353451868669785e-05,  -3.218319600010131e-07,  -2.132811001375357e-09,
   6.629784636097258e-11,  -6.433512746915022e-13,  -2.008828947853707e-16,   9.973295222537689e-17,  -1.463009819728848e-18,   5.970758093667029e-21,   1.527674326943045e-22,
  -3.406823445913052e-24,   2.662950582875088e-26,   3.712592003611002e-01,  -6.279601502743583e-03,   6.353202639499189e-05,  -3.217032233466711e-07,  -2.134680893473958e-09,
   6.629692691972521e-11,  -6.428083597730096e-13,  -2.110847118147057e-16,   9.978429374544182e-17,  -1.461369075523214e-18,   5.927184822145253e-21,   1.531656153443383e-22,
  -3.403536040723878e-24,   2.647115960243447e-26,   3.712691357824188e-01,  -6.279752246137776e-03,   6.353001810978510e-05,  -3.215995152270437e-07,  -2.136186870698593e-09,
   6.629617615354781e-11,  -6.423709272473825e-13,  -2.193003778854718e-16,   9.982556155379882e-17,  -1.460046285779827e-18,   5.892093034350083e-21,   1.534858046769704e-22,
  -3.400878898630732e-24,   2.634359756761335e-26,   3.712757008741187e-01,  -6.279851845787228e-03,   6.352869081249195e-05,  -3.215309869733217e-07,  -2.137181805817984e-09,
   6.629567512789199e-11,  -6.420818466998230e-13,  -2.247277794837221e-16,   9.985278542398488e-17,  -1.459171707240667e-18,   5.868910044731439e-21,   1.536970953994479e-22,
  -3.399118776302784e-24,   2.625930675897739e-26,   3.712790723449845e-01,  -6.279902992220478e-03,   6.352800910197809e-05,  -3.214957945057421e-07,  -2.137692694524828e-09,
   6.629541630193394e-11,  -6.419333798317611e-13,  -2.275145878929490e-16,   9.986675221851150e-17,  -1.458722413968246e-18,   5.857006030377448e-21,   1.538055152540290e-22,
  -3.398213530897281e-24,   2.621601938839853e-26,   3.712802458134524e-01,  -6.279920793766768e-03,   6.352777181368004e-05,  -3.214835454562370e-07,  -2.137870504770670e-09,
   6.629532597237392e-11,  -6.418817029595825e-13,  -2.284844948867652e-16,   9.987161126606602e-17,  -1.458566008608050e-18,   5.852862977698656e-21,   1.538432377610046e-22,
  -3.397898238942209e-24,   2.620095282330797e-26,   3.712804320266020e-01,  -6.279923618606195e-03,   6.352773415869173e-05,  -3.214816017013057e-07,  -2.137898720368843e-09,
   6.629531162678989e-11,  -6.418735024748229e-13,  -2.286384025787783e-16,   9.987238222445377e-17,  -1.458541188057974e-18,   5.852205544099498e-21,   1.538492231379394e-22,
  -3.397848196340716e-24,   2.619856196699564e-26,   5.958215492964882e-01,  -8.896462686157956e-03,   6.155255039106440e-05,   1.496502063613850e-07,  -8.030079631148055e-09,
   5.726272512589158e-11,   6.069529388867396e-13,  -1.540943982850914e-14,   6.100230382862043e-17,   2.054431777948987e-18,  -3.379010760803100e-20,  -9.878529114878613e-24,
   6.604700208952889e-24,  -7.354328149405188e-26,   5.958273107791475e-01,  -8.896420408978960e-03,   6.154803830946151e-05,   1.497036360288738e-07,  -8.029224250539927e-09,
   5.723249810461568e-11,   6.071101564882674e-13,  -1.540250807613502e-14,   6.086105883960898e-17,   2.054360407392303e-18,  -3.374943577794923e-20,  -1.040541066654144e-23,
   6.600514177059837e-24,  -7.334531124138512e-26,   5.958374766627614e-01,  -8.896345798057469e-03,   6.154007706198349e-05,   1.497978905143383e-07,  -8.027714739377423e-09,
   5.717917314322030e-11,   6.073872687799941e-13,  -1.539027710065799e-14,   6.061196915769428e-17,   2.054232275360261e-18,  -3.367769086519742e-20,  -1.133392812482107e-23,
   6.593117465034771e-24,  -7.299625706670766e-26,   5.958497687727231e-01,  -8.896255556979803e-03,   6.153045090405334e-05,   1.499118248283873e-07,  -8.025889118019079e-09,
   5.711471094467379e-11,   6.077218435121232e-13,  -1.537548763769403e-14,   6.031100476068146e-17,   2.054073593074663e-18,  -3.359097228448305e-20,  -1.245470182326527e-23,
   6.584155597836227e-24,  -7.257463314424064e-26,   5.958617011275905e-01,  -8.896167930774641e-03,   6.152110669571931e-05,   1.500223892281678e-07,  -8.024116518011598e-09,
   5.705215196495376e-11,   6.080461065375017e-13,  -1.536113066870987e-14,   6.001908238583880e-17,   2.053915631020388e-18,  -3.350682527229834e-20,  -1.354063702848863e-23,
   6.575437100675324e-24,  -7.216580569134037e-26,   5.958713132385165e-01,  -8.896097324677724e-03,   6.151357962399240e-05,   1.501114290566124e-07,  -8.022688306579615e-09,
   5.700176945569848e-11,   6.083069445160783e-13,  -1.534956516121673e-14,   5.978409163032294e-17,   2.053785576038335e-18,  -3.343906470984849e-20,  -1.441395401896134e-23,
   6.568400390916372e-24,  -7.183680199937647e-26,   5.958776645352550e-01,  -8.896050661806657e-03,   6.150860611440237e-05,   1.501702505892089e-07,  -8.021744458398437e-09,
   5.696848453943508e-11,   6.084791136150415e-13,  -1.534192301849035e-14,   5.962890111613433e-17,   2.053698266914624e-18,  -3.339430305637329e-20,  -1.499029312259404e-23,
   6.563744207816857e-24,  -7.161956989451158e-26,   5.958809261635618e-01,  -8.896026695833342e-03,   6.150605205512501e-05,   1.502004538078655e-07,  -8.021259712728696e-09,
   5.695139329112163e-11,   6.085674725632488e-13,  -1.533799845571609e-14,   5.954923032220697e-17,   2.053653005733924e-18,  -3.337131992733376e-20,  -1.528604416274488e-23,
   6.561351042920775e-24,  -7.150806267589994e-26,   5.958820613925816e-01,  -8.896018353881758e-03,   6.150516310348328e-05,   1.502109656058535e-07,  -8.021090987073563e-09,
   5.694544486772138e-11,   6.085982174526225e-13,  -1.533663248260485e-14,   5.952150446461312e-17,   2.053637184724164e-18,  -3.336332109523595e-20,  -1.538894694259131e-23,
   6.560517763072685e-24,  -7.146925982431478e-26,   5.958822415372901e-01,  -8.896017030111121e-03,   6.150502203967403e-05,   1.502126336497723e-07,  -8.021064212375434e-09,
   5.694450095109102e-11,   6.086030958039593e-13,  -1.533641572181285e-14,   5.951710495660045e-17,   2.053634670946612e-18,  -3.336205182191196e-20,  -1.540527448395898e-23,
   6.560385517998211e-24,  -7.146310273816922e-26,   8.552174206784194e-01,  -1.070654104712429e-02,   3.166882362645067e-05,   7.316172022601248e-07,  -6.897331198645323e-09,
  -7.261526665349573e-11,   1.464662624813538e-12,   5.148024827074320e-15,  -2.977601145667599e-16,   6.045100835121908e-19,   5.622481202798449e-20,  -4.382829876391324e-22,
  -9.411700784443818e-24,   1.477558686377775e-25,   8.552203818599593e-01,  -1.070633551965788e-02,   3.166495545462157e-05,   7.315492110900281e-07,  -6.895280699262099e-09,
  -7.260510009358561e-11,   1.463885860906941e-12,   5.150007367418327e-15,  -2.975247713741280e-16,   6.022912778976511e-19,   5.616705256427336e-20,  -4.372237296100525e-22,
  -9.401437554882034e-24,   1.473702463376827e-25,   8.552256066179996e-01,  -1.070597287873640e-02,   3.165813094003606e-05,   7.314292473574496e-07,  -6.891663446943339e-09,
  -7.258715789350539e-11,   1.462515749883415e-12,   5.153499533081688e-15,  -2.971097022911179e-16,   5.983805792236905e-19,   5.606518666834732e-20,  -4.353569322057288e-22,
  -9.383331595520172e-24,   1.466907358626538e-25,   8.552319239510729e-01,  -1.070553439593187e-02,   3.164988025884179e-05,   7.312841991576444e-07,  -6.887290937274369e-09,
  -7.256545663728069e-11,   1.460859851139485e-12,   5.157711976061262e-15,  -2.966081332654825e-16,   5.936592483935614e-19,   5.594209728498035e-20,  -4.331034647580726e-22,
  -9.361443960442838e-24,   1.458706420488607e-25,   8.552380561849533e-01,  -1.070510875213539e-02,   3.164187231002025e-05,   7.311434027297075e-07,  -6.883047761839557e-09,
  -7.254438383287808e-11,   1.459253227386316e-12,   5.161790545238823e-15,  -2.961215714278304e-16,   5.890837368560455e-19,   5.582269632248500e-20,  -4.309198999770418e-22,
  -9.340202436858711e-24,   1.450761590442206e-25,   8.552429958576264e-01,  -1.070476587888833e-02,   3.163542240664570e-05,   7.310299888858670e-07,  -6.879630647506576e-09,
  -7.252740384888604e-11,   1.457959592532352e-12,   5.165068458558207e-15,  -2.957298561312479e-16,   5.854034006004424e-19,   5.572657442338560e-20,  -4.291637559118212e-22,
  -9.323095303341625e-24,   1.444373145299349e-25,   8.552462597216449e-01,  -1.070453932407828e-02,   3.163116101091652e-05,   7.309550518996018e-07,  -6.877373233645855e-09,
  -7.251618181850793e-11,   1.457105095092810e-12,   5.167230663976488e-15,  -2.954711412733314e-16,   5.829742573008375e-19,   5.566309107760995e-20,  -4.280047493404348e-22,
  -9.311793554946622e-24,   1.440157549476425e-25,   8.552479358151855e-01,  -1.070442298035006e-02,   3.162897276136526e-05,   7.309165696750932e-07,  -6.876214115043310e-09,
  -7.251041816348894e-11,   1.456666366679190e-12,   5.168339891150711e-15,  -2.953383170396784e-16,   5.817276282139474e-19,   5.563049932783177e-20,  -4.274099835302065e-22,
  -9.305990292222766e-24,   1.437994424000427e-25,   8.552485191858488e-01,  -1.070438248632872e-02,   3.162821114989201e-05,   7.309031758238206e-07,  -6.875810700487718e-09,
  -7.250841197423215e-11,   1.456513678662942e-12,   5.168725781814454e-15,  -2.952920924334162e-16,   5.812938631749608e-19,   5.561915706052592e-20,  -4.272030397897273e-22,
  -9.303970529217725e-24,   1.437241812381851e-25,   8.552486117583095e-01,  -1.070437606050795e-02,   3.162809029400855e-05,   7.309010504154511e-07,  -6.875746685449105e-09,
  -7.250809361505390e-11,   1.456489449909895e-12,   5.168787008518753e-15,  -2.952847575138587e-16,   5.812250370751280e-19,   5.561735727437789e-20,  -4.271702039882570e-22,
  -9.303650026143122e-24,   1.437122396763870e-25,   1.133176169843223e+00,  -1.107868667375346e-02,  -1.809890100809849e-05,   9.090201569377033e-07,   3.414626299160512e-09,
  -1.343283468534861e-10,  -7.455080994864164e-13,   2.403379431018518e-14,   1.745364370890302e-16,  -4.751665394892755e-18,  -4.287303257535349e-20,   9.935131265682128e-22,
   1.079869840893616e-23,  -2.162215529120162e-25,   1.133174476918368e+00,  -1.107843145443159e-02,  -1.809698616902368e-05,   9.088946198096967e-07,   3.413583299267494e-09,
  -1.342812831101648e-10,  -7.450536277705118e-13,   2.401788919866818e-14,   1.743576752521134e-16,  -4.746602980892886e-18,  -4.280729143252178e-20,   9.919574108887920e-22,
   1.077540464146980e-23,  -2.157596627246659e-25,   1.133171489871030e+00,  -1.107798114455261e-02,  -1.809360788101739e-05,   9.086731433628623e-07,   3.411743427663966e-09,
  -1.341982637863621e-10,  -7.442520854917567e-13,   2.398983822514270e-14,   1.740424717133288e-16,  -4.737676767297414e-18,  -4.269140672480439e-20,   9.892150575684229e-22,
   1.073435706894481e-23,  -2.149457241137209e-25,   1.133167878149029e+00,  -1.107743667384559e-02,  -1.808952362995083e-05,   9.084053926894180e-07,   3.409519518396421e-09,
  -1.340979192127753e-10,  -7.432834999726626e-13,   2.395594228458179e-14,   1.736617068037593e-16,  -4.726894162074852e-18,  -4.255147627717469e-20,   9.859036276603101e-22,
   1.068481496932558e-23,  -2.139633297025207e-25,   1.133164372211035e+00,  -1.107690816221419e-02,  -1.808555955865916e-05,   9.081455288451472e-07,   3.407361510205436e-09,
  -1.340005517405422e-10,  -7.423438920458051e-13,   2.392306138654813e-14,   1.732924671037278e-16,  -4.716438175513496e-18,  -4.241584193174133e-20,   9.826938158776729e-22,
   1.063681766741638e-23,  -2.130115505414107e-25,   1.133161548058677e+00,  -1.107648243672921e-02,  -1.808236676249748e-05,   9.079362316656897e-07,   3.405623708954256e-09,
  -1.339221462168246e-10,  -7.415874417018201e-13,   2.389659064514280e-14,   1.729952989593788e-16,  -4.708023258677034e-18,  -4.230672532261678e-20,   9.801115165612737e-22,
   1.059822128629680e-23,  -2.122461778104220e-25,   1.133159682000022e+00,  -1.107620114283701e-02,  -1.808025731736411e-05,   9.077979542155914e-07,   3.404475724911157e-09,
  -1.338703531242707e-10,  -7.410878304256976e-13,   2.387910790416231e-14,   1.727990757500529e-16,  -4.702466887689572e-18,  -4.223469572898852e-20,   9.784068831203231e-22,
   1.057275153254608e-23,  -2.117411022400349e-25,   1.133158723717729e+00,  -1.107605669050675e-02,  -1.807917410840656e-05,   9.077269490542717e-07,   3.403886280373417e-09,
  -1.338437598031415e-10,  -7.408313295955857e-13,   2.387013235534789e-14,   1.726983490822446e-16,  -4.699614679123747e-18,  -4.219772756036592e-20,   9.775319989095515e-22,
   1.055968211602616e-23,  -2.114819285205643e-25,   1.133158390183277e+00,  -1.107600641343273e-02,  -1.807879710226280e-05,   9.077022361601089e-07,   3.403681134753610e-09,
  -1.338345045357796e-10,  -7.407420638262919e-13,   2.386700875919884e-14,   1.726632971408586e-16,  -4.698622141365451e-18,  -4.218486402736776e-20,   9.772275712575515e-22,
   1.055513486005524e-23,  -2.113917536341829e-25,   1.133158337256166e+00,  -1.107599843519540e-02,  -1.807873727727564e-05,   9.076983146164935e-07,   3.403648581726195e-09,
  -1.338330358894175e-10,  -7.407278991331816e-13,   2.386651310772185e-14,   1.726577352079261e-16,  -4.698464648765009e-18,  -4.218282293160910e-20,   9.771792667599351e-22,
   1.055441335261949e-23,  -2.113774456831926e-25,   1.408929443245517e+00,  -9.693666270115779e-03,  -6.382485004325187e-05,   3.950028693898929e-07,   1.114363996353489e-08,
   2.316259494621564e-11,  -1.784379597286754e-12,  -1.886765397504319e-14,   2.062328023617745e-16,   5.726921842727381e-18,   3.125234631929466e-21,  -1.272289666779397e-21,
  -1.177510705332842e-23,   1.982092811650983e-25,   1.408923472232084e+00,  -9.693555100447440e-03,  -6.381859588242617e-05,   3.950242748291801e-07,   1.114113708963571e-08,
   2.312575369463630e-11,  -1.783838018880114e-12,  -1.884849497633578e-14,   2.062437098241125e-16,   5.720417785581265e-18,   3.054140507118935e-21,  -1.270845184168343e-21,
  -1.173689889258423e-23,   1.981213487885807e-25,   1.408912936759790e+00,  -9.693358934974999e-03,  -6.380756146018490e-05,   3.950620170777043e-07,   1.113672134846161e-08,
   2.306077730824279e-11,  -1.782882373345837e-12,  -1.881470642631116e-14,   2.062627139176102e-16,   5.708947324496944e-18,   2.928884987133250e-21,  -1.268296906005465e-21,
  -1.166957240233269e-23,   1.979653431084056e-25,   1.408900197963712e+00,  -9.693121721335093e-03,  -6.379422046749870e-05,   3.951076077056105e-07,   1.113138284284917e-08,
   2.298225929224654e-11,  -1.781726759539302e-12,  -1.877387929756195e-14,   2.062852811843113e-16,   5.695087434717343e-18,   2.777750337196166e-21,  -1.265216414979820e-21,
  -1.158831791839931e-23,   1.977752579140996e-25,   1.408887832208702e+00,  -9.692891429800935e-03,  -6.378127130302263e-05,   3.951518163649690e-07,   1.112620141964895e-08,
   2.290608992105372e-11,  -1.780604871346398e-12,  -1.873427679222444e-14,   2.063067575060134e-16,   5.681643292703484e-18,   2.631372061470769e-21,  -1.262226889270089e-21,
  -1.150960214966254e-23,   1.975892218601126e-25,   1.408877871124604e+00,  -9.692705903750098e-03,  -6.377084108620208e-05,   3.951873945235060e-07,   1.112202812470022e-08,
   2.284476794039152e-11,  -1.779701065672887e-12,  -1.870239627788739e-14,   2.063237497206782e-16,   5.670820602821255e-18,   2.513695398399576e-21,  -1.259819258323876e-21,
  -1.144630761511646e-23,   1.974382789761389e-25,   1.408871289315023e+00,  -9.692583308413581e-03,  -6.376394970034210e-05,   3.952108864323588e-07,   1.111927087362982e-08,
   2.280426659268543e-11,  -1.779103833826164e-12,  -1.868134133630742e-14,   2.063348268238290e-16,   5.663672949372140e-18,   2.436055998077179e-21,  -1.258228678784960e-21,
  -1.140454137329507e-23,   1.973380138005222e-25,   1.408867909332826e+00,  -9.692520348906466e-03,  -6.376041086525541e-05,   3.952229452394016e-07,   1.111785501323442e-08,
   2.278347312570488e-11,  -1.778797122654220e-12,  -1.867053205888962e-14,   2.063404687673806e-16,   5.660003458436541e-18,   2.396221303372273e-21,  -1.257411945527235e-21,
  -1.138311023044561e-23,   1.972863608265794e-25,   1.408866732913708e+00,  -9.692498435124493e-03,  -6.375917917652463e-05,   3.952271415561041e-07,   1.111736222915547e-08,
   2.277623671032267e-11,  -1.778690368380953e-12,  -1.866677033887249e-14,   2.063424250692249e-16,   5.658726444944219e-18,   2.382362337835308e-21,  -1.257127690847346e-21,
  -1.137565376104307e-23,   1.972683567699883e-25,   1.408866546232890e+00,  -9.692494957702025e-03,  -6.375898372615856e-05,   3.952278074128752e-07,   1.111728403201552e-08,
   2.277508843554325e-11,  -1.778673427917644e-12,  -1.866617343172571e-14,   2.063427351548025e-16,   5.658523809340634e-18,   2.380163389248297e-21,  -1.257082584342961e-21,
  -1.137447065666185e-23,   1.972654985514935e-25,   1.657766029860809e+00,  -6.800213179621260e-03,  -7.771285995747523e-05,  -3.857577682538681e-07,   4.769969134571265e-09,
   1.259003070501941e-10,   9.873462354133649e-13,  -9.073314560445709e-15,  -3.349149969797119e-16,  -3.274007258375911e-18,   2.120277165507051e-20,   1.063939038861499e-21,
   1.215584596233629e-23,  -5.204880670330147e-26,   1.657758749696434e+00,  -6.800321258604278e-03,  -7.771016908195571e-05,  -3.856398887629630e-07,   4.771347216222044e-09,
   1.258822708232101e-10,   9.864689886379727e-13,  -9.084221786692205e-15,  -3.348231843100135e-16,  -3.268537299816164e-18,   2.127651317294868e-20,   1.063532694144922e-21,
   1.212405062164100e-23,  -5.251727477985349e-26,   1.657745903937693e+00,  -6.800511938745434e-03,  -7.770542036192383e-05,  -3.854319023439649e-07,   4.773777860818920e-09,
   1.258504282285622e-10,   9.849212702492965e-13,  -9.103452762168686e-15,  -3.346609277790090e-16,  -3.258887201435959e-18,   2.140647140893365e-20,   1.062812926195143e-21,
   1.206795718717459e-23,  -5.334250093877585e-26,   1.657730371059955e+00,  -6.800742465302888e-03,  -7.769967708870717e-05,  -3.851804264781720e-07,   4.776715313633009e-09,
   1.258118941906552e-10,   9.830500894965208e-13,  -9.126681495638327e-15,  -3.344642967716039e-16,  -3.247221156305801e-18,   2.156334580388300e-20,   1.061937863990543e-21,
   1.200014548328059e-23,  -5.433799797358853e-26,   1.657715292378706e+00,  -6.800966208424343e-03,  -7.769410049816393e-05,  -3.849363227171022e-07,   4.779565152944215e-09,
   1.257744550040498e-10,   9.812339328350219e-13,  -9.149204778108711e-15,  -3.342729623663023e-16,  -3.235899068196875e-18,   2.171535144432757e-20,   1.061083442558498e-21,
   1.193433309066952e-23,  -5.530192211884774e-26,   1.657703145452581e+00,  -6.801146418533265e-03,  -7.768960726691779e-05,  -3.847396935759194e-07,   4.781859664736987e-09,
   1.257442722786717e-10,   9.797711140587280e-13,  -9.167330063995225e-15,  -3.341185048986808e-16,  -3.226780374199490e-18,   2.183760082208438e-20,   1.060391607266228e-21,
   1.188132851361305e-23,  -5.607666498804793e-26,   1.657695119109164e+00,  -6.801265481300963e-03,  -7.768663782697876e-05,  -3.846097731992996e-07,   4.783375209759027e-09,
   1.257243172059499e-10,   9.788046336804043e-13,  -9.179297541372598e-15,  -3.340162851418307e-16,  -3.220755999823277e-18,   2.191828097152845e-20,   1.059932731200832e-21,
   1.184631045701842e-23,  -5.658772887436541e-26,   1.657690997237663e+00,  -6.801326620514575e-03,  -7.768511275604230e-05,  -3.845430555474136e-07,   4.784153320597347e-09,
   1.257140659623133e-10,   9.783083382030821e-13,  -9.185440510359012e-15,  -3.339637418767150e-16,  -3.217662534937431e-18,   2.195968314646284e-20,   1.059696543775536e-21,
   1.182832900526618e-23,  -5.684991484848188e-26,   1.657689562588891e+00,  -6.801347899747621e-03,  -7.768458192180459e-05,  -3.845198342840916e-07,   4.784424118308929e-09,
   1.257104973884467e-10,   9.781356041396942e-13,  -9.187578164788670e-15,  -3.339454459888264e-16,  -3.216585880275821e-18,   2.197408862680315e-20,   1.059614251826161e-21,
   1.182207071488396e-23,  -5.694112812880798e-26,   1.657689334930191e+00,  -6.801351276429434e-03,  -7.768449768480413e-05,  -3.845161494096547e-07,   4.784467088709773e-09,
   1.257099310795424e-10,   9.781081939134711e-13,  -9.187917359165566e-15,  -3.339425423167962e-16,  -3.216415032579360e-18,   2.197637434429889e-20,   1.059601189204424e-21,
   1.182107762553114e-23,  -5.695560038127930e-26,   1.853215328191266e+00,  -3.338233769629763e-03,  -5.177198596547758e-05,  -6.113246786234321e-07,  -4.956950931407257e-09,
  -6.968392360719582e-12,   6.569261387480610e-13,   1.450502022940050e-14,   1.791682176722885e-16,   9.798921127517886e-19,  -1.483093620658343e-20,  -5.228252662210486e-22,
  -8.328180165906496e-24,  -7.192094465612882e-26,   1.853210468990452e+00,  -3.338405726469013e-03,  -5.177476899605875e-05,  -6.113309708984918e-07,  -4.956021586749816e-09,
  -6.939784340484695e-12,   6.573951230169616e-13,   1.450825648561820e-14,   1.791039966191832e-16,   9.771763499169997e-19,  -1.488236734963341e-20,  -5.233397902714038e-22,
  -8.326082664895480e-24,  -7.171506924981934e-26,   1.853201894642550e+00,  -3.338709148418540e-03,  -5.177967927106672e-05,  -6.113420518964632e-07,  -4.954381207799497e-09,
  -6.889299892971110e-12,   6.582225150909526e-13,   1.451395944433554e-14,   1.789905012462326e-16,   9.723821983986764e-19,  -1.497310750531662e-20,  -5.242464459769155e-22,
  -8.322349467808224e-24,  -7.135134303527850e-26,   1.853191526088642e+00,  -3.339076051868119e-03,  -5.178561610113848e-05,  -6.113554139494092e-07,  -4.952396730772045e-09,
  -6.828244793881317e-12,   6.592227707890161e-13,   1.452084278828638e-14,   1.788529608239197e-16,   9.665814048311711e-19,  -1.508281276591331e-20,  -5.253406845118535e-22,
  -8.317780468807752e-24,  -7.091074498753930e-26,   1.853181460098178e+00,  -3.339432237880439e-03,  -5.179137871155638e-05,  -6.113683466316480e-07,  -4.950469278592070e-09,
  -6.768964391593400e-12,   6.601935546196844e-13,   1.452751167870432e-14,   1.787191242059067e-16,   9.609462725920819e-19,  -1.518929300476228e-20,  -5.264007516864269e-22,
  -8.313287596668129e-24,  -7.048220797723285e-26,   1.853173350796480e+00,  -3.339719178484305e-03,  -5.179602044984405e-05,  -6.113787371098256e-07,  -4.948915863141203e-09,
  -6.721202308259653e-12,   6.609754281809054e-13,   1.453287448789763e-14,   1.786110816683675e-16,   9.564039478981467e-19,  -1.527505786501710e-20,  -5.272531495939561e-22,
  -8.309627090671771e-24,  -7.013640301503372e-26,   1.853167992181853e+00,  -3.339908784596148e-03,  -5.179908736055325e-05,  -6.113855892801643e-07,  -4.947889058509789e-09,
  -6.689638764405955e-12,   6.614919894129203e-13,   1.453641345331386e-14,   1.785395786837749e-16,   9.534011226007340e-19,  -1.533172274657992e-20,  -5.278156254383559e-22,
  -8.307188165280208e-24,  -6.990761701292839e-26,   1.853165240235859e+00,  -3.340006156676456e-03,  -5.180066228328263e-05,  -6.113891039689316e-07,  -4.947361641491491e-09,
  -6.673428382277683e-12,   6.617572414310535e-13,   1.453822943270469e-14,   1.785028243395738e-16,   9.518586145984661e-19,  -1.536082069802360e-20,  -5.281042443406514e-22,
  -8.305929435267159e-24,  -6.979003661045246e-26,   1.853164282389330e+00,  -3.340040047963605e-03,  -5.180121043639959e-05,  -6.113903266153319e-07,  -4.947178052658430e-09,
  -6.667786052440732e-12,   6.618495605422024e-13,   1.453886127030191e-14,   1.784900262184864e-16,   9.513216647520081e-19,  -1.537094815922133e-20,  -5.282046626739779e-22,
  -8.305490331685567e-24,  -6.974909769529427e-26,   1.853164130391967e+00,  -3.340045426046152e-03,  -5.180129742012511e-05,  -6.113905206005170e-07,  -4.947148918855287e-09,
  -6.666890684908816e-12,   6.618642101103438e-13,   1.453896152327603e-14,   1.784879950749149e-16,   9.512364550826324e-19,  -1.537255523133404e-20,  -5.282205958706155e-22,
  -8.305420604944601e-24,  -6.974260058974621e-26,   1.971283229838633e+00,  -7.048309162927042e-04,  -1.275818857481986e-05,  -2.006078013925432e-07,  -2.868529754842888e-09,
  -3.781625314568675e-11,  -4.584395327523184e-13,  -5.012573877240547e-15,  -4.684535810563180e-17,  -3.111132996287244e-19,   2.505930443877804e-22,   5.874847188113504e-23,
   1.394897921942360e-24,   2.403347954775008e-26,   1.971282030514288e+00,  -7.048874623132453e-04,  -1.275980576763524e-05,  -2.006433371877839e-07,  -2.869175888007977e-09,
  -3.782613818567591e-11,  -4.585624730415911e-13,  -5.013615777472138e-15,  -4.684401826184045e-17,  -3.108034357850226e-19,   2.593624234310139e-22,   5.892653974765323e-23,
   1.397881328869341e-24,   2.407554919509486e-26,   1.971279914163887e+00,  -7.049872467975486e-04,  -1.276265962567103e-05,  -2.007060481978557e-07,  -2.870316140704164e-09,
  -3.784358215816861e-11,  -4.587794000881189e-13,  -5.015453371503997e-15,  -4.684162388670897e-17,  -3.102559272978452e-19,   2.748511750521185e-22,   5.924099374295273e-23,
   1.403148871206596e-24,   2.414980634282275e-26,   1.971277354839386e+00,  -7.051079211452396e-04,  -1.276611104583062e-05,  -2.007818918790404e-07,  -2.871695186114392e-09,
  -3.786467843227593e-11,  -4.590417053833988e-13,  -5.017673950043463e-15,  -4.683867705435076e-17,  -3.095925965965218e-19,   2.936060021319530e-22,   5.962166200042395e-23,
   1.409524020598355e-24,   2.423964072225328e-26,   1.971274870070502e+00,  -7.052250842528961e-04,  -1.276946215317355e-05,  -2.008555330775235e-07,  -2.873034190501201e-09,
  -3.788516129883112e-11,  -4.592963413141856e-13,  -5.019828118765126e-15,  -4.683576231531807e-17,  -3.089473078368182e-19,   3.118397521799843e-22,   5.999165556497739e-23,
   1.415718747860396e-24,   2.432689408483462e-26,   1.971272868214671e+00,  -7.053194797475819e-04,  -1.277216214030402e-05,  -2.009148671182410e-07,  -2.874113054842124e-09,
  -3.790166415607061e-11,  -4.595014687213685e-13,  -5.021562391215810e-15,  -4.683337551305564e-17,  -3.084265117122102e-19,   3.265478998066211e-22,   6.029003822573204e-23,
   1.420713324577600e-24,   2.439721548988796e-26,   1.971271545346470e+00,  -7.053818597106435e-04,  -1.277394642910722e-05,  -2.009540787200245e-07,  -2.874826037223229e-09,
  -3.791256999090531e-11,  -4.596370112894882e-13,  -5.022707829503349e-15,  -4.683177938229376e-17,  -3.080819086607274e-19,   3.362762237363763e-22,   6.048736121052777e-23,
   1.424015700495830e-24,   2.444369788011369e-26,   1.971270865966374e+00,  -7.054138963843090e-04,  -1.277486280412468e-05,  -2.009742172149638e-07,  -2.875192215019088e-09,
  -3.791817098070927e-11,  -4.597066182715345e-13,  -5.023295900364029e-15,  -4.683095382203975e-17,  -3.079047930202264e-19,   3.412751044538511e-22,   6.058874457790905e-23,
   1.425712261986835e-24,   2.446757352339408e-26,   1.971270629498093e+00,  -7.054250472931671e-04,  -1.277518176597064e-05,  -2.009812268351839e-07,  -2.875319670889041e-09,
  -3.792012050772596e-11,  -4.597308455213153e-13,  -5.023500557294574e-15,  -4.683066554335975e-17,  -3.078431231332159e-19,   3.430154757542080e-22,   6.062403972095577e-23,
   1.426302866586301e-24,   2.447588440918268e-26,   1.971270591973652e+00,  -7.054268168007557e-04,  -1.277523238125617e-05,  -2.009823391764187e-07,  -2.875339896586035e-09,
  -3.792042987324576e-11,  -4.597346900475449e-13,  -5.023533032271780e-15,  -4.683061975311704e-17,  -3.078333358715962e-19,   3.432916707916089e-22,   6.062964094121692e-23,
   1.426396592189114e-24,   2.447720326786634e-26,   7.294236523401240e-03,  -1.398747559571955e-04,   2.004949203205186e-06,  -2.544593003017516e-08,   3.010795663962601e-10,
  -3.398871133045414e-12,   3.699788608446770e-14,  -3.910835092438398e-16,   4.021202265984913e-18,  -4.035468262565958e-20,   3.936731767271403e-22,  -3.752275613387579e-24,
   3.428892116087661e-26,  -3.094109347296760e-28,   7.294424827593088e-03,  -1.398819238589595e-04,   2.005118854585986e-06,  -2.544912295957218e-08,   3.011317198630047e-10,
  -3.399643252783529e-12,   3.700847618261756e-14,  -3.912202130426769e-16,   4.022869930134266e-18,  -4.037411879240732e-20,   3.938863351481465e-22,  -3.754549263859387e-24,
   3.431039767154556e-26,  -3.096120094599671e-28,   7.294757106272818e-03,  -1.398945724657937e-04,   2.005418231000926e-06,  -2.545475752298224e-08,   3.012237575980162e-10,
  -3.401005889287042e-12,   3.702716614086887e-14,  -3.914614824457560e-16,   4.025813281785515e-18,  -4.040842375752817e-20,   3.942625647364058e-22,  -3.758562350014791e-24,
   3.434830764410343e-26,  -3.099667097504800e-28,   7.295158923320303e-03,  -1.399098685435283e-04,   2.005780280889669e-06,  -2.546157190211102e-08,   3.013350712832132e-10,
  -3.402653977512699e-12,   3.704977231515894e-14,  -3.917533190542972e-16,   4.029373662468120e-18,  -4.044992196314820e-20,   3.947176901157042e-22,  -3.763417052358850e-24,
   3.439417324302782e-26,  -3.103954479532257e-28,   7.295549023517641e-03,  -1.399247190171999e-04,   2.006131795310586e-06,  -2.546818823582902e-08,   3.014431543337281e-10,
  -3.404254304345796e-12,   3.707172436307444e-14,  -3.920367243711543e-16,   4.032831326060507e-18,  -4.049022475050477e-20,   3.951597112688463e-22,  -3.768132044596460e-24,
   3.443872440511398e-26,  -3.108114824496230e-28,   7.295863299761064e-03,  -1.399366833016287e-04,   2.006415001323207e-06,  -2.547351902238792e-08,   3.015302401496160e-10,
  -3.405543787258000e-12,   3.708941320903341e-14,  -3.922651003709787e-16,   4.035617712046300e-18,  -4.052270436957550e-20,   3.955159363144607e-22,  -3.771931907689032e-24,
   3.447463262410359e-26,  -3.111465075410901e-28,   7.296070976031171e-03,  -1.399445895459506e-04,   2.006602153778761e-06,  -2.547704188047964e-08,   3.015877925034317e-10,
  -3.406395991921045e-12,   3.710110391721681e-14,  -3.924160406417568e-16,   4.037459365219882e-18,  -4.054417230661108e-20,   3.957513913359357e-22,  -3.774443536876869e-24,
   3.449836914258606e-26,  -3.113678240354008e-28,   7.296177630246291e-03,  -1.399486499224528e-04,   2.006698270148755e-06,  -2.547885115089010e-08,   3.016173507408812e-10,
  -3.406833682265896e-12,   3.710710834618291e-14,  -3.924935660479468e-16,   4.038405284199236e-18,  -4.055519897015602e-20,   3.958723297448998e-22,  -3.775733609735079e-24,
   3.451056176750719e-26,  -3.114814614365209e-28,   7.296214752622731e-03,  -1.399500631962446e-04,   2.006731725068531e-06,  -2.547948090220968e-08,   3.016276391302520e-10,
  -3.406986031160972e-12,   3.710919835267648e-14,  -3.925205511241683e-16,   4.038734542563624e-18,  -4.055903719603540e-20,   3.959144268075315e-22,  -3.776182668195081e-24,
   3.451480596607633e-26,  -3.115210109168514e-28,   7.296220643451611e-03,  -1.399502874644027e-04,   2.006737033938539e-06,  -2.547958083593430e-08,   3.016292717737131e-10,
  -3.407010207153473e-12,   3.710953001314540e-14,  -3.925248333623887e-16,   4.038786792404416e-18,  -4.055964628361016e-20,   3.959211071902571e-22,  -3.776253929334516e-24,
   3.451547948300875e-26,  -3.115272867295361e-28,   6.534773913117371e-02,  -1.226227280435073e-03,   1.677121135047306e-05,  -1.957878513700193e-07,   2.020449575356931e-09,
  -1.833914664735934e-11,   1.390430616731645e-13,  -7.248509836120267e-16,  -9.312661474425342e-19,   9.394871423336575e-20,  -1.680552445897953e-21,   2.134034475364948e-23,
  -2.211707106173694e-25,   1.715582227782034e-27,   6.534931371285695e-02,  -1.226282406264114e-03,   1.677234895463289e-05,  -1.958050562366527e-07,   2.020645073395684e-09,
  -1.834056859909704e-11,   1.390404696337291e-13,  -7.245310242970423e-16,  -9.384000904478618e-19,   9.405923687960357e-20,  -1.681924304071621e-21,   2.135285849055311e-23,
  -2.212436590740104e-25,   1.715015414309741e-27,   6.535209217388872e-02,  -1.226379680594245e-03,   1.677435636449646e-05,  -1.958354155771739e-07,   2.020990029744265e-09,
  -1.834307714179707e-11,   1.390358806877278e-13,  -7.239661474242091e-16,  -9.509927535326783e-19,   9.425430825641567e-20,  -1.684345334256416e-21,   2.137493578045375e-23,
  -2.213721840863039e-25,   1.714013315726941e-27,   6.535545206679905e-02,  -1.226497312467632e-03,   1.677678389843168e-05,  -1.958721282619111e-07,   2.021407149491685e-09,
  -1.834610962252101e-11,   1.390303056729903e-13,  -7.232825744644757e-16,  -9.662279653904239e-19,   9.449028003523897e-20,  -1.687273491263268e-21,   2.140162607732825e-23,
  -2.215272672148090e-25,   1.712798242519433e-27,   6.535871394781807e-02,  -1.226611514485236e-03,   1.677914066602994e-05,  -1.959077702333253e-07,   2.021812076708664e-09,
  -1.834905258464453e-11,   1.390248662966722e-13,  -7.226184312967993e-16,  -9.810264544360759e-19,   9.471945094484307e-20,  -1.690116745309429e-21,   2.142753047378825e-23,
  -2.216774723791648e-25,   1.711615182805869e-27,   6.536134178791121e-02,  -1.226703519183437e-03,   1.678103936176451e-05,  -1.959364843264362e-07,   2.022138276919391e-09,
  -1.835142273885219e-11,   1.390204648761802e-13,  -7.220830175019848e-16,  -9.929539506240542e-19,   9.490413509851877e-20,  -1.692407698849246e-21,   2.144839435398514e-23,
  -2.217982267951047e-25,   1.710659622220806e-27,   6.536307827226209e-02,  -1.226764316715798e-03,   1.678229404209804e-05,  -1.959554587654088e-07,   2.022353822298941e-09,
  -1.835298857232916e-11,   1.390175469311806e-13,  -7.217290352527691e-16,  -1.000838378357063e-18,   9.502620392274983e-20,  -1.693921747596264e-21,   2.146217869436217e-23,
  -2.218778971301073e-25,   1.710026977559734e-27,   6.536397005689755e-02,  -1.226795539920614e-03,   1.678293839780701e-05,  -1.959652032573003e-07,   2.022464514573617e-09,
  -1.835379260307264e-11,   1.390160454682849e-13,  -7.215471895547266e-16,  -1.004888321861437e-18,   9.508890225560608e-20,  -1.694699354364441e-21,   2.146925695027471e-23,
  -2.219187738859852e-25,   1.709701704358034e-27,   6.536428045338660e-02,  -1.226806407564439e-03,   1.678316267447026e-05,  -1.959685949503049e-07,   2.022503041939306e-09,
  -1.835407243746621e-11,   1.390155223993262e-13,  -7.214838871204698e-16,  -1.006298087080608e-18,   9.511072660048961e-20,  -1.694970018707160e-21,   2.147172049655130e-23,
  -2.219329953986546e-25,   1.709588429529249e-27,   6.536432970916178e-02,  -1.226808132115608e-03,   1.678319826421886e-05,  -1.959691331668575e-07,   2.022509155697159e-09,
  -1.835411684257708e-11,   1.390154393731231e-13,  -7.214738414509522e-16,  -1.006521804302986e-18,   9.511418990016617e-20,  -1.695012969941637e-21,   2.147211142240662e-23,
  -2.219352518711672e-25,   1.709570451500610e-27,   1.798010101088011e-01,  -3.224572106347510e-03,   3.979474046881309e-05,  -3.783260876808840e-07,   2.519575726083815e-09,
  -3.894714070187400e-12,  -2.041858311973552e-13,   3.895829705465994e-15,  -4.271803954489012e-17,   2.579606165754274e-19,   9.567988050204229e-22,  -5.244407773645451e-23,
   8.163256214169986e-25,  -7.903566837924456e-27,   1.798047437001611e-01,  -3.224678522970266e-03,   3.979615609839692e-05,  -3.783296743525716e-07,   2.519287265394597e-09,
  -3.887030451408540e-12,  -2.042978786089908e-13,   3.896693204629223e-15,  -4.271384029423824e-17,   2.576879688854784e-19,   9.618594585895424e-22,  -5.250153237541682e-23,
   8.165355186869937e-25,  -7.897440409383553e-27,   1.798113317886544e-01,  -3.224866297586947e-03,   3.979865386687619e-05,  -3.783359972306783e-07,   2.518778143895047e-09,
  -3.873471206385080e-12,  -2.044955789719839e-13,   3.898216112754341e-15,  -4.270641328452764e-17,   2.572066372375855e-19,   9.707901048147718e-22,  -5.260287522928608e-23,
   8.169047444686332e-25,  -7.886605035603802e-27,   1.798192983594581e-01,  -3.225093358042868e-03,   3.980167396977123e-05,  -3.783436329290658e-07,   2.518162290365844e-09,
  -3.857072872260898e-12,  -2.047346248940386e-13,   3.900056350722763e-15,  -4.269740285233607e-17,   2.566241958829724e-19,   9.815909127836039e-22,  -5.272535730883863e-23,
   8.173492698635534e-25,  -7.873459831203865e-27,   1.798270323609658e-01,  -3.225313785850328e-03,   3.980460559725687e-05,  -3.783510350670046e-07,   2.517564201751927e-09,
  -3.841151193324750e-12,  -2.049666703056929e-13,   3.901841482156618e-15,  -4.268862466750619e-17,   2.560583427030366e-19,   9.920780040795242e-22,  -5.284419491578721e-23,
   8.177787686538200e-25,  -7.860653717310266e-27,   1.798332629099053e-01,  -3.225491360661657e-03,   3.980696710901546e-05,  -3.783569906336540e-07,   2.517082225508706e-09,
  -3.828323133965617e-12,  -2.051535914190182e-13,   3.903278600506304e-15,  -4.268153085290485e-17,   2.556021913187190e-19,   1.000527593209825e-21,  -5.293988165456539e-23,
   8.181233061325693e-25,  -7.850305055979808e-27,   1.798373800131701e-01,  -3.225608699440641e-03,   3.980852747104816e-05,  -3.783609222938291e-07,   2.516763663978479e-09,
  -3.819845718507653e-12,  -2.052770998461710e-13,   3.904227752349130e-15,  -4.267683250470639e-17,   2.553006241269991e-19,   1.006111578393312e-21,  -5.300308655432548e-23,
   8.183502547795274e-25,  -7.843451069300739e-27,   1.798394943635731e-01,  -3.225668958674841e-03,   3.980932876598157e-05,  -3.783629402537434e-07,   2.516600042583478e-09,
  -3.815491893412288e-12,  -2.053405255639018e-13,   3.904715041737161e-15,  -4.267441631258880e-17,   2.551457084145716e-19,   1.008979421819986e-21,  -5.303553811412514e-23,
   8.184665824350261e-25,  -7.839926340727600e-27,   1.798402302859176e-01,  -3.225689932478089e-03,   3.980960765994042e-05,  -3.783636424423601e-07,   2.516543088709350e-09,
  -3.813976462274819e-12,  -2.053626011839474e-13,   3.904884624104457e-15,  -4.267357479898505e-17,   2.550917811752784e-19,   1.009977632776989e-21,  -5.304683203284871e-23,
   8.185070361011773e-25,  -7.838698750037995e-27,   1.798403470668162e-01,  -3.225693260732992e-03,   3.980965191637697e-05,  -3.783637538614391e-07,   2.516534050726427e-09,
  -3.813735982209431e-12,  -2.053661042674344e-13,   3.904911533390759e-15,  -4.267344123692864e-17,   2.550832233134858e-19,   1.010136036616872e-21,  -5.304862416789121e-23,
   8.185134538678563e-25,  -7.838503911433530e-27,   3.470932872970207e-01,  -5.786594568635864e-03,   5.951149229858073e-05,  -3.464190037647849e-07,  -9.558394850783600e-10,
   5.108269429566173e-11,  -6.124998942112644e-13,   2.223166570198619e-15,   5.238537530822726e-17,  -1.133340203777410e-18,   9.668212800612831e-21,   2.341227899288882e-23,
  -1.938497929850799e-24,   2.698234882099544e-26,   3.470988653993102e-01,  -5.786691829970114e-03,   5.951094978817196e-05,  -3.463710776046034e-07,  -9.566991740180040e-10,
   5.108701036579287e-11,  -6.123615496711012e-13,   2.219344930001621e-15,   5.242577559088581e-17,  -1.133211872364660e-18,   9.656171175590343e-21,   2.360814174544876e-23,
  -1.939523828247313e-24,   2.695622989561195e-26,   3.471087080067736e-01,  -5.786863438162137e-03,   5.950999212724467e-05,  -3.462865078687833e-07,  -9.582159502044980e-10,
   5.109462002431006e-11,  -6.121173525653817e-13,   2.212601943370600e-15,   5.249702118393449e-17,  -1.132984609982603e-18,   9.634918433991900e-21,   2.395358870150133e-23,
  -1.941328956132022e-24,   2.691009230819952e-26,   3.471206097216258e-01,  -5.787070929929285e-03,   5.950883344375235e-05,  -3.461842396644132e-07,  -9.600497819005495e-10,
   5.110381127828933e-11,  -6.118219202593895e-13,   2.204448863195668e-15,   5.258310161407023e-17,  -1.132708404869440e-18,   9.609210705167524e-21,   2.437104073633814e-23,
  -1.943503063829012e-24,   2.685421653468300e-26,   3.471321636257418e-01,  -5.787272339770232e-03,   5.950770791266954e-05,  -3.460849536265635e-07,  -9.618297508528810e-10,
   5.111272307062900e-11,  -6.115349662951319e-13,   2.196534636206273e-15,   5.266659316119805e-17,  -1.132438807361680e-18,   9.584245012855020e-21,   2.477601701204797e-23,
  -1.945604568206247e-24,   2.679988368875150e-26,   3.471414712471474e-01,  -5.787434578893098e-03,   5.950680069709947e-05,  -3.460049659075025e-07,  -9.632634677826907e-10,
   5.111989447234980e-11,  -6.113036900601741e-13,   2.190159499318495e-15,   5.273379994587527e-17,  -1.132220575739977e-18,   9.564126489941656e-21,   2.510206059509155e-23,
  -1.947291005585240e-24,   2.675604974808583e-26,   3.471476215313631e-01,  -5.787541776747752e-03,   5.950620097925804e-05,  -3.459521094030978e-07,  -9.642107430145747e-10,
   5.112462937699503e-11,  -6.111508130791081e-13,   2.185947148929699e-15,   5.277818307664425e-17,  -1.132075859512347e-18,   9.550829359114403e-21,   2.531740636864468e-23,
  -1.948402187184606e-24,   2.672705371316399e-26,   3.471507799884841e-01,  -5.787596825851456e-03,   5.950589291939125e-05,  -3.459249644269363e-07,  -9.646971834339115e-10,
   5.112705979269915e-11,  -6.110722868117780e-13,   2.183783975616900e-15,   5.280096792248633e-17,  -1.132001382295105e-18,   9.543999667415970e-21,   2.542796639861166e-23,
  -1.948971846734328e-24,   2.671215317584914e-26,   3.471518793171191e-01,  -5.787615985857994e-03,   5.950578568422502e-05,  -3.459155162687945e-07,  -9.648664885826036e-10,
   5.112790553258859e-11,  -6.110449523793791e-13,   2.183031074516656e-15,   5.280889712058488e-17,  -1.131975434585705e-18,   9.541622374974455e-21,   2.546644299975404e-23,
  -1.949169965083928e-24,   2.670696536612925e-26,   3.471520537653720e-01,  -5.787619026271104e-03,   5.950576866690617e-05,  -3.459140169714442e-07,  -9.648933547456501e-10,
   5.112803973091013e-11,  -6.110406146558108e-13,   2.182911600012190e-15,   5.281015531453549e-17,  -1.131971315843803e-18,   9.541245124015395e-21,   2.547254847713354e-23,
  -1.949201396290155e-24,   2.670614205902165e-26,   5.612289495895123e-01,  -8.398951782767797e-03,   6.261743283975331e-05,   3.098048970795684e-08,  -6.772708782000853e-09,
   6.693169420015378e-11,   2.120964789545039e-13,  -1.253071633122012e-14,   1.112735231390570e-16,   7.732154322168535e-19,  -2.866537830645223e-20,   2.106205796958670e-22,
   2.598880258538165e-24,  -7.233127120379984e-26,   5.612348123181611e-01,  -8.398942849276676e-03,   6.261362490327908e-05,   3.104303102556786e-08,  -6.772407100909450e-09,
   6.690706641225651e-11,   2.123860861846297e-13,  -1.252807903584092e-14,   1.111531140001110e-16,   7.742810744979564e-19,  -2.864914560630206e-20,   2.100963707332273e-22,
   2.602184855866849e-24,  -7.224599228326976e-26,   5.612451569052156e-01,  -8.398927071726283e-03,   6.260690587813126e-05,   3.115336740793739e-08,  -6.771874449742963e-09,
   6.686361452728643e-11,   2.128968460540797e-13,  -1.252342257754343e-14,   1.109407059860157e-16,   7.761592244202640e-19,  -2.862048628509066e-20,   2.091719038739388e-22,
   2.608001603004138e-24,  -7.209543258670151e-26,   5.612576651961539e-01,  -8.398907969024080e-03,   6.259878139767246e-05,   3.128675536133801e-08,  -6.771229799554723e-09,
   6.681107926657128e-11,   2.135140248276172e-13,  -1.251778698225399e-14,   1.106839551378775e-16,   7.784265661883575e-19,  -2.858580310006858e-20,   2.080548953637103e-22,
   2.615010969314888e-24,  -7.191323192805139e-26,   5.612698075109099e-01,  -8.398889398987844e-03,   6.259089454051041e-05,   3.141621259224241e-08,  -6.770603395306045e-09,
   6.676008651260299e-11,   2.141127132375159e-13,  -1.251231085910090e-14,   1.104348055919744e-16,   7.806237506496906e-19,  -2.855210397671827e-20,   2.069714308599755e-22,
   2.621790112385895e-24,  -7.173620627816242e-26,   5.612795888309462e-01,  -8.398874420966191e-03,   6.258454116860714e-05,   3.152047766384803e-08,  -6.770098350349779e-09,
   6.671901283824909e-11,   2.145946807100695e-13,  -1.250789565431053e-14,   1.102341654507391e-16,   7.823909724886005e-19,  -2.852493546070230e-20,   2.060992568426155e-22,
   2.627233100204353e-24,  -7.159349078991573e-26,   5.612860519714159e-01,  -8.398864514825624e-03,   6.258034306065909e-05,   3.158936242038668e-08,  -6.769764419168613e-09,
   6.669187474335976e-11,   2.149129956011082e-13,  -1.250497635003266e-14,   1.101016210383838e-16,   7.835573500938848e-19,  -2.850697275406006e-20,   2.055232586071616e-22,
   2.630820824704716e-24,  -7.149913523621648e-26,   5.612893710471478e-01,  -8.398859424786780e-03,   6.257818715827668e-05,   3.162473440669436e-08,  -6.769592865691484e-09,
   6.667793885520138e-11,   2.150764158588300e-13,  -1.250347658642736e-14,   1.100335639734383e-16,   7.841559168899154e-19,  -2.849774488315630e-20,   2.052275545760427e-22,
   2.632660540504952e-24,  -7.145066319025115e-26,   5.612905262729125e-01,  -8.398857652712506e-03,   6.257743678099590e-05,   3.163704537222138e-08,  -6.769533144771081e-09,
   6.667308847260452e-11,   2.151332878691775e-13,  -1.250295449065860e-14,   1.100098778135988e-16,   7.843641860672672e-19,  -2.849453253519440e-20,   2.051246477832988e-22,
   2.633300432386911e-24,  -7.143378951389123e-26,   5.612907095909070e-01,  -8.398857371487854e-03,   6.257731770665933e-05,   3.163899892545068e-08,  -6.769523667401125e-09,
   6.667231878990158e-11,   2.151423122986096e-13,  -1.250287163701119e-14,   1.100061192281338e-16,   7.843972323142064e-19,  -2.849402275594240e-20,   2.051083186380785e-22,
   2.633401953622912e-24,  -7.143111177347019e-26,   8.129507823146427e-01,  -1.042004670709307e-02,   3.974443505014060e-05,   6.115814201931305e-07,  -7.991867866807079e-09,
  -3.677576494102464e-11,   1.481524459965954e-12,  -3.642548209398294e-15,  -2.411615541538485e-16,   2.363909557327043e-18,   2.990112341940996e-20,  -6.913522356628531e-22,
  -1.105187988304658e-24,   1.517508679828290e-25,   8.129544993476299e-01,  -1.041987482181702e-02,   3.973995134717306e-05,   6.115468838638696e-07,  -7.989791928699809e-09,
  -3.678281095345751e-11,   1.480894011858051e-12,  -3.634661679154389e-15,  -2.410356418757190e-16,   2.360387325145797e-18,   2.989393590927489e-20,  -6.902565887529137e-22,
  -1.112767633594952e-24,   1.514961807543634e-25,   8.129610577705624e-01,  -1.041957153544601e-02,   3.973204073023311e-05,   6.114859386347627e-07,  -7.986129622956098e-09,
  -3.679523117532466e-11,   1.479781844808405e-12,  -3.620755405632044e-15,  -2.408134926346012e-16,   2.354176869609209e-18,   2.988121563943288e-20,  -6.883248125109047e-22,
  -1.126111783365475e-24,   1.510470880864167e-25,   8.129689877055440e-01,  -1.041920481180115e-02,   3.972247674301867e-05,   6.114122339262012e-07,  -7.981702350666377e-09,
  -3.681022840445074e-11,   1.478437458400297e-12,  -3.603956207861262e-15,  -2.405449100363759e-16,   2.346674922911835e-18,   2.986576981322759e-20,  -6.859914614069447e-22,
  -1.142196149541760e-24,   1.505045640053689e-25,   8.129766853417431e-01,  -1.041884881694704e-02,   3.971319388103309e-05,   6.113406731641540e-07,  -7.977405715940518e-09,
  -3.682476502089809e-11,   1.477132830777898e-12,  -3.587665017970925e-15,  -2.402842194614925e-16,   2.339400328089496e-18,   2.985070802870621e-20,  -6.837289777541884e-22,
  -1.157756699942822e-24,   1.499784395388870e-25,   8.129828860221974e-01,  -1.041856204223422e-02,   3.970571693970643e-05,   6.112830179391299e-07,  -7.973945323085858e-09,
  -3.683645946566341e-11,   1.476082183208689e-12,  -3.574553349310439e-15,  -2.400742426757373e-16,   2.333545855528878e-18,   2.983852636425952e-20,  -6.819082788940837e-22,
  -1.170253532748330e-24,   1.495549936925478e-25,   8.129869831083313e-01,  -1.041837255156410e-02,   3.970077690320881e-05,   6.112449170636221e-07,  -7.971659207612187e-09,
  -3.684417908469805e-11,   1.475388102173660e-12,  -3.565895412533816e-15,  -2.399355095303235e-16,   2.329680185349231e-18,   2.983045343047874e-20,  -6.807061373353779e-22,
  -1.178492367623339e-24,   1.492753808007599e-25,   8.129890870922160e-01,  -1.041827524056953e-02,   3.969824014150997e-05,   6.112253494116906e-07,  -7.970485317228667e-09,
  -3.684814104794168e-11,   1.475031710354425e-12,  -3.561451008901282e-15,  -2.398642683070765e-16,   2.327695863200953e-18,   2.982630033098355e-20,  -6.800890719107121e-22,
  -1.182717578953495e-24,   1.491318457733825e-25,   8.129898193925863e-01,  -1.041824137083052e-02,   3.969735722756806e-05,   6.112185385474201e-07,  -7.970076756105635e-09,
  -3.684951965866459e-11,   1.474907673196666e-12,  -3.559904389758004e-15,  -2.398394729252314e-16,   2.327005342481960e-18,   2.982485365130780e-20,  -6.798743430828556e-22,
  -1.184187275596793e-24,   1.490818965777959e-25,   8.129899355980718e-01,  -1.041823599618097e-02,   3.969721712267128e-05,   6.112174577492849e-07,  -7.970011924134905e-09,
  -3.684973840683541e-11,   1.474887990601009e-12,  -3.559658976662731e-15,  -2.398355382765817e-16,   2.326895773036391e-18,   2.982462402833278e-20,  -6.798402707798498e-22,
  -1.184420452220991e-24,   1.490739707786849e-25,   1.088641961761758e+00,  -1.117912545625661e-02,  -6.954012852964762e-06,   9.414275333952317e-07,   6.062012223446736e-10,
  -1.436816951222091e-10,  -2.191278983812650e-14,   2.664386930976792e-14,  -1.579285727240371e-17,  -5.484516280431855e-18,   7.726189406149079e-21,   1.196471277169174e-21,
  -2.847764976603656e-24,  -2.739624976272721e-25,   1.088641310508484e+00,  -1.117886115310410e-02,  -6.953672042363417e-06,   9.412932703591585e-07,   6.061699261178929e-10,
  -1.436295316596901e-10,  -2.195358595308540e-14,   2.662551762960841e-14,  -1.576081635048158e-17,  -5.478423415730590e-18,   7.708910264163794e-21,   1.194501748958588e-21,
  -2.840367972446562e-24,  -2.733474812009373e-25,   1.088640161387775e+00,  -1.117839481665059e-02,  -6.953070691112007e-06,   9.410564007850424e-07,   6.061146570499527e-10,
  -1.435375177038043e-10,  -2.202550329625133e-14,   2.659315246282741e-14,  -1.570433860461017e-17,  -5.467680681759515e-18,   7.678457929612541e-21,   1.191030121824370e-21,
  -2.827336362390492e-24,  -2.722637522269849e-25,   1.088638771902961e+00,  -1.117783096982678e-02,  -6.952343555348795e-06,   9.407700431824032e-07,   6.060477460678840e-10,
  -1.434263033762957e-10,  -2.211235058211213e-14,   2.655404455129041e-14,  -1.563614556440546e-17,  -5.454704461240907e-18,   7.641697630559999e-21,   1.186838387537035e-21,
  -2.811613333689894e-24,  -2.709558109825502e-25,   1.088637423061466e+00,  -1.117728365174408e-02,  -6.951637690310714e-06,   9.404921229672282e-07,   6.059827073481195e-10,
  -1.433183906963590e-10,  -2.219653912857658e-14,   2.651610898193251e-14,  -1.557005002500627e-17,  -5.442122026935837e-18,   7.606077240599943e-21,   1.182775603461640e-21,
  -2.796386201246037e-24,  -2.696887141515979e-25,   1.088636336485480e+00,  -1.117684277856771e-02,  -6.951069073095317e-06,   9.402682847621213e-07,   6.059302537970916e-10,
  -1.432314950753939e-10,  -2.226427349626582e-14,   2.648556985686303e-14,  -1.551687953231397e-17,  -5.431996273078009e-18,   7.577429051608765e-21,   1.179507314256469e-21,
  -2.784145532368089e-24,  -2.686698387549149e-25,   1.088635618511670e+00,  -1.117655147659492e-02,  -6.950693350022309e-06,   9.401204012851746e-07,   6.058955644562796e-10,
  -1.431740943174687e-10,  -2.230898867639460e-14,   2.646540055889110e-14,  -1.548178221351180e-17,  -5.425310488501470e-18,   7.558521891236907e-21,   1.177349955109448e-21,
  -2.776069881125581e-24,  -2.679975039948504e-25,   1.088635249802789e+00,  -1.117640188502108e-02,  -6.950500401047579e-06,   9.400444637188812e-07,   6.058777408652008e-10,
  -1.431446219460992e-10,  -2.233193892918116e-14,   2.645504587808436e-14,  -1.546376943365490e-17,  -5.421878604901090e-18,   7.548819283508589e-21,   1.176242748942178e-21,
  -2.771926591159184e-24,  -2.676525121737594e-25,   1.088635121471086e+00,  -1.117634981924751e-02,  -6.950433243835966e-06,   9.400180341752963e-07,   6.058715357758589e-10,
  -1.431343647189913e-10,  -2.233992488483271e-14,   2.645144234893053e-14,  -1.545750173062379e-17,  -5.420684358916307e-18,   7.545443335670857e-21,   1.175857487252145e-21,
  -2.770485108552589e-24,  -2.675324798410910e-25,   1.088635101106650e+00,  -1.117634155717110e-02,  -6.950422586932563e-06,   9.400138402287229e-07,   6.058705510459846e-10,
  -1.431327370811158e-10,  -2.234119204680282e-14,   2.645087054280212e-14,  -1.545650721838545e-17,  -5.420494860512963e-18,   7.544907673051010e-21,   1.175796356822947e-21,
  -2.770256394892896e-24,  -2.675134345097672e-25,   1.369167906302508e+00,  -1.018225460160679e-02,  -5.800772926975259e-05,   5.745165151913289e-07,   1.114050532576936e-08,
  -2.506781633728052e-11,  -2.189791098020034e-12,  -9.063042120710968e-15,   3.999740740237808e-16,   4.611908851795788e-18,  -6.053606624547921e-20,  -1.491984883253549e-21,
   4.352313298253890e-24,   3.943794617140947e-25,   1.369162480633077e+00,  -1.018209310248464e-02,  -5.800148005345905e-05,   5.744928664343497e-07,   1.113743828415600e-08,
  -2.508541516109807e-11,  -2.188746421527676e-12,  -9.047674195557456e-15,   3.997195759045705e-16,   4.604325887337760e-18,  -6.050854284861852e-20,  -1.489148641212134e-21,
   4.365234165952256e-24,   3.935135065300378e-25,   1.369152907428113e+00,  -1.018180814017170e-02,  -5.799045461252795e-05,   5.744511244913570e-07,   1.113202763319584e-08,
  -2.511644406212682e-11,  -2.186903615987577e-12,  -9.020577975482175e-15,   3.992706048825185e-16,   4.590957468008098e-18,  -6.045991323310017e-20,  -1.484149173463028e-21,
   4.387956245794499e-24,   3.919871580932796e-25,   1.369141332214696e+00,  -1.018146356995671e-02,  -5.797712491749285e-05,   5.744006269560660e-07,   1.112548704864758e-08,
  -2.515392278811623e-11,  -2.184676200818333e-12,  -8.987848253372657e-15,   3.987278663095528e-16,   4.574812407300268e-18,  -6.040100066728242e-20,  -1.478112497137314e-21,
   4.415300982356910e-24,   3.901442816539826e-25,   1.369130096044240e+00,  -1.018112907685453e-02,  -5.796418717834691e-05,   5.743515810346075e-07,   1.111913969015621e-08,
  -2.519026279246185e-11,  -2.182514833179984e-12,  -8.956111760714981e-15,   3.982011549160942e-16,   4.559160169944396e-18,  -6.034369544009902e-20,  -1.472261333361325e-21,
   4.441709851926896e-24,   3.883581800746343e-25,   1.369121044937788e+00,  -1.018085962051170e-02,  -5.795376649345096e-05,   5.743120532452909e-07,   1.111402786485688e-08,
  -2.521950654107947e-11,  -2.180774357284210e-12,  -8.930571713140759e-15,   3.977769648752650e-16,   4.546566041772192e-18,  -6.029744970192259e-20,  -1.467554252612865e-21,
   4.462886598355119e-24,   3.869214187798849e-25,   1.369115064424741e+00,  -1.018068157196434e-02,  -5.794688156656512e-05,   5.742859256511706e-07,   1.111065080787603e-08,
  -2.523881497882026e-11,  -2.179624621453212e-12,  -8.913708251270159e-15,   3.974967273473754e-16,   4.538251459505478e-18,  -6.026685158550868e-20,  -1.464447097583404e-21,
   4.476831968598026e-24,   3.859730597413716e-25,   1.369111993236933e+00,  -1.018059013656878e-02,  -5.794334609807696e-05,   5.742725053047067e-07,   1.110891675823962e-08,
  -2.524872605234632e-11,  -2.179034282115747e-12,  -8.905052058850161e-15,   3.973528304404665e-16,   4.533983808977575e-18,  -6.025112571392460e-20,  -1.462852413940350e-21,
   4.483978804734467e-24,   3.854863495816995e-25,   1.369110924296506e+00,  -1.018055831180963e-02,  -5.794211558901780e-05,   5.742678338200899e-07,   1.110831324311006e-08,
  -2.525217493888514e-11,  -2.178828825822275e-12,  -8.902039828800594e-15,   3.973027487461234e-16,   4.532498777852025e-18,  -6.024565022795839e-20,  -1.462297527120628e-21,
   4.486463975326905e-24,   3.853169962046653e-25,   1.369110754671076e+00,  -1.018055326166662e-02,  -5.794192032622421e-05,   5.742670925003495e-07,   1.110821747531421e-08,
  -2.525272219391844e-11,  -2.178796223531783e-12,  -8.901561859613933e-15,   3.972948016106489e-16,   4.532263141129661e-18,  -6.024478125109738e-20,  -1.462209481696963e-21,
   4.486858226088459e-24,   3.852901245557611e-25,   1.629294547668379e+00,  -7.438935789240631e-03,  -8.179706274357156e-05,  -2.881161977590091e-07,   7.497668204766607e-09,
   1.452363242015966e-10,   5.672777577069984e-13,  -2.141154697489584e-14,  -4.247929780688458e-16,  -1.336437476779635e-18,   7.878348912665703e-20,   1.479195928066042e-21,
   2.730924745589277e-24,  -3.296958129036101e-25,   1.629286887684010e+00,  -7.439016343495397e-03,  -8.179284089159378e-05,  -2.879803940320495e-07,   7.498452842731470e-09,
   1.451941021127487e-10,   5.661695535468472e-13,  -2.141586143790065e-14,  -4.244601496108865e-16,  -1.328904207050042e-18,   7.879817775157615e-20,   1.476784721091453e-21,
   2.683089192094649e-24,  -3.297047762869026e-25,   1.629273371843191e+00,  -7.439158451756612e-03,  -8.178539101150493e-05,  -2.877407984179194e-07,   7.499836084496481e-09,
   1.451195937623032e-10,   5.642148204174644e-13,  -2.142345377441129e-14,  -4.238728201093730e-16,  -1.315621741960839e-18,   7.882385667228474e-20,   1.472530085971996e-21,
   2.598795223871169e-24,  -3.297183000576585e-25,   1.629257028893295e+00,  -7.439330237751400e-03,  -8.177638193053074e-05,  -2.874511317459637e-07,   7.501506560093052e-09,
   1.450294858789904e-10,   5.618523478392212e-13,  -2.143259940084346e-14,  -4.231625329474242e-16,  -1.299577678014926e-18,   7.885450010720448e-20,   1.467385306686156e-21,
   2.497058062838377e-24,  -3.297307503023835e-25,   1.629241164015606e+00,  -7.439496949301745e-03,  -8.176763543618396e-05,  -2.871699858549799e-07,   7.503125972770672e-09,
   1.449419985975669e-10,   5.595601692251988e-13,  -2.144144107615969e-14,  -4.224729132549413e-16,  -1.284020426533391e-18,   7.888382168424082e-20,   1.462390825444344e-21,
   2.398494431700619e-24,  -3.297387569749819e-25,   1.629228383888576e+00,  -7.439631210326848e-03,  -8.176058891982902e-05,  -2.869435395830087e-07,   7.504428934565988e-09,
   1.448715113262143e-10,   5.577145291445552e-13,  -2.144853750744956e-14,  -4.219173040490070e-16,  -1.271500638427165e-18,   7.890713750045185e-20,   1.458367331341995e-21,
   2.319236882851903e-24,  -3.297422889584751e-25,   1.629219939210095e+00,  -7.439719908217505e-03,  -8.175593248507877e-05,  -2.867939280951409e-07,   7.505289117475505e-09,
   1.448249303633500e-10,   5.564954082520985e-13,  -2.145321382894102e-14,  -4.215501379397788e-16,  -1.263234117014013e-18,   7.892239485144625e-20,   1.455708679046608e-21,
   2.266935420966358e-24,  -3.297431961077224e-25,   1.629215602526039e+00,  -7.439765452828243e-03,  -8.175354111432307e-05,  -2.867171016769406e-07,   7.505730617966468e-09,
   1.448010075037866e-10,   5.558694690265845e-13,  -2.145561136388232e-14,  -4.213615715119425e-16,  -1.258990820813427e-18,   7.893018408109605e-20,   1.454343334885269e-21,
   2.240097923555398e-24,  -3.297432211821835e-25,   1.629214093113375e+00,  -7.439781304091897e-03,  -8.175270876489615e-05,  -2.866903625318865e-07,   7.505884247320054e-09,
   1.447926807256245e-10,   5.556516270671580e-13,  -2.145644521440023e-14,  -4.212959378009834e-16,  -1.257514214441211e-18,   7.893288784931644e-20,   1.453868114570046e-21,
   2.230760358194135e-24,  -3.297431597740966e-25,   1.629213853590844e+00,  -7.439783819423786e-03,  -8.175257668198630e-05,  -2.866861194449826e-07,   7.505908624334334e-09,
   1.447913593707461e-10,   5.556170595889997e-13,  -2.145657750492299e-14,  -4.212855225667449e-16,  -1.257279912144914e-18,   7.893331655148306e-20,   1.453792703662766e-21,
   2.229278779965704e-24,  -3.297431467007042e-25,   1.838985671132365e+00,  -3.783105824852453e-03,  -5.958516750600219e-05,  -6.907440933498307e-07,  -4.902291402843823e-09,
   1.434664392238330e-11,   1.147523471130253e-12,   2.063576769928253e-14,   1.970582292144792e-16,  -2.034360794366120e-19,  -4.781459241537034e-20,  -9.980248151773084e-22,
  -1.093847393423860e-23,  -8.142703899755033e-27,   1.838980079516857e+00,  -3.783300047594865e-03,  -5.958791589321200e-05,  -6.907303019450588e-07,  -4.900671640303001e-09,
   1.438725715398797e-11,   1.148036531240643e-12,   2.063494692918406e-14,   1.968543721688945e-16,  -2.085830790686089e-19,  -4.788129093132277e-20,  -9.980538485119898e-22,
  -1.091733029995562e-23,  -7.589894333367381e-27,   1.838970212814791e+00,  -3.783642753471595e-03,  -5.959276472358705e-05,  -6.907059358432043e-07,  -4.897812958862350e-09,
   1.445891846130786e-11,   1.148941397536750e-12,   2.063348454404046e-14,   1.964944352998495e-16,  -2.176651314670302e-19,  -4.799887459374490e-20,  -9.981017908131867e-22,
  -1.087997153060561e-23,  -6.614379159651689e-27,   1.838958281537699e+00,  -3.784057151605178e-03,  -5.959862671557100e-05,  -6.906764193189265e-07,  -4.894355213664483e-09,
   1.454556971341102e-11,   1.150034827201971e-12,   2.063169213060657e-14,   1.960588074467698e-16,  -2.286473912672278e-19,  -4.814087553671968e-20,  -9.981541574585929e-22,
  -1.083471089901640e-23,  -5.434652555226245e-27,   1.838946698488165e+00,  -3.784459436401344e-03,  -5.960431611045260e-05,  -6.906477099250761e-07,  -4.890997450809334e-09,
   1.462968675122370e-11,   1.151095529916841e-12,   2.062992686839625e-14,   1.956355011180267e-16,  -2.393089187771842e-19,  -4.827853628381807e-20,  -9.981991235094687e-22,
  -1.079068270646548e-23,  -4.289269089333370e-27,   1.838937367067400e+00,  -3.784783507685619e-03,  -5.960889846312731e-05,  -6.906245424156562e-07,  -4.888291733240269e-09,
   1.469744853941484e-11,   1.151949459152542e-12,   2.062848672720140e-14,   1.952942001231954e-16,  -2.478977983658072e-19,  -4.838929676252254e-20,  -9.982311410815281e-22,
  -1.075514979410433e-23,  -3.366475930856887e-27,   1.838931200900225e+00,  -3.784997646200129e-03,  -5.961192593500361e-05,  -6.906092143516117e-07,  -4.886503477409751e-09,
   1.474222343322943e-11,   1.152513446519704e-12,   2.062752626049354e-14,   1.950685321547139e-16,  -2.535732184512931e-19,  -4.846241805995035e-20,  -9.982502380158282e-22,
  -1.073163879194041e-23,  -2.756669054745886e-27,   1.838928034237964e+00,  -3.785107615949328e-03,  -5.961348054280853e-05,  -6.906013366618977e-07,  -4.885585009356341e-09,
   1.476521720756998e-11,   1.152802996299271e-12,   2.062703027883874e-14,   1.949525968512226e-16,  -2.564878303148051e-19,  -4.849994853266796e-20,  -9.982594082018441e-22,
  -1.071955503666553e-23,  -2.443491409161005e-27,   1.838926932045737e+00,  -3.785145891828210e-03,  -5.961402161538730e-05,  -6.905985938053794e-07,  -4.885265310132855e-09,
   1.477322035724826e-11,   1.152903763261958e-12,   2.062685721229917e-14,   1.949122375034060e-16,  -2.575022895249182e-19,  -4.851300804286355e-20,  -9.982624985554752e-22,
  -1.071534762645048e-23,  -2.334485070113594e-27,   1.838926757142705e+00,  -3.785151965678325e-03,  -5.961410747506640e-05,  -6.905981585065135e-07,  -4.885214577414284e-09,
   1.477449034478754e-11,   1.152919752950703e-12,   2.062682972834431e-14,   1.949058326982908e-16,  -2.576632703171711e-19,  -4.851508024989744e-20,  -9.982629841375646e-22,
  -1.071467989489323e-23,  -2.317187171233265e-27,   1.968243346467572e+00,  -8.173674538032804e-04,  -1.546789423279274e-05,  -2.532035811009272e-07,  -3.747167458292611e-09,
  -5.068254938032626e-11,  -6.214123168760561e-13,  -6.682449848819473e-15,  -5.702474992298966e-17,  -2.243978330723473e-19,   4.854341034680759e-21,   1.654907445442466e-22,
   3.294218743095578e-24,   5.220318181522126e-26,   1.968241892114044e+00,  -8.174388349478973e-04,  -1.547000695391077e-05,  -2.532512066199602e-07,  -3.748043081992025e-09,
  -5.069571706209515e-11,  -6.215615678196819e-13,  -6.683184494495810e-15,  -5.700360513019981e-17,  -2.235294930321303e-19,   4.874998651896937e-21,   1.658764147198100e-22,
   3.300141538372632e-24,   5.227455146378153e-26,   1.968239325722707e+00,  -8.175647990116115e-04,  -1.547373528446762e-05,  -2.533352526386489e-07,  -3.749588304271128e-09,
  -5.071895280874038e-11,  -6.218248779313567e-13,  -6.684478394674078e-15,  -5.696622371569381e-17,  -2.219956725689211e-19,   4.911479175259361e-21,   1.665573596076564e-22,
   3.310595835182261e-24,   5.240044648361685e-26,   1.968236222139217e+00,  -8.177171347092319e-04,  -1.547824430524676e-05,  -2.534368991040073e-07,  -3.751457094218866e-09,
  -5.074705170566290e-11,  -6.221431976014461e-13,  -6.686038908128903e-15,  -5.692090041686464e-17,  -2.201381956585349e-19,   4.955642693062482e-21,   1.673814878922642e-22,
   3.323243121886401e-24,   5.255261521414379e-26,   1.968233208945389e+00,  -8.178650390535034e-04,  -1.548262230053176e-05,  -2.535355936633950e-07,  -3.753271587479784e-09,
  -5.077433170247666e-11,  -6.224521352956886e-13,  -6.687549546471131e-15,  -5.687677423652211e-17,  -2.183320923843822e-19,   4.998569166838570e-21,   1.681822937080518e-22,
   3.335526989104521e-24,   5.270026961690672e-26,   1.968230781348755e+00,  -8.179842028328997e-04,  -1.548614966963444e-05,  -2.536151135645431e-07,  -3.754733537672564e-09,
  -5.079630959684866e-11,  -6.227009529739180e-13,  -6.688763426929200e-15,  -5.684113562504381e-17,  -2.168750424021981e-19,   5.033188372234358e-21,   1.688279542343545e-22,
   3.345427073229308e-24,   5.281916879365919e-26,   1.968229177134848e+00,  -8.180629509727806e-04,  -1.548848074351504e-05,  -2.536676651893727e-07,  -3.755699675050980e-09,
  -5.081083292343264e-11,  -6.228653385769360e-13,  -6.689564033177446e-15,  -5.681754161812011e-17,  -2.159112324948292e-19,   5.056082832650515e-21,   1.692548604181952e-22,
   3.351971003263241e-24,   5.289771099452152e-26,   1.968228353262918e+00,  -8.181033940251857e-04,  -1.548967793918537e-05,  -2.536946549087446e-07,  -3.756195865828701e-09,
  -5.081829157071427e-11,  -6.229497495700916e-13,  -6.689974717327848e-15,  -5.680541115359681e-17,  -2.154159553071803e-19,   5.067846019507576e-21,   1.694741791766841e-22,
   3.355332282531434e-24,   5.293803864475241e-26,   1.968228066501761e+00,  -8.181174709366020e-04,  -1.549009464647150e-05,  -2.537040492374697e-07,  -3.756368574827205e-09,
  -5.082088765687407e-11,  -6.229791281749153e-13,  -6.690117585583507e-15,  -5.680118683479428e-17,  -2.152435194399777e-19,   5.071941225632522e-21,   1.695505281334656e-22,
   3.356502311250215e-24,   5.295207385191133e-26,   1.968228020996478e+00,  -8.181197047645559e-04,  -1.549016077276605e-05,  -2.537055400027617e-07,  -3.756395981616115e-09,
  -5.082129962168669e-11,  -6.229837900877332e-13,  -6.690140253288739e-15,  -5.680051638914958e-17,  -2.152161538637939e-19,   5.072591122179155e-21,   1.695626442811255e-22,
   3.356687983662245e-24,   5.295430098893740e-26,   6.764991972859239e-03,  -1.249795436472895e-04,   1.726405126749605e-06,  -2.112770880165694e-08,   2.411644823508990e-10,
  -2.629026452997947e-12,   2.765057724718875e-14,  -2.829063142825067e-16,   2.816108756242599e-18,  -2.747779729922039e-20,   2.596921037318425e-22,  -2.440492637348025e-24,
   2.133596793641977e-26,  -1.964574546004647e-28,   6.765154095788725e-03,  -1.249854945028255e-04,   1.726541001532254e-06,  -2.113017820592324e-08,   2.412034536235762e-10,
  -2.629584904804894e-12,   2.765799224608726e-14,  -2.829993813820634e-16,   2.817208600006128e-18,  -2.749043709177363e-20,   2.598247957737407e-22,  -2.441932125730646e-24,
   2.135052283374456e-26,  -1.965101621964334e-28,   6.765440174635129e-03,  -1.249959954466595e-04,   1.726780772570221e-06,  -2.113453593476861e-08,   2.412722275347567e-10,
  -2.630570450944425e-12,   2.767107847829871e-14,  -2.831636344691983e-16,   2.819149747369178e-18,  -2.751274624228118e-20,   2.600590064456299e-22,  -2.444472436934253e-24,
   2.137622826153110e-26,  -1.966030101389450e-28,   6.765786121944255e-03,  -1.250086942646451e-04,   1.727070736703540e-06,  -2.113980607378187e-08,   2.413554041566459e-10,
  -2.631762438202132e-12,   2.768690649773097e-14,  -2.833623102789909e-16,   2.821497780748535e-18,  -2.753973300111611e-20,   2.603423418554560e-22,  -2.447544738567449e-24,
   2.140735087323581e-26,  -1.967150194580246e-28,   6.766121980152077e-03,  -1.250210230674346e-04,   1.727352260736794e-06,  -2.114492299463775e-08,   2.414361657404379e-10,
  -2.632919865185239e-12,   2.770227626260831e-14,  -2.835552433471258e-16,   2.823778025056116e-18,  -2.756594206212531e-20,   2.606175303469343e-22,  -2.450527830226589e-24,
   2.143760532547609e-26,  -1.968234824126596e-28,   6.766392556447475e-03,  -1.250309557144325e-04,   1.727579075675488e-06,  -2.114904566495332e-08,   2.415012370851632e-10,
  -2.633852464210785e-12,   2.771466095348457e-14,  -2.837107121731313e-16,   2.825615543707087e-18,  -2.758706346739426e-20,   2.608393128218451e-22,  -2.452931366758042e-24,
   2.146200738793246e-26,  -1.969106640811415e-28,   6.766571354951264e-03,  -1.250375193850429e-04,   1.727728962129794e-06,  -2.115177011913478e-08,   2.415442403900890e-10,
  -2.634468802516783e-12,   2.772284600971322e-14,  -2.838134649744313e-16,   2.826830029052983e-18,  -2.760102389918500e-20,   2.609859088843889e-22,  -2.454519774886087e-24,
   2.147814625629722e-26,  -1.969681774467247e-28,   6.766663178550867e-03,  -1.250408902535737e-04,   1.727805939454656e-06,  -2.115316933932024e-08,   2.415663262900599e-10,
  -2.634785350641240e-12,   2.772704988335590e-14,  -2.838662401880965e-16,   2.827453813775077e-18,  -2.760819441902861e-20,   2.610612072565688e-22,  -2.455335558413242e-24,
   2.148643879514335e-26,  -1.969976841423355e-28,   6.766695138916036e-03,  -1.250420635326862e-04,   1.727832732668170e-06,  -2.115365636387050e-08,   2.415740137517415e-10,
  -2.634895532718168e-12,   2.772851315261646e-14,  -2.838846101565989e-16,   2.827670941832414e-18,  -2.761069037041932e-20,   2.610874178184611e-22,  -2.455619508880658e-24,
   2.148932579873987e-26,  -1.970079495853324e-28,   6.766700210601035e-03,  -1.250422497167512e-04,   1.727836984408295e-06,  -2.115373364858355e-08,   2.415752336584723e-10,
  -2.634913017314864e-12,   2.772874535673949e-14,  -2.838875252685018e-16,   2.827705397732860e-18,  -2.761108645237428e-20,   2.610915771816156e-22,  -2.455664568362020e-24,
   2.148978396012959e-26,  -1.970095783500586e-28,   6.069703005727439e-02,  -1.100932576121989e-03,   1.460418485250126e-05,  -1.662205348345931e-07,   1.685387320753554e-09,
  -1.524632708660016e-11,   1.187557519038984e-13,  -7.118488652455102e-16,   1.440951959411525e-18,   4.268014304708225e-20,  -9.460089400846365e-22,   1.265126887011062e-23,
  -1.452870416376822e-25,   1.211553490377796e-27,   6.069840110194852e-02,  -1.100979375945819e-03,   1.460513382393748e-05,  -1.662348399994283e-07,   1.685554364321109e-09,
  -1.524772621402532e-11,   1.187594512829062e-13,  -7.117031091371463e-16,   1.436931976126502e-18,   4.274572290760440e-20,  -9.469109039318780e-22,   1.266017650964791e-23,
  -1.453521029576442e-25,   1.212425533253456e-27,   6.070082040432375e-02,  -1.101061958245482e-03,   1.460680837539263e-05,  -1.662600827538914e-07,   1.685849119525104e-09,
  -1.525019476227389e-11,   1.187659702986672e-13,  -7.114457399880359e-16,   1.429835556031274e-18,   4.286147699560953e-20,  -9.485027585653828e-22,   1.267589937316797e-23,
  -1.454667168289957e-25,   1.213964930723163e-27,   6.070374597419184e-02,  -1.101161823227676e-03,   1.460883339121995e-05,  -1.662906083799089e-07,   1.686205547823727e-09,
  -1.525317935782749e-11,   1.187738384995680e-13,  -7.111342191317275e-16,   1.421249208737594e-18,   4.300151184775279e-20,  -9.504282001039715e-22,   1.269492048552838e-23,
  -1.456049889546147e-25,   1.215827501909119e-27,   6.070658619620249e-02,  -1.101258776270506e-03,   1.461079937799958e-05,  -1.663202440324819e-07,   1.686551569732042e-09,
  -1.525607633306550e-11,   1.187814614524817e-13,  -7.108314781526449e-16,   1.412908200971988e-18,   4.313752205885235e-20,  -9.522979646421598e-22,   1.271339513120737e-23,
  -1.457388859791419e-25,   1.217636800016748e-27,   6.070887433485502e-02,  -1.101336884570357e-03,   1.461238324916274e-05,  -1.663441194923558e-07,   1.686830325839096e-09,
  -1.525840979863959e-11,   1.187875913945236e-13,  -7.105873632358970e-16,   1.406184830357471e-18,   4.324713799207431e-20,  -9.538046370684533e-22,   1.272828471619019e-23,
  -1.458465116383126e-25,   1.219095153029947e-27,   6.071038634152290e-02,  -1.101388499194749e-03,   1.461342989088818e-05,  -1.663598966385077e-07,   1.687014525529569e-09,
  -1.525995156416032e-11,   1.187916365587405e-13,  -7.104259434549193e-16,   1.401740206048660e-18,   4.331959369476912e-20,  -9.548004220487665e-22,   1.273812674595092e-23,
  -1.459175112657489e-25,   1.220059195185895e-27,   6.071116284333690e-02,  -1.101415006408441e-03,   1.461396740630053e-05,  -1.663679991644156e-07,   1.687109121694244e-09,
  -1.526074328906150e-11,   1.187937122761556e-13,  -7.103430117242309e-16,   1.399457078535860e-18,   4.335681041726601e-20,  -9.553118679138463e-22,   1.274318210668285e-23,
  -1.459539366451304e-25,   1.220554395782991e-27,   6.071143311413997e-02,  -1.101424232587910e-03,   1.461415449581942e-05,  -1.663708193556248e-07,   1.687142046884549e-09,
  -1.526101884892439e-11,   1.187944344830374e-13,  -7.103141410114055e-16,   1.398662319528908e-18,   4.336976519302806e-20,  -9.554898912973781e-22,   1.274494183169752e-23,
  -1.459666090495359e-25,   1.220726773685485e-27,   6.071147600250033e-02,  -1.101425696660322e-03,   1.461418418446133e-05,  -1.663712668826897e-07,   1.687147271664916e-09,
  -1.526106257613585e-11,   1.187945490747149e-13,  -7.103095593627197e-16,   1.398536197683085e-18,   4.337182099234367e-20,  -9.555181416296180e-22,   1.274522108343783e-23,
  -1.459686197110910e-25,   1.220754128574706e-27,   1.675116424927811e-01,  -2.923695986802933e-03,   3.549336858597017e-05,  -3.388678677265477e-07,   2.400751321502979e-09,
  -7.631898644059994e-12,  -1.128145359277849e-13,   2.680942971123444e-15,  -3.320404874141088e-17,   2.602150734818886e-19,  -6.256088982962997e-22,  -2.236274375197866e-23,
   4.551751679155977e-25,  -5.826690562717420e-27,   1.675149726986203e-01,  -2.923791318239174e-03,   3.549471810405910e-05,  -3.388749781097643e-07,   2.400591644919982e-09,
  -7.626606634116541e-12,  -1.129017487318526e-13,   2.681818139788034e-15,  -3.320659682101879e-17,   2.600981124600442e-19,  -6.227750924465260e-22,  -2.240525186035138e-23,
   4.555510194963973e-25,  -5.824911569130704e-27,   1.675208490020534e-01,  -2.923959533678785e-03,   3.549709927672770e-05,  -3.388875204551906e-07,   2.400309793343341e-09,
  -7.617267399890707e-12,  -1.130556424815382e-13,   2.683362066544596e-15,  -3.321108321277176e-17,   2.598915548008403e-19,  -6.177729068148234e-22,  -2.248024728962539e-23,
   4.562142025789106e-25,  -5.821756060489316e-27,   1.675279548662980e-01,  -2.924162944348378e-03,   3.549997849126698e-05,  -3.389026799080870e-07,   2.399968805346491e-09,
  -7.605971912290483e-12,  -1.132417416154262e-13,   2.685228449699015e-15,  -3.321649160252814e-17,   2.596414794348829e-19,  -6.117209868746815e-22,  -2.257091408808602e-23,
   4.570161072145139e-25,  -5.817912379735369e-27,   1.675348532999225e-01,  -2.924360414797678e-03,   3.550277345207582e-05,  -3.389173892315015e-07,   2.399637602012227e-09,
  -7.595003950528917e-12,  -1.134224130151672e-13,   2.687039726221077e-15,  -3.322172458142605e-17,   2.593983926722734e-19,  -6.058425120724604e-22,  -2.265891241377833e-23,
   4.577945560744388e-25,  -5.814151720078935e-27,   1.675404107198998e-01,  -2.924519496495432e-03,   3.550502494239209e-05,  -3.389292337038132e-07,   2.399370661308966e-09,
  -7.586166513728455e-12,  -1.135679663979097e-13,   2.688498454074970e-15,  -3.322592773568484e-17,   2.592023373728179e-19,  -6.011044706026282e-22,  -2.272978873718247e-23,
   4.584216442957737e-25,  -5.811101234769831e-27,   1.675440830284338e-01,  -2.924624615861572e-03,   3.550651264116372e-05,  -3.389370577897827e-07,   2.399194209167604e-09,
  -7.580326016894819e-12,  -1.136641488303722e-13,   2.689462153138245e-15,  -3.322869900009465e-17,   2.590726760153112e-19,  -5.979724730065702e-22,  -2.277661567829017e-23,
   4.588360027047595e-25,  -5.809075285572996e-27,   1.675459689545001e-01,  -2.924678599999466e-03,   3.550727663146299e-05,  -3.389410750497117e-07,   2.399103573227239e-09,
  -7.577326371420466e-12,  -1.137135441465453e-13,   2.689956996124485e-15,  -3.323012028858284e-17,   2.590060542216606e-19,  -5.963636761608727e-22,  -2.280066142314092e-23,
   4.590487922777873e-25,  -5.808031698851801e-27,   1.675466253715097e-01,  -2.924697389722954e-03,   3.550754254302159e-05,  -3.389424731692253e-07,   2.399072023481922e-09,
  -7.576282274219143e-12,  -1.137307368033541e-13,   2.690129220790116e-15,  -3.323061468039264e-17,   2.589828604068337e-19,  -5.958036613835890e-22,  -2.280903042528489e-23,
   4.591228551031455e-25,  -5.807667965336241e-27,   1.675467295359993e-01,  -2.924700371395665e-03,   3.550758473941638e-05,  -3.389426950256219e-07,   2.399067016825811e-09,
  -7.576116588325653e-12,  -1.137334650490237e-13,   2.690156549999404e-15,  -3.323069311928983e-17,   2.589791796072539e-19,  -5.957147919832989e-22,  -2.281035845453623e-23,
   4.591346078279685e-25,  -5.807610221934265e-27,   3.248724939884460e-01,  -5.327318156851431e-03,   5.529389607411860e-05,  -3.543137881652170e-07,  -7.531463312064016e-11,
   3.728409788377473e-11,  -5.323796220472277e-13,   3.321904439813606e-15,   1.858003926763973e-17,  -7.487049244202818e-19,   9.107844545677120e-21,  -3.954773782130490e-23,
  -7.672053539358585e-25,   1.760302578410372e-26,   3.248776776874179e-01,  -5.327417684086026e-03,   5.529384948744544e-05,  -3.542787797840761e-07,  -7.606270314535573e-11,
   3.729059758343291e-11,  -5.323300596615246e-13,   3.319372400761426e-15,   1.861830772182716e-17,  -7.489038204958105e-19,   9.103028644676337e-21,  -3.941872517447770e-23,
  -7.686949068815291e-25,   1.760834411141090e-26,   3.248868244018862e-01,  -5.327593293445452e-03,   5.529376694256206e-05,  -3.542170020022856e-07,  -7.738262751770547e-11,
   3.730206235058456e-11,  -5.322425244752145e-13,   3.314904035898372e-15,   1.868581643403457e-17,  -7.492542346322344e-19,   9.094523450103991e-21,  -3.919104916120909e-23,
  -7.713203744218405e-25,   1.761769484663413e-26,   3.248978847000557e-01,  -5.327805628497730e-03,   5.529366654534510e-05,  -3.541422912231683e-07,  -7.897859699543914e-11,
   3.731591875456789e-11,  -5.321365369212919e-13,   3.309499918016641e-15,   1.876742040709830e-17,  -7.496770364103414e-19,   9.084226165382939e-21,  -3.891568788579424e-23,
  -7.744902197904294e-25,   1.762894459590170e-26,   3.249086218390333e-01,  -5.328011745383867e-03,   5.529356847091075e-05,  -3.540697544718381e-07,  -8.052783469506628e-11,
   3.732936306967703e-11,  -5.320335004354033e-13,   3.304252728300087e-15,   1.884661049157271e-17,  -7.500865186607474e-19,   9.074216439776643e-21,  -3.864831659225843e-23,
  -7.775623204612788e-25,   1.763980559872503e-26,   3.249172715335113e-01,  -5.328177780215267e-03,   5.529348902597810e-05,  -3.540113134905095e-07,  -8.177580741156535e-11,
   3.734018844567916e-11,  -5.319503912799630e-13,   3.300024969550397e-15,   1.891038374114041e-17,  -7.504156997368522e-19,   9.066143214612496e-21,  -3.843288623224155e-23,
  -7.800334881179899e-25,   1.764851198082517e-26,   3.249229870950552e-01,  -5.328287488054328e-03,   5.529343631600427e-05,  -3.539726936385526e-07,  -8.260040977172257e-11,
   3.734733912020668e-11,  -5.318954231701979e-13,   3.297231003944231e-15,   1.895251355617976e-17,  -7.506328776294853e-19,   9.060803913404092e-21,  -3.829051438651679e-23,
  -7.816645911480013e-25,   1.765424387226970e-26,   3.249259223086198e-01,  -5.328343826726559e-03,   5.529340918067561e-05,  -3.539528595404340e-07,  -8.302387146950325e-11,
   3.735101054782339e-11,  -5.318671786266910e-13,   3.295796064487017e-15,   1.897414601062262e-17,  -7.507443039928218e-19,   9.058060487044136e-21,  -3.821739367295549e-23,
  -7.825016836973320e-25,   1.765718093203676e-26,   3.249269439364584e-01,  -5.328363435670205e-03,   5.529339972543139e-05,  -3.539459559487274e-07,  -8.317125942857258e-11,
   3.735228829670682e-11,  -5.318573453412027e-13,   3.295296604049434e-15,   1.898167487152128e-17,  -7.507830702619667e-19,   9.057105383239957e-21,  -3.819194239132264e-23,
  -7.827929527592385e-25,   1.765820216076695e-26,   3.249271060547205e-01,  -5.328366547327769e-03,   5.529339822451377e-05,  -3.539448604365753e-07,  -8.319464778412143e-11,
   3.735249105191721e-11,  -5.318557848149030e-13,   3.295217345767871e-15,   1.898286957370168e-17,  -7.507892211423072e-19,   9.056953810543687e-21,  -3.818790357847921e-23,
  -7.828391689385592e-25,   1.765836416623274e-26,   5.286349108894665e-01,  -7.898264462209694e-03,   6.238378153344201e-05,  -6.650900383788727e-08,  -5.409430054784305e-09,
   6.823234422738245e-11,  -8.619259585558092e-14,  -8.726082824409399e-15,   1.209454182318364e-16,  -1.637414284744436e-19,  -1.785592713867105e-20,   2.567454779682926e-22,
  -4.051042614731972e-25,  -4.129119928167906e-26,   5.286407532479344e-01,  -7.898282943056029e-03,   6.238073807393255e-05,  -6.644518065784691e-08,  -5.409547529224039e-09,
   6.821515661507910e-11,  -8.587667221801542e-14,  -8.726601293765814e-15,   1.208700170333326e-16,  -1.624293377889694e-19,  -1.785819304726896e-20,   2.564434847675142e-22,
  -3.999012093933492e-25,  -4.129239870251894e-26,   5.286510619494695e-01,  -7.898315538232118e-03,   6.237536778882426e-05,  -6.633257675364600e-08,  -5.409754454145944e-09,
   6.818482798926816e-11,  -8.531938094022280e-14,  -8.727512549527664e-15,   1.207369628699723e-16,  -1.601153991095103e-19,  -1.786216517453366e-20,   2.559106082782131e-22,
  -3.907266316014801e-25,  -4.129433669697970e-26,   5.286635269461136e-01,  -7.898354927829712e-03,   6.236887389256267e-05,  -6.619643724830897e-08,  -5.410004055287945e-09,
   6.814815290771128e-11,  -8.464577281784102e-14,  -8.728608328177636e-15,   1.205760595206729e-16,  -1.573195183397755e-19,  -1.786692382527969e-20,   2.552662409824453e-22,
  -3.796433612653863e-25,  -4.129637634842743e-26,   5.286756273350297e-01,  -7.898393140562154e-03,   6.236256963624147e-05,  -6.606429876653407e-08,  -5.410245720225271e-09,
   6.811254792993988e-11,  -8.399213312278350e-14,  -8.729665683727592e-15,   1.204198439735399e-16,  -1.546075861663838e-19,  -1.787149688134931e-20,   2.546406935896690e-22,
  -3.688951516119624e-25,  -4.129803878751546e-26,   5.286853749543114e-01,  -7.898423905610351e-03,   6.235749094191008e-05,  -6.595786648566522e-08,  -5.410439941381906e-09,
   6.808386399217546e-11,  -8.346577542251374e-14,  -8.730512886871488e-15,   1.202939892422518e-16,  -1.524245085084258e-19,  -1.787514753549928e-20,   2.541367565393064e-22,
  -3.602445879926547e-25,  -4.129915081242754e-26,   5.286918158622284e-01,  -7.898444225484105e-03,   6.235413499819774e-05,  -6.588754613757656e-08,  -5.410568053602873e-09,
   6.806490965385177e-11,  -8.311806846735453e-14,  -8.731070457712953e-15,   1.202108220397500e-16,  -1.509827627001535e-19,  -1.787754350628619e-20,   2.538037621163811e-22,
  -3.545323943818063e-25,  -4.129977451322180e-26,   5.286951235317077e-01,  -7.898454657890634e-03,   6.235241155033727e-05,  -6.585143581227641e-08,  -5.410633775580779e-09,
   6.805517553886429e-11,  -8.293953549414362e-14,  -8.731356102636477e-15,   1.201681102722199e-16,  -1.502426024912250e-19,  -1.787876890759774e-20,   2.536327530469382e-22,
  -3.516001298262060e-25,  -4.130006048387885e-26,   5.286962747892090e-01,  -7.898458288536185e-03,   6.235181168690538e-05,  -6.583886768694689e-08,  -5.410656639609248e-09,
   6.805178746629942e-11,  -8.287740042269859e-14,  -8.731455413437742e-15,   1.201532438232089e-16,  -1.499850219962804e-19,  -1.787919461683138e-20,   2.535732316996153e-22,
  -3.505797225706967e-25,  -4.130015455602011e-26,   5.286964574775795e-01,  -7.898458864648312e-03,   6.235171649676325e-05,  -6.583687331773127e-08,  -5.410660267288371e-09,
   6.805124982467260e-11,  -8.286754067829745e-14,  -8.731471167447269e-15,   1.201508847117186e-16,  -1.499441493727363e-19,  -1.787926213290983e-20,   2.535637864780934e-22,
  -3.504178072158787e-25,  -4.130016922470300e-26,   7.719498595885509e-01,  -1.007495268643575e-02,   4.629804855300781e-05,   4.797100301178511e-07,  -8.384226439119471e-09,
  -3.229702901751360e-12,   1.285587433001941e-12,  -9.826624207402506e-15,  -1.418130594268585e-16,   2.961647657972007e-18,   7.932278605072748e-22,  -5.838406831330849e-22,
   4.880253464311497e-24,   7.156573009674205e-26,   7.719541905754336e-01,  -1.007481777952238e-02,   4.629334261234915e-05,   4.797068411007275e-07,  -8.382422986405561e-09,
  -3.248891451212282e-12,   1.285215265995962e-12,  -9.816706529499831e-15,  -1.418087660262243e-16,   2.958657616426191e-18,   8.227800026875788e-22,  -5.833169366867260e-22,
   4.866304382183260e-24,   7.157379101608714e-26,   7.719618323125684e-01,  -1.007457973490500e-02,   4.628503972960702e-05,   4.797011994529166e-07,  -8.379241191128601e-09,
  -3.282734113203226e-12,   1.284558581184592e-12,  -9.799214819901926e-15,  -1.418010894587466e-16,   2.953383836986518e-18,   8.748553787180696e-22,  -5.823927335618699e-22,
   4.841720481393703e-24,   7.158774314438831e-26,   7.719710721734866e-01,  -1.007429189009740e-02,   4.627500119922521e-05,   4.796943526654739e-07,  -8.375394455631523e-09,
  -3.323630029966266e-12,   1.283764527623751e-12,  -9.778077616705109e-15,  -1.417916351718783e-16,   2.947010470864058e-18,   9.377064917659450e-22,  -5.812751028660287e-22,
   4.812043590702786e-24,   7.160415200947183e-26,   7.719800414325539e-01,  -1.007401245669150e-02,   4.626525743793085e-05,   4.796876799141095e-07,  -8.371660870964513e-09,
  -3.363302824035871e-12,   1.282993691877923e-12,  -9.757572598124280e-15,  -1.417822775204762e-16,   2.940827238527579e-18,   9.985967905263004e-22,  -5.801900498211764e-22,
   4.783286334375505e-24,   7.161959835645573e-26,   7.719872664939553e-01,  -1.007378734974337e-02,   4.625740904383979e-05,   4.796822858047005e-07,  -8.368653687928830e-09,
  -3.395242475177094e-12,   1.282372729443316e-12,  -9.741064487828710e-15,  -1.417746105871384e-16,   2.935848916578950e-18,   1.047560129393592e-21,  -5.793158913655921e-22,
   4.760157490599014e-24,   7.163169623982732e-26,   7.719920404620461e-01,  -1.007363860355780e-02,   4.625222348051024e-05,   4.796787123556758e-07,  -8.366666861410437e-09,
  -3.416337722920195e-12,   1.281962414857646e-12,  -9.730161345565530e-15,  -1.417694815412335e-16,   2.932560705823485e-18,   1.079870645453008e-21,  -5.787382370704809e-22,
   4.744892775052853e-24,   7.163952140245218e-26,   7.719944920538860e-01,  -1.007356221542152e-02,   4.624956060508629e-05,   4.796768743995476e-07,  -8.365646613331814e-09,
  -3.427168079565727e-12,   1.281751700653717e-12,  -9.724563644313822e-15,  -1.417668280993390e-16,   2.930872477723149e-18,   1.096450169904646e-21,  -5.784415760065154e-22,
   4.737059305036174e-24,   7.164348781822462e-26,   7.719953453418604e-01,  -1.007353562785461e-02,   4.624863379229538e-05,   4.796762342333425e-07,  -8.365291519763788e-09,
  -3.430937196894514e-12,   1.281678359959796e-12,  -9.722615565276953e-15,  -1.417659014522057e-16,   2.930284942206742e-18,   1.102218681229133e-21,  -5.783383191493578e-22,
   4.734333699989947e-24,   7.164486006339736e-26,   7.719954807463874e-01,  -1.007353140877503e-02,   4.624848672107489e-05,   4.796761326264800e-07,  -8.365235171927769e-09,
  -3.431535280764260e-12,   1.281666721816683e-12,  -9.722306443932822e-15,  -1.417657542592848e-16,   2.930191711627547e-18,   1.103133962762834e-21,  -5.783219336486778e-22,
   4.733901227009917e-24,   7.164507742577592e-26,   1.043885690354046e+00,  -1.118962148544494e-02,   4.307075954491953e-06,   9.283594339456192e-07,  -2.213316990411294e-09,
  -1.354901973299748e-10,   6.883593750330588e-13,   2.313763828820638e-14,  -1.957063586757342e-16,  -4.210395606252028e-18,   5.275309539949519e-20,   7.592420055121444e-22,
  -1.414904528248581e-23,  -1.347521056653928e-25,   1.043886091653407e+00,  -1.118936083085320e-02,   4.305836392948168e-06,   9.282327930188617e-07,  -2.212355001621731e-09,
  -1.354448693920215e-10,   6.878501777254539e-13,   2.312352914704295e-14,  -1.954865695089264e-16,  -4.206518586924301e-18,   5.266695885230570e-20,   7.582683181632331e-22,
  -1.411850825695585e-23,  -1.345401515618767e-25,   1.043886799658620e+00,  -1.118890093060979e-02,   4.303649605587378e-06,   9.280093675874782e-07,  -2.210658137622056e-09,
  -1.353649100646537e-10,   6.869521584397069e-13,   2.309864395546155e-14,  -1.950990422595004e-16,  -4.199681595005465e-18,   5.251512243741616e-20,   7.565514898569236e-22,
  -1.406469176552437e-23,  -1.341662824535860e-25,   1.043887655626138e+00,  -1.118834486356624e-02,   4.301006066415669e-06,   9.277392579416059e-07,  -2.208607260728993e-09,
  -1.352682607993941e-10,   6.858670604073161e-13,   2.306857059914750e-14,  -1.946309414345205e-16,  -4.191421166854647e-18,   5.233178066289591e-20,   7.544776277747744e-22,
  -1.399972965956278e-23,  -1.337144134931197e-25,   1.043888486417118e+00,  -1.118780509486744e-02,   4.298440546859298e-06,   9.274771017044596e-07,  -2.206617340341833e-09,
  -1.351744755710554e-10,   6.848144995427018e-13,   2.303939483225372e-14,  -1.941770417202260e-16,  -4.183409344404255e-18,   5.215406808138548e-20,   7.524666039704576e-22,
  -1.393678411643380e-23,  -1.332759755217738e-25,   1.043889155571556e+00,  -1.118737030116181e-02,   4.296374358171673e-06,   9.272659561254971e-07,  -2.205015027888006e-09,
  -1.350989522072939e-10,   6.839671670284950e-13,   2.301590476801306e-14,  -1.938117614678593e-16,  -4.176960321662839e-18,   5.201110013355245e-20,   7.508481578429039e-22,
  -1.388616081879468e-23,  -1.329229399198362e-25,   1.043889597678156e+00,  -1.118708301531086e-02,   4.295009331866256e-06,   9.271264564650665e-07,  -2.203956611304019e-09,
  -1.350490618092602e-10,   6.834075568662373e-13,   2.300038958572530e-14,  -1.935705744871428e-16,  -4.172701465713930e-18,   5.191672485333751e-20,   7.497795048450735e-22,
  -1.385275132254900e-23,  -1.326897409590104e-25,   1.043889824702887e+00,  -1.118693548587255e-02,   4.294308410382236e-06,   9.270548233865142e-07,  -2.203413175959529e-09,
  -1.350234450609183e-10,   6.831202605633025e-13,   2.299242384818997e-14,  -1.934467702163208e-16,  -4.170515125694078e-18,   5.186828811474438e-20,   7.492309438587184e-22,
  -1.383560676417751e-23,  -1.325700071304894e-25,   1.043889903718032e+00,  -1.118688413779077e-02,   4.294064461745945e-06,   9.270298918996218e-07,  -2.203224046173483e-09,
  -1.350145296108210e-10,   6.830202788257084e-13,   2.298965162675330e-14,  -1.934036880437502e-16,  -4.169754275181651e-18,   5.185143395655016e-20,   7.490400509395698e-22,
  -1.382964148309716e-23,  -1.325283366584997e-25,   1.043889916256511e+00,  -1.118687598959963e-02,   4.294025751098188e-06,   9.270259356664336e-07,  -2.203194034729105e-09,
  -1.350131148846094e-10,   6.830044137831324e-13,   2.298921172888807e-14,  -1.933968519252982e-16,  -4.169633544624878e-18,   5.184875965648859e-20,   7.490097607021102e-22,
  -1.382869497194599e-23,  -1.325217243176841e-25,   1.327558631442379e+00,  -1.061576639699400e-02,  -5.007000621110173e-05,   7.458397788906163e-07,   1.010109909190657e-08,
  -7.908804390425974e-11,  -2.243452709382021e-12,   5.803565486677570e-15,   5.077030118537831e-16,   1.013341518218190e-18,  -1.142468029310379e-19,  -7.889135267449910e-22,
   2.421779283589639e-23,   3.095636052732297e-25,   1.327553948758521e+00,  -1.061555689076863e-02,  -5.006434206531030e-05,   7.457657305530702e-07,   1.009795987164068e-08,
  -7.907656563428480e-11,  -2.242129833274814e-12,   5.806882039162309e-15,   5.072257832643555e-16,   1.009359347191589e-18,  -1.140988101300687e-19,  -7.867037174502730e-22,
   2.417767779476330e-23,   3.085826465376074e-25,   1.327545686518668e+00,  -1.061518723064736e-02,  -5.005434902273729e-05,   7.456350798593178e-07,   1.009242217657192e-08,
  -7.905630678838590e-11,  -2.239796613131364e-12,   5.812723284451375e-15,   5.063842118645711e-16,   1.002341952315518e-18,  -1.138378755919127e-19,  -7.828102623343222e-22,
   2.410695801219731e-23,   3.068549727764340e-25,   1.327535696462187e+00,  -1.061474026250937e-02,  -5.004226776972339e-05,   7.454771105884157e-07,   1.008572850780975e-08,
  -7.903180062206985e-11,  -2.236976989278735e-12,   5.819768074313808e-15,   5.053674369582086e-16,   9.938721282433466e-19,  -1.135226934112732e-19,  -7.781121109391832e-22,
   2.402155171536688e-23,   3.047713731637220e-25,   1.327525999054968e+00,  -1.061430638376706e-02,  -5.003054205384221e-05,   7.453237724072546e-07,   1.007923310165253e-08,
  -7.900800109921704e-11,  -2.234241558863498e-12,   5.826587676676070e-15,   5.043812717887556e-16,   9.856661735076636e-19,  -1.132170785463593e-19,  -7.735615313783647e-22,
   2.393875467712091e-23,   3.027544227641423e-25,   1.327518187499080e+00,  -1.061395687832361e-02,  -5.002109780013761e-05,   7.452002563800215e-07,   1.007400241473631e-08,
  -7.898882181677463e-11,  -2.232039229044742e-12,   5.832067605417489e-15,   5.035874760305240e-16,   9.790673015389510e-19,  -1.129711358807383e-19,  -7.699030149947022e-22,
   2.387213605305179e-23,   3.011337220004425e-25,   1.327513026031011e+00,  -1.061372594194237e-02,  -5.001485810163308e-05,   7.451186446828998e-07,   1.007054701362419e-08,
  -7.897614521419390e-11,  -2.230584603683196e-12,   5.835681867551095e-15,   5.030632661002600e-16,   9.747126259631590e-19,  -1.128087469536139e-19,  -7.674891369856720e-22,
   2.382815559211175e-23,   3.000648101256240e-25,   1.327510375453345e+00,  -1.061360734833551e-02,  -5.001165399498317e-05,   7.450767348705186e-07,   1.006877279158034e-08,
  -7.896963416048914e-11,  -2.229837780265776e-12,   5.837535869524369e-15,   5.027941569593290e-16,   9.724780660170609e-19,  -1.127253912970240e-19,  -7.662506088226040e-22,
   2.380558187018251e-23,   2.995164962808275e-25,   1.327509452908753e+00,  -1.061356607126594e-02,  -5.001053882043133e-05,   7.450621480470332e-07,   1.006815530379361e-08,
  -7.896736776763400e-11,  -2.229577872783410e-12,   5.838180838549808e-15,   5.027005066156265e-16,   9.717005893258859e-19,  -1.126963847772802e-19,  -7.658197049648999e-22,
   2.379772684533080e-23,   2.993257498391127e-25,   1.327509306514261e+00,  -1.061355952118823e-02,  -5.001036185968237e-05,   7.450598333318816e-07,   1.006805731919076e-08,
  -7.896700811466025e-11,  -2.229536630528772e-12,   5.838283170429142e-15,   5.026856463343421e-16,   9.715772278849195e-19,  -1.126917821354300e-19,  -7.657513348681819e-22,
   2.379648045438625e-23,   2.992954857146541e-25,   1.598211329519739e+00,  -8.104878063229980e-03,  -8.443705306116523e-05,  -1.444077684749460e-07,   1.048194214979260e-08,
   1.501011031106813e-10,  -2.247127987938123e-13,  -3.503974492684549e-14,  -4.006672679733876e-16,   3.082265561401143e-18,   1.392648670407957e-19,   1.071802477551023e-21,
  -2.201743206355014e-23,  -5.902863966787256e-25,   1.598203425393795e+00,  -8.104918184339610e-03,  -8.443115883995842e-05,  -1.442676273908281e-07,   1.048161387111124e-08,
   1.500322867385363e-10,  -2.257525188121732e-13,  -3.502920318311326e-14,  -4.000841547480090e-16,   3.087627305657028e-18,   1.391278529815592e-19,   1.067557691010263e-21,
  -2.203457295120571e-23,  -5.889872395719312e-25,   1.598189478888039e+00,  -8.104988946726066e-03,  -8.442075854676835e-05,  -1.440203986388270e-07,   1.048103343423528e-08,
   1.499108761068247e-10,  -2.275858794034668e-13,  -3.501058751903057e-14,  -3.990557128903923e-16,   3.097070466966128e-18,   1.388860053767207e-19,   1.060075419553674e-21,
  -2.206462922146994e-23,  -5.866950231216752e-25,   1.598172615389525e+00,  -8.105074458903138e-03,  -8.440818266211941e-05,  -1.437215363203026e-07,   1.048032954595188e-08,
   1.497640939729412e-10,  -2.298006820416675e-13,  -3.498805241273087e-14,  -3.978129126177357e-16,   3.108459045275757e-18,   1.385934178489524e-19,   1.051040941463967e-21,
  -2.210065158668996e-23,  -5.839235430793507e-25,   1.598156245398434e+00,  -8.105157415628358e-03,  -8.439597448477554e-05,  -1.434314994888485e-07,   1.047964411159631e-08,
   1.496216307013751e-10,  -2.319485585242659e-13,  -3.496614974507564e-14,  -3.966072643587830e-16,   3.119483290177107e-18,   1.383092302093135e-19,   1.042284211293297e-21,
  -2.213528482557210e-23,  -5.812333552403149e-25,   1.598143058520653e+00,  -8.105224203642953e-03,  -8.438613993236297e-05,  -1.431979165979876e-07,   1.047909042237207e-08,
   1.495068858545163e-10,  -2.336772730509164e-13,  -3.494848665858005e-14,  -3.956366123560707e-16,   3.128341664470669e-18,   1.380801863588439e-19,   1.035239779390787e-21,
  -2.216294408695676e-23,  -5.790664095150388e-25,   1.598134345147850e+00,  -8.105268315977673e-03,  -8.437964153166625e-05,  -1.430436019908546e-07,   1.047872381432466e-08,
   1.494310751403540e-10,  -2.348188001076080e-13,  -3.493680611934630e-14,  -3.949955179014158e-16,   3.134184056013505e-18,   1.379287866052015e-19,   1.030589779570028e-21,
  -2.218110307410470e-23,  -5.776346482679254e-25,   1.598129870500934e+00,  -8.105290963589079e-03,  -8.437630432179427e-05,  -1.429643642012835e-07,   1.047853531475179e-08,
   1.493921460018940e-10,  -2.354047887209247e-13,  -3.493080479608860e-14,  -3.946663765001067e-16,   3.137180983571020e-18,   1.378510196619630e-19,   1.028203277463590e-21,
  -2.219039219742143e-23,  -5.768994074587022e-25,   1.598128313072938e+00,  -8.105298845313316e-03,  -8.437514278008747e-05,  -1.429367863780022e-07,   1.047846966933080e-08,
   1.493785968827391e-10,  -2.356087091965939e-13,  -3.492871553384586e-14,  -3.945518303538434e-16,   3.138223547328834e-18,   1.378239496342860e-19,   1.027372871598099e-21,
  -2.219361957217437e-23,  -5.766435061250718e-25,   1.598128065931221e+00,  -8.105300095987677e-03,  -8.437495845964118e-05,  -1.429324102339245e-07,   1.047845925057781e-08,
   1.493764468490085e-10,  -2.356410667529530e-13,  -3.492838397549889e-14,  -3.945336541479267e-16,   3.138388962001030e-18,   1.378196538736476e-19,   1.027241108924574e-21,
  -2.219413143730344e-23,  -5.766028983920001e-25,   1.822845548369193e+00,  -4.294243749277230e-03,  -6.832983352281634e-05,  -7.651798840469381e-07,  -4.289552471900690e-09,
   4.951112709035379e-11,   1.809331825223804e-12,   2.636030265547516e-14,   1.433457432738157e-16,  -3.143858393268145e-18,  -1.025999993613584e-19,  -1.453768852304787e-21,
  -5.886129085942185e-24,   2.448138545140009e-25,   1.822839137645398e+00,  -4.294458790576551e-03,  -6.833223200248800e-05,  -7.651330327412117e-07,  -4.287003774125033e-09,
   4.956285155413361e-11,   1.809699142350655e-12,   2.634949890730571e-14,   1.429118318576112e-16,  -3.151282564797585e-18,  -1.026336609463511e-19,  -1.451930750572732e-21,
  -5.826604766244342e-24,   2.456850342151756e-25,   1.822827825641149e+00,  -4.294838223549463e-03,  -6.833646299109305e-05,  -7.650503235033013e-07,  -4.282506140317025e-09,
   4.965410279798328e-11,   1.810346352543066e-12,   2.633041520530140e-14,   1.421460752978311e-16,  -3.164374878095908e-18,  -1.026927578157760e-19,  -1.448682240137501e-21,
  -5.721564568216879e-24,   2.472201508719832e-25,   1.822814146735738e+00,  -4.295297019562870e-03,  -6.834157715859910e-05,  -7.649502434858465e-07,  -4.277066844040724e-09,
   4.976441510988296e-11,   1.811127385833799e-12,   2.630730435900445e-14,   1.412199222454429e-16,  -3.180193006990951e-18,  -1.027637076356065e-19,  -1.444745332261068e-21,
  -5.594534469291698e-24,   2.490728561647321e-25,   1.822800867167632e+00,  -4.295742391523717e-03,  -6.834653982073511e-05,  -7.648530172580970e-07,  -4.271785727397626e-09,
   4.987147329727866e-11,   1.811883944466998e-12,   2.628483250402255e-14,   1.403206286910056e-16,  -3.195535093057381e-18,  -1.028320496091722e-19,  -1.440914272758481e-21,
  -5.471201175667012e-24,   2.508676820061337e-25,   1.822790169088515e+00,  -4.296101163573227e-03,  -6.835053618412842e-05,  -7.647746427267915e-07,  -4.267530797539511e-09,
   4.995769568103314e-11,   1.812492232340427e-12,   2.626670351332470e-14,   1.395960266866740e-16,  -3.207884520110879e-18,  -1.028867217479453e-19,  -1.437821453120005e-21,
  -5.371835229563916e-24,   2.523108807517460e-25,   1.822783099874966e+00,  -4.296338226988174e-03,  -6.835317617896081e-05,  -7.647228295849640e-07,  -4.264718955974783e-09,
   5.001465896960607e-11,   1.812893597413012e-12,   2.625471149552949e-14,   1.391171529216033e-16,  -3.216039920484848e-18,  -1.029226604562523e-19,  -1.435774560284889e-21,
  -5.306171071113018e-24,   2.532632022939978e-25,   1.822779469460479e+00,  -4.296459968302493e-03,  -6.835453171657722e-05,  -7.646962134356351e-07,  -4.263274860527034e-09,
   5.004390896300668e-11,   1.813099537977542e-12,   2.624854909299425e-14,   1.388712068386852e-16,  -3.220226598158060e-18,  -1.029410586627755e-19,  -1.434722389976763e-21,
  -5.272447887656450e-24,   2.537518568859057e-25,   1.822778205855886e+00,  -4.296502341148671e-03,  -6.835500348787003e-05,  -7.646869482277747e-07,  -4.262772217108912e-09,
   5.005408915268027e-11,   1.813171188882528e-12,   2.624640358718012e-14,   1.387855996356270e-16,  -3.221683569065390e-18,  -1.029474530868484e-19,  -1.434356014454163e-21,
  -5.260709988655539e-24,   2.539218725937864e-25,   1.822778005338974e+00,  -4.296509065119975e-03,  -6.835507834976836e-05,  -7.646854779092898e-07,  -4.262692453914707e-09,
   5.005570458301516e-11,   1.813182557536862e-12,   2.624606309527861e-14,   1.387720147894051e-16,  -3.221914758858655e-18,  -1.029484673552175e-19,  -1.434297868204414e-21,
  -5.258847334570223e-24,   2.539488486588709e-25,   1.964705599357271e+00,  -9.543662423771207e-04,  -1.890232354074512e-05,  -3.221451959876874e-07,  -4.926204369529762e-09,
  -6.805366377454462e-11,  -8.349171922346895e-13,  -8.581547612531640e-15,  -5.934818297560900e-17,   1.732469633215368e-19,   1.677618328527724e-20,   4.076493071248114e-22,
   7.245167868875100e-24,   1.043765893302249e-25,   1.964703821691833e+00,  -9.544570707922301e-04,  -1.890510116393702e-05,  -3.222091381233913e-07,  -4.927380291838086e-09,
  -6.807054835168496e-11,  -8.350714846412372e-13,  -8.580907214228961e-15,  -5.927594988283766e-17,   1.753787901223151e-19,   1.682147843296865e-20,   4.084168205998442e-22,
   7.255225917715054e-24,   1.044542848656915e-25,   1.964700684760655e+00,  -9.546173536075229e-04,  -1.891000286202497e-05,  -3.223219778955110e-07,  -4.929455401091478e-09,
  -6.810034040160140e-11,  -8.353435809827540e-13,  -8.579771349844123e-15,  -5.914833768701529e-17,   1.791436539054526e-19,   1.690145298193039e-20,   4.097715677381004e-22,
   7.272969051761795e-24,   1.045910549821465e-25,   1.964696891187516e+00,  -9.548111942783280e-04,  -1.891593096557444e-05,  -3.224584468936388e-07,  -4.931964945074269e-09,
  -6.813636346635570e-11,  -8.356723382068958e-13,  -8.578387833028574e-15,  -5.899376194148591e-17,   1.837016622576205e-19,   1.699824523449493e-20,   4.114105212622063e-22,
   7.294416606615515e-24,   1.047558839935713e-25,   1.964693208072799e+00,  -9.549993976054798e-04,  -1.892168682711812e-05,  -3.225909516094334e-07,  -4.934401480622066e-09,
  -6.817133214054561e-11,  -8.359912126733279e-13,  -8.577034240924897e-15,  -5.884342407795744e-17,   1.881322536756959e-19,   1.709229969786788e-20,   4.130024028361507e-22,
   7.315229474777280e-24,   1.049153148972594e-25,   1.964690240731485e+00,  -9.551510305032659e-04,  -1.892632436309686e-05,  -3.226977121461325e-07,  -4.936364546621641e-09,
  -6.819950108722204e-11,  -8.362478948667750e-13,  -8.575936277544274e-15,  -5.872211426680209e-17,   1.917056056958314e-19,   1.716813337867562e-20,   4.142853838615175e-22,
   7.331990246908972e-24,   1.050433323437144e-25,   1.964688279832020e+00,  -9.552512359996483e-04,  -1.892938910151822e-05,  -3.227682656663747e-07,  -4.937661815613038e-09,
  -6.821811395591391e-11,  -8.364174084033033e-13,  -8.575207075189370e-15,  -5.864185714021373e-17,   1.940688333305639e-19,   1.721827456201290e-20,   4.151334393118869e-22,
   7.343062609396937e-24,   1.051277189814908e-25,   1.964687272775128e+00,  -9.553026991554741e-04,  -1.893096309564542e-05,  -3.228045007673014e-07,  -4.938328059305660e-09,
  -6.822767234704319e-11,  -8.365044315496432e-13,  -8.574831453960357e-15,  -5.860061102180826e-17,   1.952830886872923e-19,   1.724403424193969e-20,   4.155690442272217e-22,
   7.348747910428745e-24,   1.051709920842515e-25,   1.964686922253196e+00,  -9.553206118300955e-04,  -1.893151095532155e-05,  -3.228171131228028e-07,  -4.938559956935120e-09,
  -6.823099919952409e-11,  -8.365347159486834e-13,  -8.574700533872571e-15,  -5.858625011691500e-17,   1.957058208763068e-19,   1.725300169181416e-20,   4.157206744859461e-22,
   7.350726590028149e-24,   1.051860435724603e-25,   1.964686866629882e+00,  -9.553234543463163e-04,  -1.893159789389525e-05,  -3.228191145487575e-07,  -4.938596756152027e-09,
  -6.823152712362308e-11,  -8.365395214376349e-13,  -8.574679750031950e-15,  -5.858397101045840e-17,   1.957729073761432e-19,   1.725442477653896e-20,   4.157447367831512e-22,
   7.351040572506850e-24,   1.051884315561910e-25,   6.291178192645159e-03,  -1.121206104469244e-04,   1.494399107880674e-06,  -1.765618606807903e-08,   1.946274542969015e-10,
  -2.051133303721306e-12,   2.085526693099727e-14,  -2.068066031224332e-16,   1.990505804542522e-18,  -1.896923069689974e-20,   1.716637637021228e-22,  -1.622789385908696e-24,
   1.355577442959171e-26,  -1.002084414353820e-28,   6.291318512394225e-03,  -1.121255830255706e-04,   1.494508751537380e-06,  -1.765811243460820e-08,   1.946568439508434e-10,
  -2.051541475734625e-12,   2.086050701998857e-14,  -2.068708431203240e-16,   1.991232735472858e-18,  -1.897762638269703e-20,   1.717484193991315e-22,  -1.623515098997885e-24,
   1.357257628267941e-26,  -1.000795055223914e-28,   6.291566117179421e-03,  -1.121343576600267e-04,   1.494702232952380e-06,  -1.766151185012561e-08,   1.947087084551950e-10,
  -2.052261804614820e-12,   2.086975479261314e-14,  -2.069842186664459e-16,   1.992515707597939e-18,  -1.899244373762778e-20,   1.718978803873365e-22,  -1.624794873898759e-24,
   1.360223757216473e-26,  -9.985268145034765e-29,   6.291865537821414e-03,  -1.121449687941104e-04,   1.494936215695339e-06,  -1.766562299082986e-08,   1.947714337956740e-10,
  -2.053133009542278e-12,   2.088093994678014e-14,  -2.071213529118157e-16,   1.994067587684905e-18,  -1.901036621474552e-20,   1.720787546441430e-22,  -1.626341102987479e-24,
   1.363812834152784e-26,  -9.957957310905998e-29,   6.292156225163171e-03,  -1.121552706873135e-04,   1.495163386126023e-06,  -1.766961457133484e-08,   1.948323371823118e-10,
  -2.053978944071042e-12,   2.089180107506987e-14,  -2.072545216500365e-16,   1.995574646179311e-18,  -1.902777045988876e-20,   1.722544955516663e-22,  -1.627840809801328e-24,
   1.367299548740716e-26,  -9.931567064535575e-29,   6.292390409828874e-03,  -1.121635703230908e-04,   1.495346408892820e-06,  -1.767283053529842e-08,   1.948814078347036e-10,
  -2.054660549688630e-12,   2.090055264689623e-14,  -2.073618301689772e-16,   1.996789085782871e-18,  -1.904179497105059e-20,   1.723961785973941e-22,  -1.629047992497646e-24,
   1.370110182185232e-26,  -9.910395396212694e-29,   6.292545160134887e-03,  -1.121690548510140e-04,   1.495467355509784e-06,  -1.767495578218889e-08,   1.949138366065316e-10,
  -2.055111007061928e-12,   2.090633650324806e-14,  -2.074327521801830e-16,   1.997591748482503e-18,  -1.905106401599071e-20,   1.724898533502786e-22,  -1.629845207507323e-24,
   1.371968266812550e-26,  -9.896448648399029e-29,   6.292624633445460e-03,  -1.121718715040276e-04,   1.495529469992839e-06,  -1.767604725852612e-08,   1.949304914950913e-10,
  -2.055342358433186e-12,   2.090930709135775e-14,  -2.074691784967581e-16,   1.998004010684577e-18,  -1.905582470082191e-20,   1.725379762496611e-22,  -1.630254470484050e-24,
   1.372922749761769e-26,  -9.889299667917918e-29,   6.292652295117533e-03,  -1.121728518795151e-04,   1.495551089922729e-06,  -1.767642716647204e-08,   1.949362885666659e-10,
  -2.055422885573877e-12,   2.091034107969570e-14,  -2.074818577215455e-16,   1.998147511315612e-18,  -1.905748179417059e-20,   1.725547284817471e-22,  -1.630396895134054e-24,
   1.373255008814514e-26,  -9.886813524598731e-29,   6.292656684656201e-03,  -1.121730074522492e-04,   1.495554520727561e-06,  -1.767648745308716e-08,   1.949372084908732e-10,
  -2.055435664272906e-12,   2.091050516168066e-14,  -2.074838697736866e-16,   1.998170283316541e-18,  -1.905774475649667e-20,   1.725573869544726e-22,  -1.630419494869356e-24,
   1.373307735767271e-26,  -9.886419108780656e-29,   5.651495181172801e-02,  -9.916414591494456e-04,   1.276175640963419e-05,  -1.415455597769731e-07,   1.407379768985369e-09,
  -1.262897635150003e-11,   9.965418706349021e-14,  -6.474831246811236e-16,   2.413337524845765e-18,   1.413073682353200e-20,  -5.221995382798331e-22,   7.049244011142066e-24,
  -8.994031159781003e-26,   1.010066668572453e-27,   5.651614981484487e-02,  -9.916813105032634e-04,   1.276254885069510e-05,  -1.415574101294139e-07,   1.407519981713630e-09,
  -1.263025030545382e-11,   9.966047614011797e-14,  -6.474344772299037e-16,   2.411116639747984e-18,   1.416737737432077e-20,  -5.227551492872882e-22,   7.056753978966159e-24,
  -8.992115840596614e-26,   1.012320611595777e-27,   5.651826377071678e-02,  -9.917516315566001e-04,   1.276394718957348e-05,  -1.415783212337943e-07,   1.407767396454295e-09,
  -1.263249813894379e-11,   9.967156856443392e-14,  -6.473485372821899e-16,   2.407195948117702e-18,   1.423206181224428e-20,  -5.237354363242647e-22,   7.070018750710190e-24,
  -8.988727196673515e-26,   1.016291455980707e-27,   5.652082009194854e-02,  -9.918366691510059e-04,   1.276563818528632e-05,  -1.416036088203577e-07,   1.408066585233972e-09,
  -1.263521610959354e-11,   9.968497353994124e-14,  -6.472444459244159e-16,   2.402451758060910e-18,   1.431033286087327e-20,  -5.249206436286923e-22,   7.086081332627229e-24,
  -8.984614312265421e-26,   1.021082335161697e-27,   5.652330183243001e-02,  -9.919192270194926e-04,   1.276727988921938e-05,  -1.416281593054705e-07,   1.408357045326570e-09,
  -1.263785452838219e-11,   9.969797836972065e-14,  -6.471432157954012e-16,   2.397842779655509e-18,   1.438637356897971e-20,  -5.260710478763796e-22,   7.101698324766385e-24,
  -8.980605703590774e-26,   1.025722009674644e-27,   5.652530116773043e-02,  -9.919857380354736e-04,   1.276860250664704e-05,  -1.416479380992456e-07,   1.408591045370797e-09,
  -1.263997990378836e-11,   9.970844880705651e-14,  -6.470615370676791e-16,   2.394127410119623e-18,   1.444767151160755e-20,  -5.269976732868725e-22,   7.114296139639878e-24,
  -8.977365125982268e-26,   1.029451616096765e-27,   5.652662233079941e-02,  -9.920296890294205e-04,   1.276947650887548e-05,  -1.416610081820450e-07,   1.408745672920468e-09,
  -1.264138426476744e-11,   9.971536450542391e-14,  -6.470075020103628e-16,   2.391671167239943e-18,   1.448819596193952e-20,  -5.276099093961453e-22,   7.122628850479794e-24,
  -8.975218316892594e-26,   1.031912125537031e-27,   5.652730082297786e-02,  -9.920522604933695e-04,   1.276992536326977e-05,  -1.416677204830374e-07,   1.408825082953861e-09,
  -1.264210545609390e-11,   9.971891512560069e-14,  -6.469797328703301e-16,   2.390409400103820e-18,   1.450901335160254e-20,  -5.279243029040874e-22,   7.126910660814363e-24,
  -8.974114136780370e-26,   1.033174493028101e-27,   5.652753698026101e-02,  -9.920601167817740e-04,   1.277008159313115e-05,  -1.416700567908118e-07,   1.408852722564141e-09,
  -1.264235647091375e-11,   9.972015080469164e-14,  -6.469700644536249e-16,   2.389970171770903e-18,   1.451626001333119e-20,  -5.280337274122223e-22,   7.128401392225586e-24,
  -8.973729548284118e-26,   1.033613676998387e-27,   5.652757445525807e-02,  -9.920613634705174e-04,   1.277010638475246e-05,  -1.416704275321010e-07,   1.408857108600121e-09,
  -1.264239630339345e-11,   9.972034688297694e-14,  -6.469685300612466e-16,   2.389900469495727e-18,   1.451741000520823e-20,  -5.280510914306901e-22,   7.128637970140710e-24,
  -8.973668506654167e-26,   1.033683360206288e-27,   1.563599040197253e-01,  -2.655374129339364e-03,   3.165197749294430e-05,  -3.018005892435127e-07,   2.226533688989858e-09,
  -9.550274542794706e-12,  -5.125913052050685e-14,   1.761886581547585e-15,  -2.447267338216673e-17,   2.209592191354335e-19,  -1.223869764219411e-21,  -6.690404294553465e-24,
   2.221224021325059e-25,  -2.998077138200091e-27,   1.563628739001279e-01,  -2.655459042015791e-03,   3.165322950409365e-05,  -3.018095133329491e-07,   2.226460844861363e-09,
  -9.546793990285059e-12,  -5.132347672834768e-14,   1.762631392829058e-15,  -2.447779150740648e-17,   2.209238777094822e-19,  -1.222471846719354e-21,  -6.712129090989598e-24,
   2.226300784734616e-25,  -2.994459737233549e-27,   1.563681143962767e-01,  -2.655608873806895e-03,   3.165543866400424e-05,  -3.018252573728935e-07,   2.226332236641097e-09,
  -9.540651308845422e-12,  -5.143702752144470e-14,   1.763945526479334e-15,  -2.448681770467764e-17,   2.208614263376691e-19,  -1.220002643216635e-21,  -6.750441500731017e-24,
   2.235260824474007e-25,  -2.988089352353900e-27,   1.563744514229734e-01,  -2.655790055483679e-03,   3.165810994669935e-05,  -3.018442907044526e-07,   2.226176596688045e-09,
  -9.533221480837072e-12,  -5.157435292709219e-14,   1.765534424389678e-15,  -2.449772406248246e-17,   2.207857545921054e-19,  -1.217012496953271e-21,  -6.796732948811665e-24,
   2.246098794092102e-25,  -2.980407683830095e-27,   1.563806034692370e-01,  -2.655965947156775e-03,   3.166070312190479e-05,  -3.018627631889514e-07,   2.226025372662602e-09,
  -9.526006604683746e-12,  -5.170768549467419e-14,   1.767076724360253e-15,  -2.450830315407425e-17,   2.207121316608068e-19,  -1.214105149160448e-21,  -6.841633909539672e-24,
   2.256623616986545e-25,  -2.972972967781264e-27,   1.563855595998226e-01,  -2.656107645807184e-03,   3.166279210726428e-05,  -3.018776409823998e-07,   2.225903454360862e-09,
  -9.520192869861800e-12,  -5.181511040019766e-14,   1.768319055894309e-15,  -2.451681935697253e-17,   2.206527058878145e-19,  -1.211759755783429e-21,  -6.877778376419089e-24,
   2.265104760787276e-25,  -2.966999811938994e-27,   1.563888345824165e-01,  -2.656201279026914e-03,   3.166417245058092e-05,  -3.018874702983971e-07,   2.225822846796245e-09,
  -9.516350511101657e-12,  -5.188610167858289e-14,   1.769139905045709e-15,  -2.452244368616238e-17,   2.206133815735492e-19,  -1.210208359420816e-21,  -6.901648715154861e-24,
   2.270710152827174e-25,  -2.963060775973286e-27,   1.563905164611722e-01,  -2.656249364559956e-03,   3.166488131642637e-05,  -3.018925176075511e-07,   2.225781436690343e-09,
  -9.514377045218438e-12,  -5.192256120374896e-14,   1.769561431361008e-15,  -2.452533111203977e-17,   2.205931690885125e-19,  -1.209411147611131e-21,  -6.913903172942672e-24,
   2.273589159294080e-25,  -2.961040343514676e-27,   1.563911018574192e-01,  -2.656266101232892e-03,   3.166512804264135e-05,  -3.018942742877429e-07,   2.225767021252769e-09,
  -9.513690125600843e-12,  -5.193525161074299e-14,   1.769708144429249e-15,  -2.452633595796084e-17,   2.205861311515538e-19,  -1.209133591844075e-21,  -6.918167796302121e-24,
   2.274591282437381e-25,  -2.960337503869176e-27,   1.563911947518811e-01,  -2.656268757115367e-03,   3.166516719464461e-05,  -3.018945530448039e-07,   2.225764733613547e-09,
  -9.513581119173582e-12,  -5.193726541947801e-14,   1.769731425628933e-15,  -2.452649540609054e-17,   2.205850141951388e-19,  -1.209089543820861e-21,  -6.918844502307933e-24,
   2.274750308354779e-25,  -2.960225991432966e-27,   3.044210361613498e-01,  -4.901942213281038e-03,   5.105734781594601e-05,  -3.502150513924188e-07,   5.503806877761542e-10,
   2.566784673766673e-11,  -4.346155057783332e-13,   3.551594424417949e-15,  -2.311967627260383e-18,  -4.271252908702641e-19,   6.837648898570171e-21,  -5.820104352240503e-23,
  -7.865125968490466e-26,   9.734911144649386e-27,   3.044258233927947e-01,  -4.902040626092226e-03,   5.105765395419981e-05,  -3.501909292615472e-07,   5.497694471174376e-10,
   2.567481585543103e-11,  -4.346209793253499e-13,   3.550145141230781e-15,  -2.283138259242002e-18,  -4.274225671296058e-19,   6.837128346564620e-21,  -5.812869024115800e-23,
  -7.938408950684145e-26,   9.756137427051830e-27,   3.044342705610402e-01,  -4.902214271522512e-03,   5.105819386042893e-05,  -3.501483600768164e-07,   5.486908973193978e-10,
   2.568711065001615e-11,  -4.346305759699071e-13,   3.547587044595760e-15,  -2.232270200258516e-18,  -4.279468112732694e-19,   6.836206147525063e-21,  -5.800089628280587e-23,
  -8.067630391906126e-26,   9.793536825622785e-27,   3.044444850064247e-01,  -4.902424236013724e-03,   5.105884624417633e-05,  -3.500968759189948e-07,   5.473866931293164e-10,
   2.570197368460566e-11,  -4.346420754490799e-13,   3.544492380042196e-15,  -2.170763102187114e-18,  -4.285802133489070e-19,   6.835084748268509e-21,  -5.784615277450784e-23,
  -8.223737551179163e-26,   9.838667204495912e-27,   3.044544010543165e-01,  -4.902628056043399e-03,   5.105947906789732e-05,  -3.500468865196769e-07,   5.461205836044747e-10,
   2.571639831079849e-11,  -4.346531291122707e-13,   3.541486681781813e-15,  -2.111056335815998e-18,  -4.291945646003545e-19,   6.833989555051361e-21,  -5.769570696809059e-23,
  -8.375128461324873e-26,   9.882381104286231e-27,   3.044623893229998e-01,  -4.902792243740579e-03,   5.105998850483226e-05,  -3.500066089254622e-07,   5.451006146323015e-10,
   2.572801562745289e-11,  -4.346619551076587e-13,   3.539064290885884e-15,  -2.062959684620368e-18,  -4.296890875105556e-19,   6.833102585362724e-21,  -5.757434985635970e-23,
  -8.496976213227786e-26,   9.917526237049400e-27,   3.044676678430576e-01,  -4.902900732584945e-03,   5.106032495658019e-05,  -3.499799908874295e-07,   5.444266335997588e-10,
   2.573569068656785e-11,  -4.346677486394965e-13,   3.537463109393761e-15,  -2.031179424802368e-18,  -4.300156681261644e-19,   6.832514193248832e-21,  -5.749408101582174e-23,
  -8.577436956035231e-26,   9.940715103471185e-27,   3.044703786201330e-01,  -4.902956445727110e-03,   5.106049768649891e-05,  -3.499663202242256e-07,   5.440805109483972e-10,
   2.573963174607152e-11,  -4.346707119801618e-13,   3.536640668795300e-15,  -2.014859097219278e-18,  -4.301833237053079e-19,   6.832211315189666e-21,  -5.745283495163268e-23,
  -8.618740708073042e-26,   9.952613047262502e-27,   3.044713221316283e-01,  -4.902975837026028e-03,   5.106055779810777e-05,  -3.499615618612064e-07,   5.439600396083646e-10,
   2.574100339618225e-11,  -4.346717415011294e-13,   3.536354385776736e-15,  -2.009178714555673e-18,  -4.302416683388562e-19,   6.832105782606525e-21,  -5.743847503430583e-23,
  -8.633114203439221e-26,   9.956752539682393e-27,   3.044714718539420e-01,  -4.902978914150014e-03,   5.106056733658295e-05,  -3.499608067667668e-07,   5.439409224572497e-10,
   2.574122105475825e-11,  -4.346719047818770e-13,   3.536308955415958e-15,  -2.008277318756605e-18,  -4.302509263811261e-19,   6.832089030670138e-21,  -5.743619613059733e-23,
  -8.635394953279407e-26,   9.957409339598668e-27,   4.980329969922149e-01,  -7.403755405013697e-03,   6.111082918815835e-05,  -1.423304227362068e-07,  -4.083039249730749e-09,
   6.365925837830278e-11,  -2.780832250017589e-13,  -5.066512602678290e-15,   1.048165416438895e-16,  -6.641370351312964e-19,  -7.588244522699059e-21,   1.997923426120708e-22,
  -1.689431206286224e-24,  -9.092533050649912e-27,   4.980387215062730e-01,  -7.403795225467693e-03,   6.110853029580438e-05,  -1.422708264936296e-07,  -4.083427058636348e-09,
   6.364924853381807e-11,  -2.778087510577980e-13,  -5.068727285461411e-15,   1.047842002714685e-16,  -6.631094963931768e-19,  -7.598493900125827e-21,   1.997247091693295e-22,
  -1.685029774182700e-24,  -9.113326409770545e-27,   4.980488223260581e-01,  -7.403865475673821e-03,   6.110447368743260e-05,  -1.421656756246889e-07,  -4.084111040022855e-09,
   6.363158247385178e-11,  -2.773245066780018e-13,  -5.072632310625923e-15,   1.047270984356203e-16,  -6.612966727903776e-19,  -7.616556945721455e-21,   1.996052457739419e-22,
  -1.677263261274171e-24,  -9.149979571954775e-27,   4.980610360463101e-01,  -7.403950399766311e-03,   6.109956809214491e-05,  -1.420385390968123e-07,  -4.084937583085969e-09,
   6.361021446628561e-11,  -2.767390712635710e-13,  -5.077349505333266e-15,   1.046579907015946e-16,  -6.591050728515978e-19,  -7.638361219013258e-21,   1.994605795768500e-22,
  -1.667871730518463e-24,  -9.194237944108349e-27,   4.980728926014384e-01,  -7.404032818304291e-03,   6.109480550996950e-05,  -1.419151307996646e-07,  -4.085739417091139e-09,
   6.358946447521277e-11,  -2.761708643970358e-13,  -5.081923846864721e-15,   1.045908397802287e-16,  -6.569780146699813e-19,  -7.659488893677363e-21,   1.993199206449553e-22,
  -1.658754429934724e-24,  -9.237137393299690e-27,   4.980824438637405e-01,  -7.404099196196209e-03,   6.109096860996132e-05,  -1.418157244574027e-07,  -4.086384963169176e-09,
   6.357274404165785e-11,  -2.757132130107919e-13,  -5.085605273825765e-15,   1.045366992591926e-16,  -6.552648493467611e-19,  -7.676480745719184e-21,   1.992064505075974e-22,
  -1.651409549610048e-24,  -9.271649607344314e-27,   4.980887550578847e-01,  -7.404143049000527e-03,   6.108843314429324e-05,  -1.417500433050554e-07,  -4.086811332212253e-09,
   6.356169326964183e-11,  -2.754108485641478e-13,  -5.088036131206309e-15,   1.045009023430058e-16,  -6.541329991038566e-19,  -7.687694788677226e-21,   1.991313945807734e-22,
  -1.646556140573717e-24,  -9.294431691564439e-27,   4.980919961240892e-01,  -7.404165566877735e-03,   6.108713102719118e-05,  -1.417163143713971e-07,  -4.087030232411865e-09,
   6.355601748703548e-11,  -2.752555833902942e-13,  -5.089283947300095e-15,   1.044825121683630e-16,  -6.535517951957625e-19,  -7.693449446815236e-21,   1.990928260062655e-22,
  -1.644063670958889e-24,  -9.306124288727136e-27,   4.980931242014546e-01,  -7.404173404011448e-03,   6.108667780797112e-05,  -1.417045749429151e-07,  -4.087106412967021e-09,
   6.355404187030179e-11,  -2.752015440642146e-13,  -5.089718174280698e-15,   1.044761102261541e-16,  -6.533495106670562e-19,  -7.695451725385426e-21,   1.990793980783448e-22,
  -1.643196142325968e-24,  -9.310192875995577e-27,   4.980933032115396e-01,  -7.404174647636712e-03,   6.108660588806458e-05,  -1.417027120684856e-07,  -4.087118501313176e-09,
   6.355372836197867e-11,  -2.751929688689867e-13,  -5.089787075999835e-15,   1.044750942751386e-16,  -6.533174113167390e-19,  -7.695769426999417e-21,   1.990772670715759e-22,
  -1.643058477398853e-24,  -9.310838451219756e-27,   7.324240626806833e-01,  -9.683817241359444e-03,   5.125270681455077e-05,   3.466205398841715e-07,  -8.164801416118777e-09,
   2.390742757391716e-11,   9.627129844491496e-13,  -1.269829142109994e-14,  -4.010961883351132e-17,   2.558389065757130e-18,  -1.884463394188350e-20,  -2.972300094695630e-22,
   6.365602749651277e-24,  -8.245955887437396e-27,   7.324288584084719e-01,  -9.683719676358902e-03,   5.124812175671806e-05,   3.466427441461276e-07,  -8.163448870332141e-09,
   2.388256447913851e-11,   9.626060846492725e-13,  -1.268969688394159e-14,  -4.018786780995696e-17,   2.556854552227868e-18,  -1.880564387910696e-20,  -2.972809251173503e-22,
   6.357021302626589e-24,  -8.075239323309323e-27,   7.324373201971696e-01,  -9.683547516337097e-03,   5.124003196815859e-05,   3.466819050078955e-07,  -8.161062404827622e-09,
   2.383870689330478e-11,   9.624172920321837e-13,  -1.267453589960305e-14,  -4.032580598026323e-17,   2.554146675065632e-18,  -1.873688836728277e-20,  -2.973697579512121e-22,
   6.341888274140185e-24,  -7.774474165626684e-27,   7.324475516884038e-01,  -9.683339330002646e-03,   5.123025076329811e-05,   3.467292265082128e-07,  -8.158176874778439e-09,
   2.378569724838836e-11,   9.621887187265286e-13,  -1.265621025699439e-14,  -4.049237496727694e-17,   2.550871936288650e-18,  -1.865382186992636e-20,  -2.974754576683161e-22,
   6.323604712103879e-24,  -7.411581620014272e-27,   7.324574836209253e-01,  -9.683137217314295e-03,   5.122075644251700e-05,   3.467751316575320e-07,  -8.155375871745583e-09,
   2.373426091830426e-11,   9.619665273433829e-13,  -1.263842756138166e-14,  -4.065383933571612e-17,   2.547692519198851e-18,  -1.857325917838989e-20,  -2.975762725848221e-22,
   6.305871524714288e-24,  -7.060124996935493e-27,   7.324654842109314e-01,  -9.682974391516086e-03,   5.121310873184217e-05,   3.468120880777995e-07,  -8.153119577579526e-09,
   2.369284204087231e-11,   9.617873206780784e-13,  -1.262410744215837e-14,  -4.078374255254525e-17,   2.545130968674018e-18,  -1.850841393941738e-20,  -2.976562022643908e-22,
   6.291597484790579e-24,  -6.777592885582404e-27,   7.324707706400813e-01,  -9.682866795974746e-03,   5.120805564798888e-05,   3.468364963897714e-07,  -8.151628735728189e-09,
   2.366548178125425e-11,   9.616688002893858e-13,  -1.261464760126000e-14,  -4.086949689884152e-17,   2.543438218661828e-18,  -1.846559228745847e-20,  -2.977083896441183e-22,
   6.282171123355251e-24,  -6.591192816415205e-27,   7.324734854069180e-01,  -9.682811539540670e-03,   5.120546076736688e-05,   3.468490275672049e-07,  -8.150863140969358e-09,
   2.365143363706309e-11,   9.616079023075613e-13,  -1.260979033641720e-14,  -4.091351007901180e-17,   2.542568872701339e-18,  -1.844360964517947e-20,  -2.977349960674406e-22,
   6.277331988632713e-24,  -6.495557784867415e-27,   7.324744302956343e-01,  -9.682792306877512e-03,   5.120455761446217e-05,   3.468533885758535e-07,  -8.150596672502832e-09,
   2.364654447499563e-11,   9.615867010996702e-13,  -1.260809985083314e-14,  -4.092882516593874e-17,   2.542266282875129e-18,  -1.843595971035086e-20,  -2.977442257580585e-22,
   6.275647962493794e-24,  -6.462285514351428e-27,   7.324745802359505e-01,  -9.682789254911376e-03,   5.120441429743942e-05,   3.468540805802170e-07,  -8.150554387807495e-09,
   2.364576865239869e-11,   9.615833365175170e-13,  -1.260783160022077e-14,  -4.093125526451896e-17,   2.542218265752445e-18,  -1.843474583395405e-20,  -2.977456889152997e-22,
   6.275380743983197e-24,  -6.457006345794754e-27,   9.992655601197251e-01,  -1.111140472441690e-02,   1.514896243319794e-05,   8.723714502006866e-07,  -4.709632642505725e-09,
  -1.120271093155760e-10,   1.228969856152953e-12,   1.490969726631698e-14,  -3.032017734012177e-16,  -1.649016691768811e-18,   6.972881149193007e-20,   8.605975789937610e-25,
  -1.561245000326000e-23,   7.563154472477564e-26,   9.992669750338261e-01,  -1.111115973944030e-02,   1.514632296756837e-05,   8.722666709559431e-07,  -4.707913738994839e-09,
  -1.119978444181367e-10,   1.228179956024716e-12,   1.490413258859016e-14,  -3.029106628285723e-16,  -1.648991366805360e-18,   6.963352260874696e-20,   1.399605572762026e-24,
  -1.558405751175896e-23,   7.537564487344675e-26,   9.992694714720312e-01,  -1.111072748350430e-02,   1.514166637275523e-05,   8.720818086056036e-07,  -4.704881607386433e-09,
  -1.119462149518615e-10,   1.226786784218969e-12,   1.489431371184915e-14,  -3.023973193103915e-16,  -1.648944435289809e-18,   6.946552626429370e-20,   2.349184788664608e-24,
  -1.553399792595938e-23,   7.492503161749101e-26,   9.992724898508318e-01,  -1.111020483577176e-02,   1.513603690473916e-05,   8.718583090530857e-07,  -4.701216656695207e-09,
  -1.118837992343547e-10,   1.225103201634536e-12,   1.488244076971918e-14,  -3.017771337986780e-16,  -1.648883861226361e-18,   6.926262593898587e-20,   3.494857122531916e-24,
  -1.547353252390885e-23,   7.438172106257314e-26,   9.992754196837355e-01,  -1.110969750108292e-02,   1.513057331351658e-05,   8.716413793191366e-07,  -4.697660393082340e-09,
  -1.118232230373950e-10,   1.223469913663401e-12,   1.487091488392142e-14,  -3.011756491572170e-16,  -1.648821058043406e-18,   6.906590774231082e-20,   4.604370535278966e-24,
  -1.541490409096744e-23,   7.385593067931417e-26,   9.992777796632782e-01,  -1.110928882943410e-02,   1.512617291751853e-05,   8.714666520322476e-07,  -4.694796664393370e-09,
  -1.117744350339153e-10,   1.222154949314541e-12,   1.486162989926715e-14,  -3.006915167342509e-16,  -1.648767603266248e-18,   6.890761593701398e-20,   5.496259351062463e-24,
  -1.536772416566873e-23,   7.343353734177836e-26,   9.992793389705148e-01,  -1.110901880145970e-02,   1.512326570475585e-05,   8.713512092993779e-07,  -4.692904926890289e-09,
  -1.117422023686252e-10,   1.221286431518556e-12,   1.485549460662727e-14,  -3.003718141105424e-16,  -1.648730881869510e-18,   6.880310850449214e-20,   6.084664490826412e-24,
  -1.533657317166194e-23,   7.315500226749895e-26,   9.992801397106738e-01,  -1.110888013380410e-02,   1.512177286357406e-05,   8.712919282447782e-07,  -4.691933603365112e-09,
  -1.117256510778485e-10,   1.220840525788091e-12,   1.485234385911574e-14,  -3.002076944111801e-16,  -1.648711591220217e-18,   6.874946644248473e-20,   6.386548546786967e-24,
  -1.532058327078125e-23,   7.301213873234769e-26,   9.992804184094554e-01,  -1.110883186999371e-02,   1.512125329067495e-05,   8.712712956173628e-07,  -4.691595553046448e-09,
  -1.117198905241633e-10,   1.220685343270620e-12,   1.485124721561601e-14,  -3.001505810575474e-16,  -1.648704808115212e-18,   6.873080020947760e-20,   6.491575892396627e-24,
  -1.531501905315161e-23,   7.296244201542245e-26,   9.992804626348212e-01,  -1.110882421122669e-02,   1.512117084275775e-05,   8.712680215361399e-07,  -4.691541910432922e-09,
  -1.117189764166672e-10,   1.220660718846868e-12,   1.485107319354003e-14,  -3.001415184300983e-16,  -1.648703728463455e-18,   6.872783834319010e-20,   6.508240094615431e-24,
  -1.531413614606632e-23,   7.295455717131174e-26,   1.284354826460383e+00,  -1.097791744973397e-02,  -4.021166703521759e-05,   8.919662055342581e-07,   8.003583968405590e-09,
  -1.291441552069534e-10,  -1.854589719878642e-12,   2.170633907250156e-14,   4.570240022920718e-16,  -3.863326097722042e-18,  -1.192238120070781e-19,   6.176062961262301e-22,
   3.095879411738371e-23,  -8.165613525823946e-26,   1.284351065631781e+00,  -1.097766700984992e-02,  -4.020717966243370e-05,   8.918454904903055e-07,   8.000990007033557e-09,
  -1.291016268391377e-10,  -1.853400278880919e-12,   2.169338269675023e-14,   4.565270720269106e-16,  -3.860164541053293e-18,  -1.190353498837345e-19,   6.170150420061747e-22,
   3.089173933582929e-23,  -8.155060305166051e-26,   1.284344429930729e+00,  -1.097722513226828e-02,  -4.019926280539398e-05,   8.916325192443283e-07,   7.996414277163931e-09,
  -1.290266055614110e-10,  -1.851302548354599e-12,   2.167052962565094e-14,   4.556508744282664e-16,  -3.854588397029644e-18,  -1.187031408389126e-19,   6.159723975597925e-22,
   3.077359893179041e-23,  -8.136398941962107e-26,   1.284336406550091e+00,  -1.097669085611728e-02,  -4.018969167367568e-05,   8.913750472836394e-07,   7.990883566606096e-09,
  -1.289359243102925e-10,  -1.848767751227103e-12,   2.164291020542869e-14,   4.545924636592531e-16,  -3.847849878013757e-18,  -1.183020012757054e-19,   6.147127012469220e-22,
   3.063104677003925e-23,  -8.113765548648253e-26,   1.284328618198316e+00,  -1.097617223922891e-02,  -4.018040229569591e-05,   8.911251556950368e-07,   7.985516867421866e-09,
  -1.288479294536254e-10,  -1.846308898886151e-12,   2.161611319838620e-14,   4.535661242888767e-16,  -3.841312650836705e-18,  -1.179131792658523e-19,   6.134909433860102e-22,
   3.049297791691768e-23,  -8.091722871080878e-26,   1.284322344438455e+00,  -1.097575448341964e-02,  -4.017292040575238e-05,   8.909238876374281e-07,   7.981195256732963e-09,
  -1.287770683946961e-10,  -1.844329429049421e-12,   2.159453694226958e-14,   4.527401401017232e-16,  -3.836049504054202e-18,  -1.176003767482875e-19,   6.125075247272130e-22,
   3.038197914659418e-23,  -8.073915368163183e-26,   1.284318199062689e+00,  -1.097547845506158e-02,  -4.016797724639868e-05,   8.907909135357006e-07,   7.978340461297274e-09,
  -1.287302576180776e-10,  -1.843022091120175e-12,   2.158028515227261e-14,   4.521947463907471e-16,  -3.832573256199643e-18,  -1.173938914794882e-19,   6.118580981228335e-22,
   3.030874447581129e-23,  -8.062124047209872e-26,   1.284316070279748e+00,  -1.097533670662307e-02,  -4.016543892644110e-05,   8.907226312320906e-07,   7.976874649407666e-09,
  -1.287062220482665e-10,  -1.842350914725494e-12,   2.157296785067575e-14,   4.519147848626487e-16,  -3.830788514498760e-18,  -1.172879160211864e-19,   6.115247099810061e-22,
   3.027116936901575e-23,  -8.056061111796983e-26,   1.284315329347836e+00,  -1.097528737062959e-02,  -4.016455547737165e-05,   8.906988659475676e-07,   7.976364501887110e-09,
  -1.286978568854272e-10,  -1.842117338135089e-12,   2.157042126339428e-14,   4.518173614625528e-16,  -3.830167394876056e-18,  -1.172510405737738e-19,   6.114086908563050e-22,
   3.025809648280988e-23,  -8.053949655859135e-26,   1.284315211772643e+00,  -1.097527954172718e-02,  -4.016441528790112e-05,   8.906950947715232e-07,   7.976283550482466e-09,
  -1.286965294795471e-10,  -1.842080274289825e-12,   2.157001716771821e-14,   4.518019026493026e-16,  -3.830068835357195e-18,  -1.172451894361306e-19,   6.113902811531290e-22,
   3.025602225561450e-23,  -8.053614540170070e-26,   1.564434170759178e+00,  -8.784230478650621e-03,  -8.506653284012082e-05,   4.666851861395998e-08,   1.334365657928638e-08,
   1.316286699828671e-10,  -1.360554973841923e-12,  -4.494150077537108e-14,  -1.817178752724546e-16,   9.174301855799328e-18,   1.522679994923922e-19,  -7.155888014326049e-22,
  -5.095485563462092e-23,  -4.094476944888377e-25,   1.564426210832793e+00,  -8.784216921260839e-03,  -8.505903788161076e-05,   4.679118095742583e-08,   1.334173783587918e-08,
   1.315406822794200e-10,  -1.361018952109797e-12,  -4.491063707082426e-14,  -1.810854878316349e-16,   9.170501488131707e-18,   1.519566295954326e-19,  -7.184521583623543e-22,
  -5.087044016466904e-23,  -4.070687973044888e-25,   1.564412165987217e+00,  -8.784192971113694e-03,  -8.504581378796130e-05,   4.700755368314216e-08,   1.333835165755569e-08,
   1.313854759413806e-10,  -1.361836305525824e-12,  -4.485618808644460e-14,  -1.799706947404436e-16,   9.163783809644837e-18,   1.514076373286641e-19,  -7.234905457358745e-22,
  -5.072147160517036e-23,  -4.028779984645183e-25,   1.564395183781310e+00,  -8.784163962745072e-03,  -8.502982457078867e-05,   4.726907983523737e-08,   1.333425615974997e-08,
   1.311978829114750e-10,  -1.362822368719808e-12,  -4.479036573163504e-14,  -1.786244890807462e-16,   9.155640521981565e-18,   1.507445144107209e-19,  -7.295590871482188e-22,
  -5.054131028661751e-23,  -3.978220323219568e-25,   1.564378698766986e+00,  -8.784135752095445e-03,  -8.501430408459672e-05,   4.752284548734006e-08,   1.333027938568647e-08,
   1.310158589330527e-10,  -1.363777226458097e-12,  -4.472648534258705e-14,  -1.773195143183069e-16,   9.147714058267657e-18,   1.501015248074084e-19,  -7.354252976585353e-22,
  -5.036638530252140e-23,  -3.929259192255626e-25,   1.564365419382607e+00,  -8.784112990271108e-03,  -8.500180210712907e-05,   4.772719026340172e-08,   1.332707507874117e-08,
   1.308692858872722e-10,  -1.364544732575980e-12,  -4.467503763163920e-14,  -1.762696029112860e-16,   9.141313519471023e-18,   1.495840843578080e-19,  -7.401331354814560e-22,
  -5.022544881812268e-23,  -3.889903603485083e-25,   1.564356644958785e+00,  -8.784097932191171e-03,  -8.499354157371285e-05,   4.786217578120266e-08,   1.332495740238073e-08,
   1.307724639229353e-10,  -1.365051047868739e-12,  -4.464104851858077e-14,  -1.755765053394302e-16,   9.137076787117509e-18,   1.492424351119467e-19,  -7.432352340740146e-22,
  -5.013231130764003e-23,  -3.863940637489607e-25,   1.564352138982655e+00,  -8.784090193744079e-03,  -8.498929956483590e-05,   4.793148435673648e-08,   1.332386977306777e-08,
   1.307227507645975e-10,  -1.365310805625411e-12,  -4.462359553103416e-14,  -1.752207722093164e-16,   9.134898746089228e-18,   1.490670642009513e-19,  -7.448256041546053e-22,
  -5.008447794030560e-23,  -3.850620552457439e-25,   1.564350570653966e+00,  -8.784087499446683e-03,  -8.498782312190975e-05,   4.795560578020836e-08,   1.332349119762523e-08,
   1.307054491653668e-10,  -1.365401175409637e-12,  -4.461752118513716e-14,  -1.750969887664130e-16,   9.134140296858084e-18,   1.490060378558191e-19,  -7.453787164202959e-22,
  -5.006782865699242e-23,  -3.845986466380107e-25,   1.564350321782636e+00,  -8.784087071857967e-03,  -8.498758883203832e-05,   4.795943342007096e-08,   1.332343112215215e-08,
   1.307027037120456e-10,  -1.365415513890235e-12,  -4.461655728559174e-14,  -1.750773475924948e-16,   9.134019924225889e-18,   1.489963544375279e-19,  -7.454664672808827e-22,
  -5.006518662413455e-23,  -3.845251200022546e-25,   1.804515615263532e+00,  -4.878685946402485e-03,  -7.788276460509713e-05,  -8.232729412677404e-07,  -2.803183350631463e-09,
   1.021744377959993e-10,   2.588238232432795e-12,   2.821668144728073e-14,  -5.944239653007012e-17,  -8.548305562276002e-18,  -1.661996545712139e-19,  -1.236630231924862e-21,
   1.954303865215848e-23,   7.761744929915079e-25,   1.804508310645068e+00,  -4.878917152334060e-03,  -7.788432086041662e-05,  -8.231766901982440e-07,  -2.799545685528568e-09,
   1.022295274807931e-10,   2.588067811739746e-12,   2.818767140319479e-14,  -6.013949792311127e-17,  -8.554460544965217e-18,  -1.660743169167586e-19,  -1.230942416422095e-21,
   1.963863105079018e-23,   7.764022242498688e-25,   1.804495421414514e+00,  -4.879325096754940e-03,  -7.788706523438329e-05,  -8.230068118229554e-07,  -2.793127168625928e-09,
   1.023266875860113e-10,   2.587765616502703e-12,   2.813646599751480e-14,  -6.136911055267379e-17,  -8.565297253401814e-18,  -1.658526780859009e-19,  -1.220904909175356e-21,
   1.980709677311690e-23,   7.767976275780710e-25,   1.804479835420891e+00,  -4.879818349848154e-03,  -7.789038092517182e-05,  -8.228013217448025e-07,  -2.785366172264139e-09,
   1.024440953013085e-10,   2.587397666967815e-12,   2.807451939859758e-14,  -6.285523059010521e-17,  -8.578360438175320e-18,  -1.655838547662377e-19,  -1.208765313444217e-21,
   2.001045133310033e-23,   7.772647909658506e-25,   1.804464704600504e+00,  -4.880297151968215e-03,  -7.789359677113413e-05,  -8.226017608671378e-07,  -2.777832291855122e-09,
   1.025579895905289e-10,   2.587037817440393e-12,   2.801435295087014e-14,  -6.429715312282707e-17,  -8.590999348903190e-18,  -1.653220329108152e-19,  -1.196978201950018e-21,
   2.020749116532993e-23,   7.777068311948524e-25,   1.804452515259719e+00,  -4.880682840461881e-03,  -7.789618528741524e-05,  -8.224409437425858e-07,  -2.771763355123038e-09,
   1.026496817998771e-10,   2.586746028850047e-12,   2.796586235912483e-14,  -6.545818938552207e-17,  -8.601150563084295e-18,  -1.651105022285026e-19,  -1.187481103934052e-21,
   2.036595612996813e-23,   7.780547162673178e-25,   1.804444460687720e+00,  -4.880937682704791e-03,  -7.789789469125072e-05,  -8.223346524767342e-07,  -2.767753237250491e-09,
   1.027102412150720e-10,   2.586552290828371e-12,   2.793381023505069e-14,  -6.622510795567787e-17,  -8.607843356052920e-18,  -1.649704279159395e-19,  -1.181204839219902e-21,
   2.047053572093790e-23,   7.782805710797477e-25,   1.804440324257109e+00,  -4.881068552108731e-03,  -7.789877222978968e-05,  -8.222800587329513e-07,  -2.765693889337032e-09,
   1.027413323520126e-10,   2.586452509733231e-12,   2.791734672136758e-14,  -6.661887266540307e-17,  -8.611275802249859e-18,  -1.648984007634182e-19,  -1.177981446585286e-21,
   2.052420173133415e-23,   7.783953150292041e-25,   1.804438884530974e+00,  -4.881114101721564e-03,  -7.789907761383252e-05,  -8.222610555922374e-07,  -2.764977120731862e-09,
   1.027521524707603e-10,   2.586417734267049e-12,   2.791161593324470e-14,  -6.675591259105222e-17,  -8.612469760534330e-18,  -1.648733163655542e-19,  -1.176859478760512e-21,
   2.054287420949719e-23,   7.784350548086387e-25,   1.804438656066095e+00,  -4.881121329785439e-03,  -7.789912607163979e-05,  -8.222580399943684e-07,  -2.764863379724733e-09,
   1.027538694064053e-10,   2.586412213708056e-12,   2.791070651182295e-14,  -6.677765829945278e-17,  -8.612659190327539e-18,  -1.648693351199030e-19,  -1.176681436189616e-21,
   2.054583696750241e-23,   7.784413515698881e-25,   1.960559176711248e+00,  -1.122498663548686e-03,  -2.328965587068481e-05,  -4.130272144425536e-07,  -6.508185340519875e-09,
  -9.117829194810704e-11,  -1.099690520700749e-12,  -1.020930627527776e-14,  -3.561898300283408e-17,   1.327387927600246e-18,   4.460909911315906e-20,   9.157946085173404e-22,
   1.458711604076204e-23,   1.801171189611248e-25,   1.960556985943603e+00,  -1.122615128941509e-03,  -2.329332545337232e-05,  -4.131128622240949e-07,  -6.509732830034509e-09,
  -9.119831795896562e-11,  -1.099780064355808e-12,  -1.020470172197708e-14,  -3.542786709941432e-17,   1.332161049188600e-18,   4.469988384357395e-20,   9.171076622758693e-22,
   1.459855140594500e-23,   1.800454853154326e-25,   1.960553120018835e+00,  -1.122820653575689e-03,  -2.329980119778641e-05,  -4.132640043251725e-07,  -6.512463500482522e-09,
  -9.123364673914122e-11,  -1.099937655905487e-12,  -1.019656378067232e-14,  -3.509032823562980e-17,   1.340588797600760e-18,   4.486013200645243e-20,   9.194241240965091e-22,
   1.461868870150713e-23,   1.799178751023737e-25,   1.960548444822486e+00,  -1.123069209609184e-03,  -2.330763294440971e-05,  -4.134467929556497e-07,  -6.515765628008474e-09,
  -9.127635399265583e-11,  -1.100127518367425e-12,  -1.018670088923180e-14,  -3.468164077886363e-17,   1.350789098168900e-18,   4.505400297918944e-20,   9.222244555568935e-22,
   1.464296961337207e-23,   1.797614996532460e-25,   1.960543905721341e+00,  -1.123310538535480e-03,  -2.331523713276406e-05,  -4.136242682023728e-07,  -6.518971455584315e-09,
  -9.131780015313585e-11,  -1.100311101070407e-12,  -1.017710268855907e-14,  -3.428433694537303e-17,   1.360701191384953e-18,   4.524231115211848e-20,   9.249421678080947e-22,
   1.466646835897553e-23,   1.796075250270813e-25,   1.960540248721161e+00,  -1.123504975082287e-03,  -2.332136387391008e-05,  -4.137672594443507e-07,  -6.521554156791916e-09,
  -9.135117909723383e-11,  -1.100458467672309e-12,  -1.016935367286743e-14,  -3.396387484589173e-17,   1.368693278161274e-18,   4.539408242846858e-20,   9.271309430422387e-22,
   1.468534641601696e-23,   1.794819298038381e-25,   1.960537832064640e+00,  -1.123633467580227e-03,  -2.332541275887856e-05,  -4.138617550517577e-07,  -6.523260822395464e-09,
  -9.137323063072994e-11,  -1.100555587562165e-12,  -1.016422501714933e-14,  -3.375192364411648e-17,   1.373977749984619e-18,   4.549440570975874e-20,   9.285769617178603e-22,
   1.469779508516392e-23,   1.793981764634368e-25,   1.960536590941466e+00,  -1.123699458427528e-03,  -2.332749219222037e-05,  -4.139102860182612e-07,  -6.524137296195447e-09,
  -9.138455370043117e-11,  -1.100605383653907e-12,  -1.016158865664837e-14,  -3.364301607294572e-17,   1.376692643875165e-18,   4.554593749067924e-20,   9.293194729718826e-22,
   1.470418014168286e-23,   1.793549292207320e-25,   1.960536158948516e+00,  -1.123722427751473e-03,  -2.332821597987706e-05,  -4.139271781353065e-07,  -6.524442364006615e-09,
  -9.138849456793077e-11,  -1.100622702961103e-12,  -1.016067064113584e-14,  -3.360510016483649e-17,   1.377637757057594e-18,   4.556387534531268e-20,   9.295778966859907e-22,
   1.470640125567679e-23,   1.793398390527551e-25,   1.960536090396773e+00,  -1.123726072695576e-03,  -2.332833083604679e-05,  -4.139298587039380e-07,  -6.524490774212888e-09,
  -9.138911991837891e-11,  -1.100625450694673e-12,  -1.016052494543692e-14,  -3.359908297519080e-17,   1.377787741549937e-18,   4.556672191868493e-20,   9.296189042989748e-22,
   1.470675365588369e-23,   1.793374426671046e-25,   5.865335104157771e-03,  -1.009629261596771e-04,   1.299938370872707e-06,  -1.484497980613420e-08,   1.581756978677987e-10,
  -1.613483114974718e-12,   1.586246019398896e-14,  -1.528402789337811e-16,   1.415637852334073e-18,  -1.335334230459014e-20,   1.132901766017499e-22,  -1.046200496430676e-24,
   1.162982987267152e-26,   3.385771815758298e-29,   5.865457152006989e-03,  -1.009671066395605e-04,   1.300027470713918e-06,  -1.484649498027753e-08,   1.581980484872190e-10,
  -1.613784738086706e-12,   1.586618616269524e-14,  -1.528854867087974e-16,   1.416118147051754e-18,  -1.335872713201486e-20,   1.133631861965495e-22,  -1.045952893435085e-24,
   1.165257728853887e-26,   3.386088520261480e-29,   5.865672514166389e-03,  -1.009744835090894e-04,   1.300184699019463e-06,  -1.484916875904638e-08,   1.582374907711547e-10,
  -1.614317029249648e-12,   1.587276171963628e-14,  -1.529652713084918e-16,   1.416965885983258e-18,  -1.336822770701308e-20,   1.134921265722864e-22,  -1.045516001432176e-24,
   1.169265809914179e-26,   3.386452751276093e-29,   5.865932944001800e-03,  -1.009834042902580e-04,   1.300374838617681e-06,  -1.485240231337628e-08,   1.582851920742034e-10,
  -1.614960804938187e-12,   1.588071470405663e-14,  -1.530617728801636e-16,   1.417991409789819e-18,  -1.337971413450021e-20,   1.136482364880131e-22,  -1.044987727425770e-24,
   1.174102638585128e-26,   3.386561802357971e-29,   5.866185776937847e-03,  -1.009920650498839e-04,   1.300559441124811e-06,  -1.485554180299108e-08,   1.583315072895798e-10,
  -1.615585900609890e-12,   1.588843715746391e-14,  -1.531554813025941e-16,   1.418987419958888e-18,  -1.339086310676421e-20,   1.137999880221620e-22,  -1.044474919663639e-24,
   1.178787894245308e-26,   3.386321192763935e-29,   5.866389464576213e-03,  -1.009990424892475e-04,   1.300708167600191e-06,  -1.485807122954390e-08,   1.583688236824173e-10,
  -1.616089562266885e-12,   1.589465957974610e-14,  -1.532309904792774e-16,   1.419790115038408e-18,  -1.339984324645054e-20,   1.139223821619749e-22,  -1.044061838053468e-24,
   1.182554923967368e-26,   3.385879496741219e-29,   5.866524062005448e-03,  -1.010036532743071e-04,   1.300806449818461e-06,  -1.485974277378190e-08,   1.583934843625390e-10,
  -1.616422418318089e-12,   1.589877188916546e-14,  -1.532808948465330e-16,   1.420320679521355e-18,  -1.340577651289326e-20,   1.140033289909808e-22,  -1.043788898461102e-24,
   1.185040508924133e-26,   3.385466425917311e-29,   5.866593185545068e-03,  -1.010060212002974e-04,   1.300856924423498e-06,  -1.486060123633661e-08,   1.584061496283106e-10,
  -1.616593369868797e-12,   1.590088395589432e-14,  -1.533065259869741e-16,   1.420593198614462e-18,  -1.340882332813248e-20,   1.140449209910882e-22,  -1.043648736903258e-24,
   1.186315861655191e-26,   3.385216843226944e-29,   5.866617244836110e-03,  -1.010068453893287e-04,   1.300874492887771e-06,  -1.486090003919226e-08,   1.584105580216422e-10,
  -1.616652873357138e-12,   1.590161911175661e-14,  -1.533154475954330e-16,   1.420688059158418e-18,  -1.340988376808355e-20,   1.140594009575732e-22,  -1.043599953396054e-24,
   1.186759582456731e-26,   3.385124014364395e-29,   5.866621062724221e-03,  -1.010069761772853e-04,   1.300877280776084e-06,  -1.486094745542743e-08,   1.584112575791978e-10,
  -1.616662315847375e-12,   1.590173577237196e-14,  -1.533168633534395e-16,   1.420703112589584e-18,  -1.341005204378027e-20,   1.140616988944851e-22,  -1.043592212174197e-24,
   1.186829986414670e-26,   3.385109000853245e-29,   5.274233276747878e-02,  -8.959771691663777e-04,   1.119038751113549e-05,  -1.209241729517730e-07,   1.177295369909225e-09,
  -1.044576391804949e-11,   8.265674242640120e-14,  -5.656098522290158e-16,   2.610674625588883e-18,  -1.627605322619565e-21,  -2.871484942254255e-22,   4.127970377760660e-24,
  -2.731323231543887e-26,   1.521178074039353e-27,   5.274338319496853e-02,  -8.960112135521298e-04,   1.119105039509336e-05,  -1.209339751993629e-07,   1.177411686431961e-09,
  -1.044687753732697e-11,   8.266357029113196e-14,  -5.656147774778641e-16,   2.609457993786133e-18,  -1.605885789434041e-21,  -2.873119079620583e-22,   4.139136740381085e-24,
  -2.719185026735612e-26,   1.521978848962443e-27,   5.274523674143002e-02,  -8.960712876502580e-04,   1.119222011749524e-05,  -1.209512722685167e-07,   1.177616936565594e-09,
  -1.044884254369362e-11,   8.267561556643373e-14,  -5.656234082412755e-16,   2.607310672198883e-18,  -1.567514478307646e-21,  -2.875996496607914e-22,   4.158844485456019e-24,
  -2.697822938608899e-26,   1.523374129855049e-27,   5.274747815594834e-02,  -8.961439337177435e-04,   1.119363464908561e-05,  -1.209721895170991e-07,   1.177865140516816e-09,
  -1.045121866333557e-11,   8.269017640897746e-14,  -5.656337424033169e-16,   2.604713162004806e-18,  -1.521035577802340e-21,  -2.879465613581553e-22,   4.182682940948549e-24,
  -2.672087144689812e-26,   1.525031178858653e-27,   5.274965417277452e-02,  -8.962144612694551e-04,   1.119500794691852e-05,  -1.209924971360226e-07,   1.178106106537781e-09,
  -1.045352537262863e-11,   8.270430717959682e-14,  -5.656436674420304e-16,   2.602190555239879e-18,  -1.475830978091035e-21,  -2.882822625130125e-22,   4.205832809484160e-24,
  -2.647203316383915e-26,   1.526608301010373e-27,   5.275140720841367e-02,  -8.962712802190067e-04,   1.119611432589959e-05,  -1.210088577760098e-07,   1.178300235603585e-09,
  -1.045538363723368e-11,   8.271568741703303e-14,  -5.656515860458046e-16,   2.600157668805776e-18,  -1.439354767322160e-21,  -2.885519307059654e-22,   4.224487644562636e-24,
  -2.627228943497445e-26,   1.527856266525744e-27,   5.275256561485508e-02,  -8.963088265744855e-04,   1.119684543476837e-05,  -1.210196691273312e-07,   1.178428517514297e-09,
  -1.045661155005572e-11,   8.272320564562172e-14,  -5.656567808444213e-16,   2.598814027896096e-18,  -1.415222568134340e-21,  -2.887297471698560e-22,   4.236817144180080e-24,
  -2.614065364013617e-26,   1.528669876056701e-27,   5.275316052180047e-02,  -8.963281088593211e-04,   1.119722090446799e-05,  -1.210252214380256e-07,   1.178494397923257e-09,
  -1.045724214348394e-11,   8.272706611171198e-14,  -5.656594369643115e-16,   2.598123897174561e-18,  -1.402820445610790e-21,  -2.888209484631164e-22,   4.243149766876888e-24,
  -2.607316103948842e-26,   1.529084297255153e-27,   5.275336758617260e-02,  -8.963348203043569e-04,   1.119735159177729e-05,  -1.210271539967959e-07,   1.178517328443249e-09,
  -1.045746162753033e-11,   8.272840970204093e-14,  -5.656603595946245e-16,   2.597883673860109e-18,  -1.398502327092465e-21,  -2.888526734593092e-22,   4.245354026591623e-24,
  -2.604968692662218e-26,   1.529227998339894e-27,   5.275340044451086e-02,  -8.963358853215385e-04,   1.119737233013137e-05,  -1.210274606685002e-07,   1.178520967212377e-09,
  -1.045749645663656e-11,   8.272862290751220e-14,  -5.656605059152002e-16,   2.597845552921819e-18,  -1.397817032496248e-21,  -2.888577069037101e-22,   4.245703818525938e-24,
  -2.604596272978250e-26,   1.529250775997438e-27,   1.462227376948319e-01,  -2.416053994076494e-03,   2.823764015253421e-05,  -2.677556642661258e-07,   2.026794543143071e-09,
  -1.026999185384287e-11,  -1.176408882113564e-14,   1.096178529890072e-15,  -1.744496455595632e-17,   1.688330713645748e-19,  -1.322112249367834e-21,   1.753965960391962e-24,
   1.639372531072031e-25,   9.512541397440096e-28,   1.462253872568338e-01,  -2.416129334054515e-03,   2.823878012548695e-05,  -2.677652741346121e-07,   2.026777456850914e-09,
  -1.026782468859243e-11,  -1.180999615755061e-14,   1.096748584246678e-15,  -1.745050846694616e-17,   1.688423850420679e-19,  -1.321067618723062e-21,   1.760903678246189e-24,
   1.645927478290371e-25,   9.509948998837137e-28,   1.462300625376151e-01,  -2.416262274827161e-03,   2.824079161778432e-05,  -2.677822292444038e-07,   2.026747255288943e-09,
  -1.026399977880676e-11,  -1.189101218698680e-14,   1.097754479896060e-15,  -1.746028717576513e-17,   1.688588482338024e-19,  -1.319221070850994e-21,   1.773143175119303e-24,
   1.657478603590077e-25,   9.504873970083423e-28,   1.462357160853407e-01,  -2.416423031974322e-03,   2.824322392225632e-05,  -2.678027287230731e-07,   2.026710645659123e-09,
  -1.025937310092483e-11,  -1.198899777077667e-14,   1.098970863656220e-15,  -1.747210553304786e-17,   1.688788052456271e-19,  -1.316982616866159e-21,   1.787939325034562e-24,
   1.671420444949906e-25,   9.497884615116268e-28,   1.462412046068575e-01,  -2.416579096150933e-03,   2.824558514717058e-05,  -2.678226263071296e-07,   2.026675011846788e-09,
  -1.025487997255338e-11,  -1.208414155819833e-14,   1.100151754094213e-15,  -1.748357212724207e-17,   1.688982310399459e-19,  -1.314803718880574e-21,   1.802298744131776e-24,
   1.684927797899442e-25,   9.490208141622563e-28,   1.462456261996514e-01,  -2.416704822231159e-03,   2.824748730909231e-05,  -2.678386534244235e-07,   2.026646238482791e-09,
  -1.025125919915895e-11,  -1.216080325418836e-14,   1.101103097182173e-15,  -1.749280482916378e-17,   1.689139173666757e-19,  -1.313044243361001e-21,   1.813863151161521e-24,
   1.695789682098733e-25,   9.483386484074171e-28,   1.462485479638661e-01,  -2.416787901160571e-03,   2.824874421882279e-05,  -2.678492428209831e-07,   2.026627192636375e-09,
  -1.024886608489816e-11,  -1.221146732775170e-14,   1.101731743977649e-15,  -1.749890336081831e-17,   1.689243008032080e-19,  -1.311879566766547e-21,   1.821502989490365e-24,
   1.702957486052993e-25,   9.478567094330662e-28,   1.462500484464353e-01,  -2.416830566591318e-03,   2.824938970056845e-05,  -2.678546806620509e-07,   2.026617401501380e-09,
  -1.024763692941207e-11,  -1.223748803889277e-14,   1.102054589210441e-15,  -1.750203454499468e-17,   1.689296388198635e-19,  -1.311280817110142e-21,   1.825425865739389e-24,
   1.706635546160129e-25,   9.475995782218788e-28,   1.462505707058160e-01,  -2.416845416752917e-03,   2.824961436615559e-05,  -2.678565733013658e-07,   2.026613991986200e-09,
  -1.024720908244079e-11,  -1.224654514946286e-14,   1.102166959250393e-15,  -1.750312427024980e-17,   1.689314976609198e-19,  -1.311072316150772e-21,   1.826791170380711e-24,
   1.707915258881376e-25,   9.475085486429228e-28,   1.462506535813143e-01,  -2.416847773272257e-03,   2.824965001747846e-05,  -2.678568736347348e-07,   2.026613450866143e-09,
  -1.024714118768257e-11,  -1.224798240544217e-14,   1.102184790866140e-15,  -1.750329718931835e-17,   1.689317926759050e-19,  -1.311039225142197e-21,   1.827007821201033e-24,
   1.708118309361492e-25,   9.474940307559940e-28,   2.856038268789758e-01,  -4.510108549935346e-03,   4.692280036864549e-05,  -3.378353471698232e-07,   9.673878927301047e-10,
   1.640960536266120e-11,  -3.381709198868314e-13,   3.279367867722069e-15,  -1.338024646987356e-17,  -2.042769709649445e-19,   4.357156160603319e-21,  -5.105112536245534e-23,
   3.672840800787124e-25,   8.618013356875948e-27,   2.856082269697863e-01,  -4.510203511550316e-03,   4.692334183640310e-05,  -3.378199090166973e-07,   9.669119305485744e-10,
   1.641605051600293e-11,  -3.382056615864781e-13,   3.278671646973052e-15,  -1.336179117381632e-17,  -2.045377199596760e-19,   4.359442467359533e-21,  -5.098741995913475e-23,
   3.675858404215148e-25,   8.630613313760216e-27,   2.856159910403092e-01,  -4.510371069276907e-03,   4.692429704703317e-05,  -3.377926632432124e-07,   9.660720482093304e-10,
   1.642742197292799e-11,  -3.382669244322217e-13,   3.277442440852525e-15,  -1.332921865946731e-17,  -2.049975479180810e-19,   4.363478170208874e-21,  -5.087493737157949e-23,
   3.681147363112630e-25,   8.652734175439028e-27,   2.856253795073532e-01,  -4.510573675838669e-03,   4.692545172664500e-05,  -3.377597089924071e-07,   9.650563860507362e-10,
   1.644117055386317e-11,  -3.383409368772345e-13,   3.275954855338715e-15,  -1.328981823173968e-17,  -2.055531200629197e-19,   4.368360694073254e-21,  -5.073879752392855e-23,
   3.687482019985861e-25,   8.679292274424099e-27,   2.856344937419475e-01,  -4.510770356464613e-03,   4.692657228079979e-05,  -3.377277088115062e-07,   9.640703282039278e-10,
   1.645451544101717e-11,  -3.384127164472088e-13,   3.274509459976428e-15,  -1.325155494668932e-17,  -2.060919813300534e-19,   4.373103175282036e-21,  -5.060650530994730e-23,
   3.693567887971439e-25,   8.704875014439336e-27,   2.856418361033237e-01,  -4.510928795292321e-03,   4.692747470605214e-05,  -3.377019236025897e-07,   9.632759222655026e-10,
   1.646526447685766e-11,  -3.384704906617878e-13,   3.273344156553872e-15,  -1.322072048502619e-17,  -2.065257378905774e-19,   4.376925516574928e-21,  -5.049983968145556e-23,
   3.698424917789827e-25,   8.725341462337246e-27,   2.856466878306304e-01,  -4.511033486630478e-03,   4.692807087616719e-05,  -3.376848821215667e-07,   9.627509682286990e-10,
   1.647236654697021e-11,  -3.385086421162155e-13,   3.272573698594311e-15,  -1.320034069673655e-17,  -2.068121884481631e-19,   4.379452157896610e-21,  -5.042931169022492e-23,
   3.701611989015601e-25,   8.738795548514553e-27,   2.856491794326989e-01,  -4.511087249956323e-03,   4.692837699585825e-05,  -3.376761295549402e-07,   9.624813715625840e-10,
   1.647601358285584e-11,  -3.385282270685831e-13,   3.272177893609304e-15,  -1.318987317685132e-17,  -2.069592425285092e-19,   4.380749988435779e-21,  -5.039307823497138e-23,
   3.703241783490072e-25,   8.745683302943831e-27,   2.856500466588817e-01,  -4.511105962665081e-03,   4.692848353690349e-05,  -3.376730829926210e-07,   9.623875347563596e-10,
   1.647728293255205e-11,  -3.385350425734407e-13,   3.272040108100022e-15,  -1.318622961813634e-17,  -2.070104177700141e-19,   4.381201754624231e-21,  -5.038046463018024e-23,
   3.703807946699844e-25,   8.748077217662895e-27,   2.856501842757934e-01,  -4.511108932109062e-03,   4.692850044318120e-05,  -3.376725995379539e-07,   9.623726440897508e-10,
   1.647748435922712e-11,  -3.385361240424124e-13,   3.272018242394890e-15,  -1.318565142403261e-17,  -2.070185381830387e-19,   4.381273445801854e-21,  -5.037846291954317e-23,
   3.703897736700354e-25,   8.748456936095301e-27,   4.693834879851881e-01,  -6.922717025130182e-03,   5.905161680643988e-05,  -1.978779044618570e-07,  -2.886226176746660e-09,
   5.563814184849465e-11,  -3.769073376359231e-13,  -2.137778419608376e-15,   7.733944854161496e-17,  -8.163604886488359e-19,  -6.213504660064969e-22,   1.186644628191275e-22,
  -1.471507678068941e-24,   1.632982064676079e-26,   4.693890207982818e-01,  -6.922772494588796e-03,   5.904999033044713e-05,  -1.978257796013855e-07,  -2.886753801621168e-09,
   5.563388957231518e-11,  -3.767043829208972e-13,  -2.140517543432416e-15,   7.733654011464060e-17,  -8.157440490012286e-19,  -6.303035289597132e-22,   1.187823419453292e-22,
  -1.468224620257005e-24,   1.630229812390956e-26,   4.693987834098506e-01,  -6.922870359410143e-03,   5.904712014720228e-05,  -1.977338077181283e-07,  -2.887684572015736e-09,
   5.562638198767929e-11,  -3.763462725087296e-13,  -2.145349075782747e-15,   7.733137757504608e-17,  -8.146558389559608e-19,  -6.460848759612605e-22,   1.189901755848850e-22,
  -1.462435369803717e-24,   1.625356246383715e-26,   4.694105882523279e-01,  -6.922988678289027e-03,   5.904364908049811e-05,  -1.976225998832186e-07,  -2.888809673952831e-09,
   5.561729627581852e-11,  -3.759132524870432e-13,  -2.151188525747554e-15,   7.732508288367042e-17,  -8.133391243160873e-19,  -6.651397738176443e-22,   1.192412066171899e-22,
  -1.455441362800148e-24,   1.619433844947733e-26,   4.694220479673155e-01,  -6.923103518942109e-03,   5.904027899929067e-05,  -1.975146470558549e-07,  -2.889901489208610e-09,
   5.560846821403364e-11,  -3.754928956323780e-13,  -2.156854334531596e-15,   7.731891760389245e-17,  -8.120600021107329e-19,  -6.836085549912132e-22,   1.194846053018192e-22,
  -1.448658435176761e-24,   1.613653929779210e-26,   4.694312796057920e-01,  -6.923196017841946e-03,   5.903756379785684e-05,  -1.974276858295655e-07,  -2.890780744591191e-09,
   5.560135084810927e-11,  -3.751542698869814e-13,  -2.161416465910935e-15,   7.731391191866043e-17,  -8.110289289408928e-19,  -6.984657232543809e-22,   1.196804700511625e-22,
  -1.443199031136163e-24,   1.608975860101795e-26,   4.694373796302418e-01,  -6.923257132006987e-03,   5.903576949041857e-05,  -1.973702254417561e-07,  -2.891361595570847e-09,
   5.559664508112555e-11,  -3.749305160922317e-13,  -2.164429977987872e-15,   7.731058516176534e-17,  -8.103473063799578e-19,  -7.082727775532689e-22,   1.198097889244393e-22,
  -1.439593925143089e-24,   1.605873996792811e-26,   4.694405122606110e-01,  -6.923288514747858e-03,   5.903484798109468e-05,  -1.973407174147237e-07,  -2.891659845402374e-09,
   5.559422759789382e-11,  -3.748156090731047e-13,  -2.165977231795943e-15,   7.730887081237415e-17,  -8.099971654346255e-19,  -7.133059855023369e-22,   1.198761678079897e-22,
  -1.437743264797066e-24,   1.604277743020904e-26,   4.694416025974681e-01,  -6.923299437430925e-03,   5.903452723391730e-05,  -1.973304469762379e-07,  -2.891763646833176e-09,
   5.559338603592977e-11,  -3.747756148338227e-13,  -2.166515715295880e-15,   7.730827317825980e-17,  -8.098752805280941e-19,  -7.150573328650744e-22,   1.198992664002257e-22,
  -1.437099242457260e-24,   1.603721627482072e-26,   4.694417756187291e-01,  -6.923301170692862e-03,   5.903447633540550e-05,  -1.973288172038708e-07,  -2.891780118351026e-09,
   5.559325248523776e-11,  -3.747692683084075e-13,  -2.166601162725500e-15,   7.730817829737941e-17,  -8.098559383531863e-19,  -7.153352235160019e-22,   1.199029315823987e-22,
  -1.436997050534668e-24,   1.603633354698069e-26,   6.945321023459649e-01,  -9.259334738670433e-03,   5.464784343675895e-05,   2.209418207046462e-07,  -7.484810607782444e-09,
   4.268024229004022e-11,   6.018783180730295e-13,  -1.267396318049796e-14,   3.606892706725016e-17,   1.629706894194099e-18,  -2.555629672742291e-20,  -1.911192741849584e-23,
   5.002351583136699e-24,  -3.394186266443796e-26,   6.945372171292337e-01,  -9.259272458749499e-03,   5.464363802336817e-05,   2.209816243864273e-07,  -7.483963127850740e-09,
   4.265537791073814e-11,   6.019707957294660e-13,  -1.266846577871038e-14,   3.596210757222416e-17,   1.629599042721155e-18,  -2.552532527989840e-20,  -1.935230869614367e-23,
   5.002795224925950e-24,  -3.379948650709768e-26,   6.945462419249507e-01,  -9.259162555782493e-03,   5.463621789299015e-05,   2.210518396857113e-07,  -7.482467631293573e-09,
   4.261151311936297e-11,   6.021337466485388e-13,  -1.265876582937331e-14,   3.577372913402115e-17,   1.629407737385640e-18,  -2.547067362031911e-20,  -1.977562524803514e-23,
   5.003561814931515e-24,  -3.354873922437763e-26,   6.945571542590507e-01,  -9.259029644483906e-03,   5.462724605316287e-05,   2.211367125144543e-07,  -7.480659082217056e-09,
   4.255848634433774e-11,   6.023304011275954e-13,  -1.264703706482230e-14,   3.554612106848330e-17,   1.629174706734267e-18,  -2.540458480460102e-20,  -2.028607382611863e-23,
   5.004461131035979e-24,  -3.324634683194570e-26,   6.945677471930893e-01,  -9.258900600313666e-03,   5.461853703870590e-05,   2.212190718095231e-07,  -7.478903187214005e-09,
   4.250702457580594e-11,   6.025209042897626e-13,  -1.263565152786580e-14,   3.532535280750751e-17,   1.628946705150374e-18,  -2.534042338993855e-20,  -2.078011312837029e-23,
   5.005305225019173e-24,  -3.295364108156477e-26,   6.945762803138870e-01,  -9.258796632416360e-03,   5.461152166600548e-05,   2.212853951889694e-07,  -7.477488527304785e-09,
   4.246557889784064e-11,   6.026740806870947e-13,  -1.262647987926781e-14,   3.514764069736243e-17,   1.628761757217217e-18,  -2.528873330508020e-20,  -2.117703510233368e-23,
   5.005964483953568e-24,  -3.271845073232127e-26,   6.945819186477965e-01,  -9.258727926607290e-03,   5.460688627560889e-05,   2.213292086504769e-07,  -7.476553679824838e-09,
   4.243819784206748e-11,   6.027751547549598e-13,  -1.262041960982652e-14,   3.503027825728169e-17,   1.628638924579397e-18,  -2.525457622205543e-20,  -2.143879103982907e-23,
   5.006389962670689e-24,  -3.256333939770463e-26,   6.945848141400999e-01,  -9.258692641132169e-03,   5.460450585596940e-05,   2.213517052961910e-07,  -7.476073570697159e-09,
   4.242413806375285e-11,   6.028270171706626e-13,  -1.261730743119175e-14,   3.497002761225510e-17,   1.628575651863806e-18,  -2.523703456007893e-20,  -2.157305363569843e-23,
   5.006605328719189e-24,  -3.248377449860306e-26,   6.945858219328509e-01,  -9.258680359420086e-03,   5.460367734107479e-05,   2.213595348766003e-07,  -7.475906461101384e-09,
   4.241924470042533e-11,   6.028450613628651e-13,  -1.261622421843403e-14,   3.494906010045244e-17,   1.628553598621144e-18,  -2.523092896618466e-20,  -2.161975924771441e-23,
   5.006679789390407e-24,  -3.245609587998497e-26,   6.945859818552127e-01,  -9.258678410468265e-03,   5.460354586773931e-05,   2.213607772954971e-07,  -7.475879942957301e-09,
   4.241846820393584e-11,   6.028479243955326e-13,  -1.261605232793969e-14,   3.494573300066732e-17,   1.628550097623164e-18,  -2.522996008978503e-20,  -2.162716956464183e-23,
   5.006691581563944e-24,  -3.245170436090595e-26,   9.551266057272197e-01,  -1.094977946208085e-02,   2.509688757113727e-05,   7.808172672715366e-07,  -6.627236457734846e-09,
  -7.865439049261556e-11,   1.505459157360305e-12,   4.783356993814252e-15,  -3.142172140911461e-16,   9.407742588124128e-19,   5.544169186965523e-20,  -5.867673002113199e-22,
  -7.735251586226779e-24,   2.067301902660756e-25,   9.551289510966005e-01,  -1.094956011708748e-02,   2.509317164796847e-05,   7.807436085639885e-07,  -6.625129100023150e-09,
  -7.864492417214151e-11,   1.504639133315343e-12,   4.786454968467386e-15,  -3.139848415062219e-16,   9.378065835993484e-19,   5.539429596610667e-20,  -5.852774202816379e-22,
  -7.725196063080206e-24,   2.063340636291835e-25,   9.551330892560240e-01,  -1.094917309621888e-02,   2.508661580442480e-05,   7.806136438439876e-07,  -6.621411569769846e-09,
  -7.862821577977148e-11,   1.503192682958365e-12,   4.791913293048839e-15,  -3.135749785699622e-16,   9.325762972230336e-19,   5.531071571928379e-20,  -5.826508541611668e-22,
  -7.707453966066849e-24,   2.056354266961943e-25,   9.551380926822646e-01,  -1.094870513513264e-02,   2.507869004724657e-05,   7.804565014432389e-07,  -6.616917887324078e-09,
  -7.860800343137026e-11,   1.501444463461611e-12,   4.798499757211843e-15,  -3.130796442809229e-16,   9.262623834268089e-19,   5.520973581481400e-20,  -5.794787887015670e-22,
  -7.686001880765422e-24,   2.047911981318800e-25,   9.551429494188969e-01,  -1.094825087664582e-02,   2.507099757521932e-05,   7.803039632329791e-07,  -6.612557167815644e-09,
  -7.858837286732846e-11,   1.499748205479284e-12,   4.804879346014576e-15,  -3.125990715695971e-16,   9.201440414031342e-19,   5.511179655802294e-20,  -5.764035961414794e-22,
  -7.665178615865451e-24,   2.039722331434406e-25,   9.551468615824505e-01,  -1.094788495343528e-02,   2.506480184892444e-05,   7.801810896883126e-07,  -6.609045424819761e-09,
  -7.857255246728939e-11,   1.498382354735552e-12,   4.810008326506848e-15,  -3.122121355770856e-16,   9.152231289589403e-19,   5.503296265243122e-20,  -5.739292645377931e-22,
  -7.648405211445116e-24,   2.033129136116486e-25,   9.551494464940316e-01,  -1.094764316843227e-02,   2.506070842507118e-05,   7.800999015707398e-07,  -6.606725513026328e-09,
  -7.856209556058216e-11,   1.497480134561266e-12,   4.813392410227397e-15,  -3.119565565414500e-16,   9.119753649844950e-19,   5.498090228234876e-20,  -5.722957404067909e-22,
  -7.637322434073620e-24,   2.028774565424195e-25,   9.551507739152616e-01,  -1.094751900352245e-02,   2.505860644212097e-05,   7.800582089893633e-07,  -6.605534308332924e-09,
  -7.855672449045941e-11,   1.497016897080717e-12,   4.815128736668477e-15,  -3.118253358196670e-16,   9.103086844478238e-19,   5.495417658530847e-20,  -5.714573021452475e-22,
  -7.631631148563679e-24,   2.026538932939549e-25,   9.551512359276928e-01,  -1.094747578730722e-02,   2.505787485732502e-05,   7.800436977277769e-07,  -6.605119727446029e-09,
  -7.855485488942500e-11,   1.496855678275091e-12,   4.815732832319657e-15,  -3.117796682346423e-16,   9.097287722841919e-19,   5.494487602089212e-20,  -5.711655483842959e-22,
  -7.629650285081990e-24,   2.025760903723957e-25,   9.551513092422904e-01,  -1.094746892951367e-02,   2.505775876629954e-05,   7.800413950010107e-07,  -6.605053940536890e-09,
  -7.855455820232734e-11,   1.496830095794521e-12,   4.815828682176318e-15,  -3.117724216546651e-16,   9.096367572893168e-19,   5.494340022342774e-20,  -5.711192545152330e-22,
  -7.629335951266081e-24,   2.025637446099095e-25,   1.239870355586471e+00,  -1.125483030450023e-02,  -2.883216545672138e-05,   9.971765204107611e-07,   5.032710606823330e-09,
  -1.648680116115693e-10,  -1.069103922563708e-12,   3.326364107800145e-14,   2.424215268664519e-16,  -7.682806445762306e-18,  -6.282673606829461e-20,   1.828069198623240e-21,
   1.638174170249338e-23,  -4.335369524872237e-25,   1.239867658241970e+00,  -1.125455039153091e-02,  -2.882934300274076e-05,   9.970225037225207e-07,   5.031214635639894e-09,
  -1.648029319946069e-10,  -1.068472965211709e-12,   3.323795376460566e-14,   2.421596899169916e-16,  -7.673500659300322e-18,  -6.272662011265043e-20,   1.824969583466471e-21,
   1.635475420266573e-23,  -4.322509066243983e-25,   1.239862898949212e+00,  -1.125405651580767e-02,  -2.882436342059076e-05,   9.967507883266167e-07,   5.028575690157516e-09,
  -1.646881389809835e-10,  -1.067360187870923e-12,   3.319265354123808e-14,   2.416980167847415e-16,  -7.657093374121501e-18,  -6.255009893072686e-20,   1.819507850955575e-21,
   1.630720322479166e-23,  -4.299859925694256e-25,   1.239857144326491e+00,  -1.125345937587185e-02,  -2.881834321980508e-05,   9.964223115017002e-07,   5.025385874953653e-09,
  -1.645493999132951e-10,  -1.066015554568007e-12,   3.313791938915692e-14,   2.411403400074759e-16,  -7.637275519999510e-18,  -6.233687757649294e-20,   1.812916384873238e-21,
   1.624982127494236e-23,  -4.272546144954913e-25,   1.239851558220475e+00,  -1.125287974543939e-02,  -2.881250013084938e-05,   9.961035201735108e-07,   5.022290540733126e-09,
  -1.644147875605809e-10,  -1.064711200924424e-12,   3.308482979920065e-14,   2.405995674759105e-16,  -7.618059711709445e-18,  -6.213012647242770e-20,   1.806531010181511e-21,
   1.619423826793244e-23,  -4.246107559172883e-25,   1.239847058399859e+00,  -1.125241284760427e-02,  -2.880779388668895e-05,   9.958467692636820e-07,   5.019797898729294e-09,
  -1.643063979740407e-10,  -1.063661141689158e-12,   3.304209400696955e-14,   2.401643652443147e-16,  -7.602596181753235e-18,  -6.196374257467059e-20,   1.801396696938790e-21,
   1.614954878149832e-23,  -4.224864174967026e-25,   1.239844085132578e+00,  -1.125210435181537e-02,  -2.880468451141340e-05,   9.956771437917649e-07,   5.018151255102396e-09,
  -1.642348016998632e-10,  -1.062967629243714e-12,   3.301387085647703e-14,   2.398770052575799e-16,  -7.592386215527141e-18,  -6.185388324005635e-20,   1.798008758411384e-21,
   1.612006149336133e-23,  -4.210853915384941e-25,   1.239842558259007e+00,  -1.125194593126465e-02,  -2.880308783047591e-05,   9.955900425672609e-07,   5.017305763883544e-09,
  -1.641980415126309e-10,  -1.062611585000507e-12,   3.299938183353365e-14,   2.397294982793561e-16,  -7.587145399956925e-18,  -6.179749123077781e-20,   1.796270349517835e-21,
   1.610493155392828e-23,  -4.203667316151930e-25,   1.239842026823276e+00,  -1.125189079262338e-02,  -2.880253211207379e-05,   9.955597277120893e-07,   5.017011505059600e-09,
  -1.641852480543545e-10,  -1.062487677664694e-12,   3.299433957876212e-14,   2.396781676497193e-16,  -7.585321682464437e-18,  -6.177786761563609e-20,   1.795665512639840e-21,
   1.609966753864893e-23,  -4.201167281451812e-25,   1.239841942492058e+00,  -1.125188204293176e-02,  -2.880244392821472e-05,   9.955549172344074e-07,   5.016964811287723e-09,
  -1.641832179686056e-10,  -1.062468016089825e-12,   3.299353947951036e-14,   2.396700226853439e-16,  -7.585032302428573e-18,  -6.177475381468610e-20,   1.795569544380834e-21,
   1.609883231151701e-23,  -4.200770623358257e-25,   1.527945101724929e+00,  -9.458706786258866e-03,  -8.314557979461545e-05,   2.790180857552325e-07,   1.554581425629626e-08,
   8.356275891060915e-11,  -2.642873412876500e-12,  -4.440359249988749e-14,   2.436469251171800e-16,   1.386569560980939e-17,   6.278602849311256e-20,  -3.356629123573083e-21,
  -5.097032506865618e-23,   5.230513710393497e-25,   1.527937324353669e+00,  -9.458628039361348e-03,  -8.313685622252506e-05,   2.790956976062114e-07,   1.554210535641489e-08,
   8.347607576521200e-11,  -2.642228603257704e-12,  -4.435724251700634e-14,   2.439019748230347e-16,   1.384853865197306e-17,   6.247905201464275e-20,  -3.352764071394355e-21,
  -5.078835990528016e-23,   5.237936144335713e-25,   1.527923601721929e+00,  -9.458489071599598e-03,  -8.312146503643413e-05,   2.792325790977082e-07,   1.553556168337857e-08,
   8.332319595718202e-11,  -2.641090288153471e-12,  -4.427550420765953e-14,   2.443509685300730e-16,   1.381828117262576e-17,   6.193829765570161e-20,  -3.345939832797745e-21,
  -5.046772226135679e-23,   5.250944307867936e-25,   1.527907009298024e+00,  -9.458321000260103e-03,  -8.310285673811107e-05,   2.793979854346780e-07,   1.552765026475871e-08,
   8.313845812612648e-11,  -2.639712908891270e-12,  -4.417674541865240e-14,   2.448921159657375e-16,   1.378172121253832e-17,   6.128596260565037e-20,  -3.337680606220171e-21,
  -5.008075829421205e-23,   5.266522736648411e-25,   1.527890902842292e+00,  -9.458157808071443e-03,  -8.308479514855802e-05,   2.795584415715485e-07,   1.551997131726672e-08,
   8.295924978734060e-11,  -2.638374815160086e-12,  -4.408095588224264e-14,   2.454155906704466e-16,   1.374625846630585e-17,   6.065430917423671e-20,  -3.329655109735742e-21,
  -4.970588993058646e-23,   5.281488065224527e-25,   1.527877928537954e+00,  -9.458026320047866e-03,  -8.307024713361848e-05,   2.796876188152027e-07,   1.551378620371910e-08,
   8.281497637546174e-11,  -2.637296179366268e-12,  -4.400384908256406e-14,   2.458359629845853e-16,   1.371771094995909e-17,   6.014661827544219e-20,  -3.323184473693909e-21,
  -4.940446618203752e-23,   5.293431039870683e-25,   1.527869355763429e+00,  -9.457939424082240e-03,  -8.306063512530845e-05,   2.797729356565538e-07,   1.550969965454597e-08,
   8.271968932379497e-11,  -2.636583101261421e-12,  -4.395292765194311e-14,   2.461130860616929e-16,   1.369885745360857e-17,   5.981171302457678e-20,  -3.318906161464221e-21,
  -4.920556738384672e-23,   5.301267572774194e-25,   1.527864953361747e+00,  -9.457894795438201e-03,  -8.305569922716714e-05,   2.798167372045149e-07,   1.550760115943935e-08,
   8.267076916233033e-11,  -2.636216798116196e-12,  -4.392678614108299e-14,   2.462552007163161e-16,   1.368917843460822e-17,   5.963989864908648e-20,  -3.316708232467528e-21,
  -4.910350885593111e-23,   5.305274967633719e-25,   1.527863421085939e+00,  -9.457879261487480e-03,  -8.305398129484086e-05,   2.798319807076652e-07,   1.550687078183685e-08,
   8.265374432818353e-11,  -2.636089286498012e-12,  -4.391768879421099e-14,   2.463046329898616e-16,   1.368581006552831e-17,   5.958012501091218e-20,  -3.315943094292847e-21,
  -4.906800006291778e-23,   5.306667067380686e-25,   1.527863177935840e+00,  -9.457876796437685e-03,  -8.305370868511963e-05,   2.798343995454675e-07,   1.550675488205446e-08,
   8.265104282951872e-11,  -2.636069051379412e-12,  -4.391624523916583e-14,   2.463124756904439e-16,   1.368527557558428e-17,   5.957064108340287e-20,  -3.315821671289784e-21,
  -4.906236595266034e-23,   5.306887845791662e-25,   1.783691336048512e+00,  -5.541849093758920e-03,  -8.795206188283009e-05,  -8.481402567235392e-07,  -7.701390477641519e-11,
   1.732255571708558e-10,   3.295756938872150e-12,   2.002434789467518e-14,  -4.962359302705449e-16,  -1.584049420919685e-17,  -1.827882781700824e-19,   9.316859829679350e-22,
   7.571649747745479e-23,   1.328102117383469e-24,   1.783683090524863e+00,  -5.542087059507391e-03,  -8.795207913874890e-05,  -8.479775345940719e-07,  -7.239486858084828e-11,
   1.732641321317762e-10,   3.294438754448667e-12,   1.997102268217245e-14,  -4.969919407357805e-16,  -1.583531982741128e-17,  -1.823180961791170e-19,   9.412312437223448e-22,
   7.575378035970793e-23,   1.325095063202131e-24,   1.783668541170239e+00,  -5.542506916556984e-03,  -8.795210747842536e-05,  -8.476903796920925e-07,  -6.424601959433291e-11,
   1.733321129736918e-10,   3.292111193012734e-12,   1.987694397408044e-14,  -4.983243190009529e-16,  -1.582614970604694e-17,  -1.814882717058315e-19,   9.580560393171452e-22,
   7.581896862790311e-23,   1.319782358059743e-24,   1.783650947937961e+00,  -5.543014548656282e-03,  -8.795213815209396e-05,  -8.473430992669071e-07,  -5.439492545113999e-11,
   1.734141707347431e-10,   3.289293947778889e-12,   1.976320773931606e-14,  -4.999326924548222e-16,  -1.581499321288927e-17,  -1.804845326021152e-19,   9.783700993382522e-22,
   7.589677599638210e-23,   1.313346771382632e-24,   1.783633868735659e+00,  -5.543507282576398e-03,  -8.795216416554978e-05,  -8.470059135057113e-07,  -4.483435829425225e-11,
   1.734936787485573e-10,   3.286556155833650e-12,   1.965282057853878e-14,  -5.014911905600180e-16,  -1.580409166059113e-17,  -1.795098017308269e-19,   9.980584931666522e-22,
   7.597124373801555e-23,   1.307087315392727e-24,   1.783620109954675e+00,  -5.543904174938836e-03,  -8.795218242517929e-05,  -8.467342438694882e-07,  -3.713442861951023e-11,
   1.735576203054960e-10,   3.284348579878131e-12,   1.956391281845462e-14,  -5.027446303346854e-16,  -1.579525867150345e-17,  -1.787243449869425e-19,   1.013896151906728e-21,
   7.603047051783345e-23,   1.302036284782675e-24,   1.783611018398461e+00,  -5.544166410996617e-03,  -8.795219317072573e-05,  -8.465547112292318e-07,  -3.204740204700885e-11,
   1.735998183519921e-10,   3.282888851914256e-12,   1.950517333804218e-14,  -5.035718692761960e-16,  -1.578939711571347e-17,  -1.782052191405876e-19,   1.024350096426942e-21,
   7.606923292458403e-23,   1.298694507605860e-24,   1.783606349449695e+00,  -5.544301074539843e-03,  -8.795219828086438e-05,  -8.464625070079270e-07,  -2.943526432369403e-11,
   1.736214725562506e-10,   3.282138902343028e-12,   1.947501065015392e-14,  -5.039963831354640e-16,  -1.578637923786329e-17,  -1.779385893126902e-19,   1.029715200981053e-21,
   7.608902378427639e-23,   1.296977065644862e-24,   1.783604724379379e+00,  -5.544347944269812e-03,  -8.795219999451006e-05,  -8.464304135898822e-07,  -2.852613265409929e-11,
   1.736290068717696e-10,   3.281877826283698e-12,   1.946451270399470e-14,  -5.041440892518123e-16,  -1.578532761418049e-17,  -1.778457809819118e-19,   1.031582017975335e-21,
   7.609589379207774e-23,   1.296379090791582e-24,   1.783604466503104e+00,  -5.544355381795888e-03,  -8.795220026335705e-05,  -8.464253207639807e-07,  -2.838186820017691e-11,
   1.736302023390933e-10,   3.281836394771274e-12,   1.946284684606277e-14,  -5.041675258130610e-16,  -1.578516067790130e-17,  -1.778310533229956e-19,   1.031878229686291e-21,
   7.609698309512342e-23,   1.296284190764277e-24,   1.955662463297694e+00,  -1.330559840362601e-03,  -2.893586063459516e-05,  -5.332795094209391e-07,  -8.619258042624396e-09,
  -1.210713228046110e-10,  -1.391345980062395e-12,  -1.014755618421185e-14,   5.613553224952492e-17,   4.159777478144831e-18,   1.039313902881252e-19,   1.867900394712513e-21,
   2.546330193872832e-23,   2.204727213229303e-25,   1.955659740810934e+00,  -1.330710225349723e-03,  -2.894071999037217e-05,  -5.333931793901477e-07,  -8.621212753620196e-09,
  -1.210910728641903e-10,  -1.391189449377772e-12,  -1.013326406849256e-14,   5.657904587171586e-17,   4.169469620928521e-18,   1.040886246935706e-19,   1.869469739584086e-21,
   2.545663107849122e-23,   2.197009152477833e-25,   1.955654936568452e+00,  -1.330975608049549e-03,  -2.894929529368917e-05,  -5.335937668249313e-07,  -8.624661689398806e-09,
  -1.211258991548381e-10,  -1.390912298935437e-12,  -1.010801876638209e-14,   5.736217165107980e-17,   4.186578094222685e-18,   1.043660320331348e-19,   1.872234239472704e-21,
   2.544470767667883e-23,   2.183356863831081e-25,   1.955649126593176e+00,  -1.331296556021523e-03,  -2.895966616569253e-05,  -5.338363448344061e-07,  -8.628831867428145e-09,
  -1.211679722311327e-10,  -1.390575545747169e-12,  -1.007744644324826e-14,   5.831005469252798e-17,   4.207276972065218e-18,   1.047014153337918e-19,   1.875569187496302e-21,
   2.543002938334795e-23,   2.166790968571001e-25,   1.955643485705835e+00,  -1.331608173230072e-03,  -2.896973562414864e-05,  -5.340718620969864e-07,  -8.632879876435636e-09,
  -1.212087749094831e-10,  -1.390246934219815e-12,  -1.004771976742726e-14,   5.923120538071508e-17,   4.227382721613802e-18,   1.050269354844954e-19,   1.878798391512663e-21,
   2.541550694966412e-23,   2.150648938335281e-25,   1.955638941004617e+00,  -1.331859241300750e-03,  -2.897784859200611e-05,  -5.342616108820834e-07,  -8.636140664428164e-09,
  -1.212416155165503e-10,  -1.389980992184523e-12,  -1.002373823223145e-14,   5.997396175986006e-17,   4.243587977963889e-18,   1.052891238450077e-19,   1.881393832844772e-21,
   2.540361203333370e-23,   2.137602009691522e-25,   1.955635937714063e+00,  -1.332025158914635e-03,  -2.898321005629805e-05,  -5.343870028666738e-07,  -8.638295219505482e-09,
  -1.212633015500617e-10,  -1.389804666330982e-12,  -1.000787495454366e-14,   6.046509944292194e-17,   4.254300194419686e-18,   1.054623503129711e-19,   1.883105929398423e-21,
   2.539565610739664e-23,   2.128959709507166e-25,   1.955634395308615e+00,  -1.332110370591010e-03,  -2.898596359782387e-05,  -5.344514005466455e-07,  -8.639401650839994e-09,
  -1.212744338934232e-10,  -1.389713930159697e-12,  -9.999723234854346e-15,   6.071742651132911e-17,   4.259802688315113e-18,   1.055513032606345e-19,   1.883984267301258e-21,
   2.539154065727360e-23,   2.124514940504060e-25,   1.955633858448805e+00,  -1.332140030098150e-03,  -2.898692202072151e-05,  -5.344738152098752e-07,  -8.639786748695500e-09,
  -1.212783078952497e-10,  -1.389682319240819e-12,  -9.996885131397731e-15,   6.080526787316621e-17,   4.261718081917749e-18,   1.055822630095727e-19,   1.884289836584745e-21,
   2.539010350690468e-23,   2.122966857484682e-25,   1.955633773256002e+00,  -1.332144736691569e-03,  -2.898707411054379e-05,  -5.344773721301122e-07,  -8.639847858150674e-09,
  -1.212789226121700e-10,  -1.389677301629253e-12,  -9.996434724405021e-15,   6.081920787627133e-17,   4.262022038006087e-18,   1.055871758411937e-19,   1.884338319370914e-21,
   2.538987522633733e-23,   2.122721148632037e-25,   5.481211861934858e-03,  -9.123527940981406e-05,   1.135981818562987e-06,  -1.255300963223193e-08,   1.293910620385809e-10,
  -1.279434416293392e-12,   1.215063393249647e-14,  -1.144365710863562e-16,   1.006969871355085e-18,  -9.566196124202780e-21,   8.084111371403834e-23,  -3.856495100451869e-25,
   1.695291981035827e-26,   1.518950427333180e-28,   5.481318506324252e-03,  -9.123881416887598e-05,   1.136054697535859e-06,  -1.255421099872082e-08,   1.294081801887702e-10,
  -1.279660227317148e-12,   1.215328434690653e-14,  -1.144689075378568e-16,   1.007314297991762e-18,  -9.568143528975586e-21,   8.094617571047996e-23,  -3.845859260254121e-25,
   1.695671174800149e-26,   1.510415759033294e-28,   5.481506687596192e-03,  -9.124505158197457e-05,   1.136183301467720e-06,  -1.255633100109177e-08,   1.294383884675244e-10,
  -1.280058726209600e-12,   1.215796178200220e-14,  -1.145259710295093e-16,   1.007922404707080e-18,  -9.571575345144763e-21,   8.113157675158234e-23,  -3.827142978839654e-25,
   1.696325940819701e-26,   1.495349713062209e-28,   5.481734247897163e-03,  -9.125259439767800e-05,   1.136338824081130e-06,  -1.255889482442619e-08,   1.294749218138185e-10,
  -1.280540683637933e-12,   1.216361904396616e-14,  -1.145949818663687e-16,   1.008658348560030e-18,  -9.575717628791050e-21,   8.135579501106922e-23,  -3.804597739651728e-25,
   1.697093292145709e-26,   1.477120704655341e-28,   5.481955169443269e-03,  -9.125991732391167e-05,   1.136489816738988e-06,  -1.256138404745575e-08,   1.295103931717232e-10,
  -1.281008652051297e-12,   1.216911233343727e-14,  -1.146619858620087e-16,   1.009373433886343e-18,  -9.579731045393627e-21,   8.157349231336931e-23,  -3.782802023597871e-25,
   1.697812712414328e-26,   1.459412898390412e-28,   5.482133148093819e-03,  -9.126581693010620e-05,   1.136611464490169e-06,  -1.256338955365992e-08,   1.295389723186684e-10,
  -1.281385707589660e-12,   1.217353860044602e-14,  -1.147159701872555e-16,   1.009949958621291e-18,  -9.582958596958622e-21,   8.174888755208095e-23,  -3.765308767559183e-25,
   1.698374016893246e-26,   1.445139623756423e-28,   5.482250756704771e-03,  -9.126971545716645e-05,   1.136691852068194e-06,  -1.256471486440694e-08,   1.295578588109450e-10,
  -1.281634891622248e-12,   1.217646386145346e-14,  -1.147516453832646e-16,   1.010331141771860e-18,  -9.585088566655045e-21,   8.186479576560402e-23,  -3.753781414304241e-25,
   1.698735991749213e-26,   1.435704163140350e-28,   5.482311155432975e-03,  -9.127171759066324e-05,   1.136733136454798e-06,  -1.256539550828343e-08,   1.295675585163907e-10,
  -1.281762869581865e-12,   1.217796626605949e-14,  -1.147699673281524e-16,   1.010526967415768e-18,  -9.586181562116767e-21,   8.192432328474054e-23,  -3.747871427584425e-25,
   1.698919125338809e-26,   1.430857391902806e-28,   5.482332177935241e-03,  -9.127241446004959e-05,   1.136747506105442e-06,  -1.256563241793436e-08,   1.295709346813088e-10,
  -1.281807415080460e-12,   1.217848921452819e-14,  -1.147763446119419e-16,   1.010595137446052e-18,  -9.586561854630029e-21,   8.194504287393617e-23,  -3.745815972601396e-25,
   1.698982427823709e-26,   1.429170236587729e-28,   5.482335513924979e-03,  -9.127252504402670e-05,   1.136749786382577e-06,  -1.256567001248559e-08,   1.295714704366281e-10,
  -1.281814483913448e-12,   1.217857220032984e-14,  -1.147773566067908e-16,   1.010605955618989e-18,  -9.586622195428131e-21,   8.194833081062881e-23,  -3.745489874741138e-25,
   1.698992452227421e-26,   1.428902499161874e-28,   4.932871205229142e-02,  -8.119534083793877e-04,   9.845758422373740e-06,  -1.036562010373160e-07,   9.869832040595465e-10,
  -8.642731657725488e-12,   6.796663297452564e-14,  -4.848778882339066e-16,   2.387865013106523e-18,  -9.553276559924832e-21,  -1.025956294702589e-22,   5.054077334008738e-24,
   7.171878581431342e-26,   2.150004885037137e-27,   4.932963620591675e-02,  -8.119825901986455e-04,   9.846314139299917e-06,  -1.036643116131175e-07,   9.870788559612073e-10,
  -8.643686759391968e-12,   6.797289250610687e-14,  -4.849094333293178e-16,   2.387446420581193e-18,  -9.526622940705558e-21,  -1.021528364534437e-22,   5.069395940784216e-24,
   7.169989629196660e-26,   2.142705085893558e-27,   4.933126693197253e-02,  -8.120340838345237e-04,   9.847294754333805e-06,  -1.036786235800522e-07,   9.872476424020784e-10,
  -8.645372101479800e-12,   6.798393666351966e-14,  -4.849650215776980e-16,   2.386709325280711e-18,  -9.479528406859061e-21,  -1.013716310384902e-22,   5.096382387308395e-24,
   7.166522384365234e-26,   2.129818604107899e-27,   4.933323889571810e-02,  -8.120963536551936e-04,   9.848480599153064e-06,  -1.036959310052944e-07,   9.874517529700553e-10,
  -8.647410120606090e-12,   6.799728987067724e-14,  -4.850321139213748e-16,   2.385820609456539e-18,  -9.422472528123332e-21,  -1.004271809768952e-22,   5.128940533027340e-24,
   7.162101282782966e-26,   2.114226195522918e-27,   4.933515331978153e-02,  -8.121568074347451e-04,   9.849631874944893e-06,  -1.037127340546771e-07,   9.876499127514443e-10,
  -8.649388683692315e-12,   6.801025135881712e-14,  -4.850971143695880e-16,   2.384960568958157e-18,  -9.366970034992832e-21,  -9.951053200492458e-23,   5.160469734580656e-24,
   7.157570457420250e-26,   2.099079043463892e-27,   4.933669560921954e-02,  -8.122055105890692e-04,   9.850559383760636e-06,  -1.037262713046112e-07,   9.878095568471494e-10,
  -8.650982652364180e-12,   6.802069183917616e-14,  -4.851493834602193e-16,   2.384269672561322e-18,  -9.322176642601086e-21,  -9.877224381992372e-23,   5.185813569161531e-24,
   7.153749566729082e-26,   2.086869372852656e-27,   4.933771475319731e-02,  -8.122376939290802e-04,   9.851172292487854e-06,  -1.037352169344885e-07,   9.879150513028582e-10,
  -8.652035949763996e-12,   6.802759017212890e-14,  -4.851838756678598e-16,   2.383814090810256e-18,  -9.292538202836588e-21,  -9.828447238030362e-23,   5.202533052745412e-24,
   7.151141206492332e-26,   2.078797881797079e-27,   4.933823814061816e-02,  -8.122542219738470e-04,   9.851487058927428e-06,  -1.037398110845736e-07,   9.879692291393975e-10,
  -8.652576878049842e-12,   6.803113262610450e-14,  -4.852015747462868e-16,   2.383580421642162e-18,  -9.277305158153077e-21,  -9.803400234046726e-23,   5.211110872041171e-24,
   7.149775861320063e-26,   2.074651690219969e-27,   4.933842031171232e-02,  -8.122599747684617e-04,   9.851596617619554e-06,  -1.037414101430478e-07,   9.879880864521688e-10,
  -8.652765154632734e-12,   6.803236558259162e-14,  -4.852077327919400e-16,   2.383499137729152e-18,  -9.272001202091400e-21,  -9.794682779120110e-23,   5.214095117496789e-24,
   7.149296530602143e-26,   2.073208396499015e-27,   4.933844921981821e-02,  -8.122608876604572e-04,   9.851614003139230e-06,  -1.037416638926715e-07,   9.879910788584716e-10,
  -8.652795031606516e-12,   6.803256123452124e-14,  -4.852087098806874e-16,   2.383486241312415e-18,  -9.271159444501827e-21,  -9.793299457384387e-23,   5.214568612386182e-24,
   7.149220272350671e-26,   2.072979357423555e-27,   1.369907321709425e-01,  -2.202469519238727e-03,   2.521234250294447e-05,  -2.369761215365459e-07,   1.820753968893269e-09,
  -1.024183738164140e-11,   1.195612691118215e-14,   6.252824974464507e-16,  -1.227690298237280e-17,   1.201455244538011e-19,  -1.034817684329777e-21,   1.253407869139068e-23,
   3.158366863129398e-25,   4.372230636081061e-27,   1.369930978795726e-01,  -2.202536202423618e-03,   2.521336676758255e-05,  -2.369857128291982e-07,   1.820770399865675e-09,
  -1.024059987805415e-11,   1.192381143604116e-14,   6.256897081644398e-16,  -1.228120554784452e-17,   1.202113404755348e-19,  -1.032857273156371e-21,   1.256479033890729e-23,
   3.159754832777440e-25,   4.349418062395972e-27,   1.369972722878098e-01,  -2.202653868145486e-03,   2.521517410610116e-05,  -2.370026358710137e-07,   1.820799355594754e-09,
  -1.023841563084155e-11,   1.186678112693103e-14,   6.264084193536027e-16,  -1.228879076322886e-17,   1.203276013351792e-19,  -1.029397440304538e-21,   1.261884566349702e-23,
   3.162166109229856e-25,   4.309147089466521e-27,   1.370023201600925e-01,  -2.202796154532832e-03,   2.521735957184221e-05,  -2.370230977824226e-07,   1.820834306110256e-09,
  -1.023577330272648e-11,   1.179780388492008e-14,   6.272778022640984e-16,  -1.229795141159780e-17,   1.204684021379642e-19,  -1.025212667054080e-21,   1.268397821494423e-23,
   3.165017448138225e-25,   4.260420818287523e-27,   1.370072206866550e-01,  -2.202934287610232e-03,   2.521948119743143e-05,  -2.370429601637698e-07,   1.820868169419240e-09,
  -1.023320701050283e-11,   1.173082566666982e-14,   6.281221087224099e-16,  -1.230683239195700e-17,   1.206053157877504e-19,  -1.021149019561009e-21,   1.274696501861298e-23,
   3.167718139421686e-25,   4.213086870111125e-27,   1.370111685870987e-01,  -2.203045568626408e-03,   2.522119036091932e-05,  -2.370589598300965e-07,   1.820895401932104e-09,
  -1.023113880336825e-11,   1.167685721092268e-14,   6.288025037980393e-16,  -1.231397818171602e-17,   1.207157736987751e-19,  -1.017874591359316e-21,   1.279753237599582e-23,
   3.169845605037927e-25,   4.174933005960900e-27,   1.370137773383332e-01,  -2.203119102513047e-03,   2.522231975035387e-05,  -2.370695315321163e-07,   1.820913373515606e-09,
  -1.022977175978514e-11,   1.164119010437375e-14,   6.292522108010304e-16,  -1.231869577484697e-17,   1.207888415233299e-19,  -1.015710517289771e-21,   1.283086116821730e-23,
   3.171227837197505e-25,   4.149710796133290e-27,   1.370151170720548e-01,  -2.203156866107075e-03,   2.522289974730481e-05,  -2.370749604236891e-07,   1.820922595615740e-09,
  -1.022906959094490e-11,   1.162287157269987e-14,   6.294831921565214e-16,  -1.232111718025394e-17,   1.208263898119408e-19,  -1.014599042021982e-21,   1.284795073831319e-23,
   3.171930399845474e-25,   4.136754656315249e-27,   1.370155833810555e-01,  -2.203170010139429e-03,   2.522310162078372e-05,  -2.370768499699411e-07,   1.820925804310956e-09,
  -1.022882517450153e-11,   1.161649535893643e-14,   6.295635929526899e-16,  -1.232195976490924e-17,   1.208394627297432e-19,  -1.014212163911353e-21,   1.285389472275164e-23,
   3.172173774822412e-25,   4.132244624832650e-27,   1.370156573779862e-01,  -2.203172095919551e-03,   2.522313365533543e-05,  -2.370771498135229e-07,   1.820926313432519e-09,
  -1.022878638802159e-11,   1.161548352828549e-14,   6.295763517185820e-16,  -1.232209346163073e-17,   1.208415374064712e-19,  -1.014150770784836e-21,   1.285483775196821e-23,
   3.172212340098193e-25,   4.131528919896193e-27,   2.682888829360508e-01,  -4.150656885335231e-03,   4.297113038570467e-05,  -3.201423058242639e-07,   1.221581749217429e-09,
   9.341293384461823e-12,  -2.532323282853281e-13,   2.763158926421987e-15,  -1.807878863654595e-17,  -6.802812084189512e-20,   2.669529727941442e-21,  -2.152934510595243e-23,
   8.842379152723632e-25,   1.081588566547388e-26,   2.682929128469263e-01,  -4.150746894164596e-03,   4.297181551053498e-05,  -3.201335026758488e-07,   1.221225083904309e-09,
   9.346729640070237e-12,  -2.532795482587902e-13,   2.762926527646072e-15,  -1.806735102386365e-17,  -6.813614993015088e-20,   2.674991313450417e-21,  -2.145238774328492e-23,
   8.840425395947565e-25,   1.077727328136677e-26,   2.683000237401502e-01,  -4.150905714141552e-03,   4.297302426085490e-05,  -3.201179652394259e-07,   1.220595688446278e-09,
   9.356321625403822e-12,  -2.533628441302029e-13,   2.762516162108767e-15,  -1.804715045242946e-17,  -6.832644853863183e-20,   2.684627290871942e-21,  -2.131682532263573e-23,
   8.836893361445482e-25,   1.070910344375493e-26,   2.683086223970177e-01,  -4.151097757512353e-03,   4.297448561633404e-05,  -3.200991701420831e-07,   1.219834524845274e-09,
   9.367919719883275e-12,  -2.534635245610932e-13,   2.762019442610173e-15,  -1.802269178242759e-17,  -6.855601397248548e-20,   2.696277353793159e-21,  -2.115329421062452e-23,
   8.832478308310501e-25,   1.062660795209284e-26,   2.683169699172472e-01,  -4.151284186286954e-03,   4.297590398345901e-05,  -3.200809167906485e-07,   1.219095504197088e-09,
   9.379178282116581e-12,  -2.535612195451015e-13,   2.761536711929732e-15,  -1.799891430274627e-17,  -6.877830153863487e-20,   2.707585044289315e-21,  -2.099495216195717e-23,
   8.828041590489189e-25,   1.054645652303335e-26,   2.683236946376070e-01,  -4.151434368299495e-03,   4.297704639271183e-05,  -3.200662068288719e-07,   1.218500089863637e-09,
   9.388247555162272e-12,  -2.536398899211538e-13,   2.761147455472739e-15,  -1.797973552699776e-17,  -6.895696528555440e-20,   2.716692921564211e-21,  -2.086768856924142e-23,
   8.824359633940722e-25,   1.048184052077612e-26,   2.683281382456400e-01,  -4.151533604632642e-03,   4.297780117412648e-05,  -3.200564841535998e-07,   1.218106616945829e-09,
   9.394240134935376e-12,  -2.536918585040305e-13,   2.760890058397049e-15,  -1.796705080938692e-17,  -6.907482346899755e-20,   2.722710523582623e-21,  -2.078373940208117e-23,
   8.821873945600356e-25,   1.043912054142834e-26,   2.683304202610700e-01,  -4.151584566846631e-03,   4.297818875886914e-05,  -3.200514902922522e-07,   1.217904539344734e-09,
   9.397317538901594e-12,  -2.537185420931856e-13,   2.760757816028314e-15,  -1.796053297433303e-17,  -6.913528759692812e-20,   2.725800624923920e-21,  -2.074067214018839e-23,
   8.820581135669516e-25,   1.041717474787728e-26,   2.683312145390441e-01,  -4.151602304649596e-03,   4.297832365625277e-05,  -3.200497520053387e-07,   1.217834202724636e-09,
   9.398388645992664e-12,  -2.537278288020075e-13,   2.760711778845498e-15,  -1.795826380496973e-17,  -6.915632287402483e-20,   2.726876126938300e-21,  -2.072568929499941e-23,
   8.820128569113590e-25,   1.040953519574379e-26,   2.683313405800959e-01,  -4.151605119391680e-03,   4.297834506237066e-05,  -3.200494761570815e-07,   1.217823041192893e-09,
   9.398558615388528e-12,  -2.537293024387750e-13,   2.760704472950715e-15,  -1.795790369164286e-17,  -6.915966041687562e-20,   2.727046792580205e-21,  -2.072331206135679e-23,
   8.820056629996581e-25,   1.040832285103448e-26,   4.426214060981668e-01,  -6.460505988609966e-03,   5.643508910221144e-05,  -2.356625756079830e-07,  -1.867439368146818e-09,
   4.612663670304994e-11,  -4.065157452490935e-13,  -1.288212429548348e-16,   4.859911089884517e-17,  -7.538029860530322e-19,   3.435827602345685e-21,   7.624855317404634e-23,
  -1.672072429070696e-25,   3.085469980691027e-26,   4.426266947621781e-01,  -6.460572116270599e-03,   5.643403545215774e-05,  -2.356193344817599e-07,  -1.868009517135080e-09,
   4.612634281059564e-11,  -4.063878742461922e-13,  -1.313548179455427e-16,   4.861357313027261e-17,  -7.534012911877033e-19,   3.434809996854647e-21,   7.646884643688290e-23,
  -1.668222332939323e-25,   3.075821277496838e-26,   4.426360266124752e-01,  -6.460688789682903e-03,   5.643217600965338e-05,  -2.355430350695344e-07,  -1.869015407698855e-09,
   4.612582018267871e-11,  -4.061622130019380e-13,  -1.358242424761872e-16,   4.863908848964588e-17,  -7.526915762566483e-19,   3.433016213508177e-21,   7.685698255391972e-23,
  -1.661554820867130e-25,   3.058787090460857e-26,   4.426473106482031e-01,  -6.460829855564662e-03,   5.642992710793653e-05,  -2.354507734082717e-07,  -1.870231491846162e-09,
   4.612518131095165e-11,  -4.058892884209139e-13,  -1.412268267437925e-16,   4.866993601283652e-17,  -7.518318177273479e-19,   3.430850173242161e-21,   7.732534043777634e-23,
  -1.653707019006120e-25,   3.038174086628053e-26,   4.426582648509050e-01,  -6.460966782230495e-03,   5.642774344821210e-05,  -2.353612078095044e-07,  -1.871411784012814e-09,
   4.612455387660625e-11,  -4.056242828931283e-13,  -1.464695789460658e-16,   4.869987605801567e-17,  -7.509955436975290e-19,   3.428750528021584e-21,   7.777898698843301e-23,
  -1.646312893203197e-25,   3.018147659074533e-26,   4.426670893110662e-01,  -6.461077075925498e-03,   5.642598398730112e-05,  -2.352890552342357e-07,  -1.872362424810415e-09,
   4.612404324539426e-11,  -4.054107584340452e-13,  -1.506916495241737e-16,   4.872399093292490e-17,  -7.503206819915932e-19,   3.427061270018989e-21,   7.814370246542725e-23,
  -1.640516792346020e-25,   3.002003475150662e-26,   4.426729203066634e-01,  -6.461149949842395e-03,   5.642482120382870e-05,  -2.352413782485991e-07,  -1.872990499636545e-09,
   4.612370329441452e-11,  -4.052696459602587e-13,  -1.534808214736453e-16,   4.873992344203952e-17,  -7.498741730266935e-19,   3.425946094499721e-21,   7.838433932352081e-23,
  -1.636765317577914e-25,   2.991330257020834e-26,   4.426759147862946e-01,  -6.461187372170697e-03,   5.642422400845848e-05,  -2.352168938819978e-07,  -1.873313017757949e-09,
   4.612352792945165e-11,  -4.051971719800238e-13,  -1.549129790171789e-16,   4.874810487682177e-17,  -7.496446924252683e-19,   3.425373721777702e-21,   7.850780630839373e-23,
  -1.634863005772106e-25,   2.985847376762616e-26,   4.426769570398675e-01,  -6.461200397049910e-03,   5.642401614111432e-05,  -2.352083718814437e-07,  -1.873425268629459e-09,
   4.612346676728585e-11,  -4.051719457966377e-13,  -1.554114202124628e-16,   4.875095239332477e-17,  -7.495647914517601e-19,   3.425174553377937e-21,   7.855076236091689e-23,
  -1.634204747368947e-25,   2.983938744499620e-26,   4.426771224310374e-01,  -6.461202463904386e-03,   5.642398315504855e-05,  -2.352070195576773e-07,  -1.873443081082517e-09,
   4.612345705576871e-11,  -4.051679427036150e-13,  -1.554905143344163e-16,   4.875140424990769e-17,  -7.495521109316003e-19,   3.425142950518993e-21,   7.855757805157144e-23,
  -1.634100473968194e-25,   2.983635858250157e-26,   6.583831375353588e-01,  -8.813513266477580e-03,   5.661099211000732e-05,   1.086808546217167e-07,  -6.514621017740845e-09,
   5.304448612066756e-11,   2.705897807643073e-13,  -1.077600197542199e-14,   7.673481784149178e-17,   6.554391113930853e-19,  -2.168138473571421e-20,   1.843336514273680e-22,
   3.646201218918055e-24,  -1.526810326685051e-26,   6.583884374536513e-01,  -8.813482525551199e-03,   5.660732980533791e-05,   1.087304056926442e-07,  -6.514238144577823e-09,
   5.302330654189059e-11,   2.707893374970359e-13,  -1.077376523211841e-14,   7.664407990903326e-17,   6.563850512698008e-19,  -2.165869365868661e-20,   1.842179030938619e-22,
   3.649061887223211e-24,  -1.534226598370477e-26,   6.583977889641177e-01,  -8.813428271402914e-03,   5.660086778668455e-05,   1.088178232062610e-07,  -6.513562331433352e-09,
   5.298593843365011e-11,   2.711412652929617e-13,  -1.076981587110450e-14,   7.648404933750878e-17,   6.580536876568496e-19,  -2.161864088125669e-20,   1.840132210485634e-22,
   3.654075542034841e-24,  -1.547323056545712e-26,   6.584090964352302e-01,  -8.813362647442069e-03,   5.659305414408282e-05,   1.089235018956913e-07,  -6.512744743330489e-09,
   5.294075864488993e-11,   2.715664908387912e-13,  -1.076503584246254e-14,   7.629067158330261e-17,   6.600705848538542e-19,  -2.157018485492493e-20,   1.837649627799663e-22,
   3.660080128073255e-24,  -1.563176922640984e-26,   6.584200730347791e-01,  -8.813298920665858e-03,   5.658546910871517e-05,   1.090260641406227e-07,  -6.511950637225113e-09,
   5.289690530776103e-11,   2.719789477384078e-13,  -1.076039084693437e-14,   7.610308304344207e-17,   6.620276769262910e-19,  -2.152311983031105e-20,   1.835231672679963e-22,
   3.665848639270807e-24,  -1.578585736675940e-26,   6.584289152840594e-01,  -8.813247568753497e-03,   5.657935892762922e-05,   1.091086663197983e-07,  -6.511310625106678e-09,
   5.286158223192315e-11,   2.723109707795508e-13,  -1.075664558492899e-14,   7.595206394660860e-17,   6.636036554697157e-19,  -2.148518722807494e-20,   1.833278130609638e-22,
   3.670452285648197e-24,  -1.591011773167378e-26,   6.584347579102828e-01,  -8.813213629250326e-03,   5.657532153889313e-05,   1.091632382672222e-07,  -6.510887574285617e-09,
   5.283824362708302e-11,   2.725302448560543e-13,  -1.075416916022235e-14,   7.585232208985145e-17,   6.646447253930553e-19,  -2.146011345026628e-20,   1.831984487711888e-22,
   3.673473069851833e-24,  -1.599228945986185e-26,   6.584377583244176e-01,  -8.813196197503908e-03,   5.657324818064281e-05,   1.091912604496931e-07,  -6.510670273477246e-09,
   5.282625883420458e-11,   2.726428152259250e-13,  -1.075289689600566e-14,   7.580111499055958e-17,   6.651792690688960e-19,  -2.144723421811090e-20,   1.831319281030132e-22,
   3.675017828302782e-24,  -1.603450786633562e-26,   6.584388026374389e-01,  -8.813190129876681e-03,   5.657252653473746e-05,   1.092010133296367e-07,  -6.510594632941944e-09,
   5.282208752833930e-11,   2.726819904270234e-13,  -1.075245399293907e-14,   7.578329429751746e-17,   6.653653066710942e-19,  -2.144275106272955e-20,   1.831087612946425e-22,
   3.675554451882786e-24,  -1.604920543215065e-26,   6.584389683551248e-01,  -8.813189167011272e-03,   5.657241201972832e-05,   1.092025609537573e-07,  -6.510582629498488e-09,
   5.282142560481895e-11,   2.726882067095989e-13,  -1.075238370653132e-14,   7.578046651322584e-17,   6.653948275537185e-19,  -2.144203962775851e-20,   1.831050843916924e-22,
   3.675639557112927e-24,  -1.605153787865662e-26,   9.117856939554073e-01,  -1.071343439654115e-02,   3.378500361382843e-05,   6.641855364822200e-07,  -7.833853299151085e-09,
  -4.200712370632443e-11,   1.506449136715157e-12,  -4.357117193734800e-15,  -2.473558613904360e-16,   2.572725559042854e-18,   2.542808985080424e-20,  -6.867417060782515e-22,
   3.559327450626435e-24,   2.055975370585324e-25,   9.117888524716197e-01,  -1.071324773370512e-02,   3.378060899050609e-05,   6.641460840412201e-07,  -7.831742507993310e-09,
  -4.201556529413152e-11,   1.505802060725440e-12,  -4.348524841898643e-15,  -2.472478966093382e-16,   2.569242064039049e-18,   2.544963199196424e-20,  -6.852602248861476e-22,
   3.548951404437150e-24,   2.052001961858818e-25,   9.117944253897147e-01,  -1.071291837322281e-02,   3.377285557189597e-05,   6.640764631952466e-07,  -7.828018722646758e-09,
  -4.203044690044516e-11,   1.504660515773514e-12,  -4.333373017788285e-15,  -2.470573175885806e-16,   2.563101570143950e-18,   2.548759118516871e-20,  -6.826484939730459e-22,
   3.530637446856120e-24,   2.044988003019601e-25,   9.118011636533090e-01,  -1.071252012240361e-02,   3.376348169767697e-05,   6.639922660306548e-07,  -7.823517141251149e-09,
  -4.204841853462451e-11,   1.503280541080447e-12,  -4.315067483943833e-15,  -2.468267422575109e-16,   2.555686963301763e-18,   2.553340273213089e-20,  -6.794943963208711e-22,
   3.508483061460119e-24,   2.036501882004890e-25,   9.118077044476930e-01,  -1.071213352352485e-02,   3.375438342246284e-05,   6.639105174819569e-07,  -7.819148402797998e-09,
  -4.206584063356425e-11,   1.501941297908635e-12,  -4.297313752649735e-15,  -2.466027728256618e-16,   2.548500024205650e-18,   2.557778244556376e-20,  -6.764366800379026e-22,
   3.486966615923331e-24,   2.028258755912492e-25,   9.118129732001239e-01,  -1.071182209604836e-02,   3.374705520215777e-05,   6.638446537534391e-07,  -7.815629948696207e-09,
  -4.207985813916510e-11,   1.500862716585115e-12,  -4.283023721882786e-15,  -2.464222522909911e-16,   2.542718218432507e-18,   2.561346726921618e-20,  -6.739764532771683e-22,
   3.469626562994947e-24,   2.021614688310616e-25,   9.118164544890810e-01,  -1.071161631597661e-02,   3.374221344780840e-05,   6.638011281817939e-07,  -7.813305479429282e-09,
  -4.208911208720000e-11,   1.500150154013168e-12,  -4.273587066076425e-15,  -2.463029217173526e-16,   2.538901569217211e-18,   2.563701440423864e-20,  -6.723522630884807e-22,
   3.458165298720672e-24,   2.017222699873509e-25,   9.118182422329677e-01,  -1.071151063981306e-02,   3.373972716177088e-05,   6.637787744837607e-07,  -7.812111896264889e-09,
  -4.209386178276675e-11,   1.499784263811872e-12,  -4.268742728501211e-15,  -2.462416255972256e-16,   2.536942731998033e-18,   2.564909685181154e-20,  -6.715186226841195e-22,
   3.452278382414193e-24,   2.014966678514973e-25,   9.118188644633205e-01,  -1.071147385853511e-02,   3.373886181683474e-05,   6.637709938779868e-07,  -7.811696481482695e-09,
  -4.209551453606712e-11,   1.499656919505449e-12,  -4.267056904771838e-15,  -2.462202886677099e-16,   2.536261130927990e-18,   2.565330064503420e-20,  -6.712285395836560e-22,
   3.450229226821516e-24,   2.014181366260259e-25,   9.118189632022200e-01,  -1.071146802186608e-02,   3.373872449992045e-05,   6.637697591936810e-07,  -7.811630561958828e-09,
  -4.209577678523395e-11,   1.499636712056280e-12,  -4.266789401639640e-15,  -2.462169026838855e-16,   2.536152979252036e-18,   2.565396765253176e-20,  -6.711825108600381e-22,
   3.449904046435303e-24,   2.014056744068442e-25,   1.194467097871964e+00,  -1.143651229029746e-02,  -1.649533998246794e-05,   1.050255926748989e-06,   1.557603280461145e-09,
  -1.787421256718392e-10,  -7.318979661272922e-14,   3.627857366680147e-14,  -5.851973907720547e-17,  -8.439869227362554e-18,   2.655361500086215e-20,   2.047146665977482e-21,
  -6.808960394119193e-24,  -3.845173653512849e-25,   1.194465553194490e+00,  -1.143621749440382e-02,  -1.649446442435650e-05,   1.050088952632878e-06,   1.557498571432783e-09,
  -1.786711505182921e-10,  -7.334112761554488e-14,   3.625036110334765e-14,  -5.840900763250046e-17,  -8.429420985308562e-18,   2.651318751229053e-20,   2.044380877022873e-21,
  -6.771957003623978e-24,  -3.836786063010537e-25,   1.194462827653409e+00,  -1.143569736048027e-02,  -1.649291953657603e-05,   1.049794378132501e-06,   1.557313638584281e-09,
  -1.785459587646543e-10,  -7.360791801781595e-14,   3.620060818058094e-14,  -5.821375742446433e-17,  -8.410996445010761e-18,   2.644203679542497e-20,   2.039505535802136e-21,
  -6.706837818310221e-24,  -3.822022817321438e-25,   1.194459532013606e+00,  -1.143506847388390e-02,  -1.649105152414224e-05,   1.049438267472335e-06,   1.557089722511678e-09,
  -1.783946522924114e-10,  -7.393012241858378e-14,   3.614049514023773e-14,  -5.797789223984332e-17,  -8.388736968822207e-18,   2.635631410674589e-20,   2.033618624043136e-21,
  -6.628391087277072e-24,  -3.804233552024383e-25,   1.194456332782482e+00,  -1.143445802961545e-02,  -1.648923817633906e-05,   1.049092657691118e-06,   1.556872041761936e-09,
  -1.782478469033286e-10,  -7.424249278051049e-14,   3.608218943844160e-14,  -5.774916232328025e-17,  -8.367148439940282e-18,   2.627342355709061e-20,   2.027912492507930e-21,
  -6.552545910734799e-24,  -3.787029451451733e-25,   1.194453755608717e+00,  -1.143396631233189e-02,  -1.648777742883494e-05,   1.048814307911430e-06,   1.556696461251463e-09,
  -1.781296399083290e-10,  -7.449383346521235e-14,   3.603525564317887e-14,  -5.756507486045164e-17,  -8.349771738461098e-18,   2.620688216288553e-20,   2.023321984989183e-21,
  -6.491667460926093e-24,  -3.773216809971346e-25,   1.194452052699930e+00,  -1.143364141814273e-02,  -1.648681222323576e-05,   1.048630413094476e-06,   1.556580333259354e-09,
  -1.780515589824615e-10,  -7.465976769633235e-14,   3.600426050061116e-14,  -5.744351837169793e-17,  -8.338296734029500e-18,   2.616302722729768e-20,   2.020291727811796e-21,
  -6.451548344639709e-24,  -3.764112513065618e-25,   1.194451178187691e+00,  -1.143347457680064e-02,  -1.648631655336091e-05,   1.048535984745348e-06,   1.556520662741962e-09,
  -1.780114693944230e-10,  -7.474493735112649e-14,   3.598834853763441e-14,  -5.738111962268532e-17,  -8.332405998977344e-18,   2.614054096273468e-20,   2.018736493548074e-21,
  -6.430978714541306e-24,  -3.759444078444126e-25,   1.194450873807752e+00,  -1.143341650731685e-02,  -1.648614403241604e-05,   1.048503119755334e-06,   1.556499888581839e-09,
  -1.779975172315595e-10,  -7.477457418514062e-14,   3.598281111276832e-14,  -5.735940535456998e-17,  -8.330356029425351e-18,   2.613272003502998e-20,   2.018195330807602e-21,
  -6.423824589901969e-24,  -3.757820309755160e-25,   1.194450825506945e+00,  -1.143340729254521e-02,  -1.648611665578903e-05,   1.048497904612924e-06,   1.556496591757622e-09,
  -1.779953032812298e-10,  -7.477927679865032e-14,   3.598193244145762e-14,  -5.735595979802830e-17,  -8.330030744328287e-18,   2.613147922835536e-20,   2.018109462890021e-21,
  -6.422689581518531e-24,  -3.757562693310302e-25,   1.488807257067472e+00,  -1.010614748348369e-02,  -7.826208042435194e-05,   5.372739922133968e-07,   1.648862091265600e-08,
   6.565900502119730e-12,  -3.700385894023066e-12,  -2.846216205942336e-14,   7.468696742653935e-16,   1.284660976344745e-17,  -1.234449452527727e-19,  -4.642348131515106e-21,
   7.198675856985072e-24,   1.631459495494327e-24,   1.488799938571126e+00,  -1.010599635552657e-02,  -7.825283482351179e-05,   5.372796829827305e-07,   1.648344029682127e-08,
   6.510544310054261e-12,  -3.698436082443860e-12,  -2.841941519111044e-14,   7.463504990015609e-16,   1.282312685309188e-17,  -1.233956909547749e-19,  -4.630641320254765e-21,
   7.301278317737282e-24,   1.627407295703607e-24,   1.488787025670205e+00,  -1.010572968664405e-02,  -7.823652317888093e-05,   5.372896824515074e-07,   1.647430124352035e-08,
   6.412935557583410e-12,  -3.694996716189139e-12,  -2.834405176964896e-14,   7.454345791183635e-16,   1.278173973485877e-17,  -1.233082716450990e-19,  -4.610008492509316e-21,
   7.481704866330866e-24,   1.620261973845077e-24,   1.488771412447605e+00,  -1.010540722570035e-02,  -7.821680299317905e-05,   5.373017023664733e-07,   1.646325399529142e-08,
   6.295022090231027e-12,  -3.690839684951392e-12,  -2.825303071977915e-14,   7.443273352390218e-16,   1.273177720779067e-17,  -1.232016969542739e-19,  -4.585100001370269e-21,
   7.698828088226153e-24,   1.611630051366716e-24,   1.488756256652775e+00,  -1.010509418402633e-02,  -7.819766319677775e-05,   5.373132962110486e-07,   1.645253348847880e-08,
   6.180675204783176e-12,  -3.686806086896927e-12,  -2.816478330139883e-14,   7.432527537676140e-16,   1.268336150910852e-17,  -1.230973315761830e-19,  -4.560962120837452e-21,
   7.908509699328778e-24,   1.603259010934659e-24,   1.488744048238067e+00,  -1.010484200017447e-02,  -7.818224744762700e-05,   5.373225824414369e-07,   1.644390003170240e-08,
   6.088645809090084e-12,  -3.683558088260424e-12,  -2.809377409999585e-14,   7.423873093183829e-16,   1.264442076652685e-17,  -1.230126100027904e-19,  -4.541547643268619e-21,
   8.076641423546055e-24,   1.596521638176677e-24,   1.488735981574024e+00,  -1.010467536082095e-02,  -7.817206247457106e-05,   5.373286923760931e-07,   1.643819658949402e-08,
   6.027876980427010e-12,  -3.681412561594857e-12,  -2.804689248888313e-14,   7.418155493490310e-16,   1.261871990345843e-17,  -1.229563118738490e-19,  -4.528733919364069e-21,
   8.187356114598713e-24,   1.592072755568422e-24,   1.488731839091789e+00,  -1.010458978330600e-02,  -7.816683246102603e-05,   5.373318220073652e-07,   1.643526802951325e-08,
   5.996682434834266e-12,  -3.680310945280392e-12,  -2.802282890297342e-14,   7.415219574512045e-16,   1.260553070326257e-17,  -1.229273026446731e-19,  -4.522158101636931e-21,
   8.244094858943781e-24,   1.589788986505529e-24,   1.488730397284519e+00,  -1.010455999723110e-02,  -7.816501217973889e-05,   5.373329100129083e-07,   1.643424878592210e-08,
   5.985826981479480e-12,  -3.679927551746990e-12,  -2.801445531936217e-14,   7.414197755559890e-16,   1.260094158098922e-17,  -1.229171902177302e-19,  -4.519870067030572e-21,
   8.263824437535062e-24,   1.588994250287160e-24,   1.488730168490588e+00,  -1.010455527058947e-02,  -7.816472332962498e-05,   5.373330826031073e-07,   1.643408704925462e-08,
   5.984104469930940e-12,  -3.679866714092851e-12,  -2.801312664037274e-14,   7.414035609555484e-16,   1.260021342167004e-17,  -1.229155847793465e-19,  -4.519507022528588e-21,
   8.266954354784762e-24,   1.588868143741566e-24,   1.760052601735747e+00,  -6.285905254021419e-03,  -9.800846067571498e-05,  -8.172075932768931e-07,   4.212210984059735e-09,
   2.566834617415318e-10,   3.539158515103173e-12,  -6.236038653832949e-15,  -1.176648188303945e-15,  -2.101393955231674e-17,  -3.739761114980970e-20,   6.196026651460941e-21,
   1.393120141667282e-22,   7.958643337806194e-25,   1.760043418273541e+00,  -6.286134246018996e-03,  -9.800606344494466e-05,  -8.169670666848713e-07,   4.217151354500673e-09,
   2.566700716894161e-10,   3.536067207287743e-12,  -6.306121567010474e-15,  -1.176778690686560e-15,  -2.098178556282164e-17,  -3.654765128127932e-20,   6.201387152395290e-21,
   1.390531405363620e-22,   7.875211014563356e-25,   1.760027214095792e+00,  -6.286538251029310e-03,  -9.800183124278805e-05,  -8.165426642709550e-07,   4.225865180752726e-09,
   2.566463329704916e-10,   3.530612283932915e-12,  -6.429695595111836e-15,  -1.177006059558938e-15,  -2.092502733979632e-17,  -3.504919183136035e-20,   6.210796430821750e-21,
   1.385958204566390e-22,   7.728134909547354e-25,   1.760007620147819e+00,  -6.287026684474620e-03,  -9.799670978211211e-05,  -8.160294903698660e-07,   4.236396004707686e-09,
   2.566174373925703e-10,   3.524015689689377e-12,  -6.578971903198975e-15,  -1.177276046865614e-15,  -2.085635731514178e-17,  -3.323947090923255e-20,   6.222090040974518e-21,
   1.380419175544562e-22,   7.550530715423032e-25,   1.759988599014292e+00,  -6.287500749057924e-03,  -9.799173394049351e-05,  -8.155313289871320e-07,   4.246612833761355e-09,
   2.565891867360358e-10,   3.517611372057874e-12,  -6.723728867360284e-15,  -1.177532966669336e-15,  -2.078965468575835e-17,  -3.148496507646167e-20,   6.232965593510216e-21,
   1.375032527552351e-22,   7.378369441424620e-25,   1.759973276074455e+00,  -6.287882578998371e-03,  -9.798772259056167e-05,  -8.151300302905764e-07,   4.254838855289731e-09,
   2.565662856427752e-10,   3.512451812616927e-12,  -6.840230029852782e-15,  -1.177736229818239e-15,  -2.073589212879053e-17,  -3.007323616126645e-20,   6.241663734255784e-21,
   1.370686367392288e-22,   7.239860821183999e-25,   1.759963151065336e+00,  -6.288134850989699e-03,  -9.798507055391220e-05,  -8.148648659578703e-07,   4.260272249080161e-09,
   2.565510831583002e-10,   3.509042310332088e-12,  -6.917156499206535e-15,  -1.177868728020739e-15,  -2.070035323535997e-17,  -2.914121317397576e-20,   6.247380454559985e-21,
   1.367811209979493e-22,   7.148426199953405e-25,   1.759957951424745e+00,  -6.288264394079969e-03,  -9.798370817082313e-05,  -8.147286934610064e-07,   4.263061871840674e-09,
   2.565432543608592e-10,   3.507291319444450e-12,  -6.956644778687244e-15,  -1.177936211286391e-15,  -2.068209813248904e-17,  -2.866282922721872e-20,   6.250306725933957e-21,
   1.366333663298743e-22,   7.101497832536223e-25,   1.759956141647962e+00,  -6.288309481043686e-03,  -9.798323391160811e-05,  -8.146812977072855e-07,   4.264032716546104e-09,
   2.565405260390507e-10,   3.506681863366520e-12,  -6.970386306464515e-15,  -1.177959610180055e-15,  -2.067574361217218e-17,  -2.849636383528415e-20,   6.251323723417072e-21,
   1.365819228142855e-22,   7.085168395231002e-25,   1.759955854461583e+00,  -6.288316635643405e-03,  -9.798315864991234e-05,  -8.146737766696296e-07,   4.264186771053504e-09,
   2.565400929287947e-10,   3.506585150717258e-12,  -6.972566768086454e-15,  -1.177963319024481e-15,  -2.067473520578334e-17,  -2.846994999412971e-20,   6.251485034851853e-21,
   1.365737586705730e-22,   7.082577347878982e-25,   1.949833153094065e+00,  -1.590184853636908e-03,  -3.624869830475234e-05,  -6.924642296749465e-07,  -1.139586743655682e-08,
  -1.574987610238222e-10,  -1.621051936437412e-12,  -4.968960445713007e-15,   3.040824651607278e-16,   1.035798955709495e-17,   2.165783994244934e-19,   3.313526630556995e-21,
   3.268588849396477e-23,  -3.282094404818492e-26,   1.949829741891210e+00,  -1.590380129195705e-03,  -3.625512127512624e-05,  -6.926119614192865e-07,  -1.139813734212544e-08,
  -1.575079795169424e-10,  -1.620234701101726e-12,  -4.933557423965130e-15,   3.050024933206503e-16,   1.037505824172074e-17,   2.167762614108670e-19,   3.313124080731043e-21,
   3.259193903581533e-23,  -3.575684699081612e-26,   1.949823722278939e+00,  -1.590724729789535e-03,  -3.626645574333195e-05,  -6.928726432621959e-07,  -1.140214168444411e-08,
  -1.575241888080165e-10,  -1.618790709175538e-12,  -4.871041412487808e-15,   3.066265722737020e-16,   1.040517435017111e-17,   2.171249147976257e-19,   3.312396229775772e-21,
   3.242574822372943e-23,  -4.094406235692878e-26,   1.949816442461923e+00,  -1.591141482139508e-03,  -3.628016326945171e-05,  -6.931878741920974e-07,  -1.140698217062745e-08,
  -1.575436922108960e-10,  -1.617041263283278e-12,  -4.795366550609869e-15,   3.085915753442732e-16,   1.044158785839416e-17,   2.175456950979227e-19,   3.311486160656106e-21,
   3.222407978790678e-23,  -4.722803244073034e-26,   1.949809374464445e+00,  -1.591546118457823e-03,  -3.629347214755526e-05,  -6.934939070946092e-07,  -1.141167954567276e-08,
  -1.575625240866567e-10,  -1.615339416470664e-12,  -4.721819109199557e-15,   3.105003685611391e-16,   1.047693403388598e-17,   2.179533259355374e-19,   3.310571289186079e-21,
   3.202756107804384e-23,  -5.334047108730821e-26,   1.949803679949079e+00,  -1.591872131456033e-03,  -3.630419493123442e-05,  -6.937404519157937e-07,  -1.141546248112828e-08,
  -1.575776218940557e-10,  -1.613965911424776e-12,  -4.662510354379054e-15,   3.120389279451596e-16,   1.050540595156338e-17,   2.182810938603471e-19,   3.309811763552319e-21,
   3.186871595808692e-23,  -5.827321348008690e-26,   1.949799916807013e+00,  -1.592087576210524e-03,  -3.631128100410027e-05,  -6.939033685879603e-07,  -1.141796158506875e-08,
  -1.575875625404746e-10,  -1.613057089844225e-12,  -4.623290862170744e-15,   3.130560014372629e-16,   1.052421844430354e-17,   2.184973758278811e-19,   3.309298847607946e-21,
   3.176349326489016e-23,  -6.153691024720167e-26,   1.949797984158321e+00,  -1.592198223948632e-03,  -3.631492024208305e-05,  -6.939870354053136e-07,  -1.141924481118965e-08,
  -1.575926564886538e-10,  -1.612589984801811e-12,  -4.603140708049574e-15,   3.135784474076488e-16,   1.053387917106224e-17,   2.186083536951798e-19,   3.309032025946592e-21,
   3.170937574485745e-23,  -6.321428184700222e-26,   1.949797311467092e+00,  -1.592236736949623e-03,  -3.631618694410949e-05,  -6.940161566157852e-07,  -1.141969142059539e-08,
  -1.575944277245336e-10,  -1.612427343844209e-12,  -4.596125818720995e-15,   3.137603102110880e-16,   1.053724161329664e-17,   2.186469656993248e-19,   3.308938612396825e-21,
   3.169052680799575e-23,  -6.379831444427686e-26,   1.949797204719539e+00,  -1.592242848481959e-03,  -3.631638795379105e-05,  -6.940207777607167e-07,  -1.141976228997098e-08,
  -1.575947087117407e-10,  -1.612401532079081e-12,  -4.595012583860642e-15,   3.137891703158298e-16,   1.053777518361176e-17,   2.186530921870099e-19,   3.308923763131915e-21,
   3.168753513179272e-23,  -6.389100224991228e-26,   5.133539670219411e-03,  -8.271662191109422e-05,   9.969713150097360e-07,  -1.067264550709402e-08,   1.064765310696734e-10,
  -1.022925124405914e-12,   9.350092821237794e-15,  -8.711728754412315e-17,   7.190867394129322e-19,  -6.405269840423873e-21,   8.437904263675857e-23,   5.923963382965369e-25,
   2.231014469999547e-26,  -2.667073793724197e-29,   5.133633256479643e-03,  -8.271962697004553e-05,   9.970312822988367e-07,  -1.067360594276644e-08,   1.064897020343235e-10,
  -1.023096978649253e-12,   9.351987874399619e-15,  -8.713882602782524e-17,   7.194470321381320e-19,  -6.402227408639168e-21,   8.451387882145399e-23,   5.921008406986282e-25,
   2.224099050719748e-26,  -2.849849291645221e-29,   5.133798395490121e-03,  -8.272492966378213e-05,   9.971371015540050e-07,  -1.067530077773657e-08,   1.065129445785290e-10,
  -1.023400252605254e-12,   9.355332497091449e-15,  -8.717682268290572e-17,   7.200832339757628e-19,  -6.396860331170237e-21,   8.475145100333818e-23,   5.915686296527088e-25,
   2.211892008431074e-26,  -3.171875381061041e-29,   5.133998091159105e-03,  -8.273134211274654e-05,   9.972650696106093e-07,  -1.067735041387429e-08,   1.065410534117518e-10,
  -1.023767033427290e-12,   9.359378166855846e-15,  -8.722275442944709e-17,   7.208533189681297e-19,  -6.390372721645137e-21,   8.503813163690634e-23,   5.909066776560715e-25,
   2.197123202639042e-26,  -3.560447462965376e-29,   5.134191960440028e-03,  -8.273756759996822e-05,   9.973893095535814e-07,  -1.067934039931502e-08,   1.065683448563151e-10,
  -1.024123159373568e-12,   9.363307012270935e-15,  -8.726732929176641e-17,   7.216017229827435e-19,  -6.384077129305586e-21,   8.531581380604616e-23,   5.902448263875604e-25,
   2.182777676172547e-26,  -3.936802534809061e-29,   5.134348144874423e-03,  -8.274258305295066e-05,   9.974894033523777e-07,  -1.068094367349697e-08,   1.065903332667189e-10,
  -1.024410093841885e-12,   9.366473027866202e-15,  -8.730322756061008e-17,   7.222052134792103e-19,  -6.379007277118070e-21,   8.553906484269169e-23,   5.896978801251741e-25,
   2.171215261050033e-26,  -4.239370442006760e-29,   5.134451351637094e-03,  -8.274589731274115e-05,   9.975555473299407e-07,  -1.068200317067615e-08,   1.066048641768027e-10,
  -1.024599716585527e-12,   9.368565558967230e-15,  -8.732694327845471e-17,   7.226042758500452e-19,  -6.375658099247995e-21,   8.568636666800910e-23,   5.893297339988447e-25,
   2.163572180304584e-26,  -4.438999000877920e-29,   5.134504354135819e-03,  -8.274759938634476e-05,   9.975895165958592e-07,  -1.068254729858321e-08,   1.066123269151104e-10,
  -1.024697103603974e-12,   9.369640323667221e-15,  -8.733912082060404e-17,   7.228093020426455e-19,  -6.373938413828103e-21,   8.576194562368768e-23,   5.891385923875907e-25,
   2.159646217584962e-26,  -4.541424152419062e-29,   5.134522802282229e-03,  -8.274819181543485e-05,   9.976013400959855e-07,  -1.068273669132974e-08,   1.066149244565005e-10,
  -1.024731001108837e-12,   9.370014429225270e-15,  -8.734335906878037e-17,   7.228806773814876e-19,  -6.373339905986722e-21,   8.578824081149006e-23,   5.890717326432588e-25,
   2.158279611364702e-26,  -4.577059254245310e-29,   5.134525729755703e-03,  -8.274828582609450e-05,   9.976032163314516e-07,  -1.068276674554231e-08,   1.066153366537250e-10,
  -1.024736380226394e-12,   9.370073795757955e-15,  -8.734403160820091e-17,   7.228920043337826e-19,  -6.373244933148013e-21,   8.579241298482394e-23,   5.890611072043168e-25,
   2.158062743190095e-26,  -4.582713346326923e-29,   4.623091506189996e-02,  -7.379069626585664e-04,   8.691205037728851e-06,  -8.916314329434425e-08,   8.293840711394384e-10,
  -7.166150892908795e-12,   5.540535215328709e-14,  -4.142495076283482e-16,   2.035714903652903e-18,  -7.819169473391484e-21,   2.318335868940276e-22,   1.081927888423843e-23,
   1.524992632992111e-25,   2.394151434691933e-28,   4.623173079819654e-02,  -7.379320634330176e-04,   8.691672005542704e-06,  -8.916986840829216e-08,   8.294620482376230e-10,
  -7.166966838380686e-12,   5.541071678516773e-14,  -4.142744422220515e-16,   2.036722141029914e-18,  -7.763355188788302e-21,   2.327462843478088e-22,   1.082012592140306e-23,
   1.518332888215871e-25,   2.229736010871674e-28,   4.623317021339093e-02,  -7.379763556840240e-04,   8.692496013283941e-06,  -8.918173559985641e-08,   8.295996461977325e-10,
  -7.168406626217093e-12,   5.542018492986492e-14,  -4.143182865405193e-16,   2.038502530493782e-18,  -7.664867376194644e-21,   2.343533982648500e-22,   1.082152338574686e-23,
   1.506577143434371e-25,   1.940067605470651e-28,   4.623491083043935e-02,  -7.380299169724496e-04,   8.693492473100980e-06,  -8.919608659562558e-08,   8.297660415984303e-10,
  -7.170147699749555e-12,   5.543163761161532e-14,  -4.143710423970170e-16,   2.040660679896396e-18,  -7.545770655573225e-21,   2.362910153343371e-22,   1.082304775355889e-23,
   1.492354312765709e-25,   1.590556377443322e-28,   4.623660065502823e-02,  -7.380819160933907e-04,   8.694459882769033e-06,  -8.921001940492969e-08,   8.299275863469074e-10,
  -7.171837973427453e-12,   5.544275955718544e-14,  -4.144219833785609e-16,   2.042761296677825e-18,  -7.430149571391454e-21,   2.381660262195319e-22,   1.082435454538150e-23,
   1.478539077660542e-25,   1.252051393945187e-28,   4.623796200137630e-02,  -7.381238078789517e-04,   8.695239261078666e-06,  -8.922124429098466e-08,   8.300577325597332e-10,
  -7.173199685660630e-12,   5.545172203622453e-14,  -4.144628248126414e-16,   2.044457476135372e-18,  -7.337004077824213e-21,   2.396722144020605e-22,   1.082528346157430e-23,
   1.467404046609209e-25,   9.799252376026470e-29,   4.623886157713639e-02,  -7.381514901891584e-04,   8.695754282739562e-06,  -8.922866188551106e-08,   8.301437347098911e-10,
  -7.174099505139251e-12,   5.545764564762440e-14,  -4.144897161572452e-16,   2.045580212412457e-18,  -7.275453997313852e-21,   2.406653726394488e-22,   1.082583671384545e-23,
   1.460043464246423e-25,   8.003876748460262e-29,   4.623932355924281e-02,  -7.381657066783138e-04,   8.696018777919896e-06,  -8.923247129576564e-08,   8.301879021202005e-10,
  -7.174561612996146e-12,   5.546068812797172e-14,  -4.145034964765315e-16,   2.046157387813639e-18,  -7.243844736958652e-21,   2.411747560923712e-22,   1.082610212093619e-23,
   1.456262605648855e-25,   7.082726758111889e-29,   4.623948435744583e-02,  -7.381706549050476e-04,   8.696110838990407e-06,  -8.923379721508157e-08,   8.302032751814763e-10,
  -7.174722455060421e-12,   5.546174715840577e-14,  -4.145082881188746e-16,   2.046358373923077e-18,  -7.232842790778024e-21,   2.413519480457651e-22,   1.082619152018991e-23,
   1.454946508624960e-25,   6.762249174833105e-29,   4.623950987395833e-02,  -7.381714401227369e-04,   8.696125447866672e-06,  -8.923400762112721e-08,   8.302057146835826e-10,
  -7.174747978537471e-12,   5.546191521514539e-14,  -4.145090482622596e-16,   2.046390272155940e-18,  -7.231096930932376e-21,   2.413800610489473e-22,   1.082620556526459e-23,
   1.454737655771421e-25,   6.711400304677231e-29,   1.285669201936484e-01,  -2.011665827790440e-03,   2.253672676421932e-05,  -2.094619585976257e-07,   1.619991422431530e-09,
  -9.785445671472979e-12,   2.456495871850662e-14,   2.950155061513120e-16,  -8.517284903805159e-18,   9.503757921245896e-20,  -7.331096384843865e-23,   3.257961714496895e-23,
   4.818460866165778e-25,  -1.389495319117771e-28,   1.285690348373019e-01,  -2.011724771145597e-03,   2.253763820096215e-05,  -2.094711275029203e-07,   1.620025702379551e-09,
  -9.784859679482958e-12,   2.454259669875404e-14,   2.953406315998433e-16,  -8.517501431635149e-18,   9.520540771415485e-20,  -7.041322513657498e-23,   3.257592589817169e-23,
   4.800420695529854e-25,  -1.876159281296628e-28,   1.285727662288436e-01,  -2.011828779720300e-03,   2.253924646107206e-05,  -2.094873057325614e-07,   1.620086164320307e-09,
  -9.783825164830940e-12,   2.450313815645356e-14,   2.959147809525159e-16,  -8.517873633208439e-18,   9.550152554371216e-20,  -6.530920839281546e-23,   3.256912503369045e-23,
   4.768575924799802e-25,  -2.733606524967318e-28,   1.285772783859510e-01,  -2.011954551576046e-03,   2.254119121303799e-05,  -2.095068678565620e-07,   1.620159231951266e-09,
  -9.782573327135506e-12,   2.445542378646602e-14,   2.966098334398497e-16,  -8.518306903727306e-18,   9.585956252839949e-20,  -5.915287823027747e-23,   3.256041149161574e-23,
   4.730047536402193e-25,  -3.768260683833830e-28,   1.285816588341501e-01,  -2.012076652461094e-03,   2.254307917248836e-05,  -2.095258576273754e-07,   1.620230119091238e-09,
  -9.781357130529802e-12,   2.440910280921511e-14,   2.972854003123842e-16,  -8.518709950144939e-18,   9.620710422399900e-20,  -5.319265781580209e-23,   3.255144021879799e-23,
   4.692622666693413e-25,  -4.770402638074663e-28,   1.285851877552335e-01,  -2.012175018029190e-03,   2.254460010805707e-05,  -2.095411549659598e-07,   1.620287192140075e-09,
  -9.780376708525999e-12,   2.437178674879921e-14,   2.978302170884564e-16,  -8.519022072994843e-18,   9.648705389954011e-20,  -4.840282026544611e-23,   3.254384647262033e-23,
   4.662457916438677e-25,  -5.576080333682028e-28,   1.285875196469876e-01,  -2.012240017557908e-03,   2.254560512497011e-05,  -2.095512628937241e-07,   1.620324888978606e-09,
  -9.779728534979386e-12,   2.434712872928027e-14,   2.981905106299379e-16,  -8.519222173281028e-18,   9.667202692592314e-20,  -4.524348098403732e-23,   3.253864934948580e-23,
   4.642517920973651e-25,  -6.107657547228631e-28,   1.285887171984541e-01,  -2.012273398332268e-03,   2.254612125226834e-05,  -2.095564537113362e-07,   1.620344243155983e-09,
  -9.779395565326095e-12,   2.433446558590879e-14,   2.983756277658672e-16,  -8.519323035630508e-18,   9.676701542458365e-20,  -4.362277220870163e-23,   3.253592496476211e-23,
   4.632275419454639e-25,  -6.380400438179076e-28,   1.285891340193539e-01,  -2.012285016881151e-03,   2.254630089558259e-05,  -2.095582604090990e-07,   1.620350978766143e-09,
  -9.779279656022927e-12,   2.433005805176662e-14,   2.984400736748651e-16,  -8.519357839563164e-18,   9.680007639880245e-20,  -4.305895039635792e-23,   3.253496789941577e-23,
   4.628710048304031e-25,  -6.475291709617255e-28,   1.285892001631919e-01,  -2.012286860587915e-03,   2.254632940252533e-05,  -2.095585471064945e-07,   1.620352047577278e-09,
  -9.779261262045314e-12,   2.432935863627363e-14,   2.984503010269168e-16,  -8.519363348127745e-18,   9.680532268946614e-20,  -4.296949296704944e-23,   3.253481560776533e-23,
   4.628144255237112e-25,  -6.490347777660837e-28,   2.523499479239458e-01,  -3.821910223569900e-03,   3.925185915886557e-05,  -2.994074987233838e-07,   1.353553822499429e-09,
   4.125209009957542e-12,  -1.841911292703374e-13,   2.165035783854344e-15,  -1.870628952035076e-17,   3.416716341741449e-20,   2.834736508950468e-21,   3.219683495939612e-23,
   1.260031913732981e-24,  -4.739668075954602e-28,   2.523536293039613e-01,  -3.821994418007476e-03,   3.925261906575620e-05,  -2.994035954922480e-07,   1.353294226917335e-09,
   4.129473328352381e-12,  -1.842399804177845e-13,   2.165155414092038e-15,  -1.869408654325424e-17,   3.433280344518748e-20,   2.842352016104945e-21,   3.218803744908884e-23,
   1.256131947463244e-24,  -5.709806200483432e-28,   2.523601252147556e-01,  -3.822142979520607e-03,   3.925395981458688e-05,  -2.993967049285822e-07,   1.352836110670851e-09,
   4.136997978965368e-12,  -1.843261528469694e-13,   2.165366957734435e-15,  -1.867252823699264e-17,   3.462503555996939e-20,   2.855770045415278e-21,   3.217194098628057e-23,
   1.249247261827547e-24,  -7.418932026724809e-28,   2.523679802381151e-01,  -3.822322620160513e-03,   3.925558085976174e-05,  -2.993883672421787e-07,   1.352282056559353e-09,
   4.146097197691923e-12,  -1.844303087768610e-13,   2.165623532940025e-15,  -1.864641548291958e-17,   3.497833195677386e-20,   2.871961749428513e-21,   3.215150085614237e-23,
   1.240916913050471e-24,  -9.481025805448900e-28,   2.523756058620900e-01,  -3.822497010582280e-03,   3.925715433013616e-05,  -2.993802673556304e-07,   1.351744090907843e-09,
   4.154930908779013e-12,  -1.845313747012607e-13,   2.165873422512527e-15,  -1.862101942571779e-17,   3.532122661117262e-20,   2.887645259682416e-21,   3.213063715372870e-23,
   1.232824428862477e-24,  -1.147805574464363e-27,   2.523817490395842e-01,  -3.822637496090045e-03,   3.925842174533667e-05,  -2.993737380330668e-07,   1.351310641494271e-09,
   4.162047480666299e-12,  -1.846127584942961e-13,   2.166075311160952e-15,  -1.860052759766978e-17,   3.559739974328671e-20,   2.900254521825265e-21,   3.211309922965675e-23,
   1.226301296581935e-24,  -1.308338820188531e-27,   2.523858083780606e-01,  -3.822730325848588e-03,   3.925925915625887e-05,  -2.993694215364924e-07,   1.351024190949915e-09,
   4.166750106746622e-12,  -1.846665189891415e-13,   2.166208999954327e-15,  -1.858697077552541e-17,   3.577986086930821e-20,   2.908574170034415e-21,   3.210115325859252e-23,
   1.221989012505187e-24,  -1.414247504608989e-27,   2.523878930538028e-01,  -3.822777998197397e-03,   3.925968918380600e-05,  -2.993672041791377e-07,   1.350877074099691e-09,
   4.169165168067216e-12,  -1.846941224804759e-13,   2.166277743483794e-15,  -1.858000369621706e-17,   3.587355424351285e-20,   2.912842894241126e-21,   3.209490804116195e-23,
   1.219773858542551e-24,  -1.468584480099175e-27,   2.523886186460692e-01,  -3.822794590967274e-03,   3.925983885516531e-05,  -2.993664323073345e-07,   1.350825867015148e-09,
   4.170005758300088e-12,  -1.847037293170115e-13,   2.166301684297862e-15,  -1.857757794438037e-17,   3.590616361335856e-20,   2.914328055649999e-21,   3.209271676941027e-23,
   1.219002760236275e-24,  -1.487488652278519e-27,   2.523887337876535e-01,  -3.822797224010019e-03,   3.925986260577467e-05,  -2.993663098171495e-07,   1.350817741074531e-09,
   4.170139148679279e-12,  -1.847052537511367e-13,   2.166305484039906e-15,  -1.857719297318578e-17,   3.591133820137543e-20,   2.914563701487079e-21,   3.209236821096914e-23,
   1.218880393111497e-24,  -1.490488089576355e-27,   4.176638042229310e-01,  -6.020778348774697e-03,   5.345659405382019e-05,  -2.586898153921076e-07,  -1.041956784521957e-09,
   3.647874633470225e-11,  -3.922024988962781e-13,   1.025337243718415e-15,   2.476455888280973e-17,  -5.460385467407688e-19,   7.159027017291805e-21,   1.038718928620869e-22,
   1.157769251879335e-24,   1.170739276650104e-26,   4.176688145859223e-01,  -6.020850984620948e-03,   5.345600484587283e-05,  -2.586555999354238e-07,  -1.042507541019746e-09,
   3.648073590510131e-11,  -3.921368631396224e-13,   1.023508414958875e-15,   2.479497885548448e-17,  -5.455000858862104e-19,   7.165855723577605e-21,   1.039473043533941e-22,
   1.150546333065463e-24,   1.152189296180504e-26,   4.176776554050960e-01,  -6.020979143889773e-03,   5.345496492747930e-05,  -2.585952247154355e-07,  -1.043479284250888e-09,
   3.648424361312548e-11,  -3.920209827610894e-13,   1.020282897344613e-15,   2.484867850337908e-17,  -5.445496575130160e-19,   7.177868702096682e-21,   1.040792725816934e-22,
   1.137797118861913e-24,   1.119504105347460e-26,   4.176883457411115e-01,  -6.021134102105203e-03,   5.345370701789886e-05,  -2.585222157839047e-07,  -1.044654198150059e-09,
   3.648848019351072e-11,  -3.918807480143377e-13,   1.016385090218750e-15,   2.491365204025594e-17,  -5.433998712216861e-19,   7.192332876838511e-21,   1.042369821844059e-22,
   1.122373424111917e-24,   1.080060162652444e-26,   4.176987236536274e-01,  -6.021284518886774e-03,   5.345248541168309e-05,  -2.584513372871524e-07,  -1.045794649702879e-09,
   3.649258778195413e-11,  -3.917444943160541e-13,   1.012603809554162e-15,   2.497676832177856e-17,  -5.422831399955231e-19,   7.206309453834823e-21,   1.043881304224810e-22,
   1.107392890070381e-24,   1.041851726233688e-26,   4.177070839072045e-01,  -6.021405682679106e-03,   5.345150097965132e-05,  -2.583942365660199e-07,  -1.046713286212098e-09,
   3.649589306997252e-11,  -3.916346467975692e-13,   1.009559553240597e-15,   2.502764334600524e-17,  -5.413831327576846e-19,   7.217522222156074e-21,   1.045084954941462e-22,
   1.095319458374606e-24,   1.011131002931112e-26,   4.177126081855385e-01,  -6.021485740653001e-03,   5.345085032687455e-05,  -2.583565044842852e-07,  -1.047320257619006e-09,
   3.649807531880810e-11,  -3.915620207107808e-13,   1.007548890559447e-15,   2.506127500430027e-17,  -5.407882375764668e-19,   7.224908607620345e-21,   1.045873467867827e-22,
   1.087338970785008e-24,   9.908604205557689e-27,   4.177154451580379e-01,  -6.021526852737339e-03,   5.345051613679524e-05,  -2.583371269635647e-07,  -1.047631951867638e-09,
   3.649919544323308e-11,  -3.915247111187654e-13,   1.006516605995942e-15,   2.507855090086118e-17,  -5.404826730227457e-19,   7.228694814045043e-21,   1.046276293726760e-22,
   1.083239815248293e-24,   9.804595121443210e-27,   4.177164325909031e-01,  -6.021541161933453e-03,   5.345039981111747e-05,  -2.583303823936533e-07,  -1.047740437578788e-09,
   3.649958522289621e-11,  -3.915117231640173e-13,   1.006157355583669e-15,   2.508456463966845e-17,  -5.403763093627932e-19,   7.230011514453139e-21,   1.046416164652793e-22,
   1.081812940709419e-24,   9.768408142927824e-27,   4.177165892828335e-01,  -6.021543432594350e-03,   5.345038135146608e-05,  -2.583293121210951e-07,  -1.047757652656603e-09,
   3.649964707129295e-11,  -3.915096620590661e-13,   1.006100349659740e-15,   2.508551897064187e-17,  -5.403594304823623e-19,   7.230220403340054e-21,   1.046438344279644e-22,
   1.081586509401415e-24,   9.762666448349873e-27,   6.240407270666333e-01,  -8.357098193679042e-03,   5.732564328910945e-05,   1.318951366010206e-08,  -5.411723547689574e-09,
   5.621164387595148e-11,   5.699430422069194e-15,  -8.091485084866381e-15,   8.712647705961106e-17,  -3.888605586525240e-22,  -9.943347576407601e-21,   3.442938570466463e-22,
   2.966389694927649e-24,  -2.275171356315493e-26,   6.240460952244493e-01,  -8.357094299016099e-03,   5.732259926249260e-05,   1.324207804449758e-08,  -5.411712839624432e-09,
   5.619571461093108e-11,   5.927284284241877e-15,  -8.091440337693238e-15,   8.708510536648038e-17,   1.379161423271858e-21,  -9.925354446160233e-21,   3.441104411105444e-22,
   2.958612822398074e-24,  -2.306192017545733e-26,   6.240555671915042e-01,  -8.357087414826032e-03,   5.731722803508935e-05,   1.333481658824318e-08,  -5.411693684907337e-09,
   5.616760726608902e-11,   6.329248070773084e-15,  -8.091356534733568e-15,   8.701216575744470e-17,   4.498077779804309e-21,  -9.893644570489016e-21,   3.437849688714072e-22,
   2.944875433410038e-24,  -2.360837422710512e-26,   6.240670203999291e-01,  -8.357079069937504e-03,   5.731073309889744e-05,   1.344693632751357e-08,  -5.411670079279787e-09,
   5.613361972977023e-11,   6.815157124429933e-15,  -8.091246938188145e-15,   8.692407099281237e-17,   8.268158910296818e-21,  -9.855367686453448e-21,   3.433882844648409e-22,
   2.928238597861422e-24,  -2.426760044901592e-26,   6.240781385624166e-01,  -8.357070947449100e-03,   5.730442793718829e-05,   1.355575855422211e-08,  -5.411646698962972e-09,
   5.610062539778761e-11,   7.286712413339516e-15,  -8.091131894721263e-15,   8.683865952765491e-17,   1.192667236750782e-20,  -9.818279414833932e-21,   3.429999277083245e-22,
   2.912061329476376e-24,  -2.490594133532724e-26,   6.240870949129065e-01,  -8.357064388735952e-03,   5.729934858808910e-05,   1.364340879462574e-08,  -5.411627531417168e-09,
   5.607404572671711e-11,   7.666478948855805e-15,  -8.091033021550328e-15,   8.676993146875415e-17,   1.487290393592427e-20,  -9.788451975668202e-21,   3.426847383864476e-22,
   2.899010219414886e-24,  -2.541901689336378e-26,   6.240930129645252e-01,  -8.357060047343922e-03,   5.729599224823312e-05,   1.370131890806197e-08,  -5.411614702986794e-09,
   5.605648242095938e-11,   7.917366970890121e-15,  -8.090964654914110e-15,   8.672455549915355e-17,   1.681922029945568e-20,  -9.768767225940213e-21,   3.424753253700781e-22,
   2.890377052691098e-24,  -2.575747853621661e-26,   6.240960521222851e-01,  -8.357057815508620e-03,   5.729426860822420e-05,   1.373105617061032e-08,  -5.411608064614069e-09,
   5.604746284432954e-11,   8.046192991163075e-15,  -8.090928607507211e-15,   8.670126460733572e-17,   1.781859154563335e-20,  -9.758665804812638e-21,   3.423674290246409e-22,
   2.885940662739740e-24,  -2.593111868225378e-26,   6.240971099218248e-01,  -8.357057038328130e-03,   5.729366867971048e-05,   1.374140612278868e-08,  -5.411605746050756e-09,
   5.604432350150432e-11,   8.091029364075132e-15,  -8.090915911577726e-15,   8.669315988340951e-17,   1.816640709443433e-20,  -9.755151129287083e-21,   3.423298185820934e-22,
   2.884396084197502e-24,  -2.599152769261075e-26,   6.240972777797040e-01,  -8.357056914982735e-03,   5.729357347932608e-05,   1.374304849988454e-08,  -5.411605377746112e-09,
   5.604382533119680e-11,   8.098144150642124e-15,  -8.090913889821047e-15,   8.669187386478176e-17,   1.822159945541114e-20,  -9.754593456449289e-21,   3.423238476586133e-22,
   2.884150959391848e-24,  -2.600111243985025e-26,   8.695199178985207e-01,  -1.041345562547008e-02,   4.098166910900807e-05,   5.340307356203352e-07,  -8.326568287808716e-09,
  -8.119563494439621e-12,   1.288636381291266e-12,  -1.064894287716993e-14,  -1.429941509698866e-16,   3.070458696120589e-18,   2.300125817402195e-21,  -3.022307787204850e-22,
   1.126624417719673e-23,   6.654982226414417e-26,   8.695237505409631e-01,  -1.041330545708613e-02,   4.097699562498455e-05,   5.340229488177609e-07,  -8.324760582026452e-09,
  -8.140364453673180e-12,   1.288261274551891e-12,  -1.063862018818854e-14,  -1.429822621046547e-16,   3.068918146331120e-18,   2.368324223317420e-21,  -3.017688273618874e-22,
   1.123362232140499e-23,   6.610098135160280e-26,   8.695305129439566e-01,  -1.041304048441707e-02,   4.096875001442353e-05,   5.340091930781487e-07,  -8.321571285439521e-09,
  -8.177051571246233e-12,   1.287599419493188e-12,  -1.062040985488879e-14,  -1.429610514325165e-16,   3.066201733234109e-18,   2.488497325684139e-21,  -3.009563628655247e-22,
   1.117606436395376e-23,   6.530991666851803e-26,   8.695386895088358e-01,  -1.041272007971775e-02,   4.095878074147819e-05,   5.339925325523519e-07,  -8.317715484884519e-09,
  -8.221385892738668e-12,   1.286799143121508e-12,  -1.059839690661265e-14,  -1.429350070740630e-16,   3.062920268714634e-18,   2.633532207057564e-21,  -2.999784469611317e-22,
   1.110647133997739e-23,   6.435492573850524e-26,   8.695466265429127e-01,  -1.041240903961368e-02,   4.094910421756205e-05,   5.339763306035587e-07,  -8.313973105869322e-09,
  -8.264395429829430e-12,   1.286022297104348e-12,  -1.057703463313944e-14,  -1.429093092701300e-16,   3.059738074708199e-18,   2.774036659679867e-21,  -2.990338367048131e-22,
   1.103891882792669e-23,   6.342948495303827e-26,   8.695530200604367e-01,  -1.041215847206849e-02,   4.094130999150509e-05,   5.339632583277382e-07,  -8.310958842402321e-09,
  -8.299022253489456e-12,   1.285396515060516e-12,  -1.055983084518970e-14,  -1.428883108899149e-16,   3.057176966233149e-18,   2.887015371079311e-21,  -2.982762591738596e-22,
   1.098450469779866e-23,   6.268514309002374e-26,   8.695572445606896e-01,  -1.041199290263401e-02,   4.093616022265975e-05,   5.339546105150925e-07,  -8.308967339303195e-09,
  -8.321892712213558e-12,   1.284983026695883e-12,  -1.054846552234874e-14,  -1.428742904688401e-16,   3.055485816275040e-18,   2.961566948952144e-21,  -2.977773230273654e-22,
   1.094855146012882e-23,   6.219387379352563e-26,   8.695594139749809e-01,  -1.041190787515860e-02,   4.093351572979097e-05,   5.339501663929504e-07,  -8.307944690207066e-09,
  -8.333634592943858e-12,   1.284770686000522e-12,  -1.054262969950051e-14,  -1.428670454787359e-16,   3.054617695706271e-18,   2.999820978609036e-21,  -2.975216077767797e-22,
   1.093008858412616e-23,   6.194176246674837e-26,   8.695601690485514e-01,  -1.041187828062309e-02,   4.093259531527639e-05,   5.339486190889906e-07,  -8.307588761043185e-09,
  -8.337720953581853e-12,   1.284696779733317e-12,  -1.054059861751932e-14,  -1.428645166587574e-16,   3.054315596584387e-18,   3.013130585791485e-21,  -2.974326852803635e-22,
   1.092366254457526e-23,   6.185404130567155e-26,   8.695602888678086e-01,  -1.041187358438054e-02,   4.093244925937707e-05,   5.339483735300651e-07,  -8.307532280614371e-09,
  -8.338369378598267e-12,   1.284685051867267e-12,  -1.054027631893368e-14,  -1.428641150311945e-16,   3.054267660375836e-18,   3.015242397023061e-21,  -2.974185783752104e-22,
   1.092264282696008e-23,   6.184012251835059e-26,   1.148537183918884e+00,  -1.151790967864957e-02,  -3.860091027132397e-06,   1.046821474807440e-06,  -1.954769601331910e-09,
  -1.687898845386878e-10,   8.731592185424762e-13,   2.991740646155471e-14,  -3.228616016177031e-16,  -5.732752120896670e-18,   1.037417181481480e-19,   1.365285091684588e-21,
  -1.889651045151805e-23,  -8.127753058979790e-26,   1.148536819842719e+00,  -1.151761581621847e-02,  -3.861183713213766e-06,   1.046663726954909e-06,  -1.953551626391201e-09,
  -1.687312891986084e-10,   8.723206597876631e-13,   2.989824120852486e-14,  -3.224276404755184e-16,  -5.725737781105470e-18,   1.036264402167967e-19,   1.364640206244923e-21,
  -1.886074524650063e-23,  -8.219834520780053e-26,   1.148536177342123e+00,  -1.151709732731267e-02,  -3.863111220354103e-06,   1.046385422950441e-06,  -1.951403445610033e-09,
  -1.686279273835864e-10,   8.708419335428506e-13,   2.986444304523885e-14,  -3.216623031519668e-16,  -5.713363622966304e-18,   1.034232082405740e-19,   1.363496866196708e-21,
  -1.879783315879765e-23,  -8.381981308005530e-26,   1.148535400282937e+00,  -1.151647042632443e-02,  -3.865441037173227e-06,   1.046048970742297e-06,  -1.948807470366649e-09,
  -1.685029933002827e-10,   8.690554166689215e-13,   2.982360672378750e-14,  -3.207375203669556e-16,  -5.698405371359864e-18,   1.031777603651146e-19,   1.362105082867048e-21,
  -1.872209305176937e-23,  -8.577484632598303e-26,   1.148534645780132e+00,  -1.151586190591873e-02,  -3.867701793368495e-06,   1.045722428294824e-06,  -1.946289046346562e-09,
  -1.683817640156552e-10,   8.673227452909896e-13,   2.978399784864246e-14,  -3.198404596811725e-16,  -5.683889114425614e-18,   1.029397996319047e-19,   1.360744300348922e-21,
  -1.864891466746342e-23,  -8.766683446018387e-26,   1.148534037857041e+00,  -1.151537173580185e-02,  -3.869522320351317e-06,   1.045459426915825e-06,  -1.944261456831164e-09,
  -1.682841423541670e-10,   8.659281082309605e-13,   2.975211403850751e-14,  -3.191183021783131e-16,  -5.672198570637169e-18,   1.027483272377189e-19,   1.359641160017093e-21,
  -1.859021245254668e-23,  -8.918675496499136e-26,   1.148533636100677e+00,  -1.151504786264505e-02,  -3.870724945207007e-06,   1.045285668178081e-06,  -1.942922258942740e-09,
  -1.682196548231780e-10,   8.650071346870969e-13,   2.973105782010745e-14,  -3.186413594582886e-16,  -5.664475418215682e-18,   1.026219159455097e-19,   1.358908845311619e-21,
  -1.855154492643636e-23,  -9.018901677960466e-26,   1.148533429763599e+00,  -1.151488154524759e-02,  -3.871342443341575e-06,   1.045196443375680e-06,  -1.942234701364981e-09,
  -1.681865433029991e-10,   8.645343493450466e-13,   2.972024816608899e-14,  -3.183965026253768e-16,  -5.660509752509997e-18,   1.025570317440217e-19,   1.358531722655854e-21,
  -1.853172493606533e-23,  -9.070308495722740e-26,   1.148533357943549e+00,  -1.151482365806317e-02,  -3.871557352146337e-06,   1.045165389238868e-06,  -1.941995420039765e-09,
  -1.681750194763235e-10,   8.643698205128419e-13,   2.971648635946861e-14,  -3.183112900707112e-16,  -5.659129552734044e-18,   1.025344536190103e-19,   1.358400295546148e-21,
  -1.852483239398027e-23,  -9.088190904315859e-26,   1.148533346546575e+00,  -1.151481447221687e-02,  -3.871591454403274e-06,   1.045160461440208e-06,  -1.941957450783850e-09,
  -1.681731908484154e-10,   8.643437134029580e-13,   2.971588944069136e-14,  -3.182977685866191e-16,  -5.658910538146117e-18,   1.025308710385211e-19,   1.358379431989697e-21,
  -1.852373892661420e-23,  -9.091028111874575e-26,   1.447177610583488e+00,  -1.070199256997799e-02,  -7.024379411471580e-05,   7.970998578200348e-07,   1.568290986812229e-08,
  -8.872230280818987e-11,  -4.102226148340088e-12,   1.503798659595426e-15,   1.074500170953755e-15,   4.243739874592556e-18,  -2.884507710998776e-19,  -2.145385528970973e-21,
   9.499004534142155e-23,   1.400669248046978e-24,   1.447171042883861e+00,  -1.070176867895792e-02,  -7.023500485339611e-05,   7.970167078095133e-07,   1.567717414922002e-08,
  -8.871911941267859e-11,  -4.099430283867970e-12,   1.517844356107581e-15,   1.073301821939636e-15,   4.233059895099463e-18,  -2.878723796193367e-19,  -2.135507522068028e-21,
   9.478787527469350e-23,   1.394033631823487e-24,   1.447159454740430e+00,  -1.070137363873292e-02,  -7.021949867855239e-05,   7.968699908004162e-07,   1.566705656961170e-08,
  -8.871347991531898e-11,  -4.094499483158859e-12,   1.542599183981615e-15,   1.071189291798770e-15,   4.214255940250518e-18,  -2.868528141557009e-19,  -2.118116771506776e-21,
   9.443128635414713e-23,   1.382347332381723e-24,   1.447145443368825e+00,  -1.070089598427173e-02,  -7.020075290409410e-05,   7.966925832870061e-07,   1.565482771572535e-08,
  -8.870662250481743e-11,  -4.088541444751726e-12,   1.572483573674378e-15,   1.068638163869436e-15,   4.191587856686756e-18,  -2.856216755519250e-19,  -2.097154350117466e-21,
   9.400034031460496e-23,   1.368254192415531e-24,   1.447131842560452e+00,  -1.070043231951709e-02,  -7.018255949767504e-05,   7.965203636213774e-07,   1.564296184131038e-08,
  -8.869992562308515e-11,  -4.082762023755429e-12,   1.601443175147106e-15,   1.066165094930287e-15,   4.169655087108644e-18,  -2.844283193972899e-19,  -2.076874084456284e-21,
   9.358224288637725e-23,   1.354612606446688e-24,   1.447120886777635e+00,  -1.070005882152934e-02,  -7.016790646900528e-05,   7.963816289168389e-07,   1.563340691887075e-08,
  -8.869450219516973e-11,  -4.078109447346927e-12,   1.624735717577611e-15,   1.064175344036142e-15,   4.152038546652449e-18,  -2.834682649616812e-19,  -2.060586417571942e-21,
   9.324561416293468e-23,   1.343651586920232e-24,   1.447113647808403e+00,  -1.069981203261473e-02,  -7.015822564512678e-05,   7.962899570755755e-07,   1.562709518921856e-08,
  -8.869090454421904e-11,  -4.075036697974816e-12,   1.640108957610163e-15,   1.062861785713251e-15,   4.140423375142949e-18,  -2.828345133308753e-19,  -2.049848193206538e-21,
   9.302326678835774e-23,   1.336422659451367e-24,   1.447109930380245e+00,  -1.069968529837945e-02,  -7.015325458485957e-05,   7.962428796882815e-07,   1.562385443020042e-08,
  -8.868905266769498e-11,  -4.073459185719343e-12,   1.647998273541920e-15,   1.062187591987653e-15,   4.134466313896250e-18,  -2.825092479587756e-19,  -2.044341132630229e-21,
   9.290910893311988e-23,   1.332714560016879e-24,   1.447108636515853e+00,  -1.069964118795425e-02,  -7.015152444235979e-05,   7.962264940505259e-07,   1.562272655242659e-08,
  -8.868840741907177e-11,  -4.072910196371671e-12,   1.650743334635471e-15,   1.061952993378384e-15,   4.132394158725499e-18,  -2.823960676332762e-19,  -2.042425548158410e-21,
   9.286937973401983e-23,   1.331424606386970e-24,   1.447108431198368e+00,  -1.069963418826509e-02,  -7.015124989639682e-05,   7.962238938791862e-07,   1.562254757841320e-08,
  -8.868830499443759e-11,  -4.072823083036879e-12,   1.651178895900414e-15,   1.061915768690909e-15,   4.132065395780153e-18,  -2.823781089585922e-19,  -2.042121628163727e-21,
   9.286307547042881e-23,   1.331219940992180e-24,   1.733280906458761e+00,  -7.107633676639481e-03,  -1.072265850511227e-04,  -7.042726498963445e-07,   1.015619093120306e-08,
   3.345793067847965e-10,   2.725309840099291e-12,  -5.562677798654286e-14,  -1.875864393655440e-15,  -1.502439228765849e-17,   3.863206844390103e-19,   1.285242822584147e-20,
   1.099710592733688e-22,  -2.454834506044995e-24,   1.733270865497540e+00,  -7.107830651568193e-03,  -1.072208509295832e-04,  -7.039599104712852e-07,   1.015996561541310e-08,
   3.344690161727904e-10,   2.720419854196732e-12,  -5.567577917756493e-14,  -1.874213960953261e-15,  -1.495883744002233e-17,   3.869679382514483e-19,   1.283410113795991e-20,
   1.092528995190555e-22,  -2.461730830040666e-24,   1.733253148502810e+00,  -7.108178145585492e-03,  -1.072107312691435e-04,  -7.034081611275517e-07,   1.016662052799483e-08,
   3.342743290579118e-10,   2.711794931694889e-12,  -5.576206320359543e-14,  -1.871299555580848e-15,  -1.484324208805395e-17,   3.881064292922662e-19,   1.280172244287364e-20,
   1.079869743391655e-22,  -2.473844609353683e-24,   1.733231725672622e+00,  -7.108598217431306e-03,  -1.071984915489304e-04,  -7.027411236902831e-07,   1.017465821276865e-08,
   3.340387792087561e-10,   2.701371613127605e-12,  -5.586609311478467e-14,  -1.867771698221325e-15,  -1.470359471380100e-17,   3.894769735129430e-19,   1.276250135453235e-20,
   1.064583873871351e-22,  -2.488399229315865e-24,   1.733210929544504e+00,  -7.109005888552151e-03,  -1.071866063862182e-04,  -7.020937258922425e-07,   1.018245110631413e-08,
   3.338099733987775e-10,   2.691259154358044e-12,  -5.596676365873843e-14,  -1.864343022985129e-15,  -1.456816558406714e-17,   3.908010591168358e-19,   1.272435483161322e-20,
   1.049767511341485e-22,  -2.502430833909239e-24,   1.733194177016370e+00,  -7.109334211867708e-03,  -1.071770296669374e-04,  -7.015722985851542e-07,   1.018872183215300e-08,
   3.336255516463162e-10,   2.683117219083421e-12,  -5.604763346861690e-14,  -1.861578145503771e-15,  -1.445916470602460e-17,   3.918631329184085e-19,   1.269357355298663e-20,
   1.037848068795517e-22,  -2.513664556400207e-24,   1.733183107519529e+00,  -7.109551117398153e-03,  -1.071707004713740e-04,  -7.012278015742080e-07,   1.019286192709912e-08,
   3.335036407496040e-10,   2.677739392452225e-12,  -5.610095869197640e-14,  -1.859749804977304e-15,  -1.438718741499276e-17,   3.925626854435028e-19,   1.267320897354199e-20,
   1.029979965256150e-22,  -2.521053386367412e-24,   1.733177422888395e+00,  -7.109662494953746e-03,  -1.071674497958182e-04,  -7.010509022274863e-07,   1.019498698516633e-08,
   3.334410187525568e-10,   2.674978307695653e-12,  -5.612830908705342e-14,  -1.858810445082075e-15,  -1.435023865456487e-17,   3.929212445991716e-19,   1.266274311693223e-20,
   1.025941809594485e-22,  -2.524837331383093e-24,   1.733175444314027e+00,  -7.109701258733002e-03,  -1.071663183157715e-04,  -7.009893333933961e-07,   1.019572645936260e-08,
   3.334192202193353e-10,   2.674017396180375e-12,  -5.613782312583087e-14,  -1.858483425532851e-15,  -1.433738069251431e-17,   3.930459338560155e-19,   1.265909916004569e-20,
   1.024536689431643e-22,  -2.526152685637631e-24,   1.733175130342168e+00,  -7.109707409906518e-03,  -1.071661387629719e-04,  -7.009795633909700e-07,   1.019584379558139e-08,
   3.334157609796686e-10,   2.673864917946990e-12,  -5.613933261087998e-14,  -1.858431528867207e-15,  -1.433534042460973e-17,   3.930657150767081e-19,   1.265852085640333e-20,
   1.024313735058780e-22,  -2.526361334385317e-24,   1.942835098114107e+00,  -1.916765667917066e-03,  -4.576313954511377e-05,  -9.021342255990103e-07,  -1.493877803209930e-08,
  -1.965621322658345e-10,  -1.554192654420248e-12,   1.271159035919335e-14,   8.720246119127472e-16,   2.236287301209874e-17,   3.924201059938153e-19,   4.463516707807051e-21,
   4.115637227967312e-24,  -1.348317001463712e-24,   1.942830790934843e+00,  -1.917020040922138e-03,  -4.577155475765369e-05,  -9.023182804375578e-07,  -1.494093608329463e-08,
  -1.965358951863271e-10,  -1.551869398732965e-12,   1.278765274850328e-14,   8.736803281145057e-16,   2.238548503636076e-17,   3.924288465018434e-19,   4.453227935538292e-21,
   3.755805753205967e-24,  -1.356090520309618e-24,   1.942823190206313e+00,  -1.917468928144527e-03,  -4.578640451319172e-05,  -9.026430277291354e-07,  -1.494474132903257e-08,
  -1.964894774116257e-10,  -1.547766443865529e-12,   1.292192778003288e-14,   8.766018806805597e-16,   2.242534073836909e-17,   3.924424507761841e-19,   4.435026973809516e-21,
   3.120119627713066e-24,  -1.369810518978917e-24,   1.942813998227813e+00,  -1.918011799070998e-03,  -4.580436266746013e-05,  -9.030356808334369e-07,  -1.494933811827157e-08,
  -1.964331403949554e-10,  -1.542799081811795e-12,   1.308439978762291e-14,   8.801346750308263e-16,   2.247346025481957e-17,   3.924557979309877e-19,   4.412939283463390e-21,
   2.350150345566931e-24,  -1.386406791494048e-24,   1.942805073666046e+00,  -1.918538883849764e-03,  -4.582179788176959e-05,  -9.034168251565726e-07,  -1.495379582866769e-08,
  -1.963782313382450e-10,  -1.537970543188225e-12,   1.324223486434720e-14,   8.835642679629091e-16,   2.252009574246877e-17,   3.924655020747063e-19,   4.391414302679449e-21,
   1.601327458147402e-24,  -1.402524260388363e-24,   1.942797883332451e+00,  -1.918963550285112e-03,  -4.583584471608123e-05,  -9.037238438473740e-07,  -1.495738347984658e-08,
  -1.963338410191294e-10,  -1.534076214508376e-12,   1.336946353586559e-14,   8.863271119871278e-16,   2.255760860259888e-17,   3.924709864741545e-19,   4.374014839430477e-21,
   9.971193877977226e-25,  -1.415512589004532e-24,   1.942793131685270e+00,  -1.919244188637311e-03,  -4.584512722686356e-05,  -9.039267034680702e-07,  -1.495975245915775e-08,
  -1.963044321353657e-10,  -1.531500698008293e-12,   1.345357252132987e-14,   8.881527527319731e-16,   2.258236892466419e-17,   3.924734671606968e-19,   4.362488584189117e-21,
   5.973969234436372e-25,  -1.424097128233513e-24,   1.942790691362501e+00,  -1.919388318003889e-03,  -4.584989442978340e-05,  -9.040308776074941e-07,  -1.496096852464373e-08,
  -1.962893055868650e-10,  -1.530177362511530e-12,   1.349677842407402e-14,   8.890903070897173e-16,   2.259507601749789e-17,   3.924743873327945e-19,   4.356560331100467e-21,
   3.919742805312762e-25,  -1.428506338770344e-24,   1.942789841965979e+00,  -1.919438484846444e-03,  -4.585155372857624e-05,  -9.040671357362935e-07,  -1.496139170476906e-08,
  -1.962840368828585e-10,  -1.529716654493471e-12,   1.351181853038401e-14,   8.894166315168620e-16,   2.259949748064723e-17,   3.924746512671268e-19,   4.354495520274282e-21,
   3.204518093638814e-25,  -1.430041106114155e-24,   1.942789707177507e+00,  -1.919446445695002e-03,  -4.585181703787409e-05,  -9.040728893718515e-07,  -1.496145885370497e-08,
  -1.962832006330978e-10,  -1.529643541302362e-12,   1.351420527812646e-14,   8.894684147108700e-16,   2.260019904152158e-17,   3.924746904748651e-19,   4.354167795437205e-21,
   3.091010751659398e-25,  -1.430284657350972e-24,   4.817852534582260e-03,  -7.522565632736859e-05,   8.784835211665964e-07,  -9.121281572245260e-09,   8.807709287541407e-11,
  -8.253822625281260e-13,   7.203323369747178e-15,  -6.707550263858808e-17,   5.582371650923658e-19,  -2.219722739957720e-21,   1.308209736148900e-22,   1.374377351845836e-24,
   3.678822046619015e-27,  -7.860148559478132e-28,   4.817934991822558e-03,  -7.522822441249775e-05,   8.785331217208457e-07,  -9.122056477971926e-09,   8.808724001110403e-11,
  -8.255144331003365e-13,   7.204800148809064e-15,  -6.708281623251743e-17,   5.587895371200942e-19,  -2.212861760234784e-21,   1.308367426767378e-22,   1.368585095440660e-24,
   3.527408690902420e-27,  -7.868342495332779e-28,   4.818080492709807e-03,  -7.523275601655822e-05,   8.786206473250025e-07,  -9.123423912112683e-09,   8.810514648480339e-11,
  -8.257476617766709e-13,   7.207407127839622e-15,  -6.709570252459152e-17,   5.597642542184182e-19,  -2.200779779873103e-21,   1.308638094249003e-22,   1.358359810836204e-24,
   3.260569225821224e-27,  -7.882715837288423e-28,   4.818256440399040e-03,  -7.523823598318925e-05,   8.787264921428814e-07,  -9.125077599956964e-09,   8.812680207199819e-11,
  -8.260297041809143e-13,   7.210561525340042e-15,  -6.711125299647072e-17,   5.609429725584059e-19,  -2.186211611962483e-21,   1.308952474991155e-22,   1.345987210715821e-24,
   2.938469729038926e-27,  -7.899951527692784e-28,   4.818427254137118e-03,  -7.524355615681912e-05,   8.788292527566058e-07,  -9.126683151480225e-09,   8.814782796652441e-11,
  -8.263035267700324e-13,   7.213625865394501e-15,  -6.712631591439131e-17,   5.620873334412648e-19,  -2.172112553718293e-21,   1.309244162303493e-22,   1.333967690743221e-24,
   2.626373335627737e-27,  -7.916532356955584e-28,   4.818564864311978e-03,  -7.524784224657014e-05,   8.789120413157359e-07,  -9.127976691875573e-09,   8.816476832220268e-11,
  -8.265241295039649e-13,   7.216095966577578e-15,  -6.713842665081387e-17,   5.630092725022049e-19,  -2.160785691738932e-21,   1.309469473599270e-22,   1.324278924123845e-24,
   2.375376790498239e-27,  -7.929781445826382e-28,   4.818655797038305e-03,  -7.525067452950515e-05,   8.789667494318515e-07,  -9.128831503473574e-09,   8.817596326953644e-11,
  -8.266699071081612e-13,   7.217728904150945e-15,  -6.714641759556188e-17,   5.636185005850405e-19,  -2.153316362770879e-21,   1.309613625624833e-22,   1.317873835608738e-24,
   2.209730439009364e-27,  -7.938483297224531e-28,   4.818702496078514e-03,  -7.525212907669721e-05,   8.789948455674810e-07,  -9.129270509660070e-09,   8.818171273918162e-11,
  -8.267447731229142e-13,   7.218567724187105e-15,  -6.715051773981013e-17,   5.639313766231688e-19,  -2.149485225168848e-21,   1.309686192778738e-22,   1.314583614525082e-24,
   2.124727336519204e-27,  -7.942935766711593e-28,   4.818718750224014e-03,  -7.525263535064203e-05,   8.790046248281187e-07,  -9.129423312892772e-09,   8.818371394705257e-11,
  -8.267708312813906e-13,   7.218859719553770e-15,  -6.715194426162788e-17,   5.640402772974090e-19,  -2.148152514198529e-21,   1.309711217797961e-22,   1.313438279636946e-24,
   2.095151452375538e-27,  -7.944482888312583e-28,   4.818721329538598e-03,  -7.525271568960443e-05,   8.790061766689043e-07,  -9.129447560808966e-09,   8.818403151366398e-11,
  -8.267749663691803e-13,   7.218906056923709e-15,  -6.715217060389617e-17,   5.640575583962612e-19,  -2.147941067002645e-21,   1.309715177881115e-22,   1.313256523965443e-24,
   2.090458652248353e-27,  -7.944728271744719e-28,   4.341187478353875e-02,  -6.724420029730348e-04,   7.696362099367699e-06,  -7.697114744402388e-08,   6.984560737898803e-10,
  -5.968419843669464e-12,   4.469482171180166e-14,  -3.507646014935289e-16,   2.054596500849599e-18,   1.297264208041704e-20,   8.477496092829096e-22,   1.601757100445432e-23,
   2.233278630489861e-27,  -6.886929706270029e-27,   4.341259710547817e-02,  -6.724636707962841e-04,   7.696755335317705e-06,  -7.697674862586195e-08,   6.985189905284769e-10,
  -5.969109675729456e-12,   4.470028883285767e-14,  -3.507187253494697e-16,   2.058170966055319e-18,   1.305325509812929e-20,   8.476983887703099e-22,   1.596681119748361e-23,
   8.252530492452620e-28,  -6.894278122689701e-27,   4.341387168393739e-02,  -6.725019052936170e-04,   7.697449235136306e-06,  -7.698663252503643e-08,   6.986300143847277e-10,
  -5.970326820812575e-12,   4.470994328113636e-14,  -3.506375564328908e-16,   2.064477933505037e-18,   1.319528484685217e-20,   8.476009598417686e-22,   1.587720208368991e-23,
  -1.656201715040196e-27,  -6.907166376118651e-27,   4.341541296904030e-02,  -6.725481410428900e-04,   7.698288355316943e-06,  -7.699858513785599e-08,   6.987642763339165e-10,
  -5.971798478487591e-12,   4.472163054770873e-14,  -3.505390318400560e-16,   2.072103972754706e-18,   1.336666511044347e-20,   8.474711381366281e-22,   1.576877340494434e-23,
  -4.651640201195171e-27,  -6.922617934974907e-27,   4.341690927556911e-02,  -6.725930281978187e-04,   7.699103010089062e-06,  -7.701018946606352e-08,   6.988946267394107e-10,
  -5.973227004813620e-12,   4.473298996152024e-14,  -3.504429944491478e-16,   2.079506745918985e-18,   1.353265716445625e-20,   8.473325464399085e-22,   1.566343732777336e-23,
  -7.554154226379499e-27,  -6.937478943229052e-27,   4.341811471907783e-02,  -6.726291903468678e-04,   7.699759322227799e-06,  -7.701953843441731e-08,   6.989996433820932e-10,
  -5.974377711198558e-12,   4.474215071424569e-14,  -3.503653478846948e-16,   2.085469983780069e-18,   1.366610515496334e-20,   8.472119067815312e-22,   1.557852621955623e-23,
  -9.888509225721676e-27,  -6.949351281479455e-27,   4.341891127349020e-02,  -6.726530864541557e-04,   7.700193019640119e-06,  -7.702571639540016e-08,   6.990690404530195e-10,
  -5.975138030463207e-12,   4.474820875343020e-14,  -3.503139034237646e-16,   2.089410212704722e-18,   1.375415147407728e-20,   8.471277913130128e-22,   1.552239227680768e-23,
  -1.142911359782991e-26,  -6.957147661849431e-27,   4.341932034811385e-02,  -6.726653584971010e-04,   7.700415749593077e-06,  -7.702888917578713e-08,   6.991046803897260e-10,
  -5.975528476227108e-12,   4.475132132370831e-14,  -3.502874418958520e-16,   2.091433654192434e-18,   1.379932610356706e-20,   8.470832343918190e-22,   1.549355673464732e-23,
  -1.221970141582163e-26,  -6.961136445246833e-27,   4.341946273120922e-02,  -6.726696299335888e-04,   7.700493273681271e-06,  -7.702999350726552e-08,   6.991170853903851e-10,
  -5.975664372131460e-12,   4.475240491748123e-14,  -3.502782249816006e-16,   2.092137922726818e-18,   1.381504296035825e-20,   8.470675095684770e-22,   1.548351897648967e-23,
  -1.249477942059773e-26,  -6.962522386154989e-27,   4.341948532548951e-02,  -6.726703077536100e-04,   7.700505575728561e-06,  -7.703016875023152e-08,   6.991190539023704e-10,
  -5.975685936829749e-12,   4.475257688005436e-14,  -3.502767620644685e-16,   2.092249680023554e-18,   1.381753669636605e-20,   8.470650039848162e-22,   1.548192606161766e-23,
  -1.253842608116919e-26,  -6.962742202374296e-27,   1.208655281451801e-01,  -1.841000203950665e-03,   2.017235423499724e-05,  -1.850734391063737e-07,   1.430701609764552e-09,
  -9.124342108082985e-12,   2.953813537554486e-14,   7.983246787770074e-17,  -4.744801292716297e-18,   1.270022934307131e-19,   1.795883555969107e-21,   4.882996777204587e-23,
   2.172606943722458e-26,  -2.012303894654520e-26,   1.208674209156822e-01,  -1.841052285878349e-03,   2.017315923664372e-05,  -1.850819917736806e-07,   1.430743002486646e-09,
  -9.124178004364460e-12,   2.952583670694727e-14,   8.026748952798660e-17,  -4.737227465063858e-18,   1.272482929903843e-19,   1.795833197229562e-21,   4.868161609750807e-23,
   1.772532765870259e-26,  -2.014515410036104e-26,   1.208707608004443e-01,  -1.841144187215861e-03,   2.017457969362982e-05,  -1.850970829626990e-07,   1.430816026597709e-09,
  -9.123887741333071e-12,   2.950415167393799e-14,   8.103576282581773e-17,  -4.723863661638164e-18,   1.276817399759561e-19,   1.795724309977762e-21,   4.841971879541426e-23,
   1.067473763536931e-26,  -2.018395078072825e-26,   1.208747995295368e-01,  -1.841255318631561e-03,   2.017629735764498e-05,  -1.851153311728047e-07,   1.430904304277516e-09,
  -9.123535558841703e-12,   2.947795745588125e-14,   8.196590962241443e-17,  -4.707704625202959e-18,   1.282048058880874e-19,   1.795558522392067e-21,   4.810281169657922e-23,
   2.164060337740213e-27,  -2.023047957713747e-26,   1.208787203675274e-01,  -1.841363206580130e-03,   2.017796486990531e-05,  -1.851330459916993e-07,   1.430989977755874e-09,
  -9.123192415596008e-12,   2.945255741744611e-14,   8.287007496713196e-17,  -4.692018418756991e-18,   1.287114757898307e-19,   1.795361887174486e-21,   4.779493656358703e-23,
  -6.082282657119632e-27,  -2.027524690376740e-26,   1.208818790222242e-01,  -1.841450122211839e-03,   2.017930822028765e-05,  -1.851473166560283e-07,   1.431058977319884e-09,
  -9.122915087166428e-12,   2.943211615067974e-14,   8.359931392269832e-17,  -4.679382363116802e-18,   1.291188443786300e-19,   1.795177934762795e-21,   4.754675438891591e-23,
  -1.271420008204896e-26,  -2.031102331582987e-26,   1.208839662434640e-01,  -1.841507555738648e-03,   2.018019589413235e-05,  -1.851567463766579e-07,   1.431104562254630e-09,
  -9.122731394170527e-12,   2.941861904795748e-14,   8.408160029324016e-17,  -4.671032968105033e-18,   1.293876353856796e-19,   1.795043885440894e-21,   4.738268105503311e-23,
  -1.709095563478564e-26,  -2.033452312780067e-26,   1.208850381433426e-01,  -1.841537050981824e-03,   2.018065176078746e-05,  -1.851615889645855e-07,   1.431127969595371e-09,
  -9.122636923110564e-12,   2.941169077022394e-14,   8.432940668089739e-17,  -4.666745246162806e-18,   1.295255515118879e-19,   1.794971182274831e-21,   4.729839719458199e-23,
  -1.933692909984160e-26,  -2.034654796421698e-26,   1.208854112298063e-01,  -1.841547317131668e-03,   2.018081042993447e-05,  -1.851632744677083e-07,   1.431136116304215e-09,
  -9.122604019949779e-12,   2.940927981805843e-14,   8.441567853371749e-17,  -4.665252880227922e-18,   1.295735352299746e-19,   1.794945262576990e-21,   4.726905755437080e-23,
  -2.011839011626027e-26,  -2.035072640641003e-26,   1.208854704335799e-01,  -1.841548946231125e-03,   2.018083560857055e-05,  -1.851635419336531e-07,   1.431137409054277e-09,
  -9.122598797643736e-12,   2.940889725681202e-14,   8.442936966497785e-17,  -4.665016063023642e-18,   1.295811486711563e-19,   1.794941120300535e-21,   4.726440157391217e-23,
  -2.024238437038000e-26,  -2.035138913956755e-26,   2.376681079911783e-01,  -3.521893936285932e-03,   3.579090839164564e-05,  -2.773113722612035e-07,   1.396420799303648e-09,
   3.664387721590663e-13,  -1.315884669009813e-13,   1.611797840244188e-15,  -1.493955542706145e-17,   1.924226245129758e-19,   5.423261977591165e-21,   7.787166684640819e-23,
   2.785486640319755e-25,  -4.247589135033109e-26,   2.376714649569500e-01,  -3.521971928646204e-03,   3.579169282945435e-05,  -2.773110019469932e-07,   1.396235295954153e-09,
   3.696225060765796e-13,  -1.316272096656824e-13,   1.612457365939479e-15,  -1.491663497806143e-17,   1.928119546732857e-19,   5.424600254226117e-21,   7.755862524751248e-23,
   2.702084647173564e-25,  -4.252075093638238e-26,   2.376773884356187e-01,  -3.522109547305601e-03,   3.579307689738839e-05,  -2.773103460918718e-07,   1.395907928263039e-09,
   3.752413153366478e-13,  -1.316955229452786e-13,   1.613622168723400e-15,  -1.487618723245242e-17,   1.934976191256612e-19,   5.426919908904214e-21,   7.700599813145735e-23,
   2.555100936435955e-25,  -4.259943027377444e-26,   2.376845512711958e-01,  -3.522275957109795e-03,   3.579475038231317e-05,  -2.773095488811612e-07,   1.395511996575724e-09,
   3.820374492254638e-13,  -1.317780446432772e-13,   1.615032464449017e-15,  -1.482727023275785e-17,   1.943244894286598e-19,   5.429653725652897e-21,   7.633731363171922e-23,
   2.377674244471532e-25,  -4.269375950937607e-26,   2.376915049346695e-01,  -3.522437504710503e-03,   3.579637482085000e-05,  -2.773087706228603e-07,   1.395127554271042e-09,
   3.886369149325169e-13,  -1.318580678842402e-13,   1.616403440843424e-15,  -1.477977508981213e-17,   1.951248515659687e-19,   5.432233255579209e-21,   7.568770601548220e-23,
   2.205753519858614e-25,  -4.278448524100551e-26,   2.376971067919715e-01,  -3.522567645244248e-03,   3.579768333873436e-05,  -2.773081405580382e-07,   1.394817796213021e-09,
   3.939547186060035e-13,  -1.319224709431262e-13,   1.617509230480917e-15,  -1.474150843016200e-17,   1.957679290146623e-19,   5.434258031241903e-21,   7.516406251181344e-23,
   2.067487115758067e-25,  -4.285696653617310e-26,   2.377008084369079e-01,  -3.522653639735355e-03,   3.579854793082652e-05,  -2.773077226994594e-07,   1.394613086036278e-09,
   3.974692948129878e-13,  -1.319649966730155e-13,   1.618240576124597e-15,  -1.471621999736870e-17,   1.961920383989501e-19,   5.435569911922152e-21,   7.481788828663594e-23,
   1.976236076766753e-25,  -4.290456449927005e-26,   2.377027094202735e-01,  -3.522697802004118e-03,   3.579899192377665e-05,  -2.773075076380500e-07,   1.394507949042140e-09,
   3.992744040016113e-13,  -1.319868261864958e-13,   1.618616360886577e-15,  -1.470323240973334e-17,   1.964095837465393e-19,   5.436235572477310e-21,   7.464006194825842e-23,
   1.929409225412667e-25,  -4.292891675887586e-26,   2.377033710767851e-01,  -3.522713173083460e-03,   3.579914645696861e-05,  -2.773074327089637e-07,   1.394471353791849e-09,
   3.999027216110888e-13,  -1.319944226387307e-13,   1.618747188639364e-15,  -1.469871183942264e-17,   1.964852617774653e-19,   5.436465980117452e-21,   7.457816002573088e-23,
   1.913116270492929e-25,  -4.293737821529946e-26,   2.377034760726485e-01,  -3.522715612261928e-03,   3.579917097913351e-05,  -2.773074208151894e-07,   1.394465546565226e-09,
   4.000024285208795e-13,  -1.319956280194025e-13,   1.618767950740919e-15,  -1.469799448141837e-17,   1.964972689102749e-19,   5.436502481803044e-21,   7.456833667137425e-23,
   1.910531066859609e-25,  -4.293872024034757e-26,   3.944160047791448e-01,  -5.605773940512314e-03,   5.027473781146911e-05,  -2.700247956307904e-07,  -4.037913055682312e-10,
   2.748400082442528e-11,  -3.549029308024937e-13,   1.568496677305708e-15,   1.151470946912405e-17,  -1.519432574807163e-19,   1.288739487499590e-20,   1.475641631822640e-22,
  -1.722628908024733e-26,  -6.661263765161735e-26,   3.944207175649009e-01,  -5.605849793983321e-03,   5.027450786447140e-05,  -2.699990035409331e-07,  -4.042900143661504e-10,
   2.748708098868426e-11,  -3.548715826086090e-13,   1.568003128833060e-15,   1.156904795471996e-17,  -1.512015378704135e-19,   1.288657004567303e-20,   1.470725220155467e-22,
  -3.277524480541991e-26,  -6.669610072923396e-26,   3.944290333317712e-01,  -5.605983632726193e-03,   5.027410189139198e-05,  -2.699534906466541e-07,  -4.051699576174147e-10,
   2.749251520653816e-11,  -3.548161522810165e-13,   1.567134275866929e-15,   1.166492560971738e-17,  -1.498948275046023e-19,   1.288503677090840e-20,   1.462045287270438e-22,
  -6.017834551207928e-26,  -6.684251926986010e-26,   3.944390888156682e-01,  -5.606145461903695e-03,   5.027361059568562e-05,  -2.698984519689260e-07,  -4.062339324676765e-10,
   2.749908499232301e-11,  -3.547489276441938e-13,   1.566087091796539e-15,   1.178085581660195e-17,  -1.483182626854140e-19,   1.288305009177603e-20,   1.451541189468726e-22,
  -9.325773662737161e-26,  -6.701811718112308e-26,   3.944488504736804e-01,  -5.606302552332364e-03,   5.027313324726794e-05,  -2.698450171853859e-07,  -4.072667558656806e-10,
   2.750546143825163e-11,  -3.546834601162119e-13,   1.565074103324499e-15,   1.189339225738559e-17,  -1.467914521795994e-19,   1.288098271868390e-20,   1.441335418637881e-22,
  -1.253112386932670e-25,  -6.718706577689209e-26,   3.944567143157123e-01,  -5.606429094789814e-03,   5.027274840995045e-05,  -2.698019678183746e-07,  -4.080987383321280e-10,
   2.751059722737431e-11,  -3.546305720073793e-13,   1.564260628655860e-15,   1.198404525985168e-17,  -1.455641195444022e-19,   1.287921796658375e-20,   1.433107669813663e-22,
  -1.510905715684162e-25,  -6.732208224252414e-26,   3.944619105913116e-01,  -5.606512708095118e-03,   5.027249397351617e-05,  -2.697735200946705e-07,  -4.086484746597918e-10,
   2.751399038003589e-11,  -3.545955518681640e-13,   1.563724358790369e-15,   1.204394468823850e-17,  -1.447544160749149e-19,   1.287800326993616e-20,   1.427667939606388e-22,
  -1.681042639898901e-25,  -6.741076758999555e-26,   3.944645791240228e-01,  -5.606555646384997e-03,   5.027236326407444e-05,  -2.697589103731407e-07,  -4.089307834897552e-10,
   2.751573277637059e-11,  -3.545775448933809e-13,   1.563449347828764e-15,   1.207470513571944e-17,  -1.443389955276252e-19,   1.287736445017004e-20,   1.424873458826540e-22,
  -1.768351674030060e-25,  -6.745614766633396e-26,   3.944655079307226e-01,  -5.606570591268013e-03,   5.027231776242624e-05,  -2.697538252534585e-07,  -4.090290425358440e-10,
   2.751633920951996e-11,  -3.545712738256601e-13,   1.563353689691221e-15,   1.208541146651462e-17,  -1.441944684393188e-19,   1.287713971349435e-20,   1.423900668125270e-22,
  -1.798730128151901e-25,  -6.747191650816067e-26,   3.944656553195281e-01,  -5.606572962806484e-03,   5.027231054160760e-05,  -2.697530183115655e-07,  -4.090446348396737e-10,
   2.751643544097684e-11,  -3.545702785238517e-13,   1.563338513002462e-15,   1.208711040781905e-17,  -1.441715370116282e-19,   1.287710393745258e-20,   1.423746292708624e-22,
  -1.803550283625966e-25,  -6.747441756698469e-26,   5.915285811557144e-01,  -7.899246809012640e-03,   5.700131887758657e-05,  -6.446815187034653e-08,  -4.302853635524237e-09,
   5.394275983969043e-11,  -1.821959454272627e-13,  -5.348531026095560e-15,   8.393906482379464e-17,  -6.006966591234321e-20,   7.582410078340410e-21,   4.255228286846367e-22,
  -4.955848729141020e-25,  -1.280179076804739e-25,   5.915339201572637e-01,  -7.899264762847753e-03,   5.699889709711582e-05,  -6.441766918552866e-08,  -4.303107233553368e-09,
   5.393222773272178e-11,  -1.819749484482761e-13,  -5.348677672224273e-15,   8.397091526856112e-17,  -5.791241888276879e-20,   7.578288502453985e-21,   4.245772011288034e-22,
  -5.184360422108307e-25,  -1.281922865051896e-25,   5.915433407248755e-01,  -7.899296431144905e-03,   5.699462371195426e-05,  -6.432859972074981e-08,  -4.303554458350714e-09,
   5.391364345685521e-11,  -1.815849279095276e-13,  -5.348930539519873e-15,   8.402710081848055e-17,  -5.410989624893509e-20,   7.570901570571842e-21,   4.229076105433601e-22,
  -5.587025200458124e-25,  -1.284984336480709e-25,   5.915547318611001e-01,  -7.899334705134351e-03,   5.698945609223205e-05,  -6.422090965865024e-08,  -4.304094816060590e-09,
   5.389117080465679e-11,  -1.811131951671290e-13,  -5.349226270303649e-15,   8.409501503789770e-17,  -4.951862360242565e-20,   7.561774432070695e-21,   4.208869978676867e-22,
  -6.072998065874911e-25,  -1.288659959625077e-25,   5.915657898493193e-01,  -7.899371840281090e-03,   5.698443925054865e-05,  -6.411638034282715e-08,  -4.304618934257695e-09,
   5.386935438746766e-11,  -1.806551240144157e-13,  -5.349502857379102e-15,   8.416091747274280e-17,  -4.506859748485687e-20,   7.552710231286635e-21,   4.189236227064735e-22,
  -6.543794600747526e-25,  -1.292200654823078e-25,   5.915746977846316e-01,  -7.899401741128236e-03,   5.698039760066732e-05,  -6.403218315448592e-08,  -4.305040833362153e-09,
   5.385177911660074e-11,  -1.802860210522434e-13,  -5.349718153519855e-15,   8.421398766321148e-17,  -4.148880537565054e-20,   7.545262424810737e-21,   4.173406696081380e-22,
  -6.922361951575456e-25,  -1.295033296883967e-25,   5.915805838739493e-01,  -7.899421491856703e-03,   5.697772687825168e-05,  -6.397655218041056e-08,  -4.305319458263532e-09,
   5.384016557117119e-11,  -1.800420818997745e-13,  -5.349856738683362e-15,   8.424904563263733e-17,  -3.912583627843343e-20,   7.540269725805115e-21,   4.162940561844525e-22,
  -7.172169737098029e-25,  -1.296895426180091e-25,   5.915836066266875e-01,  -7.899431632568468e-03,   5.697635531218766e-05,  -6.394798456835911e-08,  -4.305462496457006e-09,
   5.383420142343567e-11,  -1.799167943341976e-13,  -5.349926771706266e-15,   8.426704650526553e-17,  -3.791311002131796e-20,   7.537683693832069e-21,   4.157563769331982e-22,
  -7.300351995716907e-25,  -1.297848743354283e-25,   5.915846587177657e-01,  -7.899435161780681e-03,   5.697587792250676e-05,  -6.393804159692597e-08,  -4.305512274404922e-09,
   5.383212554143653e-11,  -1.798731847581104e-13,  -5.349950966366617e-15,   8.427331138290410e-17,  -3.749113237536292e-20,   7.536780093881146e-21,   4.155692020344335e-22,
  -7.344950131894146e-25,  -1.298180080708628e-25,   5.915848256698598e-01,  -7.899435721801181e-03,   5.697580216717051e-05,  -6.393646379604875e-08,  -4.305520173109156e-09,
   5.383179612728015e-11,  -1.798662644196977e-13,  -5.349954797135586e-15,   8.427430550936093e-17,  -3.742417616623609e-20,   7.536636538511093e-21,   4.155394984987118e-22,
  -7.352026440909059e-25,  -1.298232636913971e-25,   8.285591878634773e-01,  -1.006223558481157e-02,   4.659047513432527e-05,   4.010775244726206e-07,  -8.206076728320466e-09,
   1.881490463005633e-11,   9.430458430391687e-13,  -1.345466040267860e-14,  -3.252184682275545e-17,   3.058941762759115e-18,   9.868824424490765e-22,   2.164806243123680e-22,
   7.882366610322800e-24,  -2.174309877559894e-25,   8.285635464609815e-01,  -1.006212272067639e-02,   4.658586670466660e-05,   4.010949422480094e-07,  -8.204751580648927e-09,
   1.878858052802344e-11,   9.429605944290918e-13,  -1.344430926246268e-14,  -3.251620145637654e-17,   3.059995873537000e-18,   1.033333637528044e-21,   2.148850630720437e-22,
   7.832143005644272e-24,  -2.175357091878394e-25,   8.285712369246041e-01,  -1.006192356618700e-02,   4.657773566368434e-05,   4.011256561739514e-07,  -8.202413434114347e-09,
   1.874214781650974e-11,   9.428101848540330e-13,  -1.342604166577134e-14,  -3.250608283395357e-17,   3.061849174358107e-18,   1.115045895587713e-21,   2.120690775388174e-22,
   7.743616717944392e-24,  -2.177182638980542e-25,   8.285805357182270e-01,  -1.006168273972317e-02,   4.656790455470239e-05,   4.011627616666373e-07,  -8.199586288370421e-09,
   1.868602916009420e-11,   9.426283302778736e-13,  -1.340394745098639e-14,  -3.249357969371791e-17,   3.064078789640026e-18,   1.213424545214817e-21,   2.086629562940844e-22,
   7.636730149803153e-24,  -2.179352187179555e-25,   8.285895622008164e-01,  -1.006144894251988e-02,   4.655836176562063e-05,   4.011987473230872e-07,  -8.196841918068622e-09,
   1.863157975252022e-11,   9.424518126343586e-13,  -1.338249371562058e-14,  -3.248116239179674e-17,   3.066231304873443e-18,   1.308480333137829e-21,   2.053553155403211e-22,
   7.533134447910321e-24,  -2.181418717084426e-25,   8.285968333698126e-01,  -1.006126059349129e-02,   4.655067499358323e-05,   4.012277113191098e-07,  -8.194631213594032e-09,
   1.858773723798598e-11,   9.423096294520834e-13,  -1.336520725547793e-14,  -3.247095946542483e-17,   3.067956774760321e-18,   1.384734980934801e-21,   2.026899881014219e-22,
   7.449799414548366e-24,  -2.183055150076177e-25,   8.286016378094173e-01,  -1.006113613334089e-02,   4.654559609088072e-05,   4.012468376897976e-07,  -8.193170480438862e-09,
   1.855877727645042e-11,   9.422156858105789e-13,  -1.335378290761659e-14,  -3.246411998410787e-17,   3.069092738622382e-18,   1.434965612508262e-21,   2.009284305685158e-22,
   7.394792018073681e-24,  -2.184122624894047e-25,   8.286041050512090e-01,  -1.006107221633558e-02,   4.654298794863372e-05,   4.012566561244635e-07,  -8.192420342927721e-09,
   1.854390816428116e-11,   9.421674438933278e-13,  -1.334791541412188e-14,  -3.246057745450865e-17,   3.069674812673538e-18,   1.460712891512490e-21,   2.000236768879127e-22,
   7.366561305841483e-24,  -2.184666545740162e-25,   8.286049637865106e-01,  -1.006104996931511e-02,   4.654208017951527e-05,   4.012600729042201e-07,  -8.192159253699489e-09,
   1.853873334527988e-11,   9.421506532737260e-13,  -1.334587309272231e-14,  -3.245933965216394e-17,   3.069877202263551e-18,   1.469666740164465e-21,   1.997087516972385e-22,
   7.356738248202373e-24,  -2.184855181664208e-25,   8.286051000554636e-01,  -1.006104643901359e-02,   4.654193612994476e-05,   4.012606150708522e-07,  -8.192117822577267e-09,
   1.853791219706362e-11,   9.421479888536801e-13,  -1.334554900033619e-14,  -3.245914300254649e-17,   3.069909308895266e-18,   1.471087225822077e-21,   1.996587765825492e-22,
   7.355179601925841e-24,  -2.184885083280962e-25,   1.102482264225570e+00,  -1.149932251548490e-02,   8.407118616111722e-06,   9.899390489326587e-07,  -5.059886473631237e-09,
  -1.391087347768377e-10,   1.541489143446910e-12,   1.718578353746513e-14,  -4.425668574123522e-16,  -6.569483638696599e-19,   1.431254411392786e-19,   4.156741236468608e-22,
  -2.048688472419299e-23,  -6.296105136900033e-26,   1.102483046702537e+00,  -1.149904455397131e-02,   8.404284587557475e-06,   9.898089188994132e-07,  -5.057732331798807e-09,
  -1.390749345970243e-10,   1.540339780041469e-12,   1.718362157125031e-14,  -4.419671846167424e-16,  -6.548263556118853e-19,   1.429970449092460e-19,   4.151382147016315e-22,
  -2.052232442337389e-23,  -6.434032882071156e-26,   1.102484427180915e+00,  -1.149855411620611e-02,   8.399284881442828e-06,   9.895793281567915e-07,  -5.053932623777777e-09,
  -1.390152970803766e-10,   1.538312987469438e-12,   1.717981255440532e-14,  -4.409094943311816e-16,  -6.510843620138385e-19,   1.427703108145615e-19,   4.141844962712196e-22,
  -2.058473581485219e-23,  -6.676656507146785e-26,   1.102486096104363e+00,  -1.149796112425439e-02,   8.393240857122567e-06,   9.893017484787699e-07,  -5.049340207418487e-09,
  -1.389431886041596e-10,   1.535864345386255e-12,   1.717521654673492e-14,  -4.396312776497157e-16,  -6.465634879790459e-19,   1.424958402712658e-19,   4.130174713283733e-22,
  -2.065999550501994e-23,  -6.968759252487525e-26,   1.102487715883405e+00,  -1.149738551095065e-02,   8.387375175130467e-06,   9.890323249026882e-07,  -5.044884304305215e-09,
  -1.388731930575282e-10,   1.533489525102083e-12,   1.717076517953063e-14,  -4.383911968292219e-16,  -6.421789037821537e-19,   1.422290740872105e-19,   4.118701539245871e-22,
  -2.073283770971743e-23,  -7.250989305494331e-26,   1.102489020481998e+00,  -1.149692184234239e-02,   8.382651113072084e-06,   9.888153137095156e-07,  -5.041296358963430e-09,
  -1.388168099302670e-10,   1.531578033123002e-12,   1.716718663305298e-14,  -4.373927701126414e-16,  -6.386497712354455e-19,   1.420139454501092e-19,   4.109356070572409e-22,
  -2.079136187753035e-23,  -7.477393097227156e-26,   1.102489882403204e+00,  -1.149661547698228e-02,   8.379530151389067e-06,   9.886719327046495e-07,  -5.038926327018458e-09,
  -1.387795551039316e-10,   1.530315752285821e-12,   1.716482562323587e-14,  -4.367333049330657e-16,  -6.363192759452655e-19,   1.418716821346885e-19,   4.103130513874574e-22,
  -2.082995697132235e-23,  -7.626528798001383e-26,   1.102490324999453e+00,  -1.149645814946158e-02,   8.377927578200032e-06,   9.885983046849944e-07,  -5.037709455239551e-09,
  -1.387604236292700e-10,   1.529667757729244e-12,   1.716361425396804e-14,  -4.363947238321053e-16,  -6.351229184883714e-19,   1.417985890846020e-19,   4.099917879703788e-22,
  -2.084975370426792e-23,  -7.702972568626012e-26,   1.102490479042519e+00,  -1.149640339109274e-02,   8.377369818165979e-06,   9.885726785723933e-07,  -5.037285952148451e-09,
  -1.387537648495399e-10,   1.529442256616099e-12,   1.716319280443236e-14,  -4.362768912452599e-16,  -6.347065892489975e-19,   1.417731429643429e-19,   4.098797225370382e-22,
  -2.085664036674726e-23,  -7.729556524405480e-26,   1.102490503486719e+00,  -1.149639470173721e-02,   8.377281310765726e-06,   9.885686120989413e-07,  -5.037218749952340e-09,
  -1.387527081978975e-10,   1.529406474561961e-12,   1.716312593467493e-14,  -4.362581934853713e-16,  -6.346405270453545e-19,   1.417691047585076e-19,   4.098619275859226e-22,
  -2.085773300619183e-23,  -7.733773940520220e-26,   1.403312120274814e+00,  -1.122158563140114e-02,  -5.924871128615405e-05,   1.028566763793005e-06,   1.294771943965205e-08,
  -1.827264685752722e-10,  -3.572288947017765e-12,   3.600980721744678e-14,   1.010579534646962e-15,  -7.645298166876294e-18,  -2.650657631222910e-19,   3.379536840120923e-21,
   1.150977173227610e-22,  -8.987392733419892e-25,   1.403306580282169e+00,  -1.122129694874462e-02,  -5.924145637201187e-05,   1.028396050345311e-06,   1.294272698762553e-08,
  -1.826559767323170e-10,  -3.569658751137771e-12,   3.598445089861908e-14,   1.009483444667798e-15,  -7.628130142169546e-18,  -2.643736386073711e-19,   3.372921013183015e-21,
   1.146634441084211e-22,  -8.995514112545563e-25,   1.403296805427455e+00,  -1.122078760258001e-02,  -5.922865723749460e-05,   1.028094877381328e-06,   1.293392072556544e-08,
  -1.825316331303821e-10,  -3.565020054877684e-12,   3.593975619195187e-14,   1.007551732948314e-15,  -7.597864669937063e-18,  -2.631545452312845e-19,   3.361242623192232e-21,
   1.138983713569493e-22,  -9.009718733330797e-25,   1.403284986505456e+00,  -1.122017176211638e-02,  -5.921318426646587e-05,   1.027730787187002e-06,   1.292327720955528e-08,
  -1.823813442909208e-10,  -3.559414855964395e-12,   3.588579081990633e-14,   1.005219899090751e-15,  -7.561314713504253e-18,  -2.616841024522241e-19,   3.347113095593624e-21,
   1.129752966199194e-22,  -9.026681290045781e-25,   1.403273513881379e+00,  -1.121957398433608e-02,  -5.919816743507551e-05,   1.027377430385464e-06,   1.291295001745390e-08,
  -1.822355184396092e-10,  -3.553977570659318e-12,   3.583348582158231e-14,   1.002960390615411e-15,  -7.525882276775368e-18,  -2.602604892258062e-19,   3.333388193382487e-21,
   1.120813452756591e-22,  -9.042924936446049e-25,   1.403264272387260e+00,  -1.121909247210575e-02,  -5.918607297987565e-05,   1.027092839260169e-06,   1.290463439670845e-08,
  -1.821180945378204e-10,  -3.549600330965778e-12,   3.579140948354728e-14,   1.001143161447515e-15,  -7.497373936700928e-18,  -2.591164120092056e-19,   3.322325759929418e-21,
   1.113627306830745e-22,  -9.055851030082581e-25,   1.403258166116566e+00,  -1.121877432177016e-02,  -5.917808260325936e-05,   1.026904820055373e-06,   1.289914145771565e-08,
  -1.820405281162512e-10,  -3.546709380258286e-12,   3.576363549290476e-14,   9.999438365480330e-16,  -7.478553554226964e-18,  -2.583617795000060e-19,   3.315013064458943e-21,
   1.108886366283086e-22,  -9.064314400474746e-25,   1.403255030360763e+00,  -1.121861094388540e-02,  -5.917397960283090e-05,   1.026808273568562e-06,   1.289632115045455e-08,
  -1.820007018370085e-10,  -3.545225187308113e-12,   3.574938127824850e-14,   9.993283793534895e-16,  -7.468893775840222e-18,  -2.579746578095879e-19,   3.311256772125017e-21,
   1.106453995458358e-22,  -9.068636672048453e-25,   1.403253938949173e+00,  -1.121855407991604e-02,  -5.917255158604588e-05,   1.026774671330653e-06,   1.289533960896755e-08,
  -1.819868411755705e-10,  -3.544708671748636e-12,   3.574442141006253e-14,   9.991142360079698e-16,  -7.465532459461781e-18,  -2.578399831113291e-19,   3.309949221494514e-21,
   1.105607757137241e-22,  -9.070137248862225e-25,   1.403253765757989e+00,  -1.121854505644420e-02,  -5.917232498277627e-05,   1.026769339196649e-06,   1.289518385623230e-08,
  -1.819846417383414e-10,  -3.544626711231498e-12,   3.574363441572772e-14,   9.990802578335775e-16,  -7.464999105576865e-18,  -2.578186152503162e-19,   3.309741724640556e-21,
   1.105473488361568e-22,  -9.070375188008016e-25,   1.703085817411814e+00,  -7.995960454137583e-03,  -1.144722806356596e-04,  -4.853438320209613e-07,   1.733899363714648e-08,
   3.741486442471703e-10,   2.740856151275241e-13,  -1.201513100805873e-13,  -1.992693871376533e-15,   1.264479747168785e-17,   9.991115568041396e-19,   1.290762803711651e-20,
  -1.529174306496907e-22,  -7.575685267293146e-24,   1.703075105239102e+00,  -7.996095728735683e-03,  -1.144625256708273e-04,  -4.849950505160029e-07,   1.733931836508208e-08,
   3.739128059508241e-10,   2.689411100222823e-13,  -1.201069625950741e-13,  -1.988510317607728e-15,   1.270923510213632e-17,   9.981379693159058e-19,   1.285308137700855e-20,
  -1.535148428295389e-22,  -7.560309938569445e-24,   1.703056204185261e+00,  -7.996334343488820e-03,  -1.144453127474106e-04,  -4.843797995880886e-07,   1.733988550492171e-08,
   3.734967373628028e-10,   2.598724588185377e-13,  -1.200285355022868e-13,  -1.981131734248315e-15,   1.282270852736242e-17,   9.964170976123574e-19,   1.275692468214662e-20,
  -1.545649997889143e-22,  -7.533154616918234e-24,   1.703033350096616e+00,  -7.996622743636630e-03,  -1.144244984689711e-04,  -4.836361376586305e-07,   1.734056133260329e-08,
   3.729937453896118e-10,   2.489217345114610e-13,  -1.199334022230285e-13,  -1.972215213636866e-15,   1.295953367297941e-17,   9.943311656355763e-19,   1.264080751291906e-20,
  -1.558280734781962e-22,  -7.500275267678254e-24,   1.703011165070395e+00,  -7.996902575794827e-03,  -1.144042920918046e-04,  -4.829145239913991e-07,   1.734120698923099e-08,
   3.725055781269306e-10,   2.383068568378578e-13,  -1.198407365445864e-13,  -1.963565230703769e-15,   1.309195504421554e-17,   9.923009232611346e-19,   1.252824702328313e-20,
  -1.570471480888997e-22,  -7.468312100228713e-24,   1.702993294052875e+00,  -7.997127903430741e-03,  -1.143880139297024e-04,  -4.823334309802317e-07,   1.734171965846339e-08,
   3.721124092684154e-10,   2.297670343482219e-13,  -1.197658631605142e-13,  -1.956601237091471e-15,   1.319834123887144e-17,   9.906616329785025e-19,   1.243768738617288e-20,
  -1.580241434384172e-22,  -7.442531412181083e-24,   1.702981485668540e+00,  -7.997276746225893e-03,  -1.143772575288483e-04,  -4.819495674623496e-07,   1.734205476943088e-08,
   3.718526555718591e-10,   2.241296443399702e-13,  -1.197162790721515e-13,  -1.952001671918459e-15,   1.326849708308915e-17,   9.895765863347764e-19,   1.237790482172050e-20,
  -1.586672430172559e-22,  -7.425480646160114e-24,   1.702975421642190e+00,  -7.997353168757347e-03,  -1.143717335773255e-04,  -4.817524699340668e-07,   1.734222573615476e-08,
   3.717192736382238e-10,   2.212362978140194e-13,  -1.196907815661616e-13,  -1.949640230583116e-15,   1.330448149179005e-17,   9.890187972009518e-19,   1.234722144477163e-20,
  -1.589967387192806e-22,  -7.416719540099215e-24,   1.702973311025214e+00,  -7.997379765873227e-03,  -1.143698109114422e-04,  -4.816838738672190e-07,   1.734228506303130e-08,
   3.716728510677890e-10,   2.202295163261898e-13,  -1.196819015628987e-13,  -1.948818413698449e-15,   1.331699919585308e-17,   9.888245636081269e-19,   1.233654465373360e-20,
  -1.591113007212917e-22,  -7.413669407330600e-24,   1.702972976100457e+00,  -7.997383986353097e-03,  -1.143695058106577e-04,  -4.816729888787878e-07,   1.734229446886159e-08,
   3.716654845512396e-10,   2.200697669893616e-13,  -1.196804921741478e-13,  -1.948688007634149e-15,   1.331898525086631e-17,   9.887937371423816e-19,   1.233485052884359e-20,
  -1.591294743430843e-22,  -7.413185357726230e-24,   1.934361117070267e+00,  -2.330547648500507e-03,  -5.815867856197759e-05,  -1.174442872981271e-06,  -1.919431917042483e-08,
  -2.255768385493550e-10,  -6.627879124292835e-13,   5.690121866043485e-14,   2.005008090483300e-15,   4.168936754994995e-17,   5.548580754068541e-19,   1.687642039992386e-21,
  -1.539720597607146e-22,  -5.344629996931120e-24,   1.934355643021038e+00,  -2.330878701199635e-03,  -5.816948021709187e-05,  -1.174653387912548e-06,  -1.919518833602946e-08,
  -2.254625732033439e-10,  -6.574771961702568e-13,   5.704210021805084e-14,   2.007316688661155e-15,   4.169651764128937e-17,   5.538630548815380e-19,   1.647867226167016e-21,
  -1.548854022813236e-22,  -5.357245989114575e-24,   1.934345983151053e+00,  -2.331462896871512e-03,  -5.818854029039442e-05,  -1.175024757043263e-06,  -1.919671590208336e-08,
  -2.252607246186028e-10,  -6.481014464311207e-13,   5.729070642190676e-14,   2.011386796531431e-15,   4.170896664605705e-17,   5.521027312005681e-19,   1.577609588058800e-21,
  -1.564969927914138e-22,  -5.379459008710640e-24,   1.934334300928043e+00,  -2.332169394309434e-03,  -5.821158858568654e-05,  -1.175473670778707e-06,  -1.919855266293029e-08,
  -2.250162624942462e-10,  -6.367558273034917e-13,   5.759135489284289e-14,   2.016302521242055e-15,   4.172373439744008e-17,   5.499662954260317e-19,   1.492526720329511e-21,
  -1.584457076711801e-22,  -5.406236971726118e-24,   1.934322958556824e+00,  -2.332855335424273e-03,  -5.823396415107569e-05,  -1.175909311458343e-06,  -1.920032487510563e-08,
  -2.247785400598904e-10,  -6.257329461479149e-13,   5.788325148634391e-14,   2.021068436612453e-15,   4.173777120274201e-17,   5.478840774773998e-19,   1.409797443501400e-21,
  -1.603374354285568e-22,  -5.432146098751386e-24,   1.934313820235842e+00,  -2.333407982008417e-03,  -5.825199010055771e-05,  -1.176260145325818e-06,  -1.920174474478302e-08,
  -2.245867453106938e-10,  -6.168467913138808e-13,   5.811842241768288e-14,   2.024903354754294e-15,   4.174886430914208e-17,   5.462007924224512e-19,   1.343057198951356e-21,
  -1.618613420720392e-22,  -5.452955986023867e-24,   1.934307781279945e+00,  -2.333773191056034e-03,  -5.826390156362410e-05,  -1.176491914921480e-06,  -1.920267914820783e-08,
  -2.244598694207337e-10,  -6.109719127816290e-13,   5.827383024388710e-14,   2.027435221847268e-15,   4.175608920646023e-17,   5.450856299916603e-19,   1.298910180557802e-21,
  -1.628682872838710e-22,  -5.466676259395976e-24,   1.934304679827501e+00,  -2.333960752662533e-03,  -5.827001874292619e-05,  -1.176610922626406e-06,  -1.920315782704979e-08,
  -2.243946688694121e-10,  -6.079539338459457e-13,   5.835364299586406e-14,   2.028734782188739e-15,   4.175976697728055e-17,   5.445120507967689e-19,   1.276224285297475e-21,
  -1.633853933496995e-22,  -5.473712815563859e-24,   1.934303600313162e+00,  -2.334026036675549e-03,  -5.827214789482212e-05,  -1.176652341629214e-06,  -1.920332424739783e-08,
  -2.243719682614508e-10,  -6.069033477985760e-13,   5.838142309375699e-14,   2.029186998601992e-15,   4.176104187409777e-17,   5.443122696287277e-19,   1.268325978255010e-21,
  -1.635653754386442e-22,  -5.476160445512495e-24,   1.934303429007897e+00,  -2.334036396419483e-03,  -5.827248576245622e-05,  -1.176658914125444e-06,  -1.920335064707977e-08,
  -2.243683656572370e-10,  -6.067366271015702e-13,   5.838583143822673e-14,   2.029258754015546e-15,   4.176124393648628e-17,   5.442805603829655e-19,   1.267072517804592e-21,
  -1.635939360490695e-22,  -5.476548779058221e-24,   4.530349996109814e-03,  -6.861301042833758e-05,   7.769705684370806e-07,  -7.835365078552152e-09,   7.315695148411711e-11,
  -6.730632124613049e-13,   5.571270547306442e-15,  -4.936526651174381e-17,   5.863039684059696e-19,   4.089608690163640e-21,   4.530460690481329e-03,  -6.861635890690068e-05,
   7.770331006207147e-07,  -7.836324139381459e-09,   7.316887203131861e-11,  -6.732104033809906e-13,   5.573629653779798e-15,  -4.934430847545510e-17,   5.874109569418542e-19,
   4.089961161228361e-21,   4.530642419655426e-03,  -6.862185627278367e-05,   7.771357646892443e-07,  -7.837898744254205e-09,   7.318844519134239e-11,  -6.734519958329607e-13,
   5.577505680990319e-15,  -4.930990197566568e-17,   5.892254500511889e-19,   4.090431856223622e-21,   4.530835257119767e-03,  -6.862768980575107e-05,   7.772447092172479e-07,
  -7.839569727342167e-09,   7.320921879381631e-11,  -6.737082825797858e-13,   5.581622752208508e-15,  -4.927339357127272e-17,   5.911469490738885e-19,   4.090784723363534e-21,
   4.530987027564267e-03,  -6.863228111857711e-05,   7.773304563866629e-07,  -7.840884948669534e-09,   7.322557132644157e-11,  -6.739099370566441e-13,   5.584866023631698e-15,
  -4.924466111201705e-17,   5.926564123386233e-19,   4.090956406313466e-21,   4.531074619799798e-03,  -6.863493097193560e-05,   7.773799456627305e-07,  -7.841644048278718e-09,
   7.323501013586439e-11,  -6.740262979448752e-13,   5.586739026383662e-15,  -4.922807904308536e-17,   5.935264434950352e-19,   4.091013020678670e-21,   4.531107512036151e-03,
  -6.863592604032653e-05,   7.773985299276672e-07,  -7.841929109006517e-09,   7.323855477550143e-11,  -6.740699892409834e-13,   5.587442593175542e-15,  -4.922185231712365e-17,
   5.938529390423814e-19,   4.091026257114773e-21,   4.531112964420508e-03,  -6.863609098832168e-05,   7.774016105645894e-07,  -7.841976362497294e-09,   7.323914236465401e-11,
  -6.740772315206810e-13,   5.587559231869378e-15,  -4.922082014863833e-17,   5.939070492828330e-19,   4.091028028099713e-21,   4.083970232757765e-02,  -6.143858220768059e-04,
   6.836025187994133e-06,  -6.669605604253136e-08,   5.890637846900025e-10,  -5.005511375501554e-12,   3.591910693182093e-14,  -2.696686871487360e-16,   3.290900221377376e-18,
   5.936737666822513e-20,   4.084067615652139e-02,  -6.144143212839661e-04,   6.836528592011604e-06,  -6.670318601155357e-08,   5.891406161378229e-10,  -5.006312398117129e-12,
   3.593239937973336e-14,  -2.693640060662742e-16,   3.299575787214492e-18,   5.938834961399822e-20,   4.084227490623611e-02,  -6.144611095479970e-04,   6.837355058669810e-06,
  -6.671489183186841e-08,   5.892667680015325e-10,  -5.007626747974925e-12,   3.595424591831952e-14,  -2.688637524533652e-16,   3.313791609767091e-18,   5.942180386959061e-20,
   4.084397137379167e-02,  -6.145107585069146e-04,   6.838232068226887e-06,  -6.672731372912445e-08,   5.894006529080715e-10,  -5.009020479856644e-12,   3.597746049398924e-14,
  -2.683328511327829e-16,   3.328839626475668e-18,   5.945597581439922e-20,   4.084530655375230e-02,  -6.145498346668220e-04,   6.838922326104219e-06,  -6.673709063613266e-08,
   5.895060413435293e-10,  -5.010116706178297e-12,   3.599575486086767e-14,  -2.679149628076666e-16,   3.340656361216638e-18,   5.948191046040960e-20,   4.084607713269253e-02,
  -6.145723871520402e-04,   6.839320706163467e-06,  -6.674273340437908e-08,   5.895668712173235e-10,  -5.010749100057165e-12,   3.600632265711339e-14,  -2.676737652602855e-16,
   3.347465548398688e-18,   5.949649379885090e-20,   4.084636649661749e-02,  -6.145808559987969e-04,   6.839470305379578e-06,  -6.674485238120063e-08,   5.895897149803123e-10,
  -5.010986521146060e-12,   3.601029281302137e-14,  -2.675831883249492e-16,   3.350020484078574e-18,   5.950189743355430e-20,   4.084641446303412e-02,  -6.145822598400356e-04,
   6.839495103777862e-06,  -6.674520363516945e-08,   5.895935017422918e-10,  -5.011025874499579e-12,   3.601095102040351e-14,  -2.675681736466302e-16,   3.350443896671470e-18,
   5.950278933669190e-20,   1.138108747851043e-01,  -1.688132723721764e-03,   1.808297609139538e-05,  -1.636036545696963e-07,   1.255419503794263e-09,  -8.400934597538977e-12,
   3.045794039131356e-14,   1.911221539271200e-17,   1.608086267447389e-18,   2.373410992675799e-19,   1.138134502818222e-01,  -1.688202611961626e-03,   1.808404839278072e-05,
  -1.636156090523714e-07,   1.255484601710658e-09,  -8.400858011080172e-12,   3.046479662374089e-14,   2.033034857206301e-17,   1.629778324921197e-18,   2.374264392278115e-19,
   1.138176784869893e-01,  -1.688317348510334e-03,   1.808580878930261e-05,  -1.636352341841200e-07,   1.255591481295498e-09,  -8.400729649441593e-12,   3.047611427570054e-14,
   2.233040613723283e-17,   1.665313275897389e-18,   2.375637226187248e-19,   1.138221650896396e-01,  -1.688439097874789e-03,   1.808767676079242e-05,  -1.636560578470195e-07,
   1.255704903553032e-09,  -8.400589869590759e-12,   3.048820737210822e-14,   2.445301675873546e-17,   1.702915151351696e-18,   2.377055671329135e-19,   1.138256961782415e-01,
  -1.688534918898047e-03,   1.808914690379629e-05,  -1.636724460920744e-07,   1.255794178191718e-09,  -8.400477271110110e-12,   3.049778556595904e-14,   2.612380395536532e-17,
   1.732433069964172e-18,   2.378144336347524e-19,   1.138277340821117e-01,  -1.688590220540861e-03,   1.808999536795677e-05,  -1.636819040334736e-07,   1.255845704644437e-09,
  -8.400411249636337e-12,   3.050333769484958e-14,   2.708815927576545e-17,   1.749438375448109e-18,   2.378761547913976e-19,   1.138284993435188e-01,  -1.688610987132960e-03,
   1.809031397768868e-05,  -1.636854555778032e-07,   1.255865054156620e-09,  -8.400386261583192e-12,   3.050542717616155e-14,   2.745030516035500e-17,   1.755818352612135e-18,
   2.378991224115135e-19,   1.138286261969854e-01,  -1.688614429507372e-03,   1.809036679197066e-05,  -1.636860442967565e-07,   1.255868261658359e-09,  -8.400382109098008e-12,
   3.050577378026725e-14,   2.751033712122814e-17,   1.756875625235690e-18,   2.379029185849536e-19,   2.241328701179799e-01,  -3.248503514968287e-03,   3.259701061131882e-05,
  -2.550672859375058e-07,   1.375568421206425e-09,  -2.295891547914228e-12,  -9.177340519130481e-14,   1.293102211740555e-15,  -3.314858536419764e-18,   4.717770811104268e-19,
   2.241375112717379e-01,  -3.248612420233907e-03,   3.259818402145556e-05,  -2.550705201710653e-07,   1.375372377857319e-09,  -2.291988515180018e-12,  -9.178556201812653e-14,
   1.295520973095176e-15,  -3.264041740344224e-18,   4.718503596915300e-19,   2.241451305975105e-01,  -3.248791206848492e-03,   3.260011024312798e-05,  -2.550758256583668e-07,
   1.375050522763959e-09,  -2.285575829468633e-12,  -9.180537392312336e-14,   1.299491988273175e-15,  -3.180767251021917e-18,   4.719647629587317e-19,   2.241532154551751e-01,
  -3.248980914618037e-03,   3.260215394878612e-05,  -2.550814497096819e-07,   1.374708985009417e-09,  -2.278764371707307e-12,  -9.182619838386833e-14,   1.303705838802304e-15,
  -3.092609908696346e-18,   4.720781483441717e-19,   2.241595783994845e-01,  -3.249130216609104e-03,   3.260376223683796e-05,  -2.550858718970726e-07,   1.374440175268642e-09,
  -2.273398575982195e-12,  -9.184244453315514e-14,   1.307022366611897e-15,  -3.023376938074807e-18,   4.721615926665697e-19,   2.241632506267067e-01,  -3.249216382100165e-03,
   3.260469036360321e-05,  -2.550884224355308e-07,   1.374285032834071e-09,  -2.270299808844232e-12,  -9.185176331919693e-14,   1.308936478870483e-15,  -2.983480325530107e-18,
   4.722074306807064e-19,   2.241646295935488e-01,  -3.249248738173049e-03,   3.260503887541328e-05,  -2.550893798870206e-07,   1.374226773973350e-09,  -2.269135801317898e-12,
  -9.185525181486403e-14,   1.309655261660807e-15,  -2.968509923321309e-18,   4.722242051478273e-19,   2.241648581775161e-01,  -3.249254101659179e-03,   3.260509664575849e-05,
  -2.550895385824251e-07,   1.374217116663008e-09,  -2.268942829852998e-12,  -9.185582951332309e-14,   1.309774410958234e-15,  -2.966028954374597e-18,   4.722269626460675e-19,
   3.727770012423058e-01,  -5.216613808270836e-03,   4.701236164109863e-05,  -2.725338158357501e-07,   6.444565770018133e-11,   1.953407465197708e-11,  -3.058652530026565e-13,
   1.961116098605825e-15,   1.677581203608116e-17,   4.767867768833955e-19,   3.727836915499076e-01,  -5.216730060568010e-03,   4.701241297350161e-05,  -2.725059675647355e-07,
   6.379357926552866e-11,   1.953997442554570e-11,  -3.057961083810073e-13,   1.963560640257412e-15,   1.688688937594621e-17,   4.768684653988527e-19,   3.727946747776261e-01,
  -5.216920898929129e-03,   4.701249684178773e-05,  -2.724602440348130e-07,   6.272319485161306e-11,   1.954966514025861e-11,  -3.056822779590455e-13,   1.967573976439944e-15,
   1.706896700612431e-17,   4.769923472867798e-19,   3.728063288379625e-01,  -5.217123381492708e-03,   4.701258528598623e-05,  -2.724117195609969e-07,   6.158758112882896e-11,
   1.955995491592174e-11,  -3.055610628716927e-13,   1.971832721974116e-15,   1.726179306813046e-17,   4.771099142845346e-19,   3.728155006496442e-01,  -5.217282727871843e-03,
   4.701265449635696e-05,  -2.723735245516059e-07,   6.069395370827438e-11,   1.956805822095632e-11,  -3.054653533678487e-13,   1.975184567642421e-15,   1.741327837886628e-17,
   4.771923996989616e-19,   3.728207938834980e-01,  -5.217374686390768e-03,   4.701269428041716e-05,  -2.723514790615260e-07,   6.017826662800101e-11,   1.957273688022131e-11,
  -3.054099923509016e-13,   1.977119054350807e-15,   1.750059529273846e-17,   4.772359822301669e-19,   3.728227815458197e-01,  -5.217409217087823e-03,   4.701270918975178e-05,
  -2.723432003064447e-07,   5.998462909524770e-11,   1.957449415710370e-11,  -3.053891800895245e-13,   1.977845486134413e-15,   1.753336319932021e-17,   4.772515882061020e-19,
   3.728231110293202e-01,  -5.217414941011295e-03,   4.701271165960608e-05,  -2.723418279603191e-07,   5.995253132969646e-11,   1.957478547167530e-11,  -3.053857289120341e-13,
   1.977965903259623e-15,   1.753879386916893e-17,   4.772541350520861e-19,   5.608375512453161e-01,  -7.447423442763443e-03,   5.584919887281810e-05,  -1.249627176672755e-07,
  -3.278315284719094e-09,   4.807707970797261e-11,  -2.940350047264982e-13,  -2.603347732337604e-15,   9.147936858419553e-17,   5.808268905187897e-19,   5.608454933604092e-01,
  -7.447476550633408e-03,   5.584639617351821e-05,  -1.248943656868129e-07,  -3.278938565853237e-09,   4.806934787092835e-11,  -2.936675622312770e-13,  -2.600338867554249e-15,
   9.162119281021504e-17,   5.820816965999696e-19,   5.608585313392501e-01,  -7.447563714723346e-03,   5.584179470562114e-05,  -1.247821627779744e-07,  -3.279961214267885e-09,
   4.805666132917581e-11,  -2.930639402840284e-13,  -2.595394812490491e-15,   9.185352401844204e-17,   5.841244453611005e-19,   5.608723652504959e-01,  -7.447656173920288e-03,
   5.583691167163586e-05,  -1.246631175920993e-07,  -3.281045550377375e-09,   4.804320879442824e-11,  -2.924229002500976e-13,  -2.590142684457626e-15,   9.209937060016550e-17,
   5.862685786464410e-19,   5.608832523275299e-01,  -7.447728919059642e-03,   5.583306832122423e-05,  -1.245694362017260e-07,  -3.281898368726306e-09,   4.803262800264481e-11,
  -2.919180004175169e-13,  -2.586004840403056e-15,   9.229236427983909e-17,   5.879391103025512e-19,   5.608895353588074e-01,  -7.447770893390981e-03,   5.583085009747365e-05,
  -1.245153739637012e-07,  -3.282390322360857e-09,   4.802652419711438e-11,  -2.916264535331948e-13,  -2.583615058293574e-15,   9.240354864105204e-17,   5.888964326865266e-19,
   5.608918946780258e-01,  -7.447786653598949e-03,   5.583001710384888e-05,  -1.244950736461333e-07,  -3.282575013397117e-09,   4.802423264455174e-11,  -2.915169446904552e-13,
  -2.582717341389187e-15,   9.244526240390882e-17,   5.892546370127363e-19,   5.608922857678226e-01,  -7.447789265996140e-03,   5.582987902172636e-05,  -1.244917086090657e-07,
  -3.282605626340560e-09,   4.802385281261483e-11,  -2.914987904455702e-13,  -2.582568514581955e-15,   9.245217510126254e-17,   5.893139470099207e-19,   7.890834170079669e-01,
  -9.672450531155260e-03,   5.063135773078251e-05,   2.738940323435413e-07,  -7.634077439558515e-09,   3.691040695768981e-11,   5.685026532843861e-13,  -1.270169621462467e-14,
   8.124905930912957e-17,   3.347241410156382e-18,   7.890906091280132e-01,  -9.672333415372285e-03,   5.062484631846387e-05,   2.739462406499364e-07,  -7.632860039917013e-09,
   3.687272313364147e-11,   5.688280796129258e-13,  -1.268451567110773e-14,   8.133055815102937e-17,   3.348478839659212e-18,   7.891024154887724e-01,  -9.672141134818808e-03,
   5.061415753354696e-05,   2.740319103906962e-07,  -7.630860978340884e-09,   3.681089616639055e-11,   5.693625513168585e-13,  -1.265630668623744e-14,   8.146382678190909e-17,
   3.350478388353788e-18,   7.891149420418766e-01,  -9.671937088494289e-03,   5.060281692908848e-05,   2.741227601081441e-07,  -7.628739135626626e-09,   3.674534344154597e-11,
   5.699299811978526e-13,  -1.262636893625729e-14,   8.160452097261789e-17,   3.352556759663681e-18,   7.891247998475122e-01,  -9.671776487188420e-03,   5.059389255419624e-05,
   2.741942213191172e-07,  -7.627068738958071e-09,   3.669378964521501e-11,   5.703767782555930e-13,  -1.260280359442922e-14,   8.171473041881106e-17,   3.354161126398000e-18,
   7.891304887163688e-01,  -9.671683794712078e-03,   5.058874241977091e-05,   2.742354477568626e-07,  -7.626104521784503e-09,   3.666405159060856e-11,   5.706347242555479e-13,
  -1.258920191789233e-14,   8.177812676864916e-17,   3.355074492501739e-18,   7.891326248933839e-01,  -9.671648986570710e-03,   5.058680854919205e-05,   2.742509258172439e-07,
  -7.625742411105661e-09,   3.665288742442565e-11,   5.707316026575288e-13,  -1.258409404190296e-14,   8.180189345296907e-17,   3.355415100582944e-18,   7.891329789926732e-01,
  -9.671643216560017e-03,   5.058648798542280e-05,   2.742534913755457e-07,  -7.625682384096812e-09,   3.665103695016207e-11,   5.707476625415669e-13,  -1.258324732197622e-14,
   8.180583104858457e-17,   3.355471436250928e-18,   1.056692653379967e+00,  -1.138610423220220e-02,   1.971541075563359e-05,   8.888617978938325e-07,  -7.441156990578536e-09,
  -9.792012619741052e-11,   1.828793591028851e-12,   3.769059573734051e-15,  -3.615096452550622e-16,   5.121454497916745e-18,   1.056695446295553e+00,  -1.138572524944276e-02,
   1.970907918178354e-05,   8.887225493540067e-07,  -7.437270100870668e-09,  -9.790844633388154e-11,   1.827371098466398e-12,   3.795125911455701e-15,  -3.606417749625750e-16,
   5.115104382643913e-18,   1.056700030670916e+00,  -1.138510313083401e-02,   1.969868727170808e-05,   8.884939625196024e-07,  -7.430891327316590e-09,  -9.788921575554738e-11,
   1.825038337720332e-12,   3.837894302088713e-15,  -3.592184868957263e-16,   5.104651960613220e-18,   1.056704894167530e+00,  -1.138444307324289e-02,   1.968766390360991e-05,
   8.882514308054287e-07,  -7.424125922992287e-09,  -9.786873428387231e-11,   1.822566481453242e-12,   3.883242574666601e-15,  -3.577102559695719e-16,   5.093523548870558e-18,
   1.056708721127913e+00,  -1.138392364668420e-02,   1.967899080870074e-05,   8.880605691039727e-07,  -7.418803661077577e-09,  -9.785256000659871e-11,   1.820623565279454e-12,
   3.918908476660228e-15,  -3.565247106024078e-16,   5.084738246330512e-18,   1.056710929486274e+00,  -1.138362389238896e-02,   1.967398633932488e-05,   8.879504239150815e-07,
  -7.415732939669439e-09,  -9.784320337468458e-11,   1.819503250923243e-12,   3.939482560988045e-15,  -3.558410869039749e-16,   5.079657188938957e-18,   1.056711758698546e+00,
  -1.138351133487004e-02,   1.967210728958006e-05,   8.879090642155013e-07,  -7.414580015733245e-09,  -9.783968568249522e-11,   1.819082747007099e-12,   3.947206554843665e-15,
  -3.555844886459601e-16,   5.077747144606283e-18,   1.056711896149804e+00,  -1.138349267701895e-02,   1.967179581959253e-05,   8.879022083015301e-07,  -7.414388910658491e-09,
  -9.783910235396706e-11,   1.819013052235812e-12,   3.948486823471535e-15,  -3.555419595757111e-16,   5.077430418941829e-18,   1.357560226482050e+00,  -1.164296374918337e-02,
  -4.579718185476349e-05,   1.202223170375720e-06,   8.534858020433592e-09,  -2.530175609251121e-10,  -2.165005690631653e-12,   6.227305862711516e-14,   5.932329121225328e-16,
  -1.392729431496861e-17,   1.357553723808660e+00,  -1.164245175985905e-02,  -4.578992042814951e-05,   1.201864668609216e-06,   8.530264612511594e-09,  -2.528325767331921e-10,
  -2.162645184531800e-12,   6.220305391618548e-14,   5.930743996582053e-16,  -1.387697775383507e-17,   1.357543049360289e+00,  -1.164161135675515e-02,  -4.577800244668812e-05,
   1.201276319728301e-06,   8.522727429962638e-09,  -2.525290455736354e-10,  -2.158770489229635e-12,   6.208831461215793e-14,   5.928139883434483e-16,  -1.379458087452281e-17,
   1.357531723954337e+00,  -1.164071977388919e-02,  -4.576536038608821e-05,   1.200652293946423e-06,   8.514734843345871e-09,  -2.522071796457736e-10,  -2.154659760110221e-12,
   6.196681802811968e-14,   5.925374117940648e-16,  -1.370743089944104e-17,   1.357522811530589e+00,  -1.164001820190794e-02,  -4.575541379642203e-05,   1.200161369003279e-06,
   8.508448216850941e-09,  -2.519540170663109e-10,  -2.151425045331335e-12,   6.187138075420208e-14,   5.923195522171464e-16,  -1.363904548769339e-17,   1.357517668289245e+00,
  -1.163961335445027e-02,  -4.574967453845095e-05,   1.199878121406178e-06,   8.504821517181716e-09,  -2.518079710993371e-10,  -2.149558408901404e-12,   6.181637455403656e-14,
   5.921937427268065e-16,  -1.359965984081839e-17,   1.357515737006291e+00,  -1.163946133841595e-02,  -4.574751960042330e-05,   1.199771773249884e-06,   8.503459926688567e-09,
  -2.517531405518382e-10,  -2.148857502528687e-12,   6.179573287254177e-14,   5.921464850199049e-16,  -1.358488542107884e-17,   1.357515416871416e+00,  -1.163943614001553e-02,
  -4.574716239969912e-05,   1.199754145266251e-06,   8.503234237886624e-09,  -2.517440521926181e-10,  -2.148741319067572e-12,   6.179231194046237e-14,   5.921386505837190e-16,
  -1.358243715547576e-17,   1.669240127563643e+00,  -8.929757128460811e-03,  -1.183861793744332e-04,  -1.489412609037734e-07,   2.458047555282750e-08,   3.338469658351264e-10,
  -3.854044973323860e-12,  -1.679857324422719e-13,  -7.116098920881738e-16,   6.029435390177416e-17,   1.669223322451615e+00,  -8.929819051966308e-03,  -1.183652382870120e-04,
  -1.484703646939869e-07,   2.457221714976089e-08,   3.333498644372053e-10,  -3.856717968767753e-12,  -1.676779453518790e-13,  -7.037559164119455e-16,   6.025361552198470e-17,
   1.669195736286041e+00,  -8.929920565099982e-03,  -1.183308652083675e-04,  -1.476978215916401e-07,   2.455865560633143e-08,   3.325344561109952e-10,  -3.861083647472406e-12,
  -1.671728171080932e-13,  -6.908873463471805e-16,   6.018630672083171e-17,   1.669166468147898e+00,  -8.930028082319829e-03,  -1.182943996552816e-04,  -1.468787853706925e-07,
   2.454426029116131e-08,   3.316701471962607e-10,  -3.865685462722322e-12,  -1.666370472718632e-13,  -6.772667525323007e-16,   6.011430384075085e-17,   1.669143436080113e+00,
  -8.930112557050481e-03,  -1.182657060991427e-04,  -1.462347000906523e-07,   2.453292715729132e-08,   3.309905847128452e-10,  -3.869285058329986e-12,  -1.662155465173008e-13,
  -6.665718362814606e-16,   6.005721629876110e-17,   1.669130144669424e+00,  -8.930161252216356e-03,  -1.182491485017240e-04,  -1.458631864213411e-07,   2.452638500758043e-08,
   3.305986576919900e-10,  -3.871353623910084e-12,  -1.659723517118436e-13,  -6.604094300960764e-16,   6.002410165320256e-17,   1.669125153772437e+00,  -8.930179526992167e-03,
  -1.182429313401268e-04,  -1.457237172369759e-07,   2.452392806790783e-08,   3.304515346712185e-10,  -3.872128722832830e-12,  -1.658810412990055e-13,  -6.580972441795443e-16,
   6.001163501086945e-17,   1.669124326468258e+00,  -8.930182555731150e-03,  -1.182419007766951e-04,  -1.457006002220684e-07,   2.452352077931392e-08,   3.304271495344138e-10,
  -3.872257118607785e-12,  -1.658659059065777e-13,  -6.577140643124290e-16,   6.000956681196641e-17,   1.924010793787425e+00,  -2.857787631351706e-03,  -7.424546438506373e-05,
  -1.517831587251026e-06,  -2.369173537103789e-08,  -2.135526998531141e-10,   2.085599566941013e-12,   1.493402439899432e-13,   3.894663494238636e-15,   6.195826014932762e-17,
   1.924000187485934e+00,  -2.858436686521500e-03,  -7.426566706899228e-05,  -1.518131673454602e-06,  -2.368709855130495e-08,  -2.131013920376155e-10,   2.101158424161521e-12,
   1.496542695209450e-13,   3.896624988877963e-15,   6.183276140603117e-17,   1.923982773451265e+00,  -2.859502307360475e-03,  -7.429883012484956e-05,  -1.518623847250041e-06,
  -2.367946243477550e-08,  -2.123598211233782e-10,   2.126706297626710e-12,   1.501693223367427e-13,   3.899817487930166e-15,   6.162591059292410e-17,   1.923964292995611e+00,
  -2.860633138030115e-03,  -7.433401471444335e-05,  -1.519145447599786e-06,  -2.367132726622381e-08,  -2.115720387564783e-10,   2.153821985351784e-12,   1.507151914922486e-13,
   3.903167416618514e-15,   6.140530589954868e-17,   1.923949746738999e+00,  -2.861523197861838e-03,  -7.436170228639076e-05,  -1.519555490420313e-06,  -2.366490119638115e-08,
  -2.109513854518586e-10,   2.175167511568124e-12,   1.511443274688415e-13,   3.905776608329413e-15,   6.123087819590495e-17,   1.923941350991812e+00,  -2.862036904912491e-03,
  -7.437768016703838e-05,  -1.519791949903013e-06,  -2.366118310476483e-08,  -2.105929280975770e-10,   2.187488560346724e-12,   1.513918030364738e-13,   3.907271504440124e-15,
   6.112988769342695e-17,   1.923938198150641e+00,  -2.862229813842354e-03,  -7.438367980087746e-05,  -1.519880707953711e-06,  -2.365978513223214e-08,  -2.104582735001845e-10,
   2.192115637584776e-12,   1.514846971394208e-13,   3.907830787904866e-15,   6.109190336305009e-17,   1.923937675513931e+00,  -2.862261791618676e-03,  -7.438467431449241e-05,
  -1.519895419033016e-06,  -2.365955330372679e-08,  -2.104359499203154e-10,   2.192882662984383e-12,   1.515000937961119e-13,   3.907923388188046e-15,   6.108560367811477e-17,
   4.267760796001007e-03,  -6.275442274086577e-05,   6.895473786489865e-07,  -6.765708633225279e-09,   6.093254023533435e-11,  -5.536356767078691e-13,   4.483268500941255e-15,
  -2.694553767086049e-17,   8.509737371728868e-19,   1.001304572883204e-20,   4.267859028393831e-03,  -6.275731395695701e-05,   6.895994600089517e-07,  -6.766497169866723e-09,
   6.094215067264005e-11,  -5.537154025736462e-13,   4.486668926117329e-15,  -2.689535695928329e-17,   8.514442688375327e-19,   9.971539661473027e-21,   4.268020298135371e-03,
  -6.276206059971247e-05,   6.896849659367725e-07,  -6.767791762093361e-09,   6.095793301276971e-11,  -5.538461778278437e-13,   4.492252590706688e-15,  -2.681313158493202e-17,
   8.522099338852447e-19,   9.903308503070835e-21,   4.268191425095675e-03,  -6.276709748567690e-05,   6.897757024188160e-07,  -6.769165535501755e-09,   6.097468643443017e-11,
  -5.539847943483671e-13,   4.498179068702974e-15,  -2.672609411642597e-17,   8.530131427112583e-19,   9.830784938385291e-21,   4.268326108198751e-03,  -6.277106178117139e-05,
   6.898471183615631e-07,  -6.770246782713925e-09,   6.098787663502450e-11,  -5.540937806194580e-13,   4.502844517170232e-15,  -2.665774736969669e-17,   8.536386004721646e-19,
   9.773618235221827e-21,   4.268403838570223e-03,  -6.277334974973792e-05,   6.898883362459020e-07,  -6.770870823804465e-09,   6.099549103027582e-11,  -5.541566364218258e-13,
   4.505537548686434e-15,  -2.661836418237610e-17,   8.539968914453940e-19,   9.740590107938616e-21,   4.268433027498187e-03,  -6.277420892285367e-05,   6.899038144150555e-07,
  -6.771105163520128e-09,   6.099835070317910e-11,  -5.541802314100585e-13,   4.506548904861299e-15,  -2.660358694998364e-17,   8.541309282305998e-19,   9.728180903290113e-21,
   4.268437866001932e-03,  -6.277435134405405e-05,   6.899063801665532e-07,  -6.771144009003028e-09,   6.099882475556396e-11,  -5.541841421956904e-13,   4.506716556683233e-15,
  -2.660113802144268e-17,   8.541531201075500e-19,   9.726123540744845e-21,   3.848668308040624e-02,  -5.627461217607686e-04,   6.089064287119948e-06,  -5.802740291715823e-08,
   4.970337979522740e-10,  -4.219808487765414e-12,   3.023889442207818e-14,  -1.198117106906543e-16,   6.361785859379865e-18,   1.062741384544229e-19,   3.848755045316811e-02,
  -5.627709161644214e-04,   6.089489044066902e-06,  -5.803341095797425e-08,   4.970986482387834e-10,  -4.220158017266558e-12,   3.026431254640186e-14,  -1.192771557316525e-16,
   6.365166396473057e-18,   1.059064231337982e-19,   3.848897442972565e-02,  -5.628116220466253e-04,   6.090186391478121e-06,  -5.804327448560308e-08,   4.972051497354742e-10,
  -4.220730678347217e-12,   3.030604988888193e-14,  -1.184009651455659e-16,   6.370653464284685e-18,   1.053019217524276e-19,   3.849048543843605e-02,  -5.628548166562373e-04,
   6.090926385547913e-06,  -5.805374093436780e-08,   4.973182094152414e-10,  -4.221336757188689e-12,   3.035034908143680e-14,  -1.174731199871412e-16,   6.376390597855525e-18,
   1.046593641931232e-19,   3.849167465333347e-02,  -5.628888128674477e-04,   6.091508804290784e-06,  -5.806197843420269e-08,   4.974072266180089e-10,  -4.221812617067035e-12,
   3.038522185750030e-14,  -1.167442495495090e-16,   6.380844199826266e-18,   1.041528486280020e-19,   3.849236098978353e-02,  -5.629084334778742e-04,   6.091844945381876e-06,
  -5.806673259643232e-08,   4.974586156775175e-10,  -4.222086793629089e-12,   3.040535123215336e-14,  -1.163241451801992e-16,   6.383389800695385e-18,   1.038602008927395e-19,
   3.849261871921127e-02,  -5.629158013505834e-04,   6.091971172699567e-06,  -5.806851785806543e-08,   4.974779157085911e-10,  -4.222189664370404e-12,   3.041291069248176e-14,
  -1.161664941209992e-16,   6.384341039736957e-18,   1.037502469094905e-19,   3.849266144172530e-02,  -5.629170226882478e-04,   6.091992096842296e-06,  -5.806881379212935e-08,
   4.974811151194804e-10,  -4.222206712170350e-12,   3.041416381703353e-14,  -1.161403665998739e-16,   6.384498475458519e-18,   1.037320172023104e-19,   1.073357032026464e-01,
  -1.550992925977232e-03,   1.623483753511509e-05,  -1.448209777935533e-07,   1.094821107267577e-09,  -7.648858081350496e-12,   3.318699008585826e-14,   2.334036380256215e-16,
   1.250553623853227e-17,   3.547442925783272e-19,   1.073380154199876e-01,  -1.551054791676778e-03,   1.623577274667205e-05,  -1.448318565243872e-07,   1.094892542458417e-09,
  -7.648132022859109e-12,   3.323696938581839e-14,   2.351932528769937e-16,   1.251291985762229e-17,   3.537125564894354e-19,   1.073418113953403e-01,  -1.551156357593537e-03,
   1.623730809212061e-05,  -1.448497149635572e-07,   1.095009892077734e-09,  -7.646936232851667e-12,   3.331903872877438e-14,   2.381273568026697e-16,   1.252486114511043e-17,
   3.520163838189137e-19,   1.073458393495756e-01,  -1.551264131445933e-03,   1.623893727257630e-05,  -1.448686631153258e-07,   1.095134514021814e-09,  -7.645662182721781e-12,
   3.340614785941149e-14,   2.412354461428278e-16,   1.253728712580571e-17,   3.502133452621914e-19,   1.073490094655808e-01,  -1.551348953339218e-03,   1.624021948981613e-05,
  -1.448835746611443e-07,   1.095232668130733e-09,  -7.644655719464773e-12,   3.347472268401196e-14,   2.436777443126701e-16,   1.254688942199019e-17,   3.487919847056846e-19,
   1.073508390395413e-01,  -1.551397907037314e-03,   1.624095949996645e-05,  -1.448921801049528e-07,   1.095289345248767e-09,  -7.644073356163717e-12,   3.351430629174290e-14,
   2.450857240839303e-16,   1.255236017641749e-17,   3.479707459984967e-19,   1.073515260699438e-01,  -1.551416289888146e-03,   1.624123738444655e-05,  -1.448954114777407e-07,
   1.095310633828401e-09,  -7.643854386993410e-12,   3.352917178341118e-14,   2.456141473724442e-16,   1.255440109933463e-17,   3.476621845792265e-19,   1.073516399554461e-01,
  -1.551419337122009e-03,   1.624128344795134e-05,  -1.448959471210283e-07,   1.095314163018980e-09,  -7.643818074636929e-12,   3.353163602789391e-14,   2.457017259459330e-16,
   1.255473870473500e-17,   3.476110267170470e-19,   2.116415458264271e-01,  -2.999600711444776e-03,   2.966638840889623e-05,  -2.335328889270095e-07,   1.310570433034796e-09,
  -4.058061681332771e-12,  -5.406266800003937e-14,   1.518917683315264e-15,   1.908107871046950e-17,   7.422076866665739e-19,   2.116457698204495e-01,  -2.999700432039150e-03,
   2.966750678345149e-05,  -2.335386249636597e-07,   1.310455938492418e-09,  -4.053462758525627e-12,  -5.398625887830398e-14,   1.522661387211998e-15,   1.909966956631862e-17,
   7.400271893796754e-19,   2.116527043053953e-01,  -2.999864141299563e-03,   2.966934270596856e-05,  -2.335480368412794e-07,   1.310268095251448e-09,  -4.045904834098544e-12,
  -5.386076950119261e-14,   1.528799171031226e-15,   1.912982226201312e-17,   7.364425005803607e-19,   2.116600624863919e-01,  -3.000037851877518e-03,   2.967129066613910e-05,
  -2.335580171040878e-07,   1.310068939577519e-09,  -4.037874363355178e-12,  -5.372754624440232e-14,   1.535300798930528e-15,   1.916131784929624e-17,   7.326320231550053e-19,
   2.116658535268289e-01,  -3.000174564752313e-03,   2.967282365190735e-05,  -2.335658669376865e-07,   1.309912319271471e-09,  -4.031546435498574e-12,  -5.362264910029244e-14,
   1.540409616523160e-15,   1.918574417201788e-17,   7.296282146157165e-19,   2.116691956949326e-01,  -3.000253465121839e-03,   2.967370834027386e-05,  -2.335703953507333e-07,
   1.309821977242150e-09,  -4.027891298297219e-12,  -5.356209111832897e-14,   1.543354806538937e-15,   1.919969650541447e-17,   7.278926811315217e-19,   2.116704507208759e-01,
  -3.000283093126729e-03,   2.967404054431898e-05,  -2.335720954594927e-07,   1.309788061723210e-09,  -4.026518159765588e-12,  -5.353934727143401e-14,   1.544460147920451e-15,
   1.920490842861084e-17,   7.272405979396915e-19,   2.116706587598431e-01,  -3.000288004399568e-03,   2.967409561161848e-05,  -2.335723772581038e-07,   1.309782440205359e-09,
  -4.026290510850479e-12,  -5.353557695731795e-14,   1.544643342059323e-15,   1.920577093863424e-17,   7.271324861466199e-19,   3.526420919739813e-01,  -4.853551810605763e-03,
   4.375979732747831e-05,  -2.687560699627431e-07,   3.865656461924868e-10,   1.293356030895568e-11,  -2.399086967723614e-13,   2.903883843492302e-15,   4.581238878823680e-17,
   1.079860147941825e-18,   3.526483199725196e-01,  -4.853666483194161e-03,   4.376012450619575e-05,  -2.687375904776581e-07,   3.860557169971507e-10,   1.294232491820128e-11,
  -2.397251034406245e-13,   2.909309345551669e-15,   4.586356317152825e-17,   1.075894912207579e-18,   3.526585442735696e-01,  -4.853854731092834e-03,   4.376066130902206e-05,
  -2.687072443602325e-07,   3.852188694802724e-10,   1.295672509264542e-11,  -2.394235616428782e-13,   2.918201435695802e-15,   4.594691901488532e-17,   1.069376446601996e-18,
   3.526693930927625e-01,  -4.854054468896226e-03,   4.376123047166878e-05,  -2.686750324752086e-07,   3.843312953904556e-10,   1.297202060643481e-11,  -2.391034083165709e-13,
   2.927616566734635e-15,   4.603447609035490e-17,   1.062447800343322e-18,   3.526779312034619e-01,  -4.854211657972957e-03,   4.376167809683869e-05,  -2.686496726351491e-07,
   3.836330493433462e-10,   1.298406969344188e-11,  -2.388513061913076e-13,   2.935011783459092e-15,   4.610274006963668e-17,   1.056986218839663e-18,   3.526828587273236e-01,
  -4.854302372608076e-03,   4.376193630631016e-05,  -2.686350333993664e-07,   3.832301899340259e-10,   1.299102803726117e-11,  -2.387057573634565e-13,   2.939273874304581e-15,
   4.614187858030685e-17,   1.053830753791122e-18,   3.526847090640308e-01,  -4.854336436429393e-03,   4.376203324314397e-05,  -2.686295355446198e-07,   3.830789333998743e-10,
   1.299364182970413e-11,  -2.386510918235363e-13,   2.940873228686814e-15,   4.615652673854895e-17,   1.052645188568727e-18,   3.526850157839571e-01,  -4.854342082972873e-03,
   4.376204931057784e-05,  -2.686286241608263e-07,   3.830538615817169e-10,   1.299407514884191e-11,  -2.386420296742697e-13,   2.941138286360951e-15,   4.615895230951266e-17,
   1.052448629541640e-18,   5.319307817051006e-01,  -7.007449275709660e-03,   5.406536413776277e-05,  -1.701253731128447e-07,  -2.391431496160990e-09,   4.050205786783057e-11,
  -3.215218881534624e-13,   8.371321067796005e-16,   1.287396269469698e-16,   1.429817529547017e-18,   5.319384714895812e-01,  -7.007521702270350e-03,   5.406331837725963e-05,
  -1.700677135184287e-07,  -2.392111705855190e-09,   4.050467382673013e-11,  -3.210073577150039e-13,   8.443000620967223e-16,   1.288155762474960e-16,   1.423980509334217e-18,
   5.319510953046777e-01,  -7.007640584397489e-03,   5.405995951236022e-05,  -1.699730532214764e-07,  -2.393227585523372e-09,   4.050898372697973e-11,  -3.201624604523258e-13,
   8.560456976025294e-16,   1.289391296992094e-16,   1.414383536916395e-18,   5.319644898619048e-01,  -7.007766703339222e-03,   5.405639492933153e-05,  -1.698726075959374e-07,
  -2.394410539951634e-09,   4.051357774164920e-11,  -3.192656724351799e-13,   8.684791715611862e-16,   1.290686951349233e-16,   1.404180671520364e-18,   5.319750312415630e-01,
  -7.007865942099407e-03,   5.405358917288258e-05,  -1.697935536501498e-07,  -2.395340749111100e-09,   4.051720835086011e-11,  -3.185596893586202e-13,   8.782429605592008e-16,
   1.291695536423558e-16,   1.396136713619303e-18,   5.319811147948078e-01,  -7.007923207709594e-03,   5.405196975134117e-05,  -1.697479289833688e-07,  -2.395877277420158e-09,
   4.051930969078019e-11,  -3.181521705276060e-13,   8.838692401975853e-16,   1.292273162857506e-16,   1.391488689638106e-18,   5.319833992138406e-01,  -7.007944710189007e-03,
   5.405136161134048e-05,  -1.697307962612415e-07,  -2.396078689858869e-09,   4.052009990646479e-11,  -3.179991276738226e-13,   8.859803389070280e-16,   1.292489226942708e-16,
   1.389742234894987e-18,   5.319837778881655e-01,  -7.007948274462764e-03,   5.405126080178967e-05,  -1.697279562564377e-07,  -2.396112073726324e-09,   4.052023095623315e-11,
  -3.179737578148635e-13,   8.863301979751511e-16,   1.292524998330406e-16,   1.389452678322912e-18,   7.512216804027623e-01,  -9.256268878440450e-03,   5.321166242421965e-05,
   1.582816150849791e-07,  -6.786231272612275e-09,   4.669566851994522e-11,   2.681288382442706e-13,  -8.069048566129077e-15,   2.110424651134413e-16,   3.776305137710229e-18,
   7.512292411676271e-01,  -9.256201070512851e-03,   5.320587134522476e-05,   1.583478657104282e-07,  -6.785648938484955e-09,   4.667185957722455e-11,   2.689693453934860e-13,
  -8.049931071377398e-15,   2.110241383336567e-16,   3.767811087224114e-18,   7.512416527920528e-01,  -9.256089732425912e-03,   5.319636471409018e-05,   1.584566024749995e-07,
  -6.784691646192139e-09,   4.663281448768621e-11,   2.703491114029426e-13,  -8.018578268030734e-15,   2.109923509447859e-16,   3.753839311005471e-18,   7.512548216766085e-01,
  -9.255971566389182e-03,   5.318627793646096e-05,   1.585719475036418e-07,  -6.783674122974444e-09,   4.659144050930727e-11,   2.718130621489824e-13,  -7.985353602143390e-15,
   2.109563118299243e-16,   3.738976999444336e-18,   7.512651850728015e-01,  -9.255878549029326e-03,   5.317833994656564e-05,   1.586627007128104e-07,  -6.782872051084352e-09,
   4.655891939948929e-11,   2.729651335255097e-13,  -7.959236851281285e-15,   2.109262774261843e-16,   3.727253432267707e-18,   7.512711657568434e-01,  -9.255824858848825e-03,
   5.317375892063133e-05,   1.587150665762988e-07,  -6.782408648335345e-09,   4.654016702711169e-11,   2.736299894743807e-13,  -7.944176898799063e-15,   2.109082744024832e-16,
   3.720476791823793e-18,   7.512734115188405e-01,  -9.255804696132025e-03,   5.317203872693022e-05,   1.587347286672107e-07,  -6.782234539341239e-09,   4.653312838486996e-11,
   2.738796443141671e-13,  -7.938524107858910e-15,   2.109013875789438e-16,   3.717930068509836e-18,   7.512737837836982e-01,  -9.255801353792920e-03,   5.317175358163128e-05,
   1.587379878446682e-07,  -6.782205673184432e-09,   4.653196179057222e-11,   2.739210279020686e-13,  -7.937587201968584e-15,   2.109002393166373e-16,   3.717507805775175e-18,
   1.011528202514221e+00,  -1.118787282831524e-02,   2.961054570424820e-05,   7.565357116909001e-07,  -8.958003133059331e-09,  -5.386396516912894e-11,   1.807084574353814e-12,
  -3.890762207122403e-15,  -9.173920918139445e-17,   9.352760303197151e-18,   1.011532400975326e+00,  -1.118755011769144e-02,   2.960291879558609e-05,   7.564589681952197e-07,
  -8.954149957553588e-09,  -5.387483846877839e-11,   1.806726290729466e-12,  -3.843493364029342e-15,  -9.138679352951615e-17,   9.328730110486581e-18,   1.011539292647944e+00,
  -1.118702035966033e-02,   2.959040036691489e-05,   7.563329704523465e-07,  -8.947824895114207e-09,  -5.389258707061502e-11,   1.806139109917350e-12,  -3.765983109428143e-15,
  -9.081089407714328e-17,   9.289251093327645e-18,   1.011546604184266e+00,  -1.118645827763567e-02,   2.957712057585608e-05,   7.561992623863332e-07,  -8.941114259956323e-09,
  -5.391128162388788e-11,   1.805517420245477e-12,  -3.683860030416511e-15,  -9.020341707140194e-17,   9.247320761416338e-18,   1.011552357633711e+00,  -1.118601593943617e-02,
   2.956667164845016e-05,   7.560940228208774e-07,  -8.935833493521610e-09,  -5.392589444125297e-11,   1.805029124657271e-12,  -3.619316601011798e-15,  -8.972793220942301e-17,
   9.214292487516971e-18,   1.011555677754049e+00,  -1.118576066675476e-02,   2.956064230523614e-05,   7.560332827695288e-07,  -8.932786075670735e-09,  -5.393428776867236e-11,
   1.804747710455551e-12,  -3.582102561928495e-15,  -8.945456341929590e-17,   9.195219683593054e-18,   1.011556924434070e+00,  -1.118566481109050e-02,   2.955837840402291e-05,
   7.560104734765629e-07,  -8.931641780712380e-09,  -5.393743198654211e-11,   1.804642110348068e-12,  -3.568134982024020e-15,  -8.935210776686366e-17,   9.188055478969155e-18,
   1.011557131086059e+00,  -1.118564892173526e-02,   2.955800313933552e-05,   7.560066924676223e-07,  -8.931452099592858e-09,  -5.393795278691333e-11,   1.804624609504831e-12,
  -3.565820007211546e-15,  -8.933513466962986e-17,   9.186867794759875e-18,   1.310349736521152e+00,  -1.194971285957435e-02,  -3.072559413207109e-05,   1.296100466777427e-06,
   3.105281617105925e-09,  -2.823649983271589e-10,  -2.291128907731524e-13,   7.358858426555867e-14,   1.393598883915620e-16,  -9.778464092682118e-18,   1.310345369369783e+00,
  -1.194916093843291e-02,  -3.072294543392446e-05,   1.295700489977300e-06,   3.104799481222832e-09,  -2.821458754607343e-10,  -2.285324483689418e-13,   7.353889450344389e-14,
   1.405790696889957e-16,  -9.763183358088008e-18,   1.310338200255809e+00,  -1.194825499351683e-02,  -3.071859746243794e-05,   1.295044088361862e-06,   3.104008885960983e-09,
  -2.817862568711401e-10,  -2.275760911051471e-13,   7.345737601418877e-14,   1.425728574078621e-16,  -9.738267626377202e-18,   1.310330593641124e+00,  -1.194729388301505e-02,
  -3.071398432949936e-05,   1.294347901294599e-06,   3.103171241354888e-09,  -2.814048191894520e-10,  -2.265566221508806e-13,   7.337095340598437e-14,   1.446779714965174e-16,
  -9.712060808796863e-18,   1.310324607462781e+00,  -1.194653760493454e-02,  -3.071035405961463e-05,   1.293800219759035e-06,   3.102512909325695e-09,  -2.811047309786560e-10,
  -2.257509013289203e-13,   7.330299225346514e-14,   1.463271502463468e-16,  -9.691602596097240e-18,   1.310321152829379e+00,  -1.194610119053250e-02,  -3.070825907603250e-05,
   1.293484230745676e-06,   3.102133334022175e-09,  -2.809315863766423e-10,  -2.252845469767054e-13,   7.326379205824793e-14,   1.472758969574938e-16,  -9.679862466704339e-18,
   1.310319855600441e+00,  -1.194593732174443e-02,  -3.070747241081009e-05,   1.293365590494345e-06,   3.101990868040065e-09,  -2.808665768259287e-10,  -2.251091701446471e-13,
   7.324907605112680e-14,   1.476315890411237e-16,  -9.675466525960107e-18,   1.310319640567245e+00,  -1.194591015863041e-02,  -3.070734201094679e-05,   1.293345925058899e-06,
   3.101967255870600e-09,  -2.808558009827222e-10,  -2.250800854212310e-13,   7.324663687601907e-14,   1.476905199411481e-16,  -9.674738499953160e-18,   1.631625657656897e+00,
  -9.876843087111148e-03,  -1.176141077921032e-04,   2.911196036155850e-07,   2.994786272228015e-08,   1.846648984333093e-10,  -8.486192474958720e-12,  -1.473071625769374e-13,
   2.227227100409102e-15,   9.696481375603925e-17,   1.631608971520494e+00,  -9.876717886910727e-03,  -1.175886389680508e-04,   2.913787514747287e-07,   2.992985395988176e-08,
   1.842324750874199e-10,  -8.477277931585459e-12,  -1.468182389204883e-13,   2.229177322283458e-15,   9.667269041108323e-17,   1.631581581129566e+00,  -9.876512271397079e-03,
  -1.175468388504860e-04,   2.918037430980713e-07,   2.990030343580067e-08,   1.835236331460654e-10,  -8.462637808519322e-12,  -1.460166703233025e-13,   2.232351085678224e-15,
   9.619351442752978e-17,   1.631552521344096e+00,  -9.876293989984426e-03,  -1.175025007476006e-04,   2.922540925742136e-07,   2.986896677025002e-08,   1.827729241345288e-10,
  -8.447096133124551e-12,  -1.451676093541737e-13,   2.235680925211661e-15,   9.568560443175930e-17,   1.631529653700064e+00,  -9.876122123618419e-03,  -1.174676173223742e-04,
   2.926080863994277e-07,   2.984431821030751e-08,   1.821831444367787e-10,  -8.434859448769248e-12,  -1.445004541759701e-13,   2.238274235849355e-15,   9.528626257438866e-17,
   1.631516457361478e+00,  -9.876022905031886e-03,  -1.174474897814920e-04,   2.928122095104693e-07,   2.983009848126488e-08,   1.818431844836468e-10,  -8.427795304069648e-12,
  -1.441158506781253e-13,   2.239759964804537e-15,   9.505594937971280e-17,   1.631511502199011e+00,  -9.875985641581368e-03,  -1.174399325148093e-04,   2.928888269653521e-07,
   2.982475985937662e-08,   1.817156042466130e-10,  -8.425142249098828e-12,  -1.439715085076023e-13,   2.240315808708189e-15,   9.496949375332280e-17,   1.631510680820133e+00,
  -9.875979464320677e-03,  -1.174386798332060e-04,   2.929015256751164e-07,   2.982387496060546e-08,   1.816944601156484e-10,  -8.424702446278025e-12,  -1.439475859606211e-13,
   2.240407839059296e-15,   9.495516404001538e-17,   1.911266867242537e+00,  -3.531350164457315e-03,  -9.486143185661275e-05,  -1.926646106170534e-06,  -2.704181434055175e-08,
  -9.712753221046106e-11,   8.354988081896649e-12,   3.102899680582285e-13,   6.104225755189147e-15,   5.042881886007515e-17,   1.911253321540308e+00,  -3.532173151101204e-03,
  -9.488441853521042e-05,  -1.926776460404969e-06,  -2.702369316372792e-08,  -9.619636439016188e-11,   8.379131453236429e-12,   3.105345406175848e-13,   6.095632624846349e-15,
   4.991656960052713e-17,   1.911231081729424e+00,  -3.533524255288998e-03,  -9.492214361503502e-05,  -1.926989498605507e-06,  -2.699390716477598e-08,  -9.466718238148724e-11,
   8.418741596551409e-12,   3.109341421954247e-13,   6.081462735918768e-15,   4.907469057019139e-17,   1.911207480380045e+00,  -3.534957933313988e-03,  -9.496215750664918e-05,
  -1.927214244442577e-06,  -2.696225144301378e-08,  -9.304389852524459e-11,   8.460736796666413e-12,   3.113555609542854e-13,   6.066341983841546e-15,   4.818012084289319e-17,
   1.911188903684059e+00,  -3.536086283017866e-03,  -9.499363753769048e-05,  -1.927390176122100e-06,  -2.693730169534420e-08,  -9.176585798229971e-11,   8.493762383196929e-12,
   3.116853434535830e-13,   6.054380074559549e-15,   4.747517355571246e-17,   1.911178181783750e+00,  -3.536737490711952e-03,  -9.501180082172117e-05,  -1.927491331067216e-06,
  -2.692288807129390e-08,  -9.102807290071858e-11,   8.512812105538368e-12,   3.118749147910262e-13,   6.047451863533071e-15,   4.706796875845507e-17,   1.911174155428600e+00,
  -3.536982028509763e-03,  -9.501862047259602e-05,  -1.927529244173984e-06,  -2.691747284629144e-08,  -9.075098898698580e-11,   8.519963574541765e-12,   3.119459584078565e-13,
   6.044845573120790e-15,   4.691499030118462e-17,   1.911173487993372e+00,  -3.537022564299348e-03,  -9.501975088286770e-05,  -1.927535525037676e-06,  -2.691657504934053e-08,
  -9.070505634447411e-11,   8.521148933051686e-12,   3.119577273955915e-13,   6.044413296415271e-15,   4.688962829564992e-17,   4.027284004427243e-03,  -5.754702865260681e-05,
   6.138613786030361e-07,  -5.873720299141242e-09,   5.089205217366563e-11,  -4.516723353422392e-13,   4.165339918786546e-15,   6.081535333624436e-18,   1.192073155950181e-18,
   6.210578447548219e-21,   4.027371448898556e-03,  -5.754953854349139e-05,   6.139048832015022e-07,  -5.874362904348130e-09,   5.090099936515833e-11,  -4.516537044660423e-13,
   4.170044128967143e-15,   6.110465425616233e-18,   1.189876305263310e-18,   6.102949855470275e-21,   4.027515007637682e-03,  -5.755365913396183e-05,   6.139763085823551e-07,
  -5.875417825477485e-09,   5.091569486197930e-11,  -4.516230582558511e-13,   4.177760482897205e-15,   6.157561107210509e-18,   1.186262552940486e-18,   5.926364174488726e-21,
   4.027667340654952e-03,  -5.755803166855467e-05,   6.140521039661147e-07,  -5.876537152045709e-09,   5.093129774612684e-11,  -4.515904583529222e-13,   4.185939464164429e-15,
   6.206992907001568e-18,   1.182418227351718e-18,   5.739135089560094e-21,   4.027787231956781e-03,  -5.756147307147894e-05,   6.141117607885078e-07,  -5.877418048882410e-09,
   5.094358440817260e-11,  -4.515647431262263e-13,   4.192370081549779e-15,   6.245504926578797e-18,   1.179385603725518e-18,   5.591888021879145e-21,   4.027856425342031e-03,
  -5.756345925065606e-05,   6.141461920953806e-07,  -5.877926424026006e-09,   5.095067812983260e-11,  -4.515498788650152e-13,   4.196078794762158e-15,   6.267574262642924e-18,
   1.177632568929189e-18,   5.506950366666444e-21,   4.027882408480911e-03,  -5.756420509547841e-05,   6.141591218071461e-07,  -5.878117322501434e-09,   5.095334243112927e-11,
  -4.515442927596710e-13,   4.197470976449940e-15,   6.275831905790721e-18,   1.176973749187566e-18,   5.475063294046304e-21,   4.027886715575754e-03,  -5.756432873071387e-05,
   6.141612651137682e-07,  -5.878148966579896e-09,   5.095378410559770e-11,  -4.515433665495377e-13,   4.197701725319497e-15,   6.277199166336494e-18,   1.176864512032286e-18,
   5.469777970463174e-21,   3.632889626180888e-02,  -5.166898913579512e-04,   5.437791332226518e-06,  -5.071128079634731e-08,   4.197573254184631e-10,  -3.507752102772591e-12,
   3.031245724643334e-14,   1.442524933716002e-16,   9.921804453192495e-18,   6.693132532914756e-20,   3.632967082096060e-02,  -5.167115587431572e-04,   5.438150109001842e-06,
  -5.071626889879080e-08,   4.198224945922373e-10,  -3.507316002592674e-12,   3.035156167370835e-14,   1.445691982290507e-16,   9.901144126095919e-18,   6.595502607729166e-20,
   3.633094242216513e-02,  -5.167471308020647e-04,   5.438739139527595e-06,  -5.072445722586476e-08,   4.199295404442665e-10,  -3.506599406500602e-12,   3.041569803629251e-14,
   1.450855126317096e-16,   9.867160029583708e-18,   6.435322747110995e-20,   3.633229173961912e-02,  -5.167848775981520e-04,   5.439364201349157e-06,  -5.073314506133137e-08,
   4.200432060057711e-10,  -3.505838140331363e-12,   3.048367018218521e-14,   1.456284606606823e-16,   9.831009642148551e-18,   6.265489757872183e-20,   3.633335369596508e-02,
  -5.168145860398836e-04,   5.439856168059399e-06,  -5.073998198980879e-08,   4.201327204690992e-10,  -3.505238369897910e-12,   3.053710553338916e-14,   1.460522163608077e-16,
   9.802493622909933e-18,   6.131924966622314e-20,   3.633396658633773e-02,  -5.168317319697551e-04,   5.440140107615983e-06,  -5.074392753697983e-08,   4.201844046809682e-10,
  -3.504891971221355e-12,   3.056792040822957e-14,   1.462953526551846e-16,   9.786010273803910e-18,   6.054880184449310e-20,   3.633419673552672e-02,  -5.168381705516880e-04,
   5.440246732757919e-06,  -5.074540909553201e-08,   4.202038170877721e-10,  -3.504761846169964e-12,   3.057948721525447e-14,   1.463863841513295e-16,   9.779815666624469e-18,
   6.025956313220024e-20,   3.633423488619469e-02,  -5.168392378448583e-04,   5.440264407560472e-06,  -5.074565468329356e-08,   4.202070352079077e-10,  -3.504740273503428e-12,
   3.058140434240646e-14,   1.464014597564428e-16,   9.778788561050669e-18,   6.021162148307951e-20,   1.013808879601517e-01,  -1.427779171528444e-03,   1.459718892526235e-05,
  -1.284811938982553e-07,   9.506222067030790e-10,  -6.716904130889234e-12,   4.723499471356838e-14,   8.332892988453871e-16,   2.428385973479765e-17,   2.298839318135256e-19,
   1.013829668808188e-01,  -1.427834056672544e-03,   1.459800118666182e-05,  -1.284907313577789e-07,   9.507241675489294e-10,  -6.714396407092761e-12,   4.733049013938999e-14,
   8.343923700648718e-16,   2.422302633581408e-17,   2.271014169831220e-19,   1.013863798492940e-01,  -1.427924162460046e-03,   1.459933470853129e-05,  -1.285063860550391e-07,
   9.508916994436651e-10,  -6.710277238420517e-12,   4.748708503594133e-14,   8.361929574133871e-16,   2.412296609416535e-17,   2.225362008116358e-19,   1.013900013864644e-01,
  -1.428019775661449e-03,   1.460074976441987e-05,  -1.285229933827930e-07,   9.510696629131852e-10,  -6.705903321870518e-12,   4.765300441488611e-14,   8.380895504468552e-16,
   2.401653353193876e-17,   2.176958807031031e-19,   1.013928516376755e-01,  -1.428095026646909e-03,   1.460186348323353e-05,  -1.285360608903504e-07,   9.512098651938417e-10,
  -6.702458748028339e-12,   4.778340989957580e-14,   8.395720693700927e-16,   2.393258206090762e-17,   2.138892326503809e-19,   1.013944966064270e-01,  -1.428138456621877e-03,
   1.460250625716243e-05,  -1.285436013833328e-07,   9.512908363932187e-10,  -6.700469906904439e-12,   4.785859965356748e-14,   8.404236089910069e-16,   2.388405661026823e-17,
   2.116934312017634e-19,   1.013951143147961e-01,  -1.428154765228538e-03,   1.460274762989565e-05,  -1.285464327203809e-07,   9.513212527891281e-10,  -6.699722905622200e-12,
   4.788682095142100e-14,   8.407426050708107e-16,   2.386582058335390e-17,   2.108690922881863e-19,   1.013952167091296e-01,  -1.428157468625094e-03,   1.460278764113077e-05,
  -1.285469020448386e-07,   9.513262953173179e-10,  -6.699599070420386e-12,   4.789149833877881e-14,   8.407954428569483e-16,   2.386279695017035e-17,   2.107324572108763e-19,
   2.001005513401931e-01,  -2.773129256014415e-03,   2.698694501766129e-05,  -2.132675287009247e-07,   1.220341407133634e-09,  -4.751346697013758e-12,   1.037927969411268e-15,
   2.551001722728376e-15,   4.406856326011105e-17,   5.008210684568130e-19,   2.001043938761748e-01,  -2.773220328268995e-03,   2.698798702414677e-05,  -2.132742254933555e-07,
   1.220345674338941e-09,  -4.743684926899686e-12,   1.210954016609750e-15,   2.553412821625660e-15,   4.394510172694703e-17,   4.950562359533881e-19,   2.001107021282457e-01,
  -2.773369840169958e-03,   2.698969764976875e-05,  -2.132852114658212e-07,   1.220352945229283e-09,  -4.731101783501951e-12,   1.494646448538393e-15,   2.557349726522753e-15,
   4.374202487771785e-17,   4.855979057290556e-19,   2.001173958172089e-01,  -2.773528486645766e-03,   2.699151276039657e-05,  -2.132968576973771e-07,   1.220361020850709e-09,
  -4.717743179117446e-12,   1.795179106276406e-15,   2.561498144147490e-15,   4.352600923721477e-17,   4.755694916831763e-19,   2.001226638912859e-01,  -2.773653344277497e-03,
   2.699294126542450e-05,  -2.133060155686459e-07,   1.220367637284954e-09,  -4.707224899176778e-12,   2.031346842754319e-15,   2.564742024255112e-15,   4.335561701254838e-17,
   4.676826056289221e-19,   2.001257042422163e-01,  -2.773725402868326e-03,   2.699376568500626e-05,  -2.133112976382298e-07,   1.220371560252493e-09,  -4.701152601186934e-12,
   2.167502183661856e-15,   2.566605737523084e-15,   4.325712557345622e-17,   4.631331528114354e-19,   2.001268459322314e-01,  -2.773752461738793e-03,   2.699407526302390e-05,
  -2.133132805186499e-07,   1.220373053106879e-09,  -4.698872016995510e-12,   2.218603070416710e-15,   2.567303994305973e-15,   4.322011184262041e-17,   4.614252091388218e-19,
   2.001270351841157e-01,  -2.773756947141961e-03,   2.699412658002570e-05,  -2.133136091783752e-07,   1.220373301610062e-09,  -4.698493957709801e-12,   2.227072359681249e-15,
   2.567419656698163e-15,   4.321397474648261e-17,   4.611421152639297e-19,   3.339077880109025e-01,  -4.516250799986371e-03,   4.057944130799803e-05,  -2.607833922620851e-07,
   5.952578670757962e-10,   8.354105208199111e-12,  -1.320715944350251e-13,   5.002017529057432e-15,   8.352113704211661e-17,   7.534584576934905e-19,   3.339135637824188e-01,
  -4.516362091690043e-03,   4.057994799210891e-05,  -2.607713770181616e-07,   5.949798421550125e-10,   8.369110197623112e-12,  -1.317430591858352e-13,   5.005599987332140e-15,
   8.331634709570079e-17,   7.431114158892267e-19,   3.339230456982758e-01,  -4.516544791301462e-03,   4.058077962575886e-05,  -2.607516365930150e-07,   5.945239238433697e-10,
   8.393750874489160e-12,  -1.312043092132877e-13,   5.011442933863494e-15,   8.297944921182743e-17,   7.261350012286803e-19,   3.339331068147569e-01,  -4.516738644636125e-03,
   4.058166182203021e-05,  -2.607306694636105e-07,   5.940408445541077e-10,   8.419906764265227e-12,  -1.306334619949901e-13,   5.017590802647887e-15,   8.262102233838276e-17,
   7.081352566905938e-19,   3.339410250176464e-01,  -4.516891204553902e-03,   4.058235594779318e-05,  -2.607141530055466e-07,   5.936611543767815e-10,   8.440498956194702e-12,
  -1.301847882180055e-13,   5.022391611118992e-15,   8.233825063849173e-17,   6.939792076112089e-19,   3.339455947879523e-01,  -4.516979248391787e-03,   4.058275647431063e-05,
  -2.607046149337973e-07,   5.934422263459171e-10,   8.452386055079110e-12,  -1.299260849839377e-13,   5.025147186276790e-15,   8.217478233638296e-17,   6.858134337309779e-19,
   3.339473107860337e-01,  -4.517012309449755e-03,   4.058290686333590e-05,  -2.607010321397600e-07,   5.933600542142947e-10,   8.456850333638326e-12,  -1.298289838316772e-13,
   5.026179085282434e-15,   8.211334640341294e-17,   6.827478542183395e-19,   3.339475952374833e-01,  -4.517017789778639e-03,   4.058293179180148e-05,  -2.607004381795229e-07,
   5.933464349863031e-10,   8.457590380940389e-12,  -1.298128902733966e-13,   5.026349987143399e-15,   8.210315977849218e-17,   6.822397301252385e-19,   5.047522604165191e-01,
  -6.583683934923902e-03,   5.181969879529515e-05,  -2.023102385299523e-07,  -1.654042499070557e-09,   3.358148571400112e-11,  -2.324335892281638e-13,   5.794149268044826e-15,
   1.781898314946309e-16,   9.043151470673976e-19,   5.047596318946755e-01,  -6.583770136241695e-03,   5.181828374121277e-05,  -2.022623027974056e-07,  -1.654530311072043e-09,
   3.359886721212179e-11,  -2.317304064286727e-13,   5.798332828034780e-15,   1.778616716161790e-16,   8.875649289607275e-19,   5.047717332234587e-01,  -6.583911634833959e-03,
   5.181596040244887e-05,  -2.021835906268903e-07,  -1.655330052183683e-09,   3.362741049939568e-11,  -2.305769699954620e-13,   5.805138921835614e-15,   1.773217473899057e-16,
   8.600834937904285e-19,   5.047845734707157e-01,  -6.584061755629951e-03,   5.181349475515620e-05,  -2.021000465873559e-07,  -1.656177170632465e-09,   3.365770894533845e-11,
  -2.293543804357593e-13,   5.812276624381336e-15,   1.767472228924262e-16,   8.309464224714342e-19,   5.047946786695167e-01,  -6.584179886896318e-03,   5.181155398461684e-05,
  -2.020342793602885e-07,  -1.656842794573910e-09,   3.368156247624555e-11,  -2.283931355863446e-13,   5.817833178015000e-15,   1.762938964105807e-16,   8.080320041667398e-19,
   5.048005105199164e-01,  -6.584248056911381e-03,   5.181043381056718e-05,  -2.019963167397044e-07,  -1.657226513381490e-09,   3.369533220154471e-11,  -2.278387594945844e-13,
   5.821015588666907e-15,   1.760318035977083e-16,   7.948143237893889e-19,   5.048027004268777e-01,  -6.584273654324345e-03,   5.181001315189004e-05,  -2.019820600621417e-07,
  -1.657370523156567e-09,   3.370050350808634e-11,  -2.276306570944973e-13,   5.822206007534454e-15,   1.759332965491157e-16,   7.898522181114902e-19,   5.048030634347297e-01,
  -6.584277897403614e-03,   5.180994342052313e-05,  -2.019796967432833e-07,  -1.657394390594473e-09,   3.370136075975658e-11,  -2.275961649076025e-13,   5.822403093435655e-15,
   1.759169629246492e-16,   7.890297448489023e-19,   7.150575110251045e-01,  -8.824750987517628e-03,   5.449134194192180e-05,   5.746135715621590e-08,  -5.801800946712848e-09,
   5.130506613343638e-11,   1.564118356209722e-13,   7.232502646169166e-16,   3.293590942438401e-16,   2.178416197662932e-18,   7.150652555854139e-01,  -8.824726197983020e-03,
   5.448639009527001e-05,   5.753438783427728e-08,  -5.801451652275074e-09,   5.130739353243319e-11,   1.577111995283412e-13,   7.337245595645900e-16,   3.287343496229406e-16,
   2.152847348373083e-18,   7.150779690259286e-01,  -8.824685479408706e-03,   5.447826105778968e-05,   5.765428197760874e-08,  -5.800876231114085e-09,   5.131123651299105e-11,
   1.598425054651075e-13,   7.508253204850019e-16,   3.277068131736368e-16,   2.110896840214273e-18,   7.150914582777212e-01,  -8.824642243218056e-03,   5.446963582066919e-05,
   5.778150229430873e-08,  -5.800262951126504e-09,   5.131534424286152e-11,   1.621015225500028e-13,   7.688421813222270e-16,   3.266139174209359e-16,   2.066418066003116e-18,
   7.151020738893475e-01,  -8.824608193926886e-03,   5.446284793140552e-05,   5.788162779762685e-08,  -5.799778332993797e-09,   5.131859870288736e-11,   1.638775950470273e-13,
   7.829286434757749e-16,   3.257519242679955e-16,   2.031437718391215e-18,   7.151082001658120e-01,  -8.824588534523382e-03,   5.445893059520598e-05,   5.793941316696481e-08,
  -5.799497863698724e-09,   5.132048556690225e-11,   1.649018845919052e-13,   7.910209897483774e-16,   3.252536995494582e-16,   2.011259800739241e-18,   7.151105006056309e-01,
  -8.824581150541225e-03,   5.445745961305484e-05,   5.796111233402791e-08,  -5.799392396043415e-09,   5.132119573488375e-11,   1.652863799595864e-13,   7.940527116261947e-16,
   3.250664693126852e-16,   2.003684671682247e-18,   7.151108819344588e-01,  -8.824579926451828e-03,   5.445721577758133e-05,   5.796470929140114e-08,  -5.799374905429319e-09,
   5.132131354139164e-11,   1.653501084176639e-13,   7.945548918539015e-16,   3.250354257390344e-16,   2.002429084864655e-18,   9.673044478784090e-01,  -1.091717808294603e-02,
   3.780098217829290e-05,   6.069069390296363e-07,  -9.610766651844533e-09,  -1.181346201316574e-11,   1.709045296336557e-12,  -1.311053499283522e-15,   2.458104898385658e-16,
   8.055716051093041e-18,   9.673098107757583e-01,  -1.091691904049171e-02,   3.779279682188725e-05,   6.068901004709913e-07,  -9.607107137554753e-09,  -1.181674417921990e-11,
   1.710004785410363e-12,  -1.271097590418209e-15,   2.448507291226858e-16,   8.006731938526948e-18,   9.673186140013731e-01,  -1.091649378556814e-02,   3.777936149626552e-05,
   6.068624541383658e-07,  -9.601097982712535e-09,  -1.182204693597855e-11,   1.711577162719007e-12,  -1.205684539230524e-15,   2.432724747573668e-16,   7.926361591710737e-18,
   9.673279537649498e-01,  -1.091604256427781e-02,   3.776510865159991e-05,   6.068331150589596e-07,  -9.594719809637550e-09,  -1.182755765122138e-11,   1.713241795104952e-12,
  -1.136522192543128e-15,   2.415942287565736e-16,   7.841143797338745e-18,   9.673353033832707e-01,  -1.091568745585604e-02,   3.775389381414301e-05,   6.068100220575932e-07,
  -9.589698711072122e-09,  -1.183181085241389e-11,   1.714549128381295e-12,  -1.082269068997592e-15,   2.402708428509769e-16,   7.774121521072963e-18,   9.673395446611773e-01,
  -1.091548251788821e-02,   3.774742240464183e-05,   6.067966934480303e-07,  -9.586800359154679e-09,  -1.183423193794344e-11,   1.715302516110814e-12,  -1.051029860550811e-15,
   2.395060518147676e-16,   7.735459573339290e-18,   9.673411372407339e-01,  -1.091540556203019e-02,   3.774499249472909e-05,   6.067916881997291e-07,  -9.585711890060612e-09,
  -1.183513475058696e-11,   1.715585212680244e-12,  -1.039312706415598e-15,   2.392186690089796e-16,   7.720945020289165e-18,   9.673414012302956e-01,  -1.091539280551560e-02,
   3.774458971128024e-05,   6.067908584964575e-07,  -9.585531454972946e-09,  -1.183528407098054e-11,   1.715632062706260e-12,  -1.037371131423488e-15,   2.391710208526704e-16,
   7.718539204493358e-18,   1.262158407605439e+00,  -1.213288778732961e-02,  -1.505968212733788e-05,   1.301013828300751e-06,  -2.428676886612114e-09,  -2.629029699100539e-10,
   1.852049077830226e-12,   7.396156582760330e-14,  -7.354798544339353e-17,  -2.921180131746257e-18,   1.262156260377274e+00,  -1.213233367066503e-02,  -1.506173346034501e-05,
   1.300641561683977e-06,  -2.424726872710799e-09,  -2.626822105174693e-10,   1.851762975923027e-12,   7.394481058112584e-14,  -7.320360208859526e-17,  -2.987933556449822e-18,
   1.262152735147223e+00,  -1.213142411288804e-02,  -1.506509861890495e-05,   1.300030652718672e-06,  -2.418242723250877e-09,  -2.623198355910157e-10,   1.851294230219978e-12,
   7.391705767281835e-14,  -7.264781484003296e-17,  -3.097424703414331e-18,   1.262148994323777e+00,  -1.213045915723508e-02,  -1.506866600088286e-05,   1.299382739489637e-06,
  -2.411363133525733e-09,  -2.619353788314623e-10,   1.850798113027741e-12,   7.388727492666225e-14,  -7.207107140452127e-17,  -3.213473420840566e-18,   1.262146050072067e+00,
  -1.212969984458210e-02,  -1.507147115185603e-05,   1.298873051645946e-06,  -2.405949289739691e-09,  -2.616328465280589e-10,   1.850408565359453e-12,   7.386359352214166e-14,
  -7.162655916582338e-17,  -3.304710204499033e-18,   1.262144350805093e+00,  -1.212926167549439e-02,  -1.507308909837984e-05,   1.298578990317684e-06,  -2.402825026590225e-09,
  -2.614582642015322e-10,   1.850184106327438e-12,   7.384982947433375e-14,  -7.137377996187067e-17,  -3.357326940096354e-18,   1.262143712698001e+00,  -1.212909714716657e-02,
  -1.507369647176185e-05,   1.298468584279249e-06,  -2.401651867190506e-09,  -2.613927096425454e-10,   1.850099886657246e-12,   7.384464260076528e-14,  -7.127956839468334e-17,
  -3.377077897708933e-18,   1.262143606921802e+00,  -1.212906987469074e-02,  -1.507379714301222e-05,   1.298450283790347e-06,  -2.401457400940588e-09,  -2.613818431861360e-10,
   1.850085929560902e-12,   7.384378183502848e-14,  -7.126398889383865e-17,  -3.380351524314530e-18,   1.590270356536436e+00,  -1.079543382365984e-02,  -1.111630368979069e-04,
   7.875498250534143e-07,   3.132573644467318e-08,  -5.721835507765255e-11,  -1.109124680640743e-11,  -2.135646745805057e-14,   5.485473741088455e-15,   6.966061395284483e-17,
   1.590254590738683e+00,  -1.079509789076735e-02,  -1.111364221635191e-04,   7.874679117167147e-07,   3.130231737104112e-08,  -5.727667630528957e-11,  -1.106963161231084e-11,
  -2.101078542231367e-14,   5.473795239840787e-15,   6.924247395202520e-17,   1.590228711345648e+00,  -1.079454642792728e-02,  -1.110927441399376e-04,   7.873333800045531e-07,
   3.126390439068273e-08,  -5.737168062896687e-11,  -1.103418037952747e-11,  -2.044483094827390e-14,   5.454627718584457e-15,   6.855732425866136e-17,   1.590201254999203e+00,
  -1.079396131772010e-02,  -1.110464179001977e-04,   7.871905534362829e-07,   3.122319036882025e-08,  -5.747148445350433e-11,  -1.099660954829833e-11,  -1.984639788788393e-14,
   5.434295813392622e-15,   6.783208462592538e-17,   1.590179649381094e+00,  -1.079350085788896e-02,  -1.110099730296224e-04,   7.870780920092343e-07,   3.119118086487486e-08,
  -5.754930573647260e-11,  -1.096707416485970e-11,  -1.937693791410320e-14,   5.418299090452336e-15,   6.726258742213981e-17,   1.590167181426788e+00,  -1.079323512753049e-02,
  -1.109889456406776e-04,   7.870131659125480e-07,   3.117272063269839e-08,  -5.759392783284963e-11,  -1.095004196697433e-11,  -1.910660798641055e-14,   5.409068916668778e-15,
   6.693442794325085e-17,   1.590162499788257e+00,  -1.079313534503154e-02,  -1.109810507162107e-04,   7.869887812949558e-07,   3.116579110304499e-08,  -5.761062909988620e-11,
  -1.094364871135804e-11,  -1.900521060640719e-14,   5.405603244675241e-15,   6.681129682732810e-17,   1.590161723750329e+00,  -1.079311880475394e-02,  -1.109797420758696e-04,
   7.869847389730986e-07,   3.116464256465723e-08,  -5.761339468574913e-11,  -1.094258906982261e-11,  -1.898840856168084e-14,   5.405028778421135e-15,   6.679089114656149e-17,
   1.895466788906426e+00,  -4.390136517322453e-03,  -1.205969472701863e-04,  -2.360592806906936e-06,  -2.615603966498320e-08,   2.308842209947350e-10,   1.994153387309599e-11,
   5.179018271604733e-13,   6.109105919504164e-15,  -8.024020933928181e-17,   1.895449582656461e+00,  -4.391143097110351e-03,  -1.206190375536924e-04,  -2.360251240818354e-06,
  -2.611319360455627e-08,   2.324248389991726e-10,   1.996508797974344e-11,   5.174608121982617e-13,   6.071174709100167e-15,  -8.135732700984866e-17,   1.895421333578562e+00,
  -4.392795452345901e-03,  -1.206552757999864e-04,  -2.359688923140257e-06,  -2.604281893979130e-08,   2.349530408101731e-10,   2.000364628467749e-11,   5.167326943722928e-13,
   6.008846557640624e-15,  -8.318911993381139e-17,   1.895391356088910e+00,  -4.394548581383701e-03,  -1.206936913127211e-04,  -2.359090111559256e-06,  -2.596809725255087e-08,
   2.376343324605725e-10,   2.004441061659476e-11,   5.159545095197850e-13,   5.942633243524407e-15,  -8.512987541759869e-17,   1.895367761450987e+00,  -4.395928196092535e-03,
  -1.207238983999027e-04,  -2.358617288153304e-06,  -2.590925568404828e-08,   2.397435592844030e-10,   2.007638440202388e-11,   5.153380260774025e-13,   5.890466623693357e-15,
  -8.665513568807007e-17,   1.895354143644166e+00,  -4.396724355736214e-03,  -1.207413210260135e-04,  -2.358343789124716e-06,  -2.587528297519914e-08,   2.409604477328396e-10,
   2.009479380067012e-11,   5.149806199852691e-13,   5.860337746688269e-15,  -8.753453783165236e-17,   1.895349029856028e+00,  -4.397023313467030e-03,  -1.207478614151913e-04,
  -2.358240969708830e-06,  -2.586252322509161e-08,   2.414173280361764e-10,   2.010169852635965e-11,   5.148461041108475e-13,   5.849019813401944e-15,  -8.786459995486380e-17,
   1.895348182163676e+00,  -4.397072869560910e-03,  -1.207489454738431e-04,  -2.358223919704276e-06,  -2.586040797360813e-08,   2.414930586097914e-10,   2.010284265153034e-11,
   5.148237900221494e-13,   5.847143480563352e-15,  -8.791930391235821e-17,   3.806489951712851e-03,  -5.290488420503070e-05,   5.479822110133741e-07,  -5.126146505769631e-09,
   4.289479297387937e-11,  -3.452685824857430e-13,   4.877214554742424e-15,   4.388957088249357e-17,   1.008116429741793e-18,  -2.132736266079139e-20,   3.806568007380243e-03,
  -5.290707440175282e-05,   5.480188957473044e-07,  -5.126636757877416e-09,   4.290524975495551e-11,  -3.451392309796209e-13,   4.881089756905418e-15,   4.377672758523374e-17,
   1.001281738724439e-18,  -2.146134127086333e-20,   3.806696152177659e-03,  -5.291067011527023e-05,   5.480791261448262e-07,  -5.127441453790632e-09,   4.292242215741855e-11,
  -3.449271256047545e-13,   4.887431869688706e-15,   4.359098549173211e-17,   9.900658403805614e-19,  -2.168068617069157e-20,   3.806832128859296e-03,  -5.291448565061686e-05,
   5.481430440467964e-07,  -5.128295118732596e-09,   4.294065141112885e-11,  -3.447024004005994e-13,   4.894134630629515e-15,   4.339323193199613e-17,   9.781708654478111e-19,
  -2.191260831816525e-20,   3.806939146949658e-03,  -5.291748864568598e-05,   5.481933541410516e-07,  -5.128966827592236e-09,   4.295500371418566e-11,  -3.445257834823777e-13,
   4.899390404805098e-15,   4.323711699319630e-17,   9.688138073619235e-19,  -2.209453823159415e-20,   3.807000910676519e-03,  -5.291922179246399e-05,   5.482223916339747e-07,
  -5.129354431861802e-09,   4.296328902338861e-11,  -3.444239519606168e-13,   4.902415866692368e-15,   4.314682717838689e-17,   9.634154210749382e-19,  -2.219929525344195e-20,
   3.807024103852568e-03,  -5.291987261757812e-05,   5.482332959840596e-07,  -5.129499971286001e-09,   4.296640067632810e-11,  -3.443857316683777e-13,   4.903550493450100e-15,
   4.311288604588032e-17,   9.613886063878986e-19,  -2.223858749759941e-20,   3.807027948468380e-03,  -5.291998050175081e-05,   5.482351035616370e-07,  -5.129524096010136e-09,
   4.296691650038067e-11,  -3.443793970819742e-13,   4.903738496834751e-15,   4.310725789751650e-17,   9.610526504446650e-19,  -2.224509837192096e-20,   3.434544179263475e-02,
  -4.755125936559614e-04,   4.867370936045277e-06,  -4.451484008469022e-08,   3.573951878172845e-10,  -2.694845485262212e-12,   3.891592843973294e-14,   4.638913919462523e-16,
   8.550343844773032e-18,  -1.876693727258097e-19,   3.434613506990444e-02,  -4.755316115277476e-04,   4.867676568858115e-06,  -4.451866349244502e-08,   3.574786455088226e-10,
  -2.693475118169124e-12,   3.894869488190487e-14,   4.628973218406847e-16,   8.487501032133700e-18,  -1.888898273455049e-19,   3.434727322829112e-02,  -4.755628336202153e-04,
   4.868178366227520e-06,  -4.452493883240867e-08,   3.576157046810024e-10,  -2.691227607075710e-12,   3.900230554001923e-14,   4.612609172253836e-16,   8.384373765525823e-18,
  -1.908878969946942e-19,   3.434848094518973e-02,  -4.755959642744094e-04,   4.868710882225959e-06,  -4.453159554805882e-08,   3.577612026737267e-10,  -2.688845776243578e-12,
   3.905894498729052e-14,   4.595184911432610e-16,   8.275001687178606e-18,  -1.930005166864615e-19,   3.434943145578829e-02,  -4.756220394323692e-04,   4.869130025960184e-06,
  -4.453683303991553e-08,   3.578757591959501e-10,  -2.686973404440512e-12,   3.910334275542552e-14,   4.581428035008956e-16,   8.188964642118350e-18,  -1.946577342164135e-19,
   3.434998002648995e-02,  -4.756370883804471e-04,   4.869371942390981e-06,  -4.453985514669580e-08,   3.579418915419597e-10,  -2.685893681873051e-12,   3.912889433127067e-14,
   4.573471107707467e-16,   8.139326860007285e-18,  -1.956119705875203e-19,   3.435018602259637e-02,  -4.756427394978908e-04,   4.869462788269962e-06,  -4.454098987351252e-08,
   3.579667285834855e-10,  -2.685488397988103e-12,   3.913847573813428e-14,   4.570479885887383e-16,   8.120690392839684e-18,  -1.959698843110276e-19,   3.435022016952373e-02,
  -4.756436762561274e-04,   4.869477847478060e-06,  -4.454117796522163e-08,   3.579708458730732e-10,  -2.685421224968858e-12,   3.914006328323281e-14,   4.569983873179419e-16,
   8.117601290930127e-18,  -1.960291919196370e-19,   9.589391386439164e-02,  -1.316919951666980e-03,   1.314246632313516e-05,  -1.142747699741734e-07,   8.299846512185785e-10,
  -5.211225803457835e-12,   8.198157319251707e-14,   1.636639893866361e-15,   2.156038293142686e-17,  -5.084251623530012e-19,   9.589578556105467e-02,  -1.316968764132188e-03,
   1.314317599810387e-05,  -1.142821450418130e-07,   8.301606203536256e-10,  -5.206378082788171e-12,   8.206372248523337e-14,   1.633941869676341e-15,   2.137906934485955e-17,
  -5.119161761730727e-19,   9.589885832729483e-02,  -1.317048899962332e-03,   1.314434115335971e-05,  -1.142942474412034e-07,   8.304496269202677e-10,  -5.198425652730410e-12,
   8.219806230517499e-14,   1.629499818333930e-15,   2.108152525046893e-17,  -5.176314977357957e-19,   9.590211886933774e-02,  -1.317133933354468e-03,   1.314557762124479e-05,
  -1.143070822741607e-07,   8.307564543334647e-10,  -5.189995527169328e-12,   8.233989860006850e-14,   1.624769083450117e-15,   2.076596065415803e-17,  -5.236744827076210e-19,
   9.590468500516172e-02,  -1.317200857312390e-03,   1.314655083523465e-05,  -1.143171784719282e-07,   8.309980512135600e-10,  -5.183366790694679e-12,   8.245101157807078e-14,
   1.621033415386937e-15,   2.051772110500329e-17,  -5.284148264699496e-19,   9.590616600122949e-02,  -1.317239481331450e-03,   1.314711253906763e-05,  -1.143230032285202e-07,
   8.311375303245213e-10,  -5.179543552749275e-12,   8.251493148885197e-14,   1.618872463992094e-15,   2.037450217597263e-17,  -5.311443470363140e-19,   9.590672213544331e-02,
  -1.317253985203685e-03,   1.314732347257286e-05,  -1.143251901128335e-07,   8.311899153329298e-10,  -5.178108330779502e-12,   8.253889520326242e-14,   1.618060056597049e-15,
   2.032073057877425e-17,  -5.321681321226846e-19,   9.590681432293785e-02,  -1.317256389437029e-03,   1.314735843824955e-05,  -1.143255526007099e-07,   8.311985993837167e-10,
  -5.177870445517894e-12,   8.254286548268392e-14,   1.617925338420880e-15,   2.031181761797214e-17,  -5.323377770485541e-19,   1.894240763662200e-01,  -2.567145684880522e-03,
   2.454182953837650e-05,  -1.944736272080157e-07,   1.132218958573988e-09,  -3.700229966453760e-12,   9.347284266988594e-14,   4.032895237255359e-15,   3.960614355284581e-17,
  -1.011895834859515e-18,   1.894275707952597e-01,  -2.567228728184656e-03,   2.454279741823223e-05,  -1.944787919590373e-07,   1.132420258380472e-09,  -3.688264159104969e-12,
   9.362292760171489e-14,   4.027518143392430e-15,   3.923342706866697e-17,  -1.019118013940792e-18,   1.894333075659845e-01,  -2.567365058782471e-03,   2.454438647449571e-05,
  -1.944872584624075e-07,   1.132750952047478e-09,  -3.668632088860332e-12,   9.386824419972078e-14,   4.018664274357690e-15,   3.862178066446316e-17,  -1.030942111446306e-18,
   1.894393948589324e-01,  -2.567509718221587e-03,   2.454607275575421e-05,  -1.944962254058012e-07,   1.133102151813363e-09,  -3.647816930617417e-12,   9.412708735127093e-14,
   4.009233686023425e-15,   3.797308880890823e-17,  -1.043444487928088e-18,   1.894441856888231e-01,  -2.567623567506906e-03,   2.454739999092899e-05,  -1.945032703723291e-07,
   1.133378770327150e-09,  -3.631446890242936e-12,   9.432974385589448e-14,   4.001785787048745e-15,   3.746279283250324e-17,  -1.053252107512223e-18,   1.894469506098626e-01,
  -2.567689272775152e-03,   2.454816601361115e-05,  -1.945073313257356e-07,   1.133538501216190e-09,  -3.622004077170173e-12,   9.444627832103897e-14,   3.997477063300204e-15,
   3.716838301535749e-17,  -1.058899513748800e-18,   1.894479888726595e-01,  -2.567713945873763e-03,   2.454845367206791e-05,  -1.945088553405496e-07,   1.133598498535232e-09,
  -3.618459088206960e-12,   9.448995831344337e-14,   3.995857131834815e-15,   3.705784665682741e-17,  -1.061017757549198e-18,   1.894481609799727e-01,  -2.567718035799194e-03,
   2.454850135606644e-05,  -1.945091079196295e-07,   1.133608444834289e-09,  -3.617871502057082e-12,   9.449719468481956e-14,   3.995588501507330e-15,   3.703952459582018e-17,
  -1.061368759434944e-18,   3.164724805606915e-01,  -4.203959123610500e-03,   3.751228487077971e-05,  -2.500415664144669e-07,   7.436131611238520e-10,   7.180406362375439e-12,
   4.702887531715470e-14,   7.739937647984868e-15,   7.217807496509365e-17,  -1.855168487692751e-18,   3.164778201124349e-01,  -4.204065835042685e-03,   3.751292038919005e-05,
  -2.500311543583380e-07,   7.437167858620741e-10,   7.203378703220610e-12,   4.730296323285928e-14,   7.730087218212294e-15,   7.152650125882551e-17,  -1.868119935735710e-18,
   3.164865859165131e-01,  -4.204241015876041e-03,   3.751396376051590e-05,  -2.500140377200462e-07,   7.438873183330570e-10,   7.241070018334812e-12,   4.775104868119291e-14,
   7.713868616072388e-15,   7.045723742934335e-17,  -1.889324837641150e-18,   3.164958872015119e-01,  -4.204426891855497e-03,   3.751507094661920e-05,  -2.499958436318235e-07,
   7.440688298412996e-10,   7.281034140123076e-12,   4.822395538624005e-14,   7.696594947856311e-15,   6.932321344417896e-17,  -1.911747351012059e-18,   3.165032074264088e-01,
  -4.204573174021948e-03,   3.751594237207651e-05,  -2.499815016207317e-07,   7.442120870071434e-10,   7.312464872902539e-12,   4.859429215542364e-14,   7.682953887685580e-15,
   6.843113031959610e-17,  -1.929337805579782e-18,   3.165074320972874e-01,  -4.204657595034494e-03,   3.751644531450875e-05,  -2.499732152819389e-07,   7.442949261165682e-10,
   7.330595634461044e-12,   4.880728203126094e-14,   7.675062718578171e-15,   6.791645299721505e-17,  -1.939467064235396e-18,   3.165090185081167e-01,  -4.204689295720958e-03,
   3.751663417926652e-05,  -2.499701019249761e-07,   7.443260637097855e-10,   7.337402301937645e-12,   4.888712224269310e-14,   7.672095985297362e-15,   6.772321715808116e-17,
  -1.943266439974524e-18,   3.165092814786780e-01,  -4.204694550550662e-03,   3.751666548656068e-05,  -2.499695857489551e-07,   7.443312268290795e-10,   7.338530519324982e-12,
   4.890034953626069e-14,   7.671604021139699e-15,   6.769118716990468e-17,  -1.943896016020221e-18,   4.792306943347482e-01,  -6.179237739140567e-03,   4.925454894927471e-05,
  -2.236380117190748e-07,  -1.021664547344228e-09,   3.060547515462309e-11,   1.058447287810082e-14,   1.142358528642184e-14,   1.487288456533376e-16,  -3.312787278296526e-18,
   4.792377018650076e-01,  -6.179333060199229e-03,   4.925367677662961e-05,  -2.235941722799717e-07,  -1.021635206434839e-09,   3.063933253912965e-11,   1.115513173172613e-14,
   1.140604302546286e-14,   1.476696807990877e-16,  -3.334129683815844e-18,   4.792492057707073e-01,  -6.179489531554187e-03,   4.925224498427178e-05,  -2.235221680364867e-07,
  -1.021586169826151e-09,   3.069487665579007e-11,   1.208891381419992e-14,   1.137716624324649e-14,   1.459315149150952e-16,  -3.369073074176289e-18,   4.792614121824192e-01,
  -6.179655541280420e-03,   4.925072576964604e-05,  -2.234457188177422e-07,  -1.021532960056269e-09,   3.075376116624842e-11,   1.307558894360237e-14,   1.134641949007849e-14,
   1.440880422500820e-16,  -3.406023366162605e-18,   4.792710186047316e-01,  -6.179786178426634e-03,   4.924953016005257e-05,  -2.233855187589955e-07,  -1.021490232707034e-09,
   3.080006579816226e-11,   1.384911089636779e-14,   1.132214485176039e-14,   1.426378444034172e-16,  -3.435011155839497e-18,   4.792765626236847e-01,  -6.179861566313109e-03,
   4.924884015858845e-05,  -2.233507624558005e-07,  -1.021465233469121e-09,   3.082677393586052e-11,   1.429432463406238e-14,   1.130810475463608e-14,   1.418011590726072e-16,
  -3.451703556967759e-18,   4.792786444512755e-01,  -6.179889874199885e-03,   4.924858105773832e-05,  -2.233377085348346e-07,  -1.021455781737535e-09,   3.083680023686612e-11,
   1.446127986708518e-14,   1.130282675639074e-14,   1.414870232876263e-16,  -3.457964719365896e-18,   4.792789895436465e-01,  -6.179894566583801e-03,   4.924853810814626e-05,
  -2.233355445243087e-07,  -1.021454211589184e-09,   3.083846208828259e-11,   1.448894311471876e-14,   1.130195154668701e-14,   1.414349533155645e-16,  -3.459002227283517e-18,
   6.806326123501433e-01,  -8.387560764405064e-03,   5.465849914463432e-05,  -2.692576629309704e-08,  -4.730178824451558e-09,   5.653126480619753e-11,   3.289214055266245e-13,
   1.146121184113156e-14,   2.989941593627776e-16,  -5.057585444780608e-18,   6.806403825423956e-01,  -8.387571974328229e-03,   5.465446437174780e-05,  -2.684503299235737e-08,
  -4.729463037644341e-09,   5.656508609502722e-11,   3.300764098279880e-13,   1.143441415915768e-14,   2.972406473942772e-16,  -5.090775132932435e-18,   6.806531381565549e-01,
  -8.387590352253125e-03,   5.464784108492360e-05,  -2.671246160159983e-08,  -4.728286195066425e-09,   5.662055075781481e-11,   3.319674916405753e-13,   1.139029964539037e-14,
   2.943629117513514e-16,  -5.145113565120140e-18,   6.806666722865115e-01,  -8.387609818698504e-03,   5.464081387222618e-05,  -2.657174610231464e-08,  -4.727035082750658e-09,
   5.667932346084117e-11,   3.339672209711671e-13,   1.134332552576992e-14,   2.913106973713775e-16,  -5.202569786109590e-18,   6.806773233106576e-01,  -8.387625114305554e-03,
   5.463528385850293e-05,  -2.646096825621678e-08,  -4.726048722704465e-09,   5.672552014818738e-11,   3.355360567121986e-13,   1.130623726604818e-14,   2.889095277753360e-16,
  -5.247642434565518e-18,   6.806834700617295e-01,  -8.387633931841972e-03,   5.463209255581032e-05,  -2.639702257125462e-08,  -4.725478783436876e-09,   5.675215797817544e-11,
   3.364394739749090e-13,   1.128478513033618e-14,   2.875241450696603e-16,  -5.273596295218270e-18,   6.806857781970271e-01,  -8.387637241051226e-03,   5.463089422326777e-05,
  -2.637300775666948e-08,  -4.725264634986625e-09,   5.676215636224043e-11,   3.367783403363931e-13,   1.127672061921701e-14,   2.870039920929872e-16,  -5.283331175982042e-18,
   6.806861608018633e-01,  -8.387637789501721e-03,   5.463069558425611e-05,  -2.636902682164369e-08,  -4.725229129929833e-09,   5.676381350602628e-11,   3.368344924620703e-13,
   1.127538333540225e-14,   2.869177730983747e-16,  -5.284944288646090e-18,   9.242829802330791e-01,  -1.058825628503721e-02,   4.416066483077983e-05,   4.534795423596255e-07,
  -9.434302161819632e-09,   2.986483947661106e-11,   1.814560144969058e-12,   9.468371456425718e-15,   3.562196435709190e-16,  -4.055387201930802e-18,   9.242892484656398e-01,
  -1.058806253359911e-02,   4.415263145237026e-05,   4.535222777529102e-07,  -9.430412747014569e-09,   2.989277574110261e-11,   1.815917619273198e-12,   9.446065549941471e-15,
   3.532338895693639e-16,  -4.112589355591957e-18,   9.242995379614132e-01,  -1.058774444600472e-02,   4.413944576656597e-05,   4.535924634024396e-07,  -9.424025581509670e-09,
   2.993858846923563e-11,   1.818137545308285e-12,   9.409236739103825e-15,   3.483342391002700e-16,  -4.206263238385537e-18,   9.243104547941088e-01,  -1.058740691246611e-02,
   4.412545800404556e-05,   4.536669746227624e-07,  -9.417245510555661e-09,   2.998713223878242e-11,   1.820481390068654e-12,   9.369873515150417e-15,   3.431379951482718e-16,
  -4.305341925515389e-18,   9.243190455897675e-01,  -1.058714125874888e-02,   4.411445192896866e-05,   4.537256434304736e-07,  -9.411907541343477e-09,   3.002528768128896e-11,
   1.822317562471348e-12,   9.338688468989086e-15,   3.390504655124975e-16,  -4.383087976195009e-18,   9.243240031816637e-01,  -1.058698793956212e-02,   4.410810105702387e-05,
   4.537595135974738e-07,  -9.408826087995263e-09,   3.004728832420521e-11,   1.823373868811488e-12,   9.320608523920709e-15,   3.366922548024825e-16,  -4.427864719360313e-18,
   9.243258647454331e-01,  -1.058693036569387e-02,   4.410571642088577e-05,   4.537722343076346e-07,  -9.407668819325592e-09,   3.005554607046698e-11,   1.823769882707132e-12,
   9.313803756385988e-15,   3.358068716523661e-16,  -4.444661430126481e-18,   9.243261733230409e-01,  -1.058692082194893e-02,   4.410532114277896e-05,   4.537743430595413e-07,
  -9.407476977449878e-09,   3.005691471399768e-11,   1.823835493937350e-12,   9.312674947820448e-15,   3.356601145643169e-16,  -4.447444807149900e-18,   1.213483343122790e+00,
  -1.219195763063511e-02,   1.555476083404906e-07,   1.223203682541533e-06,  -7.076291985120347e-09,  -1.939700522243925e-10,   3.872536075731431e-12,   6.950013128682945e-14,
  -2.500652532546979e-16,  -1.065483697206606e-17,   1.213483353202855e+00,  -1.219143638671392e-02,   1.495523154067181e-07,   1.222929393810366e-06,  -7.068038352820557e-09,
  -1.937632825018999e-10,   3.871473095119575e-12,   6.944243586147003e-14,  -2.532737546626783e-16,  -1.077113095670293e-17,   1.213483369141759e+00,  -1.219058076466187e-02,
   1.397151610668657e-07,   1.222479316741309e-06,  -7.054490354700323e-09,  -1.934239631665656e-10,   3.869718803377433e-12,   6.934729252899937e-14,  -2.585404202227110e-16,
  -1.096156037371758e-17,   1.213483385226560e+00,  -1.218967299793522e-02,   1.292840961940284e-07,   1.222002038610356e-06,  -7.040117165941284e-09,  -1.930640917273053e-10,
   3.867844811359234e-12,   6.924575882058477e-14,  -2.641279039050437e-16,  -1.116295998611240e-17,   1.213483397286396e+00,  -1.218895866355104e-02,   1.210798003713089e-07,
   1.221626626983703e-06,  -7.028807050925178e-09,  -1.927809963764035e-10,   3.866360881978911e-12,   6.916543262075853e-14,  -2.685246413703210e-16,  -1.132098398243751e-17,
   1.213483404006333e+00,  -1.218854644039048e-02,   1.163469477446470e-07,   1.221410053259756e-06,  -7.022280429845759e-09,  -1.926176668952215e-10,   3.865500834748827e-12,
   6.911890724500033e-14,  -2.710618200851409e-16,  -1.141199083247153e-17,   1.213483406484376e+00,  -1.218839165276502e-02,   1.145700938319755e-07,   1.221328743484479e-06,
  -7.019829745127935e-09,  -1.925563445890111e-10,   3.865177190012123e-12,   6.910140486453511e-14,  -2.720145050703186e-16,  -1.144612853371566e-17,   1.213483406892755e+00,
  -1.218836599483127e-02,   1.142755748724127e-07,   1.221315266059458e-06,  -7.019423515731316e-09,  -1.925461800425577e-10,   3.865123504946474e-12,   6.909850192608028e-14,
  -2.721724235393078e-16,  -1.145178543244922e-17,   1.545381663083271e+00,  -1.163859553851199e-02,  -9.878942528490054e-05,   1.265321034476419e-06,   2.758116967188425e-08,
  -3.090502506683807e-10,  -8.981752567358721e-12,   1.757075741707858e-13,   6.138475523220273e-15,  -4.611151934189415e-17,   1.545367651763851e+00,  -1.163805688244393e-02,
  -9.876598214375500e-05,   1.264885630521441e-06,   2.756228119287776e-08,  -3.085290157375749e-10,  -8.957780463607159e-12,   1.754666689532083e-13,   6.114945824018583e-15,
  -4.628650411333763e-17,   1.545344652308947e+00,  -1.163717272462938e-02,  -9.872750799929807e-05,   1.264171378958012e-06,   2.753130942348933e-08,  -3.076738475962792e-10,
  -8.918493855713008e-12,   1.750705435734873e-13,   6.076367595903213e-15,  -4.657277900600588e-17,   1.545320251361992e+00,  -1.163623474592276e-02,  -9.868669966486495e-05,
   1.263414228971348e-06,   2.749849583894177e-08,  -3.067671601399413e-10,  -8.876899361309412e-12,   1.746493554776039e-13,   6.035500448488578e-15,  -4.687519247673669e-17,
   1.545301050042738e+00,  -1.163549668277965e-02,  -9.865459465341620e-05,   1.262818873454646e-06,   2.747270742829336e-08,  -3.060541084725356e-10,  -8.844230559115247e-12,
   1.743172510288352e-13,   6.003386500897880e-15,  -4.711221904112728e-17,   1.545289969529450e+00,  -1.163507078460653e-02,  -9.863607077486119e-05,   1.262475492714449e-06,
   2.745783886929420e-08,  -3.056427994950755e-10,  -8.825403304080905e-12,   1.741253361627354e-13,   5.984872427013949e-15,  -4.724862122044404e-17,   1.545285808864842e+00,
  -1.163491086552755e-02,  -9.862911573413779e-05,   1.262346589622817e-06,   2.745225830454602e-08,  -3.054883880480354e-10,  -8.818338498337998e-12,   1.740532228623118e-13,
   5.977923894829719e-15,  -4.729976780253826e-17,   1.545285119184535e+00,  -1.163488435717443e-02,  -9.862796288193794e-05,   1.262325224189212e-06,   2.745133338987923e-08,
  -3.054627942071185e-10,  -8.817167670206150e-12,   1.740412665536207e-13,   5.976772270610663e-15,  -4.730824218805496e-17,   1.875787949779443e+00,  -5.474789186870875e-03,
  -1.511841073679710e-04,  -2.710869036029576e-06,  -1.548190238551251e-08,   9.009691723997306e-10,   3.634541823105457e-11,   6.085308411213556e-13,  -2.656769192845056e-15,
  -4.524133309016636e-16,   1.875766409477104e+00,  -5.475941930938301e-03,  -1.511968878395639e-04,  -2.709571887000696e-06,  -1.540446677258276e-08,   9.027502907341203e-10,
   3.633318429184587e-11,   6.061902749237529e-13,  -2.736348665455854e-15,  -4.532752446851618e-16,   1.875731046339475e+00,  -5.477833943180794e-03,  -1.512178213119568e-04,
  -2.707440590485777e-06,  -1.527736342858235e-08,   9.056692145774610e-10,   3.631287216796416e-11,   6.023447591400499e-13,  -2.866807310238060e-15,  -4.546777540446912e-16,
   1.875693521627448e+00,  -5.479840965433801e-03,  -1.512399684681689e-04,  -2.705176654304530e-06,  -1.514252398686132e-08,   9.087595239889584e-10,   3.629100967588916e-11,
   5.982601851331415e-13,  -3.004983218694820e-15,  -4.561489913599804e-16,   1.875663988260464e+00,  -5.481420104789899e-03,  -1.512573514300269e-04,  -2.703393141536913e-06,
  -1.503642435910376e-08,   9.111866191863810e-10,   3.627357973660335e-11,   5.950425940845268e-13,  -3.113546167735184e-15,  -4.572946048706458e-16,   1.875646943487948e+00,
  -5.482331297493907e-03,  -1.512673646525571e-04,  -2.702363127431437e-06,  -1.497520014425844e-08,   9.125853402968907e-10,   3.626343084635071e-11,   5.931844594244309e-13,
  -3.176126718904264e-15,  -4.579508480192416e-16,   1.875640542914047e+00,  -5.482673429259051e-03,  -1.512711211593443e-04,  -2.701976212025116e-06,  -1.495221135228150e-08,
   9.131101952869875e-10,   3.625960288603614e-11,   5.924864853590379e-13,  -3.199612468499588e-15,  -4.581963453721297e-16,   1.875639481922438e+00,  -5.482730140905229e-03,
  -1.512717436664272e-04,  -2.701912068145598e-06,  -1.494840071073238e-08,   9.131971775336884e-10,   3.625896745279663e-11,   5.923707742623232e-13,  -3.203504835375407e-15,
  -4.582369910935710e-16,   3.603264377664554e-03,  -4.875589535453586e-05,   4.903803504506677e-07,  -4.488241770976472e-09,   3.727412946217740e-11,  -2.108641481607578e-13,
   6.375157130750902e-15,   5.421751468630276e-17,  -6.926169779900977e-19,  -7.635196238006367e-20,   3.603334226548754e-03,  -4.875781253912253e-05,   4.904122536299009e-07,
  -4.488540536478842e-09,   3.728770253658168e-11,  -2.107083546414326e-13,   6.372200632165818e-15,   5.382734003920564e-17,  -7.021332216979634e-19,  -7.631668963845222e-20,
   3.603448898093933e-03,  -4.876095999988460e-05,   4.904646362286142e-07,  -4.489030850768880e-09,   3.730998026982250e-11,  -2.104534364713909e-13,   6.367319882331761e-15,
   5.318694594910566e-17,  -7.177159586387481e-19,  -7.625743908265375e-20,   3.603570577948484e-03,  -4.876429982401680e-05,   4.905202295841739e-07,  -4.489550898364383e-09,
   3.733361230356786e-11,  -2.101840929107133e-13,   6.362104153913840e-15,   5.250763232417975e-17,  -7.341964352067869e-19,  -7.619274451274835e-20,   3.603666343879288e-03,
  -4.876692837364759e-05,   4.905639900779606e-07,  -4.489960024159001e-09,   3.735220621337059e-11,  -2.099729464951101e-13,   6.357972698670944e-15,   5.197315153035451e-17,
  -7.471275254673215e-19,  -7.614050992522417e-20,   3.603721613571847e-03,  -4.876844539730545e-05,   4.905892484135514e-07,  -4.490196076888655e-09,   3.736293526250782e-11,
  -2.098514217808022e-13,   6.355577688861937e-15,   5.166475007649594e-17,  -7.545746163910373e-19,  -7.610983596123863e-20,   3.603742368136965e-03,  -4.876901506162807e-05,
   4.905987337932129e-07,  -4.490284705376009e-09,   3.736696377492345e-11,  -2.098058507902362e-13,   6.354676324776989e-15,   5.154895328436441e-17,  -7.573681057463560e-19,
  -7.609821778928708e-20,   3.603745808516185e-03,  -4.876910949200514e-05,   4.906003061635535e-07,  -4.490299396201640e-09,   3.736763153992106e-11,  -2.097983000563651e-13,
   6.354526804573236e-15,   5.152975889200080e-17,  -7.578310100279668e-19,  -7.609628664820744e-20,   3.251801850872784e-02,  -4.386168696526403e-04,   4.365901748302220e-06,
  -3.917208278441169e-08,   3.140125357836788e-10,  -1.583365431228017e-12,   5.410280665197669e-14,   5.408194904495060e-16,  -6.770282171062080e-18,  -6.925925843973021e-19,
   3.251864034912104e-02,  -4.386336009897221e-04,   4.366170518255520e-06,  -3.917432291304213e-08,   3.141276797228795e-10,  -1.581805756143644e-12,   5.407402572543612e-14,
   5.372802530195402e-16,  -6.857561093391174e-18,  -6.922705906413669e-19,   3.251966122854685e-02,  -4.386610688764005e-04,   4.366611818595020e-06,  -3.917799886614814e-08,
   3.143166617783525e-10,  -1.579252935688223e-12,   5.402652789219825e-14,   5.314713068499590e-16,  -7.000481185100285e-18,  -6.917296979135200e-19,   3.252074449828493e-02,
  -4.386902153634373e-04,   4.367080168793878e-06,  -3.918189719267514e-08,   3.145171244938120e-10,  -1.576554575825448e-12,   5.397579079486394e-14,   5.253093371253516e-16,
  -7.151637637213844e-18,  -6.911390898463512e-19,   3.252159706460878e-02,  -4.387131544796516e-04,   4.367448832668697e-06,  -3.918496364733504e-08,   3.146748447576257e-10,
  -1.574438466546562e-12,   5.393561599893039e-14,   5.204611364499355e-16,  -7.270241516429983e-18,  -6.906622187779561e-19,   3.252208910826918e-02,  -4.387263933637959e-04,
   4.367661623778077e-06,  -3.918673273855958e-08,   3.147658501350432e-10,  -1.573220230114919e-12,   5.391233250589068e-14,   5.176636733191030e-16,  -7.338546937360110e-18,
  -6.903821786643761e-19,   3.252227387762886e-02,  -4.387313647477690e-04,   4.367741534243322e-06,  -3.918739693290467e-08,   3.148000201371743e-10,  -1.572763339397199e-12,
   5.390357084899761e-14,   5.166132987112627e-16,  -7.364169227347654e-18,  -6.902761088395082e-19,   3.252230450590429e-02,  -4.387321888285296e-04,   4.367754780825695e-06,
  -3.918750702645538e-08,   3.148056841234445e-10,  -1.572687633246282e-12,   5.390211750481491e-14,   5.164391894117513e-16,  -7.368415060127875e-18,  -6.902584781529807e-19,
   9.082813788201229e-02,  -1.217046798690387e-03,   1.184779979730561e-05,  -1.017052254622793e-07,   7.494471449219890e-10,  -2.641484511578980e-12,   1.329367355312501e-13,
   1.778438473781346e-15,  -2.141862414424207e-17,  -1.962767363209725e-18,   9.082982520105440e-02,  -1.217090232011233e-03,   1.184844130940385e-05,  -1.017089411152179e-07,
   7.497298300805207e-10,  -2.636329958641255e-12,   1.328461945057323e-13,   1.768408466572901e-15,  -2.167001243724915e-17,  -1.961855699656434e-18,   9.083259527466585e-02,
  -1.217161535975350e-03,   1.184949462947776e-05,  -1.017150357259262e-07,   7.501937610849105e-10,  -2.627889573159956e-12,   1.326968387032379e-13,   1.751946227502069e-15,
  -2.208167107888175e-17,  -1.960323844802160e-18,   9.083553462702687e-02,  -1.217237196539211e-03,   1.185061252011446e-05,  -1.017214954764387e-07,   7.506858335549164e-10,
  -2.618963087961514e-12,   1.325373863935876e-13,   1.734483539285791e-15,  -2.251706393208861e-17,  -1.958650632777942e-18,   9.083784797807401e-02,  -1.217296742920014e-03,
   1.185149247720857e-05,  -1.017265742012309e-07,   7.510729561074980e-10,  -2.611959191745814e-12,   1.324111924854355e-13,   1.720744002333997e-15,  -2.285869971928295e-17,
  -1.957299248010472e-18,   9.083918308437532e-02,  -1.217331108749293e-03,   1.185200038630307e-05,  -1.017295031782931e-07,   7.512963153999746e-10,  -2.607925641010131e-12,
   1.323380816985262e-13,   1.712816144614814e-15,  -2.305545505283892e-17,  -1.956505500441339e-18,   9.083968443501546e-02,  -1.217344013544668e-03,   1.185219112419244e-05,
  -1.017306026503918e-07,   7.513801782994355e-10,  -2.606412615610950e-12,   1.323105746556143e-13,   1.709839440483974e-15,  -2.312926123751752e-17,  -1.956204826863069e-18,
   9.083976754132131e-02,  -1.217346152703688e-03,   1.185222274241216e-05,  -1.017307848831748e-07,   7.513940792085954e-10,  -2.606161895084019e-12,   1.323060121634040e-13,
   1.709346024269467e-15,  -2.314149158525867e-17,  -1.956154848086855e-18,   1.795338115005066e-01,  -2.379842452522905e-03,   2.231490152549075e-05,  -1.767879073854895e-07,
   1.090326731411900e-09,  -1.032912640265902e-14,   2.150027100194420e-13,   4.192147926839430e-15,  -4.761270017136679e-17,  -4.007201442619877e-18,   1.795369889523280e-01,
  -2.379917926845756e-03,   2.231583508002792e-05,  -1.767878193711686e-07,   1.090783282045966e-09,   1.871763796272057e-15,   2.148022688224517e-13,   4.171669073948904e-15,
  -4.813147184069471e-17,  -4.005396976820209e-18,   1.795422053503330e-01,  -2.380041830114294e-03,   2.231736794192257e-05,  -1.767876624681095e-07,   1.091532468883998e-09,
   2.185730004111926e-14,   2.144717302905564e-13,   4.138056950115824e-15,  -4.898099345815094e-17,  -4.002362203429084e-18,   1.795477404831059e-01,  -2.380173300992713e-03,
   2.231899480871308e-05,  -1.767874791360122e-07,   1.092326984778922e-09,   4.300343654991944e-14,   2.141189927418015e-13,   4.102401858435267e-15,  -4.987951026092533e-17,
  -3.999043728373568e-18,   1.795520967567851e-01,  -2.380276769215800e-03,   2.232027543781126e-05,  -1.767873226754143e-07,   1.092951961200747e-09,   5.960207755931409e-14,
   2.138399333374822e-13,   4.074348447333187e-15,  -5.058455290481920e-17,  -3.996360961153604e-18,   1.795546108856357e-01,  -2.380336482730416e-03,   2.232101462466675e-05,
  -1.767872275041301e-07,   1.093312522023159e-09,   6.916405145583901e-14,   2.136783010948729e-13,   4.058161252705397e-15,  -5.099060663441758e-17,  -3.994784210831908e-18,
   1.795555549732262e-01,  -2.380358905745062e-03,   2.232129221761303e-05,  -1.767871908457424e-07,   1.093447892477636e-09,   7.275137424566871e-14,   2.136174967550893e-13,
   4.052083367443727e-15,  -5.114292499201098e-17,  -3.994186747489627e-18,   1.795557114696380e-01,  -2.380362622680492e-03,   2.232133823372144e-05,  -1.767871847205417e-07,
   1.093470330815873e-09,   7.334585060671070e-14,   2.136074117741796e-13,   4.051075901000910e-15,  -5.116816555834290e-17,  -3.994087425771366e-18,   3.002381383684699e-01,
  -3.915648883189683e-03,   3.458832095329605e-05,  -2.368562805844322e-07,   9.170353970700510e-10,   1.107734828324516e-11,   2.796263626429285e-13,   8.059188803218523e-15,
  -8.383158412397190e-17,  -7.126387593456174e-18,   3.002430621220554e-01,  -3.915749945925594e-03,   3.458910731436963e-05,  -2.368403188028869e-07,   9.176280701095048e-10,
   1.110085087686457e-11,   2.792733704352135e-13,   8.022762772022093e-15,  -8.474864789384241e-17,  -7.123421649339398e-18,   3.002511453421006e-01,  -3.915915851796310e-03,
   3.459039861778484e-05,  -2.368140910225439e-07,   9.186004841820648e-10,   1.113935556528078e-11,   2.786912569905428e-13,   7.962975496401511e-15,  -8.625040191438164e-17,
  -7.118424171475713e-18,   3.002597223743572e-01,  -3.916091883994695e-03,   3.459176928564046e-05,  -2.367862288381772e-07,   9.196315346625298e-10,   1.118010517557732e-11,
   2.780700353079152e-13,   7.899553077004214e-15,  -8.783877288000719e-17,  -7.112947161455048e-18,   3.002664726242437e-01,  -3.916230417367534e-03,   3.459284836678395e-05,
  -2.367642776693448e-07,   9.204424277090222e-10,   1.121209798958598e-11,   2.775785618183111e-13,   7.849651450950711e-15,  -8.908512960587276e-17,  -7.108510691666825e-18,
   3.002703683576972e-01,  -3.916310365723854e-03,   3.459347126920302e-05,  -2.367515998187418e-07,   9.209101892674174e-10,   1.123053066897172e-11,   2.772938947084458e-13,
   7.820857184761033e-15,  -8.980294262215033e-17,  -7.105899851587954e-18,   3.002718312504435e-01,  -3.916340386755676e-03,   3.459370520238965e-05,  -2.367468373840929e-07,
   9.210857966063515e-10,   1.123744646467220e-11,   2.771868052303533e-13,   7.810045592805609e-15,  -9.007220798891971e-17,  -7.104909922920282e-18,   3.002720737461773e-01,
  -3.916345363151841e-03,   3.459374398159511e-05,  -2.367460478487396e-07,   9.211149038307771e-10,   1.123859254773946e-11,   2.771690433788200e-13,   7.808253466538397e-15,
  -9.011682777448656e-17,  -7.104745325362822e-18,   4.552844894972403e-01,  -5.796166682065748e-03,   4.649337370050728e-05,  -2.349574456375597e-07,  -3.789798191115170e-10,
   3.507389455981475e-11,   3.686970008914063e-13,   1.277275999575963e-14,  -1.160047965520705e-16,  -1.191883943709680e-17,   4.552911052041288e-01,  -5.796266813072504e-03,
   4.649305453350289e-05,  -2.349072197407392e-07,  -3.781986990192254e-10,   3.511109188084614e-11,   3.682036989036947e-13,   1.271182522517950e-14,  -1.175077980578018e-16,
  -1.191433965340021e-17,   4.553019659258921e-01,  -5.796431178759166e-03,   4.649253104935627e-05,  -2.348247279451236e-07,  -3.769171415028397e-10,   3.517202577219536e-11,
   3.673895703830579e-13,   1.261180919179202e-14,  -1.199690871940519e-16,  -1.190674118748946e-17,   4.553134899479614e-01,  -5.796605562294770e-03,   4.649197624450470e-05,
  -2.347371463967351e-07,  -3.755583702729846e-10,   3.523650260108848e-11,   3.665198916110716e-13,   1.250570968753895e-14,  -1.225723668602677e-16,  -1.189839172127336e-17,
   4.553225593826950e-01,  -5.796742787727373e-03,   4.649154008223245e-05,  -2.346681821172696e-07,  -3.744897807289707e-10,   3.528711681004223e-11,   3.658312396597049e-13,
   1.242222742875954e-14,  -1.246151200203077e-16,  -1.189161317649966e-17,   4.553277935183327e-01,  -5.796821977062752e-03,   4.649128855361177e-05,  -2.346283666143746e-07,
  -3.738733866161501e-10,   3.531627539813468e-11,   3.654321200125440e-13,   1.237405575459856e-14,  -1.257916095840040e-16,  -1.188761806617841e-17,   4.553297589859518e-01,
  -5.796851712283949e-03,   4.649119413785756e-05,  -2.346134126890650e-07,  -3.736419831654308e-10,   3.532721493624141e-11,   3.652819284063597e-13,   1.235596825587115e-14,
  -1.262329349263650e-16,  -1.188610216977634e-17,   4.553300847902184e-01,  -5.796856641261197e-03,   4.649117848898030e-05,  -2.346109337138162e-07,  -3.736036278289219e-10,
   3.532902780420428e-11,   3.652570152181348e-13,   1.235297007055164e-14,  -1.263060667432598e-16,  -1.188585006063521e-17,   6.479531600737167e-01,  -7.952782491797695e-03,
   5.392033139208069e-05,  -9.300912089188160e-08,  -3.490049944846963e-09,   6.910453519382341e-11,   7.392473126474491e-13,   1.565157664030912e-14,  -1.213103586145751e-16,
  -1.910917739459370e-17,   6.479608273584578e-01,  -7.952821850593922e-03,   5.391736033464057e-05,  -9.291039975133716e-08,  -3.488478354136119e-09,   6.914974846220865e-11,
   7.387134308678546e-13,   1.555388237402193e-14,  -1.237534785505234e-16,  -1.910192639543216e-17,   6.479734141434594e-01,  -7.952886433878738e-03,   5.391248383068342e-05,
  -9.274828716177239e-08,  -3.485899184048838e-09,   6.922376248081383e-11,   7.378299967816079e-13,   1.539353081101481e-14,  -1.277545928390878e-16,  -1.908968601579679e-17,
   6.479867692823983e-01,  -7.952954920209275e-03,   5.390731079791658e-05,  -9.257621096513462e-08,  -3.483163646899415e-09,   6.930201050923566e-11,   7.368831328118768e-13,
   1.522342602972264e-14,  -1.319869427028748e-16,  -1.907624092161565e-17,   6.479972795481308e-01,  -7.953008789239251e-03,   5.390324054567773e-05,  -9.244074114581401e-08,
  -3.481011610466264e-09,   6.936338466619487e-11,   7.361310998339726e-13,   1.508958261889612e-14,  -1.353083019563055e-16,  -1.906532898888598e-17,   6.480033451082524e-01,
  -7.953039866053498e-03,   5.390089190494256e-05,  -9.236254087725067e-08,  -3.479769968664727e-09,   6.939872174465207e-11,   7.356943466171222e-13,   1.501235114930713e-14,
  -1.372213038769458e-16,  -1.905889911609460e-17,   6.480056227637604e-01,  -7.953051533427265e-03,   5.390001003907554e-05,  -9.233317250275388e-08,  -3.479303784361022e-09,
   6.941197545437781e-11,   7.355298239712296e-13,   1.498335228761670e-14,  -1.379389329163552e-16,  -1.905645962831642e-17,   6.480060003165687e-01,  -7.953053467341238e-03,
   5.389986386098777e-05,  -9.232830409524188e-08,  -3.479226511048973e-09,   6.941417161748715e-11,   7.355025247003907e-13,   1.497854543427491e-14,  -1.380578520950890e-16,
  -1.905605392945959e-17,   8.826674472632835e-01,  -1.021570877964681e-02,   4.872439733884896e-05,   3.097854615513474e-07,  -8.374472481101282e-09,   7.760439724148014e-11,
   2.188051639600863e-12,   1.433087996037542e-14,  -1.958541057776867e-16,  -2.800952213405956e-17,   8.826743667771220e-01,  -1.021557613397484e-02,   4.871727324366840e-05,
   3.098962384937692e-07,  -8.369812263813275e-09,   7.764493664014014e-11,   2.187184850248990e-12,   1.418767830813397e-14,  -2.000319701618978e-16,  -2.799911869921769e-17,
   8.826857255507669e-01,  -1.021535834036877e-02,   4.870558076075018e-05,   3.100781375235779e-07,  -8.362163145846872e-09,   7.771117951108414e-11,   2.185749932894248e-12,
   1.395263215883188e-14,  -2.068749435002884e-16,  -2.798150678923223e-17,   8.826977770980501e-01,  -1.021512719793901e-02,   4.869317803584245e-05,   3.102712016626908e-07,
  -8.354048730043363e-09,   7.778104825917895e-11,   2.184211168808373e-12,   1.370328892228774e-14,  -2.141145579494756e-16,  -2.796209550944215e-17,   8.827072610128378e-01,
  -1.021494525390083e-02,   4.868341985176938e-05,   3.104231839913620e-07,  -8.347664018134537e-09,   7.783573123971605e-11,   2.182988439383172e-12,   1.350709797420283e-14,
  -2.197967315763851e-16,  -2.794629531269204e-17,   8.827127340784475e-01,  -1.021484023691562e-02,   4.867778934544024e-05,   3.105109118886156e-07,  -8.343979830193337e-09,
   7.786716797620670e-11,   2.182278089189712e-12,   1.339389005343330e-14,  -2.230698314550454e-16,  -2.793696707998256e-17,   8.827147892147540e-01,  -1.021480079943721e-02,
   4.867567524836654e-05,   3.105438575907256e-07,  -8.342596486035164e-09,   7.787894974828634e-11,   2.182010460098079e-12,   1.335138273437825e-14,  -2.242977418567399e-16,
  -2.793342463523730e-17,   8.827151298801515e-01,  -1.021479426197581e-02,   4.867532481780717e-05,   3.105493189707889e-07,  -8.342367182489398e-09,   7.788090153048821e-11,
   2.181966050048338e-12,   1.334433671697360e-14,  -2.245012237865530e-16,  -2.793283533573687e-17,   1.164807904059962e+00,  -1.213418305267074e-02,   1.404476065938143e-05,
   1.084636805388835e-06,  -9.875443899866860e-09,  -7.910631921858913e-11,   5.613836397036263e-12,   5.023439873734963e-14,  -1.144670663547371e-15,  -4.241896470084405e-17,
   1.164809885912970e+00,  -1.213372039042108e-02,   1.403639612074118e-05,   1.084525466233230e-06,  -9.863516427143622e-09,  -7.895967396237633e-11,   5.609147626274254e-12,
   5.001679209294321e-14,  -1.150850268454963e-15,  -4.243074012246451e-17,   1.164813138596004e+00,  -1.213296088950577e-02,   1.402267171953009e-05,   1.084342834370907e-06,
  -9.843942851552202e-09,  -7.871940223576067e-11,   5.601432606001675e-12,   4.965951922996954e-14,  -1.160968393958997e-15,  -4.244910766778724e-17,   1.164816588790079e+00,
  -1.213215504657651e-02,   1.400811904591642e-05,   1.084149250604880e-06,  -9.823183712835969e-09,  -7.846509443605008e-11,   5.593222435441828e-12,   4.928037767669690e-14,
  -1.171668199364869e-15,  -4.246728830530315e-17,   1.164819303275729e+00,  -1.213152087741701e-02,   1.399667323682639e-05,   1.083997045755510e-06,  -9.806853368457090e-09,
  -7.826541559653815e-11,   5.586743689672165e-12,   4.898195847411901e-14,  -1.180062694650500e-15,  -4.248064980253082e-17,   1.164820869523789e+00,  -1.213115489940032e-02,
   1.399007053068034e-05,   1.083909264053262e-06,  -9.797431700089607e-09,  -7.815036253016880e-11,   5.582997755685423e-12,   4.880972227085780e-14,  -1.184896770020454e-15,
  -4.248798174381984e-17,   1.164821457602262e+00,  -1.213101747354893e-02,   1.398759169580340e-05,   1.083876312236520e-06,  -9.793894317136518e-09,  -7.810719402153612e-11,
   5.581589812985971e-12,   4.874504353369670e-14,  -1.186710018175454e-15,  -4.249066331245509e-17,   1.164821555081351e+00,  -1.213099469338059e-02,   1.398718082229258e-05,
   1.083870850585832e-06,  -9.793307974157467e-09,  -7.810004007302206e-11,   5.581356357399700e-12,   4.873432198575627e-14,  -1.187010484736119e-15,  -4.249110404186136e-17,
   1.497352702441646e+00,  -1.236120947627152e-02,  -8.119422462331201e-05,   1.647501565148764e-06,   1.974740221544718e-08,  -4.459713480307604e-10,  -1.773093326140500e-12,
   3.158689337160062e-13,   1.714573698348084e-15,  -1.969364147338896e-16,   1.497341181771794e+00,  -1.236050833452696e-02,  -8.117738440045174e-05,   1.646874735882065e-06,
   1.974369284024143e-08,  -4.450433312163031e-10,  -1.766687200103504e-12,   3.148700026587922e-13,   1.693985843115366e-15,  -1.965649721413581e-16,   1.497322270455937e+00,
  -1.235935748844181e-02,  -8.114974071389699e-05,   1.645846642068430e-06,   1.973761295824162e-08,  -4.435219925630445e-10,  -1.756229376595986e-12,   3.132314751122677e-13,
   1.660261351121697e-15,  -1.959546477255464e-16,   1.497302206436794e+00,  -1.235813661198479e-02,  -8.112041170057532e-05,   1.644757042101424e-06,   1.973117480962063e-08,
  -4.419106566116760e-10,  -1.745212709098123e-12,   3.114947466493939e-13,   1.624577379073905e-15,  -1.953063083480203e-16,   1.497286417648632e+00,  -1.235717596405419e-02,
  -8.109733183658410e-05,   1.643900452095823e-06,   1.972611738137652e-08,  -4.406446410314702e-10,  -1.736600285910896e-12,   3.101292913053320e-13,   1.596566551331408e-15,
  -1.947955256940989e-16,   1.497277306311790e+00,  -1.235662163077010e-02,  -8.108401288627587e-05,   1.643406470089463e-06,   1.972320240728436e-08,  -4.399148457694209e-10,
  -1.731653007786051e-12,   3.093418054027011e-13,   1.580430078507440e-15,  -1.945005275242836e-16,   1.497273885043019e+00,  -1.235641348736027e-02,  -8.107901165621205e-05,
   1.643221045366678e-06,   1.972210851593998e-08,  -4.396409604491508e-10,  -1.729799621929762e-12,   3.090461996753870e-13,   1.574376177589977e-15,  -1.943897119738652e-16,
   1.497273317925544e+00,  -1.235637898536244e-02,  -8.107818263961444e-05,   1.643190312279482e-06,   1.972192722523232e-08,  -4.395955684795095e-10,  -1.729492626947999e-12,
   3.089972042325592e-13,   1.573372947286940e-15,  -1.943713405558852e-16,   1.851260102962850e+00,  -6.816890165162699e-03,  -1.844377153583086e-04,  -2.761638092938236e-06,
   1.251372508353589e-08,   1.949409352624049e-09,   4.901351523557270e-11,   1.600544343215603e-13,  -2.849425348655311e-14,  -9.641952318494637e-16,   1.851233878793219e+00,
  -6.818059356191983e-03,  -1.844264462124173e-04,  -2.758860625677034e-06,   1.261698654698855e-08,   1.949810278272009e-09,   4.889887936370739e-11,   1.552006924454086e-13,
  -2.854788371038631e-14,  -9.610113384524541e-16,   1.851190828825826e+00,  -6.819977914760801e-03,  -1.844078827922581e-04,  -2.754300583279810e-06,   1.278632951387477e-08,
   1.950458034789877e-09,   4.871053604996344e-11,   1.472443992794571e-13,  -2.863514513063676e-14,  -9.557684800571775e-16,   1.851145151186973e+00,  -6.822012487908391e-03,
  -1.843880996077702e-04,  -2.749461514730552e-06,   1.296577421374645e-08,   1.951131196423968e-09,   4.851048663664514e-11,   1.388183755047461e-13,  -2.872667553109732e-14,
  -9.501838014986846e-16,   1.851109203881464e+00,  -6.823612863570558e-03,  -1.843724679467893e-04,  -2.745652776876078e-06,   1.310682334774279e-08,   1.951650738482729e-09,
   4.835290097520812e-11,   1.321988179573368e-13,  -2.879794332434036e-14,  -9.457730852624604e-16,   1.851088458484990e+00,  -6.824536133289762e-03,  -1.843634216959782e-04,
  -2.743454534792925e-06,   1.318815546565411e-08,   1.951946475472236e-09,   4.826189711389921e-11,   1.283832670313765e-13,  -2.883876615248047e-14,  -9.432213746348350e-16,
   1.851080668476268e+00,  -6.824882766293098e-03,  -1.843600200317693e-04,  -2.742629045806960e-06,   1.321868323213312e-08,   1.952056752979791e-09,   4.822771331639528e-11,
   1.269513837987841e-13,  -2.885403749907087e-14,  -9.422620137511753e-16,   1.851079377175777e+00,  -6.824940222300962e-03,  -1.843594559089621e-04,  -2.742492207759840e-06,
   1.322374294717100e-08,   1.952074992198415e-09,   4.822204628630913e-11,   1.267140758478474e-13,  -2.885656588278836e-14,  -9.421029244168402e-16,   3.415759736969286e-03,
  -4.503841384169823e-05,   4.399887467448457e-07,  -3.916846170674045e-09,   3.468466232745222e-11,  -4.508582378778077e-14,   7.091746643378256e-15,  -2.250471891943935e-17,
  -4.359451889992182e-18,  -1.176525018844331e-19,   3.415822410327227e-03,  -4.504008625878058e-05,   4.400184465368159e-07,  -3.916910986367459e-09,   3.469959426564538e-11,
  -4.516242631728543e-14,   7.074388230240818e-15,  -2.309169553050482e-17,  -4.358938050271975e-18,  -1.170656994496186e-19,   3.415925301858925e-03,  -4.504283182233031e-05,
   4.400672127030819e-07,  -3.917017474489206e-09,   3.472408068542576e-11,  -4.528943936918293e-14,   7.045893536663120e-15,  -2.405313700913312e-17,  -4.358012246981086e-18,
  -1.161019930200859e-19,   3.416034481901772e-03,  -4.504574510499590e-05,   4.401189698028351e-07,  -3.917130579679468e-09,   3.475002628404977e-11,  -4.542591664298583e-14,
   7.015661245185727e-15,  -2.507034315529085e-17,  -4.356918328795500e-18,  -1.150789280382382e-19,   3.416120410192855e-03,  -4.504803789371725e-05,   4.401597119036986e-07,
  -3.917219676472445e-09,   3.477041926413654e-11,  -4.553455858017274e-14,   6.991870387688804e-15,  -2.586874782497446e-17,  -4.355976801925866e-18,  -1.142734194151637e-19,
   3.416170002302091e-03,  -4.504936111492574e-05,   4.401832285686557e-07,  -3.917271129191376e-09,   3.478217789291828e-11,  -4.559775178952009e-14,   6.978141099665310e-15,
  -2.632866400961980e-17,  -4.355401173483922e-18,  -1.138084070007142e-19,   3.416188624861378e-03,  -4.504985799916073e-05,   4.401920599907062e-07,  -3.917290456499063e-09,
   3.478659137929301e-11,  -4.562157472627045e-14,   6.972985785985378e-15,  -2.650120477430907e-17,  -4.355178929517033e-18,  -1.136337645694272e-19,   3.416191711829228e-03,
  -4.504994036491481e-05,   4.401935239612153e-07,  -3.917293660609845e-09,   3.478732287255490e-11,  -4.562552863688385e-14,   6.972131228042073e-15,  -2.652979731131035e-17,
  -4.355141768300846e-18,  -1.136048137427303e-19,   3.083054639264445e-02,  -4.054864299523204e-04,   3.925177757076784e-06,  -3.432629399979417e-08,   2.963187455977912e-10,
  -1.543556336542038e-13,   6.174887934029587e-14,  -1.718356396122869e-16,  -4.013133727370727e-17,  -1.072173169317209e-18,   3.083110548456254e-02,  -4.055010853990295e-04,
   3.925431502188782e-06,  -3.432651879153055e-08,   2.964486572876399e-10,  -1.549543414269545e-13,   6.158907581250444e-14,  -1.771844622942733e-16,  -4.012703839683192e-17,
  -1.066813585566517e-18,   3.083202335067537e-02,  -4.055251447580077e-04,   3.925848145440006e-06,  -3.432688847469674e-08,   2.966616818676594e-10,  -1.559486768047618e-13,
   6.132674914641059e-14,  -1.859455487243464e-16,  -4.011922903178756e-17,  -1.058011467836516e-18,   3.083299731323932e-02,  -4.055506736945884e-04,   3.926290344210465e-06,
  -3.432728162850415e-08,   2.968873824360493e-10,  -1.570192946014810e-13,   6.104842414083514e-14,  -1.952147246506124e-16,  -4.010992256554093e-17,  -1.048667102634729e-18,
   3.083376385273161e-02,  -4.055707651723275e-04,   3.926638435153972e-06,  -3.432759169305252e-08,   2.970647674516277e-10,  -1.578731173557073e-13,   6.082939910317733e-14,
  -2.024900508739770e-16,  -4.010186129384047e-17,  -1.041309766453669e-18,   3.083420624801968e-02,  -4.055823603853031e-04,   3.926839356564133e-06,  -3.432777089975076e-08,
   2.971670426042152e-10,  -1.583703749870437e-13,   6.070300307318349e-14,  -2.066809400471971e-16,  -4.009691405264403e-17,  -1.037062420821261e-18,   3.083437237380737e-02,
  -4.055867145084294e-04,   3.926914810468831e-06,  -3.432783824343850e-08,   2.972054295681457e-10,  -1.585579499603427e-13,   6.065554158020970e-14,  -2.082531778398990e-16,
  -4.009500063221412e-17,  -1.035467261167255e-18,   3.083439991163785e-02,  -4.055874362669439e-04,   3.926927318345663e-06,  -3.432784940925016e-08,   2.972117917876417e-10,
  -1.585890880094814e-13,   6.064767423699641e-14,  -2.085137205314636e-16,  -4.009468051940773e-17,  -1.035202828088814e-18,   8.614206989173094e-02,  -1.126945215161013e-03,
   1.069814303129799e-05,  -8.994876310376800e-08,   7.318396968790898e-10,   9.932862267605719e-13,   1.604528818230628e-13,  -3.173790423735743e-16,  -1.163932101344899e-16,
  -3.060390950491655e-18,   8.614359357655521e-02,  -1.126983611315158e-03,   1.069876981490634e-05,  -8.994735986619978e-08,   7.321766955817365e-10,   9.920946243668689e-13,
   1.599893583627546e-13,  -3.326454946639038e-16,  -1.163828466781421e-16,  -3.045051088420816e-18,   8.614609501663971e-02,  -1.127046644387735e-03,   1.069979898789641e-05,
  -8.994505755102665e-08,   7.327292185193916e-10,   9.901057091139316e-13,   1.592284517923485e-13,  -3.576509684784519e-16,  -1.163636750023816e-16,  -3.019857833051022e-18,
   8.614874932606127e-02,  -1.127113526767578e-03,   1.070089130006636e-05,  -8.994261643769861e-08,   7.333145163952325e-10,   9.879509320588994e-13,   1.584211318673754e-13,
  -3.841063865415803e-16,  -1.163404046209626e-16,  -2.993112038405027e-18,   8.615083834536633e-02,  -1.127166163130952e-03,   1.070175115808436e-05,  -8.994069660152608e-08,
   7.337744454223852e-10,   9.862230287571450e-13,   1.577858134949037e-13,  -4.048709408197345e-16,  -1.163199753999386e-16,  -2.972053211337762e-18,   8.615204398485136e-02,
  -1.127196540436841e-03,   1.070224748011051e-05,  -8.993958916552864e-08,   7.340395974811128e-10,   9.852129791894054e-13,   1.574191784141129e-13,  -4.168321191043516e-16,
  -1.163073388478947e-16,  -2.959895925241010e-18,   8.615249671930478e-02,  -1.127207947385396e-03,   1.070243386929746e-05,  -8.993917341473842e-08,   7.341391114207487e-10,
   9.848312701897197e-13,   1.572815070995280e-13,  -4.213194162406121e-16,  -1.163024338845492e-16,  -2.955330030114633e-18,   8.615257176677600e-02,  -1.127209838248714e-03,
   1.070246476678172e-05,  -8.993910450351182e-08,   7.341556044691466e-10,   9.847678685623260e-13,   1.572586863117579e-13,  -4.220630260538335e-16,  -1.163016123901287e-16,
  -2.954573130248631e-18,   1.703584654120563e-01,  -2.209510506245931e-03,   2.029911678158656e-05,  -1.590290812263966e-07,   1.149693140302219e-09,   6.231088726904124e-12,
   2.851045990832610e-13,  -2.181405655567999e-16,  -2.421812558636553e-16,  -6.284503755341670e-18,   1.703613561064399e-01,  -2.209578367976672e-03,   2.030010181776044e-05,
  -1.590202241025183e-07,   1.150290270444696e-09,   6.229937554251230e-12,   2.841400380781151e-13,  -2.494903831848836e-16,  -2.421644845972240e-16,  -6.253012160522822e-18,
   1.703661017511065e-01,  -2.209689771263497e-03,   2.030171927898067e-05,  -1.590056850908683e-07,   1.151269068344203e-09,   6.227980553677920e-12,   2.825566288929299e-13,
  -3.008394058707215e-16,  -2.421324972704358e-16,  -6.201291009806916e-18,   1.703711373855517e-01,  -2.209807975055530e-03,   2.030343602580935e-05,  -1.589902600034016e-07,
   1.152305626503787e-09,   6.225812881226812e-12,   2.808766166854246e-13,  -3.551659351029952e-16,  -2.420925136840003e-16,  -6.146380807532039e-18,   1.703751005567449e-01,
  -2.209900999378516e-03,   2.030478747292060e-05,  -1.589781218036527e-07,   1.153119939257584e-09,   6.224041029939618e-12,   2.795545214451948e-13,  -3.978062244804790e-16,
  -2.420566805264372e-16,  -6.103144934910550e-18,   1.703773878205987e-01,  -2.209954684459168e-03,   2.030556756298419e-05,  -1.589711171921987e-07,   1.153589308263142e-09,
   6.222992087095073e-12,   2.787915495846494e-13,  -4.223686709391424e-16,  -2.420342534599537e-16,  -6.078184315746202e-18,   1.703782467185305e-01,  -2.209974843537583e-03,
   2.030586052166944e-05,  -1.589684870019103e-07,   1.153765450081853e-09,   6.222593218153124e-12,   2.785050529237210e-13,  -4.315833994870276e-16,  -2.420255020206892e-16,
  -6.068809796528715e-18,   1.703783890935583e-01,  -2.209978185182664e-03,   2.030590908519462e-05,  -1.589680510161042e-07,   1.153794642258613e-09,   6.222526837278541e-12,
   2.784575623684393e-13,  -4.331104128899389e-16,  -2.420240339518977e-16,  -6.067255754053441e-18,   2.851113326428104e-01,  -3.650042429817849e-03,   3.184276227906225e-05,
  -2.199788561280822e-07,   1.221256688512112e-09,   1.991757744874210e-11,   4.216124674401933e-13,   2.465611340614103e-16,  -4.296234752023583e-16,  -1.117711366965718e-17,
   2.851158662088701e-01,  -3.650136243510892e-03,   3.184381001562224e-05,  -2.199505140370388e-07,   1.222136340311913e-09,   1.991742612074186e-11,   4.199012126047783e-13,
   1.907935233454557e-16,  -4.296008716927194e-16,  -1.112153054928079e-17,   2.851233089000624e-01,  -3.650290245131010e-03,   3.184553058121238e-05,  -2.199039864301868e-07,
   1.223577791346334e-09,   1.991705820647811e-11,   4.170920213484237e-13,   9.944810213514583e-17,  -4.295558348536631e-16,  -1.103023867739962e-17,   2.851312063185640e-01,
  -3.650453640875010e-03,   3.184735696249237e-05,  -2.198546178201899e-07,   1.225103694767682e-09,   1.991650567540612e-11,   4.141114149626554e-13,   2.803791155324405e-18,
  -4.294972907032367e-16,  -1.093331341799327e-17,   2.851374217355503e-01,  -3.650582225584873e-03,   3.184879486070137e-05,  -2.198157650796861e-07,   1.226301991404261e-09,
   1.991595362472946e-11,   4.117657896233298e-13,  -7.305282315418976e-17,  -4.294434440588965e-16,  -1.085699199059893e-17,   2.851410088171821e-01,  -3.650656430888389e-03,
   3.184962491070947e-05,  -2.197933426671841e-07,   1.226992510702586e-09,   1.991558810682917e-11,   4.104121377169027e-13,  -1.167497788367134e-16,  -4.294092579335512e-16,
  -1.081292937228372e-17,   2.851423558101235e-01,  -3.650684295066248e-03,   3.184993664256390e-05,  -2.197849228802360e-07,   1.227251610786625e-09,   1.991544199063587e-11,
   4.099038386196576e-13,  -1.331430361339987e-16,  -4.293958334755958e-16,  -1.079638042677466e-17,   2.851425790939124e-01,  -3.650688913918201e-03,   3.184998831868096e-05,
  -2.197835271828191e-07,   1.227294549953388e-09,   1.991541730253356e-11,   4.098195813399963e-13,  -1.358596415420169e-16,  -4.293935772159563e-16,  -1.079363704509274e-17,
   4.328257893536479e-01,  -5.435543742995335e-03,   4.366251015619663e-05,  -2.348201768982946e-07,   4.358711554611088e-10,   4.733512150205443e-11,   5.974669191070885e-13,
   5.108854087520086e-16,  -6.918696863417852e-16,  -1.860147305739191e-17,   4.328320036122730e-01,  -5.435643754927368e-03,   4.366288934627547e-05,  -2.347528164828972e-07,
   4.371137773016923e-10,   4.733516938698003e-11,   5.947108572415260e-13,   4.180327885952681e-16,  -6.918452233139748e-16,  -1.851052325220768e-17,   4.328422053639608e-01,
  -5.435807919920267e-03,   4.366351260464199e-05,  -2.346422340199735e-07,   4.391494905633796e-10,   4.733504902886066e-11,   5.901864811905847e-13,   2.659375419739164e-16,
  -6.917919513570316e-16,  -1.836113613385295e-17,   4.328530302660137e-01,  -5.435982083425469e-03,   4.366417495662893e-05,  -2.345248983530999e-07,   4.413037615601679e-10,
   4.733465130398616e-11,   5.853859869439896e-13,   1.050113774690528e-16,  -6.917176383190918e-16,  -1.820252037492407e-17,   4.328615495607047e-01,  -5.436119130572892e-03,
   4.366469697334546e-05,  -2.344325552861467e-07,   4.429950007819434e-10,   4.733414310804190e-11,   5.816081470697612e-13,  -2.130616922187970e-17,  -6.916463008689574e-16,
  -1.807761480442438e-17,   4.328664662282637e-01,  -5.436198214965715e-03,   4.366499853654786e-05,  -2.343792626136410e-07,   4.439693711524724e-10,   4.733377168216596e-11,
   5.794279570017704e-13,  -9.407329905776758e-17,  -6.915999871549357e-16,  -1.800550013749217e-17,   4.328683124888491e-01,  -5.436227910392540e-03,   4.366511183264880e-05,
  -2.343592507485437e-07,   4.443349399782742e-10,   4.733361745184956e-11,   5.786092887973699e-13,  -1.213728998974190e-16,  -6.915816247396156e-16,  -1.797841489925642e-17,
   4.328686185331277e-01,  -5.436232832752869e-03,   4.366513061605872e-05,  -2.343559334988847e-07,   4.443955215241040e-10,   4.733359110781195e-11,   5.784735836228662e-13,
  -1.258968710304650e-16,  -6.915785296984657e-16,  -1.797392484653436e-17,   6.169964937383368e-01,  -7.526721594005428e-03,   5.251827700932361e-05,  -1.366972703534043e-07,
  -1.900384501715745e-09,   9.092831665704564e-11,   9.995659836026485e-13,  -1.979729860696082e-15,  -1.048671102772327e-15,  -3.007708613611554e-17,   6.170039642358190e-01,
  -7.526779496204549e-03,   5.251666616024953e-05,  -1.365679450041441e-07,  -1.898300452759812e-09,   9.092000796115664e-11,   9.953874808407847e-13,  -2.129928768287432e-15,
  -1.048689237300902e-15,  -2.993241299639189e-17,   6.170162281030332e-01,  -7.526874512150174e-03,   5.251402296108319e-05,  -1.363556460449809e-07,  -1.894885595591264e-09,
   9.090604599616146e-11,   9.885278605229042e-13,  -2.375967831466553e-15,  -1.048697979191504e-15,  -2.969476799119355e-17,   6.170292407919976e-01,  -7.526975277206927e-03,
   5.251122004671934e-05,  -1.361303935752175e-07,  -1.891270929381557e-09,   9.089079442483862e-11,   9.812493989834305e-13,  -2.636304529347475e-15,  -1.048678726177290e-15,
  -2.944242024746202e-17,   6.170394816859243e-01,  -7.527054540591588e-03,   5.250901538506692e-05,  -1.359531283486690e-07,  -1.888432511298882e-09,   9.087847556876145e-11,
   9.755213285289765e-13,  -2.840662297495822e-15,  -1.048642958563518e-15,  -2.924368754736714e-17,   6.170453918416801e-01,  -7.527100269310171e-03,   5.250774353088343e-05,
  -1.358508290351653e-07,  -1.886796947355653e-09,   9.087123969675277e-11,   9.722156025027934e-13,  -2.958389211176937e-15,  -1.048614065982900e-15,  -2.912894222766311e-17,
   6.170476111517693e-01,  -7.527117437925522e-03,   5.250726603127094e-05,  -1.358124153712131e-07,  -1.886183257410731e-09,   9.086849867990990e-11,   9.709742810023187e-13,
  -3.002556768950760e-15,  -1.048601658704167e-15,  -2.908584433608758e-17,   6.170479790335416e-01,  -7.527120283712416e-03,   5.250718688384742e-05,  -1.358060477960332e-07,
  -1.886081554870734e-09,   9.086804305810221e-11,   9.707685148267404e-13,  -3.009876059841190e-15,  -1.048599519876414e-15,  -2.907869972461676e-17,   8.426047099795113e-01,
  -9.813184680742982e-03,   5.169864725698743e-05,   1.911738246444231e-07,  -6.273011578806261e-09,   1.331165407282792e-10,   2.315349101116352e-12,  -1.279333673945050e-14,
  -1.618754446768131e-15,  -4.732163218582740e-17,   8.426120563615662e-01,  -9.813102396507626e-03,   5.169331861278419e-05,   1.913629012860205e-07,  -6.268145905613014e-09,
   1.330745467820621e-10,   2.308893264123251e-12,  -1.302951997214228e-14,  -1.619063458761876e-15,  -4.708914668414012e-17,   8.426241160933294e-01,  -9.812967255356147e-03,
   5.168457375908958e-05,   1.916732564491753e-07,  -6.260168078469557e-09,   1.330051008384156e-10,   2.298294268737844e-12,  -1.341639021251194e-14,  -1.619536568411910e-15,
  -4.670722958754344e-17,   8.426369116625928e-01,  -9.812823780973614e-03,   5.167529883760933e-05,   1.920025061701336e-07,  -6.251716528112561e-09,   1.329307265362544e-10,
   2.287047025829180e-12,  -1.382571637788428e-14,  -1.619992195306761e-15,  -4.630164517409196e-17,   8.426469813084969e-01,  -9.812710808561071e-03,   5.166800235109574e-05,
   1.922615829746784e-07,  -6.245074917855588e-09,   1.328716971199543e-10,   2.278194784641012e-12,  -1.414700850742355e-14,  -1.620317258820458e-15,  -4.598220528909225e-17,
   8.426527924839060e-01,  -9.812645586998195e-03,   5.166379257783465e-05,   1.924110833713465e-07,  -6.241245844856644e-09,   1.328374313527257e-10,   2.273085755748401e-12,
  -1.433209174513882e-14,  -1.620491444548317e-15,  -4.579775425584049e-17,   8.426549745975868e-01,  -9.812621091310602e-03,   5.166221198748920e-05,   1.924672188661807e-07,
  -6.239808732722249e-09,   1.328245266846002e-10,   2.271167223264681e-12,  -1.440152792442412e-14,  -1.620554319941996e-15,  -4.572847306347100e-17,   8.426553363120287e-01,
  -9.812617030570694e-03,   5.166194999369124e-05,   1.924765239488718e-07,  -6.239570550004568e-09,   1.328223855719436e-10,   2.270849196903928e-12,  -1.441303456639338e-14,
  -1.620564608867186e-15,  -4.571698776861983e-17,   1.116574432080703e+00,  -1.197251920183314e-02,   2.608494499673048e-05,   9.216761667597612e-07,  -1.002468049776153e-08,
   6.668617973860654e-11,   6.225174262724200e-12,  -1.806859756428185e-14,  -3.311972107489774e-15,  -7.266114400132535e-17,   1.116578127097865e+00,  -1.197212538460077e-02,
   2.607645980428887e-05,   9.217705562613922e-07,  -1.001154907416633e-08,   6.662641553179987e-11,   6.211967174390799e-12,  -1.843075814224470e-14,  -3.312520311154156e-15,
  -7.228593717845118e-17,   1.116584192205847e+00,  -1.197147884085476e-02,   2.606253804130028e-05,   9.219254480461860e-07,  -9.990012097895806e-09,   6.652752722231471e-11,
   6.190284368600559e-12,  -1.902391014959262e-14,  -3.313359864135580e-15,  -7.166945886502732e-17,   1.116590626584886e+00,  -1.197079276853359e-02,   2.604777691344157e-05,
   9.220897129781944e-07,  -9.967187401485316e-09,   6.642154650548815e-11,   6.167275655339466e-12,  -1.965139579367569e-14,  -3.314168721324157e-15,  -7.101463576691906e-17,
   1.116595689628758e+00,  -1.197025279746683e-02,   2.603616774271661e-05,   9.222189268501152e-07,  -9.949244301627774e-09,   6.633737832862790e-11,   6.149166607377396e-12,
  -2.014385785042695e-14,  -3.314746048856847e-15,  -7.049879243179801e-17,   1.116598611271280e+00,  -1.196994115816609e-02,   2.602947103400826e-05,   9.222934731391378e-07,
  -9.938897027531051e-09,   6.628849869116437e-11,   6.138715117423123e-12,  -2.042751693341628e-14,  -3.315055520809585e-15,  -7.020089335400145e-17,   1.116599708313020e+00,
  -1.196982413234795e-02,   2.602695695238532e-05,   9.223214611669023e-07,  -9.935013042824980e-09,   6.627008639157507e-11,   6.134790405525182e-12,  -2.053392967806985e-14,
  -3.315167252291162e-15,  -7.008899254878192e-17,   1.116599890160011e+00,  -1.196980473352948e-02,   2.602654023896973e-05,   9.223261003271956e-07,  -9.934369296932192e-09,
   6.626703125672030e-11,   6.134139824544826e-12,  -2.055156362320707e-14,  -3.315185537232095e-15,  -7.007044145700727e-17,   1.446740655788086e+00,  -1.292698973682382e-02,
  -5.982200020871151e-05,   1.892819256790993e-06,   1.112016315528080e-08,  -3.835250529789100e-10,   6.623176473726532e-12,   2.374317562123232e-13,  -7.017341851435443e-15,
  -2.617998396324992e-16,   1.446732161930227e+00,  -1.292618355715887e-02,  -5.981242725908417e-05,   1.892279267801564e-06,   1.113397043728877e-08,  -3.828363962645022e-10,
   6.595329715898234e-12,   2.361203076663359e-13,  -7.011911443459720e-15,  -2.606913429447177e-16,   1.446718218884547e+00,  -1.292486024800366e-02,  -5.979670329647478e-05,
   1.891393488120883e-06,   1.115659442442964e-08,  -3.817086681262768e-10,   6.549630945491991e-12,   2.339714590999984e-13,  -7.002900531403168e-15,  -2.588713068548112e-16,
   1.446703425590379e+00,  -1.292345633916485e-02,  -5.978000753255174e-05,   1.890454556706461e-06,   1.118054193150246e-08,  -3.805158800709219e-10,   6.501163171981420e-12,
   2.316969461828291e-13,  -6.993208933439494e-15,  -2.569397725392640e-16,   1.446691784171483e+00,  -1.292235161794808e-02,  -5.976685961845098e-05,   1.889716298821362e-06,
   1.119934655156246e-08,  -3.795799105951787e-10,   6.463034938274521e-12,   2.299109340642717e-13,  -6.985487373888139e-15,  -2.554194155492320e-16,   1.446685066074487e+00,
  -1.292171412680637e-02,  -5.975926839278537e-05,   1.889290510364308e-06,   1.121018215578364e-08,  -3.790408497923298e-10,   6.441036905300021e-12,   2.288818116886897e-13,
  -6.980993387770655e-15,  -2.545419003060577e-16,   1.446682543436649e+00,  -1.292147475483973e-02,  -5.975641718738566e-05,   1.889130674419413e-06,   1.121424783723786e-08,
  -3.788386358987017e-10,   6.432777661461934e-12,   2.284956722396485e-13,  -6.979298726653538e-15,  -2.542123685967008e-16,   1.446682125277243e+00,  -1.292143507615854e-02,
  -5.975594452633557e-05,   1.889104182058078e-06,   1.121492161355847e-08,  -3.788051270627713e-10,   6.431408638907963e-12,   2.284316802545014e-13,  -6.979017436592217e-15,
  -2.541577431673292e-16,   1.820840887859144e+00,  -8.418169882741054e-03,  -2.148836409600779e-04,  -2.186356266495683e-06,   6.295394043498233e-08,   3.043020101982043e-09,
   3.528535314209267e-11,  -1.327113009779886e-12,  -6.301929952513813e-14,  -6.937941233789724e-16,   1.820810417262387e+00,  -8.419088114183296e-03,  -2.148294794071232e-04,
  -2.182059793567083e-06,   6.302633293054592e-08,   3.039002363522677e-09,   3.503836525637707e-11,  -1.330385088298374e-12,  -6.282130780880706e-14,  -6.832385646626820e-16,
   1.820760400480461e+00,  -8.420594221965784e-03,  -2.147405207010927e-04,  -2.175010591460715e-06,   6.314479806368888e-08,   3.032399710599566e-09,   3.463346794842173e-11,
  -1.335717985062910e-12,  -6.249573495468299e-14,  -6.659543699855640e-16,   1.820707336468371e+00,  -8.422190528522442e-03,  -2.146460693037792e-04,  -2.167536492007001e-06,
   6.326998430431745e-08,   3.025384473892642e-09,   3.420462057404847e-11,  -1.341324027379968e-12,  -6.214955311787381e-14,  -6.476750265065404e-16,   1.820665580359271e+00,
  -8.423445534569841e-03,  -2.145716926976234e-04,  -2.161658429315508e-06,   6.336813446094847e-08,   3.019856739681186e-09,   3.386768079846255e-11,  -1.345698018981103e-12,
  -6.187658718925872e-14,  -6.333329801677510e-16,   1.820641484316396e+00,  -8.424169303942705e-03,  -2.145287513562200e-04,  -2.158267725986883e-06,   6.342462981658727e-08,
   3.016663899837060e-09,   3.367345310183936e-11,  -1.348207129040830e-12,  -6.171884684798297e-14,  -6.250735229925977e-16,   1.820632436433156e+00,  -8.424440988434813e-03,
  -2.145126232183548e-04,  -2.156994793564075e-06,   6.344581623328103e-08,   3.015464452271724e-09,   3.360056156992878e-11,  -1.349146453523041e-12,  -6.165957497521252e-14,
  -6.219753475218949e-16,   1.820630936639182e+00,  -8.424486018853294e-03,  -2.145099495779696e-04,  -2.156783803172010e-06,   6.344932670037421e-08,   3.015265600091092e-09,
   3.358848101891486e-11,  -1.349302008595979e-12,  -6.164974777156222e-14,  -6.214619564807848e-16,   3.242361522616782e-03,  -4.169708909063752e-05,   3.963151444468452e-07,
  -3.360404169551551e-09,   3.533645079833191e-11,   9.806685073522132e-14,   3.917106038432378e-15,  -2.217273662704230e-16,  -7.558673342765024e-18,  -2.570568600547622e-20,
   3.242417981939697e-03,  -4.169852324913633e-05,   3.963453614920414e-07,  -3.360270222427671e-09,   3.534446363710630e-11,   9.740265021593478e-14,   3.887672166483952e-15,
  -2.218298074296123e-16,  -7.525681089806867e-18,  -2.461012370712512e-20,   3.242510672173744e-03,  -4.170087761247377e-05,   3.963949724983362e-07,  -3.360051010343255e-09,
   3.535757296115208e-11,   9.631205517702209e-14,   3.839446666865335e-15,  -2.219939730732755e-16,  -7.471527801881803e-18,  -2.281802071241495e-20,   3.242609027914288e-03,
  -4.170337571977809e-05,   3.964476201683478e-07,  -3.359819338823400e-09,   3.537142182399143e-11,   9.515457919509571e-14,   3.788404733906352e-15,  -2.221627312413500e-16,
  -7.414079550515940e-18,  -2.092521090717432e-20,   3.242686437467942e-03,  -4.170534170423340e-05,   3.964890588976746e-07,  -3.359637685144909e-09,   3.538227674556503e-11,
   9.424344746655332e-14,   3.748327887059255e-15,  -2.222916205159076e-16,  -7.368877020442440e-18,  -1.944189301675656e-20,   3.242731113265345e-03,  -4.170647629665524e-05,
   3.965129758933634e-07,  -3.359533119063274e-09,   3.538852363377295e-11,   9.371753976176715e-14,   3.725236199179109e-15,  -2.223644353662424e-16,  -7.342793728140199e-18,
  -1.858837935727309e-20,   3.242747889704069e-03,  -4.170690234443731e-05,   3.965219573207250e-07,  -3.359493904459561e-09,   3.539086605953362e-11,   9.352004201265099e-14,
   3.716572117566467e-15,  -2.223914817848136e-16,  -7.332999960475808e-18,  -1.826835614185923e-20,   3.242750670651190e-03,  -4.170697296779976e-05,   3.965234461397248e-07,
  -3.359487406768227e-09,   3.539125417384087e-11,   9.348730318945099e-14,   3.715136295343818e-15,  -2.223959494954557e-16,  -7.331376544234102e-18,  -1.821533301500436e-20,
   2.926890883032783e-02,  -3.756518030692653e-04,   3.541856054706157e-06,  -2.953406056634328e-08,   3.067657703822175e-10,   1.090816790338119e-12,   3.356608218551437e-14,
  -2.000569843940511e-15,  -6.930644465567445e-17,  -2.344495197510025e-19,   2.926941338998150e-02,  -3.756644065153709e-04,   3.542118371096671e-06,  -2.953255886516783e-08,
   3.068342236549633e-10,   1.084823798394297e-12,   3.329617222891379e-14,  -2.001503293597442e-15,  -6.900523930575421e-17,  -2.244249909743727e-19,   2.927024173337909e-02,
  -3.756850966610338e-04,   3.542549047152035e-06,  -2.953009974950345e-08,   3.069461876771510e-10,   1.074983488729680e-12,   3.285393835805344e-14,  -2.002999026914923e-15,
  -6.851083967146370e-17,  -2.080269266877170e-19,   2.927112070653818e-02,  -3.757070498930462e-04,   3.543006083654213e-06,  -2.952749882403170e-08,   3.070644294489568e-10,
   1.064539697310487e-12,   3.238587223576490e-14,  -2.004536390092898e-15,  -6.798635422373045e-17,  -1.907072373625047e-19,   2.927181248967516e-02,  -3.757243267600020e-04,
   3.543365814163445e-06,  -2.952545795468066e-08,   3.071570809517212e-10,   1.056318629616067e-12,   3.201835467050233e-14,  -2.005710394183078e-15,  -6.757366568332502e-17,
  -1.771344020312475e-19,   2.927221174193103e-02,  -3.757342974008602e-04,   3.543573437825425e-06,  -2.952428256353605e-08,   3.072103896336815e-10,   1.051573400735985e-12,
   3.180659495660650e-14,  -2.006373571742720e-15,  -6.733553016588897e-17,  -1.693244374718928e-19,   2.927236166714197e-02,  -3.757380414422459e-04,   3.543651405623508e-06,
  -2.952384165264131e-08,   3.072303769177497e-10,   1.049791391018639e-12,   3.172714168874222e-14,  -2.006619890398976e-15,  -6.724611470538433e-17,  -1.663960994892410e-19,
   2.927238651949817e-02,  -3.757386620689355e-04,   3.543664330062768e-06,  -2.952376858962602e-08,   3.072336884794817e-10,   1.049495990623032e-12,   3.171397458069185e-14,
  -2.006660578308397e-15,  -6.723129317521992e-17,  -1.659109166733673e-19,   8.179890788288006e-02,  -1.045475732174105e-03,   9.690318547637050e-06,  -7.788303169170959e-08,
   7.869024352424394e-10,   4.219664774268211e-12,   8.401643048416172e-14,  -5.597951223023919e-15,  -1.997971216339368e-16,  -6.722504992191146e-19,   8.180028823949882e-02,
  -1.045508961470741e-03,   9.690991398926556e-06,  -7.787716842701137e-08,   7.870725587991825e-10,   4.202894349288362e-12,   8.323819847367480e-14,  -5.600626082951532e-15,
  -1.989352626082121e-16,  -6.434444696871637e-19,   8.180255438771533e-02,  -1.045563510964693e-03,   9.692096095319817e-06,  -7.786756019472496e-08,   7.873506529740882e-10,
   4.175357701365516e-12,   8.196308560077939e-14,  -5.604911905365610e-15,  -1.975205860592488e-16,  -5.963231536436043e-19,   8.180495904049406e-02,  -1.045621389785493e-03,
   9.693268401949968e-06,  -7.785738858585192e-08,   7.876441155761459e-10,   4.146132136004621e-12,   8.061346370301669e-14,  -5.609316598187612e-15,  -1.960197978156291e-16,
  -5.465526729294928e-19,   8.180685158320364e-02,  -1.045666938980281e-03,   9.694191113304743e-06,  -7.784940046995857e-08,   7.878739032184669e-10,   4.123126452652181e-12,
   7.955374487225237e-14,  -5.612679922584128e-15,  -1.948388933643491e-16,  -5.075487148233560e-19,   8.180794383400337e-02,  -1.045693225614037e-03,   9.694723668003244e-06,
  -7.784479718469819e-08,   7.880060501225295e-10,   4.109847446684235e-12,   7.894313866253714e-14,  -5.614579686810295e-15,  -1.941574638597299e-16,  -4.851051630608979e-19,
   8.180835399021795e-02,  -1.045703096374709e-03,   9.694923655123629e-06,  -7.784306989304721e-08,   7.880555841996211e-10,   4.104860678166841e-12,   7.871403484603147e-14,
  -5.615285276088234e-15,  -1.939015984424666e-16,  -4.766899338321176e-19,   8.180842197975456e-02,  -1.045704732587633e-03,   9.694956806248632e-06,  -7.784278363766795e-08,
   7.880637905200289e-10,   4.104034030493254e-12,   7.867606736241734e-14,  -5.615401826853217e-15,  -1.938591860551325e-16,  -4.752956510343143e-19,   1.618335799579723e-01,
  -2.054426448099060e-03,   1.850640584365800e-05,  -1.392856752690248e-07,   1.336862969486310e-09,   1.192524613864087e-11,   1.388255145341934e-13,  -1.116838675228044e-14,
  -4.139042444469583e-16,  -1.400345208805476e-18,   1.618362158541127e-01,  -2.054485853323206e-03,   1.850754887746051e-05,  -1.392689873639030e-07,   1.337140206056219e-09,
   1.189178387216223e-11,   1.372130130885339e-13,  -1.117397108682816e-14,  -4.121332356581499e-16,  -1.340806814921425e-18,   1.618405432221703e-01,  -2.054583371532709e-03,
   1.850942551754279e-05,  -1.392416259185010e-07,   1.337592866463526e-09,   1.183683911038298e-11,   1.345709293081374e-13,  -1.118292082825502e-14,  -4.092261993705964e-16,
  -1.243411263751444e-18,   1.618451350544612e-01,  -2.054686838991919e-03,   1.851141700128514e-05,  -1.392126401385842e-07,   1.338069823837863e-09,   1.177852372912160e-11,
   1.317744025803906e-13,  -1.119212182590579e-14,  -4.061421312535974e-16,  -1.140537699653219e-18,   1.618487489666967e-01,  -2.054768263436319e-03,   1.851298447068079e-05,
  -1.391898620869423e-07,   1.338442769472821e-09,   1.173261874463735e-11,   1.295785371331373e-13,  -1.119914975606930e-14,  -4.037153557725692e-16,  -1.059916351332331e-18,
   1.618508346726544e-01,  -2.054815253076792e-03,   1.851388915233379e-05,  -1.391767300219684e-07,   1.338657033818401e-09,   1.170612194839362e-11,   1.283132706335591e-13,
  -1.120312039128218e-14,  -4.023149854555651e-16,  -1.013524734460531e-18,   1.618516178847783e-01,  -2.054832897776476e-03,   1.851422888144006e-05,  -1.391718013705729e-07,
   1.338737309027347e-09,   1.169617136477490e-11,   1.278385304431906e-13,  -1.120459529942795e-14,  -4.017891654192901e-16,  -9.961300254341970e-19,   1.618517477138626e-01,
  -2.054835822618097e-03,   1.851428519704255e-05,  -1.391709845116178e-07,   1.338750606131764e-09,   1.169452187251417e-11,   1.277598555054411e-13,  -1.120483893748943e-14,
  -4.017020049828371e-16,  -9.932479646527617e-19,   2.710044419640071e-01,  -3.405493406304956e-03,   2.933511211948250e-05,  -1.967323896066710e-07,   1.711800940742678e-09,
   2.821066043945488e-11,   1.796230791556492e-13,  -1.920664638941487e-14,  -7.363691753656229e-16,  -2.573690822731022e-18,   2.710086195092050e-01,  -3.405577255680782e-03,
   2.933657569352466e-05,  -1.966927298639544e-07,   1.712150378238546e-09,   2.815310253200565e-11,   1.767539978240169e-13,  -1.921699690052928e-14,  -7.332335248598700e-16,
  -2.467530681551539e-18,   2.710154777767995e-01,  -3.405714895881829e-03,   2.933897859214854e-05,  -1.966276812416342e-07,   1.712719644502644e-09,   2.805859138494148e-11,
   1.720529641445134e-13,  -1.923360047349066e-14,  -7.280863343785725e-16,  -2.293864889440997e-18,   2.710227551341157e-01,  -3.405860926312104e-03,   2.934152853040909e-05,
  -1.965587401810633e-07,   1.713317718625775e-09,   2.795828031249361e-11,   1.670770724805482e-13,  -1.925069143507321e-14,  -7.226254856746696e-16,  -2.110425429748758e-18,
   2.710284826012490e-01,  -3.405975841117913e-03,   2.934353554469786e-05,  -1.965045415365694e-07,   1.713784095896921e-09,   2.787931546178281e-11,   1.631699014784982e-13,
  -1.926376173564033e-14,  -7.183283328685749e-16,  -1.966660903923535e-18,   2.710317880941325e-01,  -3.406042155927862e-03,   2.934469391147079e-05,  -1.964732858242412e-07,
   1.714051525569619e-09,   2.783373559969715e-11,   1.609185567232737e-13,  -1.927115271016725e-14,  -7.158486023466855e-16,  -1.883933383473435e-18,   2.710330293508459e-01,
  -3.406067056896858e-03,   2.934512890470912e-05,  -1.964615534138301e-07,   1.714151622117414e-09,   2.781661846637049e-11,   1.600738272311241e-13,  -1.927389937470833e-14,
  -7.149174860230350e-16,  -1.852914075515051e-18,   2.710332351075075e-01,  -3.406071184541342e-03,   2.934520101185480e-05,  -1.964596088320715e-07,   1.714168197363196e-09,
   2.781378098078712e-11,   1.599338367215927e-13,  -1.927435315950411e-14,  -7.147631426933922e-16,  -1.847774591926393e-18,   4.117646366014140e-01,  -5.097319647807482e-03,
   4.092016456947503e-05,  -2.195413885788555e-07,   1.511653753232321e-09,   5.875246869878823e-11,   2.076984541132255e-13,  -3.115760197183570e-14,  -1.206051645343716e-15,
  -4.545673275713222e-18,   4.117704624414352e-01,  -5.097413082425997e-03,   4.092145745500210e-05,  -2.194585683312764e-07,   1.512041447416263e-09,   5.865906803722840e-11,
   2.029997682437473e-13,  -3.117618836065661e-14,  -1.200897124487077e-15,  -4.369612747132852e-18,   4.117800266342959e-01,  -5.097566445107564e-03,   4.092358015754398e-05,
  -2.193227016710005e-07,   1.512670717710906e-09,   5.850569862460223e-11,   1.953009569822715e-13,  -3.120605660441619e-14,  -1.192435602627729e-15,  -4.081588286664192e-18,
   4.117901751637536e-01,  -5.097729140307819e-03,   4.092583280791552e-05,  -2.191786673791419e-07,   1.513328659530014e-09,   5.834291214538388e-11,   1.871520937573194e-13,
  -3.123687547900423e-14,  -1.183457990855886e-15,  -3.777341142980844e-18,   4.117981622412918e-01,  -5.097857157349749e-03,   4.092760587012657e-05,  -2.190654063057658e-07,
   1.513839404669540e-09,   5.821476295641009e-11,   1.807534987532045e-13,  -3.126049916318065e-14,  -1.176393155886513e-15,  -3.538888229146973e-18,   4.118027717926478e-01,
  -5.097931028496750e-03,   4.092862922437214e-05,  -2.190000790793848e-07,   1.514131339514572e-09,   5.814079156911930e-11,   1.770665978300525e-13,  -3.127388047362825e-14,
  -1.172316163219007e-15,  -3.401669684537694e-18,   4.118045027349852e-01,  -5.097958765959078e-03,   4.092901352012968e-05,  -2.189755552305206e-07,   1.514240430164070e-09,
   5.811301195765248e-11,   1.756832361826637e-13,  -3.127885764937553e-14,  -1.170785264275200e-15,  -3.350217846496416e-18,   4.118047896639797e-01,  -5.097963363740902e-03,
   4.092907722349777e-05,  -2.189714904300303e-07,   1.514258485350462e-09,   5.810840695177184e-11,   1.754539825504118e-13,  -3.127968017584450e-14,  -1.170531498693704e-15,
  -3.341692929125873e-18,   5.877189734471571e-01,  -7.113507486507589e-03,   5.075946457680722e-05,  -1.513510390755346e-07,   1.298703974368986e-10,   1.095007987617788e-10,
   3.214965782280917e-13,  -5.104148078038848e-14,  -1.889959308942782e-15,  -7.987392138048360e-18,   5.877261971216482e-01,  -7.113571555901924e-03,   5.075957881679584e-05,
  -1.511965040685470e-07,   1.304694778217126e-10,   1.093477462694970e-10,   3.141360589083161e-13,  -5.107480811030709e-14,  -1.881756301783774e-15,  -7.703081176823080e-18,
   5.877380559650350e-01,  -7.113676688803037e-03,   5.075976670235048e-05,  -1.509429674694990e-07,   1.314416996440832e-10,   1.090964187495620e-10,   3.020761991944870e-13,
  -5.112847966686308e-14,  -1.868289756842703e-15,  -7.237943131135117e-18,   5.877506391316379e-01,  -7.113788178571973e-03,   5.075996652464284e-05,  -1.506741598029291e-07,
   1.324580112407532e-10,   1.088296508777065e-10,   2.893118624174830e-13,  -5.118401826743076e-14,  -1.854000891883390e-15,  -6.746576402426642e-18,   5.877605421623702e-01,
  -7.113875875025225e-03,   5.076012411679140e-05,  -1.504627619146467e-07,   1.332467984750504e-10,   1.086196389956145e-10,   2.792895077630854e-13,  -5.122670834663691e-14,
  -1.842755731343733e-15,  -6.361447189616696e-18,   5.877662574000670e-01,  -7.113926467698276e-03,   5.076021519798969e-05,  -1.503408222634862e-07,   1.336975966549160e-10,
   1.084984116268202e-10,   2.735147286487749e-13,  -5.125093796709641e-14,  -1.836266069728928e-15,  -6.139814554958270e-18,   5.877684035296021e-01,  -7.113945462223043e-03,
   5.076024942465967e-05,  -1.502950444701748e-07,   1.338660398415811e-10,   1.084528847800871e-10,   2.713480027914342e-13,  -5.125995947909362e-14,  -1.833829168520007e-15,
  -6.056708936812559e-18,   5.877687592813419e-01,  -7.113948610651359e-03,   5.076025509952426e-05,  -1.502874567660066e-07,   1.338939176224423e-10,   1.084453378031581e-10,
   2.709889298730340e-13,  -5.126145086675748e-14,  -1.833425219027475e-15,  -6.042939302665067e-18,   8.041915601349523e-01,  -9.391904566985732e-03,   5.348753136396610e-05,
   1.148766044260952e-07,  -3.120784994252236e-09,   1.770119777897220e-10,   9.894205194798574e-13,  -8.925755326805074e-14,  -2.964480991167325e-15,  -1.338837313308354e-17,
   8.041991664675979e-01,  -9.391854642124497e-03,   5.348487782394855e-05,   1.151262452422626e-07,  -3.118809682130618e-09,   1.767443633301646e-10,   9.778786374620800e-13,
  -8.931370263431298e-14,  -2.951451650915589e-15,  -1.292258886423970e-17,   8.042116532228384e-01,  -9.391772605880359e-03,   5.348052278420442e-05,   1.155357954459360e-07,
  -3.115584551006971e-09,   1.763049176352959e-10,   9.589683022662636e-13,  -8.940417565006065e-14,  -2.930060398330860e-15,  -1.216050795104863e-17,   8.042249022672794e-01,
  -9.391685455154930e-03,   5.347590334230412e-05,   1.159699852454012e-07,  -3.112186411924119e-09,   1.758384798803910e-10,   9.389539858672420e-13,  -8.949786217032353e-14,
  -2.907360870321380e-15,  -1.135538758648323e-17,   8.042353290685309e-01,  -9.391616791864380e-03,   5.347226896515335e-05,   1.163114236175117e-07,  -3.109529391716588e-09,
   1.754712825036789e-10,   9.232395479450184e-13,  -8.956992387556040e-14,  -2.889495153659012e-15,  -1.072429297212016e-17,   8.042413464726755e-01,  -9.391577134800202e-03,
   5.347017195363734e-05,   1.165083656203439e-07,  -3.108002913153711e-09,   1.752593227773523e-10,   9.141852439037169e-13,  -8.961084400120294e-14,  -2.879184137224267e-15,
  -1.036109402017441e-17,   8.042436060475938e-01,  -9.391562237483572e-03,   5.346938459145999e-05,   1.165822987425157e-07,  -3.107431015982742e-09,   1.751797217378308e-10,
   9.107880611009238e-13,  -8.962608380015058e-14,  -2.875312187497051e-15,  -1.022490165439090e-17,   8.042439806034154e-01,  -9.391559767739718e-03,   5.346925407946776e-05,
   1.165945531311939e-07,  -3.107336284962520e-09,   1.751665263027235e-10,   9.102250770536098e-13,  -8.962860336577002e-14,  -2.874670353407099e-15,  -1.020233597359030e-17,
   1.069168110172422e+00,  -1.172217363153868e-02,   3.625194245741072e-05,   7.796508285034338e-07,  -7.309798005903852e-09,   1.957101656687122e-10,   3.863957110342674e-12,
  -1.617158828642572e-13,  -5.343101225670259e-15,  -1.653031048900510e-17,   1.069173256630524e+00,  -1.172183981272971e-02,   3.624574624019609e-05,   7.799252491180749e-07,
  -7.301796805321192e-09,   1.952259180156195e-10,   3.843122014601568e-12,  -1.617790970578837e-13,  -5.321178716577792e-15,  -1.572637160031014e-17,   1.069181704744514e+00,
  -1.172129171139294e-02,   3.623557900627226e-05,   7.803752565198974e-07,  -7.288693442499909e-09,   1.944308244455566e-10,   3.808981007168779e-12,  -1.618799300965521e-13,
  -5.285182566106640e-15,  -1.441102263855975e-17,   1.069190667990615e+00,  -1.172071001979009e-02,   3.622479737891921e-05,   7.808520716567755e-07,  -7.274833066984108e-09,
   1.935870054506740e-10,   3.772840627895879e-12,  -1.619829306120503e-13,  -5.246979090568231e-15,  -1.302138213830608e-17,   1.069197721492998e+00,  -1.172025214316912e-02,
   3.621631694711408e-05,   7.812268371005858e-07,  -7.263956190743343e-09,   1.929227999747853e-10,   3.744460137503028e-12,  -1.620611099798988e-13,  -5.216906766820576e-15,
  -1.193210765900873e-17,   1.069201791958933e+00,  -1.171998786066035e-02,   3.621142463160671e-05,   7.814429249042888e-07,  -7.257691470395101e-09,   1.925394286040579e-10,
   3.728106127765200e-12,  -1.621050756825122e-13,  -5.199549161283092e-15,  -1.130522241934179e-17,   1.069203320412460e+00,  -1.171988861372362e-02,   3.620958787869708e-05,
   7.815240308502691e-07,  -7.255341373703582e-09,   1.923954603667799e-10,   3.721969746058773e-12,  -1.621213675644410e-13,  -5.193030791308983e-15,  -1.107015282871198e-17,
   1.069203573773035e+00,  -1.171987216179484e-02,   3.620928342960622e-05,   7.815374733606577e-07,  -7.254951936425621e-09,   1.923715951261977e-10,   3.720952801518744e-12,
  -1.621240567004598e-13,  -5.191950256561206e-15,  -1.103120419840295e-17,   1.394222982381716e+00,  -1.331220358250535e-02,  -3.626094085287523e-05,   2.019711482797180e-06,
   5.411466418248806e-09,  -1.783282692631599e-10,   8.832229484875724e-12,  -1.180199008908189e-13,  -1.411445871650663e-14,  -7.673794219085881e-17,   1.394217831683676e+00,
  -1.331134223102949e-02,  -3.625621750247386e-05,   2.019454679705968e-06,   5.429667878848923e-09,  -1.786864360985252e-10,   8.777202861284747e-12,  -1.183678515331761e-13,
  -1.405594003099179e-14,  -7.504645908813629e-17,   1.394209376481113e+00,  -1.330992826309216e-02,  -3.624845233157474e-05,   2.019032725230218e-06,   5.459464270783407e-09,
  -1.792751472832694e-10,   8.687036162076342e-12,  -1.189328742287009e-13,  -1.395989318380632e-14,  -7.227871281455777e-17,   1.394200405540330e+00,  -1.330842804249286e-02,
  -3.624019792697425e-05,   2.018584494792949e-06,   5.490966183241615e-09,  -1.799007898065188e-10,   8.591591170918936e-12,  -1.195240065384717e-13,  -1.385800966022816e-14,
  -6.935429524032004e-17,   1.394193345857480e+00,  -1.330724743972290e-02,  -3.623369085924559e-05,   2.018231369774734e-06,   5.515675664280962e-09,  -1.803938735749286e-10,
   8.516641122565902e-12,  -1.199831631945630e-13,  -1.377784901102375e-14,  -6.706173210687449e-17,   1.394189271774904e+00,  -1.330656612235154e-02,  -3.622993117815261e-05,
   2.018027427887244e-06,   5.529902879689586e-09,  -1.806787205007797e-10,   8.473452379470230e-12,  -1.202457240929613e-13,  -1.373159589711219e-14,  -6.574224714830993e-17,
   1.394187741953910e+00,  -1.330631028687325e-02,  -3.622851856390121e-05,   2.017950817972078e-06,   5.535239086931762e-09,  -1.807857357965119e-10,   8.457247125214040e-12,
  -1.203438600914552e-13,  -1.371422915566040e-14,  -6.524744783549568e-17,   1.394187488366163e+00,  -1.330626787879572e-02,  -3.622828435981025e-05,   2.017938117320028e-06,
   5.536123309864064e-09,  -1.808034778747032e-10,   8.454561534309266e-12,  -1.203601033781892e-13,  -1.371135046342090e-14,  -6.516546366984742e-17,   1.783594458966977e+00,
  -1.022021639273010e-02,  -2.329637212333684e-04,  -6.631202070915402e-07,   1.280379017010699e-07,   3.204503479551029e-09,  -3.146250801036841e-11,  -3.383900128539043e-12,
  -5.087003231446564e-14,   1.753580638023157e-15,   1.783561525565086e+00,  -1.022048369592041e-02,  -2.328547912735719e-04,  -6.586439869383932e-07,   1.279684798486664e-07,
   3.194535890389314e-09,  -3.165422264346759e-11,  -3.374833782795787e-12,  -5.033819820682365e-14,   1.756767522884536e-15,   1.783507471194387e+00,  -1.022092115576451e-02,
  -2.326760086638182e-04,  -6.513057388000786e-07,   1.278542226647717e-07,   3.178192113877296e-09,  -3.196743728190478e-11,  -3.359938973750616e-12,  -4.946784512534167e-14,
   1.761884374456661e-15,   1.783450130464661e+00,  -1.022138348564098e-02,  -2.324863657785272e-04,  -6.435331306040396e-07,   1.277325941295809e-07,   3.160876800724387e-09,
  -3.229772622431207e-11,  -3.344119798786732e-12,  -4.854805266370903e-14,   1.767158237968104e-15,   1.783405013965387e+00,  -1.022174600441892e-02,  -2.323371588276417e-04,
  -6.374260591026029e-07,   1.276365884097421e-07,   3.147268897141799e-09,  -3.255618015015034e-11,  -3.331659611914895e-12,  -4.782686201217010e-14,   1.771196747249162e-15,
   1.783378980742600e+00,  -1.022195468549309e-02,  -2.322510658383720e-04,  -6.339055591508639e-07,   1.275810683493517e-07,   3.139423264976337e-09,  -3.270474473552209e-11,
  -3.324464479577968e-12,  -4.741172670668979e-14,   1.773482714417029e-15,   1.783369205838469e+00,  -1.022203294612968e-02,  -2.322187403300048e-04,  -6.325843340832358e-07,
   1.275601986420960e-07,   3.136478618242231e-09,  -3.276042003188602e-11,  -3.321761865124633e-12,  -4.725604292558002e-14,   1.774332683660119e-15,   1.783367585551973e+00,
  -1.022204591361388e-02,  -2.322133820866183e-04,  -6.323653620787858e-07,   1.275567380628509e-07,   3.135990578252471e-09,  -3.276964309427937e-11,  -3.321313827607240e-12,
  -4.723024685203839e-14,   1.774473133808638e-15,   3.081672610233716e-03,  -3.867808603844433e-05,   3.594569213298162e-07,  -2.776819457381620e-09,   3.759630255564982e-11,
   9.111582823243220e-14,  -5.463281701305188e-15,  -4.269072200984281e-16,  -3.393891391995930e-18,   2.845930970977740e-19,   3.081723828013369e-03,  -3.867927110515443e-05,
   3.594889557410033e-07,  -2.776700347992286e-09,   3.758449518588514e-11,   8.986316732848044e-14,  -5.475658954005921e-15,  -4.254584923306285e-16,  -3.338339605046968e-18,
   2.842564276329300e-19,   3.081807913574568e-03,  -3.868121654971989e-05,   3.595415380808621e-07,  -2.776506089478399e-09,   3.756509298664987e-11,   8.780984470759368e-14,
  -5.495820184914158e-15,  -4.230814833900613e-16,  -3.247483372946036e-18,   2.836950188301367e-19,   3.081897139320763e-03,  -3.868328077046236e-05,   3.595973220387483e-07,
  -2.776301702456279e-09,   3.754448075547080e-11,   8.563535350319236e-14,  -5.516998566140263e-15,  -4.205610939163336e-16,  -3.151540645202235e-18,   2.830875497402067e-19,
   3.081967363685848e-03,  -3.868490528968035e-05,   3.596412170844693e-07,  -2.776142104527017e-09,   3.752824082565610e-11,   8.392708813111200e-14,  -5.533511366612749e-15,
  -4.185788515436830e-16,  -3.076367701204078e-18,   2.826009995850331e-19,   3.082007892836375e-03,  -3.868584281817333e-05,   3.596665468771140e-07,  -2.776050500346368e-09,
   3.751886126521206e-11,   8.294244522277315e-14,  -5.542979354934630e-15,  -4.174353932457661e-16,  -3.033117819001473e-18,   2.823168249032520e-19,   3.082023112180407e-03,
  -3.868619486693520e-05,   3.596760579184617e-07,  -2.776016197065917e-09,   3.751533779407496e-11,   8.257293453573094e-14,  -5.546523000762419e-15,  -4.170061144692587e-16,
  -3.016902343405041e-18,   2.822094782784183e-19,   3.082025635017450e-03,  -3.868625322392438e-05,   3.596776344808077e-07,  -2.776010515816544e-09,   3.751475365702614e-11,
   8.251169511530303e-14,  -5.547109795119674e-15,  -4.169349607183062e-16,  -3.014215729590795e-18,   2.821916505271991e-19,   2.782084693163285e-02,  -3.486493195958681e-04,
   3.217695753644880e-06,  -2.443101144269900e-08,   3.308287483024534e-10,   9.815651494331018e-13,  -5.154019972877265e-14,  -3.882926703691071e-15,  -3.123898747902611e-17,
   2.601640505552687e-18,   2.782130540014669e-02,  -3.486597451563078e-04,   3.217977598230625e-06,  -2.442971059724766e-08,   3.307173909428862e-10,   9.701726751289269e-13,
  -5.165419033230496e-14,  -3.869682292704311e-15,  -3.073078904618077e-17,   2.598589183491880e-18,   2.782205807932226e-02,  -3.486768600225686e-04,   3.218440222605031e-06,
  -2.442758667887091e-08,   3.305344094826611e-10,   9.514986358765124e-13,  -5.183987864154877e-14,  -3.847951348677757e-15,  -2.989961827761165e-17,   2.593499966577091e-18,
   2.782285676939276e-02,  -3.486950197060741e-04,   3.218931008818442e-06,  -2.442534882735612e-08,   3.303400217262337e-10,   9.317228257138615e-13,  -5.203494834876312e-14,
  -3.824909470499603e-15,  -2.902191460995202e-17,   2.587991845723556e-18,   2.782348537112156e-02,  -3.487093111029909e-04,   3.219317192043504e-06,  -2.442359904626111e-08,
   3.301868717578727e-10,   9.161872318343996e-13,  -5.218705403331009e-14,  -3.806787341788406e-15,  -2.833421672474898e-17,   2.583579173512021e-18,   2.782384816087299e-02,
  -3.487175588000308e-04,   3.219540038620675e-06,  -2.442259378684790e-08,   3.300984197747077e-10,   9.072325859138213e-13,  -5.227427118210251e-14,  -3.796333538266354e-15,
  -2.793855754421872e-17,   2.581001528845197e-18,   2.782398439418715e-02,  -3.487206558644493e-04,   3.219623714562125e-06,  -2.442221716588203e-08,   3.300651927111287e-10,
   9.038721530681132e-13,  -5.230691525642425e-14,  -3.792408949126897e-15,  -2.779021487054641e-17,   2.580027756538869e-18,   2.782400697692267e-02,  -3.487211692457404e-04,
   3.219637584774661e-06,  -2.442215478113071e-08,   3.300596841930911e-10,   9.033152253546811e-13,  -5.231232084679418e-14,  -3.791758440850246e-15,  -2.776563714534019e-17,
   2.579866032164841e-18,   7.776644207882709e-02,  -9.714707232410518e-04,   8.834227996303868e-06,  -6.457403623079101e-08,   8.750962178387446e-10,   3.655463027639763e-12,
  -1.566290697237968e-13,  -1.103087888920368e-14,  -9.072126984757658e-17,   7.460675614941837e-18,   7.776770075306665e-02,  -9.714982739592799e-04,   8.834973273753099e-06,
  -6.456910689043555e-08,   8.747579825225670e-10,   3.623104264071034e-12,  -1.569604374293470e-13,  -1.099289413990533e-14,  -8.926126869498521e-17,   7.452076379581322e-18,
   7.776976714694753e-02,  -9.715435014660232e-04,   8.836196557385148e-06,  -6.456104761128550e-08,   8.742022191695142e-10,   3.570064003333401e-12,  -1.575002777391167e-13,
  -1.093056960877810e-14,  -8.687339814427423e-17,   7.437727905374896e-18,   7.777195985440986e-02,  -9.715914893730288e-04,   8.837494270412070e-06,  -6.455254093880178e-08,
   8.736118415668914e-10,   3.513895437004071e-12,  -1.580674592945717e-13,  -1.086448456781683e-14,  -8.435183855655910e-17,   7.422190334507154e-18,   7.777368560188615e-02,
  -9.716292546837412e-04,   8.838515370583201e-06,  -6.454587857610740e-08,   8.731467291166950e-10,   3.469770995513861e-12,  -1.585097684097526e-13,  -1.081250903518612e-14,
  -8.237614431677341e-17,   7.409737179007379e-18,   7.777468159463428e-02,  -9.716510492135458e-04,   8.839104584521859e-06,  -6.454204658526376e-08,   8.728781112441488e-10,
   3.444338181295216e-12,  -1.587634075318666e-13,  -1.078252658294606e-14,  -8.123944975076757e-17,   7.402460492416405e-18,   7.777505560551048e-02,  -9.716592331687415e-04,
   8.839325824534018e-06,  -6.454061008822618e-08,   8.727772063062396e-10,   3.434794003562500e-12,  -1.588583446238037e-13,  -1.077127046692043e-14,  -8.081327385431558e-17,
   7.399711120318027e-18,   7.777511760346717e-02,  -9.716605897707931e-04,   8.839362497405456e-06,  -6.454037209768583e-08,   8.727604779584029e-10,   3.433212241097732e-12,
  -1.588740656248196e-13,  -1.076940474170333e-14,  -8.074266412565540e-17,   7.399254482132236e-18,   1.539019289097946e-01,  -1.912678621154733e-03,   1.697141878029190e-05,
  -1.159397629688974e-07,   1.575755366765343e-09,   1.005408604014648e-11,  -3.478764028874368e-13,  -2.244589696515957e-14,  -1.898596774268904e-16,   1.536478336079609e-17,
   1.539043467643853e-01,  -1.912728069916159e-03,   1.697275997216040e-05,  -1.159260099230550e-07,   1.575004628121456e-09,   9.988256800579695e-12,  -3.485706562240867e-13,
  -2.236765748568502e-14,  -1.868417253707274e-16,   1.534753950621461e-17,   1.539083162013911e-01,  -1.912809243948940e-03,   1.697496128987941e-05,  -1.159034992622991e-07,
   1.573771130892309e-09,   9.880356124768477e-12,  -3.497017998900457e-13,  -2.223928220777744e-14,  -1.819057703162613e-16,   1.531874715298613e-17,   1.539125282675565e-01,
  -1.912895370294612e-03,   1.697729642473286e-05,  -1.158797049330857e-07,   1.572460891126905e-09,   9.766094328785252e-12,  -3.508903913784063e-13,  -2.210315880704028e-14,
  -1.766934479583183e-16,   1.528754251991031e-17,   1.539158433209307e-01,  -1.912963148152303e-03,   1.697913372928401e-05,  -1.158610446434030e-07,   1.571428714746909e-09,
   9.676335548063281e-12,  -3.518174147477971e-13,  -2.199609684225394e-14,  -1.726094715389757e-16,   1.526251395176883e-17,   1.539177565572329e-01,  -1.913002262467246e-03,
   1.698019388965167e-05,  -1.158503018458278e-07,   1.570832622249925e-09,   9.624600461032259e-12,  -3.523490566821743e-13,  -2.193433674115250e-14,  -1.702597939396810e-16,
   1.524788190301185e-17,   1.539184750067284e-01,  -1.913016949977101e-03,   1.698059195562057e-05,  -1.158462728093421e-07,   1.570608707577740e-09,   9.605185980543314e-12,
  -3.525480590728581e-13,  -2.191115042725320e-14,  -1.693788386347561e-16,   1.524235208530416e-17,   1.539185941005562e-01,  -1.913019384626045e-03,   1.698065793891709e-05,
  -1.158456052020911e-07,   1.570571586511159e-09,   9.601968414995099e-12,  -3.525810131197196e-13,  -2.190730723984088e-14,  -1.692328800335965e-16,   1.524143357744482e-17,
   2.578375929164141e-01,  -3.179746753641871e-03,   2.715741991427852e-05,  -1.648259234703766e-07,   2.262026875358714e-09,   2.348449641964575e-11,  -6.682544777892591e-13,
  -3.933142310285866e-14,  -3.417527959728985e-16,   2.723143629953704e-17,   2.578414614842181e-01,  -3.179817007015727e-03,   2.715934316001968e-05,  -1.647934749802394e-07,
   2.260585714826016e-09,   2.336917094851111e-11,  -6.695051194421565e-13,  -3.919272788974873e-14,  -3.363672604581374e-16,   2.720198015442824e-17,   2.578478125610590e-01,
  -3.179932329516256e-03,   2.716249958526791e-05,  -1.647403232299034e-07,   2.258217945697171e-09,   2.318014455205815e-11,  -6.715429289686555e-13,  -3.896515291776408e-14,
  -3.275590050079898e-16,   2.715274628037363e-17,   2.578545518117565e-01,  -3.180054682327227e-03,   2.716584758093141e-05,  -1.646840849075210e-07,   2.255703029806715e-09,
   2.297997919912485e-11,  -6.736844315270121e-13,  -3.872383723653025e-14,  -3.182575114389841e-16,   2.709932041802559e-17,   2.578598558309734e-01,  -3.180150965036372e-03,
   2.716848159059604e-05,  -1.646399406144292e-07,   2.253721956175741e-09,   2.282274204799733e-11,  -6.753548073413830e-13,  -3.853403698413765e-14,  -3.109695323402329e-16,
   2.705642139073794e-17,   2.578629169617344e-01,  -3.180206527829093e-03,   2.717000137596920e-05,  -1.646145103592060e-07,   2.252577912961764e-09,   2.273211523937476e-11,
  -6.763128153527675e-13,  -3.842454667809282e-14,  -3.067764454094412e-16,   2.703132350871364e-17,   2.578640664614318e-01,  -3.180227391484797e-03,   2.717057200372918e-05,
  -1.646049697876326e-07,   2.252148176363637e-09,   2.269810623744153e-11,  -6.766714246943912e-13,  -3.838344094101823e-14,  -3.052043448826494e-16,   2.702183494577246e-17,
   2.578642570082336e-01,  -3.180230849896111e-03,   2.717066658992588e-05,  -1.646033887623932e-07,   2.252076934153837e-09,   2.269246993309001e-11,  -6.767308096364260e-13,
  -3.837662755078401e-14,  -3.049438756685187e-16,   2.702025870632786e-17,   3.920140937557159e-01,  -4.779995874936428e-03,   3.846944219618895e-05,  -1.860581352425260e-07,
   2.643673629608488e-09,   4.902707901384199e-11,  -1.174065660200584e-12,  -6.425838574059948e-14,  -5.658684910530230e-16,   4.471059584818392e-17,   3.920195727501675e-01,
  -4.780075066688439e-03,   3.847168513205437e-05,  -1.859899534171287e-07,   2.641143128343996e-09,   4.883868310567543e-11,  -1.176135889148294e-12,  -6.403060435496720e-14,
  -5.569240441316645e-16,   4.466455978070565e-17,   3.920285676349516e-01,  -4.780205052101001e-03,   3.847536570510946e-05,  -1.858782141784220e-07,   2.636985804374331e-09,
   4.852989187125128e-11,  -1.179509058689785e-12,  -6.365684599628023e-14,  -5.422949557429851e-16,   4.458749706319900e-17,   3.920381122136322e-01,  -4.780342948617419e-03,
   3.847926894395651e-05,  -1.857599112339848e-07,   2.632570375097060e-09,   4.820290778107641e-11,  -1.183053754620370e-12,  -6.326050933991089e-14,  -5.268465541009063e-16,
   4.450371794295508e-17,   3.920456240721237e-01,  -4.780451453614886e-03,   3.848233926784517e-05,  -1.856669949664185e-07,   2.629092394101404e-09,   4.794605253274204e-11,
  -1.185818539200600e-12,  -6.294877353115402e-14,  -5.147422129243230e-16,   4.443633726421597e-17,   3.920499594026843e-01,  -4.780514065847509e-03,   3.848411059198942e-05,
  -1.856134467689452e-07,   2.627083980212015e-09,   4.779800987745286e-11,  -1.187404187586635e-12,  -6.276893890703049e-14,  -5.077780313612365e-16,   4.439687383944422e-17,
   3.920515873794538e-01,  -4.780537575829092e-03,   3.848477562463803e-05,  -1.855933531685218e-07,   2.626329574090071e-09,   4.774245496066431e-11,  -1.187997733879753e-12,
  -6.270142333378891e-14,  -5.051669667312772e-16,   4.438194627474584e-17,   3.920518572408044e-01,  -4.780541472864135e-03,   3.848488585713607e-05,  -1.855900231197735e-07,
   2.626204508531606e-09,   4.773324786719127e-11,  -1.188096023536354e-12,  -6.269023240802744e-14,  -5.047343592218967e-16,   4.437946609363933e-17,   5.600658614611451e-01,
  -6.714495041268646e-03,   4.902772531802305e-05,  -1.319419138141888e-07,   2.246381683068237e-09,   9.339960792797271e-11,  -1.908880550911955e-12,  -1.031590631003846e-13,
  -8.912090503038013e-16,   7.103545067937290e-17,   5.600728422764698e-01,  -6.714550910112960e-03,   4.902962005598926e-05,  -1.318115480875541e-07,   2.242268749758960e-09,
   9.309710299030920e-11,  -1.912133605974815e-12,  -1.027970417519099e-13,  -8.767619155683366e-16,   7.096710788889190e-17,   5.600843026060881e-01,  -6.714642588232774e-03,
   4.903272802490380e-05,  -1.315978403853645e-07,   2.235511842514151e-09,   9.260127284286115e-11,  -1.917432920900709e-12,  -1.022029967708366e-13,  -8.531328446663644e-16,
   7.085244093752318e-17,   5.600964631617038e-01,  -6.714739811994860e-03,   4.903602235274765e-05,  -1.313714991552990e-07,   2.228335668833646e-09,   9.207621938850226e-11,
  -1.923000182185083e-12,  -1.015730432702741e-13,  -8.281803295224943e-16,   7.072743068830818e-17,   5.601060337711241e-01,  -6.714816288688053e-03,   4.903861249435089e-05,
  -1.311936705552853e-07,   2.222683250509828e-09,   9.166376723754538e-11,  -1.927341411208175e-12,  -1.010775413044246e-13,  -8.086291422287938e-16,   7.062664363939495e-17,
   5.601115572323920e-01,  -6.714860409296007e-03,   4.904010630848960e-05,  -1.310911635917909e-07,   2.219419241450605e-09,   9.142604067058278e-11,  -1.929830727080920e-12,
  -1.007916888308549e-13,  -7.973804287154907e-16,   7.056751893372188e-17,   5.601136313612745e-01,  -6.714876974078475e-03,   4.904066706012784e-05,  -1.310526941398217e-07,
   2.218193217811710e-09,   9.133683011634853e-11,  -1.930762452598065e-12,  -1.006843695907501e-13,  -7.931629706142500e-16,   7.054513642248179e-17,   5.601139751785771e-01,
  -6.714879719772973e-03,   4.904076000269139e-05,  -1.310463184869578e-07,   2.217989968101276e-09,   9.132204525669763e-11,  -1.930916739309435e-12,  -1.006665810129455e-13,
  -7.924642117522426e-16,   7.054141668763505e-17,   7.674876338243969e-01,  -8.959066653934986e-03,   5.468467711799662e-05,   9.351443225184126e-08,   3.996564588922806e-10,
   1.602938128485136e-10,  -2.768456052676884e-12,  -1.710718736384882e-13,  -1.381349471958082e-15,   1.140145986031545e-16,   7.674954164732354e-01,  -8.959025940449960e-03,
   5.468498451722270e-05,   9.373831257189834e-08,   3.936879581451003e-10,   1.597918563701060e-10,  -2.773474917192530e-12,  -1.704905402558066e-13,  -1.357827598329139e-15,
   1.139153788405227e-16,   7.675081929774087e-01,  -8.958959034576460e-03,   5.468548546102566e-05,   9.410533592549935e-08,   3.838822111556097e-10,   1.589690673397080e-10,
  -2.781647281474812e-12,  -1.695365863837176e-13,  -1.319357096835465e-15,   1.137482978635356e-16,   7.675217498717403e-01,  -8.958887949806845e-03,   5.468601196764891e-05,
   9.449408034857967e-08,   3.734674362314194e-10,   1.580977280631322e-10,  -2.790228077155036e-12,  -1.685249182010457e-13,  -1.278732989669995e-15,   1.135653414839636e-16,
   7.675324192446814e-01,  -8.958831938838103e-03,   5.468642268484972e-05,   9.479952108524558e-08,   3.652636708094700e-10,   1.574132124440026e-10,  -2.796915707144783e-12,
  -1.677291352394100e-13,  -1.246903352877696e-15,   1.134172730849099e-16,   7.675385767587533e-01,  -8.958799587025409e-03,   5.468665825554312e-05,   9.497559539525091e-08,
   3.605262124961024e-10,   1.570186591997107e-10,  -2.800749071706400e-12,  -1.672700379126308e-13,  -1.228590597847543e-15,   1.133301923106445e-16,   7.675408889684601e-01,
  -8.958787433537571e-03,   5.468674643822910e-05,   9.504167498339643e-08,   3.587467024583166e-10,   1.568705939083791e-10,  -2.802183593602971e-12,  -1.670976736642404e-13,
  -1.221724694459193e-15,   1.132971859503392e-16,   7.675412722504178e-01,  -8.958785418656101e-03,   5.468676104118564e-05,   9.505262661335156e-08,   3.584516943657155e-10,
   1.568460548925476e-10,  -2.802421125460527e-12,  -1.670691034836486e-13,  -1.220587137927966e-15,   1.132916985194629e-16,   1.022916315676263e+00,  -1.139640194835301e-02,
   4.504646531422190e-05,   6.971631893470741e-07,  -2.933032387612712e-09,   2.154069851069965e-10,  -2.907077485799523e-12,  -3.070183222231624e-13,  -2.428502731200921e-15,
   2.009084488626789e-16,   1.022922721010373e+00,  -1.139610325937228e-02,   4.504392516396334e-05,   6.974621358866908e-07,  -2.939341700944595e-09,   2.145058418563430e-10,
  -2.915918993345203e-12,  -3.059935268499031e-13,  -2.388017654844260e-15,   2.007492258131605e-16,   1.022933236136222e+00,  -1.139561282258012e-02,   4.503975116995842e-05,
   6.979519849469746e-07,  -2.949712659819058e-09,   2.130286798133467e-10,  -2.930318620562850e-12,  -3.043118070694978e-13,  -2.321809056072178e-15,   2.004801123851263e-16,
   1.022944393134740e+00,  -1.139509230840629e-02,   4.503531689928598e-05,   6.984705034573667e-07,  -2.960734892109493e-09,   2.114643000869054e-10,  -2.945441655509023e-12,
  -3.025282680900930e-13,  -2.251901648566836e-15,   2.001841246480363e-16,   1.022953173488427e+00,  -1.139468257220222e-02,   4.503182323497735e-05,   6.988776767706504e-07,
  -2.969422290294592e-09,   2.102352988990283e-10,  -2.957230869572393e-12,  -3.011252741173245e-13,  -2.197133606363541e-15,   1.999436696044326e-16,   1.022958240696844e+00,
  -1.139444606986520e-02,   4.502980542060229e-05,   6.991123026142772e-07,  -2.974441081099575e-09,   2.095268894646954e-10,  -2.963989585531389e-12,  -3.003158476123838e-13,
  -2.165625773694763e-15,   1.998019025579719e-16,   1.022960143464066e+00,  -1.139435725416912e-02,   4.502904741769140e-05,   6.992003385988748e-07,  -2.976326652380515e-09,
   2.092610393148590e-10,  -2.966519044168627e-12,  -3.000119511778469e-13,  -2.153813132584053e-15,   1.997481031910185e-16,   1.022960458873917e+00,  -1.139434253134198e-02,
   4.502892175236987e-05,   6.992149282184688e-07,  -2.976639263668518e-09,   2.092169795319173e-10,  -2.966937889692290e-12,  -2.999615787099274e-13,  -2.151856013017897e-15,
   1.997391554433525e-16,   1.340549294690071e+00,  -1.350407860599848e-02,  -1.159058606536179e-05,   2.087233756353841e-06,   3.433083542293161e-09,  -5.660840727286884e-11,
  -6.002680691614673e-13,  -5.252624599579717e-13,  -8.173153463071733e-15,   4.486599394254182e-16,   1.340547651139983e+00,  -1.350318785267399e-02,  -1.158766423317469e-05,
   2.087140285907413e-06,   3.431440668753528e-09,  -5.814171574588472e-11,  -6.309317635161844e-13,  -5.229814692754342e-13,  -8.080899985045732e-15,   4.480228676438597e-16,
   1.340544953285320e+00,  -1.350172556873731e-02,  -1.158286869999130e-05,   2.086985277062723e-06,   3.428697322407947e-09,  -6.065397463747843e-11,  -6.810087820837462e-13,
  -5.192393365217166e-13,  -7.930024532915774e-15,   4.469605719329440e-16,   1.340542091059012e+00,  -1.350017401594409e-02,  -1.157778181589033e-05,   2.086818680599830e-06,
   3.425723709339724e-09,  -6.331299846438632e-11,  -7.337886506853706e-13,  -5.152720513114208e-13,  -7.770712476311983e-15,   4.458111915042640e-16,   1.340539838765753e+00,
  -1.349895296742653e-02,  -1.157377954357741e-05,   2.086686035469661e-06,   3.423338228438113e-09,  -6.540083223724007e-11,  -7.750698432250759e-13,  -5.121522693070592e-13,
  -7.645895839878094e-15,   4.448906573238337e-16,   1.340538539041053e+00,  -1.349824828921753e-02,  -1.157147021173482e-05,   2.086608869648222e-06,   3.421943446267494e-09,
  -6.660382584252092e-11,  -7.987913049256815e-13,  -5.103527895492397e-13,  -7.574087035697397e-15,   4.443530351597741e-16,   1.340538051003763e+00,  -1.349798367796394e-02,
  -1.157060312165448e-05,   2.086579777199929e-06,   3.421416282159719e-09,  -6.705519605721942e-11,  -8.076795619167764e-13,  -5.096772584207675e-13,  -7.547164670014664e-15,
   4.441499541252896e-16,   1.340537970105771e+00,  -1.349793981498899e-02,  -1.157045939366283e-05,   2.086574948597242e-06,   3.421328717459266e-09,  -6.712999783340229e-11,
  -8.091518956226925e-13,  -5.095652895890774e-13,  -7.542704146667346e-15,   4.441162274114885e-16,   1.738990822191535e+00,  -1.207649538945057e-02,  -2.267413355923038e-04,
   1.822636671293469e-06,   1.762857333073368e-07,   1.210440798874954e-09,  -1.348452594431695e-10,  -3.361157377311579e-12,   6.901233403056972e-14,   4.437366668666944e-15,
   1.738958854658414e+00,  -1.207571148417712e-02,  -2.265924256794776e-04,   1.824277668173470e-06,   1.760011736766187e-07,   1.200744605989636e-09,  -1.345690668822589e-10,
  -3.339247673799350e-12,   6.907368222235809e-14,   4.406569136547472e-15,   1.738906389836453e+00,  -1.207442408933182e-02,  -2.263481405200016e-04,   1.826961801146332e-06,
   1.755344497018011e-07,   1.184873527709104e-09,  -1.341154950558494e-10,  -3.303392298860623e-12,   6.917096213995469e-14,   4.356154212876576e-15,   1.738850741059776e+00,
  -1.207305740300122e-02,  -2.260891721848963e-04,   1.829796541371680e-06,   1.750397995492785e-07,   1.168096547682369e-09,  -1.336340122021501e-10,  -3.265500189363521e-12,
   6.926954400787765e-14,   4.302856071258356e-15,   1.738806959982002e+00,  -1.207198133643762e-02,  -2.258855342972047e-04,   1.832017864341346e-06,   1.746509273494046e-07,
   1.154938819188234e-09,  -1.332549361797990e-10,  -3.235789601453328e-12,   6.934378972339505e-14,   4.261052049378089e-15,   1.738781698996745e+00,  -1.207136012649825e-02,
  -2.257680796197104e-04,   1.833295978817505e-06,   1.744266700131893e-07,   1.147363578611275e-09,  -1.330361066452544e-10,  -3.218687339046151e-12,   6.938530677315319e-14,
   4.236983007056901e-15,   1.738772214366283e+00,  -1.207112681995943e-02,  -2.257239872065007e-04,   1.833775195782529e-06,   1.743424909890538e-07,   1.144522463165499e-09,
  -1.329539233019581e-10,  -3.212273633376749e-12,   6.940064594970325e-14,   4.227955592130243e-15,   1.738770642212137e+00,  -1.207108814416163e-02,  -2.257166789428509e-04,
   1.833854594482384e-06,   1.743285387904390e-07,   1.144051690187660e-09,  -1.329402996771509e-10,  -3.211210910872219e-12,   6.940317542175075e-14,   4.226459735979659e-15,
   2.932515074719659e-03,  -3.592542017785669e-05,   3.297700674587370e-07,  -2.171964935211628e-09,   3.712439289956229e-11,  -1.839691902795317e-13,  -1.695445543698101e-14,
  -3.125450338245271e-16,   1.179780506350728e-17,   4.832719328465266e-19,   2.932562066758502e-03,  -3.592634839056127e-05,   3.298015642618482e-07,  -2.172234269168538e-09,
   3.708875523394461e-11,  -1.848653810084064e-13,  -1.690781540466204e-14,  -3.101653255995733e-16,   1.178021123718234e-17,   4.796732615005194e-19,   2.932639215005360e-03,
  -3.592787228684082e-05,   3.298532495453548e-07,  -2.172677330612757e-09,   3.703032199595795e-11,  -1.863315451752822e-13,  -1.683130021462483e-14,  -3.062718277060115e-16,
   1.175110038184828e-17,   4.737849426997736e-19,   2.932721079619542e-03,  -3.592948937411756e-05,   3.299080620000346e-07,  -2.173148681774037e-09,   3.696841729416848e-11,
  -1.878803728097176e-13,  -1.675018267015240e-14,  -3.021583965016444e-16,   1.171990420920572e-17,   4.675634230728911e-19,   2.932785510658176e-03,  -3.593076211407832e-05,
   3.299511782590522e-07,  -2.173520525026419e-09,   3.691976851136986e-11,  -1.890943348999761e-13,  -1.668639440767582e-14,  -2.989340126776178e-16,   1.169513189351326e-17,
   4.626861699407336e-19,   2.932822696335705e-03,  -3.593149667081778e-05,   3.299760529109541e-07,  -2.173735478027452e-09,   3.689172061291001e-11,  -1.897929465726646e-13,
  -1.664960175673242e-14,  -2.970783217751990e-16,   1.168074738118849e-17,   4.598790646394365e-19,   2.932836660166493e-03,  -3.593177251053700e-05,   3.299853919683179e-07,
  -2.173816262026656e-09,   3.688119368919601e-11,  -1.900549066249693e-13,  -1.663578969307074e-14,  -2.963824662384139e-16,   1.167532930262736e-17,   4.588264140096645e-19,
   2.932838974883934e-03,  -3.593181823525436e-05,   3.299869399652154e-07,  -2.173829656663802e-09,   3.687944898264134e-11,  -1.900983104514613e-13,  -1.663350035406807e-14,
  -2.962671696210413e-16,   1.167443030705054e-17,   4.586519983197172e-19,   2.647600425535717e-02,  -3.239895886392387e-04,   2.956610254144402e-06,  -1.908558861249577e-08,
   3.291446051900383e-10,  -1.565614758363580e-12,  -1.561274627832114e-13,  -2.843602194701902e-15,   1.077061396324689e-16,   4.421835296521841e-18,   2.647642556410924e-02,
  -3.239977448243595e-04,   2.956889435216752e-06,  -1.908788510946340e-08,   3.288163869354837e-10,  -1.573766548713170e-12,  -1.557016669783166e-13,  -2.821828640803039e-15,
   1.075456874228141e-16,   4.388898152488017e-18,   2.647711723905138e-02,  -3.240111352471700e-04,   2.957347555190221e-06,  -1.909166342257045e-08,   3.282782186586332e-10,
  -1.587102570414373e-12,  -1.550031283077687e-13,  -2.786204443898053e-15,   1.072801870570349e-16,   4.335004783731552e-18,   2.647785119826852e-02,  -3.240253445073485e-04,
   2.957833383017746e-06,  -1.909568368003433e-08,   3.277080704587908e-10,  -1.601190117038779e-12,  -1.542625723078239e-13,  -2.748567983711906e-15,   1.069956476543965e-16,
   4.278061721917412e-18,   2.647842885600167e-02,  -3.240365279852205e-04,   2.958215534678180e-06,  -1.909885571465607e-08,   3.272600048452633e-10,  -1.612231585546513e-12,
  -1.536802221967728e-13,  -2.719066035020838e-15,   1.067696856396802e-16,   4.233422160298712e-18,   2.647876224478523e-02,  -3.240429824761238e-04,   2.958436002806462e-06,
  -1.910068958639302e-08,   3.270016754650826e-10,  -1.618585628961583e-12,  -1.533443263307662e-13,  -2.702087148115549e-15,   1.066384708359429e-16,   4.207729828650233e-18,
   2.647888743770713e-02,  -3.240454062559544e-04,   2.958518775843116e-06,  -1.910137883289801e-08,   3.269047189749188e-10,  -1.620968199056578e-12,  -1.532182300599528e-13,
  -2.695720329670724e-15,   1.065890463272145e-16,   4.198095329047322e-18,   2.647890819033767e-02,  -3.240458080350210e-04,   2.958532495870865e-06,  -1.910149311750283e-08,
   3.268886496209056e-10,  -1.621362962974457e-12,  -1.531973296979658e-13,  -2.694665408807920e-15,   1.065808455014815e-16,   4.196498970329863e-18,   7.401734024884211e-02,
  -9.036547299113688e-04,   8.144806823588697e-06,  -5.029900010078862e-08,   8.851762331967350e-10,  -3.829889412956111e-12,  -4.541146022659824e-13,  -8.082214495970687e-15,
   3.081764684629397e-16,   1.270550095767969e-17,   7.401850082362477e-02,  -9.036762236438198e-04,   8.145557223013361e-06,  -5.030464494275785e-08,   8.842213338856381e-10,
  -3.853048065110587e-12,  -4.528962629661221e-13,  -8.019653318729066e-15,   3.077185046170007e-16,   1.261078746045396e-17,   7.402040617133900e-02,  -9.037115108722435e-04,
   8.146788540431667e-06,  -5.031393527373278e-08,   8.826555866078822e-10,  -3.890933245919989e-12,  -4.508975153896806e-13,  -7.917295862977982e-15,   3.069606220778566e-16,
   1.245581242559140e-17,   7.402242799630786e-02,  -9.037489557829861e-04,   8.148094269381867e-06,  -5.032382477379009e-08,   8.809967541422752e-10,  -3.930951328335629e-12,
  -4.487785387175243e-13,  -7.809157041206406e-15,   3.061482718998984e-16,   1.229206751461081e-17,   7.402401925830177e-02,  -9.037784268899210e-04,   8.149121310548544e-06,
  -5.033163078520687e-08,   8.796930870250642e-10,  -3.962315024202858e-12,  -4.471122389918581e-13,  -7.724390952621266e-15,   3.055030728416791e-16,   1.216370227733082e-17,
   7.402493763681814e-02,  -9.037954359506860e-04,   8.149713806013005e-06,  -5.033614495649163e-08,   8.789414536009297e-10,  -3.980363322370375e-12,  -4.461511268025112e-13,
  -7.675606699307169e-15,   3.051283758857411e-16,   1.208982151538198e-17,   7.402528250277224e-02,  -9.038018231562028e-04,   8.149936250484292e-06,  -5.033784180353913e-08,
   8.786593472978107e-10,  -3.987130764303872e-12,  -4.457903223403764e-13,  -7.657313384402595e-15,   3.049872329692500e-16,   1.206211657784222e-17,   7.402533966954054e-02,
  -9.038028819340176e-04,   8.149973121546805e-06,  -5.033812317147955e-08,   8.786125914995752e-10,  -3.988252044105790e-12,  -4.457305192622949e-13,  -7.654282358372493e-15,
   3.049638133167787e-16,   1.205752609305486e-17,   1.465145659074021e-01,  -1.782032523498177e-03,   1.573598363466979e-05,  -8.979089436052646e-08,   1.641519660812548e-09,
  -5.888039987032878e-12,  -9.541588131528436e-13,  -1.645243517108890e-14,   6.333210430565203e-16,   2.625672912315537e-17,   1.465168080490193e-01,  -1.782070888288601e-03,
   1.573737387981919e-05,  -8.979966937924595e-08,   1.639512617598560e-09,  -5.935151926915424e-12,  -9.516549663175168e-13,  -1.632315693985155e-14,   6.323843040842554e-16,
   2.606068215402370e-17,   1.465204890286509e-01,  -1.782133873102487e-03,   1.573965496309880e-05,  -8.981412260116688e-08,   1.636221583690974e-09,  -6.012217949162314e-12,
  -9.475472668079740e-13,  -1.611164372945995e-14,   6.308338078745624e-16,   2.573989973559957e-17,   1.465243950245189e-01,  -1.782200708673450e-03,   1.574207369957167e-05,
  -8.982952313699650e-08,   1.632734775627503e-09,  -6.093616894010879e-12,  -9.431924648575107e-13,  -1.588818544506052e-14,   6.291714911487407e-16,   2.540096405265090e-17,
   1.465274692027445e-01,  -1.782253311387704e-03,   1.574397605036939e-05,  -8.984169005523836e-08,   1.629994426505330e-09,  -6.157408123200289e-12,  -9.397679684220786e-13,
  -1.571302581521124e-14,   6.278509398129702e-16,   2.513526042687243e-17,   1.465292434267945e-01,  -1.782283670554570e-03,   1.574507345051734e-05,  -8.984873046788479e-08,
   1.628414434894546e-09,  -6.194115209881981e-12,  -9.377927341685020e-13,  -1.561221909698479e-14,   6.270839252197460e-16,   2.498233426442294e-17,   1.465299096760905e-01,
  -1.782295070934009e-03,   1.574548544380153e-05,  -8.985137773245808e-08,   1.627821419073736e-09,  -6.207878683754204e-12,  -9.370512243879310e-13,  -1.557441828017267e-14,
   6.267949814780147e-16,   2.492498765055508e-17,   1.465300201170029e-01,  -1.782296960721189e-03,   1.574555373276563e-05,  -8.985181674001396e-08,   1.627723133338160e-09,
  -6.210159100880484e-12,  -9.369283196380086e-13,  -1.556815505380644e-14,   6.267470363615892e-16,   2.491548577775470e-17,   2.455415040809321e-01,  -2.969755634380301e-03,
   2.540829371764879e-05,  -1.261302103866325e-07,   2.480410389434303e-09,  -5.876975029789543e-12,  -1.732161343847535e-12,  -2.882377589933976e-14,   1.122173979352668e-15,
   4.679437430449350e-17,   2.455451240849522e-01,  -2.969809514277697e-03,   2.541039097670698e-05,  -1.261392667822972e-07,   2.476765553432581e-09,  -5.959450963477449e-12,
  -1.727724540821151e-12,  -2.859340700675864e-14,   1.120527559537600e-15,   4.644389837075241e-17,   2.455510671200232e-01,  -2.969897969807079e-03,   2.541383173430553e-05,
  -1.261542176398807e-07,   2.470788791727072e-09,  -6.094357018777758e-12,  -1.720445683878473e-12,  -2.821650264035480e-14,   1.117801662981282e-15,   4.587043073289630e-17,
   2.455573734284141e-01,  -2.969991831994324e-03,   2.541747961211114e-05,  -1.261701946181090e-07,   2.464456259157931e-09,  -6.236836238793894e-12,  -1.712728912947722e-12,
  -2.781831846271134e-14,   1.114878196886283e-15,   4.526450979983678e-17,   2.455623367353057e-01,  -2.970065704960466e-03,   2.542034831771669e-05,  -1.261828501572403e-07,
   2.459479233723480e-09,  -6.348486730740469e-12,  -1.706660622738787e-12,  -2.750620257150831e-14,   1.112555086202435e-15,   4.478950679025047e-17,   2.455652012405341e-01,
  -2.970108339672417e-03,   2.542200302519022e-05,  -1.261901865443410e-07,   2.456609584017473e-09,  -6.412729831941717e-12,  -1.703160446671838e-12,  -2.732657732507187e-14,
   1.111205480918307e-15,   4.451611794819567e-17,   2.455662769065608e-01,  -2.970124349653907e-03,   2.542262421830180e-05,  -1.261929475892830e-07,   2.455532510134762e-09,
  -6.436817401736008e-12,  -1.701846465949941e-12,  -2.725922120154561e-14,   1.110697016706246e-15,   4.441359836766127e-17,   2.455664552144366e-01,  -2.970127003549288e-03,
   2.542272718119619e-05,  -1.261934055966937e-07,   2.455353996523976e-09,  -6.440808344530693e-12,  -1.701628674393156e-12,  -2.724806096572877e-14,   1.110612643339393e-15,
   4.439661169700698e-17,   3.734965780136912e-01,  -4.480390583066937e-03,   3.651622486749361e-05,  -1.380717937567552e-07,   3.193804025755351e-09,  -9.308187565767726e-13,
  -2.913064629597369e-12,  -4.701765430547013e-14,   1.850576369474102e-15,   7.747526657363390e-17,   3.735017799543090e-01,  -4.480449537849942e-03,   3.651891718204763e-05,
  -1.380742480338306e-07,   3.187672607854357e-09,  -1.065266446575454e-12,  -2.905747214111611e-12,  -4.663633114563258e-14,   1.847895401993074e-15,   7.689170771082669e-17,
   3.735103200533643e-01,  -4.480546322689498e-03,   3.652333329585064e-05,  -1.380784129093891e-07,   3.177618151995523e-09,  -1.285170519111739e-12,  -2.893742436934619e-12,
  -4.601246446145155e-14,   1.843455058485909e-15,   7.593685906045923e-17,   3.735193821275289e-01,  -4.480649020296191e-03,   3.652801403263635e-05,  -1.380830162507110e-07,
   3.166964892198130e-09,  -1.517402540472251e-12,  -2.881015298434825e-12,  -4.535339165735902e-14,   1.838690747654219e-15,   7.492797698261031e-17,   3.735265142945435e-01,
  -4.480729844891917e-03,   3.653169410660329e-05,  -1.380867720325380e-07,   3.158591789310535e-09,  -1.699373589211709e-12,  -2.871006882297518e-12,  -4.483679108774259e-14,
   1.834903304593190e-15,   7.413708050713113e-17,   3.735306305145789e-01,  -4.480776490769061e-03,   3.653381647090468e-05,  -1.380889927349145e-07,   3.153763942939327e-09,
  -1.804073901908206e-12,  -2.865234015349977e-12,  -4.453948820198512e-14,   1.832702400057103e-15,   7.368187951708481e-17,   3.735321762163487e-01,  -4.480794006840306e-03,
   3.653461316049816e-05,  -1.380898366660031e-07,   3.151951876674094e-09,  -1.843329742725376e-12,  -2.863066850378108e-12,  -4.442800609401962e-14,   1.831873096561813e-15,
   7.351118138048492e-17,   3.735324324396082e-01,  -4.480796910384101e-03,   3.653474520847011e-05,  -1.380899770887269e-07,   3.151651544959039e-09,  -1.849833788002600e-12,
  -2.862707643670679e-12,  -4.440953467363820e-14,   1.831735477992495e-15,   7.348289808051168e-17,   5.339833206467121e-01,  -6.327874626778962e-03,   4.771091093919635e-05,
  -8.454882148488573e-08,   3.417862389303814e-09,   1.266371366715808e-11,  -4.695843085555383e-12,  -7.519920878602767e-14,   2.976672772728389e-15,   1.244821356000842e-16,
   5.339901160150418e-01,  -6.327910665600575e-03,   4.771377332909599e-05,  -8.453260646385509e-08,   3.407978295494516e-09,   1.244872051971981e-11,  -4.684071559033320e-12,
  -7.458677121128652e-14,   2.972428923402116e-15,   1.235352401680363e-16,   5.340012719977488e-01,  -6.327969824575484e-03,   4.771846634995329e-05,  -8.450620399220862e-08,
   3.391770068827877e-09,   1.209708096986116e-11,  -4.664759286418071e-12,  -7.358482323683133e-14,   2.965397028171343e-15,   1.219858969342022e-16,   5.340131097458023e-01,
  -6.328032590626841e-03,   4.772343778409301e-05,  -8.447848327123652e-08,   3.374596493754068e-09,   1.172573578905089e-11,  -4.644284688406222e-12,  -7.252638111017624e-14,
   2.957848030447871e-15,   1.203488997716411e-16,   5.340224263965273e-01,  -6.328081983382908e-03,   4.772734437949096e-05,  -8.445687945882380e-08,   3.361098606839447e-09,
   1.143476463907651e-11,  -4.628183615482854e-12,  -7.169677788862966e-14,   2.951843989246883e-15,   1.190656184063864e-16,   5.340278033303173e-01,  -6.328110487131197e-03,
   4.772959656885161e-05,  -8.444449648536581e-08,   3.353315847411630e-09,   1.126735131770426e-11,  -4.618896425162047e-12,  -7.121935636460274e-14,   2.948353872146195e-15,
   1.183270313266321e-16,   5.340298224436720e-01,  -6.328121190237320e-03,   4.773044183808351e-05,  -8.443986260099301e-08,   3.350394692116409e-09,   1.120458256490790e-11,
  -4.615409951102249e-12,  -7.104033632720846e-14,   2.947038579691094e-15,   1.180500660135923e-16,   5.340301571417325e-01,  -6.328122964412726e-03,   4.773058192980859e-05,
  -8.443909531424664e-08,   3.349910539931969e-09,   1.119418283945177e-11,  -4.614832068748865e-12,  -7.101067471687968e-14,   2.946820302672046e-15,   1.180041751668769e-16,
   7.325338642305872e-01,  -8.516779896744398e-03,   5.593477697703731e-05,   1.202858092920848e-07,   2.547004704025871e-09,   3.614587587314861e-11,  -7.370167959411748e-12,
  -1.241493836309047e-13,   4.869349487974900e-15,   2.017672417918830e-16,   7.325418283556605e-01,  -8.516728373483443e-03,   5.593686399385198e-05,   1.203342624638108e-07,
   2.531500803950473e-09,   3.579063045492735e-11,  -7.350911051397945e-12,  -1.231573627319077e-13,   4.862440093795799e-15,   2.002080358976589e-16,   7.325549029569431e-01,
  -8.516643775449605e-03,   5.594028067423821e-05,   1.204134473128925e-07,   2.506078273942125e-09,   3.520955342200227e-11,  -7.319318245105493e-12,  -1.215345088872886e-13,
   4.850987696808382e-15,   1.976568912088801e-16,   7.325687763921992e-01,  -8.516553991071893e-03,   5.594389314102558e-05,   1.204969819970177e-07,   2.479143258119095e-09,
   3.459585463328812e-11,  -7.285823900235547e-12,  -1.198202772534088e-13,   4.838688065661286e-15,   1.949615283750853e-16,   7.325796950557559e-01,  -8.516483316348730e-03,
   5.594672684275096e-05,   1.205623728736128e-07,   2.457974389654468e-09,   3.411494232412792e-11,  -7.259484126631434e-12,  -1.184767595912070e-13,   4.828902057746747e-15,
   1.928486509994829e-16,   7.325859965088803e-01,  -8.516442523008838e-03,   5.594835849063513e-05,   1.205999706890497e-07,   2.445769094045368e-09,   3.383822720076300e-11,
  -7.244291169710068e-12,  -1.177036262176909e-13,   4.823212094271241e-15,   1.916326267136476e-16,   7.325883627820825e-01,  -8.516427203652102e-03,   5.594897048465470e-05,
   1.206140625155751e-07,   2.441188089814745e-09,   3.373447436146420e-11,  -7.238587626181460e-12,  -1.174137292218422e-13,   4.821067500356486e-15,   1.911766318874872e-16,
   7.325887550265213e-01,  -8.516424664193995e-03,   5.594907189418697e-05,   1.206163970389902e-07,   2.440428839135841e-09,   3.371728409120611e-11,  -7.237642264776151e-12,
  -1.173656969091316e-13,   4.820711584300900e-15,   1.911010776744557e-16,   9.781036920483916e-01,  -1.100307619036231e-02,   5.325259628715675e-05,   6.779306925516193e-07,
  -2.970308131553365e-11,   4.206590128633319e-11,  -1.117656260954006e-11,  -2.251567527921731e-13,   8.495274441178622e-15,   3.506327139596935e-16,   9.781112699638493e-01,
  -1.100278657554479e-02,   5.325243820902029e-05,   6.779851302909446e-07,  -5.316225369007275e-11,   4.142040795279799e-11,  -1.114298726019567e-11,  -2.234343003946789e-13,
   8.482208694080267e-15,   3.478669338177963e-16,   9.781237103014302e-01,  -1.100231111039515e-02,   5.325216434696282e-05,   6.780738460324313e-07,  -9.162262967613358e-11,
   4.036439888486225e-11,  -1.108790663648183e-11,  -2.206167395937393e-13,   8.460563688153665e-15,   3.433420505289224e-16,   9.781369104099932e-01,  -1.100180658408791e-02,
   5.325185427103088e-05,   6.781670953741700e-07,  -1.323618951296826e-10,   3.924887125650931e-11,  -1.102951479907964e-11,  -2.176408170296743e-13,   8.437333012132172e-15,
   3.385619666468142e-16,   9.781472989271949e-01,  -1.100140950408598e-02,   5.325159614409041e-05,   6.782398439964989e-07,  -1.643731354391225e-10,   3.837454118899815e-11,
  -1.098359869789389e-11,  -2.153086644313089e-13,   8.418861025392204e-15,   3.348153216774212e-16,   9.781532943283394e-01,  -1.100118033540809e-02,   5.325144152828597e-05,
   6.782815729934735e-07,  -1.828271035039866e-10,   3.787138661175351e-11,  -1.095711516082299e-11,  -2.139666994742860e-13,   8.408125105100188e-15,   3.326591886599194e-16,
   9.781555456581760e-01,  -1.100109427915159e-02,   5.325138240195284e-05,   6.782971943879165e-07,  -1.897529077017630e-10,   3.768271857276100e-11,  -1.094717327622360e-11,
  -2.134635269175468e-13,   8.404079474573233e-15,   3.318506969599197e-16,   9.781559188481673e-01,  -1.100108001403527e-02,   5.325137254466399e-05,   6.782997813133044e-07,
  -1.909007561026253e-10,   3.765145845911318e-11,  -1.094552542223184e-11,  -2.133801583338386e-13,   8.403408106533579e-15,   3.317167389425235e-16,   1.286507327181068e+00,
  -1.349579960920043e-02,   1.373144915757964e-05,   2.127019921278177e-06,   8.900959486754002e-10,  -2.583682031648879e-10,  -1.581173682308529e-11,  -4.313757941914379e-13,
   1.604386557363800e-14,   7.633253725038652e-16,   1.286509282417005e+00,  -1.349489287498760e-02,   1.373202254806655e-05,   2.126641916040508e-06,   8.570933700556611e-10,
  -2.595978728058887e-10,  -1.574856405261007e-11,  -4.276328818744895e-13,   1.600779831988670e-14,   7.570447089277375e-16,   1.286512492282587e+00,  -1.349340444301718e-02,
   1.373294373173678e-05,   2.126020119019194e-06,   8.030113542661572e-10,  -2.616085982441036e-10,  -1.564496171358244e-11,  -4.215112522679572e-13,   1.594821781568302e-14,
   7.467723632394918e-16,   1.286515898236876e+00,  -1.349182526356819e-02,   1.373389385361749e-05,   2.125358663160081e-06,   7.457579746948156e-10,  -2.637313198869401e-10,
  -1.553517624067574e-11,  -4.150468661817021e-13,   1.588449964724500e-14,   7.359246939591816e-16,   1.286518578768052e+00,  -1.349058255842823e-02,   1.373462184598215e-05,
   2.124836880197200e-06,   7.007946330116681e-10,  -2.653941049017939e-10,  -1.544887964735405e-11,  -4.099818428062488e-13,   1.583399565951516e-14,   7.274251692423040e-16,
   1.286520125765653e+00,  -1.348986541609728e-02,   1.373503407284373e-05,   2.124535263668955e-06,   6.748836142001497e-10,  -2.663506077410853e-10,  -1.539911849099141e-11,
  -4.070677108192194e-13,   1.580470670894374e-14,   7.225349980549987e-16,   1.286520706680614e+00,  -1.348959613093048e-02,   1.373518737372678e-05,   2.124421912058050e-06,
   6.651609872829067e-10,  -2.667091946333774e-10,  -1.538044069341751e-11,  -4.059751224881495e-13,   1.579368169546097e-14,   7.207015362272462e-16,   1.286520802975687e+00,
  -1.348955149352977e-02,   1.373521270673054e-05,   2.124403117576782e-06,   6.635497034326405e-10,  -2.667686044683280e-10,  -1.537734500417965e-11,  -4.057940998103923e-13,
   1.579185273539138e-14,   7.203977637691959e-16,   1.687264015578904e+00,  -1.375442649435707e-02,  -1.877895313964988e-04,   4.635381155564361e-06,   1.624065216400168e-07,
  -2.764173607548389e-09,  -1.755977176620024e-10,   1.105018381571905e-12,   1.885279107301271e-13,   8.250307670429382e-16,   1.687237566409953e+00,  -1.375246133900263e-02,
  -1.876529322443938e-04,   4.631475950627883e-06,   1.620402967510846e-07,  -2.760813853124506e-09,  -1.748702350590093e-10,   1.108683552947820e-12,   1.873782033506372e-13,
   8.038503302387753e-16,   1.687194159537818e+00,  -1.374923641669442e-02,  -1.874289059169876e-04,   4.625068403548085e-06,   1.614401891607614e-07,  -2.755290715211790e-09,
  -1.736792274821855e-10,   1.114624217713875e-12,   1.854974483496458e-13,   7.693609614806991e-16,   1.687148120125046e+00,  -1.374581615279273e-02,  -1.871914997654668e-04,
   4.618274232968747e-06,   1.608049342409090e-07,  -2.749420056825653e-09,  -1.724199140026521e-10,   1.120824577015175e-12,   1.835108711251944e-13,   7.331458221532719e-16,
   1.687111900346851e+00,  -1.374312556531550e-02,  -1.870048790362596e-04,   4.612930614367564e-06,   1.603060732359189e-07,  -2.744792515122548e-09,  -1.714320324201750e-10,
   1.125630052670781e-12,   1.819539576930620e-13,   7.049182912694468e-16,   1.687091002605566e+00,  -1.374157324679097e-02,  -1.868972643186838e-04,   4.609848083273933e-06,
   1.600186061943369e-07,  -2.742118965817899e-09,  -1.708631885643267e-10,   1.128373772041571e-12,   1.810580452618293e-13,   6.887368974175046e-16,   1.687083156316377e+00,
  -1.374099042496647e-02,  -1.868568704972847e-04,   4.608690822339467e-06,   1.599107416726395e-07,  -2.741114475193214e-09,  -1.706498240160775e-10,   1.129398485615789e-12,
   1.807221143465054e-13,   6.826812095664331e-16,   1.687081855735459e+00,  -1.374089381861285e-02,  -1.868501755173365e-04,   4.608499003501542e-06,   1.598928659191653e-07,
  -2.740947937741562e-09,  -1.706144685456575e-10,   1.129568052588162e-12,   1.806664549849658e-13,   6.816784770448156e-16,   2.793938338388724e-03,  -3.338185037565994e-05,
   3.070715316293985e-07,  -1.631535768317755e-09,   2.894977143092546e-11,  -6.389270001783068e-13,  -1.819468360432258e-14,   2.807090787761947e-16,   2.210833650566441e-17,
  -4.343257635448930e-20,   2.793982086198259e-03,  -3.338255010021615e-05,   3.070960363890026e-07,  -1.632437965090389e-09,   2.891194246696286e-11,  -6.380923172395936e-13,
  -1.810935998166444e-14,   2.804505045774265e-16,   2.197415174210956e-17,  -4.479676006421509e-20,   2.794053907796505e-03,  -3.338369908809906e-05,   3.071362418919555e-07,
  -1.633918210408702e-09,   2.884997027586073e-11,  -6.367226316093675e-13,  -1.796966947941422e-14,   2.800211278454323e-16,   2.175463589777100e-17,  -4.701422680164803e-20,
   2.794130119444651e-03,  -3.338491862907460e-05,   3.071788717875641e-07,  -1.635487701118562e-09,   2.878438959050432e-11,  -6.352700852626320e-13,  -1.782196506769954e-14,
   2.795589304134564e-16,   2.152275648718025e-17,  -4.933732061468267e-20,   2.794190100859597e-03,  -3.338587868637433e-05,   3.072123991473585e-07,  -1.636722056071282e-09,
   2.873290485798511e-11,  -6.341275043840306e-13,  -1.770609502467038e-14,   2.791904377142776e-16,   2.134101972772846e-17,  -5.114416045367570e-20,   2.794224718287786e-03,
  -3.338643286326698e-05,   3.072317393974933e-07,  -1.637434088831216e-09,   2.870324308256006e-11,  -6.334683328522202e-13,  -1.763937380594450e-14,   2.789758842847790e-16,
   2.123643721876065e-17,  -5.217837050148305e-20,   2.794237717661634e-03,  -3.338664098280834e-05,   3.072390001455057e-07,  -1.637701400409763e-09,   2.869211443397177e-11,
  -6.332208518324245e-13,  -1.761434757307126e-14,   2.788949616222763e-16,   2.119722231373674e-17,  -5.256511542279334e-20,   2.794239872503695e-03,  -3.338667548268832e-05,
   3.072402036283332e-07,  -1.637745707764501e-09,   2.869027020964930e-11,  -6.331798306598767e-13,  -1.761020060607138e-14,   2.788815287997012e-16,   2.119072487978027e-17,
  -5.262913905815270e-20,   2.522602262513904e-02,  -3.011670897769622e-04,   2.757435021088800e-06,  -1.429168468603756e-08,   2.564944905008545e-10,  -5.747766509043959e-12,
  -1.671284915210601e-13,   2.577259597125707e-15,   2.020742259209356e-16,  -3.971765670573013e-19,   2.522641546483111e-02,  -3.011732198682201e-04,   2.757652062943260e-06,
  -1.429979951256425e-08,   2.561469636739468e-10,  -5.740102938526906e-12,  -1.663486564439371e-13,   2.574894235907200e-15,   2.008458863544322e-16,  -4.096815635003042e-19,
   2.522706039679506e-02,  -3.011832858943044e-04,   2.758008160724813e-06,  -1.431311344786661e-08,   2.555776318919247e-10,  -5.727527267055374e-12,  -1.650719280842371e-13,
   2.570966332617155e-15,   1.988364249526030e-16,  -4.300080225959129e-19,   2.522774474938907e-02,  -3.011939701077026e-04,   2.758385720878800e-06,  -1.432722987515983e-08,
   2.549751409042166e-10,  -5.714190789629679e-12,  -1.637219624452037e-13,   2.566738068160054e-15,   1.967137957574037e-16,  -4.513023274041761e-19,   2.522828336014206e-02,
  -3.012023810872373e-04,   2.758682655137030e-06,  -1.433833184234527e-08,   2.545021436380966e-10,  -5.703700224727088e-12,  -1.626629569329746e-13,   2.563366946663841e-15,
   1.950501800323930e-16,  -4.678641840056457e-19,   2.522859421162156e-02,  -3.012072362087166e-04,   2.758853938603130e-06,  -1.434473590483095e-08,   2.542296344248275e-10,
  -5.697648057560318e-12,  -1.620531540191292e-13,   2.561404091249537e-15,   1.940928358484631e-16,  -4.773438482358670e-19,   2.522871094108379e-02,  -3.012090595404364e-04,
   2.758918241553157e-06,  -1.434714010816481e-08,   2.541273926377793e-10,  -5.695375815229521e-12,  -1.618244255431629e-13,   2.560663759063623e-15,   1.937338646424514e-16,
  -4.808887663551556e-19,   2.522873029074953e-02,  -3.012093617935435e-04,   2.758928899859873e-06,  -1.434753860837886e-08,   2.541104492452941e-10,  -5.694999180028397e-12,
  -1.617865241573995e-13,   2.560540866702887e-15,   1.936743874952929e-16,  -4.814756082161288e-19,   7.052954255236908e-02,  -8.406798110136785e-04,   7.621598887949946e-06,
  -3.739301271809516e-08,   6.886557497298212e-10,  -1.595368946691490e-11,  -4.838107537759705e-13,   7.454550481505227e-15,   5.794769480504243e-16,  -1.141608875026349e-18,
   7.053062833280623e-02,  -8.406958544254881e-04,   7.622181204251890e-06,  -3.741552893791122e-08,   6.876494601784698e-10,  -1.593152246331567e-11,  -4.815746864567860e-13,
   7.447748525982222e-15,   5.759437075457992e-16,  -1.177673808228915e-18,   7.053241087616337e-02,  -8.407221991873655e-04,   7.623136558064124e-06,  -3.745247020464786e-08,
   6.860008843358851e-10,  -1.589514703900181e-11,  -4.779138790980777e-13,   7.436452880911088e-15,   5.701636608853030e-16,  -1.236294400728452e-18,   7.053430237265804e-02,
  -8.407501623965136e-04,   7.624149430808592e-06,  -3.749163683075408e-08,   6.842562457802547e-10,  -1.585657084550005e-11,  -4.740431187324823e-13,   7.424292993804299e-15,
   5.640581522968611e-16,  -1.297703819324493e-18,   7.053579104839894e-02,  -8.407721763779409e-04,   7.624945965854584e-06,  -3.752243879650914e-08,   6.828865501318621e-10,
  -1.582622645887216e-11,  -4.710066601269214e-13,   7.414597790539266e-15,   5.592729856014924e-16,  -1.345463866597505e-18,   7.053665021554437e-02,  -8.407848837974316e-04,
   7.625405421137821e-06,  -3.754020624666428e-08,   6.820974102824863e-10,  -1.580872028345243e-11,  -4.692582007013767e-13,   7.408952569363138e-15,   5.565193300816419e-16,
  -1.372800032651866e-18,   7.053697284574734e-02,  -8.407896560738670e-04,   7.625577905711690e-06,  -3.754687640637341e-08,   6.818013331148635e-10,  -1.580214771001214e-11,
  -4.686023805653656e-13,   7.406823331028906e-15,   5.554868068418267e-16,  -1.383022253198114e-18,   7.053702632655344e-02,  -8.407904471741113e-04,   7.625606495101677e-06,
  -3.754798199143464e-08,   6.817522674107290e-10,  -1.580105827369370e-11,  -4.684937082036684e-13,   7.406469884185934e-15,   5.553157305053753e-16,  -1.384714479083031e-18,
   1.396319950983268e-01,  -1.660025731262003e-03,   1.480785633191539e-05,  -6.581795952318945e-08,   1.272664402058765e-09,  -3.124800495566013e-11,  -1.010060070598473e-12,
   1.554825838988510e-14,   1.194324214749402e-15,  -2.370134285151693e-18,   1.396341045262095e-01,  -1.660053986045682e-03,   1.480893110884193e-05,  -6.586203757756163e-08,
   1.270562838842568e-09,  -3.120176930595027e-11,  -1.005452146912314e-12,   1.553413484427575e-14,   1.187008170767048e-15,  -2.445082763097298e-18,   1.396375676022366e-01,
  -1.660100384357244e-03,   1.481069424941561e-05,  -6.593435138074613e-08,   1.267119812111466e-09,  -3.112589777301169e-11,  -9.979083221768019e-13,   1.551068044431511e-14,
   1.175039959127149e-15,  -2.566899141579625e-18,   1.396412423413247e-01,  -1.660149634907190e-03,   1.481256334097321e-05,  -6.601101743603873e-08,   1.263476030735474e-09,
  -3.104543569999341e-11,  -9.899319814814599e-13,   1.548543129472212e-14,   1.162398037554271e-15,  -2.694502378963310e-18,   1.396441344872356e-01,  -1.660188408632368e-03,
   1.481403307015683e-05,  -6.607130735461916e-08,   1.260615246345851e-09,  -3.098214335485245e-11,  -9.836749543271807e-13,   1.546529973595248e-14,   1.152490125153307e-15,
  -2.793737327708196e-18,   1.396458036440441e-01,  -1.660210791030024e-03,   1.481488077686905e-05,  -6.610608314284215e-08,   1.258966989368566e-09,  -3.094562890308812e-11,
  -9.800720598214479e-13,   1.545357768686575e-14,   1.146788608373709e-15,  -2.850533451406974e-18,   1.396464304371204e-01,  -1.660219196848706e-03,   1.481519900421796e-05,
  -6.611913826269497e-08,   1.258348573170307e-09,  -3.093191979181027e-11,  -9.787206770674381e-13,   1.544915640863634e-14,   1.144650752269439e-15,  -2.871771607711667e-18,
   1.396465343374717e-01,  -1.660220590286526e-03,   1.481525174994874e-05,  -6.612130214923571e-08,   1.258246089289084e-09,  -3.092964743872885e-11,  -9.784967472228664e-13,
   1.544842248988324e-14,   1.144296536503562e-15,  -2.875287429556222e-18,   2.340603493291212e-01,  -2.771893471796697e-03,   2.412112175163125e-05,  -8.982563364592741e-08,
   1.908781504938600e-09,  -5.168905342492832e-11,  -1.820666569658449e-12,   2.801006900520446e-14,   2.122315765943604e-15,  -4.289540698026086e-18,   2.340637851759868e-01,
  -2.771932077587867e-03,   2.412273013053901e-05,  -8.989848812278572e-08,   1.904991953511606e-09,  -5.160576164011385e-11,  -1.812479971086301e-12,   2.798453715212429e-14,
   2.109232964576455e-15,  -4.424090978539654e-18,   2.340694258368769e-01,  -2.771995477560378e-03,   2.412536823678898e-05,  -9.001800504615617e-08,   1.898783279310465e-09,
  -5.146908210905647e-11,  -1.799077587192122e-12,   2.794214093053680e-14,   2.087831399501571e-15,  -4.642762301346486e-18,   2.340754112343809e-01,  -2.772062780149673e-03,
   2.412816433878338e-05,  -9.014470558317421e-08,   1.892212336828833e-09,  -5.132413315071788e-11,  -1.784907118727683e-12,   2.789650521299262e-14,   2.065225652001427e-15,
  -4.871797189930796e-18,   2.340801219331126e-01,  -2.772115769581259e-03,   2.413036262090465e-05,  -9.024433549803577e-08,   1.887053211620755e-09,  -5.121011489470094e-11,
  -1.773791353210561e-12,   2.786012246738647e-14,   2.047509138773267e-15,  -5.049896217036801e-18,   2.340828406333474e-01,  -2.772146359609398e-03,   2.413163038571690e-05,
  -9.030180017800977e-08,   1.884080678355643e-09,  -5.114433585556551e-11,  -1.767390814925259e-12,   2.783893913172712e-14,   2.037314314231780e-15,  -5.151822309720465e-18,
   2.340838615443906e-01,  -2.772157848130298e-03,   2.413210627274619e-05,  -9.032337236964931e-08,   1.882965387519312e-09,  -5.111963956027649e-11,  -1.764990102668889e-12,
   2.783094953036642e-14,   2.033491665268340e-15,  -5.189934875344470e-18,   2.340840307756458e-01,  -2.772159752604704e-03,   2.413218514880120e-05,  -9.032694793332492e-08,
   1.882780560871788e-09,  -5.111554602773495e-11,  -1.764592295420501e-12,   2.782962329390910e-14,   2.032858302175786e-15,  -5.196244061592113e-18,   3.561499732882298e-01,
  -4.194047235462495e-03,   3.515218350162891e-05,  -9.121513306742474e-08,   2.413988112583550e-09,  -7.765360479246743e-11,  -3.043028242565618e-12,   4.685206903605234e-14,
   3.505328714631510e-15,  -7.375592948902652e-18,   3.561549797744943e-01,  -4.194086563236888e-03,   3.515420885320784e-05,  -9.132446436613028e-08,   2.407652367868789e-09,
  -7.751429990052330e-11,  -3.029510434080327e-12,   4.680834867720997e-14,   3.483544562060442e-15,  -7.600178522469498e-18,   3.561631989348290e-01,  -4.194151159606843e-03,
   3.515752993614898e-05,  -9.150380640990906e-08,   2.397271835528028e-09,  -7.728570658980991e-11,  -3.007380770321216e-12,   4.673577121125833e-14,   3.447909892611941e-15,
  -7.965126587498112e-18,   3.561719203747424e-01,  -4.194219746803824e-03,   3.516104862338429e-05,  -9.169390791892067e-08,   2.386285258017196e-09,  -7.704328583176741e-11,
  -2.983983558933957e-12,   4.665767646848003e-14,   3.410271616038211e-15,  -8.347304553497271e-18,   3.561787843931395e-01,  -4.194273758180805e-03,   3.516381406134643e-05,
  -9.184337820085052e-08,   2.377658973784389e-09,  -7.685259746678737e-11,  -2.965630544487826e-12,   4.659543617593766e-14,   3.380774875659785e-15,  -8.644440644078401e-18,
   3.561827458322376e-01,  -4.194304942381380e-03,   3.516540853327422e-05,  -9.192958407701256e-08,   2.372688664248505e-09,  -7.674258702237076e-11,  -2.955062946598857e-12,
   4.655920561270542e-14,   3.363801624999449e-15,  -8.814472377117326e-18,   3.561842334070991e-01,  -4.194316654848974e-03,   3.516600698693450e-05,  -9.196194459247113e-08,
   2.370823790675363e-09,  -7.670128450827281e-11,  -2.951099292624455e-12,   4.654554222071697e-14,   3.357437416598428e-15,  -8.878047591730012e-18,   3.561844799947210e-01,
  -4.194318596489477e-03,   3.516610617409088e-05,  -9.196730824940974e-08,   2.370514741708793e-09,  -7.669443842180355e-11,  -2.950442501926691e-12,   4.654327423968684e-14,
   3.356382954338502e-15,  -8.888571693357872e-18,   5.094300555318486e-01,  -5.949339153139149e-03,   4.701158093038504e-05,  -3.443331274727346e-08,   2.445260924620069e-09,
  -1.108491036350148e-10,  -4.893633267613849e-12,   7.568374009848152e-14,   5.626580143255732e-15,  -1.283786611261887e-17,   5.094367497070041e-01,  -5.949354403699560e-03,
   4.701361119799898e-05,  -3.458916102020971e-08,   2.435071544914394e-09,  -1.106241493365611e-10,  -4.871942600891015e-12,   7.560838511821526e-14,   5.591249702483689e-15,
  -1.320074820391175e-17,   5.094477394789149e-01,  -5.949379487609585e-03,   4.701693800368474e-05,  -3.484478032879861e-08,   2.418377108644518e-09,  -1.102550193159636e-10,
  -4.836434410482817e-12,   7.548338059402001e-14,   5.533458615059284e-15,  -1.379028905567647e-17,   5.094594007478228e-01,  -5.949406168294366e-03,   4.702045957659342e-05,
  -3.511569852038741e-08,   2.400707895110094e-09,  -1.098635748403923e-10,  -4.798893802753099e-12,   7.534899057282346e-14,   5.472421802299324e-15,  -1.440747727252205e-17,
   5.094685784240776e-01,  -5.949427212960336e-03,   4.702322498166679e-05,  -3.532868554638822e-08,   2.386834554873362e-09,  -1.095556744091567e-10,  -4.769447593964725e-12,
   7.524196712280223e-14,   5.424590507069158e-15,  -1.488719446679033e-17,   5.094738751191289e-01,  -5.949439377009073e-03,   4.702481851215618e-05,  -3.545151355094565e-08,
   2.378840954234366e-09,  -1.093780469482541e-10,  -4.752492988818445e-12,   7.517970077496335e-14,   5.397068098976273e-15,  -1.516165131538932e-17,   5.094758640956405e-01,
  -5.949443948275067e-03,   4.702541643807026e-05,  -3.549761949626185e-08,   2.375841727591616e-09,  -1.093113589495657e-10,  -4.746133798740680e-12,   7.515622481946085e-14,
   5.386748629398576e-15,  -1.526426102077258e-17,   5.094761937977502e-01,  -5.949444706214809e-03,   4.702551552855702e-05,  -3.550526130977954e-08,   2.375344692024733e-09,
  -1.093003051397715e-10,  -4.745080063826837e-12,   7.515232837701215e-14,   5.385038845034462e-15,  -1.528124626353737e-17,   6.993718093323776e-01,  -8.062846976055523e-03,
   5.761315222113457e-05,   1.564249889850381e-07,   1.336497663863890e-09,  -1.588711383327560e-10,  -7.736111362516197e-12,   1.214925322625703e-13,   9.122072422488709e-15,
  -2.422865995019597e-17,   6.993800102174738e-01,  -8.062780982158738e-03,   5.761420238086829e-05,   1.562019479399268e-07,   1.320399900331172e-09,  -1.585103230350889e-10,
  -7.700962396869703e-12,   1.213530299613726e-13,   9.063964689802022e-15,  -2.481120637012627e-17,   6.993934733915532e-01,  -8.062672710605194e-03,   5.761591658472866e-05,
   1.558361601227188e-07,   1.294026411356328e-09,  -1.579182974310509e-10,  -7.643425011880070e-12,   1.211219352983246e-13,   8.968923485216371e-15,  -2.575718065635659e-17,
   6.994077589870181e-01,  -8.062557918621401e-03,   5.761772218186467e-05,   1.554485338688541e-07,   1.266114802927336e-09,  -1.572905377254144e-10,  -7.582597545926927e-12,
   1.208739210621946e-13,   8.868554506352956e-15,  -2.674692670651462e-17,   6.994190019174307e-01,  -8.062467643652413e-03,   5.761913357665899e-05,   1.551438339348809e-07,
   1.244200749851927e-09,  -1.567967972855395e-10,  -7.534887866326892e-12,   1.206767178719764e-13,   8.789907940347852e-15,  -2.751579014706626e-17,   6.994254904690496e-01,
  -8.062415571013479e-03,   5.761994426877325e-05,   1.549681314928603e-07,   1.231574742009467e-09,  -1.565119748002372e-10,  -7.507418415020832e-12,   1.205621057695460e-13,
   8.744657147781203e-15,  -2.795550145697975e-17,   6.994279269916112e-01,  -8.062396022285387e-03,   5.762024796431289e-05,   1.549021810399225e-07,   1.226837519401505e-09,
  -1.564050447819682e-10,  -7.497115582119013e-12,   1.205189167740499e-13,   8.727691005912839e-15,  -2.811986125383079e-17,   6.994283308804655e-01,  -8.062392782071078e-03,
   5.762029826783482e-05,   1.548912502621880e-07,   1.226052466219818e-09,  -1.563873208506681e-10,  -7.495408384299623e-12,   1.205117496286435e-13,   8.724879994623690e-15,
  -2.814706641630619e-17,   9.349948954406733e-01,  -1.054456148554081e-02,   6.136124374498223e-05,   6.681586548478595e-07,  -2.177711412138202e-09,  -2.607860526708311e-10,
  -1.207390743884135e-11,   2.008677644524121e-13,   1.569054525801807e-14,  -5.429049196075070e-17,   9.350036235699856e-01,  -1.054427752626895e-02,   6.135924269542346e-05,
   6.677925595505611e-07,  -2.202770035898973e-09,  -2.601906544270329e-10,  -1.201350710891632e-11,   2.005650427650591e-13,   1.558775624144402e-14,  -5.522366574478249e-17,
   9.350179519789322e-01,  -1.054381147294579e-02,   6.135594240937094e-05,   6.671921652006974e-07,  -2.243815755254968e-09,  -2.592138813230717e-10,  -1.191464251566029e-11,
   2.000647589469285e-13,   1.541965799909493e-14,  -5.673724642325960e-17,   9.350331552177645e-01,  -1.054331710616062e-02,   6.135241986989111e-05,   6.665559294947942e-07,
  -2.287243553866028e-09,  -2.581783632611551e-10,  -1.181013582045901e-11,   1.995294474287037e-13,   1.524216886082541e-14,  -5.831846371677726e-17,   9.350451200211961e-01,
  -1.054292814673734e-02,   6.134963266332678e-05,   6.660558086401408e-07,  -2.321331233565731e-09,  -2.573640696321610e-10,  -1.172817462541623e-11,   1.991049454136026e-13,
   1.510311621519653e-14,  -5.954505637993482e-17,   9.350520250526527e-01,  -1.054270371464884e-02,   6.134801812733412e-05,   6.657674195205055e-07,  -2.340967796107150e-09,
  -2.568943922091962e-10,  -1.168098764865148e-11,   1.988586800343466e-13,   1.502311896581332e-14,  -6.024584050411158e-17,   9.350546179434844e-01,  -1.054261944648128e-02,
   6.134741072280644e-05,   6.656591719655021e-07,  -2.348334704076127e-09,  -2.567180743149734e-10,  -1.166329006742325e-11,   1.987659646882405e-13,   1.499312689488943e-14,
  -6.050765370835486e-17,   9.350550477513488e-01,  -1.054260547826480e-02,   6.134730997721117e-05,   6.656412307800212e-07,  -2.349555515100736e-09,  -2.566888497749894e-10,
  -1.166035757863860e-11,   1.987505831454860e-13,   1.498815779381049e-14,  -6.055098251999493e-17,   1.232905122134971e+00,  -1.328415073485728e-02,   3.909576981703141e-05,
   2.076537072078843e-06,  -8.654211472862129e-09,  -7.027100718434171e-10,  -1.729673835214773e-11,   4.064352034559900e-13,   3.067797268249092e-14,  -1.692360135779568e-16,
   1.232910670483695e+00,  -1.328326771059356e-02,   3.908817984463977e-05,   2.075547183897685e-06,  -8.689742679923595e-09,  -7.015098889313224e-10,  -1.717911984473682e-11,
   4.055361033742392e-13,   3.045382611441062e-14,  -1.704645705791899e-16,   1.232919778183917e+00,  -1.328181838639837e-02,   3.907569818692711e-05,   2.073923350624738e-06,
  -8.747893881084938e-09,  -6.995415565963464e-10,  -1.698666674909740e-11,   4.040558001745476e-13,   3.008739173780584e-14,  -1.724462951645211e-16,   1.232929441052884e+00,
  -1.328028095306160e-02,   3.906242503665469e-05,   2.072202006370417e-06,  -8.809354021883477e-09,  -6.974556754654555e-10,  -1.678332208829987e-11,   4.024793303000008e-13,
   2.970066038483272e-14,  -1.745016524422935e-16,   1.232937044980691e+00,  -1.327907128282962e-02,   3.905195794129557e-05,   2.070848506449840e-06,  -8.857548115354698e-09,
  -6.958160141665832e-10,  -1.662391168341624e-11,   4.012345288412193e-13,   2.939780397715592e-14,  -1.760851929636117e-16,   1.232941433034809e+00,  -1.327837327783733e-02,
   3.904590875081423e-05,   2.070067858735860e-06,  -8.885291713230984e-09,  -6.948705116991083e-10,  -1.653216189595871e-11,   4.005144993784450e-13,   2.922362035354813e-14,
  -1.769855354812244e-16,   1.232943080731999e+00,  -1.327811119257446e-02,   3.904363562903546e-05,   2.069774809119427e-06,  -8.895696466233472e-09,  -6.945156133420660e-10,
  -1.649775594245282e-11,   4.002438151468826e-13,   2.915832599843813e-14,  -1.773210731420802e-16,   1.232943353858186e+00,  -1.327806774938031e-02,   3.904325874269692e-05,
   2.069726236769814e-06,  -8.897420504698848e-09,  -6.944567916296062e-10,  -1.649205514105828e-11,   4.001989292691985e-13,   2.914750849772145e-14,  -1.773765590639590e-16,
   1.629649039268523e+00,  -1.499565746841506e-02,  -1.190820592346060e-04,   6.585236434331743e-06,   7.092553131392235e-08,  -5.953058033686074e-09,  -6.670232026031509e-11,
   6.080233267930778e-12,   7.788461134384884e-14,  -6.389827574182120e-15,   1.629632213207500e+00,  -1.499287546060203e-02,  -1.190222849086554e-04,   6.576913541800381e-06,
   7.078667030569322e-08,  -5.935386818315465e-09,  -6.640431343264755e-11,   6.048823889731577e-12,   7.728547882808641e-14,  -6.340056318833399e-15,   1.629604596527689e+00,
  -1.498831087800248e-02,  -1.189242402625297e-04,   6.563268136058095e-06,   7.055916075995501e-08,  -5.906443646881438e-09,  -6.591678326133603e-11,   5.997441586992140e-12,
   7.630700801071195e-14,  -6.258749627120972e-15,   1.629575301276395e+00,  -1.498347094328089e-02,  -1.188203221209261e-04,   6.548813690420635e-06,   7.031837016788992e-08,
  -5.875823535544838e-09,  -6.540177348421579e-11,   5.943166556263741e-12,   7.527567627297555e-14,  -6.173019435392601e-15,   1.629552251678938e+00,  -1.497966437768570e-02,
  -1.187386210016338e-04,   6.537455591514850e-06,   7.012931059908869e-08,  -5.851790944309138e-09,  -6.499811524963316e-11,   5.900628987148513e-12,   7.446898390375256e-14,
  -6.105940275558209e-15,   1.629538951677076e+00,  -1.497746853097672e-02,  -1.186915029214415e-04,   6.530907666197915e-06,   7.002037819486051e-08,  -5.837947505923364e-09,
  -6.476581842097924e-11,   5.876150534193403e-12,   7.400541021573321e-14,  -6.067383694044658e-15,   1.629533957842230e+00,  -1.497664415700344e-02,  -1.186738158906281e-04,
   6.528450187579823e-06,   6.997950651313758e-08,  -5.832754110278887e-09,  -6.467871357803477e-11,   5.866971990975825e-12,   7.383170773115244e-14,  -6.052934750162674e-15,
   1.629533130066260e+00,  -1.497650751514896e-02,  -1.186708843431211e-04,   6.528042895587898e-06,   6.997273321410048e-08,  -5.831893491754865e-09,  -6.466428128801935e-11,
   5.865451220221311e-12,   7.380293376619669e-14,  -6.050541182035628e-15,   2.665209749641484e-03,  -3.099682395660239e-05,   2.897843363164427e-07,  -1.290261769622924e-09,
   1.282585734224328e-11,  -9.088934405517053e-13,  -1.875876606192567e-15,   7.958847445898029e-16,   5.514182362144804e-18,  -7.861568532431384e-19,   2.665251010061274e-03,
  -3.099737929458207e-05,   2.897952664372332e-07,  -1.291535686847545e-09,   1.282210080585480e-11,  -9.065766406845824e-13,  -1.854902582260906e-15,   7.920071604327388e-16,
   5.465702408632972e-18,  -7.805329140768443e-19,   2.665318746841003e-03,  -3.099829136033613e-05,   2.898132077596793e-07,  -1.293624670715783e-09,   1.281596567708982e-11,
  -9.027815174715313e-13,  -1.820607555147128e-15,   7.856619919972094e-16,   5.386532610923419e-18,  -7.713415837713117e-19,   2.665390622326005e-03,  -3.099925966032526e-05,
   2.898322418560432e-07,  -1.295838044732991e-09,   1.280949898144851e-11,  -8.987658258309303e-13,  -1.784403732839166e-15,   7.789570745813494e-16,   5.303092719819907e-18,
  -7.616447491883115e-19,   2.665447189815587e-03,  -3.100002209929217e-05,   2.898472196019341e-07,  -1.297577668941099e-09,   1.280444081018592e-11,  -8.956135654950344e-13,
  -1.756045186140939e-15,   7.737003300032018e-16,   5.237832431831158e-18,  -7.540535736492272e-19,   2.665479836462967e-03,  -3.100046227066760e-05,   2.898558626776457e-07,
  -1.298580714204586e-09,   1.280153409852210e-11,  -8.937975791426671e-13,  -1.739732481415253e-15,   7.706745799112796e-16,   5.200332069013407e-18,  -7.496886491546232e-19,
   2.665492095687423e-03,  -3.100062758829111e-05,   2.898591080735888e-07,  -1.298957192814924e-09,   1.280044495055707e-11,  -8.931162707602839e-13,  -1.733617003431893e-15,
   7.695398939952108e-16,   5.186280969631198e-18,  -7.480526113185064e-19,   2.665494127833769e-03,  -3.100065499357758e-05,   2.898596460357272e-07,  -1.299019590312208e-09,
   1.280026453264137e-11,  -8.930033664406485e-13,  -1.732603808012035e-15,   7.693518833362553e-16,   5.183953414319397e-18,  -7.477815745604553e-19,   2.406447245950971e-02,
  -2.797338235685897e-04,   2.606156001523090e-06,  -1.128839047365505e-08,   1.107894375878562e-10,  -8.231349916502572e-12,  -1.766753311078233e-14,   7.283532452175991e-15,
   5.018217464028226e-17,  -7.195263199206495e-18,   2.406484352448163e-02,  -2.797386835493551e-04,   2.606250398635188e-06,  -1.129992579050147e-08,   1.107539783061094e-10,
  -8.210147769199731e-12,  -1.747669216194237e-14,   7.248044848392200e-15,   4.973929499674799e-17,  -7.143722307456804e-18,   2.406545269738344e-02,  -2.797466655125060e-04,
   2.606405345602960e-06,  -1.131884130604011e-08,   1.106960557893899e-10,  -8.175416778594946e-12,  -1.716464943055100e-14,   7.189974196513980e-15,   4.901606193998743e-17,
  -7.059488411947884e-18,   2.406609909009461e-02,  -2.797551397702876e-04,   2.606569727637528e-06,  -1.133888285145717e-08,   1.106349881121869e-10,  -8.138667264439798e-12,
  -1.683524571821761e-14,   7.128611484424185e-15,   4.825383146833945e-17,  -6.970622560987220e-18,   2.406660781409791e-02,  -2.797618125122771e-04,   2.606699076477399e-06,
  -1.135463448771108e-08,   1.105872109556592e-10,  -8.109819425486686e-12,  -1.657722780686332e-14,   7.080502548927090e-15,   4.765768100803632e-17,  -6.901054381755111e-18,
   2.406690141249314e-02,  -2.797656648668099e-04,   2.606773717955374e-06,  -1.136371659179691e-08,   1.105597511665895e-10,  -8.093200468511934e-12,  -1.642880994872601e-14,
   7.052811438664178e-15,   4.731511961808231e-17,  -6.861052904234614e-18,   2.406701166233302e-02,  -2.797671117258479e-04,   2.606801745013004e-06,  -1.136712541196263e-08,
   1.105494611336197e-10,  -8.086965490823361e-12,  -1.637316987239729e-14,   7.042427019896009e-15,   4.718676507221439e-17,  -6.846059802795453e-18,   2.406702993786021e-02,
  -2.797673515772416e-04,   2.606806390816776e-06,  -1.136769038831049e-08,   1.105477565410509e-10,  -8.085932249597782e-12,  -1.636395159840404e-14,   7.040706384903587e-15,
   4.716550325773094e-17,  -6.843575949391658e-18,   6.728615493511969e-02,  -7.813424197338787e-04,   7.226701026093193e-06,  -2.945140854960023e-08,   2.804543626190793e-10,
  -2.316395740404320e-11,  -5.353705232532776e-14,   2.093504372884912e-14,   1.425970139281261e-16,  -2.068962090747307e-17,   6.728718382809018e-02,  -7.813551077345559e-04,
   7.226939882330718e-06,  -2.948385950819450e-08,   2.803464842180859e-10,  -2.310301656899589e-11,  -5.299495994704076e-14,   2.083301162937370e-14,   1.413288292780623e-16,
  -2.054101178567620e-17,   6.728887294694294e-02,  -7.813759470358035e-04,   7.227331938952431e-06,  -2.953707099926355e-08,   2.801702069699009e-10,  -2.300319015561010e-11,
  -5.210861690112354e-14,   2.066605144546943e-14,   1.392579014078160e-16,  -2.029814141178187e-17,   6.729066526592986e-02,  -7.813980725826120e-04,   7.227747853876451e-06,
  -2.959344834957854e-08,   2.799842781818811e-10,  -2.289756202895016e-11,  -5.117299946109379e-14,   2.048962823774677e-14,   1.370753721424354e-16,  -2.004192024199400e-17,
   6.729207585452597e-02,  -7.814154952253374e-04,   7.228075118003166e-06,  -2.963775678577316e-08,   2.798387561906090e-10,  -2.281464552718332e-11,  -5.044016970869360e-14,
   2.035131228640599e-14,   1.353684342691146e-16,  -1.984134201721494e-17,   6.729288994246201e-02,  -7.814255540672025e-04,   7.228263963305251e-06,  -2.966330369645639e-08,
   2.797550944940074e-10,  -2.276687816578189e-11,  -5.001864033457446e-14,   2.027169934700778e-14,   1.343876083584868e-16,  -1.972601147382883e-17,   6.729319564240560e-02,
  -7.814293319980495e-04,   7.228334871834632e-06,  -2.967289221596604e-08,   2.797237394440539e-10,  -2.274895716353813e-11,  -4.986061614412300e-14,   2.024184388087030e-14,
   1.340201056178375e-16,  -1.968278424990411e-17,   6.729324631664343e-02,  -7.814299582829678e-04,   7.228346625687470e-06,  -2.967448140776996e-08,   2.797185450982667e-10,
  -2.274598735066602e-11,  -4.983443530188665e-14,   2.023689701772471e-14,   1.339592293081218e-16,  -1.967562296337608e-17,   1.332242322681946e-01,  -1.544430995312637e-03,
   1.411590906042390e-05,  -5.155070884581409e-08,   4.613204026783985e-10,  -4.635873497881399e-11,  -1.185034605391768e-13,   4.327899292000180e-14,   2.895418299994556e-16,
  -4.282023283025043e-17,   1.332262418551267e-01,  -1.544453232563222e-03,   1.411630160291974e-05,  -5.161562012391460e-08,   4.610804356479114e-10,  -4.623275523155493e-11,
  -1.174033656516697e-13,   4.306785789131432e-14,   2.869365960355062e-16,  -4.251132200444877e-17,   1.332295409575739e-01,  -1.544489758393050e-03,   1.411694588097108e-05,
  -5.172205430476750e-08,   4.606881599455285e-10,  -4.602638981995894e-11,  -1.156047544914665e-13,   4.272237217456122e-14,   2.826824463606682e-16,  -4.200648334370681e-17,
   1.332330416149819e-01,  -1.544528541988701e-03,   1.411762931464683e-05,  -5.183481523082027e-08,   4.602741872878282e-10,  -4.580803142967701e-11,  -1.137062735743589e-13,
   4.235731168075442e-14,   2.781992605577322e-16,  -4.147390836313532e-17,   1.332357966903815e-01,  -1.544559084318241e-03,   1.411816703969463e-05,  -5.192343291320185e-08,
   4.599500216933528e-10,  -4.563662376298006e-11,  -1.122193604035473e-13,   4.207110882213503e-14,   2.746931559190583e-16,  -4.105700232693585e-17,   1.332373867141505e-01,
  -1.544576718679275e-03,   1.411847731501904e-05,  -5.197452556493919e-08,   4.597635924199465e-10,  -4.553787769513774e-11,  -1.113641112503599e-13,   4.190637597786569e-14,
   2.726785713320064e-16,  -4.081728973799581e-17,   1.332379837868884e-01,  -1.544583342028072e-03,   1.411859381586143e-05,  -5.199370185558079e-08,   4.596937096154079e-10,
  -4.550083091268448e-11,  -1.110434994857812e-13,   4.184460026075919e-14,   2.719237445301661e-16,  -4.072744350513279e-17,   1.332380827603995e-01,  -1.544584440020519e-03,
   1.411861312698340e-05,  -5.199688009883045e-08,   4.596821320372229e-10,  -4.549469163648039e-11,  -1.109903821052086e-13,   4.183436443209190e-14,   2.717987091646704e-16,
  -4.071255907160458e-17,   2.233524988520484e-01,  -2.582809071464563e-03,   2.318569700378718e-05,  -6.953251118955446e-08,   5.384452405673199e-10,  -7.903826662188887e-11,
  -2.268853893266078e-13,   7.714030792740166e-14,   5.029635645082990e-16,  -7.652936401961975e-17,   2.233557992663260e-01,  -2.582839146747611e-03,   2.318615414692335e-05,
  -6.964309816242959e-08,   5.379834769874197e-10,  -7.881373535362770e-11,  -2.249758845116699e-13,   7.676305526829059e-14,   4.983660859584857e-16,  -7.597375355440694e-17,
   2.233612174772815e-01,  -2.582888553877794e-03,   2.318690434351046e-05,  -6.982441611569127e-08,   5.372283135431871e-10,  -7.844593623777108e-11,  -2.218541314240187e-13,
   7.614576006721032e-14,   4.908591815505601e-16,  -7.506577533854628e-17,   2.233669666814513e-01,  -2.582941024405524e-03,   2.318769998340449e-05,  -7.001649843062737e-08,
   5.364309520985798e-10,  -7.805676504162384e-11,  -2.185593259198935e-13,   7.549350745699058e-14,   4.829487001637637e-16,  -7.410795286955476e-17,   2.233714913813747e-01,
  -2.582982352076850e-03,   2.318832588421846e-05,  -7.016744409135265e-08,   5.358062580016795e-10,  -7.775127410727218e-11,  -2.159790014365147e-13,   7.498216238457501e-14,
   4.767626767704858e-16,  -7.335818757601259e-17,   2.233741026926269e-01,  -2.583006216338571e-03,   2.318868699504814e-05,  -7.025446805695201e-08,   5.354468678588087e-10,
  -7.757528491044659e-11,  -2.144949221567823e-13,   7.468784715106853e-14,   4.732083966447811e-16,  -7.292709942077399e-17,   2.233750832694553e-01,  -2.583015180110221e-03,
   2.318882257522641e-05,  -7.028712947584195e-08,   5.353121271103591e-10,  -7.750925879505453e-11,  -2.139385931977768e-13,   7.457747829756398e-14,   4.718767067494552e-16,
  -7.276552629595251e-17,   2.233752458142843e-01,  -2.583016666115750e-03,   2.318884504849933e-05,  -7.029254267991333e-08,   5.352898031747376e-10,  -7.749831716257964e-11,
  -2.138464241785842e-13,   7.455919095790684e-14,   4.716561169820205e-16,  -7.273875929871421e-17,   3.399300295653129e-01,  -3.916692203492883e-03,   3.422698067009351e-05,
  -6.832287211200639e-08,   2.976884100009853e-10,  -1.235068765114155e-10,  -3.973089446557918e-13,   1.276197622280517e-13,   8.026977159232354e-16,  -1.273494720148671e-16,
   3.399349008179671e-01,  -3.916721981312512e-03,   3.422723026578889e-05,  -6.849550471299333e-08,   2.968762557057101e-10,  -1.231354694334408e-10,  -3.942645224911782e-13,
   1.269922125284605e-13,   7.952124156864073e-16,  -1.264165244834049e-16,   3.399428977927620e-01,  -3.916770918966138e-03,   3.422763952762368e-05,  -6.877853118259118e-08,
   2.955475888937109e-10,  -1.225270840531839e-10,  -3.892877837548692e-13,   1.259653896633837e-13,   7.829912274540230e-16,  -1.248919774194954e-16,   3.399513832353419e-01,
  -3.916822916947530e-03,   3.422807312178430e-05,  -6.907833131275870e-08,   2.941440264594398e-10,  -1.218833565743961e-10,  -3.840357504692808e-13,   1.248804600816790e-13,
   7.701144273869380e-16,  -1.232838406861120e-16,   3.399580613480295e-01,  -3.916863891241389e-03,   3.422841388291086e-05,  -6.931390487428310e-08,   2.930439309461337e-10,
  -1.213780516846691e-10,  -3.799230494426813e-13,   1.240299406638600e-13,   7.600457428715429e-16,  -1.220250950507369e-16,   3.399619154273790e-01,  -3.916887558978999e-03,
   3.422861035090402e-05,  -6.944971057416537e-08,   2.924108498071043e-10,  -1.210869552468678e-10,  -3.775577906467275e-13,   1.235404188162577e-13,   7.542610237810096e-16,
  -1.213013907877380e-16,   3.399633626743757e-01,  -3.916896450355010e-03,   3.422868409036172e-05,  -6.950067893695172e-08,   2.921734622615039e-10,  -1.209777447283901e-10,
  -3.766711707445092e-13,   1.233568493602248e-13,   7.520937273257036e-16,  -1.210301498126375e-16,   3.399636025763800e-01,  -3.916897924433822e-03,   3.422869631182231e-05,
  -6.950912619459144e-08,   2.921341298391183e-10,  -1.209596467461249e-10,  -3.765242829340867e-13,   1.233264333190769e-13,   7.517347263131664e-16,  -1.209852149928990e-16,
   4.863829379481601e-01,  -5.574439147260571e-03,   4.674210094180136e-05,  -1.836109480410449e-08,  -6.770876181405568e-10,  -1.845575067527152e-10,  -6.419247399303010e-13,
   2.043501034749284e-13,   1.220648135323976e-15,  -2.063752952550944e-16,   4.863895885148626e-01,  -5.574447895228586e-03,   4.674151538709362e-05,  -1.861872871077017e-08,
  -6.784032911194528e-10,  -1.839629774387333e-10,  -6.373008229923722e-13,   2.033336536219561e-13,   1.208986889169208e-15,  -2.048436773279372e-16,   4.864005064353712e-01,
  -5.574462334768241e-03,   4.674055330945434e-05,  -1.904107164338302e-08,  -6.805561736556631e-10,  -1.829891305239250e-10,  -6.297428860130909e-13,   2.016705695792022e-13,
   1.189950126856260e-15,  -2.023410168253858e-16,   4.864120911098662e-01,  -5.574477762598742e-03,   4.673953139280918e-05,  -1.948838934457930e-08,  -6.828310520047248e-10,
  -1.819587452207388e-10,  -6.217679742631476e-13,   1.999134729389479e-13,   1.169895457159039e-15,  -1.997013879929759e-16,   4.864212082494613e-01,  -5.574489981313474e-03,
   4.673872636041762e-05,  -1.983983739810965e-08,  -6.846145390858480e-10,  -1.811499511974042e-10,  -6.155238693453672e-13,   1.985360867946142e-13,   1.154216624846715e-15,
  -1.976354376353215e-16,   4.864264699048987e-01,  -5.574497063784592e-03,   4.673826144896937e-05,  -2.004242741861374e-08,  -6.856410839484325e-10,  -1.806840303205042e-10,
  -6.119331358114120e-13,   1.977433521566106e-13,   1.145209693092395e-15,  -1.964477106842849e-16,   4.864284457042800e-01,  -5.574499729143621e-03,   4.673808681128926e-05,
  -2.011845712847588e-08,  -6.860260446266754e-10,  -1.805092328509339e-10,  -6.105872055351119e-13,   1.974460840883515e-13,   1.141835347731580e-15,  -1.960025698181226e-16,
   4.864287732210681e-01,  -5.574500171272025e-03,   4.673805785949338e-05,  -2.013105777563468e-08,  -6.860898301091284e-10,  -1.804802661280579e-10,  -6.103642261780407e-13,
   1.973968293509724e-13,   1.141276415139632e-15,  -1.959288267952723e-16,   6.680542421753792e-01,  -7.594368819509958e-03,   5.948553718206866e-05,   1.440153141182089e-07,
  -3.264655902312931e-09,  -2.741796691819819e-10,  -9.016386390063141e-13,   3.273436337439348e-13,   1.800530424740084e-15,  -3.387703052368573e-16,   6.680627017776378e-01,
  -7.594308684780253e-03,   5.948273926529486e-05,   1.436331479080243e-07,  -3.266500166998569e-09,  -2.732279237190631e-10,  -8.948282877014376e-13,   3.256764258253689e-13,
   1.782827441460713e-15,  -3.362061145123018e-16,   6.680765892948506e-01,  -7.594210079947916e-03,   5.947814491904996e-05,   1.430067281854370e-07,  -3.269517510385863e-09,
  -2.716690365712112e-10,  -8.836980130738254e-13,   3.229487772787616e-13,   1.753933641923071e-15,  -3.320167177255114e-16,   6.680913246311723e-01,  -7.594105610172733e-03,
   5.947326845326710e-05,   1.423433620025380e-07,  -3.272705166871533e-09,  -2.700197602124162e-10,  -8.719556492907774e-13,   3.200671889816274e-13,   1.723502975890840e-15,
  -3.275986960540090e-16,   6.681029211338742e-01,  -7.594023505871890e-03,   5.946942955894428e-05,   1.418222388278011e-07,  -3.275203781423840e-09,  -2.687252547327782e-10,
  -8.627631714139896e-13,   3.178084966864418e-13,   1.699717992320991e-15,  -3.241413301915249e-16,   6.681096135883254e-01,  -7.593976167514269e-03,   5.946721362186417e-05,
   1.415218685479511e-07,  -3.276641747746335e-09,  -2.679795639197387e-10,  -8.574775164068226e-13,   3.165086117069064e-13,   1.686056706098575e-15,  -3.221538597947721e-16,
   6.681121266499683e-01,  -7.593958400111748e-03,   5.946638143313261e-05,   1.414091483021031e-07,  -3.277180957394632e-09,  -2.676998126765758e-10,  -8.554963787963481e-13,
   3.160211807226197e-13,   1.680939101615666e-15,  -3.214090237779249e-16,   6.681125432247701e-01,  -7.593955455365164e-03,   5.946624348159824e-05,   1.413904670931931e-07,
  -3.277270298996595e-09,  -2.676534537737897e-10,  -8.551681707371270e-13,   3.159404183646564e-13,   1.680091435799179e-15,  -3.212856344780751e-16,   8.938477379988797e-01,
  -1.002267752470027e-02,   6.895450720062886e-05,   5.787090638073612e-07,  -9.567045357796823e-09,  -4.327833983488291e-10,  -6.318128498625468e-13,   5.454981607811197e-13,
   2.508701998907355e-15,  -5.941275340561417e-16,   8.938575342906108e-01,  -1.002243258718888e-02,   6.894633148211097e-05,   5.781065111430715e-07,  -9.568282333228781e-09,
  -4.311996138972590e-10,  -6.223464367149096e-13,   5.425783604000807e-13,   2.482925459936644e-15,  -5.894748609772151e-16,   8.938736156474085e-01,  -1.002203066544132e-02,
   6.893290898829918e-05,   5.771189332503451e-07,  -9.570298702152059e-09,  -4.286058021968926e-10,  -6.068785290999392e-13,   5.378019771780096e-13,   2.440870076286915e-15,
  -5.818747721006506e-16,   8.938906780662038e-01,  -1.002160444360081e-02,   6.891866569927963e-05,   5.760732211927425e-07,  -9.572418815119006e-09,  -4.258620103962638e-10,
  -5.905643394076153e-13,   5.327568143050081e-13,   2.396598894711814e-15,  -5.738619424115686e-16,   8.939041054513998e-01,  -1.002126918426490e-02,   6.890745544600771e-05,
   5.752518191642820e-07,  -9.574073348983310e-09,  -4.237087291534444e-10,  -5.777959532302504e-13,   5.288028005470940e-13,   2.362011248526088e-15,  -5.675928762169196e-16,
   8.939118543260280e-01,  -1.002107577142694e-02,   6.890098550626134e-05,   5.747784039813518e-07,  -9.575022614021215e-09,  -4.224684674414728e-10,  -5.704554106626583e-13,
   5.265274787401237e-13,   2.342151383796457e-15,  -5.639896772245794e-16,   8.939147640427654e-01,  -1.002100315656100e-02,   6.889855592613433e-05,   5.746007512189360e-07,
  -9.575378016097950e-09,  -4.220031972246943e-10,  -5.677043086369355e-13,   5.256743211033456e-13,   2.334712905353040e-15,  -5.626394308508351e-16,   8.939152463666538e-01,
  -1.002099112032368e-02,   6.889815318563742e-05,   5.745713090241461e-07,  -9.575436873395378e-09,  -4.219260962992687e-10,  -5.672485557528590e-13,   5.255329638112878e-13,
   2.333480877220455e-15,  -5.624157552375300e-16,   1.180546984715782e+00,  -1.287525263812639e-02,   6.266158028686376e-05,   1.808775613081226e-06,  -2.542476474454737e-08,
  -8.858660006358390e-10,   4.966423466772705e-12,   1.025574500448574e-12,   1.395653493783857e-15,  -1.236456183496467e-15,   1.180555858385938e+00,  -1.287448479257498e-02,
   6.263993193275458e-05,   1.807539938150017e-06,  -2.541410398875905e-08,  -8.828973347341218e-10,   4.971481916588967e-12,   1.019518765194074e-12,   1.371152002733875e-15,
  -1.225988419612071e-15,   1.180570423735098e+00,  -1.287322462528531e-02,   6.260439925253422e-05,   1.805514391448531e-06,  -2.539659509179394e-08,  -8.780366899437784e-10,
   4.979717296942468e-12,   1.009615362726567e-12,   1.331222423339838e-15,  -1.208895966852596e-15,   1.180585875684272e+00,  -1.287188800016296e-02,   6.256670530027487e-05,
   1.803369218509069e-06,  -2.537800660712319e-08,  -8.728966587597793e-10,   4.988362509016249e-12,   9.991586391929606e-13,   1.289250615868133e-15,  -1.190884087212142e-15,
   1.180598034268995e+00,  -1.287083643786229e-02,   6.253704645652900e-05,   1.801683910806652e-06,  -2.536337003761202e-08,  -8.688640545193170e-10,   4.995099240183266e-12,
   9.909663235033898e-13,   1.256503796813518e-15,  -1.176798336183020e-15,   1.180605050352048e+00,  -1.287022970835830e-02,   6.251993236188887e-05,   1.800712469306101e-06,
  -2.535492006182342e-08,  -8.665418099417309e-10,   4.998960360829790e-12,   9.862532344348273e-13,   1.237718670209021e-15,  -1.168704972162452e-15,   1.180607684795829e+00,
  -1.287000190329076e-02,   6.251350634143725e-05,   1.800347906653271e-06,  -2.535174646071702e-08,  -8.656707371856591e-10,   5.000405202448780e-12,   9.844862250361639e-13,
   1.230686085318943e-15,  -1.165672581356630e-15,   1.180608121483881e+00,  -1.286996414281124e-02,   6.251244116253784e-05,   1.800287486949507e-06,  -2.535122036187310e-08,
  -8.655263946590228e-10,   5.000644439683647e-12,   9.841934656385646e-13,   1.229521461745934e-15,  -1.165170274707522e-15,   1.568276531322920e+00,  -1.562224658298243e-02,
  -3.729703004602583e-05,   6.740660399075619e-06,  -4.984975278258367e-08,  -5.453563904567744e-09,   1.020600529487550e-10,   4.757575718964666e-12,  -1.462758791490959e-13,
  -4.087231042924144e-15,   1.568271140507364e+00,  -1.561939582825971e-02,  -3.733840034548937e-05,   6.733016601253935e-06,  -4.963850593121971e-08,  -5.439668758693203e-09,
   1.015006591774151e-10,   4.737301762962026e-12,  -1.451368522613003e-13,  -4.062321039296865e-15,   1.568262286545121e+00,  -1.561471818427237e-02,  -3.740618810382633e-05,
   6.720482228250112e-06,  -4.929256071440274e-08,  -5.416900988969131e-09,   1.005855520951004e-10,   4.704109947939701e-12,  -1.432760406231058e-13,  -4.021569471583403e-15,
   1.568252886287564e+00,  -1.560975800848301e-02,  -3.747794208920766e-05,   6.707201507668038e-06,  -4.892663954796984e-08,  -5.392801449675735e-09,   9.961892614011591e-11,
   4.669014480728816e-12,  -1.413138703119718e-13,  -3.978521746342698e-15,   1.568245484244694e+00,  -1.560585661449801e-02,  -3.753428704634632e-05,   6.696763406089386e-06,
  -4.863949068066628e-08,  -5.373877491794472e-09,   9.886134178288834e-11,   4.641483438508118e-12,  -1.397784921060546e-13,  -3.944782210323386e-15,   1.568241210783073e+00,
  -1.560360596124821e-02,  -3.756675446632669e-05,   6.690744937238438e-06,  -4.847410467338107e-08,  -5.362973116614269e-09,   9.842538621228399e-11,   4.625630447572158e-12,
  -1.388959332846081e-13,  -3.925366160937153e-15,   1.568239605753923e+00,  -1.560276099191903e-02,  -3.757893679612715e-05,   6.688485993188790e-06,  -4.841206348245874e-08,
  -5.358881627266591e-09,   9.826191850299245e-11,   4.619684232965119e-12,  -1.385651907666096e-13,  -3.918085754082938e-15,   1.568239339681450e+00,  -1.560262093530105e-02,
  -3.758095569022230e-05,   6.688111596297506e-06,  -4.840178258323291e-08,  -5.358203573707936e-09,   9.823483393232165e-11,   4.618698918191639e-12,  -1.385104006129625e-13,
  -3.916879476678664e-15,   2.545764073195564e-03,  -2.873835272728734e-05,   2.749455012846053e-07,  -1.225324582162921e-09,  -4.007609061830247e-12,  -6.932121093039299e-13,
   1.858146108637759e-14,   5.259464088942465e-16,  -2.024026776475844e-17,  -4.372885913374094e-19,   2.545803193523318e-03,  -2.873887928224806e-05,   2.749422984680166e-07,
  -1.226298126900312e-09,  -3.968865695512408e-12,  -6.916749322598024e-13,   1.850360879035940e-14,   5.237734467240680e-16,  -2.010457459197590e-17,  -4.347692879176877e-19,
   2.545867415580011e-03,  -2.873974400485322e-05,   2.749370641457138e-07,  -1.227894791422103e-09,  -3.905380825099619e-12,  -6.891560573654638e-13,   1.837618700581517e-14,
   5.202154037681140e-16,  -1.988276061267965e-17,  -4.306470254675333e-19,   2.545935559749675e-03,  -2.874066194633135e-05,   2.749315421865436e-07,  -1.229586849176235e-09,
  -3.838179384295271e-12,  -6.864896453105023e-13,   1.824150489725143e-14,   5.164525568659728e-16,  -1.964868279463905e-17,  -4.262914020081432e-19,   2.545989189283581e-03,
  -2.874138466337411e-05,   2.749272195579618e-07,  -1.230916969765587e-09,  -3.785407750197362e-12,  -6.843957243084066e-13,   1.813588633459907e-14,   5.135002138868521e-16,
  -1.946538811109323e-17,  -4.228768029101681e-19,   2.546020139822107e-03,  -2.874180187460338e-05,   2.749247341669073e-07,  -1.231683992629545e-09,  -3.754998725156827e-12,
  -6.831891063475051e-13,   1.807508252165694e-14,   5.117999745611951e-16,  -1.935997501029329e-17,  -4.209114909129437e-19,   2.546031762035552e-03,  -2.874195856369224e-05,
   2.749238026311157e-07,  -1.231971901040994e-09,  -3.743588616183029e-12,  -6.827363538773521e-13,   1.805227852855330e-14,   5.111622003224182e-16,  -1.932046109808393e-17,
  -4.201745009055079e-19,   2.546033688582652e-03,  -2.874198453831845e-05,   2.749236483081874e-07,  -1.232019619847787e-09,  -3.741697690364508e-12,  -6.826613218444627e-13,
   1.804849993969146e-14,   5.110565160996820e-16,  -1.931391477781189e-17,  -4.200523872057839e-19,   2.298640402532520e-02,  -2.594085983096524e-04,   2.476014248641289e-06,
  -1.078634873297421e-08,  -4.165954930391243e-11,  -6.270541467632346e-12,   1.694291349294943e-13,   4.805491167519972e-15,  -1.853604118438326e-16,  -3.991564927976116e-18,
   2.298675631286200e-02,  -2.594132343240870e-04,   2.475980675055782e-06,  -1.079515387635771e-08,  -4.130631671050121e-11,  -6.256496212599542e-12,   1.687161795699911e-13,
   4.785656351585024e-15,  -1.841169422188328e-16,  -3.968570546521569e-18,   2.298733464675063e-02,  -2.594208477817731e-04,   2.475925773914033e-06,  -1.080959462889324e-08,
  -4.072751467335127e-11,  -6.233481098644037e-12,   1.675492792723374e-13,   4.753178501705552e-15,  -1.820842856452062e-16,  -3.930945353212614e-18,   2.298794829948192e-02,
  -2.594289299019876e-04,   2.475867811852495e-06,  -1.082489795141219e-08,  -4.011483457512041e-11,  -6.209117871552759e-12,   1.663158936177181e-13,   4.718831192246022e-15,
  -1.799392590664717e-16,  -3.891189984738199e-18,   2.298843124435839e-02,  -2.594352932162119e-04,   2.475822406749871e-06,  -1.083692769595062e-08,  -3.963371672765771e-11,
  -6.189985501136529e-12,   1.653486669886734e-13,   4.691882166862395e-15,  -1.782596051089553e-16,  -3.860023535262118e-18,   2.298870996007174e-02,  -2.594389666681724e-04,
   2.475796287201271e-06,  -1.084386467066050e-08,  -3.935648019728893e-11,  -6.178960492802963e-12,   1.647918427701420e-13,   4.676362358109428e-15,  -1.772936369275779e-16,
  -3.842085263346348e-18,   2.298881462036367e-02,  -2.594403462859805e-04,   2.475786495034764e-06,  -1.084646851098113e-08,  -3.925245554894602e-11,  -6.174823637806937e-12,
   1.645830103815166e-13,   4.670540745431266e-15,  -1.769315462041407e-16,  -3.835358417978264e-18,   2.298883196929302e-02,  -2.594405749879325e-04,   2.475784872685945e-06,
  -1.084690007874256e-08,  -3.923521621510359e-11,  -6.174138060730066e-12,   1.645484071638477e-13,   4.669576058265650e-15,  -1.768715582098241e-16,  -3.834243829698418e-18,
   6.427423608275795e-02,  -7.249008625532983e-04,   6.885240585577543e-06,  -2.854062782404994e-08,  -1.485134913130155e-10,  -1.760001199470987e-11,   4.835249613910543e-13,
   1.376576937004746e-14,  -5.336254966834413e-16,  -1.141239615386041e-17,   6.427521565962790e-02,  -7.249131343978428e-04,   6.885119476552160e-06,  -2.856533504320797e-08,
  -1.475056287863398e-10,  -1.755977635985022e-11,   4.814725678692334e-13,   1.370905858718075e-14,  -5.300407935031147e-16,  -1.134667196034780e-17,   6.427682378209511e-02,
  -7.249332881623714e-04,   6.884921270815956e-06,  -2.860585493193128e-08,  -1.458541868081468e-10,  -1.749384441132646e-11,   4.781134115527066e-13,   1.361619936344308e-14,
  -5.241810620347250e-16,  -1.123912789155139e-17,   6.427853010873166e-02,  -7.249546831126015e-04,   6.884711793094387e-06,  -2.864879399724045e-08,  -1.441061212118126e-10,
  -1.742405017049131e-11,   4.745628830036663e-13,   1.351799497572314e-14,  -5.179974697327763e-16,  -1.112549374667168e-17,   6.427987298550145e-02,  -7.249715284656730e-04,
   6.884547535964237e-06,  -2.868254701509920e-08,  -1.427334490355793e-10,  -1.736924072693770e-11,   4.717785562317233e-13,   1.344094338937953e-14,  -5.131554908983852e-16,
  -1.103640860312845e-17,   6.428064798143986e-02,  -7.249812532188004e-04,   6.884452981381093e-06,  -2.870201042415415e-08,  -1.419424793448569e-10,  -1.733765674969984e-11,
   4.701756483027933e-13,   1.339656974217871e-14,  -5.103708939498672e-16,  -1.098513404350223e-17,   6.428093899927084e-02,  -7.249849055215423e-04,   6.884417520793579e-06,
  -2.870931608348779e-08,  -1.416456938766608e-10,  -1.732580564501040e-11,   4.695744917802923e-13,   1.337992480394270e-14,  -5.093270991389066e-16,  -1.096590602735371e-17,
   6.428098723959705e-02,  -7.249855109726029e-04,   6.884411645098380e-06,  -2.871052694054377e-08,  -1.415965096443335e-10,  -1.732384162897447e-11,   4.694748810893576e-13,
   1.337716660607323e-14,  -5.091541726563097e-16,  -1.096272008403350e-17,   1.272685304668444e-01,  -1.433922089801240e-03,   1.351162036045334e-05,  -5.132931708394758e-08,
  -3.969017434970842e-10,  -3.506364466446526e-11,   9.893987016024395e-13,   2.829962727412356e-14,  -1.106283095107740e-15,  -2.339646465462711e-17,   1.272704526118248e-01,
  -1.433944177104610e-03,   1.351129312431261e-05,  -5.137851848773492e-08,  -3.948400833483700e-10,  -3.498092327200123e-11,   9.851441493809251e-13,   2.818336188710038e-14,
  -1.098833964803631e-15,  -2.326184197286414e-17,   1.272736080921852e-01,  -1.433980452008683e-03,   1.351075716967177e-05,  -5.145920623885215e-08,  -3.914620175217387e-10,
  -3.484537152186212e-11,   9.781807662309673e-13,   2.799298650158609e-14,  -1.086657443324281e-15,  -2.304155582481422e-17,   1.272769562577185e-01,  -1.434018962886441e-03,
   1.351019018582843e-05,  -5.154470772571227e-08,  -3.878864217935747e-10,  -3.470187820279497e-11,   9.708207451191169e-13,   2.779165216820791e-14,  -1.073808198877915e-15,
  -2.280878986845265e-17,   1.272795912505034e-01,  -1.434049285909477e-03,   1.350974519966572e-05,  -5.161191508696527e-08,  -3.850787618125310e-10,  -3.458919215765666e-11,
   9.650490610482438e-13,   2.763368398380688e-14,  -1.063746958203344e-15,  -2.262630580101091e-17,   1.272811119439235e-01,  -1.434066791831897e-03,   1.350948888318111e-05,
  -5.165066863162489e-08,  -3.834609482338003e-10,  -3.452425647564179e-11,   9.617263823028762e-13,   2.754271068968172e-14,  -1.057960865783699e-15,  -2.252127229275636e-17,
   1.272816829770748e-01,  -1.434073366597009e-03,   1.350939272704652e-05,  -5.166521471389656e-08,  -3.828539230512768e-10,  -3.449989091818218e-11,   9.604802445720781e-13,
   2.750858579191214e-14,  -1.055791986791617e-15,  -2.248188432662752e-17,   1.272817776338694e-01,  -1.434074456517361e-03,   1.350937679270881e-05,  -5.166762560515051e-08,
  -3.827533252423068e-10,  -3.449585295046286e-11,   9.602737617043767e-13,   2.750293102498658e-14,  -1.055432667285434e-15,  -2.247535801026452e-17,   2.133869996646376e-01,
  -2.400632996242573e-03,   2.235188657704959e-05,  -7.312559052659329e-08,  -9.234414644882696e-10,  -5.933282980590134e-11,   1.741553832683911e-12,   5.001036025926384e-14,
  -1.981229909327236e-15,  -4.120015305614467e-17,   2.133901789583014e-01,  -2.400664508876683e-03,   2.235111860976821e-05,  -7.320879413894910e-08,  -9.198140305388823e-10,
  -5.918663546449413e-11,   1.733935429386340e-12,   4.980560835941465e-14,  -1.967839084523293e-15,  -4.096361030072281e-17,   2.133953982078232e-01,  -2.400716267354608e-03,
   2.234986007736276e-05,  -7.334523731692860e-08,  -9.138706188027786e-10,  -5.894707196255403e-11,   1.721466609734068e-12,   4.947034142381085e-14,  -1.945950630234327e-15,
  -4.057653763317260e-17,   2.134009361323912e-01,  -2.400771221581274e-03,   2.234852767715638e-05,  -7.348981179217402e-08,  -9.075799442447326e-10,  -5.869347106136006e-11,
   1.708287755851224e-12,   4.911577234018049e-14,  -1.922853568120165e-15,  -4.016751954367718e-17,   2.134052944339699e-01,  -2.400814495792451e-03,   2.234748124020221e-05,
  -7.360344639832527e-08,  -9.026405249384923e-10,  -5.849431544701063e-11,   1.697953119908567e-12,   4.883757339495722e-14,  -1.904768548588276e-15,  -3.984684517128688e-17,
   2.134078096653406e-01,  -2.400839480179137e-03,   2.234687818942310e-05,  -7.366896858426836e-08,  -8.997944407933604e-10,  -5.837955080084995e-11,   1.692003669463338e-12,
   4.867735892878025e-14,  -1.894368277276914e-15,  -3.966226781704614e-17,   2.134087541541228e-01,  -2.400848863952841e-03,   2.234665190188635e-05,  -7.369356175431256e-08,
  -8.987265671698426e-10,  -5.833648800472468e-11,   1.689772397730037e-12,   4.861726091133451e-14,  -1.890469840244401e-15,  -3.959304970547878e-17,   2.134089107163618e-01,
  -2.400850419547235e-03,   2.234661440013840e-05,  -7.369763784086476e-08,  -8.985495971382545e-10,  -5.832935144203638e-11,   1.689402680424760e-12,   4.860730218479726e-14,
  -1.889823985743484e-15,  -3.958158069081897e-17,   3.248055698502710e-01,  -3.646259929870205e-03,   3.335581598033669e-05,  -8.262724292500565e-08,  -1.981669289300372e-09,
  -9.155528956388211e-11,   2.843974385652532e-12,   8.165787162384128e-14,  -3.303879832698581e-15,  -6.699949594858026e-17,   3.248103132931852e-01,  -3.646295658063000e-03,
   3.335415741412476e-05,  -8.275552204158164e-08,  -1.975748734178351e-09,  -9.131655999354391e-11,   2.831272719251252e-12,   8.132485304919512e-14,  -3.281416873272932e-15,
  -6.661681268644348e-17,   3.248181002573804e-01,  -3.646354350790386e-03,   3.335143821561097e-05,  -8.296586962358312e-08,  -1.966048536821215e-09,  -9.092535946224758e-11,
   2.810484653559877e-12,   8.077955119234958e-14,  -3.244700403730715e-15,  -6.599056225339362e-17,   3.248263626041674e-01,  -3.646416681433031e-03,   3.334855783070256e-05,
  -8.318873433297410e-08,  -1.955782125438611e-09,  -9.051123242507681e-11,   2.788513335049829e-12,   8.020284524112277e-14,  -3.205958154640676e-15,  -6.532875599490653e-17,
   3.248328649524385e-01,  -3.646465774406902e-03,   3.334629449161185e-05,  -8.336389117315018e-08,  -1.947721367992157e-09,  -9.018601108371937e-11,   2.771284170658901e-12,
   7.975034819341891e-14,  -3.175624081790251e-15,  -6.480985717827183e-17,   3.248366175198621e-01,  -3.646494122316550e-03,   3.334498969129604e-05,  -8.346488196763877e-08,
  -1.943076934523650e-09,  -8.999859918177268e-11,   2.761365823134522e-12,   7.948975285822367e-14,  -3.158180123263188e-15,  -6.451116925680591e-17,   3.248380266339817e-01,
  -3.646504770146981e-03,   3.334449999341990e-05,  -8.350278694989312e-08,  -1.941334336014247e-09,  -8.992827696344222e-11,   2.757646091317327e-12,   7.939200046799680e-14,
  -3.151641517166951e-15,  -6.439915599450008e-17,   3.248382602141699e-01,  -3.646506535330690e-03,   3.334441883310069e-05,  -8.350906929053697e-08,  -1.941045550896045e-09,
  -8.991662283414284e-11,   2.757029740617545e-12,   7.937580208035996e-14,  -3.150558270106666e-15,  -6.438059594496747e-17,   4.648310346220239e-01,  -5.201844136325168e-03,
   4.633755924159397e-05,  -5.762540429128399e-08,  -4.065600087974098e-09,  -1.338241414669308e-10,   4.511037330125672e-12,   1.280498163501614e-13,  -5.362720344904426e-15,
  -1.046122549804839e-16,   4.648376219238747e-01,  -5.201869398929966e-03,   4.633414090922266e-05,  -5.781269240784788e-08,  -4.056214521386967e-09,  -1.334497511241703e-10,
   4.490427569897053e-12,   1.275296568383669e-13,  -5.325914522042827e-15,  -1.040218859156844e-16,   4.648484357031279e-01,  -5.201910928642609e-03,   4.632853487857275e-05,
  -5.811977451360181e-08,  -4.040837991760562e-09,  -1.328362421035929e-10,   4.456697794484468e-12,   1.266778946002090e-13,  -5.265756808884460e-15,  -1.030556489653395e-16,
   4.648599094931115e-01,  -5.201955072361348e-03,   4.632259420368920e-05,  -5.844509429222527e-08,  -4.024564889020270e-09,  -1.321867721620602e-10,   4.421049480943337e-12,
   1.257770438346004e-13,  -5.202283570709647e-15,  -1.020343987124062e-16,   4.648689390892811e-01,  -5.201989869750667e-03,   4.631792446935400e-05,  -5.870074805933126e-08,
  -4.011788634868236e-09,  -1.316767275848862e-10,   4.393096258064065e-12,   1.250701897465318e-13,  -5.152588432843697e-15,  -1.012335615768066e-16,   4.648741501108578e-01,
  -5.202009974456007e-03,   4.631523171962932e-05,  -5.884814084649266e-08,  -4.004427517686674e-09,  -1.313828078285591e-10,   4.377004761766500e-12,   1.246630987727469e-13,
  -5.124011707233948e-15,  -1.007725404008698e-16,   4.648761068757820e-01,  -5.202017528214405e-03,   4.631422098939089e-05,  -5.890345997106770e-08,  -4.001665668826980e-09,
  -1.312725205460252e-10,   4.370969954311974e-12,   1.245103922266886e-13,  -5.113300346189951e-15,  -1.005996409556627e-16,   4.648764312362321e-01,  -5.202018780581699e-03,
   4.631405346874972e-05,  -5.891262841358263e-08,  -4.001207975373747e-09,  -1.312542432011151e-10,   4.369970004993439e-12,   1.244850873757070e-13,  -5.111525811572498e-15,
  -1.005709919243596e-16,   6.386376867860006e-01,  -7.112868726720201e-03,   6.072402438647425e-05,   4.982365861888523e-08,  -8.236859909872498e-09,  -1.906309146756881e-10,
   7.254418237653992e-12,   1.977581463157728e-13,  -8.802897420857284e-15,  -1.608552864112610e-16,   6.386463142905923e-01,  -7.112848396147816e-03,   6.071707666616926e-05,
   4.955724739124621e-08,  -8.221774398755427e-09,  -1.900526688578827e-10,   7.220606484583796e-12,   1.969576232345647e-13,  -8.741546271503253e-15,  -1.599744054064717e-16,
   6.386604770350330e-01,  -7.112815101293986e-03,   6.070568004229322e-05,   4.912047971941262e-08,  -8.197060589218892e-09,  -1.891050986203960e-10,   7.165273143286633e-12,
   1.956466665670561e-13,  -8.641276349057522e-15,  -1.585323007134634e-16,   6.386755038498350e-01,  -7.112779882965062e-03,   6.069359980740757e-05,   4.865783564904029e-08,
  -8.170907172255877e-09,  -1.881019788303455e-10,   7.106796140272171e-12,   1.942600240223515e-13,  -8.535488543389621e-15,  -1.570075535587789e-16,   6.386873293434207e-01,
  -7.112752245582208e-03,   6.068410160980095e-05,   4.829431093960377e-08,  -8.150374751279693e-09,  -1.873141990018697e-10,   7.060944716955519e-12,   1.931718966750485e-13,
  -8.452670086111892e-15,  -1.558115028094740e-16,   6.386941537911032e-01,  -7.112736327401291e-03,   6.067862362175494e-05,   4.808474540766810e-08,  -8.138545277252636e-09,
  -1.868602285918278e-10,   7.034551042867124e-12,   1.925451847493811e-13,  -8.405048524020012e-15,  -1.551228140035885e-16,   6.386967163869358e-01,  -7.112730355991195e-03,
   6.067656726410510e-05,   4.800609522827584e-08,  -8.134107003338734e-09,  -1.866898852255777e-10,   7.024652802041665e-12,   1.923100875379436e-13,  -8.387199079100874e-15,
  -1.548645021468899e-16,   6.386971411711255e-01,  -7.112729366462277e-03,   6.067622642932099e-05,   4.799306014317122e-08,  -8.133371496858990e-09,  -1.866616550732857e-10,
   7.023012704119855e-12,   1.922711294306442e-13,  -8.384242013261390e-15,  -1.548216989574802e-16,   8.548997653099131e-01,  -9.446503291072005e-03,   7.470630136581783e-05,
   3.606697936340522e-07,  -1.717397977558666e-08,  -2.751554634744343e-10,   1.263457480188863e-11,   3.050262136701374e-13,  -1.539030983166605e-14,  -2.462885756048016e-16,
   8.549103673779577e-01,  -9.446350668530376e-03,   7.469178596920364e-05,   3.602857404685950e-07,  -1.714770818949938e-08,  -2.742634776691401e-10,   1.257551739463776e-11,
   3.037973733637142e-13,  -1.528029324182483e-14,  -2.450591242717813e-16,   8.549277709196322e-01,  -9.446100230677216e-03,   7.466797258882519e-05,   3.596561643835918e-07,
  -1.710466904825598e-08,  -2.728017715176957e-10,   1.247887725587851e-11,   3.017845565791013e-13,  -1.510050216306055e-14,  -2.430446123542693e-16,   8.549462354270501e-01,
  -9.445834655279277e-03,   7.464272645669243e-05,   3.589893698959519e-07,  -1.705912313962396e-08,  -2.712543613224000e-10,   1.237675756276266e-11,   2.996549422937924e-13,
  -1.491083844774176e-14,  -2.409122842651566e-16,   8.549607656473932e-01,  -9.445625760699489e-03,   7.462287330952362e-05,   3.584654917118115e-07,  -1.702336635838050e-08,
  -2.700391241322653e-10,   1.229669406297288e-11,   2.979833639192294e-13,  -1.476237116668308e-14,  -2.392379272888250e-16,   8.549691507430714e-01,  -9.445505249472567e-03,
   7.461142195228271e-05,   3.581635087784110e-07,  -1.700276566364538e-08,  -2.693388209094520e-10,   1.225060987627197e-11,   2.970204407854006e-13,  -1.467700693855490e-14,
  -2.382731493402535e-16,   8.549722993205421e-01,  -9.445460004983195e-03,   7.460712304025268e-05,   3.580501786931927e-07,  -1.699503655121562e-08,  -2.690760453439115e-10,
   1.223332783077268e-11,   2.966591892833426e-13,  -1.464501200569742e-14,  -2.379111546141653e-16,   8.549728212365585e-01,  -9.445452505518977e-03,   7.460641049662005e-05,
   3.580313961696934e-07,  -1.699375569099392e-08,  -2.690324968293674e-10,   1.223046429807220e-11,   2.965993243802542e-13,  -1.463971155921024e-14,  -2.378511640647539e-16,
   1.130174598452261e+00,  -1.229531169886185e-02,   8.138818672130195e-05,   1.276057629214393e-06,  -3.976696254903222e-08,  -4.562981630012383e-10,   2.808110658003873e-11,
   4.431417262035159e-13,  -3.219382884115187e-14,  -3.321499067923053e-16,   1.130186112977703e+00,  -1.229476917504024e-02,   8.135456257090100e-05,   1.275419214119468e-06,
  -3.970847903337347e-08,  -4.550006285145094e-10,   2.795772181609255e-11,   4.414632913536384e-13,  -3.195622942580792e-14,  -3.312963161028997e-16,   1.130205012529429e+00,
  -1.229387872880612e-02,   8.129939871732089e-05,   1.274372475873785e-06,  -3.961265665600690e-08,  -4.528741256953525e-10,   2.775583966515695e-11,   4.387111101898016e-13,
  -3.156798209821427e-14,  -3.298842560929666e-16,   1.130225061788412e+00,  -1.229293416054218e-02,   8.124091396813718e-05,   1.273263602350515e-06,  -3.951123635121862e-08,
  -4.506226442880205e-10,   2.754254016957712e-11,   4.357952594344760e-13,  -3.115847232439216e-14,  -3.283715264161345e-16,   1.130240837312680e+00,  -1.229219097133254e-02,
   8.119492113030321e-05,   1.272392212296970e-06,  -3.943160196588827e-08,  -4.488542630145604e-10,   2.737533121887961e-11,   4.335036905756215e-13,  -3.083795244188343e-14,
  -3.271707035992293e-16,   1.130249940334708e+00,  -1.229176213880331e-02,   8.116839176466852e-05,   1.271889836332145e-06,  -3.938571698716560e-08,  -4.478351161700820e-10,
   2.727909504591205e-11,   4.321824778463975e-13,  -3.065367965239728e-14,  -3.264736060594329e-16,   1.130253358356498e+00,  -1.229160112237612e-02,   8.115843236838237e-05,
   1.271701287436803e-06,  -3.936850061196029e-08,  -4.474526847768177e-10,   2.724300710162444e-11,   4.316865950051396e-13,  -3.058461642816504e-14,  -3.262110736944500e-16,
   1.130253924929163e+00,  -1.229157443236080e-02,   8.115678159534412e-05,   1.271670037941480e-06,  -3.936564748370871e-08,  -4.473893054546922e-10,   2.723702762786571e-11,
   4.316044083021000e-13,  -3.057317522120772e-14,  -3.261675149625819e-16,   1.505674323667460e+00,  -1.561787320028481e-02,   3.573520676554662e-05,   5.238157351715072e-06,
  -1.267455872021198e-07,  -2.015097053886375e-09,   1.586622709824273e-10,  -7.356019363215253e-13,  -1.522484293481968e-13,   3.211158380769226e-15,   1.505679195225382e+00,
  -1.561564710708688e-02,   3.562886149282470e-05,   5.235273447627290e-06,  -1.264139171200567e-07,  -2.017050555257365e-09,   1.580702154184395e-10,  -7.201569227182188e-13,
  -1.515431718364559e-13,   3.173350457721427e-15,   1.505687182036847e+00,  -1.561199350829818e-02,   3.545448098120592e-05,   5.230537143670169e-06,  -1.258703326999183e-07,
  -2.020224830139323e-09,   1.571002796430504e-10,  -6.949387196691176e-13,  -1.503874423523142e-13,   3.111642447089482e-15,   1.505695642212426e+00,  -1.560811797218397e-02,
   3.526972464361480e-05,   5.225508983170168e-06,  -1.252947768350041e-07,  -2.023548680956753e-09,   1.560738438692969e-10,  -6.683661192962238e-13,  -1.491639365589088e-13,
   3.046652375661428e-15,   1.505702289962455e+00,  -1.560506878451363e-02,   3.512451920529956e-05,   5.221549943566473e-06,  -1.248426999975322e-07,  -2.026132620280287e-09,
   1.552680155332830e-10,  -6.475873474102237e-13,  -1.482030722075988e-13,   2.995855715125692e-15,   1.505706122321903e+00,  -1.560330939135307e-02,   3.504079790615538e-05,
   5.219264367133338e-06,  -1.245821533916446e-07,  -2.027611096856577e-09,   1.548037498802147e-10,  -6.356490419314084e-13,  -1.476493583500726e-13,   2.966680069392631e-15,
   1.505707560619918e+00,  -1.560264878839312e-02,   3.500937476149194e-05,   5.218405971658709e-06,  -1.244843827436595e-07,  -2.028163871638570e-09,   1.546295634151350e-10,
  -6.311761852285744e-13,  -1.474415884154724e-13,   2.955750740050644e-15,   1.505707798996678e+00,  -1.560253928751399e-02,   3.500416671845247e-05,   5.218263673013270e-06,
  -1.244681794027658e-07,  -2.028255375064463e-09,   1.546006974209242e-10,  -6.304352772639991e-13,  -1.474071557628368e-13,   2.953940439245020e-15,   2.435113959235387e-03,
  -2.659957156936010e-05,   2.594880765720462e-07,  -1.372562548719801e-09,  -1.263584186083030e-11,  -1.517914132796029e-13,   2.316573993065759e-14,  -1.932622494642810e-16,
  -1.946269327682219e-17,   4.202104161623988e-19,   2.435150865155698e-03,  -2.660015832675278e-05,   2.594775621754104e-07,  -1.372783132757691e-09,  -1.258728956537390e-11,
  -1.523365897857622e-13,   2.308996836561225e-14,  -1.912220231417848e-16,  -1.937667072173943e-17,   4.159844828423756e-19,   2.435211451160966e-03,  -2.660112165312544e-05,
   2.594603307709079e-07,  -1.373145804565332e-09,  -1.250769907309867e-11,  -1.532272508935318e-13,   2.296582321751536e-14,  -1.878880357619221e-16,  -1.923572997293181e-17,
   4.090832493142420e-19,   2.435275736189259e-03,  -2.660214391093606e-05,   2.594420872166719e-07,  -1.373531368955158e-09,  -1.242340479938320e-11,  -1.541664384171862e-13,
   2.283442970214652e-14,  -1.843712395552422e-16,  -1.908656052890714e-17,   4.018096705170674e-19,   2.435326327827781e-03,  -2.660294850138889e-05,   2.594277585898109e-07,
  -1.373835345188864e-09,  -1.235717855511515e-11,  -1.549013460114224e-13,   2.273126385254703e-14,  -1.816185211162896e-16,  -1.896943832024535e-17,   3.961207659960287e-19,
   2.435355524844605e-03,  -2.660341287362710e-05,   2.594195009322782e-07,  -1.374010989665639e-09,  -1.231900365458224e-11,  -1.553237814190507e-13,   2.267182152936700e-14,
  -1.800358749537431e-16,  -1.890195503921089e-17,   3.928517431469051e-19,   2.435366488537866e-03,  -2.660358725519327e-05,   2.594164023049293e-07,  -1.374076986259175e-09,
  -1.230467720479021e-11,  -1.554820904565720e-13,   2.264951861076588e-14,  -1.794427076966950e-16,  -1.887663523546458e-17,   3.916268619816600e-19,   2.435368305922902e-03,
  -2.660361616170689e-05,   2.594158887793965e-07,  -1.374087928265846e-09,  -1.230230284446684e-11,  -1.555083155955390e-13,   2.264582254598893e-14,  -1.793444414032056e-16,
  -1.887243921502562e-17,   3.914239610721315e-19,   2.198753955608677e-02,  -2.401374822535439e-04,   2.339249292112943e-06,  -1.220268164909561e-08,  -1.193199050884921e-10,
  -1.333258354791624e-12,   2.111727389329774e-13,  -1.773506489269434e-15,  -1.778071212085946e-16,   3.855157536283698e-18,   2.198787224864584e-02,  -2.401426987067769e-04,
   2.339149914970957e-06,  -1.220462094578929e-08,  -1.188773334484707e-10,  -1.338261337741065e-12,   2.104804904970695e-13,  -1.754788470132710e-15,  -1.770219802798299e-16,
   3.816397354371178e-18,   2.198841840751925e-02,  -2.401512629673567e-04,   2.338987041839941e-06,  -1.220780963867439e-08,  -1.181518398789653e-10,  -1.346434778259020e-12,
   2.093462992641259e-13,  -1.724200824863595e-15,  -1.757355818170685e-16,   3.753099434742603e-18,   2.198899791098608e-02,  -2.401603511374173e-04,   2.338814588178957e-06,
  -1.221119989357899e-08,  -1.173834730562281e-10,  -1.355053550632159e-12,   2.081458840217721e-13,  -1.691935948102556e-15,  -1.743740635476165e-16,   3.686386464582495e-18,
   2.198945397363545e-02,  -2.401675041749169e-04,   2.338679131912343e-06,  -1.221387295193391e-08,  -1.167798039434728e-10,  -1.361797688790262e-12,   2.072033555530307e-13,
  -1.666681070688932e-15,  -1.733050403603749e-16,   3.634208127753537e-18,   2.198971717245448e-02,  -2.401716325734145e-04,   2.338601063854581e-06,  -1.221541758864060e-08,
  -1.164318309350796e-10,  -1.365674319869750e-12,   2.066602866319517e-13,  -1.652161032208960e-15,  -1.726890881552434e-16,   3.604224846051394e-18,   2.198981600550027e-02,
  -2.401731828736195e-04,   2.338571768622879e-06,  -1.221599798533355e-08,  -1.163012422260608e-10,  -1.367127100663405e-12,   2.064565255656711e-13,  -1.646718997045965e-15,
  -1.724579813989700e-16,   3.592990314333798e-18,   2.198983238845388e-02,  -2.401734398604709e-04,   2.338566913579013e-06,  -1.221609421390894e-08,  -1.162795994242444e-10,
  -1.367367765283466e-12,   2.064227580442267e-13,  -1.645817449108793e-15,  -1.724196821398361e-16,   3.591129320427651e-18,   6.148254086649131e-02,  -6.712514414010187e-04,
   6.519189432752805e-06,  -3.300918001440017e-08,  -3.642078992487743e-10,  -3.508312023721505e-12,   6.022145870406565e-13,  -5.128985301510698e-15,  -5.092789107612127e-16,
   1.113982341056244e-17,   6.148346798415672e-02,  -6.712655518382174e-04,   6.518885594610177e-06,  -3.301429399001128e-08,  -3.629458932306432e-10,  -3.522781351042635e-12,
   6.002317425880136e-13,  -5.074896298835858e-15,  -5.070345972008195e-16,   1.102788242538319e-17,   6.148498996778352e-02,  -6.712887180112812e-04,   6.518387566517806e-06,
  -3.302270393758055e-08,  -3.608771406643035e-10,  -3.546420182552207e-12,   5.969830047912921e-13,  -4.986507694255022e-15,  -5.033573799298181e-16,   1.084507580934818e-17,
   6.148660486922845e-02,  -6.713133012975520e-04,   6.517860167590022e-06,  -3.303164722425839e-08,  -3.586861531094254e-10,  -3.571347113084587e-12,   5.935445599415355e-13,
  -4.893272103986408e-15,  -4.994653400957647e-16,   1.065240689099959e-17,   6.148787577563564e-02,  -6.713326500577583e-04,   6.517445859389561e-06,  -3.303869983841973e-08,
  -3.569648122783091e-10,  -3.590852383455345e-12,   5.908447882206804e-13,  -4.820293028826069e-15,  -4.964093629337159e-16,   1.050171474960951e-17,   6.148860922875470e-02,
  -6.713438172414766e-04,   6.517207057417672e-06,  -3.304277571582323e-08,  -3.559725851148047e-10,  -3.602064341705655e-12,   5.892892205588242e-13,  -4.778334348366906e-15,
  -4.946485373477786e-16,   1.041512253803739e-17,   6.148888464546143e-02,  -6.713480107502629e-04,   6.517117442215694e-06,  -3.304430731916323e-08,  -3.556002191375975e-10,
  -3.606266068758473e-12,   5.887055660303786e-13,  -4.762608434752215e-15,  -4.939878664849160e-16,   1.038267705196971e-17,   6.148893029960506e-02,  -6.713487058907149e-04,
   6.517102590235995e-06,  -3.304456126078412e-08,  -3.555385060226057e-10,  -3.606962118434098e-12,   5.886088420720624e-13,  -4.760003220042691e-15,  -4.938783791467455e-16,
   1.037730247672512e-17,   1.217449161412466e-01,  -1.328444784698469e-03,   1.283915134304176e-05,  -6.180879825731761e-08,  -8.192205697298651e-10,  -6.233163469396802e-12,
   1.230231476191470e-12,  -1.072020550074125e-14,  -1.047071654712247e-15,   2.323354733593464e-17,   1.217467418697370e-01,  -1.328471204520155e-03,   1.283846643757048e-05,
  -6.181792226160480e-08,  -8.166427990161238e-10,  -6.263409889592461e-12,   1.226154457776934e-12,  -1.060739048645927e-14,  -1.042472707976005e-15,   2.300028100812790e-17,
   1.217497390305018e-01,  -1.328514579808568e-03,   1.283734362993326e-05,  -6.183293116389732e-08,  -8.124172108611265e-10,  -6.312824606507933e-12,   1.219474533788185e-12,
  -1.042303501032670e-14,  -1.034937287524212e-15,   2.261934348003460e-17,   1.217529191573588e-01,  -1.328560608254879e-03,   1.283615438344963e-05,  -6.184889791519860e-08,
  -8.079420043769733e-10,  -6.364932693251482e-12,   1.212404482883339e-12,  -1.022856892941298e-14,  -1.026961336131559e-15,   2.221785589808458e-17,   1.217554218671062e-01,
  -1.328596835720966e-03,   1.283521998741673e-05,  -6.186149351891164e-08,  -8.044261165498531e-10,  -6.405707684340372e-12,   1.206853232194669e-12,  -1.007635209143828e-14,
  -1.020698501999561e-15,   2.190384134926097e-17,   1.217568662030863e-01,  -1.328617744438527e-03,   1.283468134884932e-05,  -6.186877455369334e-08,  -8.023994805533171e-10,
  -6.429146046893865e-12,   1.203654668518065e-12,  -9.988836042057551e-15,  -1.017089825723614e-15,   2.172339957301398e-17,   1.217574085605551e-01,  -1.328625596085220e-03,
   1.283447920176817e-05,  -6.187151089330224e-08,  -8.016389216255234e-10,  -6.437929708592993e-12,   1.202454552839812e-12,  -9.956035384623591e-15,  -1.015735814858950e-15,
   2.165578939339643e-17,   1.217574984638022e-01,  -1.328626897619410e-03,   1.283444569916970e-05,  -6.187196459875910e-08,  -8.015128725159864e-10,  -6.439384794473056e-12,
   1.202255668000662e-12,  -9.950601499746416e-15,  -1.015511425316693e-15,   2.164458981158079e-17,   2.041360876113152e-01,  -2.225652741174845e-03,   2.135489064265984e-05,
  -9.478702257888961e-08,  -1.619225644282987e-09,  -8.630383336443130e-12,   2.157967594971010e-12,  -1.946383150090268e-14,  -1.851797022138388e-15,   4.198042130547572e-17,
   2.041391238407126e-01,  -2.225693252951425e-03,   2.135353364909860e-05,  -9.479976511453862e-08,  -1.614704646215555e-09,  -8.685314751231083e-12,   2.150756332395877e-12,
  -1.925997292129366e-14,  -1.843705636550904e-15,   4.155947696153374e-17,   2.041441081673093e-01,  -2.225759763629539e-03,   2.135130868755854e-05,  -9.482073921618302e-08,
  -1.607293733119694e-09,  -8.775060448733756e-12,   2.138941037990266e-12,  -1.892683746330714e-14,  -1.830447166913275e-15,   4.087205179094082e-17,   2.041493967392841e-01,
  -2.225830342099996e-03,   2.134895158286019e-05,  -9.484306909548361e-08,  -1.599445162131989e-09,  -8.869700730919527e-12,   2.126435534714607e-12,  -1.857542901343040e-14,
  -1.816412707734828e-15,   4.014754485309946e-17,   2.041535587402855e-01,  -2.225885891716727e-03,   2.134709924233430e-05,  -9.486069675061467e-08,  -1.593279126572682e-09,
  -8.943759648044284e-12,   2.116616368437952e-12,  -1.830036466680386e-14,  -1.805392010788408e-15,   3.958088943469604e-17,   2.041559606592023e-01,  -2.225917952088330e-03,
   2.134603130704957e-05,  -9.487089156810783e-08,  -1.589724923467792e-09,  -8.986331206133360e-12,   2.110958636901381e-12,  -1.814221743460683e-14,  -1.799041577691885e-15,
   3.925527356912401e-17,   2.041568625935805e-01,  -2.225929991379656e-03,   2.134563049200623e-05,  -9.487472388983987e-08,  -1.588391103921337e-09,  -9.002285306571477e-12,
   2.108835821482669e-12,  -1.808294434100083e-14,  -1.796658785109154e-15,   3.913326786309912e-17,   2.041570121015833e-01,  -2.225931987080511e-03,   2.134556406200205e-05,
  -9.487535936636265e-08,  -1.588170047434099e-09,  -9.004928243286010e-12,   2.108484025098584e-12,  -1.807312492074032e-14,  -1.796263901180600e-15,   3.911305770419621e-17,
   3.107470330172422e-01,  -3.384030674302240e-03,   3.212720070784982e-05,  -1.247299125717078e-07,  -3.012347714721263e-09,  -8.974999800880013e-12,   3.499233995447297e-12,
  -3.320314491358471e-14,  -3.030808844718091e-15,   7.090913602865307e-17,   3.107515998656588e-01,  -3.384083972305389e-03,   3.212467009157598e-05,  -1.247434713438753e-07,
  -3.005018051365697e-09,  -9.068760388387290e-12,   3.487429244641694e-12,  -3.285877102574606e-14,  -3.017672959760547e-15,   7.019948300455277e-17,   3.107590968329869e-01,
  -3.384171473971480e-03,   3.212052015448354e-05,  -1.247658244486291e-07,  -2.993003291193090e-09,  -9.221951899035498e-12,   3.468087444678956e-12,  -3.229600726786829e-14,
  -2.996146908214630e-15,   6.904058082649572e-17,   3.107670513505638e-01,  -3.384264325954373e-03,   3.211612283186968e-05,  -1.247896704208505e-07,  -2.980279226923809e-09,
  -9.383508557411955e-12,   3.447615352505034e-12,  -3.170236792799244e-14,  -2.973358672799488e-15,   6.781916417030613e-17,   3.107733113486968e-01,  -3.384337405274565e-03,
   3.211266651420226e-05,  -1.248085293941790e-07,  -2.970283053307249e-09,  -9.509939083553527e-12,   3.431540623625563e-12,  -3.123769260808918e-14,  -2.955462325898276e-15,
   6.686386310935772e-17,   3.107769240162828e-01,  -3.384379582515588e-03,   3.211067356719943e-05,  -1.248194500772499e-07,  -2.964521165664326e-09,  -9.582618617554768e-12,
   3.422278364849355e-12,  -3.097052716849600e-14,  -2.945149289268105e-15,   6.631492079643312e-17,   3.107782805900397e-01,  -3.384395420817650e-03,   3.210992552854005e-05,
  -1.248235578456386e-07,  -2.962358860488771e-09,  -9.609856541727965e-12,   3.418803086561481e-12,  -3.087039399451903e-14,  -2.941279534410497e-15,   6.610923644257179e-17,
   3.107785054605636e-01,  -3.384398046260271e-03,   3.210980154797493e-05,  -1.248242391330339e-07,  -2.962000498171499e-09,  -9.614368772972044e-12,   3.418227156684495e-12,
  -3.085380550742173e-14,  -2.940638219816764e-15,   6.607516497578367e-17,   4.447589038342534e-01,  -4.835176187690505e-03,   4.518891554669929e-05,  -1.373618606843678e-07,
  -5.477688164156091e-09,  -3.673949786670910e-12,   5.472014908071683e-12,  -5.597194530703531e-14,  -4.780609648015804e-15,   1.172474207369813e-16,   4.447653252749127e-01,
  -4.835234853915929e-03,   4.518430327546132e-05,  -1.373684167695354e-07,  -5.466228190861169e-09,  -3.832180557053308e-12,   5.453389179425649e-12,  -5.540243247564305e-14,
  -4.760167149187089e-15,   1.160775844412899e-16,   4.447758666452607e-01,  -4.835331166352088e-03,   4.517673848816242e-05,  -1.373793386681514e-07,  -5.447443301739209e-09,
  -4.090731905301095e-12,   5.422870585736829e-12,  -5.447174094161364e-14,  -4.726663053947168e-15,   1.141671653924545e-16,   4.447870512240784e-01,  -4.835433364487021e-03,
   4.516872117143840e-05,  -1.373911431016646e-07,  -5.427549783018376e-09,  -4.363435267763905e-12,   5.390567490939151e-12,  -5.348996929477956e-14,  -4.691188309381034e-15,
   1.121536762415601e-16,   4.447958530906670e-01,  -4.835513797290853e-03,   4.516241837707129e-05,  -1.374005887216219e-07,  -5.411921460749946e-09,  -4.576871036699350e-12,
   5.365202270375679e-12,  -5.272146733288008e-14,  -4.663324423818223e-15,   1.105788632187208e-16,   4.448009326374180e-01,  -4.835560217577250e-03,   4.515878366498034e-05,
  -1.374061021202040e-07,  -5.402913254006210e-09,  -4.699575985873275e-12,   5.350586525437480e-12,  -5.227961115741768e-14,  -4.647265687263346e-15,   1.096739275434896e-16,
   4.448028400232372e-01,  -4.835577649035323e-03,   4.515741931464798e-05,  -1.374081841819913e-07,  -5.399532698887429e-09,  -4.745563663676933e-12,   5.345102516139088e-12,
  -5.211400316257602e-14,  -4.641239645668984e-15,   1.093348543992483e-16,   4.448031561979191e-01,  -4.835580538558468e-03,   4.515719318148716e-05,  -1.374085299316215e-07,
  -5.398972435084245e-09,  -4.753182074868497e-12,   5.344193692424693e-12,  -5.208656778479582e-14,  -4.640240963313721e-15,   1.092786871276816e-16,   6.111581237583401e-01,
  -6.627146852317820e-03,   6.043966875037225e-05,  -1.017376878830430e-07,  -1.003668539800229e-08,   1.559786110538400e-11,   8.544425822709006e-12,  -9.800605774333215e-14,
  -7.487092078466541e-15,   1.978059719261612e-16,   6.111667077389830e-01,  -6.627190216644708e-03,   6.043120019379764e-05,  -1.017178212616617e-07,  -1.001879215571407e-08,
   1.532022887643836e-11,   8.515239180507044e-12,  -9.704495621287732e-14,  -7.455871027915082e-15,   1.958432117939044e-16,   6.111807988779641e-01,  -6.627261400615596e-03,
   6.041730862045841e-05,  -1.016854862587904e-07,  -9.989462189346874e-09,   1.486649292877113e-11,   8.467414086954956e-12,  -9.547429377166235e-14,  -7.404688292691007e-15,
   1.926378158326050e-16,   6.111957495048400e-01,  -6.627336924759065e-03,   6.040258343112200e-05,  -1.016515547409071e-07,  -9.958401485668578e-09,   1.438781129598127e-11,
   8.416789494182624e-12,  -9.381737139032818e-14,  -7.350477255216975e-15,   1.892593752725689e-16,   6.112075148868860e-01,  -6.627396357225148e-03,   6.039100536517292e-05,
  -1.016251235551731e-07,  -9.934000407125463e-09,   1.401308336528259e-11,   8.377035572900838e-12,  -9.252034105445987e-14,  -7.307883998963336e-15,   1.866169130803226e-16,
   6.112143045824247e-01,  -6.627430654697903e-03,   6.038432773634085e-05,  -1.016099787799289e-07,  -9.919935628717745e-09,   1.379761890497557e-11,   8.354128012169777e-12,
  -9.177458725602766e-14,  -7.283331203779573e-15,   1.850984425641226e-16,   6.112168541170309e-01,  -6.627443533332045e-03,   6.038182103248998e-05,  -1.016043123674698e-07,
  -9.914657481493402e-09,   1.371686049942348e-11,   8.345532645812195e-12,  -9.149507517680452e-14,  -7.274116803603079e-15,   1.845294763144887e-16,   6.112172767355315e-01,
  -6.627445668128509e-03,   6.038140555328106e-05,  -1.016033741644584e-07,  -9.913782727966903e-09,   1.370348157854111e-11,   8.344108191562461e-12,  -9.144876976662562e-14,
  -7.272589671020115e-15,   1.844352270744414e-16,   8.183294649780272e-01,  -8.836513110345254e-03,   7.726279819644968e-05,   6.018411521437767e-08,  -1.925698272834728e-08,
   7.174610025239804e-11,   1.394154427597821e-11,  -1.922980420450291e-13,  -1.197878298506856e-14,   3.607152365614195e-16,   8.183404273116320e-01,  -8.836487072826166e-03,
   7.724652093462746e-05,   6.028162338919043e-08,  -1.922777695671609e-08,   7.119926544674034e-11,   1.389478947879282e-11,  -1.905441986928172e-13,  -1.193169529596906e-14,
   3.571813785248446e-16,   8.183584221090578e-01,  -8.836444298996809e-03,   7.721981702297213e-05,   6.044114786970783e-08,  -1.917990257169764e-08,   7.030527523536921e-11,
   1.381816917114717e-11,  -1.876778421095839e-13,  -1.185445414277897e-14,   3.514097317089238e-16,   8.183775137420813e-01,  -8.836398873296280e-03,   7.719150634158558e-05,
   6.060966892981588e-08,  -1.912920136668573e-08,   6.936173360941742e-11,   1.373705283094182e-11,  -1.846538358169107e-13,  -1.177257919923475e-14,   3.453258513375620e-16,
   8.183925373381252e-01,  -8.836363094602676e-03,   7.716924321290079e-05,   6.074175684984468e-08,  -1.908936955047053e-08,   6.862280670804222e-11,   1.367334678992489e-11,
  -1.822864924101797e-13,  -1.170820479146485e-14,   3.405668509099004e-16,   8.184012071002696e-01,  -8.836342434646509e-03,   7.715640174521792e-05,   6.081777183057940e-08,
  -1.906640998008756e-08,   6.819781489006527e-11,   1.363663405257280e-11,  -1.809252737170350e-13,  -1.167107803796379e-14,   3.378319419438907e-16,   8.184044625595454e-01,
  -8.836334674480762e-03,   7.715158097237784e-05,   6.084627553562967e-08,  -1.905779375016677e-08,   6.803850122917399e-11,   1.362285811905748e-11,  -1.804150698475629e-13,
  -1.165714132701467e-14,   3.368071448604948e-16,   8.184050021920501e-01,  -8.836333388009029e-03,   7.715078193020893e-05,   6.085099828843613e-08,  -1.905636576713993e-08,
   6.801210720536942e-11,   1.362057509175815e-11,  -1.803305461822895e-13,  -1.165483136930530e-14,   3.366373854099452e-16,   1.082376672979729e+00,  -1.159421545765466e-02,
   9.270709320484359e-05,   6.054823587244913e-07,  -4.175885906739851e-08,   2.494371780359109e-10,   2.629980058642357e-11,  -5.019211317388656e-13,  -1.993289694918816e-14,
   8.048862558439556e-16,   1.082389794811576e+00,  -1.159395575486818e-02,   9.267175001741450e-05,   6.058252441080738e-07,  -4.170364570241348e-08,   2.479995015593068e-10,
   2.622165295858426e-11,  -4.979980444844803e-13,  -1.987152791006550e-14,   7.973663187416388e-16,   1.082411332837407e+00,  -1.159352930769517e-02,   9.261376223450360e-05,
   6.063866929305349e-07,  -4.161312391387183e-08,   2.456476675253106e-10,   2.609353877296634e-11,  -4.915850606773429e-13,  -1.977059574759572e-14,   7.850803354830847e-16,
   1.082434181477337e+00,  -1.159307667451075e-02,   9.255227858342745e-05,   6.069804633763016e-07,  -4.151723608363003e-08,   2.431634987007953e-10,   2.595784163402708e-11,
  -4.848175073882320e-13,  -1.966325177732935e-14,   7.721241670140364e-16,   1.082452159952403e+00,  -1.159272034880174e-02,   9.250392380525200e-05,   6.074463410312257e-07,
  -4.144188959838100e-08,   2.412166075281514e-10,   2.585122264065390e-11,  -4.795181886089122e-13,  -1.957859586505181e-14,   7.619854620434652e-16,   1.082462534269557e+00,
  -1.159251466583708e-02,   9.247603060632597e-05,   6.077146389990128e-07,  -4.139845282569172e-08,   2.400962823263645e-10,   2.578976110112009e-11,  -4.764705526944728e-13,
  -1.952966995494013e-14,   7.561573456579209e-16,   1.082466429661915e+00,  -1.159243742220411e-02,   9.246555894330501e-05,   6.078152801230176e-07,  -4.138215079417844e-08,
   2.396762049754223e-10,   2.576669499013072e-11,  -4.753281547359962e-13,  -1.951128481342328e-14,   7.539731934760641e-16,   1.082467075364877e+00,  -1.159242461756373e-02,
   9.246382324768243e-05,   6.078319571658814e-07,  -4.137944896896420e-08,   2.396066036092728e-10,   2.576287215434304e-11,  -4.751388923781651e-13,  -1.950823653164038e-14,
   7.536113689848438e-16,   1.444121594902046e+00,  -1.511682311148313e-02,   8.572619487137059e-05,   3.079382840447205e-06,  -1.329522946042999e-07,   1.121733960625527e-09,
   9.082810620322271e-11,  -3.331794380643851e-12,  -8.834977376063315e-15,   3.510600371322701e-15,   1.444133568305277e+00,  -1.511550311922555e-02,   8.561376953517970e-05,
   3.080897703041530e-06,  -1.327589462263673e-07,   1.112057102440699e-09,   9.078417399731761e-11,  -3.314217565361372e-12,  -9.260009621974708e-15,   3.495418507504344e-15,
   1.444153213197013e+00,  -1.511333568974190e-02,   8.542932429233540e-05,   3.083374758038270e-06,  -1.324416059344511e-07,   1.096208672823602e-09,   9.071085480686686e-11,
  -3.285418770106120e-12,  -9.953104722733453e-15,   3.470471342188388e-15,   1.444174042475683e+00,  -1.511103527152776e-02,   8.523377553085847e-05,   3.085989756484964e-06,
  -1.321049826990878e-07,   1.079443433532286e-09,   9.063143745734994e-11,  -3.254937707561587e-12,  -1.068221549908850e-14,   3.443969212282881e-15,   1.444190424032156e+00,
  -1.510922439136179e-02,   8.507999482476027e-05,   3.088038126003612e-06,  -1.318401311489232e-07,   1.066286097580195e-09,   9.056776836320162e-11,  -3.231004507044807e-12,
  -1.125147348564050e-14,   3.423089984235505e-15,   1.444199873662824e+00,  -1.510817912147746e-02,   8.499129194357215e-05,   3.089216418161763e-06,  -1.316873095398508e-07,
   1.058707554013596e-09,   9.053055768079896e-11,  -3.217214469467812e-12,  -1.157818284940076e-14,   3.411031625546227e-15,   1.444203421245429e+00,  -1.510778657911486e-02,
   8.495799200689631e-05,   3.089658149284352e-06,  -1.316299290932079e-07,   1.055864533160038e-09,   9.051649684320226e-11,  -3.212040385742996e-12,  -1.170052204215874e-14,
   3.406502004258246e-15,   1.444204009263311e+00,  -1.510772150785312e-02,   8.495247253403966e-05,   3.089731334082766e-06,  -1.316204177583365e-07,   1.055393409295602e-09,
   9.051416142873156e-11,  -3.211182929564598e-12,  -1.172078341405402e-14,   3.405751071616215e-15,   2.332758241870475e-03,  -2.459303493973377e-05,   2.417943262317731e-07,
  -1.571714481357442e-09,  -1.084492324512687e-11,   2.853719446260493e-13,   1.177022732303674e-14,  -5.184480145337467e-16,  -5.628881332065010e-19,   4.796093652886065e-19,
   2.332792632646476e-03,  -2.459370455201208e-05,   2.417852084601593e-07,  -1.571321099985135e-09,  -1.081983878497259e-11,   2.838608016424072e-13,   1.176695075058153e-14,
  -5.160492627781021e-16,  -6.131922136050583e-19,   4.774354193200887e-19,   2.332849089757835e-03,  -2.459480371054761e-05,   2.417702556290628e-07,  -1.570676839251480e-09,
  -1.077866418205002e-11,   2.813851591785474e-13,   1.176142982235147e-14,  -5.121193581928040e-16,  -6.952559777561232e-19,   4.738685080719553e-19,   2.332908993876337e-03,
  -2.459596984206401e-05,   2.417544105379275e-07,  -1.569995316827078e-09,  -1.073498247235344e-11,   2.787652918651139e-13,   1.175537964215147e-14,  -5.079603411481312e-16,
  -7.816297399467701e-19,   4.700864846492519e-19,   2.332956137835251e-03,  -2.459688747758797e-05,   2.417419555841274e-07,  -1.569460464612605e-09,  -1.070061042382658e-11,
   2.767084892601472e-13,   1.175047970561544e-14,  -5.046950725471446e-16,  -8.490998554771829e-19,   4.671120496271412e-19,   2.332983345176432e-03,  -2.459741701651725e-05,
   2.417347736855898e-07,  -1.569152395285958e-09,  -1.068077595230580e-11,   2.755234887831435e-13,   1.174759658237824e-14,  -5.028137876228664e-16,  -8.878357922936741e-19,
   4.653962779376009e-19,   2.332993561735692e-03,  -2.459761585487440e-05,   2.417320779639531e-07,  -1.569036826329497e-09,  -1.067332835120289e-11,   2.750788909286194e-13,
   1.174650351836413e-14,  -5.021079445894729e-16,  -9.023433446977285e-19,   4.647521479675954e-19,   2.332995255273046e-03,  -2.459764881471542e-05,   2.417316311703134e-07,
  -1.569017675139927e-09,  -1.067209382802643e-11,   2.750052125947575e-13,   1.174632177812542e-14,  -5.019909725558038e-16,  -9.047461670102069e-19,   4.646453826590828e-19,
   2.106344382434858e-02,  -2.220420334607008e-04,   2.181304558633753e-06,  -1.407631465859786e-08,  -1.020163223712028e-10,   2.647233944533448e-12,   1.069165251680587e-13,
  -4.737380217524910e-15,  -4.806507347333755e-18,   4.381995281926708e-18,   2.106375406746417e-02,  -2.220480300741243e-04,   2.181218743483765e-06,  -1.407266371623103e-08,
  -1.017884510838167e-10,   2.633425680169438e-12,   1.068878732841908e-13,  -4.715462514793325e-15,  -5.268805556804434e-18,   4.362181529088262e-18,   2.106426337314462e-02,
  -2.220578733863527e-04,   2.181078004531996e-06,  -1.406668416129051e-08,  -1.014144126814429e-10,   2.610804175383394e-12,   1.068395324097170e-13,  -4.679554293961262e-15,
  -6.022987994423577e-18,   4.329671206003684e-18,   2.106480377415162e-02,  -2.220683164098646e-04,   2.180928860566502e-06,  -1.406035847079385e-08,  -1.010175969722122e-10,
   2.586864795133738e-12,   1.067864739675897e-13,  -4.641552391927232e-15,  -6.816794307820418e-18,   4.295199150813197e-18,   2.106522906413162e-02,  -2.220765340461765e-04,
   2.180811621712873e-06,  -1.405539391252204e-08,  -1.007053509674657e-10,   2.568070490905790e-12,   1.067434445870208e-13,  -4.611716702934359e-15,  -7.436879476731864e-18,
   4.268087234318203e-18,   2.106547450390943e-02,  -2.220812761732443e-04,   2.180744016282841e-06,  -1.405253429114653e-08,  -1.005251680313432e-10,   2.557242392736818e-12,
   1.067181034801786e-13,  -4.594526797614918e-15,  -7.792886837391613e-18,   4.252447691705103e-18,   2.106556666834690e-02,  -2.220830568076199e-04,   2.180718640243131e-06,
  -1.405146151784530e-08,  -1.004575114245448e-10,   2.553179821105495e-12,   1.067084918508435e-13,  -4.588077269778135e-15,  -7.926221050352968e-18,   4.246576280752925e-18,
   2.106558194588789e-02,  -2.220833519689579e-04,   2.180714434353728e-06,  -1.405128374531633e-08,  -1.004462965789065e-10,   2.552506575591635e-12,   1.067068935378051e-13,
  -4.587008455838667e-15,  -7.948304652776653e-18,   4.245603084257250e-18,   5.889919254062512e-02,  -6.207820200576412e-04,   6.088142215329745e-06,  -3.868906062619202e-08,
  -3.091688003072939e-10,   7.815812664808569e-12,   3.026572343551808e-13,  -1.357620051323390e-14,  -1.173948865961900e-17,   1.255340377018560e-17,   5.890005840454553e-02,
  -6.207984992184039e-04,   6.087881888076191e-06,  -3.867827134312380e-08,  -3.085236670458227e-10,   7.776241269755874e-12,   3.025829086131499e-13,  -1.351340356171085e-14,
  -1.308004270314351e-17,   1.249693737228991e-17,   5.890147983415698e-02,  -6.208255491769419e-04,   6.087454916570736e-06,  -3.866059927546599e-08,  -3.074647055312394e-10,
   7.711413074737156e-12,   3.024571087405984e-13,  -1.341052095068494e-14,  -1.526705356555590e-17,   1.240428255080228e-17,   5.890298804532803e-02,  -6.208542468622096e-04,
   6.087002407414720e-06,  -3.864190252334883e-08,  -3.063412441810742e-10,   7.642808108665506e-12,   3.023185065825083e-13,  -1.330163815793609e-14,  -1.756905242416178e-17,
   1.230603003448918e-17,   5.890417498975659e-02,  -6.208768289026358e-04,   6.086646671709268e-06,  -3.862722761002692e-08,  -3.054572060163061e-10,   7.588947768611835e-12,
   3.022057366500198e-13,  -1.321615209120238e-14,  -1.936733022247712e-17,   1.222875060410291e-17,   5.890485998830512e-02,  -6.208898601632943e-04,   6.086441526548255e-06,
  -3.861877425624722e-08,  -3.049470639544405e-10,   7.557916813069344e-12,   3.021391815853425e-13,  -1.316689866421327e-14,  -2.039979401466856e-17,   1.218416994190663e-17,
   5.890511721012721e-02,  -6.208947532901966e-04,   6.086364522149022e-06,  -3.861560292674314e-08,  -3.047555107739481e-10,   7.546274371731567e-12,   3.021139116782963e-13,
  -1.314841905629763e-14,  -2.078648381811575e-17,   1.216743306737920e-17,   5.890515984822348e-02,  -6.208955643833080e-04,   6.086351759131686e-06,  -3.861507739110547e-08,
  -3.047237586347986e-10,   7.544344997318991e-12,   3.021097081893364e-13,  -1.314535661669481e-14,  -2.085052992231543e-17,   1.216465888244374e-17,   1.166315511107937e-01,
  -1.228921020551262e-03,   1.201946491622022e-05,  -7.446825936324010e-08,  -6.887183297794455e-10,   1.680980805776019e-11,   6.109110334736111e-13,  -2.794595975410285e-14,
  -1.729453595520507e-17,   2.581818140510765e-17,   1.166332604013586e-01,  -1.228952730737885e-03,   1.201888423681133e-05,  -7.444502364450845e-08,  -6.874158596919961e-10,
   1.672835092423147e-11,   6.107843444719136e-13,  -2.781678072793912e-14,  -2.010586082484102e-17,   2.570305477932268e-17,   1.166360664199978e-01,  -1.229004781132643e-03,
   1.201793176081761e-05,  -7.440696138166024e-08,  -6.852778700642945e-10,   1.659490286974598e-11,   6.105684311153711e-13,  -2.760513818429715e-14,  -2.469253051548031e-17,
   2.551412829156976e-17,   1.166390437432563e-01,  -1.229060001113089e-03,   1.201692220174528e-05,  -7.436668693258397e-08,  -6.830096113269235e-10,   1.645368015024303e-11,
   6.103285936442038e-13,  -2.738114753281156e-14,  -2.952064128273648e-17,   2.531376493569133e-17,   1.166413868548642e-01,  -1.229103452652315e-03,   1.201612846370831e-05,
  -7.433507209965162e-08,  -6.812247119345721e-10,   1.634280895218564e-11,   6.101321016487740e-13,  -2.720528439135221e-14,  -3.329247609018470e-17,   2.515615485284161e-17,
   1.166427390873779e-01,  -1.229128526632772e-03,   1.201567069871739e-05,  -7.431685913849619e-08,  -6.801947063489036e-10,   1.627893184617400e-11,   6.100156117468495e-13,
  -2.710395811624005e-14,  -3.545812143181692e-17,   2.506522677865531e-17,   1.166432468597849e-01,  -1.229137941641938e-03,   1.201549886327784e-05,  -7.431002614313099e-08,
  -6.798079471208604e-10,   1.625496591226180e-11,   6.099712858551134e-13,  -2.706594079969065e-14,  -3.626923866867480e-17,   2.503108850307411e-17,   1.166433310301001e-01,
  -1.229139502287059e-03,   1.201547038225228e-05,  -7.430889380080719e-08,  -6.797438372032134e-10,   1.625099429964070e-11,   6.099639074934150e-13,  -2.705964055787287e-14,
  -3.640358206011920e-17,   2.502542992086703e-17,   1.955673334129716e-01,  -2.059799997520091e-03,   2.006466778702395e-05,  -1.195468959449443e-07,  -1.345855241113956e-09,
   3.155206822238876e-11,   1.052495389455807e-12,  -4.954686872934378e-14,  -1.215389568059287e-17,   4.568501086981862e-17,   1.955701864775019e-01,  -2.059850880629778e-03,
   2.006353135333749e-05,  -1.195032111087149e-07,  -1.343610548155112e-09,   3.140764274198274e-11,   1.052341736312409e-12,  -4.931821516289799e-14,  -1.727339691302653e-17,
   4.548404476103978e-17,   1.955748701299664e-01,  -2.059934400295108e-03,   2.006166709805294e-05,  -1.194316424191158e-07,  -1.339925813733101e-09,   3.117103531718711e-11,
   1.052075040666628e-12,  -4.894358684445484e-14,  -2.562640848454404e-17,   4.515420627084745e-17,   1.955798396914266e-01,  -2.060023003207851e-03,   2.005969086068379e-05,
  -1.193559020717217e-07,  -1.336016435079689e-09,   3.092064213306019e-11,   1.051772498919812e-12,  -4.854708755210086e-14,  -3.441987854006621e-17,   4.480433770564369e-17,
   1.955837506496761e-01,  -2.060092721219686e-03,   2.005813691370323e-05,  -1.192964382943576e-07,  -1.332940039341868e-09,   3.072406258857519e-11,   1.051520300242698e-12,
  -4.823577185871441e-14,  -4.129009593682114e-17,   4.452907842179509e-17,   1.955860076949899e-01,  -2.060132951664493e-03,   2.005724064652494e-05,  -1.192621783469574e-07,
  -1.331164716879601e-09,   3.061080535359621e-11,   1.051369121511570e-12,  -4.805639858545614e-14,  -4.523493654910424e-17,   4.437025840960143e-17,   1.955868552294142e-01,
  -2.060148057617654e-03,   2.005690419248498e-05,  -1.192493243050865e-07,  -1.330498089762809e-09,   3.056831252409341e-11,   1.051311290739822e-12,  -4.798909753028999e-14,
  -4.671247245778030e-17,   4.431062721533046e-17,   1.955869957199262e-01,  -2.060150561593990e-03,   2.005684842585599e-05,  -1.192471941389523e-07,  -1.330387588057719e-09,
   3.056127064836296e-11,   1.051301648514628e-12,  -4.797794433910995e-14,  -4.695719537418169e-17,   4.430074288155732e-17,   2.977143259453948e-01,  -3.133805711952366e-03,
   3.034884947394499e-05,  -1.702795495097637e-07,  -2.472545010035134e-09,   5.561712066659273e-11,   1.661958877687395e-12,  -8.149949619065203e-14,   2.550752152638681e-17,
   7.483491251659310e-17,   2.977186406049120e-01,  -3.133878135886734e-03,   3.034675839866806e-05,  -1.702024027805479e-07,  -2.468998557094202e-09,   5.537953400718168e-11,
   1.661880871057086e-12,  -8.112476463177911e-14,   1.676858523133061e-17,   7.451263558643720e-17,   2.977257236051602e-01,  -3.133997008160304e-03,   3.034332774823288e-05,
  -1.700759958338790e-07,  -2.463176695404183e-09,   5.499030083084703e-11,   1.661728138256587e-12,  -8.051077534866691e-14,   2.508724122917817e-18,   7.398357606367137e-17,
   2.977332389283748e-01,  -3.134123109155255e-03,   3.033969053660310e-05,  -1.699421965986441e-07,  -2.456999562620317e-09,   5.457838533327852e-11,   1.661532680619565e-12,
  -7.986090687231667e-14,  -1.250490903993334e-17,   7.342222930103021e-17,   2.977391533191971e-01,  -3.134222328399203e-03,   3.033683018483795e-05,  -1.698371332458402e-07,
  -2.452138368960109e-09,   5.425499446550978e-11,   1.661354780656504e-12,  -7.935063098510748e-14,  -2.423619002420818e-17,   7.298047515692751e-17,   2.977425665464334e-01,
  -3.134279580595302e-03,   3.033518028286097e-05,  -1.697765941552774e-07,  -2.449332981450451e-09,   5.406867509404653e-11,   1.661242495986430e-12,  -7.905661137122757e-14,
  -3.097276263453097e-17,   7.272554487783809e-17,   2.977438482314496e-01,  -3.134301077632303e-03,   3.033456089136683e-05,  -1.697538790716295e-07,  -2.448279550528287e-09,
   5.399876996748771e-11,   1.661198518758154e-12,  -7.894629302343908e-14,  -3.349604036741791e-17,   7.262981917249140e-17,   2.977440606882558e-01,  -3.134304640982552e-03,
   3.033445822696525e-05,  -1.697501146678158e-07,  -2.448104930343919e-09,   5.398718533790567e-11,   1.661191133348659e-12,  -7.892801087016565e-14,  -3.391397390397862e-17,
   7.261395144192325e-17,   4.261287253298608e-01,  -4.481711104983517e-03,   4.303332105298698e-05,  -2.192450572557026e-07,  -4.435464339164102e-09,   9.601531897706541e-11,
   2.497065831530406e-12,  -1.298551173910750e-13,   1.510116926486667e-16,   1.181982711077683e-16,   4.261348417329813e-01,  -4.481804234696709e-03,   4.302956407714788e-05,
  -2.191116085747372e-07,  -4.430130935183032e-09,   9.563669184774060e-11,   2.497366300220501e-12,  -1.292627862859558e-13,   1.363600852361794e-16,   1.177066659708477e-16,
   4.261448824173186e-01,  -4.481957081761667e-03,   4.302339968533208e-05,  -2.188929164909061e-07,  -4.421374984212111e-09,   9.501638495162540e-11,   2.497818184245512e-12,
  -1.282922013093232e-13,   1.124488912169334e-16,   1.168993332460148e-16,   4.261555358414768e-01,  -4.482119209425759e-03,   4.301686326338675e-05,  -2.186613905339401e-07,
  -4.412083863203533e-09,   9.435991637430175e-11,   2.498241645772274e-12,  -1.272648129014586e-13,   8.726932543949050e-17,   1.160423276979668e-16,   4.261639197674182e-01,
  -4.482246765061440e-03,   4.301172230444088e-05,  -2.184795566749910e-07,  -4.404771453805355e-09,   9.384451939131447e-11,   2.498534524403219e-12,  -1.264580467930962e-13,
   6.759142415154087e-17,   1.153676140476926e-16,   4.261687581448114e-01,  -4.482320364020733e-03,   4.300875665505371e-05,  -2.183747682512388e-07,  -4.400551228670746e-09,
   9.354757310980990e-11,   2.498687418064585e-12,  -1.259931655193169e-13,   5.629029342877328e-17,   1.149781306952222e-16,   4.261705749752494e-01,  -4.482347998159960e-03,
   4.300764326965884e-05,  -2.183354477602403e-07,  -4.398966476081051e-09,   9.343616115278077e-11,   2.498741788765084e-12,  -1.258187339318420e-13,   5.205705234560192e-17,
   1.148318589273409e-16,   4.261708761394029e-01,  -4.482352578755773e-03,   4.300745872304098e-05,  -2.183289313344947e-07,  -4.398703779832576e-09,   9.341769800059197e-11,
   2.498750641152760e-12,  -1.257898265719079e-13,   5.135588262655885e-17,   1.148076114129627e-16,   5.856050997148942e-01,  -6.151153081809673e-03,   5.829816133699201e-05,
  -2.500140569247503e-07,  -8.005211199372098e-09,   1.680389498036540e-10,   3.657739969579920e-12,  -2.077345450206504e-13,   5.244070514627613e-16,   1.855252184169815e-16,
   5.856133823161541e-01,  -6.151258992523031e-03,   5.829137048234707e-05,  -2.497800278485928e-07,  -7.997385411349941e-09,   1.674329825466890e-10,   3.659311979583870e-12,
  -2.068035651237895e-13,   4.992439917472108e-16,   1.848009336042312e-16,   5.856269788556432e-01,  -6.151432791078523e-03,   5.828022703001063e-05,  -2.493964483577896e-07,
  -7.984535960697121e-09,   1.664401874059429e-10,   3.661821566519538e-12,  -2.052779020819344e-13,   4.581698773961797e-16,   1.836106630775799e-16,   5.856414048961721e-01,
  -6.151617108357889e-03,   5.826840953704209e-05,  -2.489902784597617e-07,  -7.970898833482215e-09,   1.653894675311234e-10,   3.664388139712085e-12,  -2.036627154889417e-13,
   4.149055818063074e-16,   1.823460495339038e-16,   5.856527575864445e-01,  -6.151762097294772e-03,   5.825911386619260e-05,  -2.486712261731084e-07,  -7.960164313383672e-09,
   1.645645068826362e-10,   3.666338616374772e-12,  -2.023942067605174e-13,   3.810861558630780e-16,   1.813496329564632e-16,   5.856593091737190e-01,  -6.151845745320449e-03,
   5.825375106025780e-05,  -2.484873373078902e-07,  -7.953968413724458e-09,   1.640891913660539e-10,   3.667436538398117e-12,  -2.016631890478184e-13,   3.616601533251084e-16,
   1.807741272015602e-16,   5.856617693084344e-01,  -6.151877150710916e-03,   5.825173763385477e-05,  -2.484183310012887e-07,  -7.951641642734270e-09,   1.639108540144398e-10,
   3.667843587866457e-12,  -2.013888857048278e-13,   3.543828250205045e-16,   1.805579344347761e-16,   5.856621771082630e-01,  -6.151882356325715e-03,   5.825140389862994e-05,
  -2.484068946330621e-07,  -7.951255939318522e-09,   1.638812998695228e-10,   3.667910786449255e-12,  -2.013434266087961e-13,   3.531774170877255e-16,   1.805220929542608e-16,
   7.842170750036530e-01,  -8.220544300416483e-03,   7.623606125440782e-05,  -2.207127371466746e-07,  -1.508096213022196e-08,   3.114634389853197e-10,   5.321129839388658e-12,
  -3.494526828677257e-13,   1.720617807802594e-15,   2.980277347741063e-16,   7.842278981918700e-01,  -8.220636993693190e-03,   7.622324924095464e-05,  -2.202780954046121e-07,
  -1.506953498090202e-08,   3.104430246298120e-10,   5.327021140102054e-12,  -3.479530712250029e-13,   1.673739542464714e-15,   2.970187605171640e-16,   7.842456649001247e-01,
  -8.220789032596654e-03,   7.620222331998638e-05,  -2.195656002658267e-07,  -1.505076688450655e-08,   3.087710706298564e-10,   5.336560017508754e-12,  -3.454949856103406e-13,
   1.597193502619318e-15,   2.953578882409090e-16,   7.842645149751101e-01,  -8.220950178246237e-03,   7.617992280770784e-05,  -2.188109989834149e-07,  -1.503084093145340e-08,
   3.070013717507995e-10,   5.346501872256404e-12,  -3.428918987202475e-13,   1.516530796662757e-15,   2.935895712958090e-16,   7.842793487979069e-01,  -8.221076870980525e-03,
   7.616237915092181e-05,  -2.182181440851094e-07,  -1.501515082426837e-08,   3.056117724627527e-10,   5.354196612323828e-12,  -3.408469781069385e-13,   1.453451914945680e-15,
   2.921936146734412e-16,   7.842879091720159e-01,  -8.221149935873792e-03,   7.615225715556370e-05,  -2.178764044410483e-07,  -1.500609246707291e-08,   3.048110742758611e-10,
   5.358585632772446e-12,  -3.396683087894776e-13,   1.417209004018925e-15,   2.913862855510439e-16,   7.842911235802716e-01,  -8.221177362651882e-03,   7.614845677345890e-05,
  -2.177481549637500e-07,  -1.500269034549927e-08,   3.045106434321234e-10,   5.360223989329178e-12,  -3.392259894507744e-13,   1.403629837075217e-15,   2.910828075237820e-16,
   7.842916564093153e-01,  -8.221181908515228e-03,   7.614782683357324e-05,  -2.177268998461902e-07,  -1.500212636261186e-08,   3.044608553395740e-10,   5.360495055752798e-12,
  -3.391526836097295e-13,   1.401380498605267e-15,   2.910324849865404e-16,   1.037513852678708e+00,  -1.083427977795312e-02,   9.622434060051979e-05,   5.822364452381872e-09,
  -3.185256561126971e-08,   6.672628658657545e-10,   7.728860473148280e-12,  -6.805674960182191e-13,   6.801569507950408e-15,   5.010566288542135e-16,   1.037527491610107e+00,
  -1.083427400017595e-02,   9.619723875303189e-05,   6.755136125645379e-09,  -3.183577468109329e-08,   6.652695755848953e-10,   7.753773681088783e-12,  -6.780263667183238e-13,
   6.695342734466449e-15,   5.001126107551308e-16,   1.037549879351797e+00,  -1.083426423110689e-02,   9.615275713667349e-05,   8.284398448380670e-09,  -3.180817236859305e-08,
   6.620027385446094e-10,   7.794371472350630e-12,  -6.738583262328696e-13,   6.521767073912369e-15,   4.985443553481173e-16,   1.037573630709974e+00,  -1.083425347984650e-02,
   9.610557292161872e-05,   9.904303566837682e-09,  -3.177883376250358e-08,   6.585438038410972e-10,   7.837040689047053e-12,  -6.694406894285516e-13,   6.338691889172443e-15,
   4.968553812288041e-16,   1.037592320427431e+00,  -1.083424473968445e-02,   9.606844899998768e-05,   1.117718121789137e-08,  -3.175570781781692e-08,   6.558269814595728e-10,
   7.870327055417901e-12,  -6.659676176594152e-13,   6.195406573686995e-15,   4.955082572236039e-16,   1.037603105536190e+00,  -1.083423958387107e-02,   9.604702819217449e-05,
   1.191098442378257e-08,  -3.174234689390109e-08,   6.542612045166712e-10,   7.889419534335341e-12,  -6.639647051304931e-13,   6.113032138902499e-15,   4.947236860058724e-16,
   1.037607155245271e+00,  -1.083423762671077e-02,   9.603898524744104e-05,   1.218638382845002e-08,  -3.173732700324069e-08,   6.536736467673356e-10,   7.896566736156999e-12,
  -6.632128695901977e-13,   6.082159804830005e-15,   4.944277322744406e-16,   1.037607826531624e+00,  -1.083423730117051e-02,   9.603765205546884e-05,   1.223202725837220e-08,
  -3.173649474063239e-08,   6.535762721312235e-10,   7.897750316234943e-12,  -6.630882567822192e-13,   6.077045441349984e-15,   4.943786031980317e-16,   1.385211928790177e+00,
  -1.431704693782052e-02,   1.109541507509008e-04,   1.219049793833496e-06,  -9.602534010652485e-08,   2.244742297922153e-09,   8.117219624158258e-12,  -2.222673598180696e-12,
   5.865964084985569e-14,   3.217379335616069e-16,   1.385227553733394e+00,  -1.431651542113803e-02,   1.108722746879983e-04,   1.222188441035539e-06,  -9.600534578649503e-08,
   2.238131428599256e-09,   8.342746365312705e-12,  -2.220738814112130e-12,   5.826327278949587e-14,   3.325134031284008e-16,   1.385253196204979e+00,  -1.431564189501732e-02,
   1.107378750570434e-04,   1.227334252209541e-06,  -9.597217827806423e-08,   2.227282979769742e-09,   8.711848260304647e-12,  -2.217523485118170e-12,   5.761340118962287e-14,
   3.500927258984817e-16,   1.385280393431872e+00,  -1.431471371887059e-02,   1.105952846841307e-04,   1.232785135161492e-06,  -9.593651897051171e-08,   2.215777912551258e-09,
   9.101950293534969e-12,  -2.214058899037559e-12,   5.692497285490652e-14,   3.685960650443849e-16,   1.385301789526623e+00,  -1.431398230089484e-02,   1.104830784502963e-04,
   1.237068334871648e-06,  -9.590811825111356e-08,   2.206727726352337e-09,   9.407846083790934e-12,  -2.211294144576867e-12,   5.638400357341526e-14,   3.830501533315786e-16,
   1.385314134318210e+00,  -1.431355980938828e-02,   1.104183273348924e-04,   1.239537578650235e-06,  -9.589159293941584e-08,   2.201506447237514e-09,   9.583937301208591e-12,
  -2.209683333019209e-12,   5.607213299740005e-14,   3.913486217096207e-16,   1.385318769284027e+00,  -1.431340108861432e-02,   1.103940136517427e-04,   1.240464298808590e-06,
  -9.588536209008486e-08,   2.199546139122342e-09,   9.649976815746330e-12,  -2.209075587794635e-12,   5.595508570744250e-14,   3.944566101888444e-16,   1.385319537562922e+00,
  -1.431337477462879e-02,   1.103899833638209e-04,   1.240617889277725e-06,  -9.588432789676958e-08,   2.199221207652756e-09,   9.660919354417441e-12,  -2.208974694114049e-12,
   5.593568678338600e-14,   3.949713730468227e-16,   2.238131864760080e-03,  -2.273656298415418e-05,   2.221175216952397e-07,  -1.689019660841779e-09,  -3.441146327818658e-12,
   4.048416643306406e-13,  -9.559384733620171e-16,  -3.391108827327397e-16,   9.209545482173734e-18,   6.074561161493778e-20,   2.238163467788471e-03,  -2.273728206023118e-05,
   2.221145745195316e-07,  -1.688452045650069e-09,  -3.442766838802234e-12,   4.038338002253148e-13,  -9.204339250894717e-16,  -3.387673953523279e-16,   9.151950809718010e-18,
   6.196082506089896e-20,   2.238215348971400e-03,  -2.273846236686413e-05,   2.221097353860625e-07,  -1.687521247734691e-09,  -3.445373023946838e-12,   4.021799908078306e-13,
  -8.623123685677992e-16,  -3.381991071888128e-16,   9.057567940040911e-18,   6.394229963195606e-20,   2.238270398504902e-03,  -2.273971452831509e-05,   2.221045995304055e-07,
  -1.686535004445336e-09,  -3.448064937843315e-12,   4.004262128010253e-13,  -8.008647586178177e-16,  -3.375901594223588e-16,   8.957649278902688e-18,   6.602650658896116e-20,
   2.238313722479229e-03,  -2.274069981586854e-05,   2.221005567585690e-07,  -1.685759842878221e-09,  -3.450130417429079e-12,   3.990467384657343e-13,  -7.526670330141148e-16,
  -3.371066276167297e-16,   8.879178768897578e-18,   6.765358478095536e-20,   2.238338725472612e-03,  -2.274126837644769e-05,   2.220982232692690e-07,  -1.685312889563173e-09,
  -3.451301208536178e-12,   3.982509220845823e-13,  -7.249159979759700e-16,  -3.368258606357896e-16,   8.833958543129125e-18,   6.858732369814446e-20,   2.238348114322690e-03,
  -2.274148186372608e-05,   2.220973469596529e-07,  -1.685145131172727e-09,  -3.451736842385892e-12,   3.979521429688460e-13,  -7.145074508166611e-16,  -3.367201072180140e-16,
   8.816990505985414e-18,   6.893695556476829e-20,   2.238349670657790e-03,  -2.274151725161931e-05,   2.220972016955767e-07,  -1.685117326881271e-09,  -3.451808843498426e-12,
   3.979026191093634e-13,  -7.127827307822301e-16,  -3.367025600757114e-16,   8.814178476326388e-18,   6.899485952522684e-20,   2.020907376754318e-02,  -2.052902983682722e-04,
   2.004673612413500e-06,  -1.518938697494943e-08,  -3.371777182455504e-11,   3.724758412718191e-12,  -9.240911735356725e-15,  -3.090640738603522e-15,   8.427015132429744e-17,
   5.465433769314512e-19,   2.020935898925260e-02,  -2.052967646150446e-04,   2.004644734614875e-06,  -1.518416388231818e-08,  -3.373365378698883e-11,   3.715572251261472e-12,
  -8.916016093436514e-15,  -3.087544011139148e-15,   8.374402967919047e-17,   5.577131227878147e-19,   2.020982722388046e-02,  -2.053073784123935e-04,   2.004597318445938e-06,
  -1.517559875764848e-08,  -3.375923110960589e-11,   3.700498559681274e-12,  -8.384153760658232e-15,  -3.082419803321877e-15,   8.288184294450382e-17,   5.759264981122785e-19,
   2.021032405297661e-02,  -2.053186383079965e-04,   2.004546994718253e-06,  -1.516652330675201e-08,  -3.378569848298592e-11,   3.684513604428684e-12,  -7.821851679386499e-15,
  -3.076927926126624e-15,   8.196907524205892e-17,   5.950848113292903e-19,   2.021071505716637e-02,  -2.053274983396804e-04,   2.004507381477940e-06,  -1.515939014967853e-08,
  -3.380604279086932e-11,   3.671940200961023e-12,  -7.380795687574763e-15,  -3.072566383302773e-15,   8.125223037113085e-17,   6.100415988856228e-19,   2.021094071215981e-02,
  -2.053326110101700e-04,   2.004484516657159e-06,  -1.515527718027729e-08,  -3.381758954210577e-11,   3.664686598023440e-12,  -7.126845758378411e-15,  -3.070033519688768e-15,
   8.083913061993631e-17,   6.186251065226026e-19,   2.021102544763253e-02,  -2.053345307503091e-04,   2.004475930081291e-06,  -1.515373342142443e-08,  -3.382188876743531e-11,
   3.661963319980268e-12,  -7.031596874497386e-15,  -3.069079438337696e-15,   8.068412209875653e-17,   6.218391749685671e-19,   2.021103949373834e-02,  -2.053348489684673e-04,
   2.004474506701467e-06,  -1.515347755833114e-08,  -3.382259949071939e-11,   3.661511925236589e-12,  -7.015813906843579e-15,  -3.068921129419938e-15,   8.065843326291702e-17,
   6.223714718286637e-19,   5.651043377245121e-02,  -5.740042353206394e-04,   5.600285427832283e-06,  -4.211592703254151e-08,  -1.097143861146883e-10,   1.082060992379570e-11,
  -2.944591995913011e-14,  -8.809049428039165e-15,   2.421836806253019e-16,   1.514960792464730e-18,   5.651123054524292e-02,  -5.740221619610999e-04,   5.600191460798866e-06,
  -4.210074946790082e-08,  -1.097661935732603e-10,   1.079442397861231e-11,  -2.851209285986547e-14,  -8.800427357634629e-15,   2.406770596820748e-16,   1.547359846948842e-18,
   5.651253856706354e-02,  -5.740515868119322e-04,   5.600037170217936e-06,  -4.207585991354595e-08,  -1.098498196882446e-10,   1.075145468717837e-11,  -2.698337874956001e-14,
  -8.786155545213688e-15,   2.382080191046478e-16,   1.600192527786638e-18,   5.651392646617557e-02,  -5.740828025639254e-04,   5.599873417744339e-06,  -4.204948668608006e-08,
  -1.099366214677606e-10,   1.070588714604969e-11,  -2.536715143022362e-14,  -8.770853361189562e-15,   2.355940603143670e-16,   1.655770082461268e-18,   5.651501874056111e-02,
  -5.741073649750017e-04,   5.599744516371479e-06,  -4.202875724541842e-08,  -1.100035389611212e-10,   1.067004432713781e-11,  -2.409940690885809e-14,  -8.758696129487872e-15,
   2.335411296326282e-16,   1.699161948901392e-18,   5.651564910965616e-02,  -5.741215386001354e-04,   5.599670114041762e-06,  -4.201680447060289e-08,  -1.100415997219298e-10,
   1.064936641702937e-11,  -2.336946252326478e-14,  -8.751634307888724e-15,   2.323580570023256e-16,   1.724065099946991e-18,   5.651588581879922e-02,  -5.741268605929631e-04,
   5.599642173195301e-06,  -4.201231808621919e-08,  -1.100557864401996e-10,   1.064160311224348e-11,  -2.309568145384102e-14,  -8.748973918142342e-15,   2.319141257168173e-16,
   1.733390221265579e-18,   5.651592505668988e-02,  -5.741277427712894e-04,   5.599637541493230e-06,  -4.201157450936575e-08,  -1.100581325302165e-10,   1.064031631026958e-11,
  -2.305031521513385e-14,  -8.748532467017627e-15,   2.318405548654927e-16,   1.734934609271515e-18,   1.119022930418083e-01,  -1.136497674133561e-03,   1.107269524020180e-05,
  -8.225918644559555e-08,  -2.665088899075041e-10,   2.272696447281731e-11,  -7.011522253591891e-14,  -1.797362892840066e-14,   5.007263102183811e-16,   2.946343257603891e-18,
   1.119038683086473e-01,  -1.136532679814191e-03,   1.107246697594606e-05,  -8.222729524208023e-08,  -2.666357110675898e-10,   2.267352477285675e-11,  -6.818411204031165e-14,
  -1.795672851875801e-14,   4.976297505277159e-16,   3.014310678220396e-18,   1.119064543406011e-01,  -1.136590137570884e-03,   1.107209217216597e-05,  -8.217499551928070e-08,
  -2.668409631171878e-10,   2.258583251967008e-11,  -6.502274961197758e-14,  -1.792873764036963e-14,   4.925549550734201e-16,   3.125153578761723e-18,   1.119091982884370e-01,
  -1.136651091472480e-03,   1.107169438079061e-05,  -8.211957599382651e-08,  -2.670547558150719e-10,   2.249283573607553e-11,  -6.168033823707079e-14,  -1.789870414130878e-14,
   4.871820638917319e-16,   3.241767988183159e-18,   1.119113577666806e-01,  -1.136699052949688e-03,   1.107138124844433e-05,  -8.207601447526326e-08,  -2.672201247373975e-10,
   2.241968427286726e-11,  -5.905854824206204e-14,  -1.787482767298293e-14,   4.829621748796996e-16,   3.332823302581552e-18,   1.119126040345335e-01,  -1.136726728624854e-03,
   1.107120050646220e-05,  -8.205089588689956e-08,  -2.673144070302505e-10,   2.237748223642432e-11,  -5.754894790544736e-14,  -1.786095229625824e-14,   4.805302495396409e-16,
   3.385084843446300e-18,   1.119130720187531e-01,  -1.136737120392233e-03,   1.107113263094312e-05,  -8.204146769213021e-08,  -2.673495928257588e-10,   2.236163781556678e-11,
  -5.698273641884870e-14,  -1.785572389261489e-14,   4.796176911546587e-16,   3.404655168965657e-18,   1.119131495937437e-01,  -1.136738842938242e-03,   1.107112137933557e-05,
  -8.203990504937628e-08,  -2.673554138725855e-10,   2.235901152729139e-11,  -5.688891348612351e-14,  -1.785485625814604e-14,   4.794664560463276e-16,   3.407896362550657e-18,
   1.876396374081764e-01,  -1.905332388357298e-03,   1.852491949728272e-05,  -1.351154471075417e-07,  -5.693505496351596e-10,   4.136705263017568e-11,  -1.480584462601267e-13,
  -3.144705170475609e-14,   8.932782358537630e-16,   4.764281027448529e-18,   1.876422726595952e-01,  -1.905389867088362e-03,   1.852443182125060e-05,  -1.350573679980053e-07,
  -5.696258237586868e-10,   4.127352372431384e-11,  -1.446123753525803e-13,  -3.141935383805710e-14,   8.878046448825689e-16,   4.888072398542533e-18,   1.876465988010292e-01,
  -1.905484209993886e-03,   1.852363106508889e-05,  -1.349621177478284e-07,  -5.700724741326756e-10,   4.112004282639807e-11,  -1.389707702835761e-13,  -3.137343485257792e-14,
   8.788337855530209e-16,   5.089979135977500e-18,   1.876511891031528e-01,  -1.905584291022877e-03,   1.852278118924906e-05,  -1.348611803170445e-07,  -5.705392736770385e-10,
   4.095727243400901e-11,  -1.330058753193322e-13,  -3.132410442782129e-14,   8.693353416441313e-16,   5.302432732940103e-18,   1.876548016455960e-01,  -1.905663037892934e-03,
   1.852211218062339e-05,  -1.347818364469640e-07,  -5.709014946814529e-10,   4.082923301719046e-11,  -1.283268632023552e-13,  -3.128484384310894e-14,   8.618747720507282e-16,
   5.468346037467507e-18,   1.876568864946583e-01,  -1.905708477270613e-03,   1.852172602223753e-05,  -1.347360833861961e-07,  -5.711084774628181e-10,   4.075536384807273e-11,
  -1.256326773618330e-13,  -3.126201119209963e-14,   8.575750578010429e-16,   5.563582435356886e-18,   1.876576693724659e-01,  -1.905725538889816e-03,   1.852158100455643e-05,
  -1.347189098076060e-07,  -5.711858122134563e-10,   4.072762995949179e-11,  -1.246221480294661e-13,  -3.125340438474308e-14,   8.559615938528876e-16,   5.599247373640971e-18,
   1.876577991454708e-01,  -1.905728367027846e-03,   1.852155696520168e-05,  -1.347160634183395e-07,  -5.711986110256952e-10,   4.072303291981952e-11,  -1.244546997291671e-13,
  -3.125197594854150e-14,   8.556941983065355e-16,   5.605154219389603e-18,   2.856509186043603e-01,  -2.899765996672615e-03,   2.810980262421868e-05,  -1.995211265711755e-07,
  -1.136795625861296e-09,   7.024170606956092e-11,  -2.962786535129292e-13,  -5.072798304685136e-14,   1.481581511732063e-15,   6.721480502898043e-18,   2.856549168774347e-01,
  -2.899850828246301e-03,   2.810882881162151e-05,  -1.994224412990615e-07,  -1.137360405052134e-09,   7.009075900909764e-11,  -2.905604289842326e-13,  -5.068793288233448e-14,
   1.472630218240436e-15,   6.932709272100336e-18,   2.856614805893231e-01,  -2.899990062854726e-03,   2.810722981341570e-05,  -1.992605884312860e-07,  -1.138278857484696e-09,
   6.984304509206480e-11,  -2.811986838030109e-13,  -5.062141839716138e-14,   1.457958481077157e-15,   7.277288013199682e-18,   2.856684450584307e-01,  -2.900137760587072e-03,
   2.810553271091709e-05,  -1.990890606040535e-07,  -1.139241571441324e-09,   6.958032484534932e-11,  -2.712999664220447e-13,  -5.054980520584161e-14,   1.442422329293843e-15,
   7.639947140994676e-18,   2.856739260333793e-01,  -2.900253969851444e-03,   2.810419676472799e-05,  -1.989542197230303e-07,  -1.139990680437616e-09,   6.937365265091588e-11,
  -2.635348037463763e-13,  -5.049269848358679e-14,   1.430218309406472e-15,   7.923220461265334e-18,   2.856770891715784e-01,  -2.900321024621068e-03,   2.810342563749816e-05,
  -1.988764614977573e-07,  -1.140419583423675e-09,   6.925441440082068e-11,  -2.590634602763622e-13,  -5.045944287423628e-14,   1.423184376943448e-15,   8.085846603269213e-18,
   2.856782769539369e-01,  -2.900346202111241e-03,   2.810313604772347e-05,  -1.988472740548032e-07,  -1.140579994542353e-09,   6.920964614340193e-11,  -2.573863311305085e-13,
  -5.044689883388678e-14,   1.420544815473502e-15,   8.146752690660263e-18,   2.856784738454693e-01,  -2.900350375522334e-03,   2.810308804281813e-05,  -1.988424364273010e-07,
  -1.140606550906695e-09,   6.920222552813891e-11,  -2.571084234267405e-13,  -5.044481651664580e-14,   1.420107362765269e-15,   8.156840224458817e-18,   4.088722600101714e-01,
  -4.149013592201965e-03,   4.004723445635976e-05,  -2.727772635917195e-07,  -2.193610230401278e-09,   1.160331733425392e-10,  -5.839467249189136e-13,  -7.849802139375798e-14,
   2.386345269180184e-15,   8.050320418111543e-18,   4.088779552463538e-01,  -4.149129470823190e-03,   4.004535506486073e-05,  -2.726141127127071e-07,  -2.194747663748107e-09,
   1.157994136337456e-10,  -5.747300081354922e-13,  -7.844737746540720e-14,   2.372245258992549e-15,   8.403825550879159e-18,   4.088873047042584e-01,  -4.149319654457855e-03,
   4.004226907195711e-05,  -2.723465142157934e-07,  -2.196600879651634e-09,   1.154157746680193e-10,  -5.596396890484065e-13,  -7.836295482671009e-14,   2.349131645310062e-15,
   8.980640821466584e-18,   4.088972249380282e-01,  -4.149521386248706e-03,   4.003899369234334e-05,  -2.720628977424157e-07,  -2.198548203476524e-09,   1.150088624505185e-10,
  -5.436825651075722e-13,  -7.827164005105696e-14,   2.324652452331237e-15,   9.587912804725345e-18,   4.089050320232162e-01,  -4.149680101211268e-03,   4.003641530152796e-05,
  -2.718399262215158e-07,  -2.200066968782736e-09,   1.146887362403373e-10,  -5.311639102868015e-13,  -7.819852362461040e-14,   2.305420722998576e-15,   1.006239164467713e-17,
   4.089095375682051e-01,  -4.149771679081818e-03,   4.003492700248976e-05,  -2.717113396331080e-07,  -2.200937959511067e-09,   1.145040319659308e-10,  -5.239550437255339e-13,
  -7.815582698591220e-14,   2.294335193109821e-15,   1.033484367597647e-17,   4.089112294306841e-01,  -4.149806063772324e-03,   4.003436808253896e-05,  -2.716630719756433e-07,
  -2.201263983196665e-09,   1.144346825697594e-10,  -5.212510450956265e-13,  -7.813969973907644e-14,   2.290175018353653e-15,   1.043689182626522e-17,   4.089115098803438e-01,
  -4.149811763331234e-03,   4.003427543098266e-05,  -2.716550718639947e-07,  -2.201317971344880e-09,   1.144231873850889e-10,  -5.208029769700304e-13,  -7.813702145109320e-14,
   2.289485544579297e-15,   1.045379404450052e-17,   5.619115471558308e-01,  -5.698668918618602e-03,   5.465067450922254e-05,  -3.483183584012363e-07,  -4.206331320389603e-09,
   1.928239176106272e-10,  -1.174250985694382e-12,  -1.199142319160253e-13,   3.871008762594267e-15,   6.227862091703553e-18,   5.619193170992461e-01,  -5.698816665226987e-03,
   5.464706984797988e-05,  -3.480469739010977e-07,  -4.208660737344961e-09,   1.924663581305335e-10,  -1.159282720208166e-12,  -1.198662558231414e-13,   3.848982454360306e-15,
   6.831780942852432e-18,   5.619320723464376e-01,  -5.699059132168842e-03,   5.464115083138557e-05,  -3.476018197349106e-07,  -4.212462000793099e-09,   1.918794803334338e-10,
  -1.134773062916464e-12,  -1.197853018003743e-13,   3.812868284297149e-15,   7.817546029145626e-18,   5.619456061433734e-01,  -5.699316295555788e-03,   5.463486842696246e-05,
  -3.471299760326177e-07,  -4.216464431298457e-09,   1.912569150760308e-10,  -1.108852206639877e-12,  -1.196964336132634e-13,   3.774610598630748e-15,   8.855835334122070e-18,
   5.619562569461638e-01,  -5.699518602887035e-03,   5.462992279347130e-05,  -3.467589939916610e-07,  -4.219591959355471e-09,   1.907670689520014e-10,  -1.088514409316199e-12,
  -1.196243527033038e-13,   3.744546891502625e-15,   9.667424035492467e-18,   5.619624035857911e-01,  -5.699635325708365e-03,   5.462706803321946e-05,  -3.465450378630931e-07,
  -4.221387949366518e-09,   1.904844163360914e-10,  -1.076801923627585e-12,  -1.195818980593558e-13,   3.727214768709236e-15,   1.013358705113907e-17,   5.619647116823189e-01,
  -5.699679150110565e-03,   5.462599594081806e-05,  -3.464647225874187e-07,  -4.222060668144496e-09,   1.903782864605234e-10,  -1.072408464342889e-12,  -1.195657946007290e-13,
   3.720709838889482e-15,   1.030821666477248e-17,   5.619650942808907e-01,  -5.699686414306657e-03,   5.462581822080589e-05,  -3.464514106251273e-07,  -4.222172091620296e-09,
   1.903606943908293e-10,  -1.071680433235831e-12,  -1.195631167202871e-13,   3.719631736125701e-15,   1.033714191857593e-17,   7.525327713237560e-01,  -7.624849227260569e-03,
   7.235919006579148e-05,  -4.083453807657479e-07,  -8.301225485330667e-09,   3.356170158351377e-10,  -2.533040374047092e-12,  -1.860865053432489e-13,   6.624559537675842e-15,
  -8.511063394000812e-18,   7.525430542561425e-01,  -7.625021889088583e-03,   7.235207335083510e-05,  -4.078724698102670e-07,  -8.306328652483485e-09,   3.350607389376320e-10,
  -2.507370395745911e-12,  -1.861005757329047e-13,   6.589512513970612e-15,  -7.402213705967972e-18,   7.525599346178489e-01,  -7.625305196605474e-03,   7.234038705779012e-05,
  -4.070966821243133e-07,  -8.314667108442275e-09,   3.341475089971441e-10,  -2.465329615724985e-12,  -1.861196394827948e-13,   6.532027571727684e-15,  -5.591248691013416e-18,
   7.525778449858932e-01,  -7.625605611055550e-03,   7.232798286053295e-05,  -4.062742890711518e-07,  -8.323461637963594e-09,   3.331784907027565e-10,  -2.420857800576890e-12,
  -1.861344025842284e-13,   6.471100751475995e-15,  -3.682417281504479e-18,   7.525919398152551e-01,  -7.625841896450616e-03,   7.231821770699724e-05,  -4.056276244462506e-07,
  -8.330344515257981e-09,   3.324158641381471e-10,  -2.385957159606448e-12,  -1.861420793047551e-13,   6.423201574151681e-15,  -2.189366251559982e-18,   7.526000739264811e-01,
  -7.625978204334293e-03,   7.231258085274159e-05,  -4.052546473346700e-07,  -8.334301362148990e-09,   3.319757370184560e-10,  -2.365854944393456e-12,  -1.861449344734590e-13,
   6.395578444758218e-15,  -1.331383389795429e-18,   7.526031283112352e-01,  -7.626029378522197e-03,   7.231046393279176e-05,  -4.051146333777225e-07,  -8.335784290075495e-09,
   3.318104649743266e-10,  -2.358313850077040e-12,  -1.861457094680317e-13,   6.385209563961046e-15,  -1.009898349093452e-18,   7.526036346163318e-01,  -7.626037860807832e-03,
   7.231011301114244e-05,  -4.050914263105877e-07,  -8.336029953289553e-09,   3.317830687743467e-10,  -2.357064200683347e-12,  -1.861458222727158e-13,   6.383490978644618e-15,
  -9.566443060240036e-19,   9.957059174249693e-01,  -1.007181953216761e-02,   9.369313517567541e-05,  -3.928486442593920e-07,  -1.801559815539289e-08,   6.605591318194264e-10,
  -6.514285891577546e-12,  -3.047490926908739e-13,   1.311340898061466e-14,  -8.940029776397459e-17,   9.957192195604954e-01,  -1.007198395581038e-02,   9.367767760541802e-05,
  -3.919163668906512e-07,  -1.802889882823090e-08,   6.596422358263444e-10,  -6.463228139927303e-12,  -3.051430435023982e-13,   1.305588108129295e-14,  -8.699929043510913e-17,
   9.957410555676837e-01,  -1.007225359798273e-02,   9.365229348437488e-05,  -3.903868282538082e-07,  -1.805065589690384e-08,   6.581361930543479e-10,  -6.379574321121527e-12,
  -3.057810089985909e-13,   1.296142779561938e-14,  -8.307381925438651e-17,   9.957642230826054e-01,  -1.007253932083753e-02,   9.362534809926939e-05,  -3.887651550512910e-07,
  -1.807363577198244e-08,   6.565370752456568e-10,  -6.291036427266614e-12,  -3.064460553593163e-13,   1.286119095238223e-14,  -7.893055798896425e-17,   9.957824544625326e-01,
  -1.007276390518998e-02,   9.360413408937110e-05,  -3.874898208005409e-07,  -1.809164437690853e-08,   6.552777799912102e-10,  -6.221519753365992e-12,  -3.069608715199722e-13,
   1.278229471030133e-14,  -7.568568581425836e-17,   9.957929755165255e-01,  -1.007289340459984e-02,   9.359188792942632e-05,  -3.867541738006683e-07,  -1.810200679508685e-08,
   6.545507056102326e-10,  -6.181465708473437e-12,  -3.072545516562090e-13,   1.273675882250840e-14,  -7.381937574725236e-17,   9.957969261574781e-01,  -1.007294201163614e-02,
   9.358728878190248e-05,  -3.864780016143426e-07,  -1.810589218787760e-08,   6.542776235845495e-10,  -6.166437375458263e-12,  -3.073641841073535e-13,   1.271965906455860e-14,
  -7.311976124059050e-17,   9.957975810264632e-01,  -1.007295006782567e-02,   9.358652637612179e-05,  -3.864322258449823e-07,  -1.810653594156762e-08,   6.542323532585983e-10,
  -6.163946866155673e-12,  -3.073823231288566e-13,   1.271682450554912e-14,  -7.300385360246770e-17,   1.329779256986457e+00,  -1.339362698273640e-02,   1.178315085836131e-04,
   3.503739697373276e-08,  -5.313425223699482e-08,   1.901495232782521e-09,  -2.879226963169972e-11,  -5.148157803614341e-13,   4.084499895538126e-14,  -9.165318412248387e-16,
   1.329795933359284e+00,  -1.339360251560271e-02,   1.177858038568306e-04,   3.772970435694074e-08,  -5.319378863862004e-08,   1.899885020504173e-09,  -2.863022286468866e-11,
  -5.193264608859806e-13,   4.081199971524032e-14,  -9.096499303579976e-16,   1.329823305570588e+00,  -1.339356152130927e-02,   1.177107360174595e-04,   4.214787690264492e-08,
  -5.329127765184382e-08,   1.897231973614163e-09,  -2.836429762769901e-11,  -5.267059913801211e-13,   4.075682736558965e-14,  -8.983522099547471e-16,   1.329852343139943e+00,
  -1.339351689879858e-02,   1.176310342136067e-04,   4.683360301236242e-08,  -5.339438185644610e-08,   1.894403837756167e-09,  -2.808226890050539e-11,  -5.345016129806922e-13,
   4.069693206399713e-14,  -8.863647402009269e-16,   1.329875191179178e+00,  -1.339348096678353e-02,   1.175682730462680e-04,   5.051962719290115e-08,  -5.347527990687262e-08,
   1.892168656540355e-09,  -2.786041231636335e-11,  -5.406117356318588e-13,   4.064881772734938e-14,  -8.769309144488557e-16,   1.329888375352754e+00,  -1.339345990355356e-02,
   1.175320381694731e-04,   5.264623426916827e-08,  -5.352186936828736e-08,   1.890874920182102e-09,  -2.773241563507174e-11,  -5.441279569736430e-13,   4.062065969748271e-14,
  -8.714866755527149e-16,   1.329893325786269e+00,  -1.339345193246236e-02,   1.175184289353716e-04,   5.344466965531371e-08,  -5.353934558125110e-08,   1.890388397756099e-09,
  -2.768435942312324e-11,  -5.454464335633469e-13,   4.061001243552739e-14,  -8.694423553463966e-16,   1.329894146372766e+00,  -1.339345060788840e-02,   1.175161728688304e-04,
   5.357701506025054e-08,  -5.354224153290077e-08,   1.890307712184798e-09,  -2.767639383155311e-11,  -5.456648897252443e-13,   4.060824361769889e-14,  -8.691034825791342e-16,
   2.150610590757170e-03,  -2.104103805749136e-05,   2.017747269169064e-07,  -1.683174923742551e-09,   3.829894103986382e-12,   3.011440782646656e-13,  -6.408579979175298e-15,
  -6.417833095854053e-17,   6.775026951345616e-18,  -1.421908589281856e-19,   2.150639311206077e-03,  -2.104175513437463e-05,   2.017779215041837e-07,  -1.682748096806203e-09,
   3.816532537579690e-12,   3.009411716458699e-13,  -6.381765880264597e-15,  -6.487742632358666e-17,   6.766382429740216e-18,  -1.410955717298862e-19,   2.150686460789114e-03,
  -2.104293220086978e-05,   2.017831577914402e-07,  -1.682047604590885e-09,   3.794638635459813e-12,   3.006065766105003e-13,  -6.337771769491593e-15,  -6.602106367032205e-17,
   6.752072890935074e-18,  -1.392994377002968e-19,   2.150736490572790e-03,  -2.104418098104154e-05,   2.017887028414270e-07,  -1.681304618904203e-09,   3.771463582653296e-12,
   3.002495238232449e-13,  -6.291125557199288e-15,  -6.722906350790445e-17,   6.736729415143467e-18,  -1.373962802713983e-19,   2.150775864587907e-03,  -2.104516364849701e-05,
   2.017930588313601e-07,  -1.680720096386488e-09,   3.753265272773452e-12,   2.999670614637305e-13,  -6.254440184832324e-15,  -6.817579563265694e-17,   6.724538711326324e-18,
  -1.359004408335655e-19,   2.150798588227113e-03,  -2.104573071336046e-05,   2.017955695577195e-07,  -1.680382841854004e-09,   3.742778932399079e-12,   2.998034629305122e-13,
  -6.233278584925051e-15,  -6.872058290431800e-17,   6.717457161115345e-18,  -1.350379515227796e-19,   2.150807121203238e-03,  -2.104594364207719e-05,   2.017965117559135e-07,
  -1.680256215485039e-09,   3.738844279959684e-12,   2.997419198226099e-13,  -6.225334135947380e-15,  -6.892485547601148e-17,   6.714789282963979e-18,  -1.347142279139090e-19,
   2.150808535667417e-03,  -2.104597893754397e-05,   2.017966679068699e-07,  -1.680235226199824e-09,   3.738192217077196e-12,   2.997317123599199e-13,  -6.224017332412420e-15,
  -6.895870073084910e-17,   6.714346586244366e-18,  -1.346605740041293e-19,   1.941882722524976e-02,  -1.899857115514586e-04,   1.821516277614841e-06,  -1.516886619471147e-08,
   3.312946234654085e-11,   2.767927148223810e-12,  -5.882896207883270e-14,  -5.787809829715339e-16,   6.180240375550807e-17,  -1.302261072432005e-18,   1.941908649587628e-02,
  -1.899921736168913e-04,   1.821543871415551e-06,  -1.516494278622311e-08,   3.300678882899139e-11,   2.766095696576402e-12,  -5.858434301495512e-14,  -5.851845578776686e-16,
   6.172444324920062e-17,  -1.292262914041926e-18,   1.941951213331122e-02,  -1.900027809364953e-04,   1.821589096321498e-06,  -1.515850380190561e-08,   3.280577691760086e-11,
   2.763075414604559e-12,  -5.818299196485157e-14,  -5.956601743710244e-16,   6.159537365133478e-17,  -1.275866929227176e-18,   1.941996377124936e-02,  -1.900140344828824e-04,
   1.821636981931831e-06,  -1.515167416665506e-08,   3.259299926860382e-11,   2.759852143648578e-12,  -5.775744276171368e-14,  -6.067255156699348e-16,   6.145695230287476e-17,
  -1.258493636848114e-18,   1.942031921537277e-02,  -1.900228898962337e-04,   1.821674594762385e-06,  -1.514630111419959e-08,   3.242591234183203e-11,   2.757302038909846e-12,
  -5.742276290308981e-14,  -6.153977543591204e-16,   6.134695528455325e-17,  -1.244838365608003e-18,   1.942052435020533e-02,  -1.900280000528053e-04,   1.821696272474310e-06,
  -1.514320098669379e-08,   3.232963155220913e-11,   2.755824974079971e-12,  -5.722970508359949e-14,  -6.203881544227850e-16,   6.128305098086916e-17,  -1.236964743329473e-18,
   1.942060138057852e-02,  -1.900299188775233e-04,   1.821704407119952e-06,  -1.514203700302869e-08,   3.229350519050989e-11,   2.755269311774227e-12,  -5.715722748251723e-14,
  -6.222593562702204e-16,   6.125897453055738e-17,  -1.234009467681290e-18,   1.942061414947621e-02,  -1.900302369454441e-04,   1.821705755261174e-06,  -1.514184406373243e-08,
   3.228751820762679e-11,   2.755177149556023e-12,  -5.714521420875249e-14,  -6.225693900827647e-16,   6.125497931154527e-17,  -1.233519659678564e-18,   5.430079939656490e-02,
  -5.312375127283223e-04,   5.091187986506739e-06,  -4.224648521835204e-08,   8.418431297382743e-11,   8.024480687955826e-12,  -1.701477756227471e-13,  -1.613287045300540e-15,
   1.764725118483712e-16,  -3.749415323377878e-18,   5.430152405049713e-02,  -5.312555085025581e-04,   5.091257860088749e-06,  -4.223510923939511e-08,   8.382940568582565e-11,
   8.019366285698531e-12,  -1.694491719514473e-13,  -1.631729229131964e-15,   1.762552780103660e-16,  -3.720827494940879e-18,   5.430271369410968e-02,  -5.312850479793500e-04,
   5.091372352490211e-06,  -4.221643911005941e-08,   8.324784329374643e-11,   8.010930829233948e-12,  -1.683029445554677e-13,  -1.661899572625215e-15,   1.758955144659084e-16,
  -3.673944767878060e-18,   5.430397600730471e-02,  -5.313163868928094e-04,   5.091493544045474e-06,  -4.219663599527910e-08,   8.263222159596194e-11,   8.001926819752067e-12,
  -1.670875883029054e-13,  -1.693769376030740e-15,   1.755095279761275e-16,  -3.624265448008054e-18,   5.430496946120362e-02,  -5.313410473407880e-04,   5.091588710051545e-06,
  -4.218105616813453e-08,   8.214878141326050e-11,   7.994802096557188e-12,  -1.661317372482478e-13,  -1.718747432666610e-15,   1.752026908541111e-16,  -3.585216394810840e-18,
   5.430554280559050e-02,  -5.313552779882239e-04,   5.091643547174006e-06,  -4.217206688671722e-08,   8.187020231531988e-11,   7.990674870807967e-12,  -1.655803550011481e-13,
  -1.733121237599623e-15,   1.750243853581276e-16,  -3.562700132142628e-18,   5.430575810262196e-02,  -5.313606214771690e-04,   5.091664122996394e-06,  -4.216869172759167e-08,
   8.176567315747736e-11,   7.989122147932441e-12,  -1.653733544157266e-13,  -1.738510899741607e-15,   1.749571990733811e-16,  -3.554248792937266e-18,   5.430579379121368e-02,
  -5.313615072231962e-04,   5.091667532886381e-06,  -4.216813226806026e-08,   8.174835017664833e-11,   7.988864608544188e-12,  -1.653390436907309e-13,  -1.739403899630905e-15,
   1.749460498218530e-16,  -3.552848060255310e-18,   1.075271553506572e-01,  -1.051903809065145e-03,   1.007431504003996e-05,  -8.311688504763899e-08,   1.397871410410422e-10,
   1.679954854468324e-11,  -3.551098901530747e-13,  -3.172587514755500e-15,   3.610882587250283e-16,  -7.773971498409806e-18,   1.075285892312224e-01,  -1.051939209354487e-03,
   1.007443020629329e-05,  -8.309306379102064e-08,   1.390460911812395e-10,   1.678945924646295e-11,  -3.536800754670533e-13,  -3.210842837692199e-15,   3.606617569138571e-16,
  -7.715360376234505e-18,   1.075309431894817e-01,  -1.051997317330273e-03,   1.007461881839856e-05,  -8.305396797097215e-08,   1.378317390122919e-10,   1.677281441963074e-11,
  -3.513340691139201e-13,  -3.273428834312713e-15,   3.599550257470158e-16,  -7.619235696339289e-18,   1.075334409364044e-01,  -1.052058964425845e-03,   1.007481833694075e-05,
  -8.301249877394993e-08,   1.365462079016182e-10,   1.675504231146911e-11,  -3.488465057162814e-13,  -3.339543631834504e-15,   3.591962487805763e-16,  -7.517370154871654e-18,
   1.075354066874021e-01,  -1.052107473805811e-03,   1.007497491548958e-05,  -8.297987282460466e-08,   1.355366524278311e-10,   1.674097564856015e-11,  -3.468900413332780e-13,
  -3.391363774852454e-15,   3.585926844023688e-16,  -7.437296556181112e-18,   1.075365411651630e-01,  -1.052135466628653e-03,   1.007506510241009e-05,  -8.296104798258439e-08,
   1.349548854823347e-10,   1.673282553235261e-11,  -3.457614356232058e-13,  -3.421185043827233e-15,   3.582417978265287e-16,  -7.391122929295970e-18,   1.075369671736783e-01,
  -1.052145977666013e-03,   1.007509893494602e-05,  -8.295397986837441e-08,   1.347365900963735e-10,   1.672975904787701e-11,  -3.453377293141658e-13,  -3.432367139022482e-15,
   3.581095540340985e-16,  -7.373791567465825e-18,   1.075370377907315e-01,  -1.052147719992106e-03,   1.007510454140379e-05,  -8.295280826957156e-08,   1.347004131564644e-10,
   1.672925041601162e-11,  -3.452674990195530e-13,  -3.434219882804644e-15,   3.580876073098021e-16,  -7.370919031790951e-18,   1.803042989510949e-01,  -1.763713063222968e-03,
   1.687487549191982e-05,  -1.380406743505768e-07,   1.677529048458753e-10,   3.043522492761324e-11,  -6.412820113505117e-13,  -5.243601398373750e-15,   6.342857855254629e-16,
  -1.392263449042983e-17,   1.803067006425326e-01,  -1.763771843346117e-03,   1.687501115477311e-05,  -1.379975052846954e-07,   1.664138425996098e-10,   3.041846464366947e-11,
  -6.387694200400736e-13,  -5.312160684331491e-15,   6.335844537045013e-16,  -1.381942115407057e-17,   1.803106434205887e-01,  -1.763868327147443e-03,   1.687523305038901e-05,
  -1.379266539644652e-07,   1.642194237029783e-10,   3.039080363475964e-11,  -6.346466825617638e-13,  -5.424330831270325e-15,   6.324212271691840e-16,  -1.365013334485185e-17,
   1.803148270302992e-01,  -1.763970685867324e-03,   1.687546738983859e-05,  -1.378514993585546e-07,   1.618962314512272e-10,   3.036125479606105e-11,  -6.302749955266626e-13,
  -5.542834513702666e-15,   6.311708727080563e-16,  -1.347071667005601e-17,   1.803181195657390e-01,  -1.764051229651318e-03,   1.687565101433265e-05,  -1.377923698169008e-07,
   1.600716708578407e-10,   3.033785643291392e-11,  -6.268365372849153e-13,  -5.635723094616593e-15,   6.301752413790918e-16,  -1.332966900489487e-17,   1.803200197573702e-01,
  -1.764097707807195e-03,   1.687575666652133e-05,  -1.377582520493497e-07,   1.590202055877804e-10,   3.032429546597830e-11,  -6.248529753158631e-13,  -5.689180901034101e-15,
   6.295960105041536e-16,  -1.324832997316280e-17,   1.803207332991753e-01,  -1.764115159827179e-03,   1.687579627931816e-05,  -1.377454418228638e-07,   1.586256579805460e-10,
   3.031919236895199e-11,  -6.241082873179932e-13,  -5.709226495515346e-15,   6.293776298042398e-16,  -1.321779820173117e-17,   1.803208515789932e-01,  -1.764118052697085e-03,
   1.687580284250763e-05,  -1.377433184149226e-07,   1.585602712621159e-10,   3.031834588715782e-11,  -6.239848530378218e-13,  -5.712547844733316e-15,   6.293413840286369e-16,
  -1.321273774991678e-17,   2.744861464691113e-01,  -2.684671547386652e-03,   2.565043673597555e-05,  -2.072445371319854e-07,   1.093022030064514e-10,   5.134138792673517e-11,
  -1.079271751968814e-12,  -7.745118871361162e-15,   1.028665225708265e-15,  -2.320965637198910e-17,   2.744897968765089e-01,  -2.684759767318052e-03,   2.565051730839791e-05,
  -2.071716869944716e-07,   1.070467793304955e-10,   5.131642285965382e-11,  -1.075194522119404e-12,  -7.859522640905500e-15,   1.027643611977278e-15,  -2.304181740823880e-17,
   2.744957896174769e-01,  -2.684904572188679e-03,   2.565064820452815e-05,  -2.070521181310242e-07,   1.033504150924499e-10,   5.127519447424429e-11,  -1.068504146685885e-12,
  -8.046715110145590e-15,   1.025946376727412e-15,  -2.276649932151942e-17,   2.745021483875150e-01,  -2.685058190876755e-03,   2.565078522672229e-05,  -2.069252823786743e-07,
   9.943681763233229e-11,   5.123111683261467e-11,  -1.061409327726653e-12,  -8.244498837065290e-15,   1.024118272191600e-15,  -2.247466362122656e-17,   2.745071527791985e-01,
  -2.685179067533222e-03,   2.565089171257084e-05,  -2.068254881852869e-07,   9.636297021506581e-11,   5.119618831955853e-11,  -1.055828723671298e-12,  -8.399546434660449e-15,
   1.022659923249251e-15,  -2.224520594516331e-17,   2.745100409139837e-01,  -2.685248818974515e-03,   2.565095262650070e-05,  -2.067679055463505e-07,   9.459146705416945e-11,
   5.117593470694653e-11,  -1.052609280929674e-12,  -8.488783343242364e-15,   1.021810441917817e-15,  -2.211286994033971e-17,   2.745111254377826e-01,  -2.685275009663459e-03,
   2.565097539807199e-05,  -2.067462846894632e-07,   9.392671758552434e-11,   5.116831121114860e-11,  -1.051400582174587e-12,  -8.522246568189372e-15,   1.021489974486257e-15,
  -2.206319329016547e-17,   2.745113052131505e-01,  -2.685279351056898e-03,   2.565097916739517e-05,  -2.067427008283910e-07,   9.381655051113517e-11,   5.116704655525254e-11,
  -1.051200235423299e-12,  -8.527791143940235e-15,   1.021436774485902e-15,  -2.205495956509304e-17,   3.928956104946946e-01,  -3.842157347817168e-03,   3.663576475039701e-05,
  -2.906650014269289e-07,  -1.472901372245763e-10,   8.403195537883497e-11,  -1.766833455605006e-12,  -1.037532546716855e-14,   1.603085429558781e-15,  -3.762189591324614e-17,
   3.929008237378614e-01,  -3.842281017716776e-03,   3.663561808450778e-05,  -2.905457071811497e-07,  -1.509861339588414e-10,   8.399799568228961e-11,  -1.760473770561104e-12,
  -1.056103465456954e-14,   1.601768659865823e-15,  -3.735980738703267e-17,   3.929093821020817e-01,  -3.842484005136511e-03,   3.663537505173501e-05,  -2.903499025163859e-07,
  -1.570439141327273e-10,   8.394184878275788e-11,  -1.750037300576606e-12,  -1.086493784904096e-14,   1.599573779298765e-15,  -3.692980645498430e-17,   3.929184631632202e-01,
  -3.842699340558188e-03,   3.663511411105910e-05,  -2.901421879804916e-07,  -1.634583761438503e-10,   8.388173476809207e-11,  -1.738968863506902e-12,  -1.118608691765709e-14,
   1.597199887643286e-15,  -3.647390124320071e-17,   3.929256099880423e-01,  -3.842868774528990e-03,   3.663490653346520e-05,  -2.899787514512443e-07,  -1.684969567188923e-10,
   8.383403622996842e-11,  -1.730261942322214e-12,  -1.143788075239798e-14,   1.595299195834188e-15,  -3.611536601337882e-17,   3.929297345531481e-01,  -3.842966543702672e-03,
   3.663478584898473e-05,  -2.898844434826960e-07,  -1.714009589293535e-10,   8.380635303997756e-11,  -1.725238623397814e-12,  -1.158281436750262e-14,   1.594189311095900e-15,
  -3.590855589309479e-17,   3.929312833669854e-01,  -3.843003254262161e-03,   3.663474036313763e-05,  -2.898490326404026e-07,  -1.724907109449475e-10,   8.379592838404428e-11,
  -1.723352624135646e-12,  -1.163716628545316e-14,   1.593770093824775e-15,  -3.583091714912726e-17,   3.929315401049758e-01,  -3.843009339418456e-03,   3.663473281436694e-05,
  -2.898431629310204e-07,  -1.726713144481797e-10,   8.379419880100284e-11,  -1.723040008993654e-12,  -1.164617209089300e-14,   1.593700473718141e-15,  -3.581804850254543e-17,
   5.399635630231185e-01,  -5.279048442287100e-03,   5.018682666731781e-05,  -3.871941426422601e-07,  -8.333319152554178e-10,   1.377757216656278e-10,  -2.913345762225873e-12,
  -1.208654085636014e-14,   2.472039284302630e-15,  -6.149038805158438e-17,   5.399707034763654e-01,  -5.279213052631450e-03,   5.018608061598626e-05,  -3.869984278776349e-07,
  -8.394341530652344e-10,   1.377347624450986e-10,  -2.903524614395834e-12,  -1.239072817012913e-14,   2.470696719587308e-15,  -6.108675836122128e-17,   5.399824256041067e-01,
  -5.279483226853079e-03,   5.018485212305207e-05,  -3.866771745400443e-07,  -8.494368277452717e-10,   1.376668712574603e-10,  -2.887405795416218e-12,  -1.288860786298027e-14,
   2.468437127666019e-15,  -6.042433774838172e-17,   5.399948635761852e-01,  -5.279769820640636e-03,   5.018354353427215e-05,  -3.863363602490792e-07,  -8.600298709475955e-10,
   1.375939518253082e-10,  -2.870308257006427e-12,  -1.341486802325343e-14,   2.465964259917914e-15,  -5.972174414157675e-17,   5.400046522447404e-01,  -5.279995312135091e-03,
   5.018251000641187e-05,  -3.860681815759086e-07,  -8.683517629842102e-10,   1.375359269096008e-10,  -2.856856653427394e-12,  -1.382756908550883e-14,   2.463963791735647e-15,
  -5.916901421740732e-17,   5.400103014443238e-01,  -5.280125423908660e-03,   5.018191207083878e-05,  -3.859134281364252e-07,  -8.731485224941244e-10,   1.375021847362456e-10,
  -2.849095195582244e-12,  -1.406515843476245e-14,   2.462787574349441e-15,  -5.885011174094211e-17,   5.400124227688028e-01,  -5.280174277679558e-03,   5.018168726307105e-05,
  -3.858553200408598e-07,  -8.749486256597790e-10,   1.374894660978493e-10,  -2.846181019806148e-12,  -1.415426437949776e-14,   2.462341797275883e-15,  -5.873037777905507e-17,
   5.400127744083754e-01,  -5.280182375654300e-03,   5.018164998335581e-05,  -3.858456879697904e-07,  -8.752469590359196e-10,   1.374873552644361e-10,  -2.845697970870275e-12,
  -1.416902909837598e-14,   2.462267687454381e-15,  -5.871053107012306e-17,   7.231575363796143e-01,  -7.067352636508793e-03,   6.686909931212126e-05,  -4.921259240409029e-07,
  -2.500763668176137e-09,   2.347690576513302e-10,  -5.050791282869205e-12,  -8.863071077505890e-15,   3.885900842262679e-15,  -1.060386989442506e-16,   7.231670479281452e-01,
  -7.067561556723455e-03,   6.686690409782030e-05,  -4.917921324020684e-07,  -2.511361278448358e-09,   2.347341920341031e-10,  -5.035312364813418e-12,  -9.389511883925472e-15,
   3.885759856081288e-15,  -1.054131350496433e-16,   7.231826624395346e-01,  -7.067904430154349e-03,   6.686329381637458e-05,  -4.912441987219434e-07,  -2.528735093319125e-09,
   2.346758283118855e-10,  -5.009902185622076e-12,  -1.025143144332940e-14,   3.885429945909018e-15,  -1.043859163059898e-16,   7.231992303234220e-01,  -7.068268105505460e-03,
   6.685945422733758e-05,  -4.906628528005775e-07,  -2.547137603327592e-09,   2.346123720810653e-10,  -4.982941494234471e-12,  -1.116284361305294e-14,   3.884946434690694e-15,
  -1.032956306555614e-16,   7.232122691035050e-01,  -7.068554218662215e-03,   6.685642608447521e-05,  -4.902053701417451e-07,  -2.561596981429337e-09,   2.345613276759259e-10,
  -4.961724475772065e-12,  -1.187784796947119e-14,   3.884469571417469e-15,  -1.024373477604073e-16,   7.232197939455314e-01,  -7.068719299573484e-03,   6.685467593424860e-05,
  -4.899413640040959e-07,  -2.569932354063283e-09,   2.345314271172507e-10,  -4.949480235264542e-12,  -1.228957619923308e-14,   3.884155841285934e-15,  -1.019419315542244e-16,
   7.232226195809640e-01,  -7.068781281426223e-03,   6.685401825375096e-05,  -4.898422301272066e-07,  -2.573060589463175e-09,   2.345201157334639e-10,  -4.944882503408464e-12,
  -1.244401133153692e-14,   3.884030762419961e-15,  -1.017558824633748e-16,   7.232230879695550e-01,  -7.068791555400835e-03,   6.685390920838965e-05,  -4.898257974296652e-07,
  -2.573579045360380e-09,   2.345182363106277e-10,  -4.944120369049798e-12,  -1.246960204309416e-14,   3.884009645550882e-15,  -1.017250413659992e-16,   9.568821955495903e-01,
  -9.345093698326073e-03,   8.765191123610635e-05,  -5.860085448286696e-07,  -6.833439776295879e-09,   4.444474991534764e-10,  -9.998455192817194e-12,   1.972615791550839e-14,
   6.484734000414042e-15,  -2.101836045006934e-16,   9.568946570856692e-01,  -9.345341642529922e-03,   8.764595752484722e-05,  -5.853757222194971e-07,  -6.854473661533666e-09,
   4.444897101066453e-10,  -9.972466721985575e-12,   1.867533990920173e-14,   6.492119629900713e-15,  -2.092189709690162e-16,   9.569151140831601e-01,  -9.345748487737436e-03,
   8.763617066138108e-05,  -5.843368049845962e-07,  -6.888964015578414e-09,   4.445567534126657e-10,  -9.929782304825345e-12,   1.695384358208959e-14,   6.504046379441737e-15,
  -2.076327546723907e-16,   9.569368196806889e-01,  -9.346179916472965e-03,   8.762576854747135e-05,  -5.832343851474176e-07,  -6.925506332530627e-09,   4.446248340589623e-10,
  -9.884463783520816e-12,   1.513208922504286e-14,   6.516433050985476e-15,  -2.059461410662309e-16,   9.569539014783306e-01,  -9.346519260941303e-03,   8.761756937271897e-05,
  -5.823667409221833e-07,  -6.954225772958446e-09,   4.446762035399870e-10,  -9.848778524225732e-12,   1.370190080265441e-14,   6.525987402342525e-15,  -2.046162513326412e-16,
   9.569637594683966e-01,  -9.346715026219846e-03,   8.761283239882902e-05,  -5.818659931622464e-07,  -6.970784463846354e-09,   4.447049649618103e-10,  -9.828176189171455e-12,
   1.287793215045117e-14,   6.531423762730966e-15,  -2.038477470934877e-16,   9.569674611945368e-01,  -9.346788523465261e-03,   8.761105266020131e-05,  -5.816779549217941e-07,
  -6.976999418777490e-09,   4.447155980361462e-10,  -9.820438366552496e-12,   1.256879247728043e-14,   6.533450510578875e-15,  -2.035589784612535e-16,   9.569680748061419e-01,
  -9.346800705917426e-03,   8.761075759252950e-05,  -5.816467847621634e-07,  -6.978029478338750e-09,   4.447173518070117e-10,  -9.819155635912864e-12,   1.251756233299551e-14,
   6.533785700073135e-15,  -2.035111010557921e-16,   1.278075797398431e+00,  -1.246111418558041e-02,   1.142765929271787e-04,  -5.510490240498352e-07,  -2.254714737824221e-08,
   1.155127609338016e-09,  -2.974579005926270e-11,   2.897106954988315e-13,   1.137836436886948e-14,  -6.138210461812737e-16,   1.278092020359596e+00,  -1.246134360755517e-02,
   1.142569848816455e-04,  -5.493983518315113e-07,  -2.261008282793170e-08,   1.155943264043755e-09,  -2.969882461898688e-11,   2.865726405709586e-13,   1.145718344287439e-14,
  -6.135936937470185e-16,   1.278118650902822e+00,  -1.246171972993777e-02,   1.142247564397121e-04,  -5.466876880724952e-07,  -2.271332823457487e-08,   1.157275519759602e-09,
  -2.962149871121129e-11,   2.814220008163183e-13,   1.158614856181159e-14,  -6.132014296521018e-16,   1.278146905147896e+00,  -1.246211813034084e-02,   1.141905070522169e-04,
  -5.438103561752306e-07,  -2.282277975477215e-08,   1.158679941560762e-09,  -2.953914546259346e-11,   2.759581515156720e-13,   1.172240662354187e-14,  -6.127593906837439e-16,
   1.278169139344170e+00,  -1.246243117059930e-02,   1.141635145982603e-04,  -5.415450815220358e-07,  -2.290884624446007e-08,   1.159778565613615e-09,  -2.947411310317819e-11,
   2.716591009971941e-13,   1.182921917028836e-14,  -6.123928470429768e-16,   1.278181970314101e+00,  -1.246261163061122e-02,   1.141479214970681e-04,  -5.402374277999656e-07,
  -2.295848781573500e-08,   1.160409932402479e-09,  -2.943649367827346e-11,   2.691784567168549e-13,   1.189069294908165e-14,  -6.121738406509751e-16,   1.278186788315937e+00,
  -1.246267935702353e-02,   1.141420632550018e-04,  -5.397463305673272e-07,  -2.297712321662338e-08,   1.160646512172961e-09,  -2.942235060225129e-11,   2.682470310354621e-13,
   1.191374484495588e-14,  -6.120901916401716e-16,   1.278187586960528e+00,  -1.246269058163487e-02,   1.141410920157430e-04,  -5.396649209956138e-07,  -2.298021201062758e-08,
   1.160685702030143e-09,  -2.942000530933195e-11,   2.680926381938892e-13,   1.191756433174076e-14,  -6.120762512729486e-16,   2.069548916824220e-03,  -1.950618891962372e-05,
   1.821152397625612e-07,  -1.582302316055594e-09,   8.275329224656884e-12,   1.454655665280091e-13,  -5.948207531484535e-15,   7.103170240063149e-17,   1.900313762001953e-18,
  -1.079396102649125e-19,   2.069574847225162e-03,  -1.950686370163900e-05,   1.821222342396187e-07,  -1.582093597704199e-09,   8.262725398642288e-12,   1.456690687315814e-13,
  -5.940385092518728e-15,   7.048226819093531e-17,   1.912455492737180e-18,  -1.078098991458768e-19,   2.069617416884221e-03,  -1.950797140075732e-05,   1.821337090575307e-07,
  -1.581750747074057e-09,   8.242046379194906e-12,   1.460019661253749e-13,  -5.927508767197470e-15,   6.958078242647290e-17,   1.932310967270173e-18,  -1.075944196725094e-19,
   2.069662587546385e-03,  -1.950914666708063e-05,   1.821458741999957e-07,  -1.581386677190257e-09,   8.220120952107136e-12,   1.463535868830118e-13,  -5.913799189277332e-15,
   6.862492021346768e-17,   1.953274321914246e-18,  -1.073623404294814e-19,   2.069698137792380e-03,  -1.951007154407456e-05,   1.821554406130683e-07,  -1.581099950894788e-09,
   8.202877575142997e-12,   1.466291497072752e-13,  -5.902975889542030e-15,   6.787315077019655e-17,   1.969696689411281e-18,  -1.071772109123198e-19,   2.069718654813999e-03,
  -1.951060528309910e-05,   1.821609585245397e-07,  -1.580934394990676e-09,   8.192930922558138e-12,   1.467877157463813e-13,  -5.896716038488689e-15,   6.743949132192385e-17,
   1.979143934421715e-18,  -1.070693767687650e-19,   2.069726359212450e-03,  -1.951080570257547e-05,   1.821630299783264e-07,  -1.580872211897715e-09,   8.189196770818998e-12,
   1.468471706869861e-13,  -5.894362851800267e-15,   6.727668610973429e-17,   1.982685718490283e-18,  -1.070286967344750e-19,   2.069727636329558e-03,  -1.951083892471736e-05,
   1.821633733210142e-07,  -1.580861903358367e-09,   8.188577830021739e-12,   1.468570215427857e-13,  -5.893972642971801e-15,   6.724970083570348e-17,   1.983272516541925e-18,
  -1.070219435662696e-19,   1.868689343025356e-02,  -1.761289798340160e-04,   1.644242040145879e-06,  -1.427469381272738e-08,   7.402427922979312e-11,   1.341055344681955e-12,
  -5.446307678962709e-14,   6.527217213870451e-16,   1.724623477581902e-17,  -9.848671384103160e-19,   1.868712754375331e-02,  -1.761350672145310e-04,   1.644304591871338e-06,
  -1.427276967223807e-08,   7.390886863130534e-11,   1.342925919902200e-12,  -5.439206232432673e-14,   6.477080653390622e-16,   1.735749860871947e-17,  -9.837017938502884e-19,
   1.868751188529337e-02,  -1.761450600377597e-04,   1.644407209701337e-06,  -1.426960899340985e-08,   7.371951422935859e-11,   1.345985963671770e-12,  -5.427516418094386e-14,
   6.394818277559999e-16,   1.753945276812591e-17,  -9.817654363455118e-19,   1.868791970998818e-02,  -1.761556623837883e-04,   1.644515998760248e-06,  -1.426625270519385e-08,
   7.351874538972531e-11,   1.349218222813228e-12,  -5.415069730543216e-14,   6.307593033712904e-16,   1.773156419182265e-17,  -9.796792962706189e-19,   1.868824067640146e-02,
  -1.761640058978679e-04,   1.644601546562244e-06,  -1.426360943732208e-08,   7.336084866067350e-11,   1.351751400560083e-12,  -5.405243155048906e-14,   6.238991199881252e-16,
   1.788206473800466e-17,  -9.780147471948006e-19,   1.868842591489337e-02,  -1.761688208672341e-04,   1.644650889918565e-06,  -1.426208321518224e-08,   7.326976729318414e-11,
   1.353209088492638e-12,  -5.399559661820928e-14,   6.199417855548139e-16,   1.796864410403519e-17,  -9.770450093941388e-19,   1.868849547426120e-02,  -1.761706288915398e-04,
   1.644669413557281e-06,  -1.426150996380514e-08,   7.323557364391698e-11,   1.353755660079010e-12,  -5.397423116247029e-14,   6.184561109598031e-16,   1.800110307845872e-17,
  -9.766791471721346e-19,   1.868850700474698e-02,  -1.761709285950966e-04,   1.644672483836908e-06,  -1.426141493181417e-08,   7.322990599569490e-11,   1.353846219694140e-12,
  -5.397068830013933e-14,   6.182098573039466e-16,   1.800648085174320e-17,  -9.766184098123495e-19,   5.225414416849194e-02,  -4.925022215445816e-04,   4.596871437360262e-06,
  -3.984299404369611e-08,   2.029398149787526e-10,   3.910613625426229e-12,  -1.566984435332589e-13,   1.891910617972669e-15,   4.871912816353920e-17,  -2.813551326395011e-18,
   5.225479868171231e-02,  -4.925192115659147e-04,   4.597042835934994e-06,  -3.983738335751068e-08,   2.026077188985791e-10,   3.916038765305994e-12,  -1.564977012993385e-13,
   1.877584790482702e-15,   4.903984203040808e-17,  -2.810330847407517e-18,   5.225587318845203e-02,  -4.925471016945954e-04,   4.597324010258559e-06,  -3.982816702284715e-08,
   2.020628426366255e-10,   3.924914125636871e-12,  -1.561672382880504e-13,   1.854079055972792e-15,   4.956433888315266e-17,  -2.804976872512541e-18,   5.225701334673855e-02,
  -4.925766929097231e-04,   4.597622080562723e-06,  -3.981838034189431e-08,   2.014851132399137e-10,   3.934289608941092e-12,  -1.558153549795612e-13,   1.829154683253067e-15,
   5.011814305371339e-17,  -2.799205041906406e-18,   5.225791067437279e-02,  -4.925999796370883e-04,   4.597856462708815e-06,  -3.981067280121060e-08,   2.010307465154807e-10,
   3.941637795300426e-12,  -1.555375281889001e-13,   1.809551505863077e-15,   5.055201503069830e-17,  -2.794597007850636e-18,   5.225842854653755e-02,  -4.926134181753489e-04,
   4.597991648785946e-06,  -3.980622248015891e-08,   2.007686467925630e-10,   3.945866408171236e-12,  -1.553768318658851e-13,   1.798243148200163e-15,   5.080161942953053e-17,
  -2.791911403720269e-18,   5.225862301397764e-02,  -4.926184643501328e-04,   4.598042397301007e-06,  -3.980455093477644e-08,   2.006702492385987e-10,   3.947451994724218e-12,
  -1.553164214102286e-13,   1.793997700293992e-15,   5.089519874248265e-17,  -2.790897985292556e-18,   5.225865524980759e-02,  -4.926193008189761e-04,   4.598050808791931e-06,
  -3.980427383082037e-08,   2.006539396757998e-10,   3.947714707086917e-12,  -1.553064039598445e-13,   1.793294006902899e-15,   5.091070295992486e-17,  -2.790729735882213e-18,
   1.034744957436456e-01,  -9.752384165254062e-04,   9.099886392683176e-06,  -7.866549721717074e-08,   3.889927732547521e-10,   8.255425904881243e-12,  -3.243895598893543e-13,
   3.962432473213363e-15,   9.795716101571290e-17,  -5.761030703303559e-18,   1.034757913843544e-01,  -9.752719586986314e-04,   9.100214638335514e-06,  -7.865365354510134e-08,
   3.883051473820734e-10,   8.266798894058636e-12,  -3.239854970464490e-13,   3.933089251197364e-15,   9.862328292749254e-17,  -5.754797442689435e-18,   1.034779184214698e-01,
  -9.753270199293664e-04,   9.100753083892717e-06,  -7.863419873704287e-08,   3.871769288747325e-10,   8.285406229623290e-12,  -3.233202675782648e-13,   3.884941732746309e-15,
   9.971273018364799e-17,  -5.744425308626045e-18,   1.034801754173570e-01,  -9.753854391543027e-04,   9.101323841834604e-06,  -7.861354008330821e-08,   3.859806605325343e-10,
   8.305064095188010e-12,  -3.226118388232843e-13,   3.833886569070251e-15,   1.008631458043588e-16,  -5.733230978148418e-18,   1.034819517176274e-01,  -9.754314117723109e-04,
   9.101772615615746e-06,  -7.859727034829981e-08,   3.850398140239648e-10,   8.320472727622113e-12,  -3.220524468246182e-13,   3.793730054008386e-15,   1.017644943468174e-16,
  -5.724284776244569e-18,   1.034829768683288e-01,  -9.754579420179757e-04,   9.102031445155829e-06,  -7.858787625933478e-08,   3.844970832302511e-10,   8.329340421095604e-12,
  -3.217288689253257e-13,   3.770564703586643e-15,   1.022830628831563e-16,  -5.719067287228118e-18,   1.034833618250829e-01,  -9.754679041146958e-04,   9.102128606742357e-06,
  -7.858434783478860e-08,   3.842933297451355e-10,   8.332665617133577e-12,  -3.216072221908506e-13,   3.761867737423769e-15,   1.024774848251073e-16,  -5.717097790820450e-18,
   1.034834256373055e-01,  -9.754695554603484e-04,   9.102144711005550e-06,  -7.858376290306213e-08,   3.842595571862776e-10,   8.333216567466940e-12,  -3.215870501218039e-13,
   3.760426188773960e-15,   1.025096969176891e-16,  -5.716770776818849e-18,   1.735090720532461e-01,  -1.635253655357669e-03,   1.525182000059864e-05,  -1.313378714525138e-07,
   6.205282816486313e-10,   1.511061047099103e-11,  -5.791251075965949e-13,   7.193255334085487e-15,   1.675908409945388e-16,  -1.012938491077457e-17,   1.735112435506542e-01,
  -1.635309649771744e-03,   1.525234288186442e-05,  -1.313161941589179e-07,   6.193003360479583e-10,   1.513128288066634e-11,  -5.784326514094799e-13,   7.141636955031969e-15,
   1.687866279556919e-16,  -1.011937568682719e-17,   1.735148084678646e-01,  -1.635401566938122e-03,   1.525320052093837e-05,  -1.312805864520765e-07,   6.172855459700099e-10,
   1.516510867614512e-11,  -5.772924698284583e-13,   7.056935976226855e-15,   1.707425254358882e-16,  -1.010269409401105e-17,   1.735185911922538e-01,  -1.635499089010784e-03,
   1.525410951634489e-05,  -1.312427755520431e-07,   6.151491704846705e-10,   1.520084922634898e-11,  -5.760780358645799e-13,   6.967115123877995e-15,   1.728081238702683e-16,
  -1.008465500769180e-17,   1.735215682681118e-01,  -1.635575832770608e-03,   1.525482415799210e-05,  -1.312129976828400e-07,   6.134689001253336e-10,   1.522886776771475e-11,
  -5.751189387988114e-13,   6.896464722789926e-15,   1.744266932659997e-16,  -1.007021369648497e-17,   1.735232864175926e-01,  -1.635620120439047e-03,   1.525523629412062e-05,
  -1.311958040941548e-07,   6.124996122373297e-10,   1.524499395147201e-11,  -5.745640927717667e-13,   6.855706790487116e-15,   1.753579680431373e-16,  -1.006178158070361e-17,
   1.735239316037357e-01,  -1.635636750396815e-03,   1.525539099910830e-05,  -1.311893461830386e-07,   6.121357161685687e-10,   1.525104120449456e-11,  -5.743554910916747e-13,
   6.840404782599287e-15,   1.757071354305508e-16,  -1.005859678935617e-17,   1.735240385527811e-01,  -1.635639507023861e-03,   1.525541664070849e-05,  -1.311882756102386e-07,
   6.120753994707477e-10,   1.525204318597893e-11,  -5.743208991191791e-13,   6.837868414454017e-15,   1.757649866693512e-16,  -1.005806789207807e-17,   2.641422498613721e-01,
  -2.489317294625231e-03,   2.320325969382314e-05,  -1.987052000862262e-07,   8.754769750736420e-10,   2.578520227812686e-11,  -9.596352395194894e-13,   1.219846597013971e-14,
   2.613388151791616e-16,  -1.644666324219816e-17,   2.641455533355462e-01,  -2.489401995516249e-03,   2.320399568826779e-05,  -1.986682105951973e-07,   8.734414467078355e-10,
   2.582031735670035e-11,  -9.585526467656912e-13,   1.211459478173357e-14,   2.633381435465323e-16,  -1.643267829024167e-17,   2.641509765970625e-01,  -2.489541034258721e-03,
   2.320520269022481e-05,  -1.986074507964806e-07,   8.701014894892963e-10,   2.587778354080708e-11,  -9.567697039265020e-13,   1.197696157888330e-14,   2.666087818364360e-16,
  -1.640930253858123e-17,   2.641567311972416e-01,  -2.489688549505375e-03,   2.320648171154600e-05,  -1.985429317228878e-07,   8.665598411169417e-10,   2.593851381188193e-11,
  -9.548701466851169e-13,   1.183099760497370e-14,   2.700634361316179e-16,  -1.638393351653134e-17,   2.641612601705789e-01,  -2.489804633476631e-03,   2.320748707690220e-05,
  -1.984921200322524e-07,   8.637742174141673e-10,   2.598613094758471e-11,  -9.533696121600562e-13,   1.171617850862035e-14,   2.727708640510959e-16,  -1.636355963709296e-17,
   2.641638739588008e-01,  -2.489871623274087e-03,   2.320806679955524e-05,  -1.984627816724635e-07,   8.621672510268678e-10,   2.601354043152687e-11,  -9.525013951495272e-13,
   1.164993655403209e-14,   2.743288017840454e-16,  -1.635163817229315e-17,   2.641648554677765e-01,  -2.489896777752339e-03,   2.320828439794513e-05,  -1.984517621950440e-07,
   8.615639462402020e-10,   2.602381949168968e-11,  -9.521749502518125e-13,   1.162506629932889e-14,   2.749129586591599e-16,  -1.634713072307661e-17,   2.641650181672288e-01,
  -2.489900947421959e-03,   2.320832046307499e-05,  -1.984499354201802e-07,   8.614639465433914e-10,   2.602552268230215e-11,  -9.521208151532683e-13,   1.162094392387917e-14,
   2.750097454278575e-16,  -1.634638192401957e-17,   3.780911556253206e-01,  -3.562950575344571e-03,   3.318158909391644e-05,  -2.818909506873495e-07,   1.110454720997816e-09,
   4.270073888057905e-11,  -1.538452515440962e-12,   2.018955670830817e-14,   3.835782618136625e-16,  -2.566452839537847e-17,   3.780958794784174e-01,  -3.563070704295920e-03,
   3.318251876017119e-05,  -2.818296945656121e-07,   1.107189773547576e-09,   4.275898168948124e-11,  -1.536856974667837e-12,   2.005853696647495e-14,   3.868303205804331e-16,
  -2.564799030956313e-17,   3.781036345406869e-01,  -3.563267896401669e-03,   3.318404294899823e-05,  -2.817290736891498e-07,   1.101832330982126e-09,   4.285431400023867e-11,
  -1.534228372843663e-12,   1.984351318986244e-14,   3.921512322279615e-16,  -2.562016393444761e-17,   3.781118633873072e-01,  -3.563477106621763e-03,   3.318565750189282e-05,
  -2.816222270824965e-07,   1.096151071857225e-09,   4.295508483780354e-11,  -1.531426661638938e-12,   1.961544786302217e-14,   3.977728354339015e-16,  -2.558972085495098e-17,
   3.781183396241160e-01,  -3.563641737444587e-03,   3.318692618812557e-05,  -2.815380803865627e-07,   1.091682359953679e-09,   4.303411397381453e-11,  -1.529212627532272e-12,
   1.943602658550403e-14,   4.021794687962600e-16,  -2.556509966958507e-17,   3.781220772235780e-01,  -3.563736741605399e-03,   3.318765758015118e-05,  -2.814894945329101e-07,
   1.089104370586641e-09,   4.307961180194118e-11,  -1.527931235695650e-12,   1.933250640018636e-14,   4.047155665599959e-16,  -2.555062537643725e-17,   3.781234807362494e-01,
  -3.563772415193429e-03,   3.318793207553402e-05,  -2.814712456910425e-07,   1.088136497615823e-09,   4.309667562968036e-11,  -1.527449375184195e-12,   1.929363875106021e-14,
   4.056665624499660e-16,  -2.554514012915020e-17,   3.781237133889285e-01,  -3.563778328526400e-03,   3.318797756918160e-05,  -2.814682204538395e-07,   1.087976068723333e-09,
   4.309950309247534e-11,  -1.527369463784513e-12,   1.928719615773839e-14,   4.058241332476916e-16,  -2.554422823448958e-17,   5.196208567130240e-01,  -4.896181085066224e-03,
   4.553913931361340e-05,  -3.822624243237286e-07,   1.233237389924461e-09,   7.073802497983806e-11,  -2.464681004720546e-12,   3.382882723426083e-14,   5.359637714133042e-16,
  -3.962662462175934e-17,   5.196273393244952e-01,  -4.896343922608338e-03,   4.554016266311495e-05,  -3.821609356552688e-07,   1.228003091131011e-09,   7.083588343590382e-11,
  -2.462435238261903e-12,   3.362618615884386e-14,   5.412980655356019e-16,  -3.961393935080203e-17,   5.196379816812111e-01,  -4.896611215287726e-03,   4.554183943529219e-05,
  -3.819942262693732e-07,   1.219413665532255e-09,   7.099609649082522e-11,  -2.458733241254514e-12,   3.329357330436853e-14,   5.500281816304755e-16,  -3.959201356703027e-17,
   5.196492741811224e-01,  -4.896894790652859e-03,   4.554361424288666e-05,  -3.818171999993656e-07,   1.210304421916505e-09,   7.116550048041051e-11,  -2.454784510196466e-12,
   3.294072269456481e-14,   5.592548023549794e-16,  -3.956725558743446e-17,   5.196581615368884e-01,  -4.897117934935312e-03,   4.554500785747161e-05,  -3.816777820421942e-07,
   1.203138885259664e-09,   7.129839197334623e-11,  -2.451661937811959e-12,   3.266308514838860e-14,   5.664896055961226e-16,  -3.954669239851093e-17,   5.196632906433256e-01,
  -4.897246703425583e-03,   4.554581086999523e-05,  -3.815972822529453e-07,   1.199004914568310e-09,   7.137491377121243e-11,  -2.449853878513784e-12,   3.250287880914560e-14,
   5.706542850196903e-16,  -3.953439346523481e-17,   5.196652166812826e-01,  -4.897295054922616e-03,   4.554611216923292e-05,  -3.815670464253566e-07,   1.197452832591795e-09,
   7.140361586876522e-11,  -2.449173808758935e-12,   3.244272428678139e-14,   5.722161466609888e-16,  -3.952969362960397e-17,   5.196655359500376e-01,  -4.897303069751276e-03,
   4.554616210123677e-05,  -3.815620340162554e-07,   1.197195566784167e-09,   7.140837193261157e-11,  -2.449061018119210e-12,   3.243275305541513e-14,   5.724749411664130e-16,
  -3.952891026935902e-17,   6.959200866663294e-01,  -6.556387580623851e-03,   6.085741004273707e-05,  -5.010366988785023e-07,   1.020518480042473e-09,   1.212568810811073e-10,
  -4.096448963500523e-12,   6.009041030447709e-14,   6.969552143851816e-16,  -6.232760170552319e-17,   6.959287487750766e-01,  -6.556600869127259e-03,   6.085823208207860e-05,
  -5.008626730611364e-07,   1.011809682477323e-09,   1.214313494298356e-10,  -4.093481348439506e-12,   5.977073664551301e-14,   7.061748128282986e-16,  -6.234297984939144e-17,
   6.959429691055478e-01,  -6.556950962693901e-03,   6.085957622959369e-05,  -5.005768041837167e-07,   9.975174610082084e-10,   1.217170767725908e-10,  -4.088583207441613e-12,
   5.924589770008275e-14,   7.212698755031883e-16,  -6.236636203777893e-17,   6.959580580797582e-01,  -6.557322365566032e-03,   6.086099518669648e-05,  -5.002732345874905e-07,
   9.823586909064502e-10,   1.220193168224267e-10,  -4.083350193388827e-12,   5.868894848298823e-14,   7.372319335765232e-16,  -6.238864382642854e-17,   6.959699332572054e-01,
  -6.557614608368066e-03,   6.086210663845964e-05,  -5.000341498082247e-07,   9.704332969231488e-10,   1.222565016226304e-10,  -4.079205980685283e-12,   5.825058999778725e-14,
   7.497543083799071e-16,  -6.240435227583235e-17,   6.959767866844924e-01,  -6.557783246066983e-03,   6.086274596497090e-05,  -4.998960996952206e-07,   9.635527836097318e-10,
   1.223931131390031e-10,  -4.076803947904907e-12,   5.799759107589684e-14,   7.569652263864427e-16,  -6.241268648663853e-17,   6.959793602202818e-01,  -6.557846567166068e-03,
   6.086298563890857e-05,  -4.998442473596833e-07,   9.609694355777425e-10,   1.224443606211236e-10,  -4.075900010852552e-12,   5.790258499719804e-14,   7.596699737511613e-16,
  -6.241567794476026e-17,   6.959797868209762e-01,  -6.557857063331784e-03,   6.086302534721888e-05,  -4.998356513996821e-07,   9.605412273100640e-10,   1.224528529079108e-10,
  -4.075750067531895e-12,   5.788683625239604e-14,   7.601181647636761e-16,  -6.241616653842892e-17,   9.208578774455972e-01,  -8.673272310290168e-03,   8.021624427890404e-05,
  -6.367444882519239e-07,  -2.058351283149402e-10,   2.281424773017403e-10,  -7.559798429474831e-12,   1.236964289073473e-13,   6.687655747091902e-16,  -1.037354076354695e-16,
   9.208692922679796e-01,  -8.673542992196612e-03,   8.021597732399481e-05,  -6.364167838471591e-07,  -2.219356903266872e-10,   2.285035735311481e-10,  -7.556757543131213e-12,
   1.231609580945766e-13,   6.869451272365941e-16,  -1.038886758222039e-16,   9.208880315047844e-01,  -8.673987258537855e-03,   8.021552914986081e-05,  -6.358784361724123e-07,
  -2.483624780965792e-10,   2.290952122770713e-10,  -7.551713408694831e-12,   1.222813544114769e-13,   7.167323782937095e-16,  -1.041368625427117e-16,   9.209079152264462e-01,
  -8.674458521026654e-03,   8.021504011600613e-05,  -6.353067083837582e-07,  -2.763966520176966e-10,   2.297214106997991e-10,  -7.546290573921474e-12,   1.213472976794316e-13,
   7.482607193146885e-16,  -1.043955528132618e-16,   9.209235637782586e-01,  -8.674829306802589e-03,   8.021464548057406e-05,  -6.348563946185387e-07,  -2.984548157888529e-10,
   2.302130905847471e-10,  -7.541971716738618e-12,   1.206116675903216e-13,   7.730168991231043e-16,  -1.045957759574678e-16,   9.209325948466827e-01,  -8.675043254311713e-03,
   8.021441381561481e-05,  -6.345963652052770e-07,  -3.111830466056042e-10,   2.304963909060030e-10,  -7.539458777038637e-12,   1.201869134198593e-13,   7.872813622603836e-16,
  -1.047099797699356e-16,   9.209359860994829e-01,  -8.675123586126363e-03,   8.021432608354900e-05,  -6.344986942766825e-07,  -3.159622507474133e-10,   2.306026864544124e-10,
  -7.538511282120834e-12,   1.200273749687116e-13,   7.926334925486084e-16,  -1.047526096004357e-16,   9.209365482480071e-01,  -8.675136901873381e-03,   8.021431150168900e-05,
  -6.344825024826181e-07,  -3.167544525269334e-10,   2.306203018972561e-10,  -7.538354017656146e-12,   1.200009271327040e-13,   7.935204568487553e-16,  -1.047596626640901e-16,
   1.230011245073207e+00,  -1.157796493653862e-02,   1.061450325224634e-04,  -7.625006664885182e-07,  -5.787950041897357e-09,   5.627318569043622e-10,  -1.917968386378265e-11,
   3.939482477902652e-13,  -2.252157962920443e-15,  -1.782885606978316e-16,   1.230026339881028e+00,  -1.157828759913779e-02,   1.061398579805556e-04,  -7.616900598534936e-07,
  -5.828983921987765e-09,   5.638939808995516e-10,  -1.918761644238194e-11,   3.930028360431224e-13,  -2.201983247919544e-15,  -1.794866692880478e-16,   1.230051119882155e+00,
  -1.157881704960980e-02,   1.061313377797362e-04,  -7.603581288579581e-07,  -5.896359363207878e-09,   5.657997327283809e-10,  -1.920049449785898e-11,   3.914463946949206e-13,
  -2.119603931141810e-15,  -1.814480662073885e-16,   1.230077412604076e+00,  -1.157937849424330e-02,   1.061222627276593e-04,  -7.589432323246127e-07,  -5.967865673798903e-09,
   5.678190740242240e-10,  -1.921396263307297e-11,   3.897889282475321e-13,  -2.032181022793734e-15,  -1.835217767541915e-16,   1.230098104552547e+00,  -1.157982010544999e-02,
   1.061150956606564e-04,  -7.578285330762742e-07,  -6.024152830591969e-09,   5.694062686015965e-10,  -1.922441986183073e-11,   3.884801857237638e-13,  -1.963370526807658e-15,
  -1.851483651326848e-16,   1.230110046055046e+00,  -1.158007486818183e-02,   1.061109494026381e-04,  -7.571847503577334e-07,  -6.056641753224305e-09,   5.703214515070709e-10,
  -1.923039790336188e-11,   3.877231609916192e-13,  -1.923655532692991e-15,  -1.860849185686244e-16,   1.230114530165298e+00,  -1.158017051526462e-02,   1.061093905506404e-04,
  -7.569429151273847e-07,  -6.068842514230861e-09,   5.706649569959286e-10,  -1.923263193784867e-11,   3.874385652028367e-13,  -1.908741590682447e-15,  -1.864361906041608e-16,
   1.230115273468503e+00,  -1.158018636914276e-02,   1.061091320488534e-04,  -7.569028228128282e-07,  -6.070865009623606e-09,   5.707218897776849e-10,  -1.923300169236437e-11,
   3.873913722154864e-13,  -1.906269361937328e-15,  -1.864943971656391e-16,   1.994321160289576e-03,  -1.812279219240860e-05,   1.639949815666796e-07,  -1.433619697338957e-09,
   9.940470032800269e-12,   3.041075321920034e-14,  -3.581952524021477e-15,   8.500984357248456e-17,  -5.800095268323229e-19,  -3.374850483820293e-20,   1.994344514960358e-03,
  -1.812340407545769e-05,   1.640034257036869e-07,  -1.433574302386719e-09,   9.932799056779727e-12,   3.066194779459663e-14,  -3.584072161899091e-15,   8.483191445415713e-17,
  -5.707769865797931e-19,  -3.393707557783746e-20,   1.994382856294919e-03,  -1.812440856603855e-05,   1.640172833797356e-07,  -1.433499522045535e-09,   9.920202739384585e-12,
   3.107393677335430e-14,  -3.587525335122240e-15,   8.453912551469599e-17,  -5.556262209776047e-19,  -3.424548461466703e-20,   1.994423540586644e-03,  -1.812547438847253e-05,
   1.640319810000275e-07,  -1.433419825013616e-09,   9.906832788863753e-12,   3.151056136984306e-14,  -3.591153337459303e-15,   8.422751910145550e-17,  -5.395582726870420e-19,
  -3.457115204657259e-20,   1.994455560186722e-03,  -1.812631318202714e-05,   1.640435434372490e-07,  -1.433356850293341e-09,   9.896307483288674e-12,   3.185380462320210e-14,
  -3.593982478164131e-15,   8.398160831237641e-17,  -5.269187233467660e-19,  -3.482631015375473e-20,   1.994474039664190e-03,  -1.812679726044580e-05,   1.640502144747628e-07,
  -1.433320405098192e-09,   9.890231893107546e-12,   3.205174344305535e-14,  -3.595604764474071e-15,   8.383941846430341e-17,  -5.196266292262375e-19,  -3.497310801531364e-20,
   1.994480978956020e-03,  -1.812697903561868e-05,   1.640527191619956e-07,  -1.433306700433991e-09,   9.887950216689988e-12,   3.212604238630961e-14,  -3.596211971216450e-15,
   8.378597381705613e-17,  -5.168888392782135e-19,  -3.502814529905008e-20,   1.994482129246359e-03,  -1.812700916739810e-05,   1.640531343310965e-07,  -1.433304427680653e-09,
   9.887571983948032e-12,   3.213835696642923e-14,  -3.596312520089909e-15,   8.377711191596346e-17,  -5.164350359596882e-19,  -3.503726393794684e-20,   1.800763107990915e-02,
  -1.636384831166839e-04,   1.480725954403238e-06,  -1.293979006258836e-08,   8.945641234036320e-11,   2.879326991562838e-13,  -3.278222095819424e-14,   7.776822532276622e-16,
  -5.353576529841582e-18,  -3.066898710159477e-19,   1.800784195088479e-02,  -1.636440058783353e-04,   1.480801938336887e-06,  -1.293936093390279e-08,   8.938620494436886e-11,
   2.902308294001895e-13,  -3.280180570577302e-14,   7.760649422466900e-16,  -5.269332429730568e-18,  -3.084176215651507e-19,   1.800818813748103e-02,  -1.636530722487259e-04,
   1.480926634865083e-06,  -1.293865409675150e-08,   8.927091885129315e-11,   2.940000590154729e-13,  -3.283371492105205e-14,   7.734035466312463e-16,  -5.131085006322090e-18,
  -3.112434379975005e-19,   1.800855547876430e-02,  -1.636626921823315e-04,   1.481058888530789e-06,  -1.293790089202313e-08,   8.914855179313215e-11,   2.979947073158714e-13,
  -3.286724382101973e-14,   7.705710351588037e-16,  -4.984466684358856e-18,  -3.142274751359635e-19,   1.800884458592044e-02,  -1.636702629855868e-04,   1.481162930144109e-06,
  -1.293730580361013e-08,   8.905221976247573e-11,   3.011350385136080e-13,  -3.289339292850513e-14,   7.683356493484726e-16,  -4.869130831625525e-18,  -3.165655119874156e-19,
   1.800901143837384e-02,  -1.636746321899551e-04,   1.481222957468256e-06,  -1.293696144007069e-08,   8.899661328747944e-11,   3.029459889814109e-13,  -3.290838858487522e-14,
   7.670430910466274e-16,  -4.802589969369810e-18,  -3.179106602441037e-19,   1.800907409370761e-02,  -1.636762728593797e-04,   1.481245495088212e-06,  -1.293683195310362e-08,
   8.897573035922425e-11,   3.036257547895258e-13,  -3.291400155426182e-14,   7.665572557092755e-16,  -4.777607348167829e-18,  -3.184149866191526e-19,   1.800908447975652e-02,
  -1.636765448232793e-04,   1.481249230850536e-06,  -1.293681047955308e-08,   8.897226860200341e-11,   3.037384217641995e-13,  -3.291493103219787e-14,   7.664766969361770e-16,
  -4.773466339943186e-18,  -3.184985442401824e-19,   5.035474137122428e-02,  -4.575797989791631e-04,   4.140211358342280e-06,  -3.615446804189598e-08,   2.484018691180187e-10,
   8.827026515385853e-13,  -9.422710538463566e-14,   2.233607048209321e-15,  -1.565779865395411e-17,  -8.687835281585918e-19,   5.035533097791538e-02,  -4.575952294728240e-04,
   4.140422311044235e-06,  -3.615315622206729e-08,   2.482000563278207e-10,   8.893041680390402e-13,  -9.428450370619816e-14,   2.229023313165335e-15,  -1.541710914097419e-17,
  -8.737620087853436e-19,   5.035629893426522e-02,  -4.576205607084262e-04,   4.140768499297319e-06,  -3.615099589806793e-08,   2.478686620604586e-10,   9.001316392499721e-13,
  -9.437803998206958e-14,   2.221480162414420e-15,  -1.502212155772248e-17,  -8.819049371492983e-19,   5.035732604004114e-02,  -4.576474385393998e-04,   4.141135662220062e-06,
  -3.614869444633664e-08,   2.475169109546388e-10,   9.116068290953027e-13,  -9.447634846052290e-14,   2.213451611697323e-15,  -1.460320665291484e-17,  -8.905043305959651e-19,
   5.035813439887712e-02,  -4.576685911216438e-04,   4.141424498574444e-06,  -3.614687654888892e-08,   2.472399973316365e-10,   9.206280046047203e-13,  -9.455303681422945e-14,
   2.207115275773229e-15,  -1.427366359272809e-17,  -8.972424685307665e-19,   5.035860092706191e-02,  -4.576807985250550e-04,   4.141591142452964e-06,  -3.614582474341318e-08,
   2.470801516835072e-10,   9.258303438150440e-13,  -9.459702227188730e-14,   2.203451323393616e-15,  -1.408353676804429e-17,  -9.011192929075577e-19,   5.035877611463958e-02,
  -4.576853824951229e-04,   4.141653709580667e-06,  -3.614542927715750e-08,   2.470201217617328e-10,   9.277831252391139e-13,  -9.461348767680630e-14,   2.202074127271562e-15,
  -1.401215347769762e-17,  -9.025728311417024e-19,   5.035880515457285e-02,  -4.576861423521234e-04,   4.141664080486713e-06,  -3.614536369644220e-08,   2.470101706114835e-10,
   9.281067871995443e-13,  -9.461621433289132e-14,   2.201845766362749e-15,  -1.400032126972845e-17,  -9.028136572966305e-19,   9.971332438748644e-02,  -9.060994576504319e-04,
   8.197435748006494e-06,  -7.150181047967601e-08,   4.863621854479455e-10,   1.994216411691437e-12,  -1.947417722509657e-13,   4.612050597278153e-15,  -3.324997699675325e-17,
  -1.754744131644596e-18,   9.971449177312917e-02,  -9.061299728940938e-04,   8.197848661364131e-06,  -7.149885758543773e-08,   4.859450500046332e-10,   2.007850693972207e-12,
  -1.948640372421901e-13,   4.602785028956567e-15,  -3.275708020965810e-17,  -1.765078169890428e-18,   9.971640826774250e-02,  -9.061800676686558e-04,   8.198526267605120e-06,
  -7.149399596984151e-08,   4.852600714479162e-10,   2.030213383451384e-12,  -1.950633370141591e-13,   4.587536294536346e-15,  -3.194817739607463e-17,  -1.781982071239985e-18,
   9.971844187392874e-02,  -9.062332208212469e-04,   8.199244909683759e-06,  -7.148881845611025e-08,   4.845330084485305e-10,   2.053914438966285e-12,  -1.952728827337610e-13,
   4.571304953770140e-15,  -3.109023773415707e-17,  -1.799835301827499e-18,   9.972004237414606e-02,  -9.062750517067583e-04,   8.199810230947538e-06,  -7.148473000426556e-08,
   4.839606275679168e-10,   2.072547358389957e-12,  -1.954364016501661e-13,   4.558493791136785e-15,  -3.041530625872432e-17,  -1.813825646410028e-18,   9.972096607073506e-02,
  -9.062991927574251e-04,   8.200136387140938e-06,  -7.148236498154051e-08,   4.836302241357999e-10,   2.083292777811266e-12,  -1.955302126789691e-13,   4.551085414602432e-15,
  -3.002590045762266e-17,  -1.821875579061691e-18,   9.972131293112972e-02,  -9.063082578917479e-04,   8.200258842798823e-06,  -7.148147585331201e-08,   4.835061409346115e-10,
   2.087326275690608e-12,  -1.955653340224035e-13,   4.548300701263452e-15,  -2.987969574329752e-17,  -1.824893838190139e-18,   9.972137042837066e-02,  -9.063097605638100e-04,
   8.200279140562090e-06,  -7.148132841279512e-08,   4.834855716604855e-10,   2.087994805797020e-12,  -1.955711503156445e-13,   4.547838947850625e-15,  -2.985546133326762e-17,
  -1.825393916661927e-18,   1.672023677092827e-01,  -1.519356096812251e-03,   1.374306804907198e-05,  -1.196713018693263e-07,   8.019635959262987e-10,   3.951476835428720e-12,
  -3.467636373182982e-13,   8.206510249533978e-15,  -6.152025328185056e-17,  -3.022724197209352e-18,   1.672043248173015e-01,  -1.519407166498484e-03,   1.374374859062483e-05,
  -1.196654739647099e-07,   8.012207182326355e-10,   3.975745250300823e-12,  -3.469907928874961e-13,   8.190529773421053e-15,  -6.065350458850342e-17,  -3.041256479567220e-18,
   1.672075377962749e-01,  -1.519491003809992e-03,   1.374486535045776e-05,  -1.196558816612688e-07,   8.000008233346960e-10,   4.015550944050037e-12,  -3.473612116037292e-13,
   8.164227414750555e-15,  -5.923099736256619e-17,  -3.071573995901723e-18,   1.672109471096273e-01,  -1.519579959167683e-03,   1.374604969466355e-05,  -1.196456697258725e-07,
   7.987059593099516e-10,   4.057740435541332e-12,  -3.477508657133642e-13,   8.136226621564500e-15,  -5.772216263687861e-17,  -3.103598700090237e-18,   1.672136303254364e-01,
  -1.519649965681530e-03,   1.374698132768724e-05,  -1.196376084513787e-07,   7.976865622136469e-10,   4.090909386614894e-12,  -3.480550725046748e-13,   8.114123440450894e-15,
  -5.653511201478722e-17,  -3.128697549762604e-18,   1.672151788891145e-01,  -1.519690367078953e-03,   1.374751881007396e-05,  -1.196329463455401e-07,   7.970981155569800e-10,
   4.110038026893868e-12,  -3.482296530682324e-13,   8.101340698183583e-15,  -5.585020900236089e-17,  -3.143140553618815e-18,   1.672157603953461e-01,  -1.519705538067204e-03,
   1.374772060579351e-05,  -1.196311938292616e-07,   7.968771229770081e-10,   4.117218408851856e-12,  -3.482950240062153e-13,   8.096535637114884e-15,  -5.559305301455860e-17,
  -3.148556095783065e-18,   1.672158567886004e-01,  -1.519708052868366e-03,   1.374775405451496e-05,  -1.196309032270659e-07,   7.968404889758907e-10,   4.118408522049517e-12,
  -3.483058503736475e-13,   8.095738865103836e-15,  -5.555042741953400e-17,  -3.149453379932442e-18,   2.545415096180635e-01,  -2.312959249504391e-03,   2.091615254169154e-05,
  -1.816962940459157e-07,   1.191423464532397e-09,   7.339897066177953e-12,  -5.722962871434448e-13,   1.354488774801492e-14,  -1.069575815630991e-16,  -4.762184984245564e-18,
   2.545444881718665e-01,  -2.313036781493796e-03,   2.091716288126427e-05,  -1.816855108640211e-07,   1.190197161269523e-09,   7.379970611638395e-12,  -5.726932749157699e-13,
   1.351966457142557e-14,  -1.055501776624564e-16,  -4.793117880897225e-18,   2.545493780529395e-01,  -2.313164059399733e-03,   2.091882075896637e-05,  -1.816677674761306e-07,
   1.188183388983672e-09,   7.445702807136990e-12,  -5.733409441142797e-13,   1.347814338404472e-14,  -1.032401858567734e-16,  -4.843729721104817e-18,   2.545545667345886e-01,
  -2.313299106464323e-03,   2.092057886466469e-05,  -1.816488846114320e-07,   1.186045812976133e-09,   7.515374843636731e-12,  -5.740226670686856e-13,   1.343393260962628e-14,
  -1.007897883124471e-16,  -4.897202129039086e-18,   2.545586503555762e-01,  -2.313405385855776e-03,   2.092196175669531e-05,  -1.816339833513470e-07,   1.184362947122840e-09,
   7.570152765822898e-12,  -5.745552021365010e-13,   1.339902756947726e-14,  -9.886181995972861e-17,  -4.939117967904998e-18,   2.545610071336822e-01,  -2.313466720422984e-03,
   2.092275955148612e-05,  -1.816253673780555e-07,   1.183391499801729e-09,   7.601744360645220e-12,  -5.748609415805004e-13,   1.337883881222237e-14,  -9.774935951384798e-17,
  -4.963241313726031e-18,   2.545618921349657e-01,  -2.313489751907911e-03,   2.092305907479743e-05,  -1.816221289400742e-07,   1.183026667827623e-09,   7.613603191248692e-12,
  -5.749754479668596e-13,   1.337124935625093e-14,  -9.733165935272386e-17,  -4.972287178047783e-18,   2.545620388370007e-01,  -2.313493569692749e-03,   2.092310872208934e-05,
  -1.816215919615183e-07,   1.182966189395344e-09,   7.615568744327517e-12,  -5.749944131179721e-13,   1.336999085363311e-14,  -9.726242168447757e-17,  -4.973785989778099e-18,
   3.643493318504556e-01,  -3.310673691230689e-03,   2.992774965471697e-05,  -2.590900536107893e-07,   1.645101788194641e-09,   1.323854100603699e-11,  -9.117539243001166e-13,
   2.161940963480220e-14,  -1.827482943169331e-16,  -7.102426566384573e-18,   3.643535935913488e-01,  -3.310784233912623e-03,   2.992914323858541e-05,  -2.590706743732079e-07,
   1.643147505796073e-09,   1.330254404938283e-11,  -9.124365419439258e-13,   2.158168304454079e-14,  -1.805523035443434e-16,  -7.152594550320735e-18,   3.643605900705227e-01,
  -3.310965701514760e-03,   2.993142982351452e-05,  -2.590387946392443e-07,   1.639938205936637e-09,   1.340753304902760e-11,  -9.135508471382010e-13,   2.151956491798216e-14,
  -1.769476216280617e-16,  -7.234696105524829e-18,   3.643680140683158e-01,  -3.311158244364423e-03,   2.993385442402241e-05,  -2.590048786966465e-07,   1.636531497560701e-09,
   1.351882234909967e-11,  -9.147246194392224e-13,   2.145340347865009e-14,  -1.731233358877229e-16,  -7.321461998486909e-18,   3.643738569330252e-01,  -3.311309770579897e-03,
   2.993576140764480e-05,  -2.589781222113317e-07,   1.633849395664516e-09,   1.360632624855124e-11,  -9.156421643941822e-13,   2.140115398660741e-14,  -1.701140299496363e-16,
  -7.389493267559173e-18,   3.643772290203783e-01,  -3.311397216906316e-03,   2.993686148819769e-05,  -2.589626546937159e-07,   1.632301100942338e-09,   1.365679378922127e-11,
  -9.161692044317561e-13,   2.137092772943680e-14,  -1.683774788336394e-16,  -7.428653522491682e-18,   3.643784952832702e-01,  -3.311430053414545e-03,   2.993727448921872e-05,
  -2.589568416069674e-07,   1.631719625198384e-09,   1.367573867082162e-11,  -9.163666420084277e-13,   2.135956386662607e-14,  -1.677254211344978e-16,  -7.443339308450474e-18,
   3.643787051850265e-01,  -3.311435496511687e-03,   2.993734294529266e-05,  -2.589558777472211e-07,   1.631623233282287e-09,   1.367887872984188e-11,  -9.163993452555994e-13,
   2.135767942649911e-14,  -1.676173350785152e-16,  -7.445772670252325e-18,   5.007362977342317e-01,  -4.549792796437503e-03,   4.110758898875199e-05,  -3.540841531422938e-07,
   2.138469547896467e-09,   2.380386379174060e-11,  -1.446010883015853e-12,   3.447961261704519e-14,  -3.188432475268968e-16,  -1.020160250787330e-17,   5.007421512823453e-01,
  -4.549943839874628e-03,   4.110939733264574e-05,  -3.540494167104660e-07,   2.135368723287666e-09,   2.390602998855100e-11,  -1.447211019017579e-12,   3.442516104977801e-14,
  -3.154544172777943e-16,  -1.028345854638264e-17,   5.007517610123868e-01,  -4.550191791208962e-03,   4.111236410379373e-05,  -3.539922865152882e-07,   2.130276403515374e-09,
   2.407363330712036e-11,  -1.449171475164500e-12,   3.433546974705355e-14,  -3.098908258588868e-16,  -1.041745976208921e-17,   5.007619579279624e-01,  -4.550454871890469e-03,
   4.111550946993563e-05,  -3.539315247060298e-07,   2.124870601071235e-09,   2.425131125874948e-11,  -1.451238403861007e-12,   3.423989306096775e-14,  -3.039870903547386e-16,
  -1.055912979142234e-17,   5.007699831345168e-01,  -4.550661907005359e-03,   4.111798300135910e-05,  -3.538836018982994e-07,   2.120614433267544e-09,   2.439102708099814e-11,
  -1.452855481858656e-12,   3.416437943185737e-14,  -2.993406106681544e-16,  -1.067025081946438e-17,   5.007746147104397e-01,  -4.550781386699382e-03,   4.111940976764935e-05,
  -3.538559034611403e-07,   2.118157407082732e-09,   2.447161255905711e-11,  -1.453784878668412e-12,   3.412068128041579e-14,  -2.966589637729826e-16,  -1.073423077589122e-17,
   5.007763539269154e-01,  -4.550826251695663e-03,   4.111994538946776e-05,  -3.538454946284003e-07,   2.117234635654986e-09,   2.450186426484584e-11,  -1.454133148616207e-12,
   3.410424995614454e-14,  -2.956519662945657e-16,  -1.075822747603489e-17,   5.007766422276617e-01,  -4.550833688667874e-03,   4.112003416890072e-05,  -3.538437688042585e-07,
   2.117081666037386e-09,   2.450687844607172e-11,  -1.454190840950459e-12,   3.410152505659936e-14,  -2.954850414264698e-16,  -1.076220377315687e-17,   6.706307708640220e-01,
  -6.093147931506379e-03,   5.500728770411805e-05,  -4.700543390089160e-07,   2.604453606192904e-09,   4.397010928888700e-11,  -2.361999867060246e-12,   5.707799981469555e-14,
  -5.965304139499744e-16,  -1.407088439338740e-17,   6.706386032188574e-01,  -6.093348381668425e-03,   5.500948276980292e-05,  -4.699903375662946e-07,   2.599384893355063e-09,
   4.413946494418411e-11,  -2.364266325724468e-12,   5.700216863779606e-14,  -5.912091052591636e-16,  -1.421088628580095e-17,   6.706514615184650e-01,  -6.093677432977082e-03,
   5.501308318892391e-05,  -4.698850951541267e-07,   2.591060342698866e-09,   4.441732344519140e-11,  -2.367971743231962e-12,   5.687716516492406e-14,  -5.824705292891412e-16,
  -1.444018119107076e-17,   6.706651054691255e-01,  -6.094026554537956e-03,   5.501689924803937e-05,  -4.697731888609519e-07,   2.582222691215936e-09,   4.471192628196477e-11,
  -2.371882623397051e-12,   5.674382891605617e-14,  -5.731945071701214e-16,  -1.468274396505903e-17,   6.706758435477862e-01,  -6.094301295245523e-03,   5.501989941857936e-05,
  -4.696849472531584e-07,   2.575264049406058e-09,   4.494361578826363e-11,  -2.374945404364105e-12,   5.663838815734531e-14,  -5.658915919557244e-16,  -1.487310726384353e-17,
   6.706820407902170e-01,  -6.094459845537741e-03,   5.502162963753106e-05,  -4.696339528684879e-07,   2.571246736188503e-09,   4.507726224678690e-11,  -2.376706940352522e-12,
   5.657733432016858e-14,  -5.616758976831381e-16,  -1.498275478560886e-17,   6.706843679328619e-01,  -6.094519381246961e-03,   5.502227911789723e-05,  -4.696147910394166e-07,
   2.569737941316933e-09,   4.512743531132570e-11,  -2.377367270087641e-12,   5.655436986765980e-14,  -5.600926683015422e-16,  -1.502388785551551e-17,   6.706847536909352e-01,
  -6.094529250063680e-03,   5.502238676621612e-05,  -4.696116140098975e-07,   2.569487823590543e-09,   4.513575155454696e-11,  -2.377476668810153e-12,   5.655056117028078e-14,
  -5.598302151735516e-16,  -1.503070410405470e-17,   8.874001601959995e-01,  -8.061873456414227e-03,   7.267743252187141e-05,  -6.122087523623457e-07,   2.823777231831754e-09,
   8.797471480448588e-11,  -4.213412933803157e-12,   1.050909206549283e-13,  -1.314547905429083e-15,  -1.691643802637418e-17,   8.874105074729903e-01,  -8.062134369680469e-03,
   7.267979226069130e-05,  -6.120809204660488e-07,   2.814723456210521e-09,   8.828725948923843e-11,  -4.218467755959531e-12,   1.049970429719135e-13,  -1.305734844547733e-15,
  -1.718576271622631e-17,   8.874274944377568e-01,  -8.062562660983492e-03,   7.268366054760963e-05,  -6.118707428768309e-07,   2.799852516605726e-09,   8.880014472593215e-11,
  -4.226740610828968e-12,   1.048419354608415e-13,  -1.291254150364280e-15,  -1.762721852735916e-17,   8.874455192393675e-01,  -8.063017056674037e-03,   7.268775747704968e-05,
  -6.116472922753374e-07,   2.784062854678391e-09,   8.934407249364482e-11,  -4.235484135760232e-12,   1.046760074602399e-13,  -1.275871968843634e-15,  -1.809470336275658e-17,
   8.874597050837595e-01,  -8.063374628980317e-03,   7.269097626151882e-05,  -6.114711199421233e-07,   2.771628761781649e-09,   8.977194060619443e-11,  -4.242340259362916e-12,
   1.045444471360745e-13,  -1.263753861702299e-15,  -1.846193712766400e-17,   8.874678921043929e-01,  -8.063580975106894e-03,   7.269283167141009e-05,  -6.113693209922526e-07,
   2.764449784411048e-09,   9.001878882328636e-11,  -4.246287005443833e-12,   1.044681309925064e-13,  -1.256755385272099e-15,  -1.867360161988081e-17,   8.874709664295141e-01,
  -8.063658457133057e-03,   7.269352797780769e-05,  -6.113310705773419e-07,   2.761753437022953e-09,   9.011146709026402e-11,  -4.247767146384078e-12,   1.044393998309054e-13,
  -1.254126469054596e-15,  -1.875303196530913e-17,   8.874714760438290e-01,  -8.063671300729849e-03,   7.269364337848195e-05,  -6.113247287629814e-07,   2.761306448794742e-09,
   9.012682901082715e-11,  -4.248012400606331e-12,   1.044346333431658e-13,  -1.253690640183139e-15,  -1.876619594764616e-17,   1.185338478005693e+00,  -1.076626835043342e-02,
   9.673953603664512e-05,  -7.865345987666013e-07,   1.696582090519415e-09,   2.225439182718731e-10,  -9.767909327947766e-12,   2.667660126202112e-13,  -4.577814416707647e-15,
   1.226536922297385e-17,   1.185352247423068e+00,  -1.076660299538374e-02,   9.674086520705003e-05,  -7.862111652309812e-07,   1.675518883948662e-09,   2.233418114370850e-10,
  -9.785838606708581e-12,   2.668105743129491e-13,  -4.562871984024023e-15,   1.158524410571632e-17,   1.185374852268292e+00,  -1.076715226786272e-02,   9.674303418900345e-05,
  -7.856793757669838e-07,   1.640912724803610e-09,   2.246517665764330e-10,  -9.815228970391380e-12,   2.668812070954432e-13,  -4.538269153063502e-15,   1.046817123805161e-17,
   1.185398837916079e+00,  -1.076773495051258e-02,   9.674531787887980e-05,  -7.851139902297805e-07,   1.604155581879871e-09,   2.260418419073736e-10,  -9.846355252632578e-12,
   2.669527246570982e-13,  -4.512065376166781e-15,   9.282149619672593e-18,   1.185417714862149e+00,  -1.076819342486563e-02,   9.674710228327983e-05,  -7.846682209261559e-07,
   1.575200515911369e-09,   2.271359170072986e-10,  -9.870808873522927e-12,   2.670065256383377e-13,  -4.491371824008399e-15,   8.348229780256938e-18,   1.185428609162849e+00,
  -1.076845797927736e-02,   9.674812693600614e-05,  -7.844106348811528e-07,   1.558479167266936e-09,   2.277673598373502e-10,  -9.884904299664035e-12,   2.670365793723058e-13,
  -4.479400729359319e-15,   7.809042544326634e-18,   1.185432700089765e+00,  -1.076855731450556e-02,   9.674851072734682e-05,  -7.843138475450591e-07,   1.552198091784125e-09,
   2.280044786086213e-10,  -9.890194010930721e-12,   2.670476765877890e-13,  -4.474900092933683e-15,   7.606534139454958e-18,   1.185433378219915e+00,  -1.076857378034129e-02,
   9.674857429476250e-05,  -7.842978004293251e-07,   1.551156805878494e-09,   2.280437847379790e-10,  -9.891070684149308e-12,   2.670495061777466e-13,  -4.474153764767851e-15,
   7.572963462654229e-18,   1.924348800655802e-03,  -1.687692257394319e-05,   1.477528674093189e-07,  -1.273616649648442e-09,   9.867495580566607e-12,  -2.986723813793704e-14,
  -1.577038476814993e-15,   5.604130176641316e-17,  -1.013073101021309e-18,   3.131359824225976e-21,   1.924369843878035e-03,  -1.687746645383693e-05,   1.477612733484254e-07,
  -1.273657737117730e-09,   9.864082111274429e-12,  -2.969956841192260e-14,  -1.581011808262053e-15,   5.605381625960525e-17,  -1.010030877204411e-18,   2.999947124007188e-21,
   1.924404390595537e-03,  -1.687835933307840e-05,   1.477750709367717e-07,  -1.273725016312872e-09,   9.858472252409240e-12,  -2.942428667854521e-14,  -1.587525845166126e-15,
   5.607387442410177e-17,  -1.005024675340703e-18,   2.784238096724371e-21,   1.924441048505168e-03,  -1.687930676375433e-05,   1.477897083596111e-07,  -1.273796170235604e-09,
   9.852511480291680e-12,  -2.913215843239442e-14,  -1.594425722736289e-15,   5.609449668571866e-17,  -9.996965718623794e-19,   2.555391477587007e-21,   1.924469899321408e-03,
  -1.688005240881062e-05,   1.478012259980375e-07,  -1.273851998949732e-09,   9.847814333506906e-12,  -2.890222849055902e-14,  -1.599847245840890e-15,   5.611024797936468e-17,
  -9.954916711913650e-19,   2.375316379410193e-21,   1.924486550031809e-03,  -1.688048274001045e-05,   1.478078722139827e-07,  -1.273884150726008e-09,   9.845101119984686e-12,
  -2.876952216331840e-14,  -1.602972613887576e-15,   5.611914655499342e-17,  -9.930602780072749e-19,   2.271403349789782e-21,   1.924492802603434e-03,  -1.688064433457233e-05,
   1.478103677756279e-07,  -1.273896211172072e-09,   9.844081828262350e-12,  -2.871968788502139e-14,  -1.604145558755033e-15,   5.612245180767581e-17,  -9.921463854724788e-19,
   2.232385263479295e-21,   1.924493839060070e-03,  -1.688067112123236e-05,   1.478107814423267e-07,  -1.273898209684908e-09,   9.843912842173928e-12,  -2.871142704909718e-14,
  -1.604339956223249e-15,   5.612299778826811e-17,  -9.919948482950302e-19,   2.225917579268953e-21,   1.737581995981261e-02,  -1.523892583470836e-04,   1.334107022925435e-06,
  -1.149820982684512e-08,   8.897944916126131e-11,  -2.639490539994287e-13,  -1.445320000606736e-14,   5.120536766068037e-16,  -9.267039188939348e-18,   2.934698855914122e-20,
   1.737600996546545e-02,  -1.523941684650177e-04,   1.334182820043268e-06,  -1.149857250885089e-08,   8.894816625902163e-11,  -2.624169817177174e-13,  -1.448954933631748e-14,
   5.121718410814190e-16,  -9.239377691199342e-18,   2.814816193784411e-20,   1.737632189827253e-02,  -1.524022293273919e-04,   1.334307233840318e-06,  -1.149916633350254e-08,
   8.889675453673705e-11,  -2.599016027623412e-13,  -1.454914235587612e-14,   5.123613897833028e-16,  -9.193857894928515e-18,   2.618031208293363e-20,   1.737665289365975e-02,
  -1.524107826734612e-04,   1.334439220057202e-06,  -1.149979428455403e-08,   8.884212699045517e-11,  -2.572322780298117e-13,  -1.461226586472015e-14,   5.125564852950296e-16,
  -9.145410095067630e-18,   2.409258353735907e-20,   1.737691339642142e-02,  -1.524175143087781e-04,   1.334543074747330e-06,  -1.150028693378863e-08,   8.879908004360753e-11,
  -2.551312827666032e-13,  -1.466186513390696e-14,   5.127056607854959e-16,  -9.107174680815285e-18,   2.244976873900783e-20,   1.737706374072648e-02,  -1.524213993099815e-04,
   1.334603003636253e-06,  -1.150057062932874e-08,   8.877421486763755e-11,  -2.539186694187818e-13,  -1.469045802491102e-14,   5.127900030272820e-16,  -9.085065572183896e-18,
   2.150176791408471e-20,   1.737712019708776e-02,  -1.524228581746523e-04,   1.334625506077119e-06,  -1.150067704226318e-08,   8.876487360179935e-11,  -2.534633045969350e-13,
  -1.470118892078126e-14,   5.128213436545885e-16,  -9.076755320635769e-18,   2.114580351373210e-20,   1.737712955556833e-02,  -1.524231000027798e-04,   1.334629236102129e-06,
  -1.150069467552822e-08,   8.876332493466183e-11,  -2.533878204957783e-13,  -1.470296740271265e-14,   5.128265213654600e-16,  -9.075377352459093e-18,   2.108679835116250e-20,
   4.858801408975102e-02,  -4.261253134264744e-04,   3.730443915079131e-06,  -3.214171184035114e-08,   2.481252981362345e-10,  -7.047835527895830e-13,  -4.165622995556405e-14,
   1.466999295407893e-15,  -2.661273580429757e-17,   8.843598714724049e-20,   4.858854538433267e-02,  -4.261390388366673e-04,   3.730655263961863e-06,  -3.214267773241785e-08,
   2.480351404523567e-10,  -7.003939067416951e-13,  -4.176063708180279e-14,   1.467360454151808e-15,  -2.653428627285336e-17,   8.501253141769036e-20,   4.858941761205675e-02,
  -4.261615716088789e-04,   3.731002171335434e-06,  -3.214425888330744e-08,   2.478869718068335e-10,  -6.931868718635914e-13,  -4.193181054671871e-14,   1.467940681965811e-15,
  -2.640518499169558e-17,   7.939287352038959e-20,   4.859034314255466e-02,  -4.261854810152416e-04,   3.731370190678844e-06,  -3.214593046688399e-08,   2.477295358679150e-10,
  -6.855386866692423e-13,  -4.211312882472933e-14,   1.468539126408435e-15,  -2.626777315341396e-17,   7.343070540026512e-20,   4.859107156125545e-02,  -4.262042981280397e-04,
   3.731659768628947e-06,  -3.214724156631575e-08,   2.476054755935801e-10,  -6.795188384441363e-13,  -4.225560242815202e-14,   1.468997637014881e-15,  -2.615932203281470e-17,
   6.873900706809486e-20,   4.859149195448310e-02,  -4.262151579655807e-04,   3.731826867582847e-06,  -3.214799644531072e-08,   2.475338149546102e-10,  -6.760443951057623e-13,
  -4.233773647875466e-14,   1.469257254865524e-15,  -2.609660983408336e-17,   6.603157215009600e-20,   4.859164981793669e-02,  -4.262192359640503e-04,   3.731889610714617e-06,
  -3.214827957302804e-08,   2.475068937649852e-10,  -6.747396562831200e-13,  -4.236856155779819e-14,   1.469353799394581e-15,  -2.607303757190037e-17,   6.501494940639639e-20,
   4.859167598614900e-02,  -4.262199119518010e-04,   3.731900011065874e-06,  -3.214832648772909e-08,   2.475024305644539e-10,  -6.745233744789099e-13,  -4.237367035479040e-14,
   1.469369753203672e-15,  -2.606912890840299e-17,   6.484643209519657e-20,   9.621484032542223e-02,  -8.438181795216033e-04,   7.386711893124317e-06,  -6.361370241460984e-08,
   4.891676348041004e-10,  -1.290165064953115e-12,  -8.642862929402497e-14,   3.017010795066591e-15,  -5.494370882509953e-17,   1.961304924395486e-19,   9.621589234656540e-02,
  -8.438453438150449e-04,   7.387128504958882e-06,  -6.361546217231460e-08,   4.889805868192425e-10,  -1.281136194721261e-12,  -8.664425120228021e-14,   3.017827515804646e-15,
  -5.478495956206312e-17,   1.891253069445094e-19,   9.621761945226552e-02,  -8.438899389255248e-04,   7.387812324484500e-06,  -6.361834180753118e-08,   4.886731863649498e-10,
  -1.266312200921192e-12,  -8.699776854233544e-14,   3.019142360679586e-15,  -5.452369691299783e-17,   1.776257735233350e-19,   9.621945210297754e-02,  -8.439372584985947e-04,
   7.388537751782836e-06,  -6.362138469375477e-08,   4.883465613736664e-10,  -1.250580596770165e-12,  -8.737225031258581e-14,   3.020502267258317e-15,  -5.424559543836970e-17,
   1.654248051180512e-19,   9.622089445076604e-02,  -8.439744997671546e-04,   7.389108552344966e-06,  -6.362377031655182e-08,   4.880891807548961e-10,  -1.238198172191887e-12,
  -8.766651433998783e-14,   3.021547003533791e-15,  -5.402609126148039e-17,   1.558233220007824e-19,   9.622172687473249e-02,  -8.439959926378688e-04,   7.389437926571525e-06,
  -6.362514344026452e-08,   4.879405111786646e-10,  -1.231051411676643e-12,  -8.783615717654259e-14,   3.022139713115303e-15,  -5.389915630570972e-17,   1.502824403023983e-19,
   9.622203946139472e-02,  -8.440040634635083e-04,   7.389561601182389e-06,  -6.362565836896183e-08,   4.878846596796115e-10,  -1.228367615577428e-12,  -8.789982518730280e-14,
   3.022360348286819e-15,  -5.385144286436652e-17,   1.482018478462199e-19,   9.622209127727632e-02,  -8.440054013204363e-04,   7.389582101561057e-06,  -6.362574368920919e-08,
   4.878754001970065e-10,  -1.227922731838090e-12,  -8.791037724738910e-14,   3.022396819742687e-15,  -5.384353114224127e-17,   1.478569632968827e-19,   1.613360500135200e-01,
  -1.414934204195181e-03,   1.238534586198797e-05,  -1.065866661502127e-07,   8.149252592573713e-10,  -1.904253575165025e-12,  -1.546472986615549e-13,   5.337013908170178e-15,
  -9.775886549715802e-17,   3.836118854538396e-19,   1.613378139346437e-01,  -1.414979717462404e-03,   1.238603978268871e-05,  -1.065892411443973e-07,   8.145905965322875e-10,
  -1.888278694111766e-12,  -1.550311153022188e-13,   5.338648833551282e-15,  -9.748462243676566e-17,   3.713082541340155e-19,   1.613407097678006e-01,  -1.415054435621688e-03,
   1.238717875787956e-05,  -1.065934519726086e-07,   8.140406043710815e-10,  -1.862050024418347e-12,  -1.556604159586088e-13,   5.341287270015637e-15,  -9.703324521983652e-17,
   3.511098669584320e-19,   1.613437825673036e-01,  -1.415133718401059e-03,   1.238838701577820e-05,  -1.065978976396216e-07,   8.134562201700023e-10,  -1.834214924496107e-12,
  -1.563270682839194e-13,   5.344024938273295e-15,  -9.655272188533873e-17,   3.296780014813198e-19,   1.613462009466742e-01,  -1.415196115114146e-03,   1.238933771617774e-05,
  -1.066013802215569e-07,   8.129957280360641e-10,  -1.812305372040182e-12,  -1.568509406621204e-13,   5.346134668793675e-15,  -9.617340805480587e-17,   3.128112732051670e-19,
   1.613475966687617e-01,  -1.415232125776968e-03,   1.238988630177705e-05,  -1.066033836009422e-07,   8.127297372262014e-10,  -1.799659679135713e-12,  -1.571529619134887e-13,
   5.347334266193855e-15,  -9.595404270915352e-17,   3.030773021478635e-19,   1.613481207815884e-01,  -1.415245648195482e-03,   1.239009228558349e-05,  -1.066041346637053e-07,
   8.126298112414204e-10,  -1.794910858881206e-12,  -1.572663141619517e-13,   5.347781330588377e-15,  -9.587158276612826e-17,   2.994221321810090e-19,   1.613482076610712e-01,
  -1.415247889732888e-03,   1.239012642952780e-05,  -1.066042590984243e-07,   8.126132447694810e-10,  -1.794123661497672e-12,  -1.572851007669921e-13,   5.347855258738792e-15,
  -9.585790931185904e-17,   2.988162373016907e-19,   2.456109889911772e-01,  -2.154020469443449e-03,   1.885293284138302e-05,  -1.620849222048305e-07,   1.229112191794520e-09,
  -2.337212772428341e-12,  -2.566227052959534e-13,   8.735924662387244e-15,  -1.613751866437206e-16,   7.125705226058692e-19,   2.456136740060837e-01,  -2.154089677995181e-03,
   1.885397916153248e-05,  -1.620880273550249e-07,   1.228556884570223e-09,  -2.311057163973377e-12,  -2.572566793063666e-13,   8.739039708883077e-15,  -1.609412743484254e-16,
   6.926282439890345e-19,   2.456180819998472e-01,  -2.154203295943468e-03,   1.885569652035768e-05,  -1.620930980390518e-07,   1.227644284566813e-09,  -2.268112118705429e-12,
  -2.582961895093641e-13,   8.744079700443114e-15,  -1.602270031956840e-16,   6.598873089832912e-19,   2.456227593676759e-01,  -2.154323854600396e-03,   1.885751830154549e-05,
  -1.620984418331793e-07,   1.226674623670311e-09,  -2.222535521764009e-12,  -2.593974736833292e-13,   8.749327133093807e-15,  -1.594664829974230e-16,   6.251435741809964e-19,
   2.456264405862597e-01,  -2.154418735785802e-03,   1.885895171290195e-05,  -1.621026209297961e-07,   1.225910539302083e-09,  -2.186660353656011e-12,  -2.602629449385205e-13,
   8.753384203633150e-15,  -1.588660542199459e-16,   5.977980577970409e-19,   2.456285651317833e-01,  -2.154473493928393e-03,   1.885977882624716e-05,  -1.621050221457985e-07,
   1.225469188278895e-09,  -2.165953651326522e-12,  -2.607619254099210e-13,   8.755696481130837e-15,  -1.585187765719490e-16,   5.820156871225520e-19,   2.456293629277473e-01,
  -2.154494056222433e-03,   1.886008938974605e-05,  -1.621059218184397e-07,   1.225303384224392e-09,  -2.158177619963077e-12,  -2.609492029564181e-13,   8.756559256981744e-15,
  -1.583882271605884e-16,   5.760891186453570e-19,   2.456294951742695e-01,  -2.154497464720525e-03,   1.886014086873070e-05,  -1.621060708461324e-07,   1.225275896012754e-09,
  -2.156888607325796e-12,  -2.609802418984807e-13,   8.756701983889358e-15,  -1.583665791762925e-16,   5.751066983599936e-19,   3.515664399339009e-01,  -3.083227185119486e-03,
   2.698201377567962e-05,  -2.316474656465843e-07,   1.735966360224100e-09,  -2.195736253444328e-12,  -4.110603164360100e-13,   1.378003064667117e-14,  -2.577222223231526e-16,
   1.312986238725579e-18,   3.515702826431939e-01,  -3.083326090266295e-03,   2.698349097470230e-05,  -2.316502417856221e-07,   1.735076889043818e-09,  -2.154462772883698e-12,
  -4.120736572876604e-13,   1.378592376827247e-14,  -2.570707490125876e-16,   1.281955590321865e-18,   3.515765912237267e-01,  -3.083488459851538e-03,   2.698591548329738e-05,
  -2.316547567767811e-07,   1.733615121928789e-09,  -2.086693486646778e-12,  -4.137353261940033e-13,   1.379548330859392e-14,  -2.559981306607467e-16,   1.231004303968985e-18,
   3.515832853209039e-01,  -3.083660747584101e-03,   2.698848732265829e-05,  -2.316594897766230e-07,   1.732061960614288e-09,  -2.014768607625599e-12,  -4.154959061754014e-13,
   1.380547044460048e-14,  -2.548557675412732e-16,   1.176928618656696e-18,   3.515885537594400e-01,  -3.083796339692163e-03,   2.699051082912834e-05,  -2.316631728511126e-07,
   1.730838085585184e-09,  -1.958151562258831e-12,  -4.168796206382663e-13,   1.381321721211867e-14,  -2.539536634661179e-16,   1.134362096621225e-18,   3.515915943380121e-01,
  -3.083874592850831e-03,   2.699167841583390e-05,  -2.316652816596774e-07,   1.730131150927743e-09,  -1.925472068472586e-12,  -4.176774379618942e-13,   1.381764265827192e-14,
  -2.534318175911570e-16,   1.109792755562944e-18,   3.515927361167789e-01,  -3.083903977746854e-03,   2.699211681494734e-05,  -2.316660703691594e-07,   1.729865574225320e-09,
  -1.913199711374433e-12,  -4.179768841364548e-13,   1.381929588236904e-14,  -2.532356281639747e-16,   1.100566099789016e-18,   3.515929253835476e-01,  -3.083908848716970e-03,
   2.699218948369613e-05,  -2.316662009418561e-07,   1.729821544982545e-09,  -1.911165346083093e-12,  -4.180265141226371e-13,   1.381956947554842e-14,  -2.532030947716789e-16,
   1.099036616926746e-18,   4.831687928936881e-01,  -4.237320994708798e-03,   3.707431484007447e-05,  -3.176412114488207e-07,   2.338763799983520e-09,  -6.840628768513008e-13,
  -6.547244004409476e-13,   2.160028893624816e-14,  -4.115799992564111e-16,   2.491158515966980e-18,   4.831740728405308e-01,  -4.237456604141300e-03,   3.707630374278154e-05,
  -3.176416382222065e-07,   2.337347000606316e-09,  -6.193305115936265e-13,  -6.563446444688366e-13,   2.161177054180640e-14,  -4.106335415672429e-16,   2.443482994570657e-18,
   4.831827409313272e-01,  -4.237679228982154e-03,   3.707956796809037e-05,  -3.176422721837306e-07,   2.335018605821588e-09,  -5.130378889868453e-13,  -6.590017825684290e-13,
   2.163044271226721e-14,  -4.090747310493755e-16,   2.365188215195689e-18,   4.831919387222222e-01,  -4.237915451148122e-03,   3.708303036610164e-05,  -3.176428542613429e-07,
   2.332544618149727e-09,  -4.002208351545232e-13,  -6.618174596455202e-13,   2.165001506524206e-14,  -4.074138639339392e-16,   2.282074405875949e-18,   4.831991776322397e-01,
  -4.238101359227984e-03,   3.708575442397527e-05,  -3.176432467488961e-07,   2.330595130868684e-09,  -3.114099517283401e-13,  -6.640306896458067e-13,   2.166524461104531e-14,
  -4.061018025690920e-16,   2.216637119352629e-18,   4.832033554290220e-01,  -4.238208650410873e-03,   3.708732618306530e-05,  -3.176434469577666e-07,   2.329469063775156e-09,
  -2.601461810470188e-13,  -6.653068945302092e-13,   2.167396411880368e-14,  -4.053426047825349e-16,   2.178861612937630e-18,   4.832049242484256e-01,  -4.238248939315590e-03,
   3.708791632843605e-05,  -3.176435171661728e-07,   2.329046029252310e-09,  -2.408943791202211e-13,  -6.657859152414553e-13,   2.167722519352647e-14,  -4.050571442680309e-16,
   2.164674594635933e-18,   4.832051843034977e-01,  -4.238255617778153e-03,   3.708801415000675e-05,  -3.176435285419152e-07,   2.328975895460172e-09,  -2.377030254187444e-13,
  -6.658653088593836e-13,   2.167776506762030e-14,  -4.050098053692938e-16,   2.162322791421755e-18,   6.471036377149055e-01,  -5.674894477746886e-03,   4.963708852372762e-05,
  -4.239273923548253e-07,   3.034004053128241e-09,   4.026060770455739e-12,  -1.070327413869139e-12,   3.480509433698980e-14,  -6.831944096840882e-16,   5.108244669870144e-18,
   6.471107066201399e-01,  -5.675075438161270e-03,   4.963966594818209e-05,  -4.239207812158718e-07,   3.031687355989331e-09,   4.130456461073468e-12,  -1.073021771924832e-12,
   3.482926768903532e-14,  -6.818579091518177e-16,   5.033958051829031e-18,   6.471223116354629e-01,  -5.675372511730431e-03,   4.964389576779806e-05,  -4.239098204250677e-07,
   3.027879980521247e-09,   4.301889800365065e-12,  -1.077441098883559e-12,   3.486867650519242e-14,  -6.796553176007596e-16,   4.911927293959328e-18,   6.471346258115234e-01,
  -5.675687726689136e-03,   4.964838197518566e-05,  -4.238980439994898e-07,   3.023834434620717e-09,   4.483862697805219e-12,  -1.082125035430819e-12,   3.491011751510788e-14,
  -6.773066468219267e-16,   4.782339231542894e-18,   6.471443173918500e-01,  -5.675935800289617e-03,   4.965191122513028e-05,  -4.238886700305372e-07,   3.020646497780771e-09,
   4.627125934449443e-12,  -1.085807462324474e-12,   3.494246032987147e-14,  -6.754498787462581e-16,   4.680278230818064e-18,   6.471499106961934e-01,  -5.676078967517445e-03,
   4.965394745518137e-05,  -4.238832176884823e-07,   3.018805046113246e-09,   4.709825751269864e-12,  -1.087931113839807e-12,   3.496101713986657e-14,  -6.743749574997549e-16,
   4.621347219887946e-18,   6.471520110572151e-01,  -5.676132728064855e-03,   4.965471197220389e-05,  -4.238811622571145e-07,   3.018113254531636e-09,   4.740884087456305e-12,
  -1.088728272901847e-12,   3.496796482607638e-14,  -6.739706822631659e-16,   4.599212473030626e-18,   6.471523592231536e-01,  -5.676141639636109e-03,   4.965483869616556e-05,
  -4.238808211166895e-07,   3.017998563920041e-09,   4.746032647907141e-12,  -1.088860397949106e-12,   3.496911541868880e-14,  -6.739036345461551e-16,   4.595543029011143e-18,
   8.562701987166610e-01,  -7.508969319040180e-03,   6.564479436083941e-05,  -5.575357881818713e-07,   3.784585870334478e-09,   1.715344853549973e-11,  -1.892392244573908e-12,
   6.109526285457184e-14,  -1.264292272088020e-15,   1.242761442914235e-17,   8.562795469043034e-01,  -7.509207251327968e-03,   6.564800255392149e-05,  -5.575098270719447e-07,
   3.780486992919932e-09,   1.733698771172402e-11,  -1.897393625473683e-12,   6.115567314980246e-14,  -1.262556913684868e-15,   1.230652650571710e-17,   8.562948937939410e-01,
  -7.509597847322573e-03,   6.565326677378095e-05,  -5.574670185272847e-07,   3.773750325163734e-09,   1.763842534277388e-11,  -1.905599112690326e-12,   6.125439627130345e-14,
  -1.259692129812354e-15,   1.210750421941115e-17,   8.563111784739162e-01,  -7.510012288464741e-03,   6.565884905196648e-05,  -5.574213381673278e-07,   3.766591743300748e-09,
   1.795844789744539e-11,  -1.914298827375283e-12,   6.135853685848347e-14,  -1.256630762112622e-15,   1.189600581408829e-17,   8.563239949239549e-01,  -7.510338447545161e-03,
   6.566323982274803e-05,  -5.573852012181911e-07,   3.760950334233266e-09,   1.821043283988143e-11,  -1.921140503028157e-12,   6.144005237138431e-14,  -1.254205815173170e-15,
   1.172932470631498e-17,   8.563313916766579e-01,  -7.510526677002505e-03,   6.566577281502443e-05,  -5.573642711951326e-07,   3.757691534438315e-09,   1.835590844982261e-11,
  -1.925086938847020e-12,   6.148691859815372e-14,  -1.252800067839774e-15,   1.163303768204470e-17,   8.563341692551846e-01,  -7.510597358405873e-03,   6.566672378832264e-05,
  -5.573563976452657e-07,   3.756467249707195e-09,   1.841054545453404e-11,  -1.926568480467942e-12,   6.150448367968727e-14,  -1.252271012440276e-15,   1.159686358708642e-17,
   8.563346296798666e-01,  -7.510609074826961e-03,   6.566688141570772e-05,  -5.573550917468295e-07,   3.756264276763703e-09,   1.841960281912880e-11,  -1.926814046907149e-12,
   6.150739356769267e-14,  -1.252183251522602e-15,   1.159086629840865e-17,   1.143762467746013e+00,  -1.002937730749780e-02,   8.757585545682120e-05,  -7.342678073467174e-07,
   4.326103087385227e-09,   6.206250053161192e-11,  -4.195742798614430e-12,   1.385985489909771e-13,  -3.231890748507877e-15,   4.779102769022421e-17,   1.143774937756860e+00,
  -1.002969045739478e-02,   8.757949758666295e-05,  -7.341759550816984e-07,   4.316993885644065e-09,   6.248051328112269e-11,  -4.208617200619842e-12,   1.388380984928114e-13,
  -3.231761717189432e-15,   4.759507908978053e-17,   1.143795409664718e+00,  -1.003020451447333e-02,   8.758547106206207e-05,  -7.340247331758474e-07,   4.302019795092616e-09,
   6.316726284558173e-11,  -4.229752031548808e-12,   1.392306245496640e-13,  -3.231512881837264e-15,   4.727238333660837e-17,   1.143817132439591e+00,  -1.003074992906471e-02,
   8.759180166815055e-05,  -7.338636882457529e-07,   4.286104134536153e-09,   6.389665488808437e-11,  -4.252176868937099e-12,   1.396461264670868e-13,  -3.231198521121233e-15,
   4.692860080472654e-17,   1.143834228738186e+00,  -1.003117914441330e-02,   8.759677829869557e-05,  -7.337365199522420e-07,   4.273558882713220e-09,   6.447119470849582e-11,
  -4.269824671078554e-12,   1.399724040532341e-13,  -3.230914657424894e-15,   4.665704588012479e-17,   1.143844095490885e+00,  -1.003142684142022e-02,   8.759964816712029e-05,
  -7.336629581725210e-07,   4.266310938799247e-09,   6.480297485553884e-11,  -4.280009281961839e-12,   1.401604142385055e-13,  -3.230736211924703e-15,   4.649992720390655e-17,
   1.143847800581935e+00,  -1.003151985192144e-02,   8.760072540721092e-05,  -7.336353027630749e-07,   4.263587783141986e-09,   6.492759974960947e-11,  -4.283833649737297e-12,
   1.402309588692187e-13,  -3.230666439263468e-15,   4.644085219965872e-17,   1.143848414755250e+00,  -1.003153526962787e-02,   8.760090395280021e-05,  -7.336307167826296e-07,
   4.263136303003023e-09,   6.494826012156018e-11,  -4.284467590497640e-12,   1.402426497451346e-13,  -3.230654727580355e-15,   4.643105569651537e-17,   1.859112076727469e-03,
  -1.575340564512646e-05,   1.333916774300344e-07,  -1.122102005755030e-09,   9.000632404064481e-12,  -5.234987259438528e-14,  -4.266712608770512e-16,   2.777174301442392e-17,
  -7.112057681071069e-19,   1.062188260793985e-20,   1.859131074786815e-03,  -1.575388495575154e-05,   1.333993571989214e-07,  -1.122175794802750e-09,   8.999687977336239e-12,
  -5.226602896445900e-14,  -4.295041670787601e-16,   2.782501874092921e-17,  -7.111662232295568e-19,   1.057956009042087e-20,   1.859162263965903e-03,  -1.575467184434158e-05,
   1.334119641892830e-07,  -1.122296844878322e-09,   8.998133177783387e-12,  -5.212827174324082e-14,  -4.341546843506595e-16,   2.791232141730200e-17,  -7.110938184935271e-19,
   1.050990344307090e-20,   1.859195359169261e-03,  -1.575550682469333e-05,   1.334253403728330e-07,  -1.122425170619319e-09,   8.996477475915299e-12,  -5.198194548344323e-14,
  -4.390890177536012e-16,   2.800474114063793e-17,  -7.110068167951317e-19,   1.043575169413849e-20,   1.859221406045678e-03,  -1.575616398086420e-05,   1.334358669137051e-07,
  -1.122526078350794e-09,   8.995170129693479e-12,  -5.186667372610066e-14,  -4.429721919689328e-16,   2.807731988220769e-17,  -7.109309782153140e-19,   1.037721996202499e-20,
   1.859236438519031e-03,  -1.575654324745447e-05,   1.334419417510549e-07,  -1.122584279966333e-09,   8.994413910952297e-12,  -5.180010320551877e-14,  -4.452131756917140e-16,
   2.811914384141287e-17,  -7.108842565802015e-19,   1.034337054964811e-20,   1.859242083421160e-03,  -1.575668566751485e-05,   1.334442228683814e-07,  -1.122606128783791e-09,
   8.994129617508210e-12,  -5.177509682563151e-14,  -4.460546733807812e-16,   2.813483730112108e-17,  -7.108661538208571e-19,   1.033064661558339e-20,   1.859243019147596e-03,
  -1.575670927576728e-05,   1.334446009938806e-07,  -1.122609750196764e-09,   8.994082474613944e-12,  -5.177095121262108e-14,  -4.461941629211897e-16,   2.813743809113985e-17,
  -7.108631235745159e-19,   1.032853674834353e-20,   1.678676828643286e-02,  -1.422446156504798e-04,   1.204447189367941e-06,  -1.013132409096417e-08,   8.122726263254036e-11,
  -4.704417409053322e-13,  -3.943971396115913e-15,   2.536992097663894e-16,  -6.494734532765607e-18,   9.718596362898035e-20,   1.678693982748739e-02,  -1.422489432770447e-04,
   1.204516495190552e-06,  -1.013198709021411e-08,   8.121853648390941e-11,  -4.696758028169459e-13,  -3.969842709357512e-15,   2.541867263984105e-16,  -6.494431151611015e-18,
   9.680115489374919e-20,   1.678722144701999e-02,  -1.422560479797182e-04,   1.204630266435305e-06,  -1.013307471976516e-08,   8.120417118721090e-11,  -4.684173451973351e-13,
  -4.012313392563281e-15,   2.549856267268077e-16,  -6.493864835815018e-18,   9.616780585434844e-20,   1.678752027680008e-02,  -1.422635868945354e-04,   1.204750979058878e-06,
  -1.013422770313311e-08,   8.118887425520958e-11,  -4.670806041120652e-13,  -4.057376243432807e-15,   2.558313652612569e-16,  -6.493171137923189e-18,   9.549357127905242e-20,
   1.678775546442331e-02,  -1.422695202599702e-04,   1.204845975115994e-06,  -1.013513432784289e-08,   8.117679621766813e-11,  -4.660275548715394e-13,  -4.092839536593795e-15,
   2.564955468221446e-16,  -6.492557999293206e-18,   9.496135359924800e-20,   1.678789119861197e-02,  -1.422729446012655e-04,   1.204900797025283e-06,  -1.013565724617356e-08,
   8.116981000433352e-11,  -4.654194083412903e-13,  -4.113305504500712e-15,   2.568782892910212e-16,  -6.492177206795967e-18,   9.465356339491982e-20,   1.678794216868109e-02,
  -1.422742304906050e-04,   1.204921382786255e-06,  -1.013585354811934e-08,   8.116718363645387e-11,  -4.651909655994706e-13,  -4.120990563733036e-15,   2.570219051143563e-16,
  -6.492029123446759e-18,   9.453786483566279e-20,   1.678795061772766e-02,  -1.422744436459671e-04,   1.204924795149098e-06,  -1.013588608485912e-08,   8.116674812142511e-11,
  -4.651530938488618e-13,  -4.122264466143030e-15,   2.570457058044386e-16,  -6.492004307878166e-18,   9.451867980111779e-20,   4.694085066817838e-02,  -3.977584358603546e-04,
   3.367956414688106e-06,  -2.832649451899239e-08,   2.268836686023474e-10,  -1.302457191209231e-12,  -1.155887443071757e-14,   7.264869273888688e-16,  -1.858629089121674e-17,
   2.792322818824077e-19,   4.694133034239585e-02,  -3.977705355441801e-04,   3.368149992744861e-06,  -2.832832947196912e-08,   2.268581153811838e-10,  -1.300263787893042e-12,
  -1.163291870571158e-14,   7.278880329987044e-16,  -1.858576465009496e-17,   2.781409997734398e-19,   4.694211782516634e-02,  -3.977903996958729e-04,   3.368467766413743e-06,
  -2.833133957898916e-08,   2.268160514017387e-10,  -1.296659954118251e-12,  -1.175447173568662e-14,   7.301840985990605e-16,  -1.858470591286437e-17,   2.763448185382419e-19,
   4.694295343231297e-02,  -3.978114778602266e-04,   3.368804926999240e-06,  -2.833453045481563e-08,   2.267712630208275e-10,  -1.292831925682878e-12,  -1.188344501162613e-14,
   7.326148525625434e-16,  -1.858331768277589e-17,   2.744326019736116e-19,   4.694361107912365e-02,  -3.978280670393167e-04,   3.369070258310825e-06,  -2.833703945926028e-08,
   2.267359019282554e-10,  -1.289816295329576e-12,  -1.198494460364396e-14,   7.345238435921442e-16,  -1.858203336386206e-17,   2.729231032467285e-19,   4.694399062781266e-02,
  -3.978376412005271e-04,   3.369223379839339e-06,  -2.833848655981523e-08,   2.267154492949620e-10,  -1.288074734090467e-12,  -1.204352069908392e-14,   7.356239437424099e-16,
  -1.858121527533043e-17,   2.720501112208814e-19,   4.694413315360417e-02,  -3.978412364351328e-04,   3.369280877292663e-06,  -2.833902979125232e-08,   2.267077606119514e-10,
  -1.287420537268090e-12,  -1.206551634945568e-14,   7.360367365757635e-16,  -1.858089354206443e-17,   2.717219483278661e-19,   4.694415677937252e-02,  -3.978418323989384e-04,
   3.369290408255051e-06,  -2.833911983071080e-08,   2.267064856534425e-10,  -1.287312083006495e-12,  -1.206916242961191e-14,   7.361051467617509e-16,  -1.858083944346652e-17,
   2.716675324016691e-19,   9.295310484587327e-02,  -7.876474532400982e-04,   6.669161134891456e-06,  -5.608086719311019e-08,   4.484835638101893e-10,  -2.537943477428459e-12,
  -2.456863073290925e-14,   1.492805941011108e-15,  -3.816040145324726e-17,   5.769531883394677e-19,   9.295405468594295e-02,  -7.876714080158173e-04,   6.669543761648706e-06,
  -5.608444077547373e-08,   4.484293132463520e-10,  -2.533436133316629e-12,  -2.472067778445442e-14,   1.495702176297633e-15,  -3.816043803312273e-17,   5.747450606995075e-19,
   9.295561404149427e-02,  -7.877107347519867e-04,   6.670171871359536e-06,  -5.609030273414017e-08,   4.483400175837196e-10,  -2.526030381346531e-12,  -2.497028545258917e-14,
   1.500448566207208e-15,  -3.816009981929251e-17,   5.711104191885766e-19,   9.295726869174412e-02,  -7.877524649460799e-04,   6.670838297973563e-06,  -5.609651639513717e-08,
   4.482449491693642e-10,  -2.518163866306405e-12,  -2.523513489541766e-14,   1.505473622061325e-15,  -3.815919957392542e-17,   5.672407000284070e-19,   9.295857094891430e-02,
  -7.877853079045492e-04,   6.671362745611389e-06,  -5.610140199300344e-08,   4.481698989992563e-10,  -2.511966774688802e-12,  -2.544356970817155e-14,   1.509420220776446e-15,
  -3.815809903090794e-17,   5.641857547957781e-19,   9.295932252251621e-02,  -7.878042626493959e-04,   6.671665401105658e-06,  -5.610421972787137e-08,   4.481264935519021e-10,
  -2.508387868119836e-12,  -2.556386011260669e-14,   1.511694609449056e-15,  -3.815730671053882e-17,   5.624189013634543e-19,   9.295960474881147e-02,  -7.878113804260642e-04,
   6.671779048700612e-06,  -5.610527746759879e-08,   4.481101768864099e-10,  -2.507043491511582e-12,  -2.560903007125827e-14,   1.512548046231187e-15,  -3.815697947569020e-17,
   5.617547156311232e-19,   9.295965153201442e-02,  -7.878125603037278e-04,   6.671797887281475e-06,  -5.610545278475166e-08,   4.481074712429633e-10,  -2.506820617501429e-12,
  -2.561651762298201e-14,   1.512689482935658e-15,  -3.815692366438999e-17,   5.616445796517264e-19,   1.558666858864944e-01,  -1.320749914978087e-03,   1.118275270936241e-05,
  -9.400950245014958e-08,   7.500884067257570e-10,  -4.154797772674540e-12,  -4.532373225496371e-14,   2.636915259067481e-15,  -6.735364968306524e-17,   1.027765425030571e-18,
   1.558682785611495e-01,  -1.320790070343980e-03,   1.118339260008490e-05,  -9.401534772932550e-08,   7.499884696136681e-10,  -4.146835183206886e-12,  -4.559215706169978e-14,
   2.642077719807939e-15,  -6.735658229652171e-17,   1.023951223479341e-18,   1.558708932601616e-01,  -1.320855993665773e-03,   1.118444302160830e-05,  -9.402493547708891e-08,
   7.498239925054866e-10,  -4.133752219917924e-12,  -4.603282427192409e-14,   2.650538481670690e-15,  -6.736069819622260e-17,   1.017672409661749e-18,   1.558736677473422e-01,
  -1.320925945836797e-03,   1.118555751473593e-05,  -9.403509763514221e-08,   7.496489066933438e-10,  -4.119855137531528e-12,  -4.650041118114754e-14,   2.659496598155822e-15,
  -6.736411601234554e-17,   1.010986784226540e-18,   1.558758513480925e-01,  -1.320981000322435e-03,   1.118643456481951e-05,  -9.404308720498630e-08,   7.495107056910035e-10,
  -4.108907179436267e-12,  -4.686840724486417e-14,   2.666532605272030e-15,  -6.736611824923955e-17,   1.005708307441481e-18,   1.558771115727430e-01,  -1.321012774047581e-03,
   1.118694070273847e-05,  -9.404769489270247e-08,   7.494307838243102e-10,  -4.102584541402791e-12,  -4.708078576920397e-14,   2.670587570568601e-15,  -6.736699810269065e-17,
   1.002655248730554e-18,   1.558775848045371e-01,  -1.321024705530525e-03,   1.118713075786173e-05,  -9.404942451092006e-08,   7.494007414907600e-10,  -4.100209504891944e-12,
  -4.716053613413151e-14,   2.672109181004733e-15,  -6.736727638457453e-17,   1.001507520797873e-18,   1.558776632497396e-01,  -1.321026683351633e-03,   1.118716226197086e-05,
  -9.404971118748322e-08,   7.493957599150086e-10,  -4.099815765187367e-12,  -4.717375590399738e-14,   2.672361353275197e-15,  -6.736731976450043e-17,   1.001317201281902e-18,
   2.372847005958432e-01,  -2.010648119387548e-03,   1.702348492293632e-05,  -1.430546075778508e-07,   1.137726559036482e-09,  -6.107409643185695e-12,  -7.794125794389329e-14,
   4.305894185062032e-15,  -1.099378625141038e-16,   1.699475443209430e-18,   2.372871251143713e-01,  -2.010709222847594e-03,   1.702445538926999e-05,  -1.430631889518546e-07,
   1.137554978400020e-09,  -6.094405473723713e-12,  -7.837953106599786e-14,   4.314437965554577e-15,  -1.099492537411475e-16,   1.693441195346958e-18,   2.372911054537054e-01,
  -2.010809536691521e-03,   1.702604845931981e-05,  -1.430772632341802e-07,   1.137272624711407e-09,  -6.073038676256686e-12,  -7.909905366712077e-14,   4.328441405794715e-15,
  -1.099668246423030e-16,   1.683506574695092e-18,   2.372953290369981e-01,  -2.010915980999043e-03,   1.702773868344614e-05,  -1.430921788700844e-07,   1.136972106447751e-09,
  -6.050341942107583e-12,  -7.986255677067295e-14,   4.343269422120103e-15,  -1.099839330362617e-16,   1.672926597699381e-18,   2.372986531174404e-01,  -2.010999755808642e-03,
   1.702906879259567e-05,  -1.431039043211451e-07,   1.136734931469997e-09,  -6.032461478197953e-12,  -8.046346094731610e-14,   4.354916864399591e-15,  -1.099962852310313e-16,
   1.664572214529085e-18,   2.373005715486253e-01,  -2.011048104923138e-03,   1.702983638199820e-05,  -1.431106660012159e-07,   1.136597786372373e-09,  -6.022135098549176e-12,
  -8.081026334404528e-14,   4.361629883505842e-15,  -1.100029679949712e-16,   1.659739573490160e-18,   2.373012919460515e-01,  -2.011066260691723e-03,   1.703012461139332e-05,
  -1.431132040759199e-07,   1.136546236599678e-09,  -6.018256077561659e-12,  -8.094049270950848e-14,   4.364148995976749e-15,  -1.100053931417324e-16,   1.657922760540685e-18,
   2.373014113626290e-01,  -2.011069270280546e-03,   1.703017238911593e-05,  -1.431136247451899e-07,   1.136537688826836e-09,  -6.017613002438927e-12,  -8.096208017486388e-14,
   4.364566485572624e-15,  -1.100057906971506e-16,   1.657621486615899e-18,   3.396482967465453e-01,  -2.878024204644549e-03,   2.436603118023911e-05,  -2.046441600886461e-07,
   1.620093668754498e-09,  -8.299650994147636e-12,  -1.298598023076192e-13,   6.765006299246040e-15,  -1.728244031301519e-16,   2.720710298490589e-18,   3.396517669902868e-01,
  -2.878111612829155e-03,   2.436741286656309e-05,  -2.046557983674777e-07,   1.619808280021273e-09,  -8.279215745003114e-12,  -1.305490810889162e-13,   6.778700272259329e-15,
  -1.728569917636590e-16,   2.711650903516951e-18,   3.396574640990448e-01,  -2.878255111065461e-03,   2.436968094961451e-05,  -2.046748833763977e-07,   1.619338704429276e-09,
  -8.245638556299652e-12,  -1.316807275883907e-13,   6.801147256655841e-15,  -1.729087391590221e-16,   2.696732938692921e-18,   3.396635093648003e-01,  -2.878407378613539e-03,
   2.437208731785830e-05,  -2.046951053399979e-07,   1.618839002570779e-09,  -8.209970619973574e-12,  -1.328816031439106e-13,   6.824919092340205e-15,  -1.729612650476939e-16,
   2.680842066938672e-18,   3.396682671604845e-01,  -2.878527217467427e-03,   2.437398096596835e-05,  -2.047109993347354e-07,   1.618444687685422e-09,  -8.181870877842916e-12,
  -1.338267768182355e-13,   6.843594165930512e-15,  -1.730008778587532e-16,   2.668291217994210e-18,   3.396710130334339e-01,  -2.878596380212809e-03,   2.437507375654181e-05,
  -2.047201637291954e-07,   1.618216701189604e-09,  -8.165642397588144e-12,  -1.343722856976681e-13,   6.854358469419252e-15,  -1.730230473778507e-16,   2.661030001489414e-18,
   3.396720441466200e-01,  -2.878622351775845e-03,   2.437548409687950e-05,  -2.047236034734558e-07,   1.618131010670331e-09,  -8.159546256351216e-12,  -1.345771354178174e-13,
   6.858398028026263e-15,  -1.730312414691024e-16,   2.658299966275182e-18,   3.396722150689483e-01,  -2.878626656948114e-03,   2.437555211595737e-05,  -2.047241735770970e-07,
   1.618116802055516e-09,  -8.158535618416553e-12,  -1.346110924903236e-13,   6.859067508389556e-15,  -1.730325928569988e-16,   2.657847245813793e-18,   4.667894480682033e-01,
  -3.955342780208954e-03,   3.348442491609423e-05,  -2.810039886551393e-07,   2.209703899957355e-09,  -1.051723831132820e-11,  -2.155772882578891e-13,   1.053219896481764e-14,
  -2.698080785057243e-16,   4.359965210170900e-18,   4.667942169365927e-01,  -3.955462798876959e-03,   3.348630897253292e-05,  -2.810186864345720e-07,   2.209230933323072e-09,
  -1.048541277508832e-11,  -2.166540633844490e-13,   1.055418000932046e-14,  -2.698923708667564e-16,   4.346799943223574e-18,   4.668020459994467e-01,  -3.955659833422551e-03,
   3.348940166022812e-05,  -2.810427823382894e-07,   2.208452819834208e-09,  -1.043311875881648e-11,  -2.184219914514756e-13,   1.059021615366113e-14,  -2.700280717230989e-16,
   4.325114241839637e-18,   4.668103535033572e-01,  -3.955868908385264e-03,   3.349268283824149e-05,  -2.810683052412607e-07,   2.207624922003213e-09,  -1.037756661054972e-11,
  -2.202982046312059e-13,   1.062838614068891e-14,  -2.701684185843133e-16,   4.302005228682031e-18,   4.668168917430972e-01,  -3.956033455878499e-03,   3.349526485060334e-05,
  -2.810883595055181e-07,   2.206971726132170e-09,  -1.033380037393876e-11,  -2.217750116582982e-13,   1.065837738869522e-14,  -2.702762339280579e-16,   4.283746863394711e-18,
   4.668206651654645e-01,  -3.956128421216363e-03,   3.349675486324282e-05,  -2.810999202213694e-07,   2.206594098213903e-09,  -1.030852343718412e-11,  -2.226273919171226e-13,
   1.067566635192220e-14,  -2.703373982569423e-16,   4.273180992314764e-18,   4.668220821375187e-01,  -3.956164081977903e-03,   3.349731435563910e-05,  -2.811042589286495e-07,
   2.206452171215288e-09,  -1.029902818499093e-11,  -2.229474853130723e-13,   1.068215482559898e-14,  -2.703601660447037e-16,   4.269207998312816e-18,   4.668223170216803e-01,
  -3.956169993277123e-03,   3.349740709834242e-05,  -2.811049780018741e-07,   2.206428638244165e-09,  -1.029745402584564e-11,  -2.230005462230825e-13,   1.068323018747572e-14,
  -2.703639295779340e-16,   4.268549132670992e-18,   6.251671982429747e-01,  -5.297322510160506e-03,   4.484016426321477e-05,  -3.758453930813384e-07,   2.924681200717773e-09,
  -1.223021173659854e-11,  -3.672066588343618e-13,   1.676428319741511e-14,  -4.326690197718268e-16,   7.273065143896771e-18,   6.251735843403340e-01,  -5.297483026731158e-03,
   4.484265691716779e-05,  -3.758623690960189e-07,   2.923876819183516e-09,  -1.217952607510363e-11,  -3.689351303517708e-13,   1.680104043533983e-14,  -4.328876926281050e-16,
   7.254440326857259e-18,   6.251840684086514e-01,  -5.297746545805692e-03,   4.484674850921134e-05,  -3.758901855945350e-07,   2.922553627551222e-09,  -1.209623829050071e-11,
  -3.717733021720843e-13,   1.686131351679785e-14,  -4.332425398674265e-16,   7.223744151643776e-18,   6.251951931633323e-01,  -5.298026166896264e-03,   4.485108932031690e-05,
  -3.759196298199818e-07,   2.921145990832182e-09,  -1.200775613644242e-11,  -3.747856390047491e-13,   1.692517270611960e-14,  -4.336134304772871e-16,   7.191009474686335e-18,
   6.252039486556046e-01,  -5.298246235214941e-03,   4.485450506531824e-05,  -3.759427509730795e-07,   2.920035546075124e-09,  -1.193804253755087e-11,  -3.771569504258685e-13,
   1.697536109804360e-14,  -4.339012444309762e-16,   7.165128725795325e-18,   6.252090017223636e-01,  -5.298373242967390e-03,   4.485647615943630e-05,  -3.759560739444635e-07,
   2.919393633425703e-09,  -1.189777834058696e-11,  -3.785257140194511e-13,   1.700429802825893e-14,  -4.340657115399272e-16,   7.150145020931216e-18,   6.252108992182606e-01,
  -5.298420936023378e-03,   4.485721628721528e-05,  -3.759610729391545e-07,   2.919152389749130e-09,  -1.188265285560479e-11,  -3.790397422731238e-13,   1.701515887655054e-14,
  -4.341271612530621e-16,   7.144509532498402e-18,   6.252112137563725e-01,  -5.298428841850220e-03,   4.485733897200112e-05,  -3.759619013875885e-07,   2.919112389653180e-09,
  -1.188014527990469e-11,  -3.791249521255516e-13,   1.701695894011410e-14,  -4.341373311018154e-16,   7.143574897143663e-18,   8.272437360377601e-01,  -7.009530660320636e-03,
   5.932241667225661e-05,  -4.962004119659955e-07,   3.790335484916698e-09,  -1.185196545304369e-11,  -6.732018510973912e-13,   2.871224814589435e-14,  -7.549631693114614e-16,
   1.355269839850525e-17,   8.272521845447021e-01,  -7.009742556056356e-03,   5.932564466439085e-05,  -4.962165434587449e-07,   3.788862552137945e-09,  -1.176506261992926e-11,
  -6.762232420592412e-13,   2.878101683851292e-14,  -7.556036784445234e-16,   1.352822548528454e-17,   8.272660544672558e-01,  -7.010090422015512e-03,   5.933094301561208e-05,
  -4.962429360727954e-07,   3.786439825998275e-09,  -1.162224944576025e-11,  -6.811851509756361e-13,   2.889381951353663e-14,  -7.566485363238941e-16,   1.348783115854767e-17,
   8.272807719770584e-01,  -7.010459541215004e-03,   5.933656372344061e-05,  -4.962708184894969e-07,   3.783862779756642e-09,  -1.147051244693845e-11,  -6.864525647332429e-13,
   2.901338603301477e-14,  -7.577481758369813e-16,   1.344467337444093e-17,   8.272923550603919e-01,  -7.010750044681551e-03,   5.934098634208330e-05,  -4.962926735657430e-07,
   3.781830034546398e-09,  -1.135094905601610e-11,  -6.905998089406771e-13,   2.910739405457581e-14,  -7.586070488997197e-16,   1.341049354021596e-17,   8.272990400148617e-01,
  -7.010917701799564e-03,   5.934353835742067e-05,  -4.963052510478885e-07,   3.780655054730883e-09,  -1.128188835990835e-11,  -6.929939682002795e-13,   2.916161114680502e-14,
  -7.591000938403050e-16,   1.339068176294561e-17,   8.273015503064186e-01,  -7.010980659070709e-03,   5.934449659563958e-05,  -4.963099673032215e-07,   3.780213489770393e-09,
  -1.125594436113029e-11,  -6.938931314593643e-13,   2.918196323951554e-14,  -7.592847402166196e-16,   1.338322600592752e-17,   8.273019664244778e-01,  -7.010991095158335e-03,
   5.934465543370348e-05,  -4.963107487357791e-07,   3.780140275679270e-09,  -1.125164319067082e-11,  -6.940421876299220e-13,   2.918533652245368e-14,  -7.593153217759458e-16,
   1.338198925095597e-17,   1.104992115722298e+00,  -9.362774063485157e-03,   7.920632884936596e-05,  -6.594622386269980e-07,   4.820908917003043e-09,  -2.209422199077036e-12,
  -1.514511250727345e-12,   6.105330656393490e-14,  -1.695154934433483e-15,   3.487199058753141e-17,   1.105003395604350e+00,  -9.363055607705928e-03,   7.921042633720928e-05,
  -6.594638156432545e-07,   4.817595007733974e-09,  -2.024115887089253e-12,  -1.521324547646785e-12,   6.123175904254004e-14,  -1.697996980563966e-15,   3.486502410620174e-17,
   1.105021913775260e+00,  -9.363517808241519e-03,   7.921715095585873e-05,  -6.594662127809846e-07,   4.812144145991527e-09,  -1.719520256643251e-12,  -1.532517803340949e-12,
   6.152468835389964e-14,  -1.702652336001971e-15,   3.485312083031365e-17,   1.105041563555216e+00,  -9.364008238880664e-03,   7.922428347803632e-05,  -6.594684954524929e-07,
   4.806346024176481e-09,  -1.395797090957392e-12,  -1.544405740472194e-12,   6.183546820333992e-14,  -1.707577966623961e-15,   3.483985578838554e-17,   1.105057028447473e+00,
  -9.364394210452825e-03,   7.922989476738484e-05,  -6.594701028734517e-07,   4.801772486617968e-09,  -1.140646142790782e-12,  -1.553769580944745e-12,   6.208002329725969e-14,
  -1.711444258588835e-15,   3.482895616327257e-17,   1.105065953704395e+00,  -9.364616962219012e-03,   7.923313233229465e-05,  -6.594709547090901e-07,   4.799128843973764e-09,
  -9.932415826326912e-13,  -1.559176827494401e-12,   6.222114843980332e-14,  -1.713671472483488e-15,   3.482248126959177e-17,   1.105069305258340e+00,  -9.364700607725849e-03,
   7.923434791503224e-05,  -6.594712602408703e-07,   4.798135342492339e-09,  -9.378609839128745e-13,  -1.561207904988463e-12,   6.227413996406646e-14,  -1.714507037774270e-15,
   3.482001499355067e-17,   1.105069860828026e+00,  -9.364714473166056e-03,   7.923454940708671e-05,  -6.594713101304218e-07,   4.797970613858049e-09,  -9.286793418580155e-13,
  -1.561544616935351e-12,   6.228292394197268e-14,  -1.714645503737687e-15,   3.481960433206628e-17,   1.798150789408616e-03,  -1.473776699633002e-05,   1.207547816348697e-07,
  -9.868016828338083e-10,   7.902396660948697e-12,  -5.548661930079163e-14,   8.766834204161326e-17,   1.078485509013537e-17,  -3.678344007145437e-19,   7.834492453474434e-21,
   1.798167987271948e-03,  -1.473818856164266e-05,   1.207615300013041e-07,  -9.868803662587980e-10,   7.902566215148667e-12,  -5.545374896444576e-14,   8.618966662975172e-17,
   1.082493060110864e-17,  -3.684630969602616e-19,   7.832310847987251e-21,   1.798196221043065e-03,  -1.473888065356520e-05,   1.207726086363435e-07,  -9.870095037626758e-10,
   7.902842277523077e-12,  -5.539970046425305e-14,   8.376038430568100e-17,   1.089071221601174e-17,  -3.694928716256427e-19,   7.828630634608680e-21,   1.798226180201235e-03,
  -1.473961504952060e-05,   1.207843640586960e-07,  -9.871464822792954e-10,   7.903132089542610e-12,  -5.534223324623001e-14,   8.118028898105866e-17,   1.096049940248964e-17,
  -3.705823669840238e-19,   7.824591376569278e-21,   1.798249758900301e-03,  -1.474019304683879e-05,   1.207936157345188e-07,  -9.872542514904781e-10,   7.903357919122708e-12,
  -5.529692111956625e-14,   7.914797739249692e-17,   1.101541330031925e-17,  -3.714375021036917e-19,   7.821315206467286e-21,   1.798263366902849e-03,  -1.474052662994925e-05,
   1.207989550960932e-07,  -9.873164337279534e-10,   7.903487345881369e-12,  -5.527073648611302e-14,   7.797438489210735e-17,   1.104710153105040e-17,  -3.719300924668224e-19,
   7.819385467952703e-21,   1.798268476894960e-03,  -1.474065189553031e-05,   1.208009600867201e-07,  -9.873397812267788e-10,   7.903535776021529e-12,  -5.526089744734920e-14,
   7.753355595990478e-17,   1.105900008004663e-17,  -3.721148900644884e-19,   7.818653459637250e-21,   1.798269323952030e-03,  -1.474067266018866e-05,   1.208012924429980e-07,
  -9.873436512743565e-10,   7.903543794993881e-12,  -5.525926614566018e-14,   7.746047522623664e-17,   1.106097239794816e-17,  -3.721455136760242e-19,   7.818531729821356e-21,
   1.623632121738741e-02,  -1.330739859447258e-04,   1.090347637599396e-06,  -8.910068163959256e-09,   7.133931103684565e-11,  -5.001955114842529e-13,   7.560504994991944e-16,
   9.863035441916127e-17,  -3.356774966389987e-18,   7.152970460937902e-20,   1.623647650437655e-02,  -1.330777923544807e-04,   1.090408558401888e-06,  -8.910777435611326e-09,
   7.134076444149847e-11,  -4.998949129074264e-13,   7.425560609215992e-16,   9.899626785745373e-17,  -3.362530326685665e-18,   7.151052956151862e-20,   1.623673143937628e-02,
  -1.330840414105812e-04,   1.090508570607544e-06,  -8.911941508228854e-09,   7.134312955728515e-11,  -4.994006416715820e-13,   7.203863016965221e-16,   9.959689620070433e-17,
  -3.371957481827010e-18,   7.147815032428713e-20,   1.623700195364424e-02,  -1.330906724389547e-04,   1.090614692434537e-06,  -8.913176255327319e-09,   7.134561073199640e-11,
  -4.988751080737104e-13,   6.968401444233232e-16,   1.002341017454753e-16,  -3.381931556040758e-18,   7.144256940349840e-20,   1.623721485597077e-02,  -1.330958913080395e-04,
   1.090698211695047e-06,  -8.914147700504114e-09,   7.134754285916859e-11,  -4.984607331186812e-13,   6.782930543676839e-16,   1.007355065490682e-16,  -3.389760263424197e-18,
   7.141368041929233e-20,   1.623733772854236e-02,  -1.330989033055741e-04,   1.090746412622342e-06,  -8.914708217224003e-09,   7.134864967832938e-11,  -4.982212776933950e-13,
   6.675827048130398e-16,   1.010248448008231e-16,  -3.394269955476820e-18,   7.139665250302773e-20,   1.623738386888277e-02,  -1.331000343568779e-04,   1.090764512611792e-06,
  -8.914918673509640e-09,   7.134906374031580e-11,  -4.981313009195668e-13,   6.635596418571118e-16,   1.011334880365902e-16,  -3.395961798844405e-18,   7.139019114016902e-20,
   1.623739151732932e-02,  -1.331002218456799e-04,   1.090767512947385e-06,  -8.914953558421028e-09,   7.134913229472978e-11,  -4.981163828752614e-13,   6.628926972415685e-16,
   1.011514968819357e-16,  -3.396242162135456e-18,   7.138911653076259e-20,   4.540163584013493e-02,  -3.721147917510011e-04,   3.048927108017322e-06,  -2.491399806590022e-08,
   1.993992437624172e-10,  -1.393957579404424e-12,   1.908078933725977e-15,   2.830497317637927e-16,  -9.592550505259101e-18,   2.046145675621048e-19,   4.540207006728190e-02,
  -3.721254350668656e-04,   3.049097384129308e-06,  -2.491597447163541e-08,   1.994028581717218e-10,  -1.393094972515568e-12,   1.869514065268184e-15,   2.840965651759078e-16,
  -9.609104652911786e-18,   2.045641162227295e-19,   4.540278293895862e-02,  -3.721429084010643e-04,   3.049376922017804e-06,  -2.491921816738716e-08,   1.994087321276995e-10,
  -1.391676603466585e-12,   1.806156259669104e-15,   2.858149054856586e-16,  -9.636220859494538e-18,   2.044787248720236e-19,   4.540353937474471e-02,  -3.721614497863066e-04,
   3.049673536147960e-06,  -2.492265876281964e-08,   1.994148836961906e-10,  -1.390168532676001e-12,   1.738864497233591e-15,   2.876379119533401e-16,  -9.664911409087954e-18,
   2.043846274519769e-19,   4.540413471094543e-02,  -3.721760425527230e-04,   3.049906975057147e-06,  -2.492536564775330e-08,   1.994196662246328e-10,  -1.388979449311148e-12,
   1.685859094508610e-15,   2.890724168723827e-16,  -9.687431647459870e-18,   2.043080439071040e-19,   4.540447829802800e-02,  -3.721844645635664e-04,   3.050041698024955e-06,
  -2.492692749020020e-08,   1.994224027397279e-10,  -1.388292314736143e-12,   1.655250052569903e-15,   2.899002118802227e-16,  -9.700404677674058e-18,   2.042628321886525e-19,
   4.540460731970200e-02,  -3.721876271577423e-04,   3.050092287991242e-06,  -2.492751391066240e-08,   1.994234258710958e-10,  -1.388034120410952e-12,   1.643752542658688e-15,
   2.902110407529875e-16,  -9.705271668888172e-18,   2.042456630669179e-19,   4.540462870696025e-02,  -3.721881514053883e-04,   3.050100674010302e-06,  -2.492761111471728e-08,
   1.994235952345945e-10,  -1.387991312119023e-12,   1.641846480706631e-15,   2.902625642195129e-16,  -9.706078204276742e-18,   2.042428069266589e-19,   8.990512640962919e-02,
  -7.368680627637745e-04,   6.037499711266480e-06,  -4.933126897337731e-08,   3.945802152236780e-10,  -2.745392286405470e-12,   3.127360750708382e-15,   5.834553949844719e-16,
  -1.964952417564885e-17,   4.198408625897904e-19,   8.990598626777352e-02,  -7.368891371162786e-04,   6.037836653275530e-06,  -4.933516082557495e-08,   3.945859514279745e-10,
  -2.743614330834507e-12,   3.048356537042698e-15,   5.856037390405334e-16,  -1.968378710221041e-17,   4.197517068222837e-19,   8.990739789878301e-02,  -7.369237352750467e-04,
   6.038389801371985e-06,  -4.934154808794975e-08,   3.945952460670948e-10,  -2.740690890239587e-12,   2.918560351251601e-15,   5.891302238784709e-16,  -1.973991367284320e-17,
   4.196001018522903e-19,   8.990889579556027e-02,  -7.369604482241459e-04,   6.038976738642232e-06,  -4.934832295977382e-08,   3.946049421411894e-10,  -2.737582589767237e-12,
   2.780703591844351e-15,   5.928715838366148e-16,  -1.979930276636086e-17,   4.194321107878469e-19,   8.991007468235214e-02,  -7.369893426869654e-04,   6.039438664503224e-06,
  -4.935365300215167e-08,   3.946124525631793e-10,  -2.735131777013116e-12,   2.672113472271707e-15,   5.958156739645907e-16,  -1.984592219608931e-17,   4.192947388073806e-19,
   8.991075505466425e-02,  -7.370060187189819e-04,   6.039705252200308e-06,  -4.935672834467270e-08,   3.946167386751540e-10,  -2.733715535712830e-12,   2.609405509033856e-15,
   5.975146109354119e-16,  -1.987277895794170e-17,   4.192133887402699e-19,   8.991101054382099e-02,  -7.370122808241289e-04,   6.039805358766477e-06,  -4.935788302847047e-08,
   3.946183390211813e-10,  -2.733183377272614e-12,   2.585850777775603e-15,   5.981525490342484e-16,  -1.988285481484709e-17,   4.191824496357633e-19,   8.991105289494225e-02,
  -7.370133188624022e-04,   6.039821952875089e-06,  -4.935807442656103e-08,   3.946186038196454e-10,  -2.733095146154504e-12,   2.581945860664888e-15,   5.982582948344102e-16,
  -1.988452455077348e-17,   4.191773003888882e-19,   1.507557449043135e-01,  -1.235602916322147e-03,   1.012377253233558e-05,  -8.271080822709038e-08,   6.609777611129234e-10,
  -4.567066162196050e-12,   3.650234772962645e-15,   1.034739323596090e-15,  -3.456281900174585e-17,   7.404051866809209e-19,   1.507571867265232e-01,  -1.235638250250826e-03,
   1.012433693823607e-05,  -8.271728082300577e-08,   6.609839001537610e-10,  -4.563913338354235e-12,   3.511250050441642e-15,   1.038529000145641e-15,  -3.462400297015715e-17,
   7.402847949656689e-19,   1.507595537691575e-01,  -1.235696258605995e-03,   1.012526350515597e-05,  -8.272790336890772e-08,   6.609937632768248e-10,  -4.558729284311900e-12,
   3.282909123584558e-15,   1.044749852611674e-15,  -3.472423649371397e-17,   7.400779779209608e-19,   1.507620654633525e-01,  -1.235757812662224e-03,   1.012624666867318e-05,
  -8.273917026526556e-08,   6.610039363170776e-10,  -4.553217480918178e-12,   3.040384229193889e-15,   1.051349939393172e-15,  -3.483030623042876e-17,   7.398460542841815e-19,
   1.507640422370951e-01,  -1.235806257988253e-03,   1.012702042665866e-05,  -8.274803414936599e-08,   6.610117306620640e-10,  -4.548871610998354e-12,   2.849344151722705e-15,
   1.056543707490958e-15,  -3.491357632141943e-17,   7.396544925937623e-19,   1.507651830948106e-01,  -1.235834217518884e-03,   1.012746697875877e-05,  -8.275314837725927e-08,
   6.610161439562848e-10,  -4.546360297143699e-12,   2.739022443411551e-15,   1.059540913379608e-15,  -3.496154985948467e-17,   7.395403148217675e-19,   1.507656115025622e-01,
  -1.235844716749144e-03,   1.012763466374426e-05,  -8.275506857616525e-08,   6.610177851264994e-10,  -4.545416663838132e-12,   2.697582561891243e-15,   1.060666351979976e-15,
  -3.497954864598465e-17,   7.394967548274927e-19,   1.507656825175078e-01,  -1.235846457154676e-03,   1.012766245994297e-05,  -8.275538686371604e-08,   6.610180563263080e-10,
  -4.545260210932068e-12,   2.690712623707122e-15,   1.060852907306746e-15,  -3.498253137096133e-17,   7.394894979883148e-19,   2.295040357592982e-01,  -1.881027166197833e-03,
   1.541178759851362e-05,  -1.258952582859236e-07,   1.004816393032157e-09,  -6.874315082163974e-12,   2.120352126748826e-15,   1.697389872591596e-15,  -5.613507245030656e-17,
   1.207255431584000e-18,   2.295062306952396e-01,  -1.881080948056146e-03,   1.541264556412474e-05,  -1.259049971891530e-07,   1.004818234195111e-09,  -6.869143735952566e-12,
   1.894576063278012e-15,   1.703571344364173e-15,  -5.623658228822732e-17,   1.207143794709288e-18,   2.295098341261775e-01,  -1.881169242678241e-03,   1.541405405385294e-05,
  -1.259209798151649e-07,   1.004820907305451e-09,  -6.860640784414087e-12,   1.523637660975130e-15,   1.713718705834594e-15,  -5.640289538347390e-17,   1.206945727069498e-18,
   2.295136577650094e-01,  -1.881262934169832e-03,   1.541554857064099e-05,  -1.259379313247227e-07,   1.004823268494714e-09,  -6.851600352774111e-12,   1.129649120437789e-15,
   1.724485097180711e-15,  -5.657891466214895e-17,   1.206715440414927e-18,   2.295166670758256e-01,  -1.881336672814699e-03,   1.541672476335140e-05,  -1.259512669663595e-07,
   1.004824782521284e-09,  -6.844472350153962e-12,   8.192930520285302e-16,   1.732957741790041e-15,  -5.671711494588131e-17,   1.206519626967690e-18,   2.295184038428026e-01,
  -1.881379230010313e-03,   1.541740356719182e-05,  -1.259589611052921e-07,   1.004825518243018e-09,  -6.840353375316014e-12,   6.400663839498226e-16,   1.737847237612699e-15,
  -5.679674139130580e-17,   1.206400773520330e-18,   2.295190560226616e-01,  -1.881395210883785e-03,   1.541765846478541e-05,  -1.259618499299181e-07,   1.004825768412911e-09,
  -6.838805664160983e-12,   5.727434357663448e-16,   1.739683246935315e-15,  -5.682661700369958e-17,   1.206355037661800e-18,   2.295191641311560e-01,  -1.881397859954091e-03,
   1.541770071771008e-05,  -1.259623287727868e-07,   1.004825808505027e-09,  -6.838549056385661e-12,   5.615825568869313e-16,   1.739987589365228e-15,  -5.683156799930323e-17,
   1.206347397976359e-18,   3.285111079083966e-01,  -2.692491647048227e-03,   2.205995532063960e-05,  -1.801656587323004e-07,   1.435418374635931e-09,  -9.681480073391062e-12,
  -3.945712223439930e-15,   2.679395673568720e-15,  -8.760803864236497e-17,   1.895408525772500e-18,   3.285142496666450e-01,  -2.692568612155374e-03,   2.206118087054472e-05,
  -1.801793671322350e-07,   1.435405760414443e-09,  -9.673317654158909e-12,  -4.298173369412794e-15,   2.689105719945253e-15,  -8.777127863130052e-17,   1.895420841645582e-18,
   3.285194074974775e-01,  -2.692694967052516e-03,   2.206319279999874e-05,  -1.802018632296633e-07,   1.435384506534322e-09,  -9.659896748403692e-12,  -4.877262674722713e-15,
   2.705046205936233e-15,  -8.803876601972976e-17,   1.895418199772071e-18,   3.285248805261721e-01,  -2.692829045095378e-03,   2.206532760015813e-05,  -1.802257218185518e-07,
   1.435361212619935e-09,  -9.645627625409570e-12,  -5.492355485158301e-15,   2.721960074964591e-15,  -8.832191324808798e-17,   1.895384309090033e-18,   3.285291879527215e-01,
  -2.692934569368268e-03,   2.206700768991505e-05,  -1.802444903111223e-07,   1.435342342716667e-09,  -9.634377112617671e-12,  -5.976895389061681e-15,   2.735271183890945e-15,
  -8.854425988538798e-17,   1.895335114506727e-18,   3.285316739026012e-01,  -2.692995471152230e-03,   2.206797729883678e-05,  -1.802553186281346e-07,   1.435331236979691e-09,
  -9.627875949021752e-12,  -6.256716479102511e-15,   2.742953194973940e-15,  -8.867238299583583e-17,   1.895297690567759e-18,   3.285326074109118e-01,  -2.693018340691917e-03,
   2.206834139591785e-05,  -1.802593841358544e-07,   1.435327025912272e-09,  -9.625433133833317e-12,  -6.361826765731384e-15,   2.745837848046368e-15,  -8.872045712694114e-17,
   1.895281929661474e-18,   3.285327621537728e-01,  -2.693022131662045e-03,   2.206840175018300e-05,  -1.802600580185495e-07,   1.435326325717384e-09,  -9.625028119762677e-12,
  -6.379252129447174e-15,   2.746316019573550e-15,  -8.872842412971900e-17,   1.895279226955690e-18,   4.514832971214379e-01,  -3.700371912685888e-03,   3.031689228272028e-05,
  -2.475280919144251e-07,   1.967055808902162e-09,  -1.298998361231782e-11,  -1.943721449207606e-14,   4.188494960751797e-15,  -1.352894629851352e-16,   2.954514603401767e-18,
   4.514876148149172e-01,  -3.700477652788985e-03,   3.031857156665083e-05,  -2.475464696676482e-07,   1.967007841932880e-09,  -1.297722440938534e-11,  -1.998173677066115e-14,
   4.203642155718925e-15,  -1.355526420767249e-16,   2.954958347999488e-18,   4.514947031804422e-01,  -3.700651247932076e-03,   3.032132835141687e-05,  -2.475766265000518e-07,
   1.966928253369723e-09,  -1.295624538760645e-11,  -2.087641205389161e-14,   4.228510109108279e-15,  -1.359839712709109e-16,   2.955652086540045e-18,   4.515022247191242e-01,
  -3.700835453474129e-03,   3.032425346992131e-05,  -2.476086072393306e-07,   1.966842657377469e-09,  -1.293394054609943e-11,  -2.182675506179422e-14,   4.254898736382423e-15,
  -1.364406614837812e-16,   2.956340949077243e-18,   4.515081443797543e-01,  -3.700980429761482e-03,   3.032655552205541e-05,  -2.476337632089292e-07,   1.966774462372931e-09,
  -1.291635431415690e-11,  -2.257542005952971e-14,   4.275667977210034e-15,  -1.367993652630305e-16,   2.956848853075519e-18,   4.515115607998699e-01,  -3.701064100639121e-03,
   3.032788406865670e-05,  -2.476482759789221e-07,   1.966734772628391e-09,  -1.290619204629358e-11,  -2.300778562316517e-14,   4.287654795960618e-15,  -1.370060934990344e-16,
   2.957128243079394e-18,   4.515128437124885e-01,  -3.701095520306601e-03,   3.032838294870707e-05,  -2.476537246789003e-07,   1.966719805760581e-09,  -1.290237357358036e-11,
  -2.317019917018524e-14,   4.292156054846400e-15,  -1.370836677416287e-16,   2.957230560434695e-18,   4.515130563742984e-01,  -3.701100728588424e-03,   3.032846564508896e-05,
  -2.476546278267004e-07,   1.966717321465367e-09,  -1.290174047834531e-11,  -2.319712449260336e-14,   4.292902207591758e-15,  -1.370965239182309e-16,   2.957247384006301e-18,
   6.046678820722524e-01,  -4.955867274147941e-03,   4.060154072494465e-05,  -3.313517542041940e-07,   2.622858613600161e-09,  -1.674730015831074e-11,  -5.522339609112756e-14,
   6.678441588900675e-15,  -2.132055620823392e-16,   4.728854738865510e-18,   6.046736644718853e-01,  -4.956008819070467e-03,   4.060377950635342e-05,  -3.313754147042412e-07,
   2.622730519619821e-09,  -1.672695397476694e-11,  -5.608210140103820e-14,   6.702713726216292e-15,  -2.136481969443462e-16,   4.730615258131744e-18,   6.046831574471585e-01,
  -4.956241195236129e-03,   4.060745474616550e-05,  -3.314142361561579e-07,   2.622518902876821e-09,  -1.669349996373174e-11,  -5.749307411566193e-14,   6.742566486318848e-15,
  -2.143738339801674e-16,   4.733452269697764e-18,   6.046932305408517e-01,  -4.956487774182471e-03,   4.061135434750851e-05,  -3.314554000269166e-07,   2.622292552845244e-09,
  -1.665793137040471e-11,  -5.899194824568120e-14,   6.784861552176210e-15,  -2.151424013101995e-16,   4.736390237842564e-18,   6.047011583453176e-01,  -4.956681840255925e-03,
   4.061442327270546e-05,  -3.314877754137353e-07,   2.622113104068761e-09,  -1.662988707035701e-11,  -6.017281630713211e-14,   6.818153848351089e-15,  -2.157462587465866e-16,
   4.738650022420250e-18,   6.047057337272103e-01,  -4.956793842445720e-03,   4.061619437664100e-05,  -3.315064515388931e-07,   2.622009015235289e-09,  -1.661368145866710e-11,
  -6.085481749233497e-14,   6.837369803235918e-15,  -2.160943512176046e-16,   4.739933162690853e-18,   6.047074518457913e-01,  -4.956835900922937e-03,   4.061685943756576e-05,
  -3.315134630316505e-07,   2.621969829497415e-09,  -1.660759217802764e-11,  -6.111101001082172e-14,   6.844586020491251e-15,  -2.162249866495551e-16,   4.740411018620537e-18,
   6.047077366494454e-01,  -4.956842872746100e-03,   4.061696968060538e-05,  -3.315146252036696e-07,   2.621963328658722e-09,  -1.660658258620441e-11,  -6.115348256092583e-14,
   6.845782234665289e-15,  -2.162466372904427e-16,   4.740490020281592e-18,   8.001184868245702e-01,  -6.557760517175233e-03,   5.372185860420691e-05,  -4.380995427521084e-07,
   3.444528860366476e-09,  -2.067460332068495e-11,  -1.410009395067659e-13,   1.137987312599922e-14,  -3.605228745993662e-16,   8.228222819176638e-18,   8.001261377504838e-01,
  -6.557947654373195e-03,   5.372479788278978e-05,  -4.381286707669453e-07,   3.444210583804392e-09,  -2.063991847849312e-11,  -1.424547624357611e-13,   1.142219274562027e-14,
  -3.613569314873586e-16,   8.234481639581971e-18,   8.001386982860206e-01,  -6.558254879298502e-03,   5.372962298248746e-05,  -4.381764531606909e-07,   3.443685829058052e-09,
  -2.058288617768317e-11,  -1.448438425049976e-13,   1.149168979499063e-14,  -3.627248277117613e-16,   8.244672742819369e-18,   8.001520263960588e-01,  -6.558580880818724e-03,
   5.373474251118993e-05,  -4.382271050535204e-07,   3.443125960667686e-09,  -2.052224608977981e-11,  -1.473820932283191e-13,   1.156546200514363e-14,  -3.641744392948828e-16,
   8.255372309256949e-18,   8.001625159863146e-01,  -6.558837454505915e-03,   5.373877140747532e-05,  -4.382669328992401e-07,   3.442683121976437e-09,  -2.047443192570630e-11,
  -1.493820628290325e-13,   1.162354304859403e-14,  -3.653139596087397e-16,   8.263710288438454e-18,   8.001685698532685e-01,  -6.558985531714931e-03,   5.374109648205437e-05,
  -4.382899041002385e-07,   3.442426660967847e-09,  -2.044680131479681e-11,  -1.505372270141823e-13,   1.165707149942697e-14,  -3.659710635812929e-16,   8.268489138620716e-18,
   8.001708431630574e-01,  -6.559041136843945e-03,   5.374196955548742e-05,  -4.382985273238789e-07,   3.442330189000615e-09,  -2.043641891742986e-11,  -1.509711807513268e-13,
   1.166966341372469e-14,  -3.662177112423355e-16,   8.270277372380695e-18,   8.001712199978841e-01,  -6.559050354225052e-03,   5.374211427910392e-05,  -4.382999566046398e-07,
   3.442314188510630e-09,  -2.043469752621645e-11,  -1.510431241886620e-13,   1.167175079054722e-14,  -3.662585912675761e-16,   8.270573466741823e-18,   1.068760035279716e+00,
  -8.759480036582902e-03,   7.174908632260588e-05,  -5.841715453120429e-07,   4.524497592580023e-09,  -2.313729680394077e-11,  -4.002771857187620e-13,   2.348364071783506e-14,
  -7.517721878053176e-16,   1.834252084132414e-17,   1.068770253460333e+00,  -8.759729546349716e-03,   7.175294447379259e-05,  -5.842038646628671e-07,   4.523606972861240e-09,
  -2.306560066370720e-11,  -4.033178122484115e-13,   2.357842667692092e-14,  -7.539465516862435e-16,   1.837303278913094e-17,   1.068787028654067e+00,  -8.760139166855231e-03,
   7.175927769237445e-05,  -5.842568477315978e-07,   4.522140161104254e-09,  -2.294769457472294e-11,  -4.083157520448886e-13,   2.373414521428142e-14,  -7.575155857522615e-16,
   1.842299859109421e-17,   1.068804828970100e+00,  -8.760573819236043e-03,   7.176599696274439e-05,  -5.843129656624756e-07,   4.520577346573288e-09,  -2.282230798676921e-11,
  -4.136274584537540e-13,   2.389952664254001e-14,  -7.613018649408123e-16,   1.847584656137516e-17,   1.068818838302571e+00,  -8.760915902611289e-03,   7.177128450939769e-05,
  -5.843570574058579e-07,   4.519342755313112e-09,  -2.272342589198815e-11,  -4.178139572012765e-13,   2.402979256557684e-14,  -7.642811391475324e-16,   1.851731507445913e-17,
   1.068826923518695e+00,  -8.761113329488363e-03,   7.177433583330467e-05,  -5.843824741754472e-07,   4.518628384026942e-09,  -2.266627801899640e-11,  -4.202325356499325e-13,
   2.410501555228068e-14,  -7.660003137184646e-16,   1.854119790849238e-17,   1.068829959627311e+00,  -8.761187465975356e-03,   7.177548159363887e-05,  -5.843920128575466e-07,
   4.518359777926354e-09,  -2.264480309489607e-11,  -4.211412023872003e-13,   2.413327083570246e-14,  -7.666458383423242e-16,   1.855015679009049e-17,   1.068830462907332e+00,
  -8.761199755197825e-03,   7.177567151759040e-05,  -5.843935937368346e-07,   4.518315234016302e-09,  -2.264124251003910e-11,  -4.212918515135626e-13,   2.413795499124517e-14,
  -7.667528410354617e-16,   1.855164135886236e-17,   1.741059725780741e-03,  -1.381702894576128e-05,   1.096357703271686e-07,  -8.690450681416584e-10,   6.832295868297299e-12,
  -5.085591372714167e-14,   2.617836634147642e-16,   2.765914141801225e-18,  -1.555361293291997e-19,   4.125420875597118e-21,   1.741075339494059e-03,  -1.381740021566434e-05,
   1.096416071623804e-07,  -8.691173668633597e-10,   6.832847176225506e-12,  -5.084730695542297e-14,   2.611536822521801e-16,   2.787228052536879e-18,  -1.560293156950527e-19,
   4.132119747503716e-21,   1.741100972533059e-03,  -1.381800973760778e-05,   1.096511896101578e-07,  -8.692360479245514e-10,   6.833751260016856e-12,  -5.083313139191315e-14,
   2.601180467828567e-16,   2.822242871816801e-18,  -1.568387909336047e-19,   4.143087822729692e-21,   1.741128171986394e-03,  -1.381865651782216e-05,   1.096613577871269e-07,
  -8.693619654573995e-10,   6.834709233226405e-12,  -5.081802726588945e-14,   2.590172286452694e-16,   2.859429655312952e-18,  -1.576974727914721e-19,   4.154686023100519e-21,
   1.741149578691271e-03,  -1.381916555920421e-05,   1.096693605281055e-07,  -8.694610543307567e-10,   6.835462199586521e-12,  -5.080609477827313e-14,   2.581494826531878e-16,
   2.888719951629264e-18,  -1.583730882793257e-19,   4.163785006530237e-21,   1.741161933156633e-03,  -1.381945934573999e-05,   1.096739791995196e-07,  -8.695182368882261e-10,
   6.835896364630818e-12,  -5.079919007577459e-14,   2.576481298254863e-16,   2.905633600305223e-18,  -1.587629296357411e-19,   4.169024618096447e-21,   1.741166572426097e-03,
  -1.381956966716886e-05,   1.096757135817116e-07,  -8.695397088317962e-10,   6.836059324820161e-12,  -5.079659384466594e-14,   2.574597610827121e-16,   2.911986664905256e-18,
  -1.589093057062519e-19,   4.170989951305065e-21,   1.741167341453783e-03,  -1.381958795461255e-05,   1.096760010817119e-07,  -8.695432680781388e-10,   6.836086333946754e-12,
  -5.079616330034924e-14,   2.574285306876706e-16,   2.913039872337556e-18,  -1.589335689347329e-19,   4.171315617663162e-21,   1.572082007534528e-02,  -1.247602338421262e-04,
   9.899505593645674e-07,  -7.846936011357812e-09,   6.168699127022253e-11,  -4.589213498406352e-13,   2.350945678333409e-15,   2.545634372099500e-17,  -1.419359985986586e-18,
   3.763118614181534e-20,   1.572096105855937e-02,  -1.247635861768131e-04,   9.900032584477804e-07,  -7.847588418738245e-09,   6.169194119715207e-11,  -4.588421644067002e-13,
   2.345196679155005e-15,   2.565077108742677e-17,  -1.423862746048865e-18,   3.769253438783667e-20,   1.572119251075425e-02,  -1.247690897780722e-04,   9.900897755573866e-07,
  -7.848659368326012e-09,   6.170005838387862e-11,  -4.587117476689801e-13,   2.335745807011896e-15,   2.597018024349580e-17,  -1.431253242464279e-18,   3.779298200911190e-20,
   1.572143810680542e-02,  -1.247749297980000e-04,   9.901815810204614e-07,  -7.849795615961494e-09,   6.170865921311637e-11,  -4.585727929439341e-13,   2.325700090470634e-15,
   2.630940352540749e-17,  -1.439093047781169e-18,   3.789920319305628e-20,   1.572163139753479e-02,  -1.247795261224817e-04,   9.902538353852272e-07,  -7.850689767074118e-09,
   6.171541931748485e-11,  -4.584630201394659e-13,   2.317781310016422e-15,   2.657659478081740e-17,  -1.445261487209324e-18,   3.798253750818846e-20,   1.572174295153764e-02,
  -1.247821788306282e-04,   9.902955359869487e-07,  -7.851205766335850e-09,   6.171931717821703e-11,  -4.583995018040561e-13,   2.313206117281819e-15,   2.673088442594748e-17,
  -1.448820794682949e-18,   3.803052603315735e-20,   1.572178484158009e-02,  -1.247831749639244e-04,   9.903111952033223e-07,  -7.851399522977129e-09,   6.172078019657330e-11,
  -4.583756185962196e-13,   2.311487121207360e-15,   2.678883840364985e-17,  -1.450157232120675e-18,   3.804852626901876e-20,   1.572179178547561e-02,  -1.247833400880684e-04,
   9.903137909544864e-07,  -7.851431640585890e-09,   6.172102267760594e-11,  -4.583716579537947e-13,   2.311202122059200e-15,   2.679844598461995e-17,  -1.450378759515231e-18,
   3.805150901368892e-20,   4.396013985281223e-02,  -3.488671017255132e-04,   2.768195542574510e-06,  -2.194200463767745e-08,   1.724669608091649e-10,  -1.281663250233577e-12,
   6.499731301057516e-15,   7.397533772674110e-17,  -4.055743567232671e-18,   1.074424700703626e-19,   4.396053408366686e-02,  -3.488764756872805e-04,   2.768342879871430e-06,
  -2.194382658900166e-08,   1.724806396753911e-10,  -1.281433297223577e-12,   6.483303563786388e-15,   7.453049468701297e-17,  -4.068623543492622e-18,   1.076190661497310e-19,
   4.396118129260451e-02,  -3.488918651248291e-04,   2.768584766276405e-06,  -2.194681737682779e-08,   1.725030702606999e-10,  -1.281054589924073e-12,   6.456297702687259e-15,
   7.544252293885815e-17,  -4.089764012731633e-18,   1.079082250224360e-19,   4.396186805195273e-02,  -3.489081952716166e-04,   2.768841437837880e-06,  -2.194999050682539e-08,
   1.725268361743745e-10,  -1.280651117522689e-12,   6.427592019744722e-15,   7.641113490194472e-17,  -4.112190042232485e-18,   1.082140205718070e-19,   4.396240855011643e-02,
  -3.489210477361855e-04,   2.769043447946267e-06,  -2.195248753949057e-08,   1.725455149458877e-10,  -1.280332398460805e-12,   6.404964027248556e-15,   7.717407317960318e-17,
  -4.129835301126395e-18,   1.084539399623810e-19,   4.396272048816788e-02,  -3.489284653665668e-04,   2.769160035231096e-06,  -2.195392853056526e-08,   1.725562847497258e-10,
  -1.280147984588928e-12,   6.391890353391270e-15,   7.761463414891123e-17,  -4.140017044453439e-18,   1.085921036355418e-19,   4.396283762514067e-02,  -3.489312508024484e-04,
   2.769203815539559e-06,  -2.195446961900839e-08,   1.725603270118810e-10,  -1.280078645567485e-12,   6.386978296314500e-15,   7.778011720494616e-17,  -4.143840070348785e-18,
   1.086439289848711e-19,   4.396285704233033e-02,  -3.489317125305270e-04,   2.769211072785243e-06,  -2.195455931121094e-08,   1.725609969741049e-10,  -1.280067146895371e-12,
   6.386163906812721e-15,   7.780755092286997e-17,  -4.144473774676520e-18,   1.086525167969918e-19,   8.705065105604375e-02,  -6.908327637062473e-04,   5.481617895415607e-06,
  -4.344872993304265e-08,   3.414328067767128e-10,  -2.532875972271452e-12,   1.263686978252086e-14,   1.553055544777405e-16,  -8.306003595372757e-18,   2.197907483594261e-19,
   8.705143171710511e-02,  -6.908513256456373e-04,   5.481909576160020e-06,  -4.345233031295978e-08,   3.414593811233982e-10,  -2.532393678738337e-12,   1.260322538457051e-14,
   1.564413435762336e-16,  -8.332430548849839e-18,   2.201567082313917e-19,   8.705271332864532e-02,  -6.908817991841775e-04,   5.482388433594989e-06,  -4.345824041580505e-08,
   3.415029550148664e-10,  -2.531599456162763e-12,   1.254791659279376e-14,   1.583072688679415e-16,  -8.375807020033997e-18,   2.207559706575215e-19,   8.705407325841039e-02,
  -6.909141354737350e-04,   5.482896560463394e-06,  -4.346451080606576e-08,   3.415491192735278e-10,  -2.530753380105571e-12,   1.248912631992836e-14,   1.602889828773584e-16,
  -8.421822258542806e-18,   2.213897643790315e-19,   8.705514355987314e-02,  -6.909395853967330e-04,   5.483296474980939e-06,  -4.346944513863965e-08,   3.415853993252795e-10,
  -2.530085091026779e-12,   1.244278323323513e-14,   1.618499197202250e-16,  -8.458028734309022e-18,   2.218870612245281e-19,   8.705576126363858e-02,  -6.909542734831430e-04,
   5.483527279878974e-06,  -4.347229263866894e-08,   3.416063166072093e-10,  -2.529698436752002e-12,   1.241600773817734e-14,   1.627512942106906e-16,  -8.478921049752226e-18,
   2.221734577107750e-19,   8.705599321978702e-02,  -6.909597890884670e-04,   5.483613950624278e-06,  -4.347336186544046e-08,   3.416141673503948e-10,  -2.529553060539435e-12,
   1.240594760483397e-14,   1.630898688671118e-16,  -8.486765721902572e-18,   2.222808882865642e-19,   8.705603166995707e-02,  -6.909607033833677e-04,   5.483628317604770e-06,
  -4.347353910308710e-08,   3.416154685174403e-10,  -2.529528952659789e-12,   1.240427969469434e-14,   1.631459977132228e-16,  -8.488066056827868e-18,   2.222986904169390e-19,
   1.459692723300834e-01,  -1.158409939133960e-03,   9.191719991759308e-06,  -7.285324335631690e-08,   5.723081725244174e-10,  -4.234796465703551e-12,   2.061877708194193e-14,
   2.820012301599483e-16,  -1.460240019511392e-17,   3.858947653481548e-19,   1.459705813625472e-01,  -1.158441063052331e-03,   9.192208898730561e-06,  -7.285926236881507e-08,
   5.723514815331855e-10,  -4.233921810332019e-12,   2.055962540651427e-14,   2.839957032599198e-16,  -1.464900382197607e-17,   3.865493931973657e-19,   1.459727304015846e-01,
  -1.158492159858585e-03,   9.193011545176922e-06,  -7.286914263928979e-08,   5.724224885043836e-10,  -4.232481602503266e-12,   2.046238420288437e-14,   2.872723579349174e-16,
  -1.472549965996581e-17,   3.876214504386232e-19,   1.459750107665980e-01,  -1.158546380043253e-03,   9.193863251117441e-06,  -7.287962512709515e-08,   5.724977075438947e-10,
  -4.230947557283905e-12,   2.035902146016057e-14,   2.907524040871627e-16,  -1.480665168080251e-17,   3.887554171635221e-19,   1.459768054754457e-01,  -1.158589053440929e-03,
   9.194533574228274e-06,  -7.288787399834885e-08,   5.725568148426539e-10,  -4.229736000891709e-12,   2.027754245577792e-14,   2.934935764764565e-16,  -1.487050697072316e-17,
   3.896452649879199e-19,   1.459778412568987e-01,  -1.158613681825671e-03,   9.194920441241514e-06,  -7.289263422115973e-08,   5.725908905220283e-10,  -4.229035081759255e-12,
   2.023046642883089e-14,   2.950765043904702e-16,  -1.490735431717532e-17,   3.901577734181137e-19,   1.459782302068922e-01,  -1.158622930167488e-03,   9.195065715623929e-06,
  -7.289442166364598e-08,   5.726036794141680e-10,  -4.228771557069111e-12,   2.021277891448994e-14,   2.956710877711928e-16,  -1.492118994856458e-17,   3.903500285962573e-19,
   1.459782946811192e-01,  -1.158624463219827e-03,   9.195089797036248e-06,  -7.289471795420685e-08,   5.726057989938888e-10,  -4.228727857059698e-12,   2.020984642838279e-14,
   2.957696578745348e-16,  -1.492348335410919e-17,   3.903818872543508e-19,   2.222173198345526e-01,  -1.763512891696450e-03,   1.399301517734012e-05,  -1.109023432835766e-07,
   8.707939794175729e-10,  -6.420316460536588e-12,   3.016306014418386e-14,   4.758125612129278e-16,  -2.369090449784737e-17,   6.252631831829658e-19,   2.222193126393394e-01,
  -1.763560270583109e-03,   1.399375905737794e-05,  -1.109114673760424e-07,   8.708572234491594e-10,  -6.418842803222611e-12,   3.006708462777751e-14,   4.790449466453732e-16,
  -2.376689349096183e-17,   6.263517581134400e-19,   2.222225842275859e-01,  -1.763638053508289e-03,   1.399498029555388e-05,  -1.109264445135831e-07,   8.709608998485764e-10,
  -6.416416555293323e-12,   2.990930651413445e-14,   4.843554302273511e-16,  -2.389162730606886e-17,   6.281346960287040e-19,   2.222260557397900e-01,  -1.763720591029353e-03,
   1.399627617620189e-05,  -1.109423343213911e-07,   8.710707059491355e-10,  -6.413832599075266e-12,   2.974159443604085e-14,   4.899956913297861e-16,  -2.402395950278871e-17,
   6.300208999991827e-19,   2.222287879136004e-01,  -1.763785551261984e-03,   1.399729607909507e-05,  -1.109548381653736e-07,   8.711569771135812e-10,  -6.411792115743409e-12,
   2.960938891080197e-14,   4.944385295311890e-16,  -2.412809080266791e-17,   6.315012656620600e-19,   2.222303647347830e-01,  -1.763823042192727e-03,   1.399788470022310e-05,
  -1.109620537686221e-07,   8.712067069913391e-10,  -6.410611747345923e-12,   2.953300424501165e-14,   4.970041487050931e-16,  -2.418818095433561e-17,   6.323539722264436e-19,
   2.222309568525347e-01,  -1.763837120619866e-03,   1.399810573618597e-05,  -1.109647631840466e-07,   8.712253699168482e-10,  -6.410167984408710e-12,   2.950430473789608e-14,
   4.979678607723475e-16,  -2.421074424557766e-17,   6.326738613934659e-19,   2.222310550048291e-01,  -1.763839454331749e-03,   1.399814237621236e-05,  -1.109652123023472e-07,
   8.712284629761644e-10,  -6.410094396762848e-12,   2.949954652362126e-14,   4.981276254800851e-16,  -2.421448437264078e-17,   6.327268712053838e-19,   3.180809399020293e-01,
  -2.524284165498030e-03,   2.002941873478647e-05,  -1.587326001376707e-07,   1.245523385762838e-09,  -9.136645225551915e-12,   4.070003492062287e-14,   7.754697108499149e-16,
  -3.689600729282265e-17,   9.729116630047827e-19,   3.180837923750705e-01,  -2.524351977802841e-03,   2.003048269881689e-05,  -1.587455819352938e-07,   1.245608485125443e-09,
  -9.134247273758992e-12,   4.055054323739806e-14,   7.805009821697076e-16,  -3.701531878301043e-17,   9.746673931740584e-19,   3.180884752808721e-01,  -2.524463306680446e-03,
   2.003222941997009e-05,  -1.587668911576558e-07,   1.245747957541668e-09,  -9.130299749599722e-12,   4.030478489415421e-14,   7.887670830617868e-16,  -3.721117504649582e-17,
   9.775435260248103e-19,   3.180934443549183e-01,  -2.524581440666440e-03,   2.003408289672126e-05,  -1.587894984865102e-07,   1.245895633009945e-09,  -9.126096302103164e-12,
   4.004354940260372e-14,   7.975468149282806e-16,  -3.741897554370385e-17,   9.805869032092527e-19,   3.180973551502340e-01,  -2.524674416674472e-03,   2.003554164372527e-05,
  -1.588072881043993e-07,   1.246011625687159e-09,  -9.122777431264615e-12,   3.983761767010522e-14,   8.044628425458175e-16,  -3.758250197578233e-17,   9.829759437773674e-19,
   3.180996121899491e-01,  -2.524728076526166e-03,   2.003638353559385e-05,  -1.588175538495683e-07,   1.246078475582709e-09,  -9.120857740681242e-12,   3.971863494790972e-14,
   8.084567524238920e-16,  -3.767687063389829e-17,   9.843522502163104e-19,   3.181004597389836e-01,  -2.524748226632571e-03,   2.003669967822461e-05,  -1.588214085514272e-07,
   1.246103561033182e-09,  -9.120136063791734e-12,   3.967393014378181e-14,   8.099569840678044e-16,  -3.771230591631299e-17,   9.848686022322738e-19,   3.181006002327991e-01,
  -2.524751566816879e-03,   2.003675208359455e-05,  -1.588220475135378e-07,   1.246107718390154e-09,  -9.120016392570231e-12,   3.966651833164228e-14,   8.102056941844551e-16,
  -3.771817976373812e-17,   9.849541704380977e-19,   4.371487969258603e-01,  -3.469202826851055e-03,   2.752682733217741e-05,  -2.181267214323682e-07,   1.709938553422849e-09,
  -1.245124848903602e-11,   5.100947383570446e-14,   1.255031172231836e-15,  -5.674949294689453e-17,   1.496798963944971e-18,   4.371527171328920e-01,  -3.469296012433026e-03,
   2.752828795312355e-05,  -2.181444076474947e-07,   1.710044701267663e-09,  -1.244737397677167e-11,   5.077948944906989e-14,   1.262775424767247e-15,  -5.693550308021770e-17,
   1.499640127188553e-18,   4.371591529377141e-01,  -3.469448997101507e-03,   2.753068586350324e-05,  -2.181734383959118e-07,   1.710218603247836e-09,  -1.244099656060168e-11,
   5.040139712464370e-14,   1.275499321937267e-15,  -5.724087075902645e-17,   1.504295421676689e-18,   4.371659820286563e-01,  -3.469611333071687e-03,   2.753323031957897e-05,
  -2.182042367689566e-07,   1.710402641195952e-09,  -1.243420681501856e-11,   4.999948383667038e-14,   1.289014548928076e-15,  -5.756489110557775e-17,   1.509222874959300e-18,
   4.371713567072703e-01,  -3.469739097700136e-03,   2.753523288338172e-05,  -2.182284712645772e-07,   1.710547128160183e-09,  -1.242884672176658e-11,   4.968264879473585e-14,
   1.299661362216176e-15,  -5.781989722061092e-17,   1.513091968088172e-18,   4.371744585987877e-01,  -3.469812835316729e-03,   2.753638862753426e-05,  -2.182424558657241e-07,
   1.710630373248812e-09,  -1.242574667877579e-11,   4.949958577978987e-14,   1.305809953779608e-15,  -5.796706613722721e-17,   1.515321346516360e-18,   4.371756234011231e-01,
  -3.469840524931572e-03,   2.753682262575764e-05,  -2.182477069197749e-07,   1.710661605911932e-09,  -1.242458132859576e-11,   4.943080385627373e-14,   1.308119586833032e-15,
  -5.802232947930441e-17,   1.516157828184116e-18,   4.371758164843751e-01,  -3.469845114903023e-03,   2.753689456742853e-05,  -2.182485773411682e-07,   1.710666781764256e-09,
  -1.242438808900111e-11,   4.941940016085420e-14,   1.308502482483281e-15,  -5.803149016591386e-17,   1.516296451514299e-18,   5.854698282460762e-01,  -4.646272073004929e-03,
   3.686597197418235e-05,  -2.920860565490584e-07,   2.286420916815356e-09,  -1.646088770974364e-11,   5.818913771955256e-14,   2.074354320442219e-15,  -8.874054602134568e-17,
   2.347495644585522e-18,   5.854750784720093e-01,  -4.646396853536242e-03,   3.686792489848188e-05,  -2.921094274417892e-07,   2.286540845317367e-09,  -1.645449409767409e-11,
   5.782936062880300e-14,   2.086509249025266e-15,  -8.903834961079697e-17,   2.352295676072815e-18,   5.854836977688258e-01,  -4.646601708178118e-03,   3.687113101252703e-05,
  -2.921477878882271e-07,   2.286737168987372e-09,  -1.644397161011121e-11,   5.723787028653961e-14,   2.106481211127669e-15,  -8.952729933071508e-17,   2.360163162603700e-18,
   5.854928437824696e-01,  -4.646819084578123e-03,   3.687453304601266e-05,  -2.921884822253704e-07,   2.286944723966210e-09,  -1.643277062009353e-11,   5.660908710402948e-14,
   2.127697009086830e-15,  -9.004618863173410e-17,   2.368494078876587e-18,   5.855000419413405e-01,  -4.646990168036327e-03,   3.687721053555048e-05,  -2.922205023101808e-07,
   2.287107520275013e-09,  -1.642392943278393e-11,   5.611338699555839e-14,   2.144411311895259e-15,  -9.045461096921808e-17,   2.375038137737466e-18,   5.855041962189806e-01,
  -4.647088906486904e-03,   3.687875579565427e-05,  -2.922389790888677e-07,   2.287201252331903e-09,  -1.641881660351796e-11,   5.582697025453897e-14,   2.154064414296956e-15,
  -9.069034063174025e-17,   2.378809852352510e-18,   5.855057562065519e-01,  -4.647125984293966e-03,   3.687933606157670e-05,  -2.922459168038522e-07,   2.287236407880951e-09,
  -1.641689471757560e-11,   5.571935393466251e-14,   2.157690563333086e-15,  -9.077886341392673e-17,   2.380225224067650e-18,   5.855060147976128e-01,  -4.647132130499540e-03,
   3.687943224924322e-05,  -2.922470668030725e-07,   2.287242233212292e-09,  -1.641657603364990e-11,   5.570151161366176e-14,   2.158291718691917e-15,  -9.079353753939841e-17,
   2.380459792318306e-18,   7.747149792461814e-01,  -6.148109680765666e-03,   4.878134455041821e-05,  -3.863908348433896e-07,   3.017304822614122e-09,  -2.129907609836239e-11,
   5.392566191378882e-14,   3.657348680644852e-15,  -1.476177643846029e-16,   3.942983959199700e-18,   7.747219263719957e-01,  -6.148274746255889e-03,   4.878392146647975e-05,
  -3.864210496500815e-07,   3.017412802455891e-09,  -2.128781908981808e-11,   5.332670261735928e-14,   3.677792410186531e-15,  -1.481360672743893e-16,   3.952071201949803e-18,
   7.747333314688511e-01,  -6.148545737281727e-03,   4.878815195573721e-05,  -3.864706404314472e-07,   3.017589138997246e-09,  -2.126929457083904e-11,   5.234191975803169e-14,
   3.711387627096033e-15,  -1.489872051438184e-16,   3.966973030828599e-18,   7.747454335189865e-01,  -6.148833292355819e-03,   4.879264091915675e-05,  -3.865232441382210e-07,
   3.017774980688042e-09,  -2.124957835314218e-11,   5.129495782293684e-14,   3.747080280356342e-15,  -1.498906789389266e-16,   3.982762716667248e-18,   7.747549581573498e-01,
  -6.149059608868796e-03,   4.879617381995619e-05,  -3.865646319675052e-07,   3.017920322176344e-09,  -2.123401791681299e-11,   5.046952230703581e-14,   3.775203525787732e-15,
  -1.506019696554947e-16,   3.995173065803810e-18,   7.747604551171480e-01,  -6.149190224224673e-03,   4.879821275126313e-05,  -3.865885130510223e-07,   3.018003833724288e-09,
  -2.122502016958867e-11,   4.999255758723391e-14,   3.791447195830642e-15,  -1.510125698788968e-16,   4.002328798763105e-18,   7.747625193000125e-01,  -6.149239272283384e-03,
   4.879897839499182e-05,  -3.865974797571778e-07,   3.018035123571141e-09,  -2.122163811426383e-11,   4.981334111213644e-14,   3.797549348442687e-15,  -1.511667732577693e-16,
   4.005014612285411e-18,   7.747628614689130e-01,  -6.149247402737775e-03,   4.879910531164934e-05,  -3.865989660707239e-07,   3.018040306640059e-09,  -2.122107731544325e-11,
   4.978362753475855e-14,   3.798560999073707e-15,  -1.511923356709719e-16,   4.005459759086787e-18,   1.034827391390928e+00,  -8.212334540854011e-03,   6.515692660850153e-05,
  -5.158218943652483e-07,   4.007172142940804e-09,  -2.704696250415437e-11,   3.021723696915048e-15,   7.708900256696487e-15,  -2.946575323813027e-16,   8.122044446580861e-18,
   1.034836670580690e+00,  -8.212554891820158e-03,   6.516034805723878e-05,  -5.158601833404592e-07,   4.007164327145437e-09,  -2.702324842866423e-11,   1.823670224440160e-15,
   7.751145574016795e-15,  -2.958108058096919e-16,   8.145722245920777e-18,   1.034851904224813e+00,  -8.212916645371512e-03,   6.516596490986191e-05,  -5.159230162175488e-07,
   4.007149635034357e-09,  -2.698422627030920e-11,  -1.464578502613204e-16,   7.820585725726548e-15,  -2.977054673577497e-16,   8.184586386397862e-18,   1.034868068777586e+00,
  -8.213300509854244e-03,   6.517192481148213e-05,  -5.159896531725619e-07,   4.007131513179898e-09,  -2.694269605862215e-11,  -2.241443137869494e-15,   7.894386171243064e-15,
  -2.997177172145936e-16,   8.225814845021045e-18,   1.034880790712370e+00,  -8.213602624804786e-03,   6.517661527537561e-05,  -5.160420724498241e-07,   4.007115415438926e-09,
  -2.690992120597336e-11,  -3.893487047151015e-15,   7.952553713905438e-15,  -3.013027179180919e-16,   8.258254930205293e-18,   1.034888132928725e+00,  -8.213776985893427e-03,
   6.517932222963540e-05,  -5.160723148629910e-07,   4.007105388526746e-09,  -2.689096995078235e-11,  -4.848229031192114e-15,   7.986157891362225e-15,  -3.022179928890501e-16,
   8.276973919652644e-18,   1.034890890030252e+00,  -8.213842461093490e-03,   6.518033871706946e-05,  -5.160836693403454e-07,   4.007101484010803e-09,  -2.688384671177027e-11,
  -5.206992781915731e-15,   7.998783124230105e-15,  -3.025617897171809e-16,   8.284002548824894e-18,   1.034891347060682e+00,  -8.213853314591384e-03,   6.518050721436831e-05,
  -5.160855514098829e-07,   4.007100829430004e-09,  -2.688266557127357e-11,  -5.266476127460502e-15,   8.000876281772314e-15,  -3.026187843395795e-16,   8.285167616241935e-18,
   1.687482259494809e-03,  -1.297987354995554e-05,   9.983072181506472e-08,  -7.675061380452282e-10,   5.881883031670566e-12,  -4.408834481769342e-14,   2.880710787154901e-16,
  -3.548676457459330e-19,  -5.332365875955664e-20,   1.793524511064319e-21,   1.687496476246487e-03,  -1.298020143692763e-05,   9.983574749406369e-08,  -7.675688865538378e-10,
   5.882495354127291e-12,  -4.408925588109481e-14,   2.878531193695450e-16,  -3.455343455019937e-19,  -5.358771931391916e-20,   1.798925633318925e-21,   1.687519815863423e-03,
  -1.298073973583861e-05,   9.984399833681673e-08,  -7.676718992638185e-10,   5.883500241361489e-12,  -4.409073128472560e-14,   2.874945415966468e-16,  -3.301922397621364e-19,
  -5.402151759614766e-20,   1.807790174924746e-21,   1.687544581705275e-03,  -1.298131093892991e-05,   9.985275363139483e-08,  -7.677812048927492e-10,   5.884566042767572e-12,
  -4.409226925079803e-14,   2.871130264514543e-16,  -3.138859260337494e-19,  -5.448221821529758e-20,   1.817193011292428e-21,   1.687564073063008e-03,  -1.298176049783789e-05,
   9.985964446538117e-08,  -7.678672298439669e-10,   5.885404499344211e-12,  -4.409345967167929e-14,   2.868120212622060e-16,  -3.010331150883466e-19,  -5.484508614702663e-20,
   1.824590800377911e-21,   1.687575322111162e-03,  -1.298201995472030e-05,   9.986362144916601e-08,  -7.679168768619887e-10,   5.885888254685959e-12,  -4.409413867714478e-14,
   2.866380042152821e-16,  -2.936076285632293e-19,  -5.505462201483921e-20,   1.828859280856104e-21,   1.687579546279251e-03,  -1.298211738480481e-05,   9.986511487423490e-08,
  -7.679355198741913e-10,   5.886069884214790e-12,  -4.409439213580031e-14,   2.865726021645378e-16,  -2.908177956591820e-19,  -5.513332703611156e-20,   1.830461961162348e-21,
   1.687580246497614e-03,  -1.298213353531214e-05,   9.986536243229952e-08,  -7.679386102236439e-10,   5.886099990567893e-12,  -4.409443407027809e-14,   2.865617578353787e-16,
  -2.903552623810912e-19,  -5.514637469150831e-20,   1.830727619022228e-21,   1.523704477608485e-02,  -1.172011801989824e-04,   9.014167919791391e-07,  -6.930141666042930e-09,
   5.310866135338467e-11,  -3.980029942142912e-13,   2.596783505522584e-15,  -3.032269801703186e-18,  -4.871928565617548e-19,   1.635369447599307e-20,   1.523717314557056e-02,
  -1.172041408304301e-04,   9.014621697551065e-07,  -6.930708117296327e-09,   5.311418074753210e-11,  -3.980106933404947e-13,   2.594792204797411e-15,  -2.947165340777126e-18,
  -4.896011106449056e-19,   1.640300471055432e-20,   1.523738388953574e-02,  -1.172090013610585e-04,   9.015366681193150e-07,  -6.931638046082114e-09,   5.312323862756994e-11,
  -3.980231480141099e-13,   2.591516210694520e-15,  -2.807270154913206e-18,  -4.935573992734622e-19,   1.648393515381626e-20,   1.523760751153103e-02,  -1.172141589975185e-04,
   9.016157212630680e-07,  -6.932624782323254e-09,   5.313284552105654e-11,  -3.980361121615589e-13,   2.588030675454230e-15,  -2.658582640713299e-18,  -4.977590571283872e-19,
   1.656978071011826e-20,   1.523778350782178e-02,  -1.172182182566971e-04,   9.016779398479550e-07,  -6.933401356036205e-09,   5.314040313863478e-11,  -3.980461329503345e-13,
   2.585280693763272e-15,  -2.541385325473825e-18,  -5.010684786501483e-19,   1.663732115732672e-20,   1.523788508056883e-02,  -1.172205610035658e-04,   9.017138487506597e-07,
  -6.933849534732859e-09,   5.314476356016639e-11,  -3.980518431073941e-13,   2.583690879760873e-15,  -2.473676537649262e-18,  -5.029794887847403e-19,   1.667629178537935e-20,
   1.523792322249433e-02,  -1.172214407413567e-04,   9.017273331540782e-07,  -6.934017830820165e-09,   5.314640070964565e-11,  -3.980539735168911e-13,   2.583093369676877e-15,
  -2.448237621192033e-18,  -5.036972956676583e-19,   1.669092406774235e-20,   1.523792954508284e-02,  -1.172215865711762e-04,   9.017295684003236e-07,  -6.934045728333474e-09,
   5.314667207835343e-11,  -3.980543259339908e-13,   2.582994296438828e-15,  -2.444020039585357e-18,  -5.038162931669246e-19,   1.669334949460046e-20,   4.260735871361958e-02,
  -3.277297330884150e-04,   2.520631250996222e-06,  -1.937864262919153e-08,   1.484989165211620e-10,  -1.112411682556320e-12,   7.236276464793801e-15,  -7.483423246280858e-18,
  -1.395425218676338e-18,   4.665336039098207e-20,   4.260771767312205e-02,  -3.277380118513673e-04,   2.520758133015387e-06,  -1.938022582516709e-08,   1.485142951999028e-10,
  -1.112430158847907e-12,   7.230573456827390e-15,  -7.240629639489898e-18,  -1.402298550707243e-18,   4.679440077546209e-20,   4.260830697632258e-02,  -3.277516032695799e-04,
   2.520966439860117e-06,  -1.938282491504662e-08,   1.485395329155848e-10,  -1.112459963769473e-12,   7.221191205222519e-15,  -6.841522792040979e-18,  -1.413590159327423e-18,
   4.702588620386897e-20,   4.260893229034839e-02,  -3.277660254793924e-04,   2.521187482398021e-06,  -1.938558277372899e-08,   1.485663000046971e-10,  -1.112490872370278e-12,
   7.211208932884369e-15,  -6.417330457933700e-18,  -1.425582174204434e-18,   4.727143419734937e-20,   4.260942442864977e-02,  -3.277773763155326e-04,   2.521361453357335e-06,
  -1.938775323974414e-08,   1.485873570865881e-10,  -1.112514678185791e-12,   7.203333289267550e-15,  -6.082975528111328e-18,  -1.435027716486470e-18,   4.746462604601550e-20,
   4.260970845644901e-02,  -3.277839272979326e-04,   2.521461859135204e-06,  -1.938900586475690e-08,   1.485995060253453e-10,  -1.112528208619493e-12,   7.198780264368007e-15,
  -5.889807020556638e-18,  -1.440482030240610e-18,   4.757609826619578e-20,   4.260981511268768e-02,  -3.277863872934274e-04,   2.521499563209148e-06,  -1.938947623914974e-08,
   1.486040674077724e-10,  -1.112533250029081e-12,   7.197069076591025e-15,  -5.817231441833550e-18,  -1.442530765826758e-18,   4.761795289800682e-20,   4.260983279253737e-02,
  -3.277867950748160e-04,   2.521505813236331e-06,  -1.938955421050362e-08,   1.486048234871121e-10,  -1.112534083635741e-12,   7.196785344550277e-15,  -5.805198949650950e-18,
  -1.442870404001842e-18,   4.762489067502819e-20,   8.437184995992730e-02,  -6.489762273291047e-04,   4.991395287996801e-06,  -3.837356528985871e-08,   2.940323514779498e-10,
  -2.201169261630407e-12,   1.425037145356822e-14,  -1.168020360740333e-17,  -2.867731390891734e-18,   9.530675890738787e-20,   8.437256077736394e-02,  -6.489926209172591e-04,
   4.991646517266147e-06,  -3.837669793578970e-08,   2.940626308409308e-10,  -2.201196224972869e-12,   1.423865273972788e-14,  -1.118417462807948e-17,  -2.881783859611469e-18,
   9.559611276609092e-20,   8.437372772512980e-02,  -6.490195346128942e-04,   4.992058969425782e-06,  -3.838184070564891e-08,   2.941123210810938e-10,  -2.201239413178384e-12,
   1.421937400815562e-14,  -1.036879210469760e-17,  -2.904869697158940e-18,   9.607102997494629e-20,   8.437496598211291e-02,  -6.490480934391458e-04,   4.992496638393911e-06,
  -3.838729761475263e-08,   2.941650214496723e-10,  -2.201283774893867e-12,   1.419886262487972e-14,  -9.502153301211818e-18,  -2.929387850733911e-18,   9.657481062663189e-20,
   8.437594052236233e-02,  -6.490705703376623e-04,   4.992841104520746e-06,  -3.839159225417175e-08,   2.942064789216373e-10,  -2.201317626597254e-12,   1.418268010136787e-14,
  -8.819050772751624e-18,  -2.948699875962627e-18,   9.697118346665654e-20,   8.437650295881773e-02,  -6.490835425770073e-04,   4.993039910012044e-06,  -3.839407078373384e-08,
   2.942303976171627e-10,  -2.201336737366702e-12,   1.417332482712642e-14,  -8.424396813754271e-18,  -2.959851669917139e-18,   9.719989533110512e-20,   8.437671416123144e-02,
  -6.490884138540197e-04,   4.993114564840662e-06,  -3.839500149794590e-08,   2.942393779590397e-10,  -2.201343833147749e-12,   1.416980879921792e-14,  -8.276120547199491e-18,
  -2.964040496602862e-18,   9.728577079026741e-20,   8.437674917115653e-02,  -6.490892213417167e-04,   4.993126940020409e-06,  -3.839515577723862e-08,   2.942408665071525e-10,
  -2.201345005127180e-12,   1.416922580743046e-14,  -8.251537425011559e-18,  -2.964734918762928e-18,   9.730000544701994e-20,   1.414773747590329e-01,  -1.088223719281330e-03,
   8.369720154377882e-06,  -6.434511234598902e-08,   4.929751823799362e-10,  -3.686986346706606e-12,   2.370311198225539e-14,  -1.192903730763001e-17,  -5.064293838139373e-18,
   1.669878128280021e-19,   1.414785666787435e-01,  -1.088251208165215e-03,   8.370141363470295e-06,  -6.435035936913361e-08,   4.930255327570123e-10,  -3.687008078552688e-12,
   2.368242059395112e-14,  -1.105985363933984e-17,  -5.088947070975645e-18,   1.674980081541645e-19,   1.414805234512802e-01,  -1.088296337237451e-03,   8.370832877380332e-06,
  -6.435897322361051e-08,   4.931081588550071e-10,  -3.687041868530278e-12,   2.364838115959984e-14,  -9.631059959661356e-18,  -5.129448791860310e-18,   1.683354166393470e-19,
   1.414825997972131e-01,  -1.088344224873651e-03,   8.371566669230115e-06,  -6.436811321076059e-08,   4.931957877153992e-10,  -3.687075156331024e-12,   2.361216591370542e-14,
  -8.112433786115647e-18,  -5.172464199663646e-18,   1.692237513950755e-19,   1.414842339351207e-01,  -1.088381914289792e-03,   8.372144197778469e-06,  -6.437530644362946e-08,
   4.932647203178138e-10,  -3.687099494403315e-12,   2.358359422039184e-14,  -6.915409669285853e-18,  -5.206346420655504e-18,   1.699227133638704e-19,   1.414851770451979e-01,
  -1.088403666228129e-03,   8.372477513022798e-06,  -6.437945780469546e-08,   4.933044899194869e-10,  -3.687112794379891e-12,   2.356707682411449e-14,  -6.223839219316295e-18,
  -5.225912066239446e-18,   1.703260321291587e-19,   1.414855311956491e-01,  -1.088411834418106e-03,   8.372602678521982e-06,  -6.438101668310431e-08,   4.933194213884214e-10,
  -3.687117647582296e-12,   2.356086906241679e-14,  -5.964006944899570e-18,  -5.233261342165603e-18,   1.704774697868765e-19,   1.414855899013265e-01,  -1.088413188418887e-03,
   8.372623426616943e-06,  -6.438127508956850e-08,   4.933218963658359e-10,  -3.687118444626247e-12,   2.355983975662622e-14,  -5.920928604279630e-18,  -5.234479704872715e-18,
   1.705025720817717e-19,   2.153790497939361e-01,  -1.656664713069596e-03,   1.274168246751409e-05,  -9.795433249508327e-08,   7.503405006092303e-10,  -5.604371064310730e-12,
   3.567323026874889e-14,  -1.733147976842763e-18,  -8.260146831185541e-18,   2.697417154049804e-19,   2.153808643182048e-01,  -1.656706560108856e-03,   1.274232357027064e-05,
  -9.796230776008129e-08,   7.504162470343217e-10,  -5.604353758530255e-12,   3.563948777410193e-14,  -3.289179235340602e-19,  -8.300052165750695e-18,   2.705734345144758e-19,
   2.153838432195589e-01,  -1.656775261259380e-03,   1.274337609085260e-05,  -9.797540042150583e-08,   7.505405445513569e-10,  -5.604322300594709e-12,   3.558397879688708e-14,
   1.979431221637152e-18,  -8.365612307921590e-18,   2.719386296860697e-19,   2.153870041539844e-01,  -1.656848161837617e-03,   1.274449295992604e-05,  -9.798929270909493e-08,
   7.506723623760202e-10,  -5.604284775551778e-12,   3.552492282194150e-14,   4.432951253811774e-18,  -8.435243271800964e-18,   2.733869215241754e-19,   2.153894918910506e-01,
  -1.656905537399708e-03,   1.274537198763807e-05,  -9.800022598350569e-08,   7.507760518897633e-10,  -5.604252238638405e-12,   3.547833197225412e-14,   6.366912807317240e-18,
  -8.490091326522080e-18,   2.745265237497295e-19,   2.153909276388395e-01,  -1.656938650930183e-03,   1.274587931010698e-05,  -9.800653577792205e-08,   7.508358723436024e-10,
  -5.604232255647761e-12,   3.545139797057829e-14,   7.484253653161646e-18,  -8.521764470759515e-18,   2.751841245010259e-19,   2.153914667813410e-01,  -1.656951085573805e-03,
   1.274606981821371e-05,  -9.800890516614054e-08,   7.508583315859196e-10,  -5.604224523908783e-12,   3.544127538063356e-14,   7.904055661554848e-18,  -8.533661688057265e-18,
   2.754310437080366e-19,   2.153915561521878e-01,  -1.656953146803661e-03,   1.274610139784259e-05,  -9.800929792602849e-08,   7.508620543192560e-10,  -5.604223230235445e-12,
   3.543959696247453e-14,   7.973655955464438e-18,  -8.535634013883406e-18,   2.754719732310281e-19,   3.082926707022827e-01,  -2.371342712756038e-03,   1.823835471260954e-05,
  -1.402076663204662e-07,   1.073747922239247e-09,  -8.004996059997315e-12,   5.023650528926576e-14,   3.065333447643895e-17,  -1.293988602766646e-17,   4.178062505051656e-19,
   3.082952679990562e-01,  -2.371402610740622e-03,   1.823927212960655e-05,  -1.402190569184154e-07,   1.073854527957041e-09,  -8.004869617889491e-12,   5.018365648861465e-14,
   3.282882951564317e-17,  -1.300190018585486e-17,   4.191117534804905e-19,   3.082995319766502e-01,  -2.371500946493847e-03,   1.824077828371906e-05,  -1.402377562843753e-07,
   1.074029456275312e-09,  -8.004657320774732e-12,   5.009671756930870e-14,   3.640508936038814e-17,  -1.310378583424175e-17,   4.212547426973003e-19,   3.083040565150126e-01,
  -2.371605293109308e-03,   1.824237651882414e-05,  -1.402575975585356e-07,   1.074214956844326e-09,  -8.004425633868646e-12,   5.000422517284375e-14,   4.020634502315961e-17,
  -1.321200208408803e-17,   4.235283328732370e-19,   3.083076174435829e-01,  -2.371687417905747e-03,   1.824363440280159e-05,  -1.402732125998556e-07,   1.074360865631187e-09,
  -8.004238639923580e-12,   4.993125678323487e-14,   4.320270795478464e-17,  -1.329724668687135e-17,   4.253174460951963e-19,   3.083096725624150e-01,  -2.371734815119325e-03,
   1.824436037811050e-05,  -1.402822242864468e-07,   1.074445039882638e-09,  -8.004128854567753e-12,   4.988907456147103e-14,   4.493387341629744e-17,  -1.334647417417536e-17,
   4.263498903559181e-19,   3.083104442870268e-01,  -2.371752613506618e-03,   1.824463299394657e-05,  -1.402856082531206e-07,   1.074476641991714e-09,  -8.004087275922230e-12,
   4.987322134380642e-14,   4.558430346760003e-17,  -1.336496546949166e-17,   4.267375665652953e-19,   3.083105722117997e-01,  -2.371755563857910e-03,   1.824467818418144e-05,
  -1.402861691934385e-07,   1.074481880168590e-09,  -8.004080365031888e-12,   4.987059274043018e-14,   4.569214056083847e-17,  -1.336803097666611e-17,   4.268018285496485e-19,
   4.236964694902317e-01,  -3.259011634965813e-03,   2.506548341932089e-05,  -1.926845667392992e-07,   1.475126367925147e-09,  -1.096797942209734e-11,   6.741035121276564e-14,
   1.079806143434288e-16,  -2.001927553554661e-17,   6.382869968943164e-19,   4.237000390271818e-01,  -3.259093951384485e-03,   2.506674375650884e-05,  -1.927001717568846e-07,
   1.475269288823370e-09,  -1.096760348818011e-11,   6.732860306334710e-14,   1.113052195207772e-16,  -2.011453037188423e-17,   6.403213514849537e-19,   4.237058991297281e-01,
  -3.259229091926564e-03,   2.506881289193228e-05,  -1.927257895106422e-07,   1.475503789432975e-09,  -1.096697911502226e-11,   6.719412516668140e-14,   1.167706296629771e-16,
  -2.027103546924080e-17,   6.436610192974105e-19,   4.237121173280837e-01,  -3.259372493035971e-03,   2.507100852404056e-05,  -1.927529713686412e-07,   1.475752439628650e-09,
  -1.096630678964229e-11,   6.705105966406819e-14,   1.225800896798714e-16,  -2.043727437077265e-17,   6.472045787038591e-19,   4.237170112107665e-01,  -3.259485355204747e-03,
   2.507273658454023e-05,  -1.927743632260247e-07,   1.475948003144318e-09,  -1.096577055106962e-11,   6.693819537128009e-14,   1.271595773164793e-16,  -2.056823169751456e-17,
   6.499933065252545e-19,   4.237198356174312e-01,  -3.259550492070184e-03,   2.507373391670548e-05,  -1.927867087207432e-07,   1.476060816308223e-09,  -1.096545822295624e-11,
   6.687295050189669e-14,   1.298054602645432e-16,  -2.064386035045297e-17,   6.516027038384029e-19,   4.237208962199105e-01,  -3.259574951970157e-03,   2.507410843140065e-05,
  -1.927913445455574e-07,   1.476103169246329e-09,  -1.096534040086662e-11,   6.684842985692302e-14,   1.307995771823746e-16,  -2.067226922158930e-17,   6.522070420996769e-19,
   4.237210720304639e-01,  -3.259579006567645e-03,   2.507417051291759e-05,  -1.927921129982267e-07,   1.476110189349296e-09,  -1.096532084168640e-11,   6.684436412489819e-14,
   1.309643959157580e-16,  -2.067697890276136e-17,   6.523072194682530e-19,   5.674532426796436e-01,  -4.364766971293559e-03,   3.356985931778011e-05,  -2.580463258230868e-07,
   1.974503733569220e-09,  -1.462167646285609e-11,   8.696591438889641e-14,   2.797326782567930e-16,  -3.144966343631943e-17,   9.896485080241702e-19,   5.674580233096931e-01,
  -4.364877210439802e-03,   3.357154627845590e-05,  -2.580671257115924e-07,   1.974687842041091e-09,  -1.462075790043563e-11,   8.683750189493336e-14,   2.848900978025360e-16,
  -3.159874484287359e-17,   9.929026710059470e-19,   5.674658716615463e-01,  -4.365058192261539e-03,   3.357431581064227e-05,  -2.581012711165633e-07,   1.974989886126774e-09,
  -1.461923873448015e-11,   8.662626138591496e-14,   2.933688908400060e-16,  -3.184370464361033e-17,   9.982454619981098e-19,   5.674741996058673e-01,  -4.365250236690791e-03,
   3.357725465216051e-05,  -2.581375006944833e-07,   1.975310106380089e-09,  -1.461761154984320e-11,   8.640153328610604e-14,   3.023819293331365e-16,  -3.210392260458596e-17,
   1.003915313227135e-18,   5.674807539129988e-01,  -4.365401382985632e-03,   3.357956764719549e-05,  -2.581660125905754e-07,   1.975561924275946e-09,  -1.461631990722118e-11,
   8.622424683312066e-14,   3.094871011365547e-16,  -3.230893004308638e-17,   1.008378035165346e-18,   5.674845366004342e-01,  -4.365488615001262e-03,   3.358090256646360e-05,
  -2.581824669720317e-07,   1.975707174195061e-09,  -1.461557004601480e-11,   8.612176120162242e-14,   3.135923903298539e-16,  -3.242732975255723e-17,   1.010953762642214e-18,
   5.674859570501518e-01,  -4.365521371969376e-03,   3.358140385035168e-05,  -2.581886456817314e-07,   1.975761702019615e-09,  -1.461528762810796e-11,   8.608324465661281e-14,
   3.151348661359695e-16,  -3.247180624773751e-17,   1.011921011797469e-18,   5.674861925107088e-01,  -4.365526801930976e-03,   3.358148694577599e-05,  -2.581896698873879e-07,
   1.975770739997318e-09,  -1.461524076910124e-11,   8.607685829052247e-14,   3.153906010007980e-16,  -3.247917971922447e-17,   1.012081349174191e-18,   7.508747930401405e-01,
  -5.775616756181765e-03,   4.442056146579280e-05,  -3.414247955702168e-07,   2.610285021114665e-09,  -1.919846059299848e-11,   1.076571790601051e-13,   6.768849684247142e-16,
  -5.233057491393670e-17,   1.627835214589047e-18,   7.508811188969871e-01,  -5.775762614405258e-03,   4.442279152853298e-05,  -3.414520980379956e-07,   2.610512281174738e-09,
  -1.919630175167153e-11,   1.074434736115015e-13,   6.853762943640435e-16,  -5.258022095473414e-17,   1.633487051277719e-18,   7.508915040446877e-01,  -5.776002072712754e-03,
   4.442645267698741e-05,  -3.414969171814998e-07,   2.610885032866390e-09,  -1.919273922379187e-11,   1.070919201523874e-13,   6.993371300816888e-16,  -5.299047050775573e-17,
   1.642768307509816e-18,   7.509025238015601e-01,  -5.776256167939055e-03,   4.443033762802500e-05,  -3.415444706531583e-07,   2.611280098743130e-09,  -1.918893401925957e-11,
   1.067179136863312e-13,   7.141791343497367e-16,  -5.342634081030112e-17,   1.652620285364750e-18,   7.509111966344121e-01,  -5.776456150510917e-03,   4.443339524207087e-05,
  -3.415818932299654e-07,   2.611590689575708e-09,  -1.918592111994134e-11,   1.064228577900970e-13,   7.258804934670555e-16,  -5.376978090395227e-17,   1.660376607549119e-18,
   7.509162019865540e-01,  -5.776571567688082e-03,   4.443515990588011e-05,  -3.416034896240848e-07,   2.611769805945638e-09,  -1.918417502159101e-11,   1.062522901521385e-13,
   7.326418451233931e-16,  -5.396815028012984e-17,   1.664854033394887e-18,   7.509180815632016e-01,  -5.776614908614142e-03,   4.443582256507147e-05,  -3.416115991131244e-07,
   2.611837041017170e-09,  -1.918351796465327e-11,   1.061881863988786e-13,   7.351823629110839e-16,  -5.404267082079935e-17,   1.666535558493056e-18,   7.509183931308393e-01,
  -5.776622093026157e-03,   4.443593241086527e-05,  -3.416129433679441e-07,   2.611848184878274e-09,  -1.918340897525974e-11,   1.061775574397699e-13,   7.356035725586200e-16,
  -5.405502529514344e-17,   1.666814306255126e-18,   1.002982846537618e+00,  -7.714789416699649e-03,   5.933407521654995e-05,  -4.559734691348936e-07,   3.479922036233877e-09,
  -2.522280406316333e-11,   1.223826707962084e-13,   1.814465571380046e-15,  -1.027763611767225e-16,   3.192267657127889e-18,   1.002991296190579e+00,  -7.714984208452605e-03,
   5.933704797662043e-05,  -4.560093147529378e-07,   3.480178269322393e-09,  -2.521711422913929e-11,   1.219625218439616e-13,   1.831155263359900e-15,  -1.032873764955290e-16,
   3.204748666649093e-18,   1.003005167969843e+00,  -7.715304001699730e-03,   5.934192840007225e-05,  -4.560681551737960e-07,   3.480598263511110e-09,  -2.520773717659954e-11,
   1.212713013903235e-13,   1.858600425850608e-15,  -1.041273700296212e-16,   3.225253575429314e-18,   1.003019887416299e+00,  -7.715643342082155e-03,   5.934710711929493e-05,
  -4.561305812841234e-07,   3.481043019848715e-09,  -2.519773805100913e-11,   1.205358526887204e-13,   1.887784864873554e-15,  -1.050201346221911e-16,   3.247031639997167e-18,
   1.003031471999612e+00,  -7.715910415628727e-03,   5.935118295239680e-05,  -4.561797050629250e-07,   3.481392400080621e-09,  -2.518983291385284e-11,   1.199555937822078e-13,
   1.910798810239044e-15,  -1.057238067172274e-16,   3.264186100209768e-18,   1.003038157810075e+00,  -7.716064553356924e-03,   5.935353525699808e-05,  -4.562080529866867e-07,
   3.481593775233098e-09,  -2.518525635084155e-11,   1.196201305749768e-13,   1.924098910329508e-15,  -1.061303351660255e-16,   3.274092281004107e-18,   1.003040668421239e+00,
  -7.716122434431031e-03,   5.935441858240650e-05,  -4.562186974654386e-07,   3.481669344610650e-09,  -2.518353509120739e-11,   1.194940502858323e-13,   1.929096690429310e-15,
  -1.062830710636706e-16,   3.277813284474160e-18,   1.003041084592181e+00,  -7.716132029091052e-03,   5.935456500685054e-05,  -4.562204619164780e-07,   3.481681868731028e-09,
  -2.518324962453047e-11,   1.194731448415640e-13,   1.929925326585472e-15,  -1.063083934674486e-16,   3.278430153859453e-18,   1.637103899707403e-03,  -1.221653280013756e-05,
   9.115741131763767e-08,  -6.800806829650659e-10,   5.067668408137955e-12,  -3.743693902697041e-14,   2.620194352852120e-16,  -1.290113182893156e-18,  -1.177403062479045e-20,
   6.653306561704543e-22,   1.637116880784613e-03,  -1.221682332990692e-05,   9.116174148160920e-08,  -6.801339905082114e-10,   5.068227127942735e-12,  -3.744073860433142e-14,
   2.619700987762482e-16,  -1.286627042969181e-18,  -1.189049223641497e-20,   6.682179825291447e-22,   1.637138191770278e-03,  -1.221730029801438e-05,   9.116885049140733e-08,
  -6.802215073551057e-10,   5.069144279541366e-12,  -3.744696864494876e-14,   2.618887680793757e-16,  -1.280893263369535e-18,  -1.208192990421477e-20,   6.729613258361691e-22,
   1.637160804980175e-03,  -1.221780642042923e-05,   9.117639416891884e-08,  -6.803143747731678e-10,   5.070117342817205e-12,  -3.745356888420082e-14,   2.618020117473433e-16,
  -1.274794708339923e-18,  -1.228539581233678e-20,   6.779988956826555e-22,   1.637178602134732e-03,  -1.221820475764055e-05,   9.118233142208155e-08,  -6.803874657384021e-10,
   5.070883072151691e-12,  -3.745875582855556e-14,   2.617334020177174e-16,  -1.269984557844970e-18,  -1.244576759185818e-20,   6.819667518502414e-22,   1.637188873396837e-03,
  -1.221843465233297e-05,   9.118575806299214e-08,  -6.804296494935211e-10,   5.071324958754121e-12,  -3.746174631446884e-14,   2.616936728016107e-16,  -1.267204292967457e-18,
  -1.253841868813579e-20,   6.842579844294526e-22,   1.637192730391198e-03,  -1.221852098130435e-05,   9.118704482643502e-08,  -6.804454902020622e-10,   5.071490885742751e-12,
  -3.746286870403376e-14,   2.616787288977427e-16,  -1.266159475576832e-18,  -1.257322850495397e-20,   6.851186114483654e-22,   1.637193369744978e-03,  -1.221853529163185e-05,
   9.118725812725025e-08,  -6.804481160414872e-10,   5.071518390208666e-12,  -3.746305472621503e-14,   2.616762504026908e-16,  -1.265986239915521e-18,  -1.257899970145269e-20,
   6.852612856871801e-22,   1.478215565673192e-02,  -1.103086303224792e-04,   8.231016684995326e-07,  -6.140751861547359e-09,   4.575782233159339e-11,  -3.380070629957107e-13,
   2.364498416582005e-15,  -1.159134239748067e-17,  -1.083306913218766e-19,   6.067665854605116e-21,   1.478227286877295e-02,  -1.103112536452232e-04,   8.231407671087255e-07,
  -6.141233158128040e-09,   4.576286419242257e-11,  -3.380411937001491e-13,   2.364044688574329e-15,  -1.155954965396415e-17,  -1.093922197893686e-19,   6.093994949468222e-21,
   1.478246529534012e-02,  -1.103155604027833e-04,   8.232049569152691e-07,  -6.142023319275936e-09,   4.577114051137843e-11,  -3.380971556425008e-13,   2.363296750421742e-15,
  -1.150725899489616e-17,  -1.111371463300441e-19,   6.137248930870379e-21,   1.478266948028117e-02,  -1.103201304075571e-04,   8.232730714903634e-07,  -6.142861788743618e-09,
   4.577992135578211e-11,  -3.381564415150748e-13,   2.362498953994750e-15,  -1.145164168503013e-17,  -1.129917134764490e-19,   6.183186129089785e-21,   1.478283017887148e-02,
  -1.103237271716944e-04,   8.233266810808669e-07,  -6.143521702923916e-09,   4.578683122235673e-11,  -3.382030316051684e-13,   2.361868057490925e-15,  -1.140777431306532e-17,
  -1.144534864341529e-19,   6.219368838506313e-21,   1.478292292276127e-02,  -1.103258029932836e-04,   8.233576214511900e-07,  -6.143902566041997e-09,   4.579081875855672e-11,
  -3.382298922879034e-13,   2.361502740676694e-15,  -1.138241899441346e-17,  -1.152979934781589e-19,   6.240262547847222e-21,   1.478295774931484e-02,  -1.103265824960221e-04,
   8.233692400998880e-07,  -6.144045586525981e-09,   4.579231606449643e-11,  -3.382399735647023e-13,   2.361365330991664e-15,  -1.137289052233230e-17,  -1.156152823377077e-19,
   6.248110601402992e-21,   1.478296352233046e-02,  -1.103267117103437e-04,   8.233711660694539e-07,  -6.144069294355280e-09,   4.579256426156081e-11,  -3.382416444074530e-13,
   2.361342541255008e-15,  -1.137131065665869e-17,  -1.156678863736271e-19,   6.249411647666003e-21,   4.133535197517998e-02,  -3.084560964427338e-04,   2.301639434669827e-06,
  -1.717135447018946e-08,   1.279499722322204e-10,  -9.450071865996658e-13,   6.603791451318417e-15,  -3.207932167039447e-17,  -3.146038214549485e-19,   1.731521967224791e-20,
   4.133567973523963e-02,  -3.084634320264853e-04,   2.301748763767281e-06,  -1.717270008064216e-08,   1.279640530235953e-10,  -9.451016002586874e-13,   6.602474956460571e-15,
  -3.198859539043113e-17,  -3.176298718727784e-19,   1.739034411242931e-20,   4.133621781769724e-02,  -3.084754749901867e-04,   2.301928253865052e-06,  -1.717490921454655e-08,
   1.279871668574181e-10,  -9.452563982773561e-13,   6.600304964896347e-15,  -3.183937467406586e-17,  -3.226040753125356e-19,   1.751376096537631e-20,   4.133678878009831e-02,
  -3.084882540705965e-04,   2.302118718542296e-06,  -1.717725340750540e-08,   1.280116896089311e-10,  -9.454203824837908e-13,   6.597990530911212e-15,  -3.168066080807589e-17,
  -3.278908568536670e-19,   1.764483504029013e-20,   4.133723814160584e-02,  -3.084983116832384e-04,   2.302268623795338e-06,  -1.717909839455049e-08,   1.280309871010049e-10,
  -9.455492442860747e-13,   6.596160431456419e-15,  -3.155547750406787e-17,  -3.320579282401022e-19,   1.774807717797355e-20,   4.133749748136751e-02,  -3.085041162922018e-04,
   2.302355140475769e-06,  -1.718016321065106e-08,   1.280421232404799e-10,  -9.456235348488142e-13,   6.595100784201933e-15,  -3.148312162906633e-17,  -3.344653702284546e-19,
   1.780769470505616e-20,   4.133759486686774e-02,  -3.085062960115934e-04,   2.302387628997416e-06,  -1.718056306686408e-08,   1.280463048162670e-10,  -9.456514169213166e-13,
   6.594702221627129e-15,  -3.145593045496643e-17,  -3.353698693549854e-19,   1.783008818705103e-20,   4.133761100995271e-02,  -3.085066573329182e-04,   2.302393014469088e-06,
  -1.718062934913347e-08,   1.280469979641083e-10,  -9.456560379943642e-13,   6.594636119640268e-15,  -3.145142202998275e-17,  -3.355198283909949e-19,   1.783380057035506e-20,
   8.185299963218774e-02,  -6.108102455926511e-04,   4.557746357031617e-06,  -3.400291471869589e-08,   2.533604796158505e-10,  -1.870810990245266e-12,   1.305162824967324e-14,
  -6.247455303272465e-17,  -6.597854388027556e-19,   3.538714800554971e-20,   8.185364866833178e-02,  -6.108247715978043e-04,   4.557962845024196e-06,  -3.400557856868938e-08,
   2.533883068148677e-10,  -1.870994721198540e-12,   1.304887086615490e-14,  -6.228913565659046e-17,  -6.659602668169424e-19,   3.554067362635072e-20,   8.185471418852841e-02,
  -6.108486192092534e-04,   4.558318262274438e-06,  -3.400995189744656e-08,   2.534339853441950e-10,  -1.871295942106423e-12,   1.304432631509648e-14,  -6.198417315248145e-17,
  -6.761104824406873e-19,   3.579289329774558e-20,   8.185584481815709e-02,  -6.108739244869226e-04,   4.558695410787251e-06,  -3.401459259238979e-08,   2.534824479060004e-10,
  -1.871615012127198e-12,   1.303947990123395e-14,  -6.165980948718741e-17,  -6.868986318886371e-19,   3.606076542866109e-20,   8.185673465159095e-02,  -6.108938406835076e-04,
   4.558992245547313e-06,  -3.401824502823910e-08,   2.535205839216694e-10,  -1.871865724144388e-12,   1.303564814207632e-14,  -6.140397225352900e-17,  -6.954019824339285e-19,
   3.627176106049146e-20,   8.185724820067482e-02,  -6.109053350347409e-04,   4.559163561465265e-06,  -3.402035299430436e-08,   2.535425912444249e-10,  -1.872010255332279e-12,
   1.303342969616418e-14,  -6.125609848090998e-17,  -7.003146507182274e-19,   3.639360233253481e-20,   8.185744104512754e-02,  -6.109096513393072e-04,   4.559227893576225e-06,
  -3.402114457048706e-08,   2.535508548878429e-10,  -1.872064498039831e-12,   1.303259531208008e-14,  -6.120052785078379e-17,  -7.021603927534636e-19,   3.643936845344318e-20,
   8.185747301194375e-02,  -6.109103668318098e-04,   4.559238557611988e-06,  -3.402127578630627e-08,   2.535522246878607e-10,  -1.872073487951821e-12,   1.303245693050116e-14,
  -6.119131397800927e-17,  -7.024664029418850e-19,   3.644695555549913e-20,   1.372536873405243e-01,  -1.024225839279247e-03,   7.642570167672608e-06,  -5.701689956267037e-08,
   4.248226653118640e-10,  -3.135800908182591e-12,   2.182391009776237e-14,  -1.022060524506397e-16,  -1.196085859201583e-18,   6.202601135961705e-20,   1.372547756643844e-01,
  -1.024250196825262e-03,   7.642933163567383e-06,  -5.702136456779761e-08,   4.248691912468760e-10,  -3.136101138046649e-12,   2.181891954352511e-14,  -1.018810535330881e-16,
  -1.206888075981177e-18,   6.229519051768047e-20,   1.372565623615702e-01,  -1.024290185058696e-03,   7.643529108788749e-06,  -5.702869490319072e-08,   4.249455632816293e-10,
  -3.136593307250276e-12,   2.181069549623874e-14,  -1.013465159887316e-16,  -1.224644999846927e-18,   6.273741891154770e-20,   1.372584582362606e-01,  -1.024332617540211e-03,
   7.644161491750828e-06,  -5.703647337226510e-08,   4.250265892623985e-10,  -3.137114575149755e-12,   2.180192664499718e-14,  -1.007779716437421e-16,  -1.243518180843980e-18,
   6.320710132101294e-20,   1.372599503364506e-01,  -1.024366013483943e-03,   7.644659208717185e-06,  -5.704259536967784e-08,   4.250903494027742e-10,  -3.137524118519707e-12,
   2.179499471169202e-14,  -1.003295400002760e-16,  -1.258394430641309e-18,   6.357706457883726e-20,   1.372608114714179e-01,  -1.024385287480404e-03,   7.644946462235305e-06,
  -5.704612861480078e-08,   4.251271435202269e-10,  -3.137760194224376e-12,   2.179098180117915e-14,  -1.000703466198190e-16,  -1.266989006514423e-18,   6.379070595560816e-20,
   1.372611348389530e-01,  -1.024392525160614e-03,   7.645054330928113e-06,  -5.704745540628073e-08,   4.251409594892556e-10,  -3.137848790080519e-12,   2.178947257677783e-14,
  -9.997294230331477e-17,  -1.270218094206269e-18,   6.387095464961915e-20,   1.372611884418978e-01,  -1.024393724915135e-03,   7.645072211820866e-06,  -5.704767534216254e-08,
   4.251432496528437e-10,  -3.137863473319236e-12,   2.178922227793674e-14,  -9.995679220634409e-17,  -1.270753453447617e-18,   6.388425829705217e-20,   2.089490906098817e-01,
  -1.559237187005100e-03,   1.163471384604419e-05,  -8.679951994397837e-08,   6.466889166307622e-10,  -4.771184829089864e-12,   3.309277322297192e-14,  -1.501374874112618e-16,
  -2.013269106048048e-18,   1.002106055685300e-19,   2.089507474263482e-01,  -1.559274267634593e-03,   1.163526641716315e-05,  -8.680631339993567e-08,   6.467594566848918e-10,
  -4.771625093305864e-12,   3.308438901632269e-14,  -1.496123989500428e-16,  -2.030683308792080e-18,   1.006459642346796e-19,   2.089534674157028e-01,  -1.559335143588087e-03,
   1.163617359561285e-05,  -8.681746640701720e-08,   6.468752464744675e-10,  -4.772346716457387e-12,   3.307057461213278e-14,  -1.487487650354385e-16,  -2.059309580661839e-18,
   1.013612217168968e-19,   2.089563536120915e-01,  -1.559399740532821e-03,   1.163713624122169e-05,  -8.682930122006359e-08,   6.469980905092375e-10,  -4.773110860651846e-12,
   3.305584794124679e-14,  -1.478301850025737e-16,  -2.089735961300324e-18,   1.021209056120219e-19,   2.089586251199046e-01,  -1.559450580733621e-03,   1.163789389120512e-05,
  -8.683861572167020e-08,   6.470947564300959e-10,  -4.773711119684312e-12,   3.304420831584788e-14,  -1.471056656225175e-16,  -2.113719105949985e-18,   1.027193158728459e-19,
   2.089599360739659e-01,  -1.559479922435778e-03,   1.163833116299363e-05,  -8.684399147951568e-08,   6.471505390091447e-10,  -4.774057088869230e-12,   3.303747093943305e-14,
  -1.466868928552192e-16,  -2.127575247277100e-18,   1.030648842629860e-19,   2.089604283545017e-01,  -1.559490940693237e-03,   1.163849536614315e-05,  -8.684601016344530e-08,
   6.471714849354290e-10,  -4.774186918238790e-12,   3.303493722046134e-14,  -1.465295188061757e-16,  -2.132781201025389e-18,   1.031946890609211e-19,   2.089605099572712e-01,
  -1.559492767135381e-03,   1.163852258533673e-05,  -8.684634479096327e-08,   6.471749569704332e-10,  -4.774208434803206e-12,   3.303451702149633e-14,  -1.465034254360716e-16,
  -2.133644311925028e-18,   1.032162081960950e-19,   2.990888545556716e-01,  -2.231885527017898e-03,   1.665387053085656e-05,  -1.242433858531974e-07,   9.255828770782220e-10,
  -6.824229818043646e-12,   4.710706109623750e-14,  -2.039596880056498e-16,  -3.269496025454439e-18,   1.551610872169975e-19,   2.990912261142272e-01,  -2.231938603585770e-03,
   1.665466140304235e-05,  -1.242531022578141e-07,   9.256832700845157e-10,  -6.824826312327264e-12,   4.709347395101988e-14,  -2.031466195628809e-16,  -3.296400689777963e-18,
   1.558369164554877e-19,   2.990951194929699e-01,  -2.232025740363966e-03,   1.665595980967590e-05,  -1.242690539170842e-07,   9.258480601951463e-10,  -6.825803786167365e-12,
   4.707109062378668e-14,  -2.018093269056258e-16,  -3.340628748746050e-18,   1.569472829446231e-19,   2.990992507795933e-01,  -2.232118203300836e-03,   1.665733760365263e-05,
  -1.242859806866206e-07,   9.260228862833127e-10,  -6.826838555523880e-12,   4.704723431200732e-14,  -2.003869439917666e-16,  -3.387639267125927e-18,   1.581266662778297e-19,
   2.991025022041522e-01,  -2.232190975072655e-03,   1.665842199570204e-05,  -1.242993027405965e-07,   9.261604543168603e-10,  -6.827651180134255e-12,   4.702838254090467e-14,
  -1.992650493369304e-16,  -3.424695527653512e-18,   1.590557134764939e-19,   2.991043786970254e-01,  -2.232232974269585e-03,   1.665904784398839e-05,  -1.243069913976625e-07,
   9.262398390774884e-10,  -6.828119461708125e-12,   4.701747203415686e-14,  -1.986165906994894e-16,  -3.446104962813160e-18,   1.595922315328123e-19,   2.991050833448416e-01,
  -2.232248745609536e-03,   1.665928286086061e-05,  -1.243098786100287e-07,   9.262696472469074e-10,  -6.828295173700210e-12,   4.701336920953344e-14,  -1.983729006128515e-16,
  -3.454148868222584e-18,   1.597937648765372e-19,   2.991052001506241e-01,  -2.232251359946691e-03,   1.665932181851474e-05,  -1.243103572091881e-07,   9.262745882933262e-10,
  -6.828324293491302e-12,   4.701268880047840e-14,  -1.983324956042751e-16,  -3.455482495415364e-18,   1.598271753657546e-19,   4.110473718470081e-01,  -3.067351492022579e-03,
   2.288792681911924e-05,  -1.707495566874055e-07,   1.271893015962924e-09,  -9.368558062728946e-12,   6.422720547567637e-14,  -2.587192756580676e-16,  -5.262864561998741e-18,
   2.366796057374638e-19,   4.110506311526247e-01,  -3.067424435896510e-03,   2.288901359261673e-05,  -1.707628951755890e-07,   1.272029855555378e-09,  -9.369311355100540e-12,
   6.420538297673064e-14,  -2.574788834169873e-16,  -5.303836046931701e-18,   2.377161529483205e-19,   4.110559819423557e-01,  -3.067544189191934e-03,   2.289079779161868e-05,
  -1.707847932298318e-07,   1.272254465775249e-09,  -9.370545309030562e-12,   6.416943927920889e-14,  -2.554387297034687e-16,  -5.371190365420739e-18,   2.394192483657777e-19,
   4.110616596961565e-01,  -3.067671262295420e-03,   2.289269107938928e-05,  -1.708080297990635e-07,   1.272492748109763e-09,  -9.371850958926474e-12,   6.413113899293735e-14,
  -2.532687347441542e-16,  -5.442784890024735e-18,   2.412283122685611e-19,   4.110661282285447e-01,  -3.067771273551521e-03,   2.289418118987583e-05,  -1.708263178538454e-07,
   1.272680243835591e-09,  -9.372875851042634e-12,   6.410087960450871e-14,  -2.515571453175200e-16,  -5.499221663465629e-18,   2.426534632781444e-19,   4.110687071501858e-01,
  -3.067828993628944e-03,   2.289504119506860e-05,  -1.708368725491952e-07,   1.272788437741159e-09,  -9.373466268392062e-12,   6.408336943757815e-14,  -2.505678328192451e-16,
  -5.531829108793417e-18,   2.434765095422099e-19,   4.110696755692650e-01,  -3.067850668399290e-03,   2.289536414186263e-05,  -1.708408359991601e-07,   1.272829063065468e-09,
  -9.373687773986262e-12,   6.407678533001680e-14,  -2.501960486072752e-16,  -5.544080461559373e-18,   2.437856780656447e-19,   4.110698360990300e-01,  -3.067854261318935e-03,
   2.289541767524827e-05,  -1.708414930007247e-07,   1.272835797159183e-09,  -9.373724481049677e-12,   6.407569345212582e-14,  -2.501344048817610e-16,  -5.546111664378056e-18,
   2.438369327882489e-19,   5.505124108662306e-01,  -4.108078737344373e-03,   3.065357596181377e-05,  -2.286793478805541e-07,   1.703107941378246e-09,  -1.252684555572199e-11,
   8.498532083816920e-14,  -3.027027898074061e-16,  -8.623957193608917e-18,   3.654965527293817e-19,   5.505167760216980e-01,  -4.108176428605247e-03,   3.065503117565741e-05,
  -2.286971818522623e-07,   1.703288926188577e-09,  -1.252771946283297e-11,   8.494964197156685e-14,  -3.007868023346672e-16,  -8.687222889713829e-18,   3.671153161060308e-19,
   5.505239422809236e-01,  -4.108336810130142e-03,   3.065742025632600e-05,  -2.287264600900219e-07,   1.703585986304046e-09,  -1.252914995586730e-11,   8.489088627598699e-14,
  -2.976353862544044e-16,  -8.791232412152159e-18,   3.697752130278176e-19,   5.505315464398177e-01,  -4.108506994812693e-03,   3.065995540727066e-05,  -2.287575277663223e-07,
   1.703901114133675e-09,  -1.253066214917420e-11,   8.482829290914564e-14,  -2.942833136758246e-16,  -8.901796588296302e-18,   3.726008745351424e-19,   5.505375311005331e-01,
  -4.108640936474740e-03,   3.066195069421433e-05,  -2.287819790601308e-07,   1.704149066306818e-09,  -1.253184814212636e-11,   8.477885110865031e-14,  -2.916392910019096e-16,
  -8.988957465688247e-18,   3.748270750512673e-19,   5.505409850244696e-01,  -4.108718239000767e-03,   3.066310225734635e-05,  -2.287960907277700e-07,   1.704292142233488e-09,
  -1.253253095205412e-11,   8.475024486771916e-14,  -2.901109979269237e-16,  -9.039318356281811e-18,   3.761128159449675e-19,   5.505422820184450e-01,  -4.108747267278841e-03,
   3.066353468907318e-05,  -2.288013898649686e-07,   1.704345864480778e-09,  -1.253278704192232e-11,   8.473948924608460e-14,  -2.895366594603144e-16,  -9.058240456220592e-18,
   3.765958052065002e-19,   5.505424970143518e-01,  -4.108752079153111e-03,   3.066360637126052e-05,  -2.288022682762728e-07,   1.704354769491292e-09,  -1.253282947601620e-11,
   8.473770562526368e-14,  -2.894414309364595e-16,  -9.061377649912057e-18,   3.766758771235141e-19,   7.284580717640915e-01,  -5.435958906418197e-03,   4.056184577727125e-05,
  -3.025879639009528e-07,   2.252906419803747e-09,  -1.653155609485947e-11,   1.101792722815529e-13,  -3.028988552907770e-16,  -1.497493401064717e-17,   5.952782397617041e-19,
   7.284638478837937e-01,  -5.436088171029538e-03,   4.056377073607005e-05,  -3.026114966938742e-07,   2.253140872125389e-09,  -1.653241125187958e-11,   1.101174505880658e-13,
  -2.997765734585005e-16,  -1.507841523997579e-17,   5.979790442791592e-19,   7.284733305175991e-01,  -5.436300387079134e-03,   4.056693101202763e-05,  -3.026501304418670e-07,
   2.253525667034600e-09,  -1.653380833898206e-11,   1.100156607622506e-13,  -2.946408067511798e-16,  -1.524855408265601e-17,   6.024174693027889e-19,   7.284833925947924e-01,
  -5.436525574590865e-03,   4.057028450551021e-05,  -3.026911249993224e-07,   2.253933832739747e-09,  -1.653528151412849e-11,   1.099072464198550e-13,  -2.891777124491451e-16,
  -1.542943479881251e-17,   6.071332517153983e-19,   7.284913116978005e-01,  -5.436702805500637e-03,   4.057292386470862e-05,  -3.027233887718893e-07,   2.254254965932767e-09,
  -1.653643420967053e-11,   1.098216284217707e-13,  -2.848683389644184e-16,  -1.557204252585243e-17,   6.108491333529392e-19,   7.284958820453226e-01,  -5.436805091792354e-03,
   4.057444714750819e-05,  -3.027420091618287e-07,   2.254440259886288e-09,  -1.653709676360518e-11,   1.097720981078480e-13,  -2.823773486045513e-16,  -1.565444592970293e-17,
   6.129954583244120e-19,   7.284975982710684e-01,  -5.436843501854117e-03,   4.057501916611850e-05,  -3.027490013667787e-07,   2.254509832362974e-09,  -1.653734505053998e-11,
   1.097534765734347e-13,  -2.814412069260780e-16,  -1.568540845115017e-17,   6.138017679768603e-19,   7.284978827608325e-01,  -5.436849868900246e-03,   4.057511398695914e-05,
  -3.027501604281741e-07,   2.254521364614410e-09,  -1.653738618081047e-11,   1.097503886050785e-13,  -2.812859884687588e-16,  -1.569054194647253e-17,   6.139354434490712e-19,
   9.730396672173605e-01,  -7.261094241782302e-03,   5.418036968396112e-05,  -4.041590188951517e-07,   3.007413919180146e-09,  -2.196004966158216e-11,   1.407947629356222e-13,
  -1.247111832507911e-16,  -3.049477159855146e-17,   1.134668139252903e-18,   9.730473826493362e-01,  -7.261266896589444e-03,   5.418293924009391e-05,  -4.041902719111748e-07,
   3.007712962000763e-09,  -2.196032680651771e-11,   1.406690707750384e-13,  -1.187507560497795e-16,  -3.069578591601593e-17,   1.140148542647105e-18,   9.730600490445569e-01,
  -7.261550347051022e-03,   5.418715776654783e-05,  -4.042415790416439e-07,   3.008203693041720e-09,  -2.196076881387801e-11,   1.404621445753695e-13,  -1.089453669237407e-16,
  -3.102634833747158e-17,   1.149157384429552e-18,   9.730734894290174e-01,  -7.261851123018710e-03,   5.419163419945588e-05,  -4.042960202005586e-07,   3.008724129529592e-09,
  -2.196122016497266e-11,   1.402417877595482e-13,  -9.851336440369729e-17,  -3.137786874180727e-17,   1.158732596151346e-18,   9.730840673430102e-01,  -7.262087844785845e-03,
   5.419515735685251e-05,  -4.043388659104759e-07,   3.009133522021484e-09,  -2.196156258038450e-11,   1.400677915620682e-13,  -9.028322959475096e-17,  -3.165507360259850e-17,
   1.166280018451010e-18,   9.730901721685651e-01,  -7.262224465354761e-03,   5.419719071248666e-05,  -4.043635930984932e-07,   3.009369712637365e-09,  -2.196175505774129e-11,
   1.399671445440012e-13,  -8.552539692877380e-17,  -3.181527710520696e-17,   1.170640465065090e-18,   9.730924646110273e-01,  -7.262275768456716e-03,   5.419795427146830e-05,
  -4.043728784204515e-07,   3.009458389842604e-09,  -2.196182636315514e-11,   1.399293070103350e-13,  -8.373725910570862e-17,  -3.187547730459415e-17,   1.172278740949766e-18,
   9.730928446172215e-01,  -7.262284272718178e-03,   5.419808084302274e-05,  -4.043744175963640e-07,   3.009473088581775e-09,  -2.196183813176582e-11,   1.399230325979463e-13,
  -8.344076923230658e-17,  -3.188545857540022e-17,   1.172550355304520e-18,   1.589646474636293e-03,  -1.151859372412498e-05,   8.345930280885816e-08,  -6.046590325241809e-10,
   4.378746509189040e-12,  -3.160662990682892e-14,   2.233986681596327e-16,  -1.394659318941560e-18,   2.514204979634522e-21,   2.006385786279920e-22,   1.589658359032252e-03,
  -1.151885202542834e-05,   8.346304427814937e-08,  -6.047040461104538e-10,   4.379223484895378e-12,  -3.161078074115572e-14,   2.234077576368614e-16,  -1.393597265076491e-18,
   2.469579883745184e-21,   2.019086156516588e-22,   1.589677869577475e-03,  -1.151927608273276e-05,   8.346918680009977e-08,  -6.047779474619472e-10,   4.380006531263067e-12,
  -3.161759269131735e-14,   2.234225502087312e-16,  -1.391849008325620e-18,   2.396189049398624e-21,   2.039963148873013e-22,   1.589698572298428e-03,  -1.151972605921652e-05,
   8.347570489103271e-08,  -6.048563683025275e-10,   4.380837422290364e-12,  -3.162481754345983e-14,   2.234380703647729e-16,  -1.389987547653869e-18,   2.318136872304550e-21,
   2.062152319584629e-22,   1.589714865828422e-03,  -1.152008020676562e-05,   8.348083495275976e-08,  -6.049180901109096e-10,   4.381491351067036e-12,  -3.163050125245088e-14,
   2.234501572842771e-16,  -1.388517911975227e-18,   2.256579853634628e-21,   2.079642146829750e-22,   1.589724269295449e-03,  -1.152028459772999e-05,   8.348379572791096e-08,
  -6.049537126545998e-10,   4.381868751402852e-12,  -3.163378051360763e-14,   2.234570817095848e-16,  -1.387667888554628e-18,   2.221002144151530e-21,   2.089746622529942e-22,
   1.589727800419604e-03,  -1.152036134960699e-05,   8.348490755038765e-08,  -6.049670895916959e-10,   4.382010469971007e-12,  -3.163501173501174e-14,   2.234596722216133e-16,
  -1.387348343077724e-18,   2.207632538671813e-21,   2.093542986119882e-22,   1.589728385755495e-03,  -1.152037407238394e-05,   8.348509185203634e-08,  -6.049693070272540e-10,
   4.382033961904310e-12,  -3.163521581841157e-14,   2.234601011253193e-16,  -1.387295355202392e-18,   2.205415816986472e-21,   2.094172394942915e-22,   1.435364098317512e-02,
  -1.040066212435711e-04,   7.535919864537695e-07,  -5.459739730521657e-09,   3.953756054280846e-11,  -2.853822880849499e-13,   2.016740525883432e-15,  -1.257466954300115e-17,
   2.203224287486886e-20,   1.832659052927664e-21,   1.435374829278876e-02,  -1.040089535627565e-04,   7.536257697625631e-07,  -5.460146166305000e-09,   3.954186642779189e-11,
  -2.854197112657513e-13,   2.016819853003918e-15,  -1.256496933188922e-17,   2.162557503011849e-20,   1.844232637074716e-21,   1.435392446237085e-02,  -1.040127825677710e-04,
   7.536812331908267e-07,  -5.460813434869236e-09,   3.954893535294559e-11,  -2.854811263195463e-13,   2.016948903215810e-15,  -1.254900182132179e-17,   2.095676476782174e-20,
   1.863257451931183e-21,   1.435411139664954e-02,  -1.040168456087623e-04,   7.537400877894595e-07,  -5.461521510632804e-09,   3.955643618839240e-11,  -2.855462636370078e-13,
   2.017084232429323e-15,  -1.253200050699577e-17,   2.024547480918658e-20,   1.883478091001449e-21,   1.435425851833869e-02,  -1.040200433669989e-04,   7.537864092850094e-07,
  -5.462078807797705e-09,   3.956233950001699e-11,  -2.855975061549685e-13,   2.017189575093766e-15,  -1.251857795047540e-17,   1.968450467047082e-20,   1.899416336793384e-21,
   1.435434342651717e-02,  -1.040218889053653e-04,   7.538131433749868e-07,  -5.462400450045587e-09,   3.956574646231504e-11,  -2.856270708258162e-13,   2.017249904070479e-15,
  -1.251081450834282e-17,   1.936028414577510e-20,   1.908624428018749e-21,   1.435437531064236e-02,  -1.040225819327409e-04,   7.538231824899087e-07,  -5.462521232772404e-09,
   3.956702581914787e-11,  -2.856381710666535e-13,   2.017272470000327e-15,  -1.250789603966922e-17,   1.923844655853634e-20,   1.912084013343471e-21,   1.435438059590620e-02,
  -1.040226968124425e-04,   7.538248466273657e-07,  -5.462541254389330e-09,   3.956723789130888e-11,  -2.856400110066958e-13,   2.017276205971785e-15,  -1.250741209185993e-17,
   1.921824550941618e-20,   1.912657587012475e-21,   4.013709610497301e-02,  -2.908337856282339e-04,   2.107269698156354e-06,  -1.526706431708310e-08,   1.105581398314865e-10,
  -7.979665153674891e-13,   5.636943656138235e-15,  -3.505656945953062e-17,   5.773666492479130e-20,   5.246210654227375e-21,   4.013739617490498e-02,  -2.908403074896054e-04,
   2.107364165759264e-06,  -1.526820076241957e-08,   1.105701749204467e-10,  -7.980708348461875e-13,   5.637149600284656e-15,  -3.502880554327822e-17,   5.657790281085911e-20,
   5.279187909947859e-21,   4.013788879800474e-02,  -2.908510145317631e-04,   2.107519257051096e-06,  -1.527006652853410e-08,   1.105899327722072e-10,  -7.982420316089093e-13,
   5.637484334035802e-15,  -3.498310393137179e-17,   5.467218628712860e-20,   5.333396633765870e-21,   4.013841152243144e-02,  -2.908623760084127e-04,   2.107683831001229e-06,
  -1.527204639621212e-08,   1.106108977923481e-10,  -7.984236021747026e-13,   5.637834944677403e-15,  -3.493444415161547e-17,   5.264542208255324e-20,   5.391013060030932e-21,
   4.013882291889197e-02,  -2.908713178959114e-04,   2.107813358879755e-06,  -1.527360466789314e-08,   1.106273976697127e-10,  -7.985664393671314e-13,   5.638107565657904e-15,
  -3.489602774031959e-17,   5.104697827140035e-20,   5.436427549688780e-21,   4.013906034767825e-02,  -2.908764785726098e-04,   2.107888114883549e-06,  -1.527450401919815e-08,
   1.106369201896383e-10,  -7.986488494965820e-13,   5.638263571763798e-15,  -3.487380837432891e-17,   5.012313374996027e-20,   5.462665218873139e-21,   4.013914950527510e-02,
  -2.908784164842191e-04,   2.107916187060574e-06,  -1.527484174254030e-08,   1.106404960127867e-10,  -7.986797907775154e-13,   5.638321902284799e-15,  -3.486545560925467e-17,
   4.977596545820827e-20,   5.472523031312977e-21,   4.013916428446129e-02,  -2.908787377221889e-04,   2.107920840454972e-06,  -1.527489772543953e-08,   1.106410887578275e-10,
  -7.986849194979879e-13,   5.638331558141086e-15,  -3.486407053490056e-17,   4.971840386476298e-20,   5.474157384770355e-21,   7.948019204686231e-02,  -5.759142367335199e-04,
   4.172852681150496e-06,  -3.023208235255191e-08,   2.189267919273718e-10,  -1.579996506548361e-12,   1.115462857550371e-14,  -6.908670951577143e-17,   1.021519367244892e-19,
   1.077152499735697e-20,   7.948078625063802e-02,  -5.759271514258284e-04,   4.173039745428856e-06,  -3.023433253826187e-08,   2.189506068912944e-10,  -1.580202054593098e-12,
   1.115498644154665e-14,  -6.902971708370301e-17,   9.978917049365801e-20,   1.083876967520232e-20,   7.948176175159505e-02,  -5.759483536787845e-04,   4.173346856424497e-06,
  -3.023802679342944e-08,   2.189897035358682e-10,  -1.580539370698758e-12,   1.115556709163644e-14,  -6.893590467775126e-17,   9.590331816113396e-20,   1.094930878257985e-20,
   7.948279685973066e-02,  -5.759708518530988e-04,   4.173672744917962e-06,  -3.024194697060438e-08,   2.190311888081245e-10,  -1.580897119959158e-12,   1.115617389230704e-14,
  -6.883602225203831e-17,   9.177062488769392e-20,   1.106679783312094e-20,   7.948361151426252e-02,  -5.759885587189456e-04,   4.173929235349395e-06,  -3.024503237832790e-08,
   2.190638384453844e-10,  -1.581178547768890e-12,   1.115664469534610e-14,  -6.875716770092269e-17,   8.851128897814449e-20,   1.115940603997812e-20,   7.948408167493538e-02,
  -5.759987779718427e-04,   4.174077266795131e-06,  -3.024681311069209e-08,   2.190826813924200e-10,  -1.581340915984424e-12,   1.115691369546847e-14,  -6.871156028818373e-17,
   8.662750159041282e-20,   1.121290964410173e-20,   7.948425822638217e-02,  -5.760026154547851e-04,   4.174132855171709e-06,  -3.024748180913217e-08,   2.190897571445805e-10,
  -1.581401877540949e-12,   1.115701419522028e-14,  -6.869441554712061e-17,   8.591959871049675e-20,   1.123301166500256e-20,   7.948428749238749e-02,  -5.760032515752476e-04,
   4.174142069798662e-06,  -3.024759265629998e-08,   2.190909300537914e-10,  -1.581411982299480e-12,   1.115703082744930e-14,  -6.869157257393678e-17,   8.580222613488937e-20,
   1.123634443693973e-20,   1.332748888962137e-01,  -9.657111239442922e-04,   6.997170108094497e-06,  -5.069403503924895e-08,   3.670975312025295e-10,  -2.649022658259769e-12,
   1.868566222465855e-14,  -1.150387686238584e-16,   1.416755057707705e-19,   1.899520815536169e-20,   1.332758852757104e-01,  -9.657327796741044e-04,   6.997483778172451e-06,
  -5.069780768062112e-08,   3.671374233688347e-10,  -2.649364834311318e-12,   1.868614082928346e-14,  -1.149382929533015e-16,   1.375469277427945e-19,   1.911273068837930e-20,
   1.332775210262592e-01,  -9.657683322252810e-04,   6.997998743006919e-06,  -5.070400143347088e-08,   3.672029135105210e-10,  -2.649926352600966e-12,   1.868691457551805e-14,
  -1.147729087575778e-16,   1.307569494986604e-19,   1.930592044707447e-20,   1.332792567279907e-01,  -9.658060578146528e-04,   6.998545193983071e-06,  -5.071057396152819e-08,
   3.672724045464547e-10,  -2.650521868641804e-12,   1.868771930498919e-14,  -1.145968287324051e-16,   1.235356015441924e-19,   1.951125963477817e-20,   1.332806227662163e-01,
  -9.658357491992464e-04,   6.998975278018490e-06,  -5.071574692133756e-08,   3.673270950252002e-10,  -2.650990326535624e-12,   1.868834083241908e-14,  -1.144578218997939e-16,
   1.178402965272526e-19,   1.967311597328366e-20,   1.332814111463530e-01,  -9.658528851378964e-04,   6.999223497644397e-06,  -5.071873247613660e-08,   3.673586582351854e-10,
  -2.651260595884133e-12,   1.868869479344071e-14,  -1.143774254656770e-16,   1.145485857094226e-19,   1.976662796231503e-20,   1.332817071933466e-01,  -9.658593199402053e-04,
   6.999316708419209e-06,  -5.071985360783325e-08,   3.673705105842200e-10,  -2.651362068278066e-12,   1.868882681383378e-14,  -1.143472031142845e-16,   1.133116006981570e-19,
   1.980176183310646e-20,   1.332817562675006e-01,  -9.658603866053813e-04,   6.999332159536244e-06,  -5.072003945284070e-08,   3.673724752833451e-10,  -2.651378887912456e-12,
   1.868884865084791e-14,  -1.143421916019584e-16,   1.131065044569763e-19,   1.980758678736164e-20,   2.028919396310033e-01,  -1.470156933147203e-03,   1.065218840411157e-05,
  -7.717425785558059e-08,   5.588411525490756e-10,  -4.031983496515089e-12,   2.840636718733952e-14,  -1.734092123749555e-16,   1.524307215864470e-19,   3.091684249465227e-20,
   2.028934564759281e-01,  -1.470189900826171e-03,   1.065266591090935e-05,  -7.718000001514109e-08,   5.589017944430497e-10,  -4.032499099226826e-12,   2.840683630697249e-14,
  -1.732457324541693e-16,   1.457870978793787e-19,   3.110605393145929e-20,   2.028959466716070e-01,  -1.470244024381278e-03,   1.065344985304871e-05,  -7.718942722890436e-08,
   5.590013485792939e-10,  -4.033345188105263e-12,   2.840758719530613e-14,  -1.729766499024711e-16,   1.348607141111135e-19,   3.141709470298301e-20,   2.028985890286289e-01,
  -1.470301456068464e-03,   1.065428172715033e-05,  -7.719943095083231e-08,   5.591069840836422e-10,  -4.034242468559210e-12,   2.840835775546551e-14,  -1.726901751315130e-16,
   1.232400520710640e-19,   3.174770318773933e-20,   2.029006686259641e-01,  -1.470346656854642e-03,   1.065493645329547e-05,  -7.720730445335705e-08,   5.591901203988303e-10,
  -4.034948281006869e-12,   2.840894520308554e-14,  -1.724640241347033e-16,   1.140750249049919e-19,   3.200830659017011e-20,   2.029018688216834e-01,  -1.470372743812365e-03,
   1.065531432333046e-05,  -7.721184861433731e-08,   5.592381002355700e-10,  -4.035355477862265e-12,   2.840927661142090e-14,  -1.723332296229039e-16,   1.087778862709818e-19,
   3.215887136090718e-20,   2.029023195107835e-01,  -1.470382539856734e-03,   1.065545622007853e-05,  -7.721355503141463e-08,   5.592561171869042e-10,  -4.035508357595690e-12,
   2.840939961747430e-14,  -1.722840623458595e-16,   1.067872791217667e-19,   3.221544119979000e-20,   2.029023942191467e-01,  -1.470384163698289e-03,   1.065547974164292e-05,
  -7.721383789655110e-08,   5.592591037568680e-10,  -4.035533698188775e-12,   2.840941993144170e-14,  -1.722759093884270e-16,   1.064572294635915e-19,   3.222482010991647e-20,
   2.904186741170149e-01,  -2.104376470792440e-03,   1.524749515214346e-05,  -1.104666071413322e-07,   7.998985799744897e-10,  -5.769828323541929e-12,   4.058140680223963e-14,
  -2.447815988689748e-16,   9.142595357891118e-20,   4.827915110136546e-20,   2.904208453220573e-01,  -2.104423660452910e-03,   1.524817863162310e-05,  -1.104748241688175e-07,
   7.999852069487490e-10,  -5.770555748214522e-12,   4.058155809139008e-14,  -2.445264093251357e-16,   8.119055385342655e-20,   4.857098296675717e-20,   2.904244097770138e-01,
  -2.104501132457164e-03,   1.524930072730023e-05,  -1.104883144961983e-07,   8.001274192707120e-10,  -5.771749377235693e-12,   4.058177680246658e-14,  -2.441063887877922e-16,
   6.435677562955708e-20,   4.905073029060815e-20,   2.904281920350329e-01,  -2.104583339693043e-03,   1.525049143024949e-05,  -1.105026297910524e-07,   8.002783176794116e-10,
  -5.773015152523844e-12,   4.058196851997346e-14,  -2.436592377663022e-16,   4.645307128575841e-20,   4.956067363017016e-20,   2.904311687613521e-01,  -2.104648039718981e-03,
   1.525142857237376e-05,  -1.105138967378820e-07,   8.003970756043971e-10,  -5.774010774964086e-12,   4.058209014848306e-14,  -2.433062572867767e-16,   3.233250523193122e-20,
   4.996264921432556e-20,   2.904328867161325e-01,  -2.104685380371019e-03,   1.525196943652238e-05,  -1.105203994075824e-07,   8.004656131524569e-10,  -5.774585147596491e-12,
   4.058214860353460e-14,  -2.431021159831723e-16,   2.417111618622836e-20,   5.019489671994074e-20,   2.904335318304930e-01,  -2.104699402346545e-03,   1.525217254037728e-05,
  -1.105228412803456e-07,   8.004913496876682e-10,  -5.774800788505953e-12,   4.058216833366497e-14,  -2.430253776976377e-16,   2.110413924144653e-20,   5.028215702111121e-20,
   2.904336387677096e-01,  -2.104701726699686e-03,   1.525220620795884e-05,  -1.105232460586429e-07,   8.004956158869788e-10,  -5.774836531871152e-12,   4.058217148704787e-14,
  -2.430126529439321e-16,   2.059562286632241e-20,   5.029662425280005e-20,   3.991316660432674e-01,  -2.892111810680461e-03,   2.095511455133418e-05,  -1.518172050074081e-07,
   1.099279164443372e-09,  -7.926677243345847e-12,   5.561761665424094e-14,  -3.296810326615243e-16,  -1.240059242288469e-19,   7.432810519314068e-20,   3.991346499989034e-01,
  -2.892176664674180e-03,   2.095605383693386e-05,  -1.518284935108524e-07,   1.099397876203107e-09,  -7.927656180045686e-12,   5.561679961448280e-14,  -3.292883133609759e-16,
  -1.395226137370376e-19,   7.477152042799617e-20,   3.991395487418774e-01,  -2.892283136489441e-03,   2.095759589956708e-05,  -1.518470264210409e-07,   1.099592759341912e-09,
  -7.929262407045614e-12,   5.561541335281350e-14,  -3.286419514031267e-16,  -1.650428245896899e-19,   7.550048247914689e-20,   3.991447468184700e-01,  -2.892396116056304e-03,
   2.095923224684019e-05,  -1.518666926363872e-07,   1.099799543437149e-09,  -7.930965572663544e-12,   5.561388124460702e-14,  -3.279538672778096e-16,  -1.921857280367932e-19,
   7.627535951635091e-20,   3.991488378274140e-01,  -2.892485035002616e-03,   2.096052013288364e-05,  -1.518821710393346e-07,   1.099962282145277e-09,  -7.932305127649677e-12,
   5.561263111452611e-14,  -3.274107150004778e-16,  -2.135936933942494e-19,   7.688619964078191e-20,   3.991511988668962e-01,  -2.892536353241673e-03,   2.096126342602093e-05,
  -1.518911043243141e-07,   1.100056201240291e-09,  -7.933077871677431e-12,   5.561189184185047e-14,  -3.270965986964373e-16,  -2.259672408591219e-19,   7.723913140846125e-20,
   3.991520854679244e-01,  -2.892555624010899e-03,   2.096154254545099e-05,  -1.518944589364829e-07,   1.100091468680617e-09,  -7.933367980542824e-12,   5.561161087126870e-14,
  -3.269785215063971e-16,  -2.306171462012171e-19,   7.737173715466958e-20,   3.991522324351166e-01,  -2.892558818430461e-03,   2.096158881378011e-05,  -1.518950150154141e-07,
   1.100097314757630e-09,  -7.933416066851443e-12,   5.561156411872730e-14,  -3.269589420108458e-16,  -2.313881200411148e-19,   7.739372248341661e-20,   5.345538032788114e-01,
  -3.873381829913895e-03,   2.806500447786389e-05,  -2.033264054355810e-07,   1.472162927504871e-09,  -1.061022038806284e-11,   7.417955941015875e-14,  -4.280200170114156e-16,
  -6.714822219567198e-19,   1.158412838176794e-19,   5.345577996647340e-01,  -3.873468687821411e-03,   2.806626237237666e-05,  -2.033415152664093e-07,   1.472321233572479e-09,
  -1.061148969177994e-11,   7.417638894212338e-14,  -4.274081860708888e-16,  -6.952600454460061e-19,   1.165238605823138e-19,   5.345643605087350e-01,  -3.873611283803146e-03,
   2.806832750754713e-05,  -2.033663218013314e-07,   1.472581113454674e-09,  -1.061357212575580e-11,   7.417111520361092e-14,  -4.264012266886319e-16,  -7.343685492558933e-19,
   1.176460551514261e-19,   5.345713222476441e-01,  -3.873762595507685e-03,   2.807051890843001e-05,  -2.033926452213252e-07,   1.472856859040872e-09,  -1.061577993378950e-11,
   7.416542559901455e-14,  -4.253293097129113e-16,  -7.759654576491181e-19,   1.188390117478069e-19,   5.345768013004417e-01,  -3.873881683209980e-03,   2.807224364863321e-05,
  -2.034133631715616e-07,   1.473073867112721e-09,  -1.061751617356330e-11,   7.416087987358974e-14,  -4.244832011073939e-16,  -8.087747238051963e-19,   1.197794833973177e-19,
   5.345799634201392e-01,  -3.873950412893934e-03,   2.807323906848956e-05,  -2.034253204188164e-07,   1.473199104633509e-09,  -1.061851766288552e-11,   7.415822916797950e-14,
  -4.239938905712625e-16,  -8.277385827545959e-19,   1.203228928122787e-19,   5.345811508372049e-01,  -3.873976221921917e-03,   2.807361286583198e-05,  -2.034298105810104e-07,
   1.473246132172787e-09,  -1.061889363208000e-11,   7.415722864213759e-14,  -4.238099595950614e-16,  -8.348651816852166e-19,   1.205270703381733e-19,   5.345813476690904e-01,
  -3.873980500156100e-03,   2.807367482847641e-05,  -2.034305548947791e-07,   1.473253927639675e-09,  -1.061895594907754e-11,   7.415706251838226e-14,  -4.237794603769321e-16,
  -8.360468066777186e-19,   1.205609221158765e-19,   7.073410621269896e-01,  -5.125399783956158e-03,   3.713661404958006e-05,  -2.690464782949990e-07,   1.947821705751184e-09,
  -1.402710423195129e-11,   9.748670131415317e-14,  -5.366980375037535e-16,  -2.011350352457193e-18,   1.899999707648211e-19,   7.073463502869026e-01,  -5.125514716399927e-03,
   3.713827836399175e-05,  -2.690664532858851e-07,   1.948029696023183e-09,  -1.402869203590444e-11,   9.747788885254212e-14,  -5.356947482883388e-16,  -2.049690257479300e-18,
   1.911111653548370e-19,   7.073550318288847e-01,  -5.125703402779829e-03,   3.714101073386293e-05,  -2.690992470936414e-07,   1.948371131703372e-09,  -1.403129648648223e-11,
   9.746331064955505e-14,  -5.340435506732226e-16,  -2.112753437809340e-18,   1.929381942879162e-19,   7.073642438492321e-01,  -5.125903622002440e-03,   3.714391016400375e-05,
  -2.691340460689812e-07,   1.948733402211320e-09,  -1.403405703316256e-11,   9.744769083252436e-14,  -5.322858754456971e-16,  -2.179834302429661e-18,   1.948806510689309e-19,
   7.073714939266023e-01,  -5.126061201658016e-03,   3.714619215712300e-05,  -2.691614346451323e-07,   1.949018497074447e-09,  -1.403622743883631e-11,   9.743528831685226e-14,
  -5.308984972178676e-16,  -2.232747545483736e-18,   1.964121542185539e-19,   7.073756781557501e-01,  -5.126152146393999e-03,   3.714750919062672e-05,  -2.691772417689175e-07,
   1.949183025286384e-09,  -1.403747915565293e-11,   9.742808658419633e-14,  -5.300961777233934e-16,  -2.263333045571459e-18,   1.972971290153457e-19,   7.073772493882041e-01,
  -5.126186297507028e-03,   3.714800375937738e-05,  -2.691831776221862e-07,   1.949244806203047e-09,  -1.403794902378976e-11,   9.742537393985057e-14,  -5.297945893028398e-16,
  -2.274827325149477e-18,   1.976296565096254e-19,   7.073775098431490e-01,  -5.126191958567129e-03,   3.714808574173200e-05,  -2.691841615812177e-07,   1.949255047218154e-09,
  -1.403802690250491e-11,   9.742492384104723e-14,  -5.297445803748929e-16,  -2.276733147734022e-18,   1.976847888153640e-19,   9.448325724062335e-01,  -6.846265099591353e-03,
   4.960526716515198e-05,  -3.593731681808172e-07,   2.601284470602362e-09,  -1.870258572358395e-11,   1.283881751686088e-13,  -6.343208969099091e-16,  -5.881548042692063e-18,
   3.610262149436551e-19,   9.448396360698739e-01,  -6.846418618004881e-03,   4.960748980742012e-05,  -3.593997990527553e-07,   2.601558230951689e-09,  -1.870445076914719e-11,
   1.283632406992172e-13,  -6.324137685496158e-16,  -5.953540920738824e-18,   3.631644765744884e-19,   9.448512324461512e-01,  -6.846670651555246e-03,   4.961113880338407e-05,
  -3.594435198458776e-07,   2.602007613612409e-09,  -1.870750838631425e-11,   1.283220979785426e-13,  -6.292749445819260e-16,  -6.071974598116016e-18,   3.666809066258517e-19,
   9.448635374092363e-01,  -6.846938089816735e-03,   4.961501089976827e-05,  -3.594899135759036e-07,   2.602484389815752e-09,  -1.871074709528274e-11,   1.282781582670830e-13,
  -6.259335733193491e-16,  -6.197976134754478e-18,   3.704204430644661e-19,   9.448732217054674e-01,  -6.847148573232925e-03,   4.961805842623103e-05,  -3.595264275582299e-07,
   2.602859576295258e-09,  -1.871329187140282e-11,   1.282433714764413e-13,  -6.232960408610979e-16,  -6.297382249915274e-18,   3.733695143182645e-19,   9.448788107926384e-01,
  -6.847270050574920e-03,   4.961981727998818e-05,  -3.595475012416272e-07,   2.603076088110867e-09,  -1.871475886357338e-11,   1.282232126605033e-13,  -6.217707171064908e-16,
  -6.354848643866207e-18,   3.750739018726714e-19,   9.448809095675439e-01,  -6.847315667138460e-03,   4.962047775965970e-05,  -3.595554147610182e-07,   2.603157387489315e-09,
  -1.871530942195955e-11,   1.282156271854589e-13,  -6.211973466851404e-16,  -6.376446223732207e-18,   3.757143740556023e-19,   9.448812574704278e-01,  -6.847323228769186e-03,
   4.962058724428370e-05,  -3.595567265476043e-07,   2.603170863868638e-09,  -1.871540066843866e-11,   1.282143689590618e-13,  -6.211022708699345e-16,  -6.380027301459019e-18,
   3.758205656370291e-19,   1.544863114902055e-03,  -1.087879813061428e-05,   7.660380161350833e-08,  -5.393778814306577e-10,   3.797135946461650e-12,  -2.669948198313707e-14,
   1.862542223485974e-16,  -1.239699791164968e-18,   6.193534816932899e-21,   3.338390483727118e-23,   1.544874022710264e-03,  -1.087902853727025e-05,   7.660704602995349e-08,
  -5.394159080067924e-10,   3.797533815661622e-12,  -2.670318379882789e-14,   1.862785921212887e-16,  -1.239515583627417e-18,   6.178698080612778e-21,   3.387341218874677e-23,
   1.544891929977395e-03,  -1.087940679883819e-05,   7.661237251042675e-08,  -5.394783385940448e-10,   3.798187019798933e-12,  -2.670926052206835e-14,   1.863185559879955e-16,
  -1.239211353718364e-18,   6.154283676272035e-21,   3.467845101757004e-23,   1.544910931426719e-03,  -1.087980817957249e-05,   7.661802465198115e-08,  -5.395445874480771e-10,
   3.798880170742983e-12,  -2.671570784071143e-14,   1.863609021269693e-16,  -1.238886061154310e-18,   6.128299888772167e-21,   3.553460839126741e-23,   1.544925885996563e-03,
  -1.088012407988730e-05,   7.662247315899861e-08,  -5.395967293916545e-10,   3.799425720981159e-12,  -2.672078151127903e-14,   1.863941862521523e-16,  -1.238628255500032e-18,
   6.107793825301540e-21,   3.620982061915733e-23,   1.544934516703285e-03,  -1.088030639677338e-05,   7.662504057636138e-08,  -5.396268230289644e-10,   3.799740583434531e-12,
  -2.672370946363819e-14,   1.864133781084094e-16,  -1.238478749051824e-18,   6.095936634535563e-21,   3.660006500436595e-23,   1.544937757644439e-03,  -1.088037485945354e-05,
   7.662600468544105e-08,  -5.396381237729228e-10,   3.799858820202194e-12,  -2.672480890815155e-14,   1.864205816133294e-16,  -1.238422471382771e-18,   6.091479841159554e-21,
   3.674671270061571e-23,   1.544938294878142e-03,  -1.088038620816897e-05,   7.662616450128803e-08,  -5.396399970479670e-10,   3.799878419785767e-12,  -2.672499115519497e-14,
   1.864217755270219e-16,  -1.238413135349809e-18,   6.090740836949875e-21,   3.677102730340798e-23,   1.394927166108929e-02,  -9.822961592403826e-05,   6.916905596665286e-07,
  -4.870287741005739e-09,   3.428603014361883e-11,  -2.410793727802146e-13,   1.681648100739788e-15,  -1.118823935360647e-17,   5.571337375900982e-20,   3.083347315323803e-22,
   1.394937015264977e-02,  -9.823169637031520e-05,   6.917198549447757e-07,  -4.870631096704671e-09,   3.428962240631576e-11,  -2.411127809168106e-13,   1.681867279351512e-15,
  -1.118653967495610e-17,   5.557811336993661e-20,   3.127938883690216e-22,   1.394953184550775e-02,  -9.823511186570172e-05,   6.917679501044498e-07,  -4.871194805022106e-09,
   3.429552002374509e-11,  -2.411676220316937e-13,   1.682226703963407e-15,  -1.118373276684815e-17,   5.535553763581758e-20,   3.201273835897286e-22,   1.394970341823431e-02,
  -9.823873611453335e-05,   6.918189858025378e-07,  -4.871792989825167e-09,   3.430177830913563e-11,  -2.412258075795336e-13,   1.682607546913989e-15,  -1.118073181858211e-17,
   5.511865490019666e-20,   3.279265579025546e-22,   1.394983844984579e-02,  -9.824158852185776e-05,   6.918591533492869e-07,  -4.872263798227100e-09,   3.430670394359804e-11,
  -2.412715961935302e-13,   1.682906884785205e-15,  -1.117835367121679e-17,   5.493171044550434e-20,   3.340774215073952e-22,   1.394991638042146e-02,  -9.824323474377237e-05,
   6.918823357015308e-07,  -4.872535524517948e-09,   3.430954675614932e-11,  -2.412980202025956e-13,   1.683079482966573e-15,  -1.117697462092288e-17,   5.482361394387146e-20,
   3.376323674203086e-22,   1.394994564435290e-02,  -9.824385292438536e-05,   6.918910410708162e-07,  -4.872637563004295e-09,   3.431061428558073e-11,  -2.413079423974931e-13,
   1.683144265872325e-15,  -1.117645553026885e-17,   5.478298344992273e-20,   3.389682609580881e-22,   1.394995049528031e-02,  -9.824395539708798e-05,   6.918924841191127e-07,
  -4.872654477479125e-09,   3.431079124518559e-11,  -2.413095871283631e-13,   1.683155003013175e-15,  -1.117636941793963e-17,   5.477624629643773e-20,   3.391897559286695e-22,
   3.900635789410623e-02,  -2.746795421042686e-04,   1.934174761507051e-06,  -1.361878631100495e-08,   9.587383493885793e-11,  -6.741166168313046e-13,   4.701666881954596e-15,
  -3.125350344808033e-17,   1.545731953333555e-19,   9.020649184235957e-22,   3.900663330612042e-02,  -2.746853596564203e-04,   1.934256679721254e-06,  -1.361974641630142e-08,
   9.588387837421427e-11,  -6.742099364902880e-13,   4.702274761636344e-15,  -3.124854027656970e-17,   1.541874860788301e-19,   9.147609711113770e-22,   3.900708544796362e-02,
  -2.746949104065367e-04,   1.934391167932283e-06,  -1.362132268053115e-08,   9.590036723287610e-11,  -6.743631248741349e-13,   4.703271575120691e-15,  -3.124034513351513e-17,
   1.535527895315627e-19,   9.356408681515867e-22,   3.900756521688968e-02,  -2.747050448939253e-04,   1.934533878752157e-06,  -1.362299534918012e-08,   9.591786445493058e-11,
  -6.745256546658368e-13,   4.704327747551044e-15,  -3.123158510091144e-17,   1.528772973513956e-19,   9.578467344952008e-22,   3.900794280587202e-02,  -2.747130210808198e-04,
   1.934646199023913e-06,  -1.362431184266080e-08,   9.593163577841902e-11,  -6.746535556170037e-13,   4.705157855726932e-15,  -3.122464425647671e-17,   1.523442101928310e-19,
   9.753595835557981e-22,   3.900816072319106e-02,  -2.747176244113262e-04,   1.934711023697033e-06,  -1.362507165465643e-08,   9.593958384614460e-11,  -6.747273653935682e-13,
   4.705636483804396e-15,  -3.122061983901229e-17,   1.520359649462398e-19,   9.854813153579914e-22,   3.900824255394145e-02,  -2.747193530298365e-04,   1.934735366469097e-06,
  -1.362535697877294e-08,   9.594256849407094e-11,  -6.747550808721633e-13,   4.705816129491973e-15,  -3.121910508953696e-17,   1.519201041769175e-19,   9.892849101202426e-22,
   3.900825611859288e-02,  -2.747196395742651e-04,   1.934739401656413e-06,  -1.362540427570685e-08,   9.594306324584997e-11,  -6.747596750658116e-13,   4.705845903907425e-15,
  -3.121885381128473e-17,   1.519008927064967e-19,   9.899155572744428e-22,   7.724108412125151e-02,  -5.439253174675206e-04,   3.830087211605428e-06,  -2.696815480604057e-08,
   1.898504029746624e-10,  -1.334854526828634e-12,   9.308046904842759e-15,  -6.178781319062067e-17,   3.022633011380436e-19,   1.911644312179523e-21,   7.724162949701181e-02,
  -5.439368374840899e-04,   3.830249426909256e-06,  -2.697005595951988e-08,   1.898702861148608e-10,  -1.335039007841559e-12,   9.309234906123598e-15,  -6.177732352439493e-17,
   3.014759533028518e-19,   1.937501201108370e-21,   7.724252483631724e-02,  -5.439557500432903e-04,   3.830515741867036e-06,  -2.697317720041836e-08,   1.899029293325588e-10,
  -1.335341840177138e-12,   9.311182917501534e-15,  -6.176000671906235e-17,   3.001803526398296e-19,   1.980025593889094e-21,   7.724347488326255e-02,  -5.439758185290224e-04,
   3.830798339316323e-06,  -2.697648933617153e-08,   1.899375687882102e-10,  -1.335663137177044e-12,   9.313246797806543e-15,  -6.174150118679875e-17,   2.988014824617858e-19,
   2.025250775943661e-21,   7.724422259166910e-02,  -5.439916131110814e-04,   3.831020757083163e-06,  -2.697909619115230e-08,   1.899648320150173e-10,  -1.335915976697749e-12,
   9.314868826694080e-15,  -6.172684221998044e-17,   2.977133056303760e-19,   2.060918221951021e-21,   7.724465411541315e-02,  -5.440007287050773e-04,   3.831149123571835e-06,
  -2.698060073298839e-08,   1.899805668746230e-10,  -1.336061886117490e-12,   9.315804025812745e-15,  -6.171834411637976e-17,   2.970840944927500e-19,   2.081532676223794e-21,
   7.724481615811789e-02,  -5.440041517450880e-04,   3.831197327380798e-06,  -2.698116571755616e-08,   1.899864756065773e-10,  -1.336116674810850e-12,   9.316155031089022e-15,
  -6.171514578274492e-17,   2.968475919581133e-19,   2.089279294703450e-21,   7.724484301908147e-02,  -5.440047191652782e-04,   3.831205317900436e-06,  -2.698125937258165e-08,
   1.899874550706327e-10,  -1.336125756728882e-12,   9.316213206197703e-15,  -6.171461523262331e-17,   2.968083762735526e-19,   2.090563707597667e-21,   1.295202822251696e-01,
  -9.120710998186811e-04,   6.422410668346850e-06,  -4.522103140328844e-08,   3.183455154256586e-10,  -2.238221809900590e-12,   1.560251937409591e-14,  -1.033633382205443e-16,
   4.975654172965287e-19,   3.510187789575975e-21,   1.295211967283902e-01,  -9.120904169362271e-04,   6.422682674624965e-06,  -4.522421916248161e-08,   3.183788438912861e-10,
  -2.238530397264066e-12,   1.560447328275496e-14,  -1.033441408031267e-16,   4.961877677885308e-19,   3.555294489261606e-21,   1.295226980614854e-01,  -9.121221300962228e-04,
   6.423129237541871e-06,  -4.522945270254380e-08,   3.184335609624728e-10,  -2.239036951118057e-12,   1.560767694196162e-14,  -1.033124571023851e-16,   4.939208205135021e-19,
   3.629477796037881e-21,   1.295242911300707e-01,  -9.121557815492536e-04,   6.423603103296804e-06,  -4.523500632446326e-08,   3.184916240793634e-10,  -2.239574386294654e-12,
   1.561107082982286e-14,  -1.032786096032511e-16,   4.915081873504880e-19,   3.708373361998734e-21,   1.295255449110331e-01,  -9.121822663893373e-04,   6.423976058400063e-06,
  -4.523937736644687e-08,   3.185373230055436e-10,  -2.239997308732352e-12,   1.561373789049713e-14,  -1.032518056851003e-16,   4.896041947598407e-19,   3.770595961354127e-21,
   1.295262685036132e-01,  -9.121975516971751e-04,   6.424191306206252e-06,  -4.524190010544875e-08,   3.185636979303198e-10,  -2.240241368705608e-12,   1.561527551906478e-14,
  -1.032362701051503e-16,   4.885032622181348e-19,   3.806558526583829e-21,   1.295265402219147e-01,  -9.122032915557400e-04,   6.424272135433285e-06,  -4.524284744269328e-08,
   3.185736021999339e-10,  -2.240333012464207e-12,   1.561585261417243e-14,  -1.032304237600411e-16,   4.880894537536554e-19,   3.820072788700046e-21,   1.295265852632228e-01,
  -9.122042430233325e-04,   6.424285534115638e-06,  -4.524300447864987e-08,   3.185752439861564e-10,  -2.240348203560617e-12,   1.561594826012956e-14,  -1.032294539807814e-16,
   4.880208381107360e-19,   3.822313496659852e-21,   1.971760884774432e-01,  -1.388497681571426e-03,   9.777200476922199e-06,  -6.884250502332673e-08,   4.846320584189674e-10,
  -3.407151770596955e-12,   2.374093567426137e-14,  -1.568369599649090e-16,   7.377232631291593e-19,   5.993991803430333e-21,   1.971774806776227e-01,  -1.388527089098598e-03,
   9.777614564477707e-06,  -6.884735760292630e-08,   4.846827703644602e-10,  -3.407619944839335e-12,   2.374382896925542e-14,  -1.568043021875859e-16,   7.355030695771710e-19,
   6.066420240503653e-21,   1.971797662422409e-01,  -1.388575367813580e-03,   9.778294387544876e-06,  -6.885532437926209e-08,   4.847660266720401e-10,  -3.408388456835174e-12,
   2.374857233809076e-14,  -1.567504193377558e-16,   7.318497165620057e-19,   6.185538678992397e-21,   1.971821914610042e-01,  -1.388626597300184e-03,   9.779015774944033e-06,
  -6.886377839919080e-08,   4.848543740807489e-10,  -3.409203809568574e-12,   2.375359664867543e-14,  -1.566928783168377e-16,   7.279616012590540e-19,   6.312225508614864e-21,
   1.971841001629537e-01,  -1.388666916651494e-03,   9.779583541450960e-06,  -6.887043223115227e-08,   4.849239083185109e-10,  -3.409845425326393e-12,   2.375754444685951e-14,
  -1.566473270565646e-16,   7.248932086055943e-19,   6.412140947469252e-21,   1.971852017290242e-01,  -1.388690186329300e-03,   9.779911222964370e-06,  -6.887427247762375e-08,
   4.849640396342665e-10,  -3.410215685731863e-12,   2.375982024521138e-14,  -1.566209317238225e-16,   7.231189991008241e-19,   6.469889218373932e-21,   1.971856153812229e-01,
  -1.388698924436557e-03,   9.780034272967302e-06,  -6.887571456425934e-08,   4.849791096725112e-10,  -3.410354716781321e-12,   2.376067434712705e-14,  -1.566109998121995e-16,
   7.224521265863113e-19,   6.491590361378692e-21,   1.971856839501638e-01,  -1.388700372908811e-03,   9.780054670389844e-06,  -6.887595361265468e-08,   4.849816077644705e-10,
  -3.410377762881940e-12,   2.376081590125458e-14,  -1.566093523896238e-16,   7.223415491927539e-19,   6.495188485557818e-21,   2.822370287115331e-01,  -1.987489772122825e-03,
   1.399504314376875e-05,  -9.854079171614206e-08,   6.936935653185916e-10,  -4.876546900338914e-12,   3.395955342361051e-14,  -2.234642028140498e-16,   1.016584079133013e-18,
   9.881623236592662e-21,   2.822390215009316e-01,  -1.987531865896904e-03,   1.399563586092059e-05,  -9.854773703091562e-08,   6.937661028944798e-10,  -4.877213849935041e-12,
   3.396353277097697e-14,  -2.234105823362366e-16,   1.013158831768121e-18,   9.992901107529030e-21,   2.822422930483766e-01,  -1.987600971786135e-03,   1.399660894686244e-05,
  -9.855913957514951e-08,   6.938851911699403e-10,  -4.878308637890271e-12,   3.397005557348471e-14,  -2.233221410702029e-16,   1.007522568124241e-18,   1.017591562991185e-20,
   2.822457644961682e-01,  -1.987674301393488e-03,   1.399764152716339e-05,  -9.857123948817537e-08,   6.940115613237081e-10,  -4.879470132007447e-12,   3.397696324057894e-14,
  -2.232277339280180e-16,   1.001524146674150e-18,   1.037056222766761e-20,   2.822484966039953e-01,  -1.987732014292562e-03,   1.399845421738864e-05,  -9.858076285829086e-08,
   6.941110212940076e-10,  -4.880384117374604e-12,   3.398238979798673e-14,  -2.231530260342174e-16,   9.967903769359928e-19,   1.052407906923011e-20,   2.822500733809687e-01,
  -1.987765322382097e-03,   1.399892325448845e-05,  -9.858625925195912e-08,   6.941684239887607e-10,  -4.880911549332911e-12,   3.398551763147141e-14,  -2.231097465332732e-16,
   9.940532182943801e-19,   1.061280856588359e-20,   2.822506654809608e-01,  -1.987777830061015e-03,   1.399909938592511e-05,  -9.858832325357218e-08,   6.941899797250041e-10,
  -4.881109596403918e-12,   3.398669141890789e-14,  -2.230934636099253e-16,   9.930244032091641e-19,   1.064615231751256e-20,   2.822507636302503e-01,  -1.987779903396273e-03,
   1.399912858240813e-05,  -9.858866539408075e-08,   6.941935529207512e-10,  -4.881142425072221e-12,   3.398688595165161e-14,  -2.230907628442790e-16,   9.928538104175598e-19,
   1.065168083768740e-20,   3.878873693385463e-01,  -2.731470709056426e-03,   1.923383367556499e-05,  -1.354276018929023e-07,   9.533522679191391e-10,  -6.701152181886478e-12,
   4.662686315494836e-14,  -3.051053997974966e-16,   1.320068816815748e-18,   1.614084387275471e-20,   3.878901080924839e-01,  -2.731528559803778e-03,   1.923464825405060e-05,
  -1.354371458099178e-07,   9.534518591365463e-10,  -6.702062572475690e-12,   4.663201486921386e-14,  -3.050181827849202e-16,   1.314871865746315e-18,   1.630894297579405e-20,
   3.878946042843296e-01,  -2.731623534117896e-03,   1.923598557798972e-05,  -1.354528146305941e-07,   9.536153621333735e-10,  -6.703556934662406e-12,   4.664045716013285e-14,
  -3.048743756286166e-16,   1.306320256593963e-18,   1.658541574837719e-20,   3.878993752055866e-01,  -2.731724313215065e-03,   1.923740466567183e-05,  -1.354694417328174e-07,
   9.537888621683960e-10,  -6.705142307699829e-12,   4.664939455411012e-14,  -3.047209328615423e-16,   1.297219167471914e-18,   1.687946949582380e-20,   3.879031300283829e-01,
  -2.731803629797343e-03,   1.923852155568415e-05,  -1.354825282708779e-07,   9.539254153582819e-10,  -6.706389815243206e-12,   4.665641344150442e-14,  -3.045995547180180e-16,
   1.290036869643261e-18,   1.711139470402489e-20,   3.879052970431925e-01,  -2.731849406111781e-03,   1.923916615902254e-05,  -1.354900811371448e-07,   9.540042259779092e-10,
  -6.707109700139502e-12,   4.666045820235433e-14,  -3.045292570712436e-16,   1.285883924532301e-18,   1.724544515931455e-20,   3.879061107850681e-01,  -2.731866595793028e-03,
   1.923940821857377e-05,  -1.354929173833225e-07,   9.540338207354692e-10,  -6.707380009669565e-12,   4.666197591970943e-14,  -3.045028127091846e-16,   1.284322958253652e-18,
   1.729582060916744e-20,   3.879062456747623e-01,  -2.731869445240349e-03,   1.923944834365121e-05,  -1.354933875354055e-07,   9.540387265210629e-10,  -6.707424816582730e-12,
   4.666222744341908e-14,  -3.044984267028614e-16,   1.284064126910057e-18,   1.730417307504676e-20,   5.194944080386080e-01,  -3.658236552583691e-03,   2.575971469423170e-05,
  -1.813767813153660e-07,   1.276791548122778e-09,  -8.973140862962488e-12,   6.235823103849085e-14,  -4.046256641981364e-16,   1.613493877212985e-18,   2.678880312779598e-20,
   5.194980760291065e-01,  -3.658314031480410e-03,   2.576080562977265e-05,  -1.813895609416777e-07,   1.276924732800569e-09,  -8.974347750748492e-12,   6.236449441592593e-14,
  -4.044815189138513e-16,   1.605535278238549e-18,   2.704520304200446e-20,   5.195040977416585e-01,  -3.658441229578381e-03,   2.576259665929416e-05,  -1.814105420075840e-07,
   1.277143386585479e-09,  -8.976328736562809e-12,   6.237475366681130e-14,  -4.042439256700515e-16,   1.592439273658498e-18,   2.746691991831724e-20,   5.195104873970353e-01,
  -3.658576201960056e-03,   2.576449719186910e-05,  -1.814328062267033e-07,   1.277375408154068e-09,  -8.978430285273916e-12,   6.238560808560745e-14,  -4.039905207378124e-16,
   1.578501667453889e-18,   2.791547520022489e-20,   5.195155162001458e-01,  -3.658682429821186e-03,   2.576599300196334e-05,  -1.814503295051780e-07,   1.277558019747418e-09,
  -8.980083902677669e-12,   6.239412776899599e-14,  -4.037901471130381e-16,   1.567502449660995e-18,   2.826927385906437e-20,   5.195184184651533e-01,  -3.658743737555445e-03,
   2.576685629567670e-05,  -1.814604430212512e-07,   1.277663412231580e-09,  -8.981038112066521e-12,   6.239903549238979e-14,  -4.036741293104962e-16,   1.561142450211791e-18,
   2.847377215130588e-20,   5.195195083029154e-01,  -3.658766759513857e-03,   2.576718047718566e-05,  -1.814642408396025e-07,   1.277702988867995e-09,  -8.981396403415131e-12,
   6.240087665990698e-14,  -4.036304919258038e-16,   1.558751912113465e-18,   2.855062269652430e-20,   5.195196889595668e-01,  -3.658770575748534e-03,   2.576723421523469e-05,
  -1.814648703872349e-07,   1.277709549299444e-09,  -8.981455794080073e-12,   6.240118176840023e-14,  -4.036232546290739e-16,   1.558355525100196e-18,   2.856336490872355e-20,
   6.874139221459221e-01,  -4.840711815964054e-03,   3.408618696199141e-05,  -2.400037180056417e-07,   1.689443409333178e-09,  -1.187005925298729e-11,   8.232429386830493e-14,
  -5.267564225189987e-16,   1.797140610888277e-18,   4.689544062713344e-20,   6.874187757636312e-01,  -4.840814338568120e-03,   3.408763047940189e-05,  -2.400206232250834e-07,
   1.689619221128055e-09,  -1.187162940199246e-11,   8.233118869275180e-14,  -5.265051128517830e-16,   1.784366194411682e-18,   4.730616103515981e-20,   6.874267439114967e-01,
  -4.840982651239830e-03,   3.409000035545164e-05,  -2.400483774929307e-07,   1.689907855147182e-09,  -1.187420650571099e-11,   8.234247058684418e-14,  -5.260910165454023e-16,
   1.763345163736336e-18,   4.798174257466666e-20,   6.874351989346100e-01,  -4.841161251095031e-03,   3.409251512471487e-05,  -2.400778291098079e-07,   1.690214132395330e-09,
  -1.187694026263955e-11,   8.235439107977053e-14,  -5.256495451566292e-16,   1.740972528053318e-18,   4.870037876521251e-20,   6.874418532287762e-01,  -4.84130181