//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _hrr_d0_76.cc
// Copyright (C) 2009 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifdef COMPILE_J_ORB
#include <src/integral/hrrlist.h>
#include <array>
#include <algorithm>

using namespace std;
using namespace bagel;

void HRRList::perform_HRR_d0_76(const int nloop, const double* data_start, const array<double,3>& AB, double* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 476];
    auto current_out = &data_out[c * 1008];
   {
     //current index a: xxxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[147];
      const auto axyz_0 = current_data[148];
      const auto ayyz_0 = current_data[149];
      const auto axzz_0 = current_data[157];
      const auto ayzz_0 = current_data[158];
      const auto azzz_0 = current_data[166];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[214];
      const auto axxyz_0 = current_data[215];
      const auto axyyz_0 = current_data[216];
      const auto ayyyz_0 = current_data[217];
      const auto axxzz_0 = current_data[225];
      const auto axyzz_0 = current_data[226];
      const auto ayyzz_0 = current_data[227];
      const auto axzzz_0 = current_data[235];
      const auto ayzzz_0 = current_data[236];
      const auto azzzz_0 = current_data[244];
      const auto axxxxx_0 = current_data[280];
      const auto axxxxy_0 = current_data[281];
      const auto axxxyy_0 = current_data[282];
      const auto axxyyy_0 = current_data[283];
      const auto axyyyy_0 = current_data[284];
      const auto ayyyyy_0 = current_data[285];
      const auto axxxxz_0 = current_data[293];
      const auto axxxyz_0 = current_data[294];
      const auto axxyyz_0 = current_data[295];
      const auto axyyyz_0 = current_data[296];
      const auto ayyyyz_0 = current_data[297];
      const auto axxxzz_0 = current_data[305];
      const auto axxyzz_0 = current_data[306];
      const auto axyyzz_0 = current_data[307];
      const auto ayyyzz_0 = current_data[308];
      const auto axxzzz_0 = current_data[316];
      const auto axyzzz_0 = current_data[317];
      const auto ayyzzz_0 = current_data[318];
      const auto axzzzz_0 = current_data[326];
      const auto ayzzzz_0 = current_data[327];
      const auto azzzzz_0 = current_data[335];
      const auto axxxxxx_0 = current_data[371];
      const auto axxxxxy_0 = current_data[372];
      const auto axxxxyy_0 = current_data[373];
      const auto axxxyyy_0 = current_data[374];
      const auto axxyyyy_0 = current_data[375];
      const auto axyyyyy_0 = current_data[376];
      const auto ayyyyyy_0 = current_data[377];
      const auto axxxxxz_0 = current_data[385];
      const auto axxxxyz_0 = current_data[386];
      const auto axxxyyz_0 = current_data[387];
      const auto axxyyyz_0 = current_data[388];
      const auto axyyyyz_0 = current_data[389];
      const auto ayyyyyz_0 = current_data[390];
      const auto axxxxzz_0 = current_data[398];
      const auto axxxyzz_0 = current_data[399];
      const auto axxyyzz_0 = current_data[400];
      const auto axyyyzz_0 = current_data[401];
      const auto ayyyyzz_0 = current_data[402];
      const auto axxxzzz_0 = current_data[410];
      const auto axxyzzz_0 = current_data[411];
      const auto axyyzzz_0 = current_data[412];
      const auto ayyyzzz_0 = current_data[413];
      const auto axxzzzz_0 = current_data[421];
      const auto axyzzzz_0 = current_data[422];
      const auto ayyzzzz_0 = current_data[423];
      const auto axzzzzz_0 = current_data[431];
      const auto ayzzzzz_0 = current_data[432];
      const auto azzzzzz_0 = current_data[440];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[0] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[1] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[2] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[3] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[4] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[5] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[6] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[7] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[8] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[9] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[10] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[11] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[12] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[13] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[14] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[15] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[16] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[17] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[18] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[19] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[20] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[21] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[22] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[23] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[24] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[25] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[26] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[27] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[148];
      const auto axyz_0 = current_data[149];
      const auto ayyz_0 = current_data[150];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[167];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[226];
      const auto axyzz_0 = current_data[227];
      const auto ayyzz_0 = current_data[228];
      const auto axzzz_0 = current_data[236];
      const auto ayzzz_0 = current_data[237];
      const auto azzzz_0 = current_data[245];
      const auto axxxxx_0 = current_data[281];
      const auto axxxxy_0 = current_data[282];
      const auto axxxyy_0 = current_data[283];
      const auto axxyyy_0 = current_data[284];
      const auto axyyyy_0 = current_data[285];
      const auto ayyyyy_0 = current_data[286];
      const auto axxxxz_0 = current_data[294];
      const auto axxxyz_0 = current_data[295];
      const auto axxyyz_0 = current_data[296];
      const auto axyyyz_0 = current_data[297];
      const auto ayyyyz_0 = current_data[298];
      const auto axxxzz_0 = current_data[306];
      const auto axxyzz_0 = current_data[307];
      const auto axyyzz_0 = current_data[308];
      const auto ayyyzz_0 = current_data[309];
      const auto axxzzz_0 = current_data[317];
      const auto axyzzz_0 = current_data[318];
      const auto ayyzzz_0 = current_data[319];
      const auto axzzzz_0 = current_data[327];
      const auto ayzzzz_0 = current_data[328];
      const auto azzzzz_0 = current_data[336];
      const auto axxxxxx_0 = current_data[372];
      const auto axxxxxy_0 = current_data[373];
      const auto axxxxyy_0 = current_data[374];
      const auto axxxyyy_0 = current_data[375];
      const auto axxyyyy_0 = current_data[376];
      const auto axyyyyy_0 = current_data[377];
      const auto ayyyyyy_0 = current_data[378];
      const auto axxxxxz_0 = current_data[386];
      const auto axxxxyz_0 = current_data[387];
      const auto axxxyyz_0 = current_data[388];
      const auto axxyyyz_0 = current_data[389];
      const auto axyyyyz_0 = current_data[390];
      const auto ayyyyyz_0 = current_data[391];
      const auto axxxxzz_0 = current_data[399];
      const auto axxxyzz_0 = current_data[400];
      const auto axxyyzz_0 = current_data[401];
      const auto axyyyzz_0 = current_data[402];
      const auto ayyyyzz_0 = current_data[403];
      const auto axxxzzz_0 = current_data[411];
      const auto axxyzzz_0 = current_data[412];
      const auto axyyzzz_0 = current_data[413];
      const auto ayyyzzz_0 = current_data[414];
      const auto axxzzzz_0 = current_data[422];
      const auto axyzzzz_0 = current_data[423];
      const auto ayyzzzz_0 = current_data[424];
      const auto axzzzzz_0 = current_data[432];
      const auto ayzzzzz_0 = current_data[433];
      const auto azzzzzz_0 = current_data[441];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[28] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[29] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[30] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[31] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[32] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[33] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[34] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[35] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[36] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[37] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[38] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[39] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[40] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[41] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[42] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[43] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[44] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[45] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[46] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[47] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[48] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[49] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[50] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[51] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[52] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[53] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[54] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[55] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[93];
      const auto ayz_0 = current_data[94];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[168];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[227];
      const auto axyzz_0 = current_data[228];
      const auto ayyzz_0 = current_data[229];
      const auto axzzz_0 = current_data[237];
      const auto ayzzz_0 = current_data[238];
      const auto azzzz_0 = current_data[246];
      const auto axxxxx_0 = current_data[282];
      const auto axxxxy_0 = current_data[283];
      const auto axxxyy_0 = current_data[284];
      const auto axxyyy_0 = current_data[285];
      const auto axyyyy_0 = current_data[286];
      const auto ayyyyy_0 = current_data[287];
      const auto axxxxz_0 = current_data[295];
      const auto axxxyz_0 = current_data[296];
      const auto axxyyz_0 = current_data[297];
      const auto axyyyz_0 = current_data[298];
      const auto ayyyyz_0 = current_data[299];
      const auto axxxzz_0 = current_data[307];
      const auto axxyzz_0 = current_data[308];
      const auto axyyzz_0 = current_data[309];
      const auto ayyyzz_0 = current_data[310];
      const auto axxzzz_0 = current_data[318];
      const auto axyzzz_0 = current_data[319];
      const auto ayyzzz_0 = current_data[320];
      const auto axzzzz_0 = current_data[328];
      const auto ayzzzz_0 = current_data[329];
      const auto azzzzz_0 = current_data[337];
      const auto axxxxxx_0 = current_data[373];
      const auto axxxxxy_0 = current_data[374];
      const auto axxxxyy_0 = current_data[375];
      const auto axxxyyy_0 = current_data[376];
      const auto axxyyyy_0 = current_data[377];
      const auto axyyyyy_0 = current_data[378];
      const auto ayyyyyy_0 = current_data[379];
      const auto axxxxxz_0 = current_data[387];
      const auto axxxxyz_0 = current_data[388];
      const auto axxxyyz_0 = current_data[389];
      const auto axxyyyz_0 = current_data[390];
      const auto axyyyyz_0 = current_data[391];
      const auto ayyyyyz_0 = current_data[392];
      const auto axxxxzz_0 = current_data[400];
      const auto axxxyzz_0 = current_data[401];
      const auto axxyyzz_0 = current_data[402];
      const auto axyyyzz_0 = current_data[403];
      const auto ayyyyzz_0 = current_data[404];
      const auto axxxzzz_0 = current_data[412];
      const auto axxyzzz_0 = current_data[413];
      const auto axyyzzz_0 = current_data[414];
      const auto ayyyzzz_0 = current_data[415];
      const auto axxzzzz_0 = current_data[423];
      const auto axyzzzz_0 = current_data[424];
      const auto ayyzzzz_0 = current_data[425];
      const auto axzzzzz_0 = current_data[433];
      const auto ayzzzzz_0 = current_data[434];
      const auto azzzzzz_0 = current_data[442];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[56] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[57] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[58] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[59] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[60] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[61] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[62] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[63] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[64] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[65] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[66] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[67] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[68] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[69] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[70] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[71] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[72] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[73] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[74] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[75] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[76] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[77] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[78] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[79] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[80] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[81] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[82] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[83] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[160];
      const auto ayzz_0 = current_data[161];
      const auto azzz_0 = current_data[169];
      const auto axxxx_0 = current_data[205];
      const auto axxxy_0 = current_data[206];
      const auto axxyy_0 = current_data[207];
      const auto axyyy_0 = current_data[208];
      const auto ayyyy_0 = current_data[209];
      const auto axxxz_0 = current_data[217];
      const auto axxyz_0 = current_data[218];
      const auto axyyz_0 = current_data[219];
      const auto ayyyz_0 = current_data[220];
      const auto axxzz_0 = current_data[228];
      const auto axyzz_0 = current_data[229];
      const auto ayyzz_0 = current_data[230];
      const auto axzzz_0 = current_data[238];
      const auto ayzzz_0 = current_data[239];
      const auto azzzz_0 = current_data[247];
      const auto axxxxx_0 = current_data[283];
      const auto axxxxy_0 = current_data[284];
      const auto axxxyy_0 = current_data[285];
      const auto axxyyy_0 = current_data[286];
      const auto axyyyy_0 = current_data[287];
      const auto ayyyyy_0 = current_data[288];
      const auto axxxxz_0 = current_data[296];
      const auto axxxyz_0 = current_data[297];
      const auto axxyyz_0 = current_data[298];
      const auto axyyyz_0 = current_data[299];
      const auto ayyyyz_0 = current_data[300];
      const auto axxxzz_0 = current_data[308];
      const auto axxyzz_0 = current_data[309];
      const auto axyyzz_0 = current_data[310];
      const auto ayyyzz_0 = current_data[311];
      const auto axxzzz_0 = current_data[319];
      const auto axyzzz_0 = current_data[320];
      const auto ayyzzz_0 = current_data[321];
      const auto axzzzz_0 = current_data[329];
      const auto ayzzzz_0 = current_data[330];
      const auto azzzzz_0 = current_data[338];
      const auto axxxxxx_0 = current_data[374];
      const auto axxxxxy_0 = current_data[375];
      const auto axxxxyy_0 = current_data[376];
      const auto axxxyyy_0 = current_data[377];
      const auto axxyyyy_0 = current_data[378];
      const auto axyyyyy_0 = current_data[379];
      const auto ayyyyyy_0 = current_data[380];
      const auto axxxxxz_0 = current_data[388];
      const auto axxxxyz_0 = current_data[389];
      const auto axxxyyz_0 = current_data[390];
      const auto axxyyyz_0 = current_data[391];
      const auto axyyyyz_0 = current_data[392];
      const auto ayyyyyz_0 = current_data[393];
      const auto axxxxzz_0 = current_data[401];
      const auto axxxyzz_0 = current_data[402];
      const auto axxyyzz_0 = current_data[403];
      const auto axyyyzz_0 = current_data[404];
      const auto ayyyyzz_0 = current_data[405];
      const auto axxxzzz_0 = current_data[413];
      const auto axxyzzz_0 = current_data[414];
      const auto axyyzzz_0 = current_data[415];
      const auto ayyyzzz_0 = current_data[416];
      const auto axxzzzz_0 = current_data[424];
      const auto axyzzzz_0 = current_data[425];
      const auto ayyzzzz_0 = current_data[426];
      const auto axzzzzz_0 = current_data[434];
      const auto ayzzzzz_0 = current_data[435];
      const auto azzzzzz_0 = current_data[443];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[84] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[85] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[86] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[87] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[88] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[89] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[90] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[91] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[92] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[93] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[94] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[95] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[96] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[97] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[98] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[99] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[100] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[101] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[102] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[103] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[104] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[105] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[106] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[107] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[108] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[109] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[110] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[111] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[140];
      const auto axxy_0 = current_data[141];
      const auto axyy_0 = current_data[142];
      const auto ayyy_0 = current_data[143];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[170];
      const auto axxxx_0 = current_data[206];
      const auto axxxy_0 = current_data[207];
      const auto axxyy_0 = current_data[208];
      const auto axyyy_0 = current_data[209];
      const auto ayyyy_0 = current_data[210];
      const auto axxxz_0 = current_data[218];
      const auto axxyz_0 = current_data[219];
      const auto axyyz_0 = current_data[220];
      const auto ayyyz_0 = current_data[221];
      const auto axxzz_0 = current_data[229];
      const auto axyzz_0 = current_data[230];
      const auto ayyzz_0 = current_data[231];
      const auto axzzz_0 = current_data[239];
      const auto ayzzz_0 = current_data[240];
      const auto azzzz_0 = current_data[248];
      const auto axxxxx_0 = current_data[284];
      const auto axxxxy_0 = current_data[285];
      const auto axxxyy_0 = current_data[286];
      const auto axxyyy_0 = current_data[287];
      const auto axyyyy_0 = current_data[288];
      const auto ayyyyy_0 = current_data[289];
      const auto axxxxz_0 = current_data[297];
      const auto axxxyz_0 = current_data[298];
      const auto axxyyz_0 = current_data[299];
      const auto axyyyz_0 = current_data[300];
      const auto ayyyyz_0 = current_data[301];
      const auto axxxzz_0 = current_data[309];
      const auto axxyzz_0 = current_data[310];
      const auto axyyzz_0 = current_data[311];
      const auto ayyyzz_0 = current_data[312];
      const auto axxzzz_0 = current_data[320];
      const auto axyzzz_0 = current_data[321];
      const auto ayyzzz_0 = current_data[322];
      const auto axzzzz_0 = current_data[330];
      const auto ayzzzz_0 = current_data[331];
      const auto azzzzz_0 = current_data[339];
      const auto axxxxxx_0 = current_data[375];
      const auto axxxxxy_0 = current_data[376];
      const auto axxxxyy_0 = current_data[377];
      const auto axxxyyy_0 = current_data[378];
      const auto axxyyyy_0 = current_data[379];
      const auto axyyyyy_0 = current_data[380];
      const auto ayyyyyy_0 = current_data[381];
      const auto axxxxxz_0 = current_data[389];
      const auto axxxxyz_0 = current_data[390];
      const auto axxxyyz_0 = current_data[391];
      const auto axxyyyz_0 = current_data[392];
      const auto axyyyyz_0 = current_data[393];
      const auto ayyyyyz_0 = current_data[394];
      const auto axxxxzz_0 = current_data[402];
      const auto axxxyzz_0 = current_data[403];
      const auto axxyyzz_0 = current_data[404];
      const auto axyyyzz_0 = current_data[405];
      const auto ayyyyzz_0 = current_data[406];
      const auto axxxzzz_0 = current_data[414];
      const auto axxyzzz_0 = current_data[415];
      const auto axyyzzz_0 = current_data[416];
      const auto ayyyzzz_0 = current_data[417];
      const auto axxzzzz_0 = current_data[425];
      const auto axyzzzz_0 = current_data[426];
      const auto ayyzzzz_0 = current_data[427];
      const auto axzzzzz_0 = current_data[435];
      const auto ayzzzzz_0 = current_data[436];
      const auto azzzzzz_0 = current_data[444];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[112] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[113] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[114] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[115] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[116] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[117] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[118] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[119] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[120] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[121] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[122] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[123] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[124] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[125] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[126] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[127] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[128] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[129] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[130] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[131] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[132] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[133] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[134] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[135] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[136] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[137] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[138] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[139] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyyy
      const auto a0_0 = current_data[5];
      const auto ax_0 = current_data[41];
      const auto ay_0 = current_data[42];
      const auto az_0 = current_data[50];
      const auto axx_0 = current_data[86];
      const auto axy_0 = current_data[87];
      const auto ayy_0 = current_data[88];
      const auto axz_0 = current_data[96];
      const auto ayz_0 = current_data[97];
      const auto azz_0 = current_data[105];
      const auto axxx_0 = current_data[141];
      const auto axxy_0 = current_data[142];
      const auto axyy_0 = current_data[143];
      const auto ayyy_0 = current_data[144];
      const auto axxz_0 = current_data[152];
      const auto axyz_0 = current_data[153];
      const auto ayyz_0 = current_data[154];
      const auto axzz_0 = current_data[162];
      const auto ayzz_0 = current_data[163];
      const auto azzz_0 = current_data[171];
      const auto axxxx_0 = current_data[207];
      const auto axxxy_0 = current_data[208];
      const auto axxyy_0 = current_data[209];
      const auto axyyy_0 = current_data[210];
      const auto ayyyy_0 = current_data[211];
      const auto axxxz_0 = current_data[219];
      const auto axxyz_0 = current_data[220];
      const auto axyyz_0 = current_data[221];
      const auto ayyyz_0 = current_data[222];
      const auto axxzz_0 = current_data[230];
      const auto axyzz_0 = current_data[231];
      const auto ayyzz_0 = current_data[232];
      const auto axzzz_0 = current_data[240];
      const auto ayzzz_0 = current_data[241];
      const auto azzzz_0 = current_data[249];
      const auto axxxxx_0 = current_data[285];
      const auto axxxxy_0 = current_data[286];
      const auto axxxyy_0 = current_data[287];
      const auto axxyyy_0 = current_data[288];
      const auto axyyyy_0 = current_data[289];
      const auto ayyyyy_0 = current_data[290];
      const auto axxxxz_0 = current_data[298];
      const auto axxxyz_0 = current_data[299];
      const auto axxyyz_0 = current_data[300];
      const auto axyyyz_0 = current_data[301];
      const auto ayyyyz_0 = current_data[302];
      const auto axxxzz_0 = current_data[310];
      const auto axxyzz_0 = current_data[311];
      const auto axyyzz_0 = current_data[312];
      const auto ayyyzz_0 = current_data[313];
      const auto axxzzz_0 = current_data[321];
      const auto axyzzz_0 = current_data[322];
      const auto ayyzzz_0 = current_data[323];
      const auto axzzzz_0 = current_data[331];
      const auto ayzzzz_0 = current_data[332];
      const auto azzzzz_0 = current_data[340];
      const auto axxxxxx_0 = current_data[376];
      const auto axxxxxy_0 = current_data[377];
      const auto axxxxyy_0 = current_data[378];
      const auto axxxyyy_0 = current_data[379];
      const auto axxyyyy_0 = current_data[380];
      const auto axyyyyy_0 = current_data[381];
      const auto ayyyyyy_0 = current_data[382];
      const auto axxxxxz_0 = current_data[390];
      const auto axxxxyz_0 = current_data[391];
      const auto axxxyyz_0 = current_data[392];
      const auto axxyyyz_0 = current_data[393];
      const auto axyyyyz_0 = current_data[394];
      const auto ayyyyyz_0 = current_data[395];
      const auto axxxxzz_0 = current_data[403];
      const auto axxxyzz_0 = current_data[404];
      const auto axxyyzz_0 = current_data[405];
      const auto axyyyzz_0 = current_data[406];
      const auto ayyyyzz_0 = current_data[407];
      const auto axxxzzz_0 = current_data[415];
      const auto axxyzzz_0 = current_data[416];
      const auto axyyzzz_0 = current_data[417];
      const auto ayyyzzz_0 = current_data[418];
      const auto axxzzzz_0 = current_data[426];
      const auto axyzzzz_0 = current_data[427];
      const auto ayyzzzz_0 = current_data[428];
      const auto axzzzzz_0 = current_data[436];
      const auto ayzzzzz_0 = current_data[437];
      const auto azzzzzz_0 = current_data[445];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[140] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[141] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[142] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[143] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[144] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[145] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[146] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[147] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[148] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[149] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[150] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[151] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[152] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[153] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[154] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[155] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[156] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[157] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[158] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[159] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[160] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[161] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[162] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[163] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[164] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[165] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[166] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[167] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyyy
      const auto a0_0 = current_data[6];
      const auto ax_0 = current_data[42];
      const auto ay_0 = current_data[43];
      const auto az_0 = current_data[51];
      const auto axx_0 = current_data[87];
      const auto axy_0 = current_data[88];
      const auto ayy_0 = current_data[89];
      const auto axz_0 = current_data[97];
      const auto ayz_0 = current_data[98];
      const auto azz_0 = current_data[106];
      const auto axxx_0 = current_data[142];
      const auto axxy_0 = current_data[143];
      const auto axyy_0 = current_data[144];
      const auto ayyy_0 = current_data[145];
      const auto axxz_0 = current_data[153];
      const auto axyz_0 = current_data[154];
      const auto ayyz_0 = current_data[155];
      const auto axzz_0 = current_data[163];
      const auto ayzz_0 = current_data[164];
      const auto azzz_0 = current_data[172];
      const auto axxxx_0 = current_data[208];
      const auto axxxy_0 = current_data[209];
      const auto axxyy_0 = current_data[210];
      const auto axyyy_0 = current_data[211];
      const auto ayyyy_0 = current_data[212];
      const auto axxxz_0 = current_data[220];
      const auto axxyz_0 = current_data[221];
      const auto axyyz_0 = current_data[222];
      const auto ayyyz_0 = current_data[223];
      const auto axxzz_0 = current_data[231];
      const auto axyzz_0 = current_data[232];
      const auto ayyzz_0 = current_data[233];
      const auto axzzz_0 = current_data[241];
      const auto ayzzz_0 = current_data[242];
      const auto azzzz_0 = current_data[250];
      const auto axxxxx_0 = current_data[286];
      const auto axxxxy_0 = current_data[287];
      const auto axxxyy_0 = current_data[288];
      const auto axxyyy_0 = current_data[289];
      const auto axyyyy_0 = current_data[290];
      const auto ayyyyy_0 = current_data[291];
      const auto axxxxz_0 = current_data[299];
      const auto axxxyz_0 = current_data[300];
      const auto axxyyz_0 = current_data[301];
      const auto axyyyz_0 = current_data[302];
      const auto ayyyyz_0 = current_data[303];
      const auto axxxzz_0 = current_data[311];
      const auto axxyzz_0 = current_data[312];
      const auto axyyzz_0 = current_data[313];
      const auto ayyyzz_0 = current_data[314];
      const auto axxzzz_0 = current_data[322];
      const auto axyzzz_0 = current_data[323];
      const auto ayyzzz_0 = current_data[324];
      const auto axzzzz_0 = current_data[332];
      const auto ayzzzz_0 = current_data[333];
      const auto azzzzz_0 = current_data[341];
      const auto axxxxxx_0 = current_data[377];
      const auto axxxxxy_0 = current_data[378];
      const auto axxxxyy_0 = current_data[379];
      const auto axxxyyy_0 = current_data[380];
      const auto axxyyyy_0 = current_data[381];
      const auto axyyyyy_0 = current_data[382];
      const auto ayyyyyy_0 = current_data[383];
      const auto axxxxxz_0 = current_data[391];
      const auto axxxxyz_0 = current_data[392];
      const auto axxxyyz_0 = current_data[393];
      const auto axxyyyz_0 = current_data[394];
      const auto axyyyyz_0 = current_data[395];
      const auto ayyyyyz_0 = current_data[396];
      const auto axxxxzz_0 = current_data[404];
      const auto axxxyzz_0 = current_data[405];
      const auto axxyyzz_0 = current_data[406];
      const auto axyyyzz_0 = current_data[407];
      const auto ayyyyzz_0 = current_data[408];
      const auto axxxzzz_0 = current_data[416];
      const auto axxyzzz_0 = current_data[417];
      const auto axyyzzz_0 = current_data[418];
      const auto ayyyzzz_0 = current_data[419];
      const auto axxzzzz_0 = current_data[427];
      const auto axyzzzz_0 = current_data[428];
      const auto ayyzzzz_0 = current_data[429];
      const auto axzzzzz_0 = current_data[437];
      const auto ayzzzzz_0 = current_data[438];
      const auto azzzzzz_0 = current_data[446];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[168] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[169] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[170] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[171] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[172] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[173] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[174] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[175] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[176] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[177] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[178] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[179] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[180] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[181] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[182] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[183] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[184] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[185] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[186] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[187] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[188] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[189] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[190] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[191] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[192] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[193] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[194] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[195] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyyy
      const auto a0_0 = current_data[7];
      const auto ax_0 = current_data[43];
      const auto ay_0 = current_data[44];
      const auto az_0 = current_data[52];
      const auto axx_0 = current_data[88];
      const auto axy_0 = current_data[89];
      const auto ayy_0 = current_data[90];
      const auto axz_0 = current_data[98];
      const auto ayz_0 = current_data[99];
      const auto azz_0 = current_data[107];
      const auto axxx_0 = current_data[143];
      const auto axxy_0 = current_data[144];
      const auto axyy_0 = current_data[145];
      const auto ayyy_0 = current_data[146];
      const auto axxz_0 = current_data[154];
      const auto axyz_0 = current_data[155];
      const auto ayyz_0 = current_data[156];
      const auto axzz_0 = current_data[164];
      const auto ayzz_0 = current_data[165];
      const auto azzz_0 = current_data[173];
      const auto axxxx_0 = current_data[209];
      const auto axxxy_0 = current_data[210];
      const auto axxyy_0 = current_data[211];
      const auto axyyy_0 = current_data[212];
      const auto ayyyy_0 = current_data[213];
      const auto axxxz_0 = current_data[221];
      const auto axxyz_0 = current_data[222];
      const auto axyyz_0 = current_data[223];
      const auto ayyyz_0 = current_data[224];
      const auto axxzz_0 = current_data[232];
      const auto axyzz_0 = current_data[233];
      const auto ayyzz_0 = current_data[234];
      const auto axzzz_0 = current_data[242];
      const auto ayzzz_0 = current_data[243];
      const auto azzzz_0 = current_data[251];
      const auto axxxxx_0 = current_data[287];
      const auto axxxxy_0 = current_data[288];
      const auto axxxyy_0 = current_data[289];
      const auto axxyyy_0 = current_data[290];
      const auto axyyyy_0 = current_data[291];
      const auto ayyyyy_0 = current_data[292];
      const auto axxxxz_0 = current_data[300];
      const auto axxxyz_0 = current_data[301];
      const auto axxyyz_0 = current_data[302];
      const auto axyyyz_0 = current_data[303];
      const auto ayyyyz_0 = current_data[304];
      const auto axxxzz_0 = current_data[312];
      const auto axxyzz_0 = current_data[313];
      const auto axyyzz_0 = current_data[314];
      const auto ayyyzz_0 = current_data[315];
      const auto axxzzz_0 = current_data[323];
      const auto axyzzz_0 = current_data[324];
      const auto ayyzzz_0 = current_data[325];
      const auto axzzzz_0 = current_data[333];
      const auto ayzzzz_0 = current_data[334];
      const auto azzzzz_0 = current_data[342];
      const auto axxxxxx_0 = current_data[378];
      const auto axxxxxy_0 = current_data[379];
      const auto axxxxyy_0 = current_data[380];
      const auto axxxyyy_0 = current_data[381];
      const auto axxyyyy_0 = current_data[382];
      const auto axyyyyy_0 = current_data[383];
      const auto ayyyyyy_0 = current_data[384];
      const auto axxxxxz_0 = current_data[392];
      const auto axxxxyz_0 = current_data[393];
      const auto axxxyyz_0 = current_data[394];
      const auto axxyyyz_0 = current_data[395];
      const auto axyyyyz_0 = current_data[396];
      const auto ayyyyyz_0 = current_data[397];
      const auto axxxxzz_0 = current_data[405];
      const auto axxxyzz_0 = current_data[406];
      const auto axxyyzz_0 = current_data[407];
      const auto axyyyzz_0 = current_data[408];
      const auto ayyyyzz_0 = current_data[409];
      const auto axxxzzz_0 = current_data[417];
      const auto axxyzzz_0 = current_data[418];
      const auto axyyzzz_0 = current_data[419];
      const auto ayyyzzz_0 = current_data[420];
      const auto axxzzzz_0 = current_data[428];
      const auto axyzzzz_0 = current_data[429];
      const auto ayyzzzz_0 = current_data[430];
      const auto axzzzzz_0 = current_data[438];
      const auto ayzzzzz_0 = current_data[439];
      const auto azzzzzz_0 = current_data[447];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[196] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[197] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[198] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[199] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[200] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[201] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[202] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[203] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[204] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[205] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[206] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[207] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[208] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[209] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[210] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[211] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[212] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[213] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[214] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[215] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[216] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[217] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[218] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[219] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[220] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[221] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[222] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[223] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxxz
      const auto a0_0 = current_data[8];
      const auto ax_0 = current_data[45];
      const auto ay_0 = current_data[46];
      const auto az_0 = current_data[53];
      const auto axx_0 = current_data[91];
      const auto axy_0 = current_data[92];
      const auto ayy_0 = current_data[93];
      const auto axz_0 = current_data[100];
      const auto ayz_0 = current_data[101];
      const auto azz_0 = current_data[108];
      const auto axxx_0 = current_data[147];
      const auto axxy_0 = current_data[148];
      const auto axyy_0 = current_data[149];
      const auto ayyy_0 = current_data[150];
      const auto axxz_0 = current_data[157];
      const auto axyz_0 = current_data[158];
      const auto ayyz_0 = current_data[159];
      const auto axzz_0 = current_data[166];
      const auto ayzz_0 = current_data[167];
      const auto azzz_0 = current_data[174];
      const auto axxxx_0 = current_data[214];
      const auto axxxy_0 = current_data[215];
      const auto axxyy_0 = current_data[216];
      const auto axyyy_0 = current_data[217];
      const auto ayyyy_0 = current_data[218];
      const auto axxxz_0 = current_data[225];
      const auto axxyz_0 = current_data[226];
      const auto axyyz_0 = current_data[227];
      const auto ayyyz_0 = current_data[228];
      const auto axxzz_0 = current_data[235];
      const auto axyzz_0 = current_data[236];
      const auto ayyzz_0 = current_data[237];
      const auto axzzz_0 = current_data[244];
      const auto ayzzz_0 = current_data[245];
      const auto azzzz_0 = current_data[252];
      const auto axxxxx_0 = current_data[293];
      const auto axxxxy_0 = current_data[294];
      const auto axxxyy_0 = current_data[295];
      const auto axxyyy_0 = current_data[296];
      const auto axyyyy_0 = current_data[297];
      const auto ayyyyy_0 = current_data[298];
      const auto axxxxz_0 = current_data[305];
      const auto axxxyz_0 = current_data[306];
      const auto axxyyz_0 = current_data[307];
      const auto axyyyz_0 = current_data[308];
      const auto ayyyyz_0 = current_data[309];
      const auto axxxzz_0 = current_data[316];
      const auto axxyzz_0 = current_data[317];
      const auto axyyzz_0 = current_data[318];
      const auto ayyyzz_0 = current_data[319];
      const auto axxzzz_0 = current_data[326];
      const auto axyzzz_0 = current_data[327];
      const auto ayyzzz_0 = current_data[328];
      const auto axzzzz_0 = current_data[335];
      const auto ayzzzz_0 = current_data[336];
      const auto azzzzz_0 = current_data[343];
      const auto axxxxxx_0 = current_data[385];
      const auto axxxxxy_0 = current_data[386];
      const auto axxxxyy_0 = current_data[387];
      const auto axxxyyy_0 = current_data[388];
      const auto axxyyyy_0 = current_data[389];
      const auto axyyyyy_0 = current_data[390];
      const auto ayyyyyy_0 = current_data[391];
      const auto axxxxxz_0 = current_data[398];
      const auto axxxxyz_0 = current_data[399];
      const auto axxxyyz_0 = current_data[400];
      const auto axxyyyz_0 = current_data[401];
      const auto axyyyyz_0 = current_data[402];
      const auto ayyyyyz_0 = current_data[403];
      const auto axxxxzz_0 = current_data[410];
      const auto axxxyzz_0 = current_data[411];
      const auto axxyyzz_0 = current_data[412];
      const auto axyyyzz_0 = current_data[413];
      const auto ayyyyzz_0 = current_data[414];
      const auto axxxzzz_0 = current_data[421];
      const auto axxyzzz_0 = current_data[422];
      const auto axyyzzz_0 = current_data[423];
      const auto ayyyzzz_0 = current_data[424];
      const auto axxzzzz_0 = current_data[431];
      const auto axyzzzz_0 = current_data[432];
      const auto ayyzzzz_0 = current_data[433];
      const auto axzzzzz_0 = current_data[440];
      const auto ayzzzzz_0 = current_data[441];
      const auto azzzzzz_0 = current_data[448];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[224] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[225] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[226] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[227] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[228] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[229] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[230] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[231] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[232] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[233] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[234] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[235] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[236] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[237] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[238] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[239] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[240] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[241] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[242] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[243] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[244] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[245] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[246] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[247] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[248] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[249] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[250] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[251] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxyz
      const auto a0_0 = current_data[9];
      const auto ax_0 = current_data[46];
      const auto ay_0 = current_data[47];
      const auto az_0 = current_data[54];
      const auto axx_0 = current_data[92];
      const auto axy_0 = current_data[93];
      const auto ayy_0 = current_data[94];
      const auto axz_0 = current_data[101];
      const auto ayz_0 = current_data[102];
      const auto azz_0 = current_data[109];
      const auto axxx_0 = current_data[148];
      const auto axxy_0 = current_data[149];
      const auto axyy_0 = current_data[150];
      const auto ayyy_0 = current_data[151];
      const auto axxz_0 = current_data[158];
      const auto axyz_0 = current_data[159];
      const auto ayyz_0 = current_data[160];
      const auto axzz_0 = current_data[167];
      const auto ayzz_0 = current_data[168];
      const auto azzz_0 = current_data[175];
      const auto axxxx_0 = current_data[215];
      const auto axxxy_0 = current_data[216];
      const auto axxyy_0 = current_data[217];
      const auto axyyy_0 = current_data[218];
      const auto ayyyy_0 = current_data[219];
      const auto axxxz_0 = current_data[226];
      const auto axxyz_0 = current_data[227];
      const auto axyyz_0 = current_data[228];
      const auto ayyyz_0 = current_data[229];
      const auto axxzz_0 = current_data[236];
      const auto axyzz_0 = current_data[237];
      const auto ayyzz_0 = current_data[238];
      const auto axzzz_0 = current_data[245];
      const auto ayzzz_0 = current_data[246];
      const auto azzzz_0 = current_data[253];
      const auto axxxxx_0 = current_data[294];
      const auto axxxxy_0 = current_data[295];
      const auto axxxyy_0 = current_data[296];
      const auto axxyyy_0 = current_data[297];
      const auto axyyyy_0 = current_data[298];
      const auto ayyyyy_0 = current_data[299];
      const auto axxxxz_0 = current_data[306];
      const auto axxxyz_0 = current_data[307];
      const auto axxyyz_0 = current_data[308];
      const auto axyyyz_0 = current_data[309];
      const auto ayyyyz_0 = current_data[310];
      const auto axxxzz_0 = current_data[317];
      const auto axxyzz_0 = current_data[318];
      const auto axyyzz_0 = current_data[319];
      const auto ayyyzz_0 = current_data[320];
      const auto axxzzz_0 = current_data[327];
      const auto axyzzz_0 = current_data[328];
      const auto ayyzzz_0 = current_data[329];
      const auto axzzzz_0 = current_data[336];
      const auto ayzzzz_0 = current_data[337];
      const auto azzzzz_0 = current_data[344];
      const auto axxxxxx_0 = current_data[386];
      const auto axxxxxy_0 = current_data[387];
      const auto axxxxyy_0 = current_data[388];
      const auto axxxyyy_0 = current_data[389];
      const auto axxyyyy_0 = current_data[390];
      const auto axyyyyy_0 = current_data[391];
      const auto ayyyyyy_0 = current_data[392];
      const auto axxxxxz_0 = current_data[399];
      const auto axxxxyz_0 = current_data[400];
      const auto axxxyyz_0 = current_data[401];
      const auto axxyyyz_0 = current_data[402];
      const auto axyyyyz_0 = current_data[403];
      const auto ayyyyyz_0 = current_data[404];
      const auto axxxxzz_0 = current_data[411];
      const auto axxxyzz_0 = current_data[412];
      const auto axxyyzz_0 = current_data[413];
      const auto axyyyzz_0 = current_data[414];
      const auto ayyyyzz_0 = current_data[415];
      const auto axxxzzz_0 = current_data[422];
      const auto axxyzzz_0 = current_data[423];
      const auto axyyzzz_0 = current_data[424];
      const auto ayyyzzz_0 = current_data[425];
      const auto axxzzzz_0 = current_data[432];
      const auto axyzzzz_0 = current_data[433];
      const auto ayyzzzz_0 = current_data[434];
      const auto axzzzzz_0 = current_data[441];
      const auto ayzzzzz_0 = current_data[442];
      const auto azzzzzz_0 = current_data[449];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[252] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[253] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[254] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[255] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[256] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[257] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[258] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[259] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[260] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[261] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[262] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[263] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[264] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[265] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[266] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[267] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[268] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[269] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[270] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[271] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[272] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[273] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[274] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[275] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[276] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[277] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[278] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[279] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyyz
      const auto a0_0 = current_data[10];
      const auto ax_0 = current_data[47];
      const auto ay_0 = current_data[48];
      const auto az_0 = current_data[55];
      const auto axx_0 = current_data[93];
      const auto axy_0 = current_data[94];
      const auto ayy_0 = current_data[95];
      const auto axz_0 = current_data[102];
      const auto ayz_0 = current_data[103];
      const auto azz_0 = current_data[110];
      const auto axxx_0 = current_data[149];
      const auto axxy_0 = current_data[150];
      const auto axyy_0 = current_data[151];
      const auto ayyy_0 = current_data[152];
      const auto axxz_0 = current_data[159];
      const auto axyz_0 = current_data[160];
      const auto ayyz_0 = current_data[161];
      const auto axzz_0 = current_data[168];
      const auto ayzz_0 = current_data[169];
      const auto azzz_0 = current_data[176];
      const auto axxxx_0 = current_data[216];
      const auto axxxy_0 = current_data[217];
      const auto axxyy_0 = current_data[218];
      const auto axyyy_0 = current_data[219];
      const auto ayyyy_0 = current_data[220];
      const auto axxxz_0 = current_data[227];
      const auto axxyz_0 = current_data[228];
      const auto axyyz_0 = current_data[229];
      const auto ayyyz_0 = current_data[230];
      const auto axxzz_0 = current_data[237];
      const auto axyzz_0 = current_data[238];
      const auto ayyzz_0 = current_data[239];
      const auto axzzz_0 = current_data[246];
      const auto ayzzz_0 = current_data[247];
      const auto azzzz_0 = current_data[254];
      const auto axxxxx_0 = current_data[295];
      const auto axxxxy_0 = current_data[296];
      const auto axxxyy_0 = current_data[297];
      const auto axxyyy_0 = current_data[298];
      const auto axyyyy_0 = current_data[299];
      const auto ayyyyy_0 = current_data[300];
      const auto axxxxz_0 = current_data[307];
      const auto axxxyz_0 = current_data[308];
      const auto axxyyz_0 = current_data[309];
      const auto axyyyz_0 = current_data[310];
      const auto ayyyyz_0 = current_data[311];
      const auto axxxzz_0 = current_data[318];
      const auto axxyzz_0 = current_data[319];
      const auto axyyzz_0 = current_data[320];
      const auto ayyyzz_0 = current_data[321];
      const auto axxzzz_0 = current_data[328];
      const auto axyzzz_0 = current_data[329];
      const auto ayyzzz_0 = current_data[330];
      const auto axzzzz_0 = current_data[337];
      const auto ayzzzz_0 = current_data[338];
      const auto azzzzz_0 = current_data[345];
      const auto axxxxxx_0 = current_data[387];
      const auto axxxxxy_0 = current_data[388];
      const auto axxxxyy_0 = current_data[389];
      const auto axxxyyy_0 = current_data[390];
      const auto axxyyyy_0 = current_data[391];
      const auto axyyyyy_0 = current_data[392];
      const auto ayyyyyy_0 = current_data[393];
      const auto axxxxxz_0 = current_data[400];
      const auto axxxxyz_0 = current_data[401];
      const auto axxxyyz_0 = current_data[402];
      const auto axxyyyz_0 = current_data[403];
      const auto axyyyyz_0 = current_data[404];
      const auto ayyyyyz_0 = current_data[405];
      const auto axxxxzz_0 = current_data[412];
      const auto axxxyzz_0 = current_data[413];
      const auto axxyyzz_0 = current_data[414];
      const auto axyyyzz_0 = current_data[415];
      const auto ayyyyzz_0 = current_data[416];
      const auto axxxzzz_0 = current_data[423];
      const auto axxyzzz_0 = current_data[424];
      const auto axyyzzz_0 = current_data[425];
      const auto ayyyzzz_0 = current_data[426];
      const auto axxzzzz_0 = current_data[433];
      const auto axyzzzz_0 = current_data[434];
      const auto ayyzzzz_0 = current_data[435];
      const auto axzzzzz_0 = current_data[442];
      const auto ayzzzzz_0 = current_data[443];
      const auto azzzzzz_0 = current_data[450];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[280] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[281] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[282] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[283] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[284] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[285] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[286] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[287] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[288] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[289] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[290] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[291] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[292] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[293] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[294] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[295] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[296] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[297] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[298] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[299] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[300] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[301] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[302] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[303] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[304] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[305] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[306] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[307] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyyz
      const auto a0_0 = current_data[11];
      const auto ax_0 = current_data[48];
      const auto ay_0 = current_data[49];
      const auto az_0 = current_data[56];
      const auto axx_0 = current_data[94];
      const auto axy_0 = current_data[95];
      const auto ayy_0 = current_data[96];
      const auto axz_0 = current_data[103];
      const auto ayz_0 = current_data[104];
      const auto azz_0 = current_data[111];
      const auto axxx_0 = current_data[150];
      const auto axxy_0 = current_data[151];
      const auto axyy_0 = current_data[152];
      const auto ayyy_0 = current_data[153];
      const auto axxz_0 = current_data[160];
      const auto axyz_0 = current_data[161];
      const auto ayyz_0 = current_data[162];
      const auto axzz_0 = current_data[169];
      const auto ayzz_0 = current_data[170];
      const auto azzz_0 = current_data[177];
      const auto axxxx_0 = current_data[217];
      const auto axxxy_0 = current_data[218];
      const auto axxyy_0 = current_data[219];
      const auto axyyy_0 = current_data[220];
      const auto ayyyy_0 = current_data[221];
      const auto axxxz_0 = current_data[228];
      const auto axxyz_0 = current_data[229];
      const auto axyyz_0 = current_data[230];
      const auto ayyyz_0 = current_data[231];
      const auto axxzz_0 = current_data[238];
      const auto axyzz_0 = current_data[239];
      const auto ayyzz_0 = current_data[240];
      const auto axzzz_0 = current_data[247];
      const auto ayzzz_0 = current_data[248];
      const auto azzzz_0 = current_data[255];
      const auto axxxxx_0 = current_data[296];
      const auto axxxxy_0 = current_data[297];
      const auto axxxyy_0 = current_data[298];
      const auto axxyyy_0 = current_data[299];
      const auto axyyyy_0 = current_data[300];
      const auto ayyyyy_0 = current_data[301];
      const auto axxxxz_0 = current_data[308];
      const auto axxxyz_0 = current_data[309];
      const auto axxyyz_0 = current_data[310];
      const auto axyyyz_0 = current_data[311];
      const auto ayyyyz_0 = current_data[312];
      const auto axxxzz_0 = current_data[319];
      const auto axxyzz_0 = current_data[320];
      const auto axyyzz_0 = current_data[321];
      const auto ayyyzz_0 = current_data[322];
      const auto axxzzz_0 = current_data[329];
      const auto axyzzz_0 = current_data[330];
      const auto ayyzzz_0 = current_data[331];
      const auto axzzzz_0 = current_data[338];
      const auto ayzzzz_0 = current_data[339];
      const auto azzzzz_0 = current_data[346];
      const auto axxxxxx_0 = current_data[388];
      const auto axxxxxy_0 = current_data[389];
      const auto axxxxyy_0 = current_data[390];
      const auto axxxyyy_0 = current_data[391];
      const auto axxyyyy_0 = current_data[392];
      const auto axyyyyy_0 = current_data[393];
      const auto ayyyyyy_0 = current_data[394];
      const auto axxxxxz_0 = current_data[401];
      const auto axxxxyz_0 = current_data[402];
      const auto axxxyyz_0 = current_data[403];
      const auto axxyyyz_0 = current_data[404];
      const auto axyyyyz_0 = current_data[405];
      const auto ayyyyyz_0 = current_data[406];
      const auto axxxxzz_0 = current_data[413];
      const auto axxxyzz_0 = current_data[414];
      const auto axxyyzz_0 = current_data[415];
      const auto axyyyzz_0 = current_data[416];
      const auto ayyyyzz_0 = current_data[417];
      const auto axxxzzz_0 = current_data[424];
      const auto axxyzzz_0 = current_data[425];
      const auto axyyzzz_0 = current_data[426];
      const auto ayyyzzz_0 = current_data[427];
      const auto axxzzzz_0 = current_data[434];
      const auto axyzzzz_0 = current_data[435];
      const auto ayyzzzz_0 = current_data[436];
      const auto axzzzzz_0 = current_data[443];
      const auto ayzzzzz_0 = current_data[444];
      const auto azzzzzz_0 = current_data[451];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[308] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[309] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[310] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[311] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[312] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[313] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[314] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[315] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[316] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[317] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[318] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[319] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[320] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[321] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[322] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[323] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[324] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[325] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[326] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[327] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[328] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[329] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[330] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[331] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[332] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[333] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[334] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[335] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyyz
      const auto a0_0 = current_data[12];
      const auto ax_0 = current_data[49];
      const auto ay_0 = current_data[50];
      const auto az_0 = current_data[57];
      const auto axx_0 = current_data[95];
      const auto axy_0 = current_data[96];
      const auto ayy_0 = current_data[97];
      const auto axz_0 = current_data[104];
      const auto ayz_0 = current_data[105];
      const auto azz_0 = current_data[112];
      const auto axxx_0 = current_data[151];
      const auto axxy_0 = current_data[152];
      const auto axyy_0 = current_data[153];
      const auto ayyy_0 = current_data[154];
      const auto axxz_0 = current_data[161];
      const auto axyz_0 = current_data[162];
      const auto ayyz_0 = current_data[163];
      const auto axzz_0 = current_data[170];
      const auto ayzz_0 = current_data[171];
      const auto azzz_0 = current_data[178];
      const auto axxxx_0 = current_data[218];
      const auto axxxy_0 = current_data[219];
      const auto axxyy_0 = current_data[220];
      const auto axyyy_0 = current_data[221];
      const auto ayyyy_0 = current_data[222];
      const auto axxxz_0 = current_data[229];
      const auto axxyz_0 = current_data[230];
      const auto axyyz_0 = current_data[231];
      const auto ayyyz_0 = current_data[232];
      const auto axxzz_0 = current_data[239];
      const auto axyzz_0 = current_data[240];
      const auto ayyzz_0 = current_data[241];
      const auto axzzz_0 = current_data[248];
      const auto ayzzz_0 = current_data[249];
      const auto azzzz_0 = current_data[256];
      const auto axxxxx_0 = current_data[297];
      const auto axxxxy_0 = current_data[298];
      const auto axxxyy_0 = current_data[299];
      const auto axxyyy_0 = current_data[300];
      const auto axyyyy_0 = current_data[301];
      const auto ayyyyy_0 = current_data[302];
      const auto axxxxz_0 = current_data[309];
      const auto axxxyz_0 = current_data[310];
      const auto axxyyz_0 = current_data[311];
      const auto axyyyz_0 = current_data[312];
      const auto ayyyyz_0 = current_data[313];
      const auto axxxzz_0 = current_data[320];
      const auto axxyzz_0 = current_data[321];
      const auto axyyzz_0 = current_data[322];
      const auto ayyyzz_0 = current_data[323];
      const auto axxzzz_0 = current_data[330];
      const auto axyzzz_0 = current_data[331];
      const auto ayyzzz_0 = current_data[332];
      const auto axzzzz_0 = current_data[339];
      const auto ayzzzz_0 = current_data[340];
      const auto azzzzz_0 = current_data[347];
      const auto axxxxxx_0 = current_data[389];
      const auto axxxxxy_0 = current_data[390];
      const auto axxxxyy_0 = current_data[391];
      const auto axxxyyy_0 = current_data[392];
      const auto axxyyyy_0 = current_data[393];
      const auto axyyyyy_0 = current_data[394];
      const auto ayyyyyy_0 = current_data[395];
      const auto axxxxxz_0 = current_data[402];
      const auto axxxxyz_0 = current_data[403];
      const auto axxxyyz_0 = current_data[404];
      const auto axxyyyz_0 = current_data[405];
      const auto axyyyyz_0 = current_data[406];
      const auto ayyyyyz_0 = current_data[407];
      const auto axxxxzz_0 = current_data[414];
      const auto axxxyzz_0 = current_data[415];
      const auto axxyyzz_0 = current_data[416];
      const auto axyyyzz_0 = current_data[417];
      const auto ayyyyzz_0 = current_data[418];
      const auto axxxzzz_0 = current_data[425];
      const auto axxyzzz_0 = current_data[426];
      const auto axyyzzz_0 = current_data[427];
      const auto ayyyzzz_0 = current_data[428];
      const auto axxzzzz_0 = current_data[435];
      const auto axyzzzz_0 = current_data[436];
      const auto ayyzzzz_0 = current_data[437];
      const auto axzzzzz_0 = current_data[444];
      const auto ayzzzzz_0 = current_data[445];
      const auto azzzzzz_0 = current_data[452];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[336] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[337] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[338] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[339] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[340] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[341] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[342] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[343] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[344] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[345] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[346] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[347] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[348] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[349] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[350] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[351] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[352] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[353] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[354] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[355] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[356] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[357] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[358] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[359] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[360] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[361] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[362] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[363] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyyz
      const auto a0_0 = current_data[13];
      const auto ax_0 = current_data[50];
      const auto ay_0 = current_data[51];
      const auto az_0 = current_data[58];
      const auto axx_0 = current_data[96];
      const auto axy_0 = current_data[97];
      const auto ayy_0 = current_data[98];
      const auto axz_0 = current_data[105];
      const auto ayz_0 = current_data[106];
      const auto azz_0 = current_data[113];
      const auto axxx_0 = current_data[152];
      const auto axxy_0 = current_data[153];
      const auto axyy_0 = current_data[154];
      const auto ayyy_0 = current_data[155];
      const auto axxz_0 = current_data[162];
      const auto axyz_0 = current_data[163];
      const auto ayyz_0 = current_data[164];
      const auto axzz_0 = current_data[171];
      const auto ayzz_0 = current_data[172];
      const auto azzz_0 = current_data[179];
      const auto axxxx_0 = current_data[219];
      const auto axxxy_0 = current_data[220];
      const auto axxyy_0 = current_data[221];
      const auto axyyy_0 = current_data[222];
      const auto ayyyy_0 = current_data[223];
      const auto axxxz_0 = current_data[230];
      const auto axxyz_0 = current_data[231];
      const auto axyyz_0 = current_data[232];
      const auto ayyyz_0 = current_data[233];
      const auto axxzz_0 = current_data[240];
      const auto axyzz_0 = current_data[241];
      const auto ayyzz_0 = current_data[242];
      const auto axzzz_0 = current_data[249];
      const auto ayzzz_0 = current_data[250];
      const auto azzzz_0 = current_data[257];
      const auto axxxxx_0 = current_data[298];
      const auto axxxxy_0 = current_data[299];
      const auto axxxyy_0 = current_data[300];
      const auto axxyyy_0 = current_data[301];
      const auto axyyyy_0 = current_data[302];
      const auto ayyyyy_0 = current_data[303];
      const auto axxxxz_0 = current_data[310];
      const auto axxxyz_0 = current_data[311];
      const auto axxyyz_0 = current_data[312];
      const auto axyyyz_0 = current_data[313];
      const auto ayyyyz_0 = current_data[314];
      const auto axxxzz_0 = current_data[321];
      const auto axxyzz_0 = current_data[322];
      const auto axyyzz_0 = current_data[323];
      const auto ayyyzz_0 = current_data[324];
      const auto axxzzz_0 = current_data[331];
      const auto axyzzz_0 = current_data[332];
      const auto ayyzzz_0 = current_data[333];
      const auto axzzzz_0 = current_data[340];
      const auto ayzzzz_0 = current_data[341];
      const auto azzzzz_0 = current_data[348];
      const auto axxxxxx_0 = current_data[390];
      const auto axxxxxy_0 = current_data[391];
      const auto axxxxyy_0 = current_data[392];
      const auto axxxyyy_0 = current_data[393];
      const auto axxyyyy_0 = current_data[394];
      const auto axyyyyy_0 = current_data[395];
      const auto ayyyyyy_0 = current_data[396];
      const auto axxxxxz_0 = current_data[403];
      const auto axxxxyz_0 = current_data[404];
      const auto axxxyyz_0 = current_data[405];
      const auto axxyyyz_0 = current_data[406];
      const auto axyyyyz_0 = current_data[407];
      const auto ayyyyyz_0 = current_data[408];
      const auto axxxxzz_0 = current_data[415];
      const auto axxxyzz_0 = current_data[416];
      const auto axxyyzz_0 = current_data[417];
      const auto axyyyzz_0 = current_data[418];
      const auto ayyyyzz_0 = current_data[419];
      const auto axxxzzz_0 = current_data[426];
      const auto axxyzzz_0 = current_data[427];
      const auto axyyzzz_0 = current_data[428];
      const auto ayyyzzz_0 = current_data[429];
      const auto axxzzzz_0 = current_data[436];
      const auto axyzzzz_0 = current_data[437];
      const auto ayyzzzz_0 = current_data[438];
      const auto axzzzzz_0 = current_data[445];
      const auto ayzzzzz_0 = current_data[446];
      const auto azzzzzz_0 = current_data[453];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[364] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[365] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[366] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[367] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[368] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[369] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[370] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[371] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[372] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[373] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[374] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[375] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[376] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[377] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[378] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[379] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[380] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[381] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[382] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[383] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[384] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[385] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[386] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[387] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[388] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[389] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[390] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[391] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyyz
      const auto a0_0 = current_data[14];
      const auto ax_0 = current_data[51];
      const auto ay_0 = current_data[52];
      const auto az_0 = current_data[59];
      const auto axx_0 = current_data[97];
      const auto axy_0 = current_data[98];
      const auto ayy_0 = current_data[99];
      const auto axz_0 = current_data[106];
      const auto ayz_0 = current_data[107];
      const auto azz_0 = current_data[114];
      const auto axxx_0 = current_data[153];
      const auto axxy_0 = current_data[154];
      const auto axyy_0 = current_data[155];
      const auto ayyy_0 = current_data[156];
      const auto axxz_0 = current_data[163];
      const auto axyz_0 = current_data[164];
      const auto ayyz_0 = current_data[165];
      const auto axzz_0 = current_data[172];
      const auto ayzz_0 = current_data[173];
      const auto azzz_0 = current_data[180];
      const auto axxxx_0 = current_data[220];
      const auto axxxy_0 = current_data[221];
      const auto axxyy_0 = current_data[222];
      const auto axyyy_0 = current_data[223];
      const auto ayyyy_0 = current_data[224];
      const auto axxxz_0 = current_data[231];
      const auto axxyz_0 = current_data[232];
      const auto axyyz_0 = current_data[233];
      const auto ayyyz_0 = current_data[234];
      const auto axxzz_0 = current_data[241];
      const auto axyzz_0 = current_data[242];
      const auto ayyzz_0 = current_data[243];
      const auto axzzz_0 = current_data[250];
      const auto ayzzz_0 = current_data[251];
      const auto azzzz_0 = current_data[258];
      const auto axxxxx_0 = current_data[299];
      const auto axxxxy_0 = current_data[300];
      const auto axxxyy_0 = current_data[301];
      const auto axxyyy_0 = current_data[302];
      const auto axyyyy_0 = current_data[303];
      const auto ayyyyy_0 = current_data[304];
      const auto axxxxz_0 = current_data[311];
      const auto axxxyz_0 = current_data[312];
      const auto axxyyz_0 = current_data[313];
      const auto axyyyz_0 = current_data[314];
      const auto ayyyyz_0 = current_data[315];
      const auto axxxzz_0 = current_data[322];
      const auto axxyzz_0 = current_data[323];
      const auto axyyzz_0 = current_data[324];
      const auto ayyyzz_0 = current_data[325];
      const auto axxzzz_0 = current_data[332];
      const auto axyzzz_0 = current_data[333];
      const auto ayyzzz_0 = current_data[334];
      const auto axzzzz_0 = current_data[341];
      const auto ayzzzz_0 = current_data[342];
      const auto azzzzz_0 = current_data[349];
      const auto axxxxxx_0 = current_data[391];
      const auto axxxxxy_0 = current_data[392];
      const auto axxxxyy_0 = current_data[393];
      const auto axxxyyy_0 = current_data[394];
      const auto axxyyyy_0 = current_data[395];
      const auto axyyyyy_0 = current_data[396];
      const auto ayyyyyy_0 = current_data[397];
      const auto axxxxxz_0 = current_data[404];
      const auto axxxxyz_0 = current_data[405];
      const auto axxxyyz_0 = current_data[406];
      const auto axxyyyz_0 = current_data[407];
      const auto axyyyyz_0 = current_data[408];
      const auto ayyyyyz_0 = current_data[409];
      const auto axxxxzz_0 = current_data[416];
      const auto axxxyzz_0 = current_data[417];
      const auto axxyyzz_0 = current_data[418];
      const auto axyyyzz_0 = current_data[419];
      const auto ayyyyzz_0 = current_data[420];
      const auto axxxzzz_0 = current_data[427];
      const auto axxyzzz_0 = current_data[428];
      const auto axyyzzz_0 = current_data[429];
      const auto ayyyzzz_0 = current_data[430];
      const auto axxzzzz_0 = current_data[437];
      const auto axyzzzz_0 = current_data[438];
      const auto ayyzzzz_0 = current_data[439];
      const auto axzzzzz_0 = current_data[446];
      const auto ayzzzzz_0 = current_data[447];
      const auto azzzzzz_0 = current_data[454];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[392] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[393] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[394] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[395] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[396] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[397] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[398] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[399] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[400] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[401] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[402] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[403] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[404] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[405] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[406] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[407] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[408] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[409] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[410] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[411] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[412] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[413] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[414] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[415] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[416] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[417] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[418] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[419] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxzz
      const auto a0_0 = current_data[15];
      const auto ax_0 = current_data[53];
      const auto ay_0 = current_data[54];
      const auto az_0 = current_data[60];
      const auto axx_0 = current_data[100];
      const auto axy_0 = current_data[101];
      const auto ayy_0 = current_data[102];
      const auto axz_0 = current_data[108];
      const auto ayz_0 = current_data[109];
      const auto azz_0 = current_data[115];
      const auto axxx_0 = current_data[157];
      const auto axxy_0 = current_data[158];
      const auto axyy_0 = current_data[159];
      const auto ayyy_0 = current_data[160];
      const auto axxz_0 = current_data[166];
      const auto axyz_0 = current_data[167];
      const auto ayyz_0 = current_data[168];
      const auto axzz_0 = current_data[174];
      const auto ayzz_0 = current_data[175];
      const auto azzz_0 = current_data[181];
      const auto axxxx_0 = current_data[225];
      const auto axxxy_0 = current_data[226];
      const auto axxyy_0 = current_data[227];
      const auto axyyy_0 = current_data[228];
      const auto ayyyy_0 = current_data[229];
      const auto axxxz_0 = current_data[235];
      const auto axxyz_0 = current_data[236];
      const auto axyyz_0 = current_data[237];
      const auto ayyyz_0 = current_data[238];
      const auto axxzz_0 = current_data[244];
      const auto axyzz_0 = current_data[245];
      const auto ayyzz_0 = current_data[246];
      const auto axzzz_0 = current_data[252];
      const auto ayzzz_0 = current_data[253];
      const auto azzzz_0 = current_data[259];
      const auto axxxxx_0 = current_data[305];
      const auto axxxxy_0 = current_data[306];
      const auto axxxyy_0 = current_data[307];
      const auto axxyyy_0 = current_data[308];
      const auto axyyyy_0 = current_data[309];
      const auto ayyyyy_0 = current_data[310];
      const auto axxxxz_0 = current_data[316];
      const auto axxxyz_0 = current_data[317];
      const auto axxyyz_0 = current_data[318];
      const auto axyyyz_0 = current_data[319];
      const auto ayyyyz_0 = current_data[320];
      const auto axxxzz_0 = current_data[326];
      const auto axxyzz_0 = current_data[327];
      const auto axyyzz_0 = current_data[328];
      const auto ayyyzz_0 = current_data[329];
      const auto axxzzz_0 = current_data[335];
      const auto axyzzz_0 = current_data[336];
      const auto ayyzzz_0 = current_data[337];
      const auto axzzzz_0 = current_data[343];
      const auto ayzzzz_0 = current_data[344];
      const auto azzzzz_0 = current_data[350];
      const auto axxxxxx_0 = current_data[398];
      const auto axxxxxy_0 = current_data[399];
      const auto axxxxyy_0 = current_data[400];
      const auto axxxyyy_0 = current_data[401];
      const auto axxyyyy_0 = current_data[402];
      const auto axyyyyy_0 = current_data[403];
      const auto ayyyyyy_0 = current_data[404];
      const auto axxxxxz_0 = current_data[410];
      const auto axxxxyz_0 = current_data[411];
      const auto axxxyyz_0 = current_data[412];
      const auto axxyyyz_0 = current_data[413];
      const auto axyyyyz_0 = current_data[414];
      const auto ayyyyyz_0 = current_data[415];
      const auto axxxxzz_0 = current_data[421];
      const auto axxxyzz_0 = current_data[422];
      const auto axxyyzz_0 = current_data[423];
      const auto axyyyzz_0 = current_data[424];
      const auto ayyyyzz_0 = current_data[425];
      const auto axxxzzz_0 = current_data[431];
      const auto axxyzzz_0 = current_data[432];
      const auto axyyzzz_0 = current_data[433];
      const auto ayyyzzz_0 = current_data[434];
      const auto axxzzzz_0 = current_data[440];
      const auto axyzzzz_0 = current_data[441];
      const auto ayyzzzz_0 = current_data[442];
      const auto axzzzzz_0 = current_data[448];
      const auto ayzzzzz_0 = current_data[449];
      const auto azzzzzz_0 = current_data[455];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[420] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[421] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[422] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[423] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[424] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[425] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[426] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[427] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[428] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[429] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[430] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[431] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[432] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[433] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[434] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[435] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[436] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[437] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[438] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[439] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[440] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[441] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[442] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[443] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[444] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[445] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[446] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[447] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyzz
      const auto a0_0 = current_data[16];
      const auto ax_0 = current_data[54];
      const auto ay_0 = current_data[55];
      const auto az_0 = current_data[61];
      const auto axx_0 = current_data[101];
      const auto axy_0 = current_data[102];
      const auto ayy_0 = current_data[103];
      const auto axz_0 = current_data[109];
      const auto ayz_0 = current_data[110];
      const auto azz_0 = current_data[116];
      const auto axxx_0 = current_data[158];
      const auto axxy_0 = current_data[159];
      const auto axyy_0 = current_data[160];
      const auto ayyy_0 = current_data[161];
      const auto axxz_0 = current_data[167];
      const auto axyz_0 = current_data[168];
      const auto ayyz_0 = current_data[169];
      const auto axzz_0 = current_data[175];
      const auto ayzz_0 = current_data[176];
      const auto azzz_0 = current_data[182];
      const auto axxxx_0 = current_data[226];
      const auto axxxy_0 = current_data[227];
      const auto axxyy_0 = current_data[228];
      const auto axyyy_0 = current_data[229];
      const auto ayyyy_0 = current_data[230];
      const auto axxxz_0 = current_data[236];
      const auto axxyz_0 = current_data[237];
      const auto axyyz_0 = current_data[238];
      const auto ayyyz_0 = current_data[239];
      const auto axxzz_0 = current_data[245];
      const auto axyzz_0 = current_data[246];
      const auto ayyzz_0 = current_data[247];
      const auto axzzz_0 = current_data[253];
      const auto ayzzz_0 = current_data[254];
      const auto azzzz_0 = current_data[260];
      const auto axxxxx_0 = current_data[306];
      const auto axxxxy_0 = current_data[307];
      const auto axxxyy_0 = current_data[308];
      const auto axxyyy_0 = current_data[309];
      const auto axyyyy_0 = current_data[310];
      const auto ayyyyy_0 = current_data[311];
      const auto axxxxz_0 = current_data[317];
      const auto axxxyz_0 = current_data[318];
      const auto axxyyz_0 = current_data[319];
      const auto axyyyz_0 = current_data[320];
      const auto ayyyyz_0 = current_data[321];
      const auto axxxzz_0 = current_data[327];
      const auto axxyzz_0 = current_data[328];
      const auto axyyzz_0 = current_data[329];
      const auto ayyyzz_0 = current_data[330];
      const auto axxzzz_0 = current_data[336];
      const auto axyzzz_0 = current_data[337];
      const auto ayyzzz_0 = current_data[338];
      const auto axzzzz_0 = current_data[344];
      const auto ayzzzz_0 = current_data[345];
      const auto azzzzz_0 = current_data[351];
      const auto axxxxxx_0 = current_data[399];
      const auto axxxxxy_0 = current_data[400];
      const auto axxxxyy_0 = current_data[401];
      const auto axxxyyy_0 = current_data[402];
      const auto axxyyyy_0 = current_data[403];
      const auto axyyyyy_0 = current_data[404];
      const auto ayyyyyy_0 = current_data[405];
      const auto axxxxxz_0 = current_data[411];
      const auto axxxxyz_0 = current_data[412];
      const auto axxxyyz_0 = current_data[413];
      const auto axxyyyz_0 = current_data[414];
      const auto axyyyyz_0 = current_data[415];
      const auto ayyyyyz_0 = current_data[416];
      const auto axxxxzz_0 = current_data[422];
      const auto axxxyzz_0 = current_data[423];
      const auto axxyyzz_0 = current_data[424];
      const auto axyyyzz_0 = current_data[425];
      const auto ayyyyzz_0 = current_data[426];
      const auto axxxzzz_0 = current_data[432];
      const auto axxyzzz_0 = current_data[433];
      const auto axyyzzz_0 = current_data[434];
      const auto ayyyzzz_0 = current_data[435];
      const auto axxzzzz_0 = current_data[441];
      const auto axyzzzz_0 = current_data[442];
      const auto ayyzzzz_0 = current_data[443];
      const auto axzzzzz_0 = current_data[449];
      const auto ayzzzzz_0 = current_data[450];
      const auto azzzzzz_0 = current_data[456];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[448] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[449] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[450] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[451] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[452] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[453] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[454] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[455] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[456] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[457] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[458] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[459] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[460] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[461] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[462] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[463] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[464] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[465] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[466] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[467] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[468] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[469] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[470] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[471] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[472] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[473] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[474] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[475] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyzz
      const auto a0_0 = current_data[17];
      const auto ax_0 = current_data[55];
      const auto ay_0 = current_data[56];
      const auto az_0 = current_data[62];
      const auto axx_0 = current_data[102];
      const auto axy_0 = current_data[103];
      const auto ayy_0 = current_data[104];
      const auto axz_0 = current_data[110];
      const auto ayz_0 = current_data[111];
      const auto azz_0 = current_data[117];
      const auto axxx_0 = current_data[159];
      const auto axxy_0 = current_data[160];
      const auto axyy_0 = current_data[161];
      const auto ayyy_0 = current_data[162];
      const auto axxz_0 = current_data[168];
      const auto axyz_0 = current_data[169];
      const auto ayyz_0 = current_data[170];
      const auto axzz_0 = current_data[176];
      const auto ayzz_0 = current_data[177];
      const auto azzz_0 = current_data[183];
      const auto axxxx_0 = current_data[227];
      const auto axxxy_0 = current_data[228];
      const auto axxyy_0 = current_data[229];
      const auto axyyy_0 = current_data[230];
      const auto ayyyy_0 = current_data[231];
      const auto axxxz_0 = current_data[237];
      const auto axxyz_0 = current_data[238];
      const auto axyyz_0 = current_data[239];
      const auto ayyyz_0 = current_data[240];
      const auto axxzz_0 = current_data[246];
      const auto axyzz_0 = current_data[247];
      const auto ayyzz_0 = current_data[248];
      const auto axzzz_0 = current_data[254];
      const auto ayzzz_0 = current_data[255];
      const auto azzzz_0 = current_data[261];
      const auto axxxxx_0 = current_data[307];
      const auto axxxxy_0 = current_data[308];
      const auto axxxyy_0 = current_data[309];
      const auto axxyyy_0 = current_data[310];
      const auto axyyyy_0 = current_data[311];
      const auto ayyyyy_0 = current_data[312];
      const auto axxxxz_0 = current_data[318];
      const auto axxxyz_0 = current_data[319];
      const auto axxyyz_0 = current_data[320];
      const auto axyyyz_0 = current_data[321];
      const auto ayyyyz_0 = current_data[322];
      const auto axxxzz_0 = current_data[328];
      const auto axxyzz_0 = current_data[329];
      const auto axyyzz_0 = current_data[330];
      const auto ayyyzz_0 = current_data[331];
      const auto axxzzz_0 = current_data[337];
      const auto axyzzz_0 = current_data[338];
      const auto ayyzzz_0 = current_data[339];
      const auto axzzzz_0 = current_data[345];
      const auto ayzzzz_0 = current_data[346];
      const auto azzzzz_0 = current_data[352];
      const auto axxxxxx_0 = current_data[400];
      const auto axxxxxy_0 = current_data[401];
      const auto axxxxyy_0 = current_data[402];
      const auto axxxyyy_0 = current_data[403];
      const auto axxyyyy_0 = current_data[404];
      const auto axyyyyy_0 = current_data[405];
      const auto ayyyyyy_0 = current_data[406];
      const auto axxxxxz_0 = current_data[412];
      const auto axxxxyz_0 = current_data[413];
      const auto axxxyyz_0 = current_data[414];
      const auto axxyyyz_0 = current_data[415];
      const auto axyyyyz_0 = current_data[416];
      const auto ayyyyyz_0 = current_data[417];
      const auto axxxxzz_0 = current_data[423];
      const auto axxxyzz_0 = current_data[424];
      const auto axxyyzz_0 = current_data[425];
      const auto axyyyzz_0 = current_data[426];
      const auto ayyyyzz_0 = current_data[427];
      const auto axxxzzz_0 = current_data[433];
      const auto axxyzzz_0 = current_data[434];
      const auto axyyzzz_0 = current_data[435];
      const auto ayyyzzz_0 = current_data[436];
      const auto axxzzzz_0 = current_data[442];
      const auto axyzzzz_0 = current_data[443];
      const auto ayyzzzz_0 = current_data[444];
      const auto axzzzzz_0 = current_data[450];
      const auto ayzzzzz_0 = current_data[451];
      const auto azzzzzz_0 = current_data[457];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[476] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[477] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[478] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[479] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[480] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[481] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[482] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[483] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[484] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[485] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[486] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[487] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[488] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[489] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[490] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[491] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[492] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[493] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[494] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[495] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[496] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[497] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[498] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[499] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[500] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[501] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[502] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[503] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyyzz
      const auto a0_0 = current_data[18];
      const auto ax_0 = current_data[56];
      const auto ay_0 = current_data[57];
      const auto az_0 = current_data[63];
      const auto axx_0 = current_data[103];
      const auto axy_0 = current_data[104];
      const auto ayy_0 = current_data[105];
      const auto axz_0 = current_data[111];
      const auto ayz_0 = current_data[112];
      const auto azz_0 = current_data[118];
      const auto axxx_0 = current_data[160];
      const auto axxy_0 = current_data[161];
      const auto axyy_0 = current_data[162];
      const auto ayyy_0 = current_data[163];
      const auto axxz_0 = current_data[169];
      const auto axyz_0 = current_data[170];
      const auto ayyz_0 = current_data[171];
      const auto axzz_0 = current_data[177];
      const auto ayzz_0 = current_data[178];
      const auto azzz_0 = current_data[184];
      const auto axxxx_0 = current_data[228];
      const auto axxxy_0 = current_data[229];
      const auto axxyy_0 = current_data[230];
      const auto axyyy_0 = current_data[231];
      const auto ayyyy_0 = current_data[232];
      const auto axxxz_0 = current_data[238];
      const auto axxyz_0 = current_data[239];
      const auto axyyz_0 = current_data[240];
      const auto ayyyz_0 = current_data[241];
      const auto axxzz_0 = current_data[247];
      const auto axyzz_0 = current_data[248];
      const auto ayyzz_0 = current_data[249];
      const auto axzzz_0 = current_data[255];
      const auto ayzzz_0 = current_data[256];
      const auto azzzz_0 = current_data[262];
      const auto axxxxx_0 = current_data[308];
      const auto axxxxy_0 = current_data[309];
      const auto axxxyy_0 = current_data[310];
      const auto axxyyy_0 = current_data[311];
      const auto axyyyy_0 = current_data[312];
      const auto ayyyyy_0 = current_data[313];
      const auto axxxxz_0 = current_data[319];
      const auto axxxyz_0 = current_data[320];
      const auto axxyyz_0 = current_data[321];
      const auto axyyyz_0 = current_data[322];
      const auto ayyyyz_0 = current_data[323];
      const auto axxxzz_0 = current_data[329];
      const auto axxyzz_0 = current_data[330];
      const auto axyyzz_0 = current_data[331];
      const auto ayyyzz_0 = current_data[332];
      const auto axxzzz_0 = current_data[338];
      const auto axyzzz_0 = current_data[339];
      const auto ayyzzz_0 = current_data[340];
      const auto axzzzz_0 = current_data[346];
      const auto ayzzzz_0 = current_data[347];
      const auto azzzzz_0 = current_data[353];
      const auto axxxxxx_0 = current_data[401];
      const auto axxxxxy_0 = current_data[402];
      const auto axxxxyy_0 = current_data[403];
      const auto axxxyyy_0 = current_data[404];
      const auto axxyyyy_0 = current_data[405];
      const auto axyyyyy_0 = current_data[406];
      const auto ayyyyyy_0 = current_data[407];
      const auto axxxxxz_0 = current_data[413];
      const auto axxxxyz_0 = current_data[414];
      const auto axxxyyz_0 = current_data[415];
      const auto axxyyyz_0 = current_data[416];
      const auto axyyyyz_0 = current_data[417];
      const auto ayyyyyz_0 = current_data[418];
      const auto axxxxzz_0 = current_data[424];
      const auto axxxyzz_0 = current_data[425];
      const auto axxyyzz_0 = current_data[426];
      const auto axyyyzz_0 = current_data[427];
      const auto ayyyyzz_0 = current_data[428];
      const auto axxxzzz_0 = current_data[434];
      const auto axxyzzz_0 = current_data[435];
      const auto axyyzzz_0 = current_data[436];
      const auto ayyyzzz_0 = current_data[437];
      const auto axxzzzz_0 = current_data[443];
      const auto axyzzzz_0 = current_data[444];
      const auto ayyzzzz_0 = current_data[445];
      const auto axzzzzz_0 = current_data[451];
      const auto ayzzzzz_0 = current_data[452];
      const auto azzzzzz_0 = current_data[458];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[504] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[505] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[506] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[507] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[508] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[509] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[510] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[511] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[512] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[513] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[514] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[515] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[516] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[517] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[518] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[519] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[520] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[521] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[522] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[523] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[524] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[525] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[526] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[527] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[528] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[529] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[530] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[531] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyyzz
      const auto a0_0 = current_data[19];
      const auto ax_0 = current_data[57];
      const auto ay_0 = current_data[58];
      const auto az_0 = current_data[64];
      const auto axx_0 = current_data[104];
      const auto axy_0 = current_data[105];
      const auto ayy_0 = current_data[106];
      const auto axz_0 = current_data[112];
      const auto ayz_0 = current_data[113];
      const auto azz_0 = current_data[119];
      const auto axxx_0 = current_data[161];
      const auto axxy_0 = current_data[162];
      const auto axyy_0 = current_data[163];
      const auto ayyy_0 = current_data[164];
      const auto axxz_0 = current_data[170];
      const auto axyz_0 = current_data[171];
      const auto ayyz_0 = current_data[172];
      const auto axzz_0 = current_data[178];
      const auto ayzz_0 = current_data[179];
      const auto azzz_0 = current_data[185];
      const auto axxxx_0 = current_data[229];
      const auto axxxy_0 = current_data[230];
      const auto axxyy_0 = current_data[231];
      const auto axyyy_0 = current_data[232];
      const auto ayyyy_0 = current_data[233];
      const auto axxxz_0 = current_data[239];
      const auto axxyz_0 = current_data[240];
      const auto axyyz_0 = current_data[241];
      const auto ayyyz_0 = current_data[242];
      const auto axxzz_0 = current_data[248];
      const auto axyzz_0 = current_data[249];
      const auto ayyzz_0 = current_data[250];
      const auto axzzz_0 = current_data[256];
      const auto ayzzz_0 = current_data[257];
      const auto azzzz_0 = current_data[263];
      const auto axxxxx_0 = current_data[309];
      const auto axxxxy_0 = current_data[310];
      const auto axxxyy_0 = current_data[311];
      const auto axxyyy_0 = current_data[312];
      const auto axyyyy_0 = current_data[313];
      const auto ayyyyy_0 = current_data[314];
      const auto axxxxz_0 = current_data[320];
      const auto axxxyz_0 = current_data[321];
      const auto axxyyz_0 = current_data[322];
      const auto axyyyz_0 = current_data[323];
      const auto ayyyyz_0 = current_data[324];
      const auto axxxzz_0 = current_data[330];
      const auto axxyzz_0 = current_data[331];
      const auto axyyzz_0 = current_data[332];
      const auto ayyyzz_0 = current_data[333];
      const auto axxzzz_0 = current_data[339];
      const auto axyzzz_0 = current_data[340];
      const auto ayyzzz_0 = current_data[341];
      const auto axzzzz_0 = current_data[347];
      const auto ayzzzz_0 = current_data[348];
      const auto azzzzz_0 = current_data[354];
      const auto axxxxxx_0 = current_data[402];
      const auto axxxxxy_0 = current_data[403];
      const auto axxxxyy_0 = current_data[404];
      const auto axxxyyy_0 = current_data[405];
      const auto axxyyyy_0 = current_data[406];
      const auto axyyyyy_0 = current_data[407];
      const auto ayyyyyy_0 = current_data[408];
      const auto axxxxxz_0 = current_data[414];
      const auto axxxxyz_0 = current_data[415];
      const auto axxxyyz_0 = current_data[416];
      const auto axxyyyz_0 = current_data[417];
      const auto axyyyyz_0 = current_data[418];
      const auto ayyyyyz_0 = current_data[419];
      const auto axxxxzz_0 = current_data[425];
      const auto axxxyzz_0 = current_data[426];
      const auto axxyyzz_0 = current_data[427];
      const auto axyyyzz_0 = current_data[428];
      const auto ayyyyzz_0 = current_data[429];
      const auto axxxzzz_0 = current_data[435];
      const auto axxyzzz_0 = current_data[436];
      const auto axyyzzz_0 = current_data[437];
      const auto ayyyzzz_0 = current_data[438];
      const auto axxzzzz_0 = current_data[444];
      const auto axyzzzz_0 = current_data[445];
      const auto ayyzzzz_0 = current_data[446];
      const auto axzzzzz_0 = current_data[452];
      const auto ayzzzzz_0 = current_data[453];
      const auto azzzzzz_0 = current_data[459];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[532] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[533] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[534] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[535] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[536] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[537] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[538] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[539] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[540] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[541] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[542] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[543] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[544] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[545] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[546] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[547] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[548] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[549] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[550] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[551] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[552] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[553] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[554] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[555] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[556] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[557] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[558] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[559] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyyzz
      const auto a0_0 = current_data[20];
      const auto ax_0 = current_data[58];
      const auto ay_0 = current_data[59];
      const auto az_0 = current_data[65];
      const auto axx_0 = current_data[105];
      const auto axy_0 = current_data[106];
      const auto ayy_0 = current_data[107];
      const auto axz_0 = current_data[113];
      const auto ayz_0 = current_data[114];
      const auto azz_0 = current_data[120];
      const auto axxx_0 = current_data[162];
      const auto axxy_0 = current_data[163];
      const auto axyy_0 = current_data[164];
      const auto ayyy_0 = current_data[165];
      const auto axxz_0 = current_data[171];
      const auto axyz_0 = current_data[172];
      const auto ayyz_0 = current_data[173];
      const auto axzz_0 = current_data[179];
      const auto ayzz_0 = current_data[180];
      const auto azzz_0 = current_data[186];
      const auto axxxx_0 = current_data[230];
      const auto axxxy_0 = current_data[231];
      const auto axxyy_0 = current_data[232];
      const auto axyyy_0 = current_data[233];
      const auto ayyyy_0 = current_data[234];
      const auto axxxz_0 = current_data[240];
      const auto axxyz_0 = current_data[241];
      const auto axyyz_0 = current_data[242];
      const auto ayyyz_0 = current_data[243];
      const auto axxzz_0 = current_data[249];
      const auto axyzz_0 = current_data[250];
      const auto ayyzz_0 = current_data[251];
      const auto axzzz_0 = current_data[257];
      const auto ayzzz_0 = current_data[258];
      const auto azzzz_0 = current_data[264];
      const auto axxxxx_0 = current_data[310];
      const auto axxxxy_0 = current_data[311];
      const auto axxxyy_0 = current_data[312];
      const auto axxyyy_0 = current_data[313];
      const auto axyyyy_0 = current_data[314];
      const auto ayyyyy_0 = current_data[315];
      const auto axxxxz_0 = current_data[321];
      const auto axxxyz_0 = current_data[322];
      const auto axxyyz_0 = current_data[323];
      const auto axyyyz_0 = current_data[324];
      const auto ayyyyz_0 = current_data[325];
      const auto axxxzz_0 = current_data[331];
      const auto axxyzz_0 = current_data[332];
      const auto axyyzz_0 = current_data[333];
      const auto ayyyzz_0 = current_data[334];
      const auto axxzzz_0 = current_data[340];
      const auto axyzzz_0 = current_data[341];
      const auto ayyzzz_0 = current_data[342];
      const auto axzzzz_0 = current_data[348];
      const auto ayzzzz_0 = current_data[349];
      const auto azzzzz_0 = current_data[355];
      const auto axxxxxx_0 = current_data[403];
      const auto axxxxxy_0 = current_data[404];
      const auto axxxxyy_0 = current_data[405];
      const auto axxxyyy_0 = current_data[406];
      const auto axxyyyy_0 = current_data[407];
      const auto axyyyyy_0 = current_data[408];
      const auto ayyyyyy_0 = current_data[409];
      const auto axxxxxz_0 = current_data[415];
      const auto axxxxyz_0 = current_data[416];
      const auto axxxyyz_0 = current_data[417];
      const auto axxyyyz_0 = current_data[418];
      const auto axyyyyz_0 = current_data[419];
      const auto ayyyyyz_0 = current_data[420];
      const auto axxxxzz_0 = current_data[426];
      const auto axxxyzz_0 = current_data[427];
      const auto axxyyzz_0 = current_data[428];
      const auto axyyyzz_0 = current_data[429];
      const auto ayyyyzz_0 = current_data[430];
      const auto axxxzzz_0 = current_data[436];
      const auto axxyzzz_0 = current_data[437];
      const auto axyyzzz_0 = current_data[438];
      const auto ayyyzzz_0 = current_data[439];
      const auto axxzzzz_0 = current_data[445];
      const auto axyzzzz_0 = current_data[446];
      const auto ayyzzzz_0 = current_data[447];
      const auto axzzzzz_0 = current_data[453];
      const auto ayzzzzz_0 = current_data[454];
      const auto azzzzzz_0 = current_data[460];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[560] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[561] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[562] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[563] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[564] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[565] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[566] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[567] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[568] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[569] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[570] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[571] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[572] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[573] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[574] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[575] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[576] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[577] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[578] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[579] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[580] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[581] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[582] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[583] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[584] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[585] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[586] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[587] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxzzz
      const auto a0_0 = current_data[21];
      const auto ax_0 = current_data[60];
      const auto ay_0 = current_data[61];
      const auto az_0 = current_data[66];
      const auto axx_0 = current_data[108];
      const auto axy_0 = current_data[109];
      const auto ayy_0 = current_data[110];
      const auto axz_0 = current_data[115];
      const auto ayz_0 = current_data[116];
      const auto azz_0 = current_data[121];
      const auto axxx_0 = current_data[166];
      const auto axxy_0 = current_data[167];
      const auto axyy_0 = current_data[168];
      const auto ayyy_0 = current_data[169];
      const auto axxz_0 = current_data[174];
      const auto axyz_0 = current_data[175];
      const auto ayyz_0 = current_data[176];
      const auto axzz_0 = current_data[181];
      const auto ayzz_0 = current_data[182];
      const auto azzz_0 = current_data[187];
      const auto axxxx_0 = current_data[235];
      const auto axxxy_0 = current_data[236];
      const auto axxyy_0 = current_data[237];
      const auto axyyy_0 = current_data[238];
      const auto ayyyy_0 = current_data[239];
      const auto axxxz_0 = current_data[244];
      const auto axxyz_0 = current_data[245];
      const auto axyyz_0 = current_data[246];
      const auto ayyyz_0 = current_data[247];
      const auto axxzz_0 = current_data[252];
      const auto axyzz_0 = current_data[253];
      const auto ayyzz_0 = current_data[254];
      const auto axzzz_0 = current_data[259];
      const auto ayzzz_0 = current_data[260];
      const auto azzzz_0 = current_data[265];
      const auto axxxxx_0 = current_data[316];
      const auto axxxxy_0 = current_data[317];
      const auto axxxyy_0 = current_data[318];
      const auto axxyyy_0 = current_data[319];
      const auto axyyyy_0 = current_data[320];
      const auto ayyyyy_0 = current_data[321];
      const auto axxxxz_0 = current_data[326];
      const auto axxxyz_0 = current_data[327];
      const auto axxyyz_0 = current_data[328];
      const auto axyyyz_0 = current_data[329];
      const auto ayyyyz_0 = current_data[330];
      const auto axxxzz_0 = current_data[335];
      const auto axxyzz_0 = current_data[336];
      const auto axyyzz_0 = current_data[337];
      const auto ayyyzz_0 = current_data[338];
      const auto axxzzz_0 = current_data[343];
      const auto axyzzz_0 = current_data[344];
      const auto ayyzzz_0 = current_data[345];
      const auto axzzzz_0 = current_data[350];
      const auto ayzzzz_0 = current_data[351];
      const auto azzzzz_0 = current_data[356];
      const auto axxxxxx_0 = current_data[410];
      const auto axxxxxy_0 = current_data[411];
      const auto axxxxyy_0 = current_data[412];
      const auto axxxyyy_0 = current_data[413];
      const auto axxyyyy_0 = current_data[414];
      const auto axyyyyy_0 = current_data[415];
      const auto ayyyyyy_0 = current_data[416];
      const auto axxxxxz_0 = current_data[421];
      const auto axxxxyz_0 = current_data[422];
      const auto axxxyyz_0 = current_data[423];
      const auto axxyyyz_0 = current_data[424];
      const auto axyyyyz_0 = current_data[425];
      const auto ayyyyyz_0 = current_data[426];
      const auto axxxxzz_0 = current_data[431];
      const auto axxxyzz_0 = current_data[432];
      const auto axxyyzz_0 = current_data[433];
      const auto axyyyzz_0 = current_data[434];
      const auto ayyyyzz_0 = current_data[435];
      const auto axxxzzz_0 = current_data[440];
      const auto axxyzzz_0 = current_data[441];
      const auto axyyzzz_0 = current_data[442];
      const auto ayyyzzz_0 = current_data[443];
      const auto axxzzzz_0 = current_data[448];
      const auto axyzzzz_0 = current_data[449];
      const auto ayyzzzz_0 = current_data[450];
      const auto axzzzzz_0 = current_data[455];
      const auto ayzzzzz_0 = current_data[456];
      const auto azzzzzz_0 = current_data[461];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[588] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[589] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[590] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[591] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[592] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[593] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[594] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[595] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[596] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[597] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[598] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[599] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[600] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[601] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[602] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[603] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[604] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[605] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[606] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[607] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[608] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[609] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[610] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[611] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[612] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[613] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[614] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[615] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyzzz
      const auto a0_0 = current_data[22];
      const auto ax_0 = current_data[61];
      const auto ay_0 = current_data[62];
      const auto az_0 = current_data[67];
      const auto axx_0 = current_data[109];
      const auto axy_0 = current_data[110];
      const auto ayy_0 = current_data[111];
      const auto axz_0 = current_data[116];
      const auto ayz_0 = current_data[117];
      const auto azz_0 = current_data[122];
      const auto axxx_0 = current_data[167];
      const auto axxy_0 = current_data[168];
      const auto axyy_0 = current_data[169];
      const auto ayyy_0 = current_data[170];
      const auto axxz_0 = current_data[175];
      const auto axyz_0 = current_data[176];
      const auto ayyz_0 = current_data[177];
      const auto axzz_0 = current_data[182];
      const auto ayzz_0 = current_data[183];
      const auto azzz_0 = current_data[188];
      const auto axxxx_0 = current_data[236];
      const auto axxxy_0 = current_data[237];
      const auto axxyy_0 = current_data[238];
      const auto axyyy_0 = current_data[239];
      const auto ayyyy_0 = current_data[240];
      const auto axxxz_0 = current_data[245];
      const auto axxyz_0 = current_data[246];
      const auto axyyz_0 = current_data[247];
      const auto ayyyz_0 = current_data[248];
      const auto axxzz_0 = current_data[253];
      const auto axyzz_0 = current_data[254];
      const auto ayyzz_0 = current_data[255];
      const auto axzzz_0 = current_data[260];
      const auto ayzzz_0 = current_data[261];
      const auto azzzz_0 = current_data[266];
      const auto axxxxx_0 = current_data[317];
      const auto axxxxy_0 = current_data[318];
      const auto axxxyy_0 = current_data[319];
      const auto axxyyy_0 = current_data[320];
      const auto axyyyy_0 = current_data[321];
      const auto ayyyyy_0 = current_data[322];
      const auto axxxxz_0 = current_data[327];
      const auto axxxyz_0 = current_data[328];
      const auto axxyyz_0 = current_data[329];
      const auto axyyyz_0 = current_data[330];
      const auto ayyyyz_0 = current_data[331];
      const auto axxxzz_0 = current_data[336];
      const auto axxyzz_0 = current_data[337];
      const auto axyyzz_0 = current_data[338];
      const auto ayyyzz_0 = current_data[339];
      const auto axxzzz_0 = current_data[344];
      const auto axyzzz_0 = current_data[345];
      const auto ayyzzz_0 = current_data[346];
      const auto axzzzz_0 = current_data[351];
      const auto ayzzzz_0 = current_data[352];
      const auto azzzzz_0 = current_data[357];
      const auto axxxxxx_0 = current_data[411];
      const auto axxxxxy_0 = current_data[412];
      const auto axxxxyy_0 = current_data[413];
      const auto axxxyyy_0 = current_data[414];
      const auto axxyyyy_0 = current_data[415];
      const auto axyyyyy_0 = current_data[416];
      const auto ayyyyyy_0 = current_data[417];
      const auto axxxxxz_0 = current_data[422];
      const auto axxxxyz_0 = current_data[423];
      const auto axxxyyz_0 = current_data[424];
      const auto axxyyyz_0 = current_data[425];
      const auto axyyyyz_0 = current_data[426];
      const auto ayyyyyz_0 = current_data[427];
      const auto axxxxzz_0 = current_data[432];
      const auto axxxyzz_0 = current_data[433];
      const auto axxyyzz_0 = current_data[434];
      const auto axyyyzz_0 = current_data[435];
      const auto ayyyyzz_0 = current_data[436];
      const auto axxxzzz_0 = current_data[441];
      const auto axxyzzz_0 = current_data[442];
      const auto axyyzzz_0 = current_data[443];
      const auto ayyyzzz_0 = current_data[444];
      const auto axxzzzz_0 = current_data[449];
      const auto axyzzzz_0 = current_data[450];
      const auto ayyzzzz_0 = current_data[451];
      const auto axzzzzz_0 = current_data[456];
      const auto ayzzzzz_0 = current_data[457];
      const auto azzzzzz_0 = current_data[462];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[616] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[617] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[618] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[619] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[620] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[621] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[622] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[623] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[624] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[625] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[626] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[627] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[628] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[629] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[630] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[631] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[632] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[633] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[634] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[635] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[636] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[637] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[638] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[639] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[640] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[641] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[642] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[643] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyyzzz
      const auto a0_0 = current_data[23];
      const auto ax_0 = current_data[62];
      const auto ay_0 = current_data[63];
      const auto az_0 = current_data[68];
      const auto axx_0 = current_data[110];
      const auto axy_0 = current_data[111];
      const auto ayy_0 = current_data[112];
      const auto axz_0 = current_data[117];
      const auto ayz_0 = current_data[118];
      const auto azz_0 = current_data[123];
      const auto axxx_0 = current_data[168];
      const auto axxy_0 = current_data[169];
      const auto axyy_0 = current_data[170];
      const auto ayyy_0 = current_data[171];
      const auto axxz_0 = current_data[176];
      const auto axyz_0 = current_data[177];
      const auto ayyz_0 = current_data[178];
      const auto axzz_0 = current_data[183];
      const auto ayzz_0 = current_data[184];
      const auto azzz_0 = current_data[189];
      const auto axxxx_0 = current_data[237];
      const auto axxxy_0 = current_data[238];
      const auto axxyy_0 = current_data[239];
      const auto axyyy_0 = current_data[240];
      const auto ayyyy_0 = current_data[241];
      const auto axxxz_0 = current_data[246];
      const auto axxyz_0 = current_data[247];
      const auto axyyz_0 = current_data[248];
      const auto ayyyz_0 = current_data[249];
      const auto axxzz_0 = current_data[254];
      const auto axyzz_0 = current_data[255];
      const auto ayyzz_0 = current_data[256];
      const auto axzzz_0 = current_data[261];
      const auto ayzzz_0 = current_data[262];
      const auto azzzz_0 = current_data[267];
      const auto axxxxx_0 = current_data[318];
      const auto axxxxy_0 = current_data[319];
      const auto axxxyy_0 = current_data[320];
      const auto axxyyy_0 = current_data[321];
      const auto axyyyy_0 = current_data[322];
      const auto ayyyyy_0 = current_data[323];
      const auto axxxxz_0 = current_data[328];
      const auto axxxyz_0 = current_data[329];
      const auto axxyyz_0 = current_data[330];
      const auto axyyyz_0 = current_data[331];
      const auto ayyyyz_0 = current_data[332];
      const auto axxxzz_0 = current_data[337];
      const auto axxyzz_0 = current_data[338];
      const auto axyyzz_0 = current_data[339];
      const auto ayyyzz_0 = current_data[340];
      const auto axxzzz_0 = current_data[345];
      const auto axyzzz_0 = current_data[346];
      const auto ayyzzz_0 = current_data[347];
      const auto axzzzz_0 = current_data[352];
      const auto ayzzzz_0 = current_data[353];
      const auto azzzzz_0 = current_data[358];
      const auto axxxxxx_0 = current_data[412];
      const auto axxxxxy_0 = current_data[413];
      const auto axxxxyy_0 = current_data[414];
      const auto axxxyyy_0 = current_data[415];
      const auto axxyyyy_0 = current_data[416];
      const auto axyyyyy_0 = current_data[417];
      const auto ayyyyyy_0 = current_data[418];
      const auto axxxxxz_0 = current_data[423];
      const auto axxxxyz_0 = current_data[424];
      const auto axxxyyz_0 = current_data[425];
      const auto axxyyyz_0 = current_data[426];
      const auto axyyyyz_0 = current_data[427];
      const auto ayyyyyz_0 = current_data[428];
      const auto axxxxzz_0 = current_data[433];
      const auto axxxyzz_0 = current_data[434];
      const auto axxyyzz_0 = current_data[435];
      const auto axyyyzz_0 = current_data[436];
      const auto ayyyyzz_0 = current_data[437];
      const auto axxxzzz_0 = current_data[442];
      const auto axxyzzz_0 = current_data[443];
      const auto axyyzzz_0 = current_data[444];
      const auto ayyyzzz_0 = current_data[445];
      const auto axxzzzz_0 = current_data[450];
      const auto axyzzzz_0 = current_data[451];
      const auto ayyzzzz_0 = current_data[452];
      const auto axzzzzz_0 = current_data[457];
      const auto ayzzzzz_0 = current_data[458];
      const auto azzzzzz_0 = current_data[463];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[644] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[645] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[646] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[647] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[648] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[649] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[650] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[651] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[652] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[653] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[654] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[655] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[656] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[657] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[658] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[659] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[660] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[661] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[662] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[663] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[664] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[665] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[666] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[667] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[668] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[669] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[670] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[671] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyyzzz
      const auto a0_0 = current_data[24];
      const auto ax_0 = current_data[63];
      const auto ay_0 = current_data[64];
      const auto az_0 = current_data[69];
      const auto axx_0 = current_data[111];
      const auto axy_0 = current_data[112];
      const auto ayy_0 = current_data[113];
      const auto axz_0 = current_data[118];
      const auto ayz_0 = current_data[119];
      const auto azz_0 = current_data[124];
      const auto axxx_0 = current_data[169];
      const auto axxy_0 = current_data[170];
      const auto axyy_0 = current_data[171];
      const auto ayyy_0 = current_data[172];
      const auto axxz_0 = current_data[177];
      const auto axyz_0 = current_data[178];
      const auto ayyz_0 = current_data[179];
      const auto axzz_0 = current_data[184];
      const auto ayzz_0 = current_data[185];
      const auto azzz_0 = current_data[190];
      const auto axxxx_0 = current_data[238];
      const auto axxxy_0 = current_data[239];
      const auto axxyy_0 = current_data[240];
      const auto axyyy_0 = current_data[241];
      const auto ayyyy_0 = current_data[242];
      const auto axxxz_0 = current_data[247];
      const auto axxyz_0 = current_data[248];
      const auto axyyz_0 = current_data[249];
      const auto ayyyz_0 = current_data[250];
      const auto axxzz_0 = current_data[255];
      const auto axyzz_0 = current_data[256];
      const auto ayyzz_0 = current_data[257];
      const auto axzzz_0 = current_data[262];
      const auto ayzzz_0 = current_data[263];
      const auto azzzz_0 = current_data[268];
      const auto axxxxx_0 = current_data[319];
      const auto axxxxy_0 = current_data[320];
      const auto axxxyy_0 = current_data[321];
      const auto axxyyy_0 = current_data[322];
      const auto axyyyy_0 = current_data[323];
      const auto ayyyyy_0 = current_data[324];
      const auto axxxxz_0 = current_data[329];
      const auto axxxyz_0 = current_data[330];
      const auto axxyyz_0 = current_data[331];
      const auto axyyyz_0 = current_data[332];
      const auto ayyyyz_0 = current_data[333];
      const auto axxxzz_0 = current_data[338];
      const auto axxyzz_0 = current_data[339];
      const auto axyyzz_0 = current_data[340];
      const auto ayyyzz_0 = current_data[341];
      const auto axxzzz_0 = current_data[346];
      const auto axyzzz_0 = current_data[347];
      const auto ayyzzz_0 = current_data[348];
      const auto axzzzz_0 = current_data[353];
      const auto ayzzzz_0 = current_data[354];
      const auto azzzzz_0 = current_data[359];
      const auto axxxxxx_0 = current_data[413];
      const auto axxxxxy_0 = current_data[414];
      const auto axxxxyy_0 = current_data[415];
      const auto axxxyyy_0 = current_data[416];
      const auto axxyyyy_0 = current_data[417];
      const auto axyyyyy_0 = current_data[418];
      const auto ayyyyyy_0 = current_data[419];
      const auto axxxxxz_0 = current_data[424];
      const auto axxxxyz_0 = current_data[425];
      const auto axxxyyz_0 = current_data[426];
      const auto axxyyyz_0 = current_data[427];
      const auto axyyyyz_0 = current_data[428];
      const auto ayyyyyz_0 = current_data[429];
      const auto axxxxzz_0 = current_data[434];
      const auto axxxyzz_0 = current_data[435];
      const auto axxyyzz_0 = current_data[436];
      const auto axyyyzz_0 = current_data[437];
      const auto ayyyyzz_0 = current_data[438];
      const auto axxxzzz_0 = current_data[443];
      const auto axxyzzz_0 = current_data[444];
      const auto axyyzzz_0 = current_data[445];
      const auto ayyyzzz_0 = current_data[446];
      const auto axxzzzz_0 = current_data[451];
      const auto axyzzzz_0 = current_data[452];
      const auto ayyzzzz_0 = current_data[453];
      const auto axzzzzz_0 = current_data[458];
      const auto ayzzzzz_0 = current_data[459];
      const auto azzzzzz_0 = current_data[464];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[672] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[673] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[674] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[675] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[676] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[677] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[678] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[679] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[680] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[681] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[682] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[683] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[684] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[685] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[686] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[687] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[688] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[689] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[690] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[691] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[692] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[693] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[694] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[695] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[696] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[697] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[698] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[699] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyyzzz
      const auto a0_0 = current_data[25];
      const auto ax_0 = current_data[64];
      const auto ay_0 = current_data[65];
      const auto az_0 = current_data[70];
      const auto axx_0 = current_data[112];
      const auto axy_0 = current_data[113];
      const auto ayy_0 = current_data[114];
      const auto axz_0 = current_data[119];
      const auto ayz_0 = current_data[120];
      const auto azz_0 = current_data[125];
      const auto axxx_0 = current_data[170];
      const auto axxy_0 = current_data[171];
      const auto axyy_0 = current_data[172];
      const auto ayyy_0 = current_data[173];
      const auto axxz_0 = current_data[178];
      const auto axyz_0 = current_data[179];
      const auto ayyz_0 = current_data[180];
      const auto axzz_0 = current_data[185];
      const auto ayzz_0 = current_data[186];
      const auto azzz_0 = current_data[191];
      const auto axxxx_0 = current_data[239];
      const auto axxxy_0 = current_data[240];
      const auto axxyy_0 = current_data[241];
      const auto axyyy_0 = current_data[242];
      const auto ayyyy_0 = current_data[243];
      const auto axxxz_0 = current_data[248];
      const auto axxyz_0 = current_data[249];
      const auto axyyz_0 = current_data[250];
      const auto ayyyz_0 = current_data[251];
      const auto axxzz_0 = current_data[256];
      const auto axyzz_0 = current_data[257];
      const auto ayyzz_0 = current_data[258];
      const auto axzzz_0 = current_data[263];
      const auto ayzzz_0 = current_data[264];
      const auto azzzz_0 = current_data[269];
      const auto axxxxx_0 = current_data[320];
      const auto axxxxy_0 = current_data[321];
      const auto axxxyy_0 = current_data[322];
      const auto axxyyy_0 = current_data[323];
      const auto axyyyy_0 = current_data[324];
      const auto ayyyyy_0 = current_data[325];
      const auto axxxxz_0 = current_data[330];
      const auto axxxyz_0 = current_data[331];
      const auto axxyyz_0 = current_data[332];
      const auto axyyyz_0 = current_data[333];
      const auto ayyyyz_0 = current_data[334];
      const auto axxxzz_0 = current_data[339];
      const auto axxyzz_0 = current_data[340];
      const auto axyyzz_0 = current_data[341];
      const auto ayyyzz_0 = current_data[342];
      const auto axxzzz_0 = current_data[347];
      const auto axyzzz_0 = current_data[348];
      const auto ayyzzz_0 = current_data[349];
      const auto axzzzz_0 = current_data[354];
      const auto ayzzzz_0 = current_data[355];
      const auto azzzzz_0 = current_data[360];
      const auto axxxxxx_0 = current_data[414];
      const auto axxxxxy_0 = current_data[415];
      const auto axxxxyy_0 = current_data[416];
      const auto axxxyyy_0 = current_data[417];
      const auto axxyyyy_0 = current_data[418];
      const auto axyyyyy_0 = current_data[419];
      const auto ayyyyyy_0 = current_data[420];
      const auto axxxxxz_0 = current_data[425];
      const auto axxxxyz_0 = current_data[426];
      const auto axxxyyz_0 = current_data[427];
      const auto axxyyyz_0 = current_data[428];
      const auto axyyyyz_0 = current_data[429];
      const auto ayyyyyz_0 = current_data[430];
      const auto axxxxzz_0 = current_data[435];
      const auto axxxyzz_0 = current_data[436];
      const auto axxyyzz_0 = current_data[437];
      const auto axyyyzz_0 = current_data[438];
      const auto ayyyyzz_0 = current_data[439];
      const auto axxxzzz_0 = current_data[444];
      const auto axxyzzz_0 = current_data[445];
      const auto axyyzzz_0 = current_data[446];
      const auto ayyyzzz_0 = current_data[447];
      const auto axxzzzz_0 = current_data[452];
      const auto axyzzzz_0 = current_data[453];
      const auto ayyzzzz_0 = current_data[454];
      const auto axzzzzz_0 = current_data[459];
      const auto ayzzzzz_0 = current_data[460];
      const auto azzzzzz_0 = current_data[465];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[700] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[701] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[702] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[703] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[704] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[705] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[706] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[707] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[708] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[709] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[710] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[711] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[712] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[713] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[714] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[715] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[716] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[717] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[718] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[719] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[720] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[721] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[722] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[723] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[724] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[725] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[726] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[727] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxzzzz
      const auto a0_0 = current_data[26];
      const auto ax_0 = current_data[66];
      const auto ay_0 = current_data[67];
      const auto az_0 = current_data[71];
      const auto axx_0 = current_data[115];
      const auto axy_0 = current_data[116];
      const auto ayy_0 = current_data[117];
      const auto axz_0 = current_data[121];
      const auto ayz_0 = current_data[122];
      const auto azz_0 = current_data[126];
      const auto axxx_0 = current_data[174];
      const auto axxy_0 = current_data[175];
      const auto axyy_0 = current_data[176];
      const auto ayyy_0 = current_data[177];
      const auto axxz_0 = current_data[181];
      const auto axyz_0 = current_data[182];
      const auto ayyz_0 = current_data[183];
      const auto axzz_0 = current_data[187];
      const auto ayzz_0 = current_data[188];
      const auto azzz_0 = current_data[192];
      const auto axxxx_0 = current_data[244];
      const auto axxxy_0 = current_data[245];
      const auto axxyy_0 = current_data[246];
      const auto axyyy_0 = current_data[247];
      const auto ayyyy_0 = current_data[248];
      const auto axxxz_0 = current_data[252];
      const auto axxyz_0 = current_data[253];
      const auto axyyz_0 = current_data[254];
      const auto ayyyz_0 = current_data[255];
      const auto axxzz_0 = current_data[259];
      const auto axyzz_0 = current_data[260];
      const auto ayyzz_0 = current_data[261];
      const auto axzzz_0 = current_data[265];
      const auto ayzzz_0 = current_data[266];
      const auto azzzz_0 = current_data[270];
      const auto axxxxx_0 = current_data[326];
      const auto axxxxy_0 = current_data[327];
      const auto axxxyy_0 = current_data[328];
      const auto axxyyy_0 = current_data[329];
      const auto axyyyy_0 = current_data[330];
      const auto ayyyyy_0 = current_data[331];
      const auto axxxxz_0 = current_data[335];
      const auto axxxyz_0 = current_data[336];
      const auto axxyyz_0 = current_data[337];
      const auto axyyyz_0 = current_data[338];
      const auto ayyyyz_0 = current_data[339];
      const auto axxxzz_0 = current_data[343];
      const auto axxyzz_0 = current_data[344];
      const auto axyyzz_0 = current_data[345];
      const auto ayyyzz_0 = current_data[346];
      const auto axxzzz_0 = current_data[350];
      const auto axyzzz_0 = current_data[351];
      const auto ayyzzz_0 = current_data[352];
      const auto axzzzz_0 = current_data[356];
      const auto ayzzzz_0 = current_data[357];
      const auto azzzzz_0 = current_data[361];
      const auto axxxxxx_0 = current_data[421];
      const auto axxxxxy_0 = current_data[422];
      const auto axxxxyy_0 = current_data[423];
      const auto axxxyyy_0 = current_data[424];
      const auto axxyyyy_0 = current_data[425];
      const auto axyyyyy_0 = current_data[426];
      const auto ayyyyyy_0 = current_data[427];
      const auto axxxxxz_0 = current_data[431];
      const auto axxxxyz_0 = current_data[432];
      const auto axxxyyz_0 = current_data[433];
      const auto axxyyyz_0 = current_data[434];
      const auto axyyyyz_0 = current_data[435];
      const auto ayyyyyz_0 = current_data[436];
      const auto axxxxzz_0 = current_data[440];
      const auto axxxyzz_0 = current_data[441];
      const auto axxyyzz_0 = current_data[442];
      const auto axyyyzz_0 = current_data[443];
      const auto ayyyyzz_0 = current_data[444];
      const auto axxxzzz_0 = current_data[448];
      const auto axxyzzz_0 = current_data[449];
      const auto axyyzzz_0 = current_data[450];
      const auto ayyyzzz_0 = current_data[451];
      const auto axxzzzz_0 = current_data[455];
      const auto axyzzzz_0 = current_data[456];
      const auto ayyzzzz_0 = current_data[457];
      const auto axzzzzz_0 = current_data[461];
      const auto ayzzzzz_0 = current_data[462];
      const auto azzzzzz_0 = current_data[466];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[728] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[729] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[730] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[731] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[732] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[733] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[734] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[735] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[736] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[737] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[738] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[739] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[740] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[741] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[742] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[743] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[744] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[745] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[746] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[747] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[748] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[749] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[750] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[751] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[752] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[753] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[754] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[755] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxyzzzz
      const auto a0_0 = current_data[27];
      const auto ax_0 = current_data[67];
      const auto ay_0 = current_data[68];
      const auto az_0 = current_data[72];
      const auto axx_0 = current_data[116];
      const auto axy_0 = current_data[117];
      const auto ayy_0 = current_data[118];
      const auto axz_0 = current_data[122];
      const auto ayz_0 = current_data[123];
      const auto azz_0 = current_data[127];
      const auto axxx_0 = current_data[175];
      const auto axxy_0 = current_data[176];
      const auto axyy_0 = current_data[177];
      const auto ayyy_0 = current_data[178];
      const auto axxz_0 = current_data[182];
      const auto axyz_0 = current_data[183];
      const auto ayyz_0 = current_data[184];
      const auto axzz_0 = current_data[188];
      const auto ayzz_0 = current_data[189];
      const auto azzz_0 = current_data[193];
      const auto axxxx_0 = current_data[245];
      const auto axxxy_0 = current_data[246];
      const auto axxyy_0 = current_data[247];
      const auto axyyy_0 = current_data[248];
      const auto ayyyy_0 = current_data[249];
      const auto axxxz_0 = current_data[253];
      const auto axxyz_0 = current_data[254];
      const auto axyyz_0 = current_data[255];
      const auto ayyyz_0 = current_data[256];
      const auto axxzz_0 = current_data[260];
      const auto axyzz_0 = current_data[261];
      const auto ayyzz_0 = current_data[262];
      const auto axzzz_0 = current_data[266];
      const auto ayzzz_0 = current_data[267];
      const auto azzzz_0 = current_data[271];
      const auto axxxxx_0 = current_data[327];
      const auto axxxxy_0 = current_data[328];
      const auto axxxyy_0 = current_data[329];
      const auto axxyyy_0 = current_data[330];
      const auto axyyyy_0 = current_data[331];
      const auto ayyyyy_0 = current_data[332];
      const auto axxxxz_0 = current_data[336];
      const auto axxxyz_0 = current_data[337];
      const auto axxyyz_0 = current_data[338];
      const auto axyyyz_0 = current_data[339];
      const auto ayyyyz_0 = current_data[340];
      const auto axxxzz_0 = current_data[344];
      const auto axxyzz_0 = current_data[345];
      const auto axyyzz_0 = current_data[346];
      const auto ayyyzz_0 = current_data[347];
      const auto axxzzz_0 = current_data[351];
      const auto axyzzz_0 = current_data[352];
      const auto ayyzzz_0 = current_data[353];
      const auto axzzzz_0 = current_data[357];
      const auto ayzzzz_0 = current_data[358];
      const auto azzzzz_0 = current_data[362];
      const auto axxxxxx_0 = current_data[422];
      const auto axxxxxy_0 = current_data[423];
      const auto axxxxyy_0 = current_data[424];
      const auto axxxyyy_0 = current_data[425];
      const auto axxyyyy_0 = current_data[426];
      const auto axyyyyy_0 = current_data[427];
      const auto ayyyyyy_0 = current_data[428];
      const auto axxxxxz_0 = current_data[432];
      const auto axxxxyz_0 = current_data[433];
      const auto axxxyyz_0 = current_data[434];
      const auto axxyyyz_0 = current_data[435];
      const auto axyyyyz_0 = current_data[436];
      const auto ayyyyyz_0 = current_data[437];
      const auto axxxxzz_0 = current_data[441];
      const auto axxxyzz_0 = current_data[442];
      const auto axxyyzz_0 = current_data[443];
      const auto axyyyzz_0 = current_data[444];
      const auto ayyyyzz_0 = current_data[445];
      const auto axxxzzz_0 = current_data[449];
      const auto axxyzzz_0 = current_data[450];
      const auto axyyzzz_0 = current_data[451];
      const auto ayyyzzz_0 = current_data[452];
      const auto axxzzzz_0 = current_data[456];
      const auto axyzzzz_0 = current_data[457];
      const auto ayyzzzz_0 = current_data[458];
      const auto axzzzzz_0 = current_data[462];
      const auto ayzzzzz_0 = current_data[463];
      const auto azzzzzz_0 = current_data[467];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[756] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[757] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[758] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[759] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[760] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[761] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[762] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[763] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[764] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[765] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[766] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[767] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[768] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[769] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[770] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[771] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[772] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[773] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[774] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[775] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[776] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[777] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[778] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[779] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[780] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[781] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[782] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[783] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyyzzzz
      const auto a0_0 = current_data[28];
      const auto ax_0 = current_data[68];
      const auto ay_0 = current_data[69];
      const auto az_0 = current_data[73];
      const auto axx_0 = current_data[117];
      const auto axy_0 = current_data[118];
      const auto ayy_0 = current_data[119];
      const auto axz_0 = current_data[123];
      const auto ayz_0 = current_data[124];
      const auto azz_0 = current_data[128];
      const auto axxx_0 = current_data[176];
      const auto axxy_0 = current_data[177];
      const auto axyy_0 = current_data[178];
      const auto ayyy_0 = current_data[179];
      const auto axxz_0 = current_data[183];
      const auto axyz_0 = current_data[184];
      const auto ayyz_0 = current_data[185];
      const auto axzz_0 = current_data[189];
      const auto ayzz_0 = current_data[190];
      const auto azzz_0 = current_data[194];
      const auto axxxx_0 = current_data[246];
      const auto axxxy_0 = current_data[247];
      const auto axxyy_0 = current_data[248];
      const auto axyyy_0 = current_data[249];
      const auto ayyyy_0 = current_data[250];
      const auto axxxz_0 = current_data[254];
      const auto axxyz_0 = current_data[255];
      const auto axyyz_0 = current_data[256];
      const auto ayyyz_0 = current_data[257];
      const auto axxzz_0 = current_data[261];
      const auto axyzz_0 = current_data[262];
      const auto ayyzz_0 = current_data[263];
      const auto axzzz_0 = current_data[267];
      const auto ayzzz_0 = current_data[268];
      const auto azzzz_0 = current_data[272];
      const auto axxxxx_0 = current_data[328];
      const auto axxxxy_0 = current_data[329];
      const auto axxxyy_0 = current_data[330];
      const auto axxyyy_0 = current_data[331];
      const auto axyyyy_0 = current_data[332];
      const auto ayyyyy_0 = current_data[333];
      const auto axxxxz_0 = current_data[337];
      const auto axxxyz_0 = current_data[338];
      const auto axxyyz_0 = current_data[339];
      const auto axyyyz_0 = current_data[340];
      const auto ayyyyz_0 = current_data[341];
      const auto axxxzz_0 = current_data[345];
      const auto axxyzz_0 = current_data[346];
      const auto axyyzz_0 = current_data[347];
      const auto ayyyzz_0 = current_data[348];
      const auto axxzzz_0 = current_data[352];
      const auto axyzzz_0 = current_data[353];
      const auto ayyzzz_0 = current_data[354];
      const auto axzzzz_0 = current_data[358];
      const auto ayzzzz_0 = current_data[359];
      const auto azzzzz_0 = current_data[363];
      const auto axxxxxx_0 = current_data[423];
      const auto axxxxxy_0 = current_data[424];
      const auto axxxxyy_0 = current_data[425];
      const auto axxxyyy_0 = current_data[426];
      const auto axxyyyy_0 = current_data[427];
      const auto axyyyyy_0 = current_data[428];
      const auto ayyyyyy_0 = current_data[429];
      const auto axxxxxz_0 = current_data[433];
      const auto axxxxyz_0 = current_data[434];
      const auto axxxyyz_0 = current_data[435];
      const auto axxyyyz_0 = current_data[436];
      const auto axyyyyz_0 = current_data[437];
      const auto ayyyyyz_0 = current_data[438];
      const auto axxxxzz_0 = current_data[442];
      const auto axxxyzz_0 = current_data[443];
      const auto axxyyzz_0 = current_data[444];
      const auto axyyyzz_0 = current_data[445];
      const auto ayyyyzz_0 = current_data[446];
      const auto axxxzzz_0 = current_data[450];
      const auto axxyzzz_0 = current_data[451];
      const auto axyyzzz_0 = current_data[452];
      const auto ayyyzzz_0 = current_data[453];
      const auto axxzzzz_0 = current_data[457];
      const auto axyzzzz_0 = current_data[458];
      const auto ayyzzzz_0 = current_data[459];
      const auto axzzzzz_0 = current_data[463];
      const auto ayzzzzz_0 = current_data[464];
      const auto azzzzzz_0 = current_data[468];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[784] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[785] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[786] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[787] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[788] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[789] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[790] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[791] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[792] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[793] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[794] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[795] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[796] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[797] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[798] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[799] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[800] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[801] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[802] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[803] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[804] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[805] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[806] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[807] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[808] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[809] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[810] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[811] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyyzzzz
      const auto a0_0 = current_data[29];
      const auto ax_0 = current_data[69];
      const auto ay_0 = current_data[70];
      const auto az_0 = current_data[74];
      const auto axx_0 = current_data[118];
      const auto axy_0 = current_data[119];
      const auto ayy_0 = current_data[120];
      const auto axz_0 = current_data[124];
      const auto ayz_0 = current_data[125];
      const auto azz_0 = current_data[129];
      const auto axxx_0 = current_data[177];
      const auto axxy_0 = current_data[178];
      const auto axyy_0 = current_data[179];
      const auto ayyy_0 = current_data[180];
      const auto axxz_0 = current_data[184];
      const auto axyz_0 = current_data[185];
      const auto ayyz_0 = current_data[186];
      const auto axzz_0 = current_data[190];
      const auto ayzz_0 = current_data[191];
      const auto azzz_0 = current_data[195];
      const auto axxxx_0 = current_data[247];
      const auto axxxy_0 = current_data[248];
      const auto axxyy_0 = current_data[249];
      const auto axyyy_0 = current_data[250];
      const auto ayyyy_0 = current_data[251];
      const auto axxxz_0 = current_data[255];
      const auto axxyz_0 = current_data[256];
      const auto axyyz_0 = current_data[257];
      const auto ayyyz_0 = current_data[258];
      const auto axxzz_0 = current_data[262];
      const auto axyzz_0 = current_data[263];
      const auto ayyzz_0 = current_data[264];
      const auto axzzz_0 = current_data[268];
      const auto ayzzz_0 = current_data[269];
      const auto azzzz_0 = current_data[273];
      const auto axxxxx_0 = current_data[329];
      const auto axxxxy_0 = current_data[330];
      const auto axxxyy_0 = current_data[331];
      const auto axxyyy_0 = current_data[332];
      const auto axyyyy_0 = current_data[333];
      const auto ayyyyy_0 = current_data[334];
      const auto axxxxz_0 = current_data[338];
      const auto axxxyz_0 = current_data[339];
      const auto axxyyz_0 = current_data[340];
      const auto axyyyz_0 = current_data[341];
      const auto ayyyyz_0 = current_data[342];
      const auto axxxzz_0 = current_data[346];
      const auto axxyzz_0 = current_data[347];
      const auto axyyzz_0 = current_data[348];
      const auto ayyyzz_0 = current_data[349];
      const auto axxzzz_0 = current_data[353];
      const auto axyzzz_0 = current_data[354];
      const auto ayyzzz_0 = current_data[355];
      const auto axzzzz_0 = current_data[359];
      const auto ayzzzz_0 = current_data[360];
      const auto azzzzz_0 = current_data[364];
      const auto axxxxxx_0 = current_data[424];
      const auto axxxxxy_0 = current_data[425];
      const auto axxxxyy_0 = current_data[426];
      const auto axxxyyy_0 = current_data[427];
      const auto axxyyyy_0 = current_data[428];
      const auto axyyyyy_0 = current_data[429];
      const auto ayyyyyy_0 = current_data[430];
      const auto axxxxxz_0 = current_data[434];
      const auto axxxxyz_0 = current_data[435];
      const auto axxxyyz_0 = current_data[436];
      const auto axxyyyz_0 = current_data[437];
      const auto axyyyyz_0 = current_data[438];
      const auto ayyyyyz_0 = current_data[439];
      const auto axxxxzz_0 = current_data[443];
      const auto axxxyzz_0 = current_data[444];
      const auto axxyyzz_0 = current_data[445];
      const auto axyyyzz_0 = current_data[446];
      const auto ayyyyzz_0 = current_data[447];
      const auto axxxzzz_0 = current_data[451];
      const auto axxyzzz_0 = current_data[452];
      const auto axyyzzz_0 = current_data[453];
      const auto ayyyzzz_0 = current_data[454];
      const auto axxzzzz_0 = current_data[458];
      const auto axyzzzz_0 = current_data[459];
      const auto ayyzzzz_0 = current_data[460];
      const auto axzzzzz_0 = current_data[464];
      const auto ayzzzzz_0 = current_data[465];
      const auto azzzzzz_0 = current_data[469];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[812] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[813] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[814] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[815] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[816] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[817] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[818] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[819] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[820] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[821] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[822] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[823] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[824] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[825] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[826] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[827] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[828] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[829] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[830] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[831] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[832] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[833] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[834] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[835] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[836] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[837] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[838] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[839] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxzzzzz
      const auto a0_0 = current_data[30];
      const auto ax_0 = current_data[71];
      const auto ay_0 = current_data[72];
      const auto az_0 = current_data[75];
      const auto axx_0 = current_data[121];
      const auto axy_0 = current_data[122];
      const auto ayy_0 = current_data[123];
      const auto axz_0 = current_data[126];
      const auto ayz_0 = current_data[127];
      const auto azz_0 = current_data[130];
      const auto axxx_0 = current_data[181];
      const auto axxy_0 = current_data[182];
      const auto axyy_0 = current_data[183];
      const auto ayyy_0 = current_data[184];
      const auto axxz_0 = current_data[187];
      const auto axyz_0 = current_data[188];
      const auto ayyz_0 = current_data[189];
      const auto axzz_0 = current_data[192];
      const auto ayzz_0 = current_data[193];
      const auto azzz_0 = current_data[196];
      const auto axxxx_0 = current_data[252];
      const auto axxxy_0 = current_data[253];
      const auto axxyy_0 = current_data[254];
      const auto axyyy_0 = current_data[255];
      const auto ayyyy_0 = current_data[256];
      const auto axxxz_0 = current_data[259];
      const auto axxyz_0 = current_data[260];
      const auto axyyz_0 = current_data[261];
      const auto ayyyz_0 = current_data[262];
      const auto axxzz_0 = current_data[265];
      const auto axyzz_0 = current_data[266];
      const auto ayyzz_0 = current_data[267];
      const auto axzzz_0 = current_data[270];
      const auto ayzzz_0 = current_data[271];
      const auto azzzz_0 = current_data[274];
      const auto axxxxx_0 = current_data[335];
      const auto axxxxy_0 = current_data[336];
      const auto axxxyy_0 = current_data[337];
      const auto axxyyy_0 = current_data[338];
      const auto axyyyy_0 = current_data[339];
      const auto ayyyyy_0 = current_data[340];
      const auto axxxxz_0 = current_data[343];
      const auto axxxyz_0 = current_data[344];
      const auto axxyyz_0 = current_data[345];
      const auto axyyyz_0 = current_data[346];
      const auto ayyyyz_0 = current_data[347];
      const auto axxxzz_0 = current_data[350];
      const auto axxyzz_0 = current_data[351];
      const auto axyyzz_0 = current_data[352];
      const auto ayyyzz_0 = current_data[353];
      const auto axxzzz_0 = current_data[356];
      const auto axyzzz_0 = current_data[357];
      const auto ayyzzz_0 = current_data[358];
      const auto axzzzz_0 = current_data[361];
      const auto ayzzzz_0 = current_data[362];
      const auto azzzzz_0 = current_data[365];
      const auto axxxxxx_0 = current_data[431];
      const auto axxxxxy_0 = current_data[432];
      const auto axxxxyy_0 = current_data[433];
      const auto axxxyyy_0 = current_data[434];
      const auto axxyyyy_0 = current_data[435];
      const auto axyyyyy_0 = current_data[436];
      const auto ayyyyyy_0 = current_data[437];
      const auto axxxxxz_0 = current_data[440];
      const auto axxxxyz_0 = current_data[441];
      const auto axxxyyz_0 = current_data[442];
      const auto axxyyyz_0 = current_data[443];
      const auto axyyyyz_0 = current_data[444];
      const auto ayyyyyz_0 = current_data[445];
      const auto axxxxzz_0 = current_data[448];
      const auto axxxyzz_0 = current_data[449];
      const auto axxyyzz_0 = current_data[450];
      const auto axyyyzz_0 = current_data[451];
      const auto ayyyyzz_0 = current_data[452];
      const auto axxxzzz_0 = current_data[455];
      const auto axxyzzz_0 = current_data[456];
      const auto axyyzzz_0 = current_data[457];
      const auto ayyyzzz_0 = current_data[458];
      const auto axxzzzz_0 = current_data[461];
      const auto axyzzzz_0 = current_data[462];
      const auto ayyzzzz_0 = current_data[463];
      const auto axzzzzz_0 = current_data[466];
      const auto ayzzzzz_0 = current_data[467];
      const auto azzzzzz_0 = current_data[470];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[840] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[841] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[842] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[843] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[844] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[845] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[846] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[847] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[848] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[849] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[850] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[851] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[852] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[853] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[854] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[855] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[856] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[857] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[858] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[859] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[860] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[861] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[862] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[863] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[864] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[865] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[866] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[867] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xyzzzzz
      const auto a0_0 = current_data[31];
      const auto ax_0 = current_data[72];
      const auto ay_0 = current_data[73];
      const auto az_0 = current_data[76];
      const auto axx_0 = current_data[122];
      const auto axy_0 = current_data[123];
      const auto ayy_0 = current_data[124];
      const auto axz_0 = current_data[127];
      const auto ayz_0 = current_data[128];
      const auto azz_0 = current_data[131];
      const auto axxx_0 = current_data[182];
      const auto axxy_0 = current_data[183];
      const auto axyy_0 = current_data[184];
      const auto ayyy_0 = current_data[185];
      const auto axxz_0 = current_data[188];
      const auto axyz_0 = current_data[189];
      const auto ayyz_0 = current_data[190];
      const auto axzz_0 = current_data[193];
      const auto ayzz_0 = current_data[194];
      const auto azzz_0 = current_data[197];
      const auto axxxx_0 = current_data[253];
      const auto axxxy_0 = current_data[254];
      const auto axxyy_0 = current_data[255];
      const auto axyyy_0 = current_data[256];
      const auto ayyyy_0 = current_data[257];
      const auto axxxz_0 = current_data[260];
      const auto axxyz_0 = current_data[261];
      const auto axyyz_0 = current_data[262];
      const auto ayyyz_0 = current_data[263];
      const auto axxzz_0 = current_data[266];
      const auto axyzz_0 = current_data[267];
      const auto ayyzz_0 = current_data[268];
      const auto axzzz_0 = current_data[271];
      const auto ayzzz_0 = current_data[272];
      const auto azzzz_0 = current_data[275];
      const auto axxxxx_0 = current_data[336];
      const auto axxxxy_0 = current_data[337];
      const auto axxxyy_0 = current_data[338];
      const auto axxyyy_0 = current_data[339];
      const auto axyyyy_0 = current_data[340];
      const auto ayyyyy_0 = current_data[341];
      const auto axxxxz_0 = current_data[344];
      const auto axxxyz_0 = current_data[345];
      const auto axxyyz_0 = current_data[346];
      const auto axyyyz_0 = current_data[347];
      const auto ayyyyz_0 = current_data[348];
      const auto axxxzz_0 = current_data[351];
      const auto axxyzz_0 = current_data[352];
      const auto axyyzz_0 = current_data[353];
      const auto ayyyzz_0 = current_data[354];
      const auto axxzzz_0 = current_data[357];
      const auto axyzzz_0 = current_data[358];
      const auto ayyzzz_0 = current_data[359];
      const auto axzzzz_0 = current_data[362];
      const auto ayzzzz_0 = current_data[363];
      const auto azzzzz_0 = current_data[366];
      const auto axxxxxx_0 = current_data[432];
      const auto axxxxxy_0 = current_data[433];
      const auto axxxxyy_0 = current_data[434];
      const auto axxxyyy_0 = current_data[435];
      const auto axxyyyy_0 = current_data[436];
      const auto axyyyyy_0 = current_data[437];
      const auto ayyyyyy_0 = current_data[438];
      const auto axxxxxz_0 = current_data[441];
      const auto axxxxyz_0 = current_data[442];
      const auto axxxyyz_0 = current_data[443];
      const auto axxyyyz_0 = current_data[444];
      const auto axyyyyz_0 = current_data[445];
      const auto ayyyyyz_0 = current_data[446];
      const auto axxxxzz_0 = current_data[449];
      const auto axxxyzz_0 = current_data[450];
      const auto axxyyzz_0 = current_data[451];
      const auto axyyyzz_0 = current_data[452];
      const auto ayyyyzz_0 = current_data[453];
      const auto axxxzzz_0 = current_data[456];
      const auto axxyzzz_0 = current_data[457];
      const auto axyyzzz_0 = current_data[458];
      const auto ayyyzzz_0 = current_data[459];
      const auto axxzzzz_0 = current_data[462];
      const auto axyzzzz_0 = current_data[463];
      const auto ayyzzzz_0 = current_data[464];
      const auto axzzzzz_0 = current_data[467];
      const auto ayzzzzz_0 = current_data[468];
      const auto azzzzzz_0 = current_data[471];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[868] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[869] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[870] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[871] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[872] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[873] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[874] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[875] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[876] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[877] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[878] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[879] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[880] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[881] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[882] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[883] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[884] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[885] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[886] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[887] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[888] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[889] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[890] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[891] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[892] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[893] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[894] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[895] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yyzzzzz
      const auto a0_0 = current_data[32];
      const auto ax_0 = current_data[73];
      const auto ay_0 = current_data[74];
      const auto az_0 = current_data[77];
      const auto axx_0 = current_data[123];
      const auto axy_0 = current_data[124];
      const auto ayy_0 = current_data[125];
      const auto axz_0 = current_data[128];
      const auto ayz_0 = current_data[129];
      const auto azz_0 = current_data[132];
      const auto axxx_0 = current_data[183];
      const auto axxy_0 = current_data[184];
      const auto axyy_0 = current_data[185];
      const auto ayyy_0 = current_data[186];
      const auto axxz_0 = current_data[189];
      const auto axyz_0 = current_data[190];
      const auto ayyz_0 = current_data[191];
      const auto axzz_0 = current_data[194];
      const auto ayzz_0 = current_data[195];
      const auto azzz_0 = current_data[198];
      const auto axxxx_0 = current_data[254];
      const auto axxxy_0 = current_data[255];
      const auto axxyy_0 = current_data[256];
      const auto axyyy_0 = current_data[257];
      const auto ayyyy_0 = current_data[258];
      const auto axxxz_0 = current_data[261];
      const auto axxyz_0 = current_data[262];
      const auto axyyz_0 = current_data[263];
      const auto ayyyz_0 = current_data[264];
      const auto axxzz_0 = current_data[267];
      const auto axyzz_0 = current_data[268];
      const auto ayyzz_0 = current_data[269];
      const auto axzzz_0 = current_data[272];
      const auto ayzzz_0 = current_data[273];
      const auto azzzz_0 = current_data[276];
      const auto axxxxx_0 = current_data[337];
      const auto axxxxy_0 = current_data[338];
      const auto axxxyy_0 = current_data[339];
      const auto axxyyy_0 = current_data[340];
      const auto axyyyy_0 = current_data[341];
      const auto ayyyyy_0 = current_data[342];
      const auto axxxxz_0 = current_data[345];
      const auto axxxyz_0 = current_data[346];
      const auto axxyyz_0 = current_data[347];
      const auto axyyyz_0 = current_data[348];
      const auto ayyyyz_0 = current_data[349];
      const auto axxxzz_0 = current_data[352];
      const auto axxyzz_0 = current_data[353];
      const auto axyyzz_0 = current_data[354];
      const auto ayyyzz_0 = current_data[355];
      const auto axxzzz_0 = current_data[358];
      const auto axyzzz_0 = current_data[359];
      const auto ayyzzz_0 = current_data[360];
      const auto axzzzz_0 = current_data[363];
      const auto ayzzzz_0 = current_data[364];
      const auto azzzzz_0 = current_data[367];
      const auto axxxxxx_0 = current_data[433];
      const auto axxxxxy_0 = current_data[434];
      const auto axxxxyy_0 = current_data[435];
      const auto axxxyyy_0 = current_data[436];
      const auto axxyyyy_0 = current_data[437];
      const auto axyyyyy_0 = current_data[438];
      const auto ayyyyyy_0 = current_data[439];
      const auto axxxxxz_0 = current_data[442];
      const auto axxxxyz_0 = current_data[443];
      const auto axxxyyz_0 = current_data[444];
      const auto axxyyyz_0 = current_data[445];
      const auto axyyyyz_0 = current_data[446];
      const auto ayyyyyz_0 = current_data[447];
      const auto axxxxzz_0 = current_data[450];
      const auto axxxyzz_0 = current_data[451];
      const auto axxyyzz_0 = current_data[452];
      const auto axyyyzz_0 = current_data[453];
      const auto ayyyyzz_0 = current_data[454];
      const auto axxxzzz_0 = current_data[457];
      const auto axxyzzz_0 = current_data[458];
      const auto axyyzzz_0 = current_data[459];
      const auto ayyyzzz_0 = current_data[460];
      const auto axxzzzz_0 = current_data[463];
      const auto axyzzzz_0 = current_data[464];
      const auto ayyzzzz_0 = current_data[465];
      const auto axzzzzz_0 = current_data[468];
      const auto ayzzzzz_0 = current_data[469];
      const auto azzzzzz_0 = current_data[472];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[896] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[897] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[898] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[899] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[900] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[901] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[902] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[903] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[904] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[905] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[906] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[907] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[908] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[909] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[910] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[911] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[912] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[913] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[914] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[915] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[916] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[917] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[918] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[919] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[920] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[921] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[922] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[923] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xzzzzzz
      const auto a0_0 = current_data[33];
      const auto ax_0 = current_data[75];
      const auto ay_0 = current_data[76];
      const auto az_0 = current_data[78];
      const auto axx_0 = current_data[126];
      const auto axy_0 = current_data[127];
      const auto ayy_0 = current_data[128];
      const auto axz_0 = current_data[130];
      const auto ayz_0 = current_data[131];
      const auto azz_0 = current_data[133];
      const auto axxx_0 = current_data[187];
      const auto axxy_0 = current_data[188];
      const auto axyy_0 = current_data[189];
      const auto ayyy_0 = current_data[190];
      const auto axxz_0 = current_data[192];
      const auto axyz_0 = current_data[193];
      const auto ayyz_0 = current_data[194];
      const auto axzz_0 = current_data[196];
      const auto ayzz_0 = current_data[197];
      const auto azzz_0 = current_data[199];
      const auto axxxx_0 = current_data[259];
      const auto axxxy_0 = current_data[260];
      const auto axxyy_0 = current_data[261];
      const auto axyyy_0 = current_data[262];
      const auto ayyyy_0 = current_data[263];
      const auto axxxz_0 = current_data[265];
      const auto axxyz_0 = current_data[266];
      const auto axyyz_0 = current_data[267];
      const auto ayyyz_0 = current_data[268];
      const auto axxzz_0 = current_data[270];
      const auto axyzz_0 = current_data[271];
      const auto ayyzz_0 = current_data[272];
      const auto axzzz_0 = current_data[274];
      const auto ayzzz_0 = current_data[275];
      const auto azzzz_0 = current_data[277];
      const auto axxxxx_0 = current_data[343];
      const auto axxxxy_0 = current_data[344];
      const auto axxxyy_0 = current_data[345];
      const auto axxyyy_0 = current_data[346];
      const auto axyyyy_0 = current_data[347];
      const auto ayyyyy_0 = current_data[348];
      const auto axxxxz_0 = current_data[350];
      const auto axxxyz_0 = current_data[351];
      const auto axxyyz_0 = current_data[352];
      const auto axyyyz_0 = current_data[353];
      const auto ayyyyz_0 = current_data[354];
      const auto axxxzz_0 = current_data[356];
      const auto axxyzz_0 = current_data[357];
      const auto axyyzz_0 = current_data[358];
      const auto ayyyzz_0 = current_data[359];
      const auto axxzzz_0 = current_data[361];
      const auto axyzzz_0 = current_data[362];
      const auto ayyzzz_0 = current_data[363];
      const auto axzzzz_0 = current_data[365];
      const auto ayzzzz_0 = current_data[366];
      const auto azzzzz_0 = current_data[368];
      const auto axxxxxx_0 = current_data[440];
      const auto axxxxxy_0 = current_data[441];
      const auto axxxxyy_0 = current_data[442];
      const auto axxxyyy_0 = current_data[443];
      const auto axxyyyy_0 = current_data[444];
      const auto axyyyyy_0 = current_data[445];
      const auto ayyyyyy_0 = current_data[446];
      const auto axxxxxz_0 = current_data[448];
      const auto axxxxyz_0 = current_data[449];
      const auto axxxyyz_0 = current_data[450];
      const auto axxyyyz_0 = current_data[451];
      const auto axyyyyz_0 = current_data[452];
      const auto ayyyyyz_0 = current_data[453];
      const auto axxxxzz_0 = current_data[455];
      const auto axxxyzz_0 = current_data[456];
      const auto axxyyzz_0 = current_data[457];
      const auto axyyyzz_0 = current_data[458];
      const auto ayyyyzz_0 = current_data[459];
      const auto axxxzzz_0 = current_data[461];
      const auto axxyzzz_0 = current_data[462];
      const auto axyyzzz_0 = current_data[463];
      const auto ayyyzzz_0 = current_data[464];
      const auto axxzzzz_0 = current_data[466];
      const auto axyzzzz_0 = current_data[467];
      const auto ayyzzzz_0 = current_data[468];
      const auto axzzzzz_0 = current_data[470];
      const auto ayzzzzz_0 = current_data[471];
      const auto azzzzzz_0 = current_data[473];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[924] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[925] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[926] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[927] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[928] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[929] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[930] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[931] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[932] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[933] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[934] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[935] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[936] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[937] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[938] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[939] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[940] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[941] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[942] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[943] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[944] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[945] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[946] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[947] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[948] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[949] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[950] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[951] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: yzzzzzz
      const auto a0_0 = current_data[34];
      const auto ax_0 = current_data[76];
      const auto ay_0 = current_data[77];
      const auto az_0 = current_data[79];
      const auto axx_0 = current_data[127];
      const auto axy_0 = current_data[128];
      const auto ayy_0 = current_data[129];
      const auto axz_0 = current_data[131];
      const auto ayz_0 = current_data[132];
      const auto azz_0 = current_data[134];
      const auto axxx_0 = current_data[188];
      const auto axxy_0 = current_data[189];
      const auto axyy_0 = current_data[190];
      const auto ayyy_0 = current_data[191];
      const auto axxz_0 = current_data[193];
      const auto axyz_0 = current_data[194];
      const auto ayyz_0 = current_data[195];
      const auto axzz_0 = current_data[197];
      const auto ayzz_0 = current_data[198];
      const auto azzz_0 = current_data[200];
      const auto axxxx_0 = current_data[260];
      const auto axxxy_0 = current_data[261];
      const auto axxyy_0 = current_data[262];
      const auto axyyy_0 = current_data[263];
      const auto ayyyy_0 = current_data[264];
      const auto axxxz_0 = current_data[266];
      const auto axxyz_0 = current_data[267];
      const auto axyyz_0 = current_data[268];
      const auto ayyyz_0 = current_data[269];
      const auto axxzz_0 = current_data[271];
      const auto axyzz_0 = current_data[272];
      const auto ayyzz_0 = current_data[273];
      const auto axzzz_0 = current_data[275];
      const auto ayzzz_0 = current_data[276];
      const auto azzzz_0 = current_data[278];
      const auto axxxxx_0 = current_data[344];
      const auto axxxxy_0 = current_data[345];
      const auto axxxyy_0 = current_data[346];
      const auto axxyyy_0 = current_data[347];
      const auto axyyyy_0 = current_data[348];
      const auto ayyyyy_0 = current_data[349];
      const auto axxxxz_0 = current_data[351];
      const auto axxxyz_0 = current_data[352];
      const auto axxyyz_0 = current_data[353];
      const auto axyyyz_0 = current_data[354];
      const auto ayyyyz_0 = current_data[355];
      const auto axxxzz_0 = current_data[357];
      const auto axxyzz_0 = current_data[358];
      const auto axyyzz_0 = current_data[359];
      const auto ayyyzz_0 = current_data[360];
      const auto axxzzz_0 = current_data[362];
      const auto axyzzz_0 = current_data[363];
      const auto ayyzzz_0 = current_data[364];
      const auto axzzzz_0 = current_data[366];
      const auto ayzzzz_0 = current_data[367];
      const auto azzzzz_0 = current_data[369];
      const auto axxxxxx_0 = current_data[441];
      const auto axxxxxy_0 = current_data[442];
      const auto axxxxyy_0 = current_data[443];
      const auto axxxyyy_0 = current_data[444];
      const auto axxyyyy_0 = current_data[445];
      const auto axyyyyy_0 = current_data[446];
      const auto ayyyyyy_0 = current_data[447];
      const auto axxxxxz_0 = current_data[449];
      const auto axxxxyz_0 = current_data[450];
      const auto axxxyyz_0 = current_data[451];
      const auto axxyyyz_0 = current_data[452];
      const auto axyyyyz_0 = current_data[453];
      const auto ayyyyyz_0 = current_data[454];
      const auto axxxxzz_0 = current_data[456];
      const auto axxxyzz_0 = current_data[457];
      const auto axxyyzz_0 = current_data[458];
      const auto axyyyzz_0 = current_data[459];
      const auto ayyyyzz_0 = current_data[460];
      const auto axxxzzz_0 = current_data[462];
      const auto axxyzzz_0 = current_data[463];
      const auto axyyzzz_0 = current_data[464];
      const auto ayyyzzz_0 = current_data[465];
      const auto axxzzzz_0 = current_data[467];
      const auto axyzzzz_0 = current_data[468];
      const auto ayyzzzz_0 = current_data[469];
      const auto axzzzzz_0 = current_data[471];
      const auto ayzzzzz_0 = current_data[472];
      const auto azzzzzz_0 = current_data[474];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[952] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[953] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[954] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[955] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[956] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[957] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[958] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[959] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[960] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[961] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[962] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[963] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[964] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[965] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[966] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[967] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[968] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[969] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[970] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[971] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[972] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[973] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[974] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[975] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[976] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[977] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[978] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[979] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: zzzzzzz
      const auto a0_0 = current_data[35];
      const auto ax_0 = current_data[78];
      const auto ay_0 = current_data[79];
      const auto az_0 = current_data[80];
      const auto axx_0 = current_data[130];
      const auto axy_0 = current_data[131];
      const auto ayy_0 = current_data[132];
      const auto axz_0 = current_data[133];
      const auto ayz_0 = current_data[134];
      const auto azz_0 = current_data[135];
      const auto axxx_0 = current_data[192];
      const auto axxy_0 = current_data[193];
      const auto axyy_0 = current_data[194];
      const auto ayyy_0 = current_data[195];
      const auto axxz_0 = current_data[196];
      const auto axyz_0 = current_data[197];
      const auto ayyz_0 = current_data[198];
      const auto axzz_0 = current_data[199];
      const auto ayzz_0 = current_data[200];
      const auto azzz_0 = current_data[201];
      const auto axxxx_0 = current_data[265];
      const auto axxxy_0 = current_data[266];
      const auto axxyy_0 = current_data[267];
      const auto axyyy_0 = current_data[268];
      const auto ayyyy_0 = current_data[269];
      const auto axxxz_0 = current_data[270];
      const auto axxyz_0 = current_data[271];
      const auto axyyz_0 = current_data[272];
      const auto ayyyz_0 = current_data[273];
      const auto axxzz_0 = current_data[274];
      const auto axyzz_0 = current_data[275];
      const auto ayyzz_0 = current_data[276];
      const auto axzzz_0 = current_data[277];
      const auto ayzzz_0 = current_data[278];
      const auto azzzz_0 = current_data[279];
      const auto axxxxx_0 = current_data[350];
      const auto axxxxy_0 = current_data[351];
      const auto axxxyy_0 = current_data[352];
      const auto axxyyy_0 = current_data[353];
      const auto axyyyy_0 = current_data[354];
      const auto ayyyyy_0 = current_data[355];
      const auto axxxxz_0 = current_data[356];
      const auto axxxyz_0 = current_data[357];
      const auto axxyyz_0 = current_data[358];
      const auto axyyyz_0 = current_data[359];
      const auto ayyyyz_0 = current_data[360];
      const auto axxxzz_0 = current_data[361];
      const auto axxyzz_0 = current_data[362];
      const auto axyyzz_0 = current_data[363];
      const auto ayyyzz_0 = current_data[364];
      const auto axxzzz_0 = current_data[365];
      const auto axyzzz_0 = current_data[366];
      const auto ayyzzz_0 = current_data[367];
      const auto axzzzz_0 = current_data[368];
      const auto ayzzzz_0 = current_data[369];
      const auto azzzzz_0 = current_data[370];
      const auto axxxxxx_0 = current_data[448];
      const auto axxxxxy_0 = current_data[449];
      const auto axxxxyy_0 = current_data[450];
      const auto axxxyyy_0 = current_data[451];
      const auto axxyyyy_0 = current_data[452];
      const auto axyyyyy_0 = current_data[453];
      const auto ayyyyyy_0 = current_data[454];
      const auto axxxxxz_0 = current_data[455];
      const auto axxxxyz_0 = current_data[456];
      const auto axxxyyz_0 = current_data[457];
      const auto axxyyyz_0 = current_data[458];
      const auto axyyyyz_0 = current_data[459];
      const auto ayyyyyz_0 = current_data[460];
      const auto axxxxzz_0 = current_data[461];
      const auto axxxyzz_0 = current_data[462];
      const auto axxyyzz_0 = current_data[463];
      const auto axyyyzz_0 = current_data[464];
      const auto ayyyyzz_0 = current_data[465];
      const auto axxxzzz_0 = current_data[466];
      const auto axxyzzz_0 = current_data[467];
      const auto axyyzzz_0 = current_data[468];
      const auto ayyyzzz_0 = current_data[469];
      const auto axxzzzz_0 = current_data[470];
      const auto axyzzzz_0 = current_data[471];
      const auto ayyzzzz_0 = current_data[472];
      const auto axzzzzz_0 = current_data[473];
      const auto ayzzzzz_0 = current_data[474];
      const auto azzzzzz_0 = current_data[475];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[980] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[981] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[982] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[983] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[984] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[985] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[986] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[987] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[988] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[989] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[990] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[991] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[992] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[993] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[994] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[995] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[996] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[997] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[998] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[999] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[1000] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[1001] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[1002] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[1003] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[1004] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[1005] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[1006] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[1007] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
  }
}


void CHRRList::perform_HRR_d0_76(const int nloop, const complex<double>* data_start, const array<double,3>& AB, complex<double>* data_out) {
  for (int c = 0; c != nloop; ++c) {
    auto current_data = &data_start[c * 476];
    auto current_out = &data_out[c * 1008];
   {
     //current index a: xxxxxxx
      const auto a0_0 = current_data[0];
      const auto ax_0 = current_data[36];
      const auto ay_0 = current_data[37];
      const auto az_0 = current_data[45];
      const auto axx_0 = current_data[81];
      const auto axy_0 = current_data[82];
      const auto ayy_0 = current_data[83];
      const auto axz_0 = current_data[91];
      const auto ayz_0 = current_data[92];
      const auto azz_0 = current_data[100];
      const auto axxx_0 = current_data[136];
      const auto axxy_0 = current_data[137];
      const auto axyy_0 = current_data[138];
      const auto ayyy_0 = current_data[139];
      const auto axxz_0 = current_data[147];
      const auto axyz_0 = current_data[148];
      const auto ayyz_0 = current_data[149];
      const auto axzz_0 = current_data[157];
      const auto ayzz_0 = current_data[158];
      const auto azzz_0 = current_data[166];
      const auto axxxx_0 = current_data[202];
      const auto axxxy_0 = current_data[203];
      const auto axxyy_0 = current_data[204];
      const auto axyyy_0 = current_data[205];
      const auto ayyyy_0 = current_data[206];
      const auto axxxz_0 = current_data[214];
      const auto axxyz_0 = current_data[215];
      const auto axyyz_0 = current_data[216];
      const auto ayyyz_0 = current_data[217];
      const auto axxzz_0 = current_data[225];
      const auto axyzz_0 = current_data[226];
      const auto ayyzz_0 = current_data[227];
      const auto axzzz_0 = current_data[235];
      const auto ayzzz_0 = current_data[236];
      const auto azzzz_0 = current_data[244];
      const auto axxxxx_0 = current_data[280];
      const auto axxxxy_0 = current_data[281];
      const auto axxxyy_0 = current_data[282];
      const auto axxyyy_0 = current_data[283];
      const auto axyyyy_0 = current_data[284];
      const auto ayyyyy_0 = current_data[285];
      const auto axxxxz_0 = current_data[293];
      const auto axxxyz_0 = current_data[294];
      const auto axxyyz_0 = current_data[295];
      const auto axyyyz_0 = current_data[296];
      const auto ayyyyz_0 = current_data[297];
      const auto axxxzz_0 = current_data[305];
      const auto axxyzz_0 = current_data[306];
      const auto axyyzz_0 = current_data[307];
      const auto ayyyzz_0 = current_data[308];
      const auto axxzzz_0 = current_data[316];
      const auto axyzzz_0 = current_data[317];
      const auto ayyzzz_0 = current_data[318];
      const auto axzzzz_0 = current_data[326];
      const auto ayzzzz_0 = current_data[327];
      const auto azzzzz_0 = current_data[335];
      const auto axxxxxx_0 = current_data[371];
      const auto axxxxxy_0 = current_data[372];
      const auto axxxxyy_0 = current_data[373];
      const auto axxxyyy_0 = current_data[374];
      const auto axxyyyy_0 = current_data[375];
      const auto axyyyyy_0 = current_data[376];
      const auto ayyyyyy_0 = current_data[377];
      const auto axxxxxz_0 = current_data[385];
      const auto axxxxyz_0 = current_data[386];
      const auto axxxyyz_0 = current_data[387];
      const auto axxyyyz_0 = current_data[388];
      const auto axyyyyz_0 = current_data[389];
      const auto ayyyyyz_0 = current_data[390];
      const auto axxxxzz_0 = current_data[398];
      const auto axxxyzz_0 = current_data[399];
      const auto axxyyzz_0 = current_data[400];
      const auto axyyyzz_0 = current_data[401];
      const auto ayyyyzz_0 = current_data[402];
      const auto axxxzzz_0 = current_data[410];
      const auto axxyzzz_0 = current_data[411];
      const auto axyyzzz_0 = current_data[412];
      const auto ayyyzzz_0 = current_data[413];
      const auto axxzzzz_0 = current_data[421];
      const auto axyzzzz_0 = current_data[422];
      const auto ayyzzzz_0 = current_data[423];
      const auto axzzzzz_0 = current_data[431];
      const auto ayzzzzz_0 = current_data[432];
      const auto azzzzzz_0 = current_data[440];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[0] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[1] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[2] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[3] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[4] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[5] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[6] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[7] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[8] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[9] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[10] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[11] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[12] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[13] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[14] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[15] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[16] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[17] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[18] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[19] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[20] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[21] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[22] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[23] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[24] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[25] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[26] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[27] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxxy
      const auto a0_0 = current_data[1];
      const auto ax_0 = current_data[37];
      const auto ay_0 = current_data[38];
      const auto az_0 = current_data[46];
      const auto axx_0 = current_data[82];
      const auto axy_0 = current_data[83];
      const auto ayy_0 = current_data[84];
      const auto axz_0 = current_data[92];
      const auto ayz_0 = current_data[93];
      const auto azz_0 = current_data[101];
      const auto axxx_0 = current_data[137];
      const auto axxy_0 = current_data[138];
      const auto axyy_0 = current_data[139];
      const auto ayyy_0 = current_data[140];
      const auto axxz_0 = current_data[148];
      const auto axyz_0 = current_data[149];
      const auto ayyz_0 = current_data[150];
      const auto axzz_0 = current_data[158];
      const auto ayzz_0 = current_data[159];
      const auto azzz_0 = current_data[167];
      const auto axxxx_0 = current_data[203];
      const auto axxxy_0 = current_data[204];
      const auto axxyy_0 = current_data[205];
      const auto axyyy_0 = current_data[206];
      const auto ayyyy_0 = current_data[207];
      const auto axxxz_0 = current_data[215];
      const auto axxyz_0 = current_data[216];
      const auto axyyz_0 = current_data[217];
      const auto ayyyz_0 = current_data[218];
      const auto axxzz_0 = current_data[226];
      const auto axyzz_0 = current_data[227];
      const auto ayyzz_0 = current_data[228];
      const auto axzzz_0 = current_data[236];
      const auto ayzzz_0 = current_data[237];
      const auto azzzz_0 = current_data[245];
      const auto axxxxx_0 = current_data[281];
      const auto axxxxy_0 = current_data[282];
      const auto axxxyy_0 = current_data[283];
      const auto axxyyy_0 = current_data[284];
      const auto axyyyy_0 = current_data[285];
      const auto ayyyyy_0 = current_data[286];
      const auto axxxxz_0 = current_data[294];
      const auto axxxyz_0 = current_data[295];
      const auto axxyyz_0 = current_data[296];
      const auto axyyyz_0 = current_data[297];
      const auto ayyyyz_0 = current_data[298];
      const auto axxxzz_0 = current_data[306];
      const auto axxyzz_0 = current_data[307];
      const auto axyyzz_0 = current_data[308];
      const auto ayyyzz_0 = current_data[309];
      const auto axxzzz_0 = current_data[317];
      const auto axyzzz_0 = current_data[318];
      const auto ayyzzz_0 = current_data[319];
      const auto axzzzz_0 = current_data[327];
      const auto ayzzzz_0 = current_data[328];
      const auto azzzzz_0 = current_data[336];
      const auto axxxxxx_0 = current_data[372];
      const auto axxxxxy_0 = current_data[373];
      const auto axxxxyy_0 = current_data[374];
      const auto axxxyyy_0 = current_data[375];
      const auto axxyyyy_0 = current_data[376];
      const auto axyyyyy_0 = current_data[377];
      const auto ayyyyyy_0 = current_data[378];
      const auto axxxxxz_0 = current_data[386];
      const auto axxxxyz_0 = current_data[387];
      const auto axxxyyz_0 = current_data[388];
      const auto axxyyyz_0 = current_data[389];
      const auto axyyyyz_0 = current_data[390];
      const auto ayyyyyz_0 = current_data[391];
      const auto axxxxzz_0 = current_data[399];
      const auto axxxyzz_0 = current_data[400];
      const auto axxyyzz_0 = current_data[401];
      const auto axyyyzz_0 = current_data[402];
      const auto ayyyyzz_0 = current_data[403];
      const auto axxxzzz_0 = current_data[411];
      const auto axxyzzz_0 = current_data[412];
      const auto axyyzzz_0 = current_data[413];
      const auto ayyyzzz_0 = current_data[414];
      const auto axxzzzz_0 = current_data[422];
      const auto axyzzzz_0 = current_data[423];
      const auto ayyzzzz_0 = current_data[424];
      const auto axzzzzz_0 = current_data[432];
      const auto ayzzzzz_0 = current_data[433];
      const auto azzzzzz_0 = current_data[441];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[28] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[29] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[30] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[31] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[32] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[33] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[34] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[35] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[36] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[37] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[38] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[39] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[40] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[41] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[42] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[43] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[44] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[45] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[46] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[47] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[48] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[49] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[50] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[51] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[52] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[53] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[54] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[55] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxxyy
      const auto a0_0 = current_data[2];
      const auto ax_0 = current_data[38];
      const auto ay_0 = current_data[39];
      const auto az_0 = current_data[47];
      const auto axx_0 = current_data[83];
      const auto axy_0 = current_data[84];
      const auto ayy_0 = current_data[85];
      const auto axz_0 = current_data[93];
      const auto ayz_0 = current_data[94];
      const auto azz_0 = current_data[102];
      const auto axxx_0 = current_data[138];
      const auto axxy_0 = current_data[139];
      const auto axyy_0 = current_data[140];
      const auto ayyy_0 = current_data[141];
      const auto axxz_0 = current_data[149];
      const auto axyz_0 = current_data[150];
      const auto ayyz_0 = current_data[151];
      const auto axzz_0 = current_data[159];
      const auto ayzz_0 = current_data[160];
      const auto azzz_0 = current_data[168];
      const auto axxxx_0 = current_data[204];
      const auto axxxy_0 = current_data[205];
      const auto axxyy_0 = current_data[206];
      const auto axyyy_0 = current_data[207];
      const auto ayyyy_0 = current_data[208];
      const auto axxxz_0 = current_data[216];
      const auto axxyz_0 = current_data[217];
      const auto axyyz_0 = current_data[218];
      const auto ayyyz_0 = current_data[219];
      const auto axxzz_0 = current_data[227];
      const auto axyzz_0 = current_data[228];
      const auto ayyzz_0 = current_data[229];
      const auto axzzz_0 = current_data[237];
      const auto ayzzz_0 = current_data[238];
      const auto azzzz_0 = current_data[246];
      const auto axxxxx_0 = current_data[282];
      const auto axxxxy_0 = current_data[283];
      const auto axxxyy_0 = current_data[284];
      const auto axxyyy_0 = current_data[285];
      const auto axyyyy_0 = current_data[286];
      const auto ayyyyy_0 = current_data[287];
      const auto axxxxz_0 = current_data[295];
      const auto axxxyz_0 = current_data[296];
      const auto axxyyz_0 = current_data[297];
      const auto axyyyz_0 = current_data[298];
      const auto ayyyyz_0 = current_data[299];
      const auto axxxzz_0 = current_data[307];
      const auto axxyzz_0 = current_data[308];
      const auto axyyzz_0 = current_data[309];
      const auto ayyyzz_0 = current_data[310];
      const auto axxzzz_0 = current_data[318];
      const auto axyzzz_0 = current_data[319];
      const auto ayyzzz_0 = current_data[320];
      const auto axzzzz_0 = current_data[328];
      const auto ayzzzz_0 = current_data[329];
      const auto azzzzz_0 = current_data[337];
      const auto axxxxxx_0 = current_data[373];
      const auto axxxxxy_0 = current_data[374];
      const auto axxxxyy_0 = current_data[375];
      const auto axxxyyy_0 = current_data[376];
      const auto axxyyyy_0 = current_data[377];
      const auto axyyyyy_0 = current_data[378];
      const auto ayyyyyy_0 = current_data[379];
      const auto axxxxxz_0 = current_data[387];
      const auto axxxxyz_0 = current_data[388];
      const auto axxxyyz_0 = current_data[389];
      const auto axxyyyz_0 = current_data[390];
      const auto axyyyyz_0 = current_data[391];
      const auto ayyyyyz_0 = current_data[392];
      const auto axxxxzz_0 = current_data[400];
      const auto axxxyzz_0 = current_data[401];
      const auto axxyyzz_0 = current_data[402];
      const auto axyyyzz_0 = current_data[403];
      const auto ayyyyzz_0 = current_data[404];
      const auto axxxzzz_0 = current_data[412];
      const auto axxyzzz_0 = current_data[413];
      const auto axyyzzz_0 = current_data[414];
      const auto ayyyzzz_0 = current_data[415];
      const auto axxzzzz_0 = current_data[423];
      const auto axyzzzz_0 = current_data[424];
      const auto ayyzzzz_0 = current_data[425];
      const auto axzzzzz_0 = current_data[433];
      const auto ayzzzzz_0 = current_data[434];
      const auto azzzzzz_0 = current_data[442];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[56] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[57] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[58] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[59] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[60] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[61] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[62] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[63] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[64] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[65] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[66] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[67] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[68] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[69] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[70] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[71] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[72] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[73] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[74] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[75] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[76] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[77] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[78] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[79] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[80] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[81] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[82] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[83] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxxyyy
      const auto a0_0 = current_data[3];
      const auto ax_0 = current_data[39];
      const auto ay_0 = current_data[40];
      const auto az_0 = current_data[48];
      const auto axx_0 = current_data[84];
      const auto axy_0 = current_data[85];
      const auto ayy_0 = current_data[86];
      const auto axz_0 = current_data[94];
      const auto ayz_0 = current_data[95];
      const auto azz_0 = current_data[103];
      const auto axxx_0 = current_data[139];
      const auto axxy_0 = current_data[140];
      const auto axyy_0 = current_data[141];
      const auto ayyy_0 = current_data[142];
      const auto axxz_0 = current_data[150];
      const auto axyz_0 = current_data[151];
      const auto ayyz_0 = current_data[152];
      const auto axzz_0 = current_data[160];
      const auto ayzz_0 = current_data[161];
      const auto azzz_0 = current_data[169];
      const auto axxxx_0 = current_data[205];
      const auto axxxy_0 = current_data[206];
      const auto axxyy_0 = current_data[207];
      const auto axyyy_0 = current_data[208];
      const auto ayyyy_0 = current_data[209];
      const auto axxxz_0 = current_data[217];
      const auto axxyz_0 = current_data[218];
      const auto axyyz_0 = current_data[219];
      const auto ayyyz_0 = current_data[220];
      const auto axxzz_0 = current_data[228];
      const auto axyzz_0 = current_data[229];
      const auto ayyzz_0 = current_data[230];
      const auto axzzz_0 = current_data[238];
      const auto ayzzz_0 = current_data[239];
      const auto azzzz_0 = current_data[247];
      const auto axxxxx_0 = current_data[283];
      const auto axxxxy_0 = current_data[284];
      const auto axxxyy_0 = current_data[285];
      const auto axxyyy_0 = current_data[286];
      const auto axyyyy_0 = current_data[287];
      const auto ayyyyy_0 = current_data[288];
      const auto axxxxz_0 = current_data[296];
      const auto axxxyz_0 = current_data[297];
      const auto axxyyz_0 = current_data[298];
      const auto axyyyz_0 = current_data[299];
      const auto ayyyyz_0 = current_data[300];
      const auto axxxzz_0 = current_data[308];
      const auto axxyzz_0 = current_data[309];
      const auto axyyzz_0 = current_data[310];
      const auto ayyyzz_0 = current_data[311];
      const auto axxzzz_0 = current_data[319];
      const auto axyzzz_0 = current_data[320];
      const auto ayyzzz_0 = current_data[321];
      const auto axzzzz_0 = current_data[329];
      const auto ayzzzz_0 = current_data[330];
      const auto azzzzz_0 = current_data[338];
      const auto axxxxxx_0 = current_data[374];
      const auto axxxxxy_0 = current_data[375];
      const auto axxxxyy_0 = current_data[376];
      const auto axxxyyy_0 = current_data[377];
      const auto axxyyyy_0 = current_data[378];
      const auto axyyyyy_0 = current_data[379];
      const auto ayyyyyy_0 = current_data[380];
      const auto axxxxxz_0 = current_data[388];
      const auto axxxxyz_0 = current_data[389];
      const auto axxxyyz_0 = current_data[390];
      const auto axxyyyz_0 = current_data[391];
      const auto axyyyyz_0 = current_data[392];
      const auto ayyyyyz_0 = current_data[393];
      const auto axxxxzz_0 = current_data[401];
      const auto axxxyzz_0 = current_data[402];
      const auto axxyyzz_0 = current_data[403];
      const auto axyyyzz_0 = current_data[404];
      const auto ayyyyzz_0 = current_data[405];
      const auto axxxzzz_0 = current_data[413];
      const auto axxyzzz_0 = current_data[414];
      const auto axyyzzz_0 = current_data[415];
      const auto ayyyzzz_0 = current_data[416];
      const auto axxzzzz_0 = current_data[424];
      const auto axyzzzz_0 = current_data[425];
      const auto ayyzzzz_0 = current_data[426];
      const auto axzzzzz_0 = current_data[434];
      const auto ayzzzzz_0 = current_data[435];
      const auto azzzzzz_0 = current_data[443];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      const auto ayyy_yyy = ayyyy_yy + AB[1] * ayyy_yy;
      const auto axxx_xxz = axxxx_xz + AB[0] * axxx_xz;
      const auto axxx_xyz = axxxx_yz + AB[0] * axxx_yz;
      const auto axxx_yyz = axxxy_yz + AB[1] * axxx_yz;
      const auto axxy_yyz = axxyy_yz + AB[1] * axxy_yz;
      const auto axyy_yyz = axyyy_yz + AB[1] * axyy_yz;
      const auto ayyy_yyz = ayyyy_yz + AB[1] * ayyy_yz;
      const auto axxx_xzz = axxxx_zz + AB[0] * axxx_zz;
      const auto axxx_yzz = axxxy_zz + AB[1] * axxx_zz;
      const auto axxy_yzz = axxyy_zz + AB[1] * axxy_zz;
      const auto axyy_yzz = axyyy_zz + AB[1] * axyy_zz;
      const auto ayyy_yzz = ayyyy_zz + AB[1] * ayyy_zz;
      const auto axxx_zzz = axxxz_zz + AB[2] * axxx_zz;
      const auto axxy_zzz = axxyz_zz + AB[2] * axxy_zz;
      const auto axyy_zzz = axyyz_zz + AB[2] * axyy_zz;
      const auto ayyy_zzz = ayyyz_zz + AB[2] * ayyy_zz;
      const auto axxz_zzz = axxzz_zz + AB[2] * axxz_zz;
      const auto axyz_zzz = axyzz_zz + AB[2] * axyz_zz;
      const auto ayyz_zzz = ayyzz_zz + AB[2] * ayyz_zz;
      const auto axzz_zzz = axzzz_zz + AB[2] * axzz_zz;
      const auto ayzz_zzz = ayzzz_zz + AB[2] * ayzz_zz;
      const auto azzz_zzz = azzzz_zz + AB[2] * azzz_zz;

      const auto a0_xxxx = ax_xxx + AB[0] * a0_xxx;
      const auto a0_xxxy = ax_xxy + AB[0] * a0_xxy;
      const auto a0_xxyy = ax_xyy + AB[0] * a0_xyy;
      const auto a0_xyyy = ax_yyy + AB[0] * a0_yyy;
      const auto a0_yyyy = ay_yyy + AB[1] * a0_yyy;
      const auto a0_xxxz = ax_xxz + AB[0] * a0_xxz;
      const auto a0_xxyz = ax_xyz + AB[0] * a0_xyz;
      const auto a0_xyyz = ax_yyz + AB[0] * a0_yyz;
      const auto a0_yyyz = ay_yyz + AB[1] * a0_yyz;
      const auto a0_xxzz = ax_xzz + AB[0] * a0_xzz;
      const auto a0_xyzz = ax_yzz + AB[0] * a0_yzz;
      const auto a0_yyzz = ay_yzz + AB[1] * a0_yzz;
      const auto a0_xzzz = ax_zzz + AB[0] * a0_zzz;
      const auto a0_yzzz = ay_zzz + AB[1] * a0_zzz;
      const auto a0_zzzz = az_zzz + AB[2] * a0_zzz;

      const auto ax_xxxx = axx_xxx + AB[0] * ax_xxx;
      const auto ax_xxxy = axx_xxy + AB[0] * ax_xxy;
      const auto ax_xxyy = axx_xyy + AB[0] * ax_xyy;
      const auto ax_xyyy = axx_yyy + AB[0] * ax_yyy;
      const auto ax_yyyy = axy_yyy + AB[1] * ax_yyy;
      const auto ay_yyyy = ayy_yyy + AB[1] * ay_yyy;
      const auto ax_xxxz = axx_xxz + AB[0] * ax_xxz;
      const auto ax_xxyz = axx_xyz + AB[0] * ax_xyz;
      const auto ax_xyyz = axx_yyz + AB[0] * ax_yyz;
      const auto ax_yyyz = axy_yyz + AB[1] * ax_yyz;
      const auto ay_yyyz = ayy_yyz + AB[1] * ay_yyz;
      const auto ax_xxzz = axx_xzz + AB[0] * ax_xzz;
      const auto ax_xyzz = axx_yzz + AB[0] * ax_yzz;
      const auto ax_yyzz = axy_yzz + AB[1] * ax_yzz;
      const auto ay_yyzz = ayy_yzz + AB[1] * ay_yzz;
      const auto ax_xzzz = axx_zzz + AB[0] * ax_zzz;
      const auto ax_yzzz = axy_zzz + AB[1] * ax_zzz;
      const auto ay_yzzz = ayy_zzz + AB[1] * ay_zzz;
      const auto ax_zzzz = axz_zzz + AB[2] * ax_zzz;
      const auto ay_zzzz = ayz_zzz + AB[2] * ay_zzz;
      const auto az_zzzz = azz_zzz + AB[2] * az_zzz;

      const auto axx_xxxx = axxx_xxx + AB[0] * axx_xxx;
      const auto axx_xxxy = axxx_xxy + AB[0] * axx_xxy;
      const auto axx_xxyy = axxx_xyy + AB[0] * axx_xyy;
      const auto axx_xyyy = axxx_yyy + AB[0] * axx_yyy;
      const auto axx_yyyy = axxy_yyy + AB[1] * axx_yyy;
      const auto axy_yyyy = axyy_yyy + AB[1] * axy_yyy;
      const auto ayy_yyyy = ayyy_yyy + AB[1] * ayy_yyy;
      const auto axx_xxxz = axxx_xxz + AB[0] * axx_xxz;
      const auto axx_xxyz = axxx_xyz + AB[0] * axx_xyz;
      const auto axx_xyyz = axxx_yyz + AB[0] * axx_yyz;
      const auto axx_yyyz = axxy_yyz + AB[1] * axx_yyz;
      const auto axy_yyyz = axyy_yyz + AB[1] * axy_yyz;
      const auto ayy_yyyz = ayyy_yyz + AB[1] * ayy_yyz;
      const auto axx_xxzz = axxx_xzz + AB[0] * axx_xzz;
      const auto axx_xyzz = axxx_yzz + AB[0] * axx_yzz;
      const auto axx_yyzz = axxy_yzz + AB[1] * axx_yzz;
      const auto axy_yyzz = axyy_yzz + AB[1] * axy_yzz;
      const auto ayy_yyzz = ayyy_yzz + AB[1] * ayy_yzz;
      const auto axx_xzzz = axxx_zzz + AB[0] * axx_zzz;
      const auto axx_yzzz = axxy_zzz + AB[1] * axx_zzz;
      const auto axy_yzzz = axyy_zzz + AB[1] * axy_zzz;
      const auto ayy_yzzz = ayyy_zzz + AB[1] * ayy_zzz;
      const auto axx_zzzz = axxz_zzz + AB[2] * axx_zzz;
      const auto axy_zzzz = axyz_zzz + AB[2] * axy_zzz;
      const auto ayy_zzzz = ayyz_zzz + AB[2] * ayy_zzz;
      const auto axz_zzzz = axzz_zzz + AB[2] * axz_zzz;
      const auto ayz_zzzz = ayzz_zzz + AB[2] * ayz_zzz;
      const auto azz_zzzz = azzz_zzz + AB[2] * azz_zzz;

      const auto a0_xxxxx = ax_xxxx + AB[0] * a0_xxxx;
      const auto a0_xxxxy = ax_xxxy + AB[0] * a0_xxxy;
      const auto a0_xxxyy = ax_xxyy + AB[0] * a0_xxyy;
      const auto a0_xxyyy = ax_xyyy + AB[0] * a0_xyyy;
      const auto a0_xyyyy = ax_yyyy + AB[0] * a0_yyyy;
      const auto a0_yyyyy = ay_yyyy + AB[1] * a0_yyyy;
      const auto a0_xxxxz = ax_xxxz + AB[0] * a0_xxxz;
      const auto a0_xxxyz = ax_xxyz + AB[0] * a0_xxyz;
      const auto a0_xxyyz = ax_xyyz + AB[0] * a0_xyyz;
      const auto a0_xyyyz = ax_yyyz + AB[0] * a0_yyyz;
      const auto a0_yyyyz = ay_yyyz + AB[1] * a0_yyyz;
      const auto a0_xxxzz = ax_xxzz + AB[0] * a0_xxzz;
      const auto a0_xxyzz = ax_xyzz + AB[0] * a0_xyzz;
      const auto a0_xyyzz = ax_yyzz + AB[0] * a0_yyzz;
      const auto a0_yyyzz = ay_yyzz + AB[1] * a0_yyzz;
      const auto a0_xxzzz = ax_xzzz + AB[0] * a0_xzzz;
      const auto a0_xyzzz = ax_yzzz + AB[0] * a0_yzzz;
      const auto a0_yyzzz = ay_yzzz + AB[1] * a0_yzzz;
      const auto a0_xzzzz = ax_zzzz + AB[0] * a0_zzzz;
      const auto a0_yzzzz = ay_zzzz + AB[1] * a0_zzzz;
      const auto a0_zzzzz = az_zzzz + AB[2] * a0_zzzz;

      const auto ax_xxxxx = axx_xxxx + AB[0] * ax_xxxx;
      const auto ax_xxxxy = axx_xxxy + AB[0] * ax_xxxy;
      const auto ax_xxxyy = axx_xxyy + AB[0] * ax_xxyy;
      const auto ax_xxyyy = axx_xyyy + AB[0] * ax_xyyy;
      const auto ax_xyyyy = axx_yyyy + AB[0] * ax_yyyy;
      const auto ax_yyyyy = axy_yyyy + AB[1] * ax_yyyy;
      const auto ay_yyyyy = ayy_yyyy + AB[1] * ay_yyyy;
      const auto ax_xxxxz = axx_xxxz + AB[0] * ax_xxxz;
      const auto ax_xxxyz = axx_xxyz + AB[0] * ax_xxyz;
      const auto ax_xxyyz = axx_xyyz + AB[0] * ax_xyyz;
      const auto ax_xyyyz = axx_yyyz + AB[0] * ax_yyyz;
      const auto ax_yyyyz = axy_yyyz + AB[1] * ax_yyyz;
      const auto ay_yyyyz = ayy_yyyz + AB[1] * ay_yyyz;
      const auto ax_xxxzz = axx_xxzz + AB[0] * ax_xxzz;
      const auto ax_xxyzz = axx_xyzz + AB[0] * ax_xyzz;
      const auto ax_xyyzz = axx_yyzz + AB[0] * ax_yyzz;
      const auto ax_yyyzz = axy_yyzz + AB[1] * ax_yyzz;
      const auto ay_yyyzz = ayy_yyzz + AB[1] * ay_yyzz;
      const auto ax_xxzzz = axx_xzzz + AB[0] * ax_xzzz;
      const auto ax_xyzzz = axx_yzzz + AB[0] * ax_yzzz;
      const auto ax_yyzzz = axy_yzzz + AB[1] * ax_yzzz;
      const auto ay_yyzzz = ayy_yzzz + AB[1] * ay_yzzz;
      const auto ax_xzzzz = axx_zzzz + AB[0] * ax_zzzz;
      const auto ax_yzzzz = axy_zzzz + AB[1] * ax_zzzz;
      const auto ay_yzzzz = ayy_zzzz + AB[1] * ay_zzzz;
      const auto ax_zzzzz = axz_zzzz + AB[2] * ax_zzzz;
      const auto ay_zzzzz = ayz_zzzz + AB[2] * ay_zzzz;
      const auto az_zzzzz = azz_zzzz + AB[2] * az_zzzz;

      current_out[84] = ax_xxxxx + AB[0] * a0_xxxxx; // a0_xxxxxx
      current_out[85] = ax_xxxxy + AB[0] * a0_xxxxy; // a0_xxxxxy
      current_out[86] = ax_xxxyy + AB[0] * a0_xxxyy; // a0_xxxxyy
      current_out[87] = ax_xxyyy + AB[0] * a0_xxyyy; // a0_xxxyyy
      current_out[88] = ax_xyyyy + AB[0] * a0_xyyyy; // a0_xxyyyy
      current_out[89] = ax_yyyyy + AB[0] * a0_yyyyy; // a0_xyyyyy
      current_out[90] = ay_yyyyy + AB[1] * a0_yyyyy; // a0_yyyyyy
      current_out[91] = ax_xxxxz + AB[0] * a0_xxxxz; // a0_xxxxxz
      current_out[92] = ax_xxxyz + AB[0] * a0_xxxyz; // a0_xxxxyz
      current_out[93] = ax_xxyyz + AB[0] * a0_xxyyz; // a0_xxxyyz
      current_out[94] = ax_xyyyz + AB[0] * a0_xyyyz; // a0_xxyyyz
      current_out[95] = ax_yyyyz + AB[0] * a0_yyyyz; // a0_xyyyyz
      current_out[96] = ay_yyyyz + AB[1] * a0_yyyyz; // a0_yyyyyz
      current_out[97] = ax_xxxzz + AB[0] * a0_xxxzz; // a0_xxxxzz
      current_out[98] = ax_xxyzz + AB[0] * a0_xxyzz; // a0_xxxyzz
      current_out[99] = ax_xyyzz + AB[0] * a0_xyyzz; // a0_xxyyzz
      current_out[100] = ax_yyyzz + AB[0] * a0_yyyzz; // a0_xyyyzz
      current_out[101] = ay_yyyzz + AB[1] * a0_yyyzz; // a0_yyyyzz
      current_out[102] = ax_xxzzz + AB[0] * a0_xxzzz; // a0_xxxzzz
      current_out[103] = ax_xyzzz + AB[0] * a0_xyzzz; // a0_xxyzzz
      current_out[104] = ax_yyzzz + AB[0] * a0_yyzzz; // a0_xyyzzz
      current_out[105] = ay_yyzzz + AB[1] * a0_yyzzz; // a0_yyyzzz
      current_out[106] = ax_xzzzz + AB[0] * a0_xzzzz; // a0_xxzzzz
      current_out[107] = ax_yzzzz + AB[0] * a0_yzzzz; // a0_xyzzzz
      current_out[108] = ay_yzzzz + AB[1] * a0_yzzzz; // a0_yyzzzz
      current_out[109] = ax_zzzzz + AB[0] * a0_zzzzz; // a0_xzzzzz
      current_out[110] = ay_zzzzz + AB[1] * a0_zzzzz; // a0_yzzzzz
      current_out[111] = az_zzzzz + AB[2] * a0_zzzzz; // a0_zzzzzz

    }
   {
     //current index a: xxxyyyy
      const auto a0_0 = current_data[4];
      const auto ax_0 = current_data[40];
      const auto ay_0 = current_data[41];
      const auto az_0 = current_data[49];
      const auto axx_0 = current_data[85];
      const auto axy_0 = current_data[86];
      const auto ayy_0 = current_data[87];
      const auto axz_0 = current_data[95];
      const auto ayz_0 = current_data[96];
      const auto azz_0 = current_data[104];
      const auto axxx_0 = current_data[140];
      const auto axxy_0 = current_data[141];
      const auto axyy_0 = current_data[142];
      const auto ayyy_0 = current_data[143];
      const auto axxz_0 = current_data[151];
      const auto axyz_0 = current_data[152];
      const auto ayyz_0 = current_data[153];
      const auto axzz_0 = current_data[161];
      const auto ayzz_0 = current_data[162];
      const auto azzz_0 = current_data[170];
      const auto axxxx_0 = current_data[206];
      const auto axxxy_0 = current_data[207];
      const auto axxyy_0 = current_data[208];
      const auto axyyy_0 = current_data[209];
      const auto ayyyy_0 = current_data[210];
      const auto axxxz_0 = current_data[218];
      const auto axxyz_0 = current_data[219];
      const auto axyyz_0 = current_data[220];
      const auto ayyyz_0 = current_data[221];
      const auto axxzz_0 = current_data[229];
      const auto axyzz_0 = current_data[230];
      const auto ayyzz_0 = current_data[231];
      const auto axzzz_0 = current_data[239];
      const auto ayzzz_0 = current_data[240];
      const auto azzzz_0 = current_data[248];
      const auto axxxxx_0 = current_data[284];
      const auto axxxxy_0 = current_data[285];
      const auto axxxyy_0 = current_data[286];
      const auto axxyyy_0 = current_data[287];
      const auto axyyyy_0 = current_data[288];
      const auto ayyyyy_0 = current_data[289];
      const auto axxxxz_0 = current_data[297];
      const auto axxxyz_0 = current_data[298];
      const auto axxyyz_0 = current_data[299];
      const auto axyyyz_0 = current_data[300];
      const auto ayyyyz_0 = current_data[301];
      const auto axxxzz_0 = current_data[309];
      const auto axxyzz_0 = current_data[310];
      const auto axyyzz_0 = current_data[311];
      const auto ayyyzz_0 = current_data[312];
      const auto axxzzz_0 = current_data[320];
      const auto axyzzz_0 = current_data[321];
      const auto ayyzzz_0 = current_data[322];
      const auto axzzzz_0 = current_data[330];
      const auto ayzzzz_0 = current_data[331];
      const auto azzzzz_0 = current_data[339];
      const auto axxxxxx_0 = current_data[375];
      const auto axxxxxy_0 = current_data[376];
      const auto axxxxyy_0 = current_data[377];
      const auto axxxyyy_0 = current_data[378];
      const auto axxyyyy_0 = current_data[379];
      const auto axyyyyy_0 = current_data[380];
      const auto ayyyyyy_0 = current_data[381];
      const auto axxxxxz_0 = current_data[389];
      const auto axxxxyz_0 = current_data[390];
      const auto axxxyyz_0 = current_data[391];
      const auto axxyyyz_0 = current_data[392];
      const auto axyyyyz_0 = current_data[393];
      const auto ayyyyyz_0 = current_data[394];
      const auto axxxxzz_0 = current_data[402];
      const auto axxxyzz_0 = current_data[403];
      const auto axxyyzz_0 = current_data[404];
      const auto axyyyzz_0 = current_data[405];
      const auto ayyyyzz_0 = current_data[406];
      const auto axxxzzz_0 = current_data[414];
      const auto axxyzzz_0 = current_data[415];
      const auto axyyzzz_0 = current_data[416];
      const auto ayyyzzz_0 = current_data[417];
      const auto axxzzzz_0 = current_data[425];
      const auto axyzzzz_0 = current_data[426];
      const auto ayyzzzz_0 = current_data[427];
      const auto axzzzzz_0 = current_data[435];
      const auto ayzzzzz_0 = current_data[436];
      const auto azzzzzz_0 = current_data[444];

      const auto a0_x = ax_0 + AB[0] * a0_0;
      const auto a0_y = ay_0 + AB[1] * a0_0;
      const auto a0_z = az_0 + AB[2] * a0_0;

      const auto ax_x = axx_0 + AB[0] * ax_0;
      const auto ax_y = axy_0 + AB[1] * ax_0;
      const auto ay_y = ayy_0 + AB[1] * ay_0;
      const auto ax_z = axz_0 + AB[2] * ax_0;
      const auto ay_z = ayz_0 + AB[2] * ay_0;
      const auto az_z = azz_0 + AB[2] * az_0;

      const auto axx_x = axxx_0 + AB[0] * axx_0;
      const auto axx_y = axxy_0 + AB[1] * axx_0;
      const auto axy_y = axyy_0 + AB[1] * axy_0;
      const auto ayy_y = ayyy_0 + AB[1] * ayy_0;
      const auto axx_z = axxz_0 + AB[2] * axx_0;
      const auto axy_z = axyz_0 + AB[2] * axy_0;
      const auto ayy_z = ayyz_0 + AB[2] * ayy_0;
      const auto axz_z = axzz_0 + AB[2] * axz_0;
      const auto ayz_z = ayzz_0 + AB[2] * ayz_0;
      const auto azz_z = azzz_0 + AB[2] * azz_0;

      const auto axxx_x = axxxx_0 + AB[0] * axxx_0;
      const auto axxx_y = axxxy_0 + AB[1] * axxx_0;
      const auto axxy_y = axxyy_0 + AB[1] * axxy_0;
      const auto axyy_y = axyyy_0 + AB[1] * axyy_0;
      const auto ayyy_y = ayyyy_0 + AB[1] * ayyy_0;
      const auto axxx_z = axxxz_0 + AB[2] * axxx_0;
      const auto axxy_z = axxyz_0 + AB[2] * axxy_0;
      const auto axyy_z = axyyz_0 + AB[2] * axyy_0;
      const auto ayyy_z = ayyyz_0 + AB[2] * ayyy_0;
      const auto axxz_z = axxzz_0 + AB[2] * axxz_0;
      const auto axyz_z = axyzz_0 + AB[2] * axyz_0;
      const auto ayyz_z = ayyzz_0 + AB[2] * ayyz_0;
      const auto axzz_z = axzzz_0 + AB[2] * axzz_0;
      const auto ayzz_z = ayzzz_0 + AB[2] * ayzz_0;
      const auto azzz_z = azzzz_0 + AB[2] * azzz_0;

      const auto axxxx_x = axxxxx_0 + AB[0] * axxxx_0;
      const auto axxxx_y = axxxxy_0 + AB[1] * axxxx_0;
      const auto axxxy_y = axxxyy_0 + AB[1] * axxxy_0;
      const auto axxyy_y = axxyyy_0 + AB[1] * axxyy_0;
      const auto axyyy_y = axyyyy_0 + AB[1] * axyyy_0;
      const auto ayyyy_y = ayyyyy_0 + AB[1] * ayyyy_0;
      const auto axxxx_z = axxxxz_0 + AB[2] * axxxx_0;
      const auto axxxy_z = axxxyz_0 + AB[2] * axxxy_0;
      const auto axxyy_z = axxyyz_0 + AB[2] * axxyy_0;
      const auto axyyy_z = axyyyz_0 + AB[2] * axyyy_0;
      const auto ayyyy_z = ayyyyz_0 + AB[2] * ayyyy_0;
      const auto axxxz_z = axxxzz_0 + AB[2] * axxxz_0;
      const auto axxyz_z = axxyzz_0 + AB[2] * axxyz_0;
      const auto axyyz_z = axyyzz_0 + AB[2] * axyyz_0;
      const auto ayyyz_z = ayyyzz_0 + AB[2] * ayyyz_0;
      const auto axxzz_z = axxzzz_0 + AB[2] * axxzz_0;
      const auto axyzz_z = axyzzz_0 + AB[2] * axyzz_0;
      const auto ayyzz_z = ayyzzz_0 + AB[2] * ayyzz_0;
      const auto axzzz_z = axzzzz_0 + AB[2] * axzzz_0;
      const auto ayzzz_z = ayzzzz_0 + AB[2] * ayzzz_0;
      const auto azzzz_z = azzzzz_0 + AB[2] * azzzz_0;

      const auto axxxxx_x = axxxxxx_0 + AB[0] * axxxxx_0;
      const auto axxxxx_y = axxxxxy_0 + AB[1] * axxxxx_0;
      const auto axxxxy_y = axxxxyy_0 + AB[1] * axxxxy_0;
      const auto axxxyy_y = axxxyyy_0 + AB[1] * axxxyy_0;
      const auto axxyyy_y = axxyyyy_0 + AB[1] * axxyyy_0;
      const auto axyyyy_y = axyyyyy_0 + AB[1] * axyyyy_0;
      const auto ayyyyy_y = ayyyyyy_0 + AB[1] * ayyyyy_0;
      const auto axxxxx_z = axxxxxz_0 + AB[2] * axxxxx_0;
      const auto axxxxy_z = axxxxyz_0 + AB[2] * axxxxy_0;
      const auto axxxyy_z = axxxyyz_0 + AB[2] * axxxyy_0;
      const auto axxyyy_z = axxyyyz_0 + AB[2] * axxyyy_0;
      const auto axyyyy_z = axyyyyz_0 + AB[2] * axyyyy_0;
      const auto ayyyyy_z = ayyyyyz_0 + AB[2] * ayyyyy_0;
      const auto axxxxz_z = axxxxzz_0 + AB[2] * axxxxz_0;
      const auto axxxyz_z = axxxyzz_0 + AB[2] * axxxyz_0;
      const auto axxyyz_z = axxyyzz_0 + AB[2] * axxyyz_0;
      const auto axyyyz_z = axyyyzz_0 + AB[2] * axyyyz_0;
      const auto ayyyyz_z = ayyyyzz_0 + AB[2] * ayyyyz_0;
      const auto axxxzz_z = axxxzzz_0 + AB[2] * axxxzz_0;
      const auto axxyzz_z = axxyzzz_0 + AB[2] * axxyzz_0;
      const auto axyyzz_z = axyyzzz_0 + AB[2] * axyyzz_0;
      const auto ayyyzz_z = ayyyzzz_0 + AB[2] * ayyyzz_0;
      const auto axxzzz_z = axxzzzz_0 + AB[2] * axxzzz_0;
      const auto axyzzz_z = axyzzzz_0 + AB[2] * axyzzz_0;
      const auto ayyzzz_z = ayyzzzz_0 + AB[2] * ayyzzz_0;
      const auto axzzzz_z = axzzzzz_0 + AB[2] * axzzzz_0;
      const auto ayzzzz_z = ayzzzzz_0 + AB[2] * ayzzzz_0;
      const auto azzzzz_z = azzzzzz_0 + AB[2] * azzzzz_0;

      const auto a0_xx = ax_x + AB[0] * a0_x;
      const auto a0_xy = ax_y + AB[0] * a0_y;
      const auto a0_yy = ay_y + AB[1] * a0_y;
      const auto a0_xz = ax_z + AB[0] * a0_z;
      const auto a0_yz = ay_z + AB[1] * a0_z;
      const auto a0_zz = az_z + AB[2] * a0_z;

      const auto ax_xx = axx_x + AB[0] * ax_x;
      const auto ax_xy = axx_y + AB[0] * ax_y;
      const auto ax_yy = axy_y + AB[1] * ax_y;
      const auto ay_yy = ayy_y + AB[1] * ay_y;
      const auto ax_xz = axx_z + AB[0] * ax_z;
      const auto ax_yz = axy_z + AB[1] * ax_z;
      const auto ay_yz = ayy_z + AB[1] * ay_z;
      const auto ax_zz = axz_z + AB[2] * ax_z;
      const auto ay_zz = ayz_z + AB[2] * ay_z;
      const auto az_zz = azz_z + AB[2] * az_z;

      const auto axx_xx = axxx_x + AB[0] * axx_x;
      const auto axx_xy = axxx_y + AB[0] * axx_y;
      const auto axx_yy = axxy_y + AB[1] * axx_y;
      const auto axy_yy = axyy_y + AB[1] * axy_y;
      const auto ayy_yy = ayyy_y + AB[1] * ayy_y;
      const auto axx_xz = axxx_z + AB[0] * axx_z;
      const auto axx_yz = axxy_z + AB[1] * axx_z;
      const auto axy_yz = axyy_z + AB[1] * axy_z;
      const auto ayy_yz = ayyy_z + AB[1] * ayy_z;
      const auto axx_zz = axxz_z + AB[2] * axx_z;
      const auto axy_zz = axyz_z + AB[2] * axy_z;
      const auto ayy_zz = ayyz_z + AB[2] * ayy_z;
      const auto axz_zz = axzz_z + AB[2] * axz_z;
      const auto ayz_zz = ayzz_z + AB[2] * ayz_z;
      const auto azz_zz = azzz_z + AB[2] * azz_z;

      const auto axxx_xx = axxxx_x + AB[0] * axxx_x;
      const auto axxx_xy = axxxx_y + AB[0] * axxx_y;
      const auto axxx_yy = axxxy_y + AB[1] * axxx_y;
      const auto axxy_yy = axxyy_y + AB[1] * axxy_y;
      const auto axyy_yy = axyyy_y + AB[1] * axyy_y;
      const auto ayyy_yy = ayyyy_y + AB[1] * ayyy_y;
      const auto axxx_xz = axxxx_z + AB[0] * axxx_z;
      const auto axxx_yz = axxxy_z + AB[1] * axxx_z;
      const auto axxy_yz = axxyy_z + AB[1] * axxy_z;
      const auto axyy_yz = axyyy_z + AB[1] * axyy_z;
      const auto ayyy_yz = ayyyy_z + AB[1] * ayyy_z;
      const auto axxx_zz = axxxz_z + AB[2] * axxx_z;
      const auto axxy_zz = axxyz_z + AB[2] * axxy_z;
      const auto axyy_zz = axyyz_z + AB[2] * axyy_z;
      const auto ayyy_zz = ayyyz_z + AB[2] * ayyy_z;
      const auto axxz_zz = axxzz_z + AB[2] * axxz_z;
      const auto axyz_zz = axyzz_z + AB[2] * axyz_z;
      const auto ayyz_zz = ayyzz_z + AB[2] * ayyz_z;
      const auto axzz_zz = axzzz_z + AB[2] * axzz_z;
      const auto ayzz_zz = ayzzz_z + AB[2] * ayzz_z;
      const auto azzz_zz = azzzz_z + AB[2] * azzz_z;

      const auto axxxx_xx = axxxxx_x + AB[0] * axxxx_x;
      const auto axxxx_xy = axxxxx_y + AB[0] * axxxx_y;
      const auto axxxx_yy = axxxxy_y + AB[1] * axxxx_y;
      const auto axxxy_yy = axxxyy_y + AB[1] * axxxy_y;
      const auto axxyy_yy = axxyyy_y + AB[1] * axxyy_y;
      const auto axyyy_yy = axyyyy_y + AB[1] * axyyy_y;
      const auto ayyyy_yy = ayyyyy_y + AB[1] * ayyyy_y;
      const auto axxxx_xz = axxxxx_z + AB[0] * axxxx_z;
      const auto axxxx_yz = axxxxy_z + AB[1] * axxxx_z;
      const auto axxxy_yz = axxxyy_z + AB[1] * axxxy_z;
      const auto axxyy_yz = axxyyy_z + AB[1] * axxyy_z;
      const auto axyyy_yz = axyyyy_z + AB[1] * axyyy_z;
      const auto ayyyy_yz = ayyyyy_z + AB[1] * ayyyy_z;
      const auto axxxx_zz = axxxxz_z + AB[2] * axxxx_z;
      const auto axxxy_zz = axxxyz_z + AB[2] * axxxy_z;
      const auto axxyy_zz = axxyyz_z + AB[2] * axxyy_z;
      const auto axyyy_zz = axyyyz_z + AB[2] * axyyy_z;
      const auto ayyyy_zz = ayyyyz_z + AB[2] * ayyyy_z;
      const auto axxxz_zz = axxxzz_z + AB[2] * axxxz_z;
      const auto axxyz_zz = axxyzz_z + AB[2] * axxyz_z;
      const auto axyyz_zz = axyyzz_z + AB[2] * axyyz_z;
      const auto ayyyz_zz = ayyyzz_z + AB[2] * ayyyz_z;
      const auto axxzz_zz = axxzzz_z + AB[2] * axxzz_z;
      const auto axyzz_zz = axyzzz_z + AB[2] * axyzz_z;
      const auto ayyzz_zz = ayyzzz_z + AB[2] * ayyzz_z;
      const auto axzzz_zz = axzzzz_z + AB[2] * axzzz_z;
      const auto ayzzz_zz = ayzzzz_z + AB[2] * ayzzz_z;
      const auto azzzz_zz = azzzzz_z + AB[2] * azzzz_z;

      const auto a0_xxx = ax_xx + AB[0] * a0_xx;
      const auto a0_xxy = ax_xy + AB[0] * a0_xy;
      const auto a0_xyy = ax_yy + AB[0] * a0_yy;
      const auto a0_yyy = ay_yy + AB[1] * a0_yy;
      const auto a0_xxz = ax_xz + AB[0] * a0_xz;
      const auto a0_xyz = ax_yz + AB[0] * a0_yz;
      const auto a0_yyz = ay_yz + AB[1] * a0_yz;
      const auto a0_xzz = ax_zz + AB[0] * a0_zz;
      const auto a0_yzz = ay_zz + AB[1] * a0_zz;
      const auto a0_zzz = az_zz + AB[2] * a0_zz;

      const auto ax_xxx = axx_xx + AB[0] * ax_xx;
      const auto ax_xxy = axx_xy + AB[0] * ax_xy;
      const auto ax_xyy = axx_yy + AB[0] * ax_yy;
      const auto ax_yyy = axy_yy + AB[1] * ax_yy;
      const auto ay_yyy = ayy_yy + AB[1] * ay_yy;
      const auto ax_xxz = axx_xz + AB[0] * ax_xz;
      const auto ax_xyz = axx_yz + AB[0] * ax_yz;
      const auto ax_yyz = axy_yz + AB[1] * ax_yz;
      const auto ay_yyz = ayy_yz + AB[1] * ay_yz;
      const auto ax_xzz = axx_zz + AB[0] * ax_zz;
      const auto ax_yzz = axy_zz + AB[1] * ax_zz;
      const auto ay_yzz = ayy_zz + AB[1] * ay_zz;
      const auto ax_zzz = axz_zz + AB[2] * ax_zz;
      const auto ay_zzz = ayz_zz + AB[2] * ay_zz;
      const auto az_zzz = azz_zz + AB[2] * az_zz;

      const auto axx_xxx = axxx_xx + AB[0] * axx_xx;
      const auto axx_xxy = axxx_xy + AB[0] * axx_xy;
      const auto axx_xyy = axxx_yy + AB[0] * axx_yy;
      const auto axx_yyy = axxy_yy + AB[1] * axx_yy;
      const auto axy_yyy = axyy_yy + AB[1] * axy_yy;
      const auto ayy_yyy = ayyy_yy + AB[1] * ayy_yy;
      const auto axx_xxz = axxx_xz + AB[0] * axx_xz;
      const auto axx_xyz = axxx_yz + AB[0] * axx_yz;
      const auto axx_yyz = axxy_yz + AB[1] * axx_yz;
      const auto axy_yyz = axyy_yz + AB[1] * axy_yz;
      const auto ayy_yyz = ayyy_yz + AB[1] * ayy_yz;
      const auto axx_xzz = axxx_zz + AB[0] * axx_zz;
      const auto axx_yzz = axxy_zz + AB[1] * axx_zz;
      const auto axy_yzz = axyy_zz + AB[1] * axy_zz;
      const auto ayy_yzz = ayyy_zz + AB[1] * ayy_zz;
      const auto axx_zzz = axxz_zz + AB[2] * axx_zz;
      const auto axy_zzz = axyz_zz + AB[2] * axy_zz;
      const auto ayy_zzz = ayyz_zz + AB[2] * ayy_zz;
      const auto axz_zzz = axzz_zz + AB[2] * axz_zz;
      const auto ayz_zzz = ayzz_zz + AB[2] * ayz_zz;
      const auto azz_zzz = azzz_zz + AB[2] * azz_zz;

      const auto axxx_xxx = axxxx_xx + AB[0] * axxx_xx;
      const auto axxx_xxy = axxxx_xy + AB[0] * axxx_xy;
      const auto axxx_xyy = axxxx_yy + AB[0] * axxx_yy;
      const auto axxx_yyy = axxxy_yy + AB[1] * axxx_yy;
      const auto axxy_yyy = axxyy_yy + AB[1] * axxy_yy;
      const auto axyy_yyy = axyyy_yy + AB[1] * axyy_yy;
      co