
#ifndef DNDLISTBOX_H
#define DNDLISTBOX_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <klistbox.h>
#include "baghirasidebariface.h"

class DCOPClient;
class QDragEnterEvent;
class QDragMoveEvent;
class QDragLeaveEvent;
class QDropEvent;
class QKeyEvent;
class QPoint;
class KPopupMenu;
class LinkConfig;
class ListBoxLink;
class ListBoxDevice;
class QResizeEvent;

class ResizingLinkBox : public KListBox
{
    Q_OBJECT
    
public:
   ResizingLinkBox( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );
   ~ResizingLinkBox(){};
   void insertItem( const QListBoxItem *, int index=-1 );
   void insertItem( const QListBoxItem *lbi, const QListBoxItem *after );

   void insertItem( const QString &text, int index=-1 ){ insertItem( new QListBoxText(text), index ); }
   void insertItem( const QPixmap &pixmap, int index=-1 ){ insertItem( new QListBoxPixmap(pixmap), index ); }
   void insertItem( const QPixmap &pixmap, const QString &text, int index=-1 ){ insertItem( new QListBoxPixmap(pixmap, text), index ); }
   
   void removeItem( int index );
protected:
   void mousePressEvent ( QMouseEvent * );
   void mouseReleaseEvent ( QMouseEvent * );
   void contentsWheelEvent ( QWheelEvent * );
signals:
   void itemNumberChanged(bool);
   void scrolled(int,int);
};

class MediaListBox : public ResizingLinkBox, virtual public BaghiraSidebarIface
{
   Q_OBJECT
public:
   MediaListBox( QWidget * parent = 0, uint size = 48, const char * name = 0, WFlags f = 0 );
   ~MediaListBox(){};
   ListBoxDevice *createListBoxDevice(QStringList & deviceProperties, uint n = 0);
   void mediumAdded(const QString &name);
   void mediumRemoved(const QString &name);
   void mediumChanged(const QString &name);
   int index (const QString & name );
protected:
   void mousePressEvent ( QMouseEvent * );
   void resizeEvent ( QResizeEvent * );
private:
   KPopupMenu *floppyPopup;
   DCOPClient *client;
   ListBoxDevice *currentFloppy;
   uint size_;
private slots:
   void kfloppy();
};

class DnDListBox : public ResizingLinkBox
{
    Q_OBJECT
    
public:
     DnDListBox( QWidget * parent = 0, uint size = 48, const char * name = 0, WFlags f = 0 );

    /** destructor */
    ~DnDListBox();
   void poof(ListBoxLink *link);

protected:
   void mousePressEvent ( QMouseEvent * );
   void mouseReleaseEvent ( QMouseEvent * );
   void mouseMoveEvent ( QMouseEvent * e );
   void dragEnterEvent ( QDragEnterEvent * );
//    void dragMoveEvent ( QDragMoveEvent * );
//    void dragLeaveEvent ( QDragLeaveEvent * );
   void dropEvent ( QDropEvent * );
   void startDrag();
private:
   ListBoxLink *currentItem; //TODO: unshadow int KListBox::currentItem()
   LinkConfig *dialog;
   uint size_;
   bool dragging_;
   void pasteURL(int mode, QListBoxItem *after = 0);
   bool _draggedMe;
   int _poofIndex;
   QPixmap *_poofPix;
   QPixmap *_poofAnimPix;
   QWidget *_poof;
private slots:
   void configureLink(QListBoxItem *);
   void updateLink();
   void runPoof();
};

#endif
