# -*- coding: latin-1 -*-
# Balazar
# Copyright (C) 2003-2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, os.path
import soya, tofu
import balazar, balazar.globdef
from balazar.level_gen import *
from balazar.character import _P, _V, _P2, _V2

import PIL, PIL.Image, PIL.ImageDraw

LAND        = 196, 196, 196, 128
LAND        = 255, 255, 255, 196
VOID        =   0,   0,   0,   0
BRIDGE      = 255, 255, 255, 255
ALTAR       = 255,   0,   0, 255
GRID        = [
             ( 64,  64,  64, 255),
             (  0,   0, 255, 255),
             (  0, 255,   0, 255),
             (255,   0,   0, 255),
  ]
TRANSPARENT =   0,   0,   0,   0

DOWN = soya.Vector(None, 0.0, -1.0, 0.0)

MAP_SIZE = 32

GOALS = [(4, -1)]

def to_map(p): return int(round((p.x + BRIDGE_DEMI_DIM) / LEVEL_DIM * MAP_SIZE)), int(round((p.z + BRIDGE_DEMI_DIM) / LEVEL_DIM * MAP_SIZE))

def power2(x):
  if x <=    32: return   32
  if x <=    64: return   64
  if x <=   128: return  128
  if x <=   256: return  256
  if x <=   512: return  512
  if x <=  1024: return 1024

def make_map(country):
  image = make_map_image(country.X1, country.Z1, country.X2, country.Z2)
  image.save(os.path.join(soya.path[0], "images", "item_map_%s.png" % country.name))
  
  
def make_map_image(X1, Z1, X2, Z2):
  X2 += 1
  Z2 += 1
  image = PIL.Image.new("RGBA", (power2((X2 - X1) * 32), power2((Z2 - Z1) * 32)), TRANSPARENT)
  
  for X in range(X1, X2):
    for Z in range(Z1, Z2):
      print "XZ", X, Z, Level.get_by_pos(X, Z)
      level_image = map_for_level(Level.get_by_pos(X, Z))
      image.paste(level_image, ((X - X1) * 32, (Z - Z1) * 32))
      
  return image
      
def map_for_level(level):
  image = PIL.Image.new("RGBA", (32, 32), TRANSPARENT)
  draw = PIL.ImageDraw.Draw(image)
  draw.rectangle((0, 0, 32, 32), VOID)
  
  bridge_2_pos = {}
  if hasattr(level, "bridge_0_1"): draw.rectangle(( 0, 13,  4, 19), BRIDGE); bridge_2_pos[level.bridge_0_1] = [ 3, 12,  3, 21]
  if hasattr(level, "bridge_2_1"): draw.rectangle((27, 13, 31, 19), BRIDGE); bridge_2_pos[level.bridge_2_1] = [28, 12, 28, 21]
  if hasattr(level, "bridge_1_0"): draw.rectangle((13,  0, 19,  4), BRIDGE); bridge_2_pos[level.bridge_1_0] = [12,  3, 20,  3]
  if hasattr(level, "bridge_1_2"): draw.rectangle((13, 27, 19, 31), BRIDGE); bridge_2_pos[level.bridge_1_2] = [12, 28, 20, 28]
  
  draw.rectangle((4, 4, 27, 27), LAND)
  
  if (level.X, level.Z) in GOALS:
    draw.line((16,  6, 27, 17), "red")
    draw.line((16, 16, 27,  5), "red")

  for i in level.mobiles:
    if   isinstance(i, LifeAltar):
      pass
      #draw.rectangle((x, z, x + 1, z + 1), color)
    elif isinstance(i, Grid):
      for bridge in bridge_2_pos.keys():
        p = i % level
        a, b = bridge.get_box()
        print (a.x < i.x < b.x), i.y, b.y, (a.z < i.z < b.z)
        
        if (a.x < i.x < b.x) and (b.y - 8.0 < i.y < b.y + 8.0) and (a.z < i.z < b.z):
          x1, z1, x2, z2 = bridge_2_pos[bridge]
          draw.line((x1, z1, x2, z2), GRID[i.typ])
          bridge_2_pos[bridge] = x1 + bridge.dX, z1 + bridge.dZ, x2 + bridge.dX, z2 + bridge.dZ
          x1, z1, x2, z2 = bridge_2_pos[bridge]
          draw.line((x1, z1, x2, z2), GRID[i.typ])
          bridge_2_pos[bridge] = x1 + bridge.dX, z1 + bridge.dZ, x2 + bridge.dX, z2 + bridge.dZ
          break
        
  return image

def fullmap_for_level(level):
  image = PIL.Image.new("RGBA", (32, 32), TRANSPARENT)
  draw = PIL.ImageDraw.Draw(image)
  _P.__init__(level, 0.0, 1000.0, 0.0)
  for x in range(32):
    _P.x = (float(x) / 32 * LEVEL_DIM) - BRIDGE_DEMI_DIM
    for z in range(32):
      _P.z = (float(z) / 32 * LEVEL_DIM) - BRIDGE_DEMI_DIM
      
      if level.raypick(_P, DOWN, -1, 1, 1, _P2, _V2):
        color  = LAND
        ground = _P2.parent
        while ground:
          if hasattr(ground, "map_color"):
            color = ground.map_color
            break
          ground = ground.parent
          
      else: color  = VOID
      
      image.putpixel((x, z), color)
      
  for i in level.recursive():
    if   isinstance(i, LifeAltar): x, z = to_map(i); draw.rectangle((x, z, x + 1, z + 1), color)
    elif isinstance(i, Grid):
      draw.line(to_map(soya.Point(i, -10.0, 0.0, 0.0) % level) + to_map(soya.Point(i, 10.0, 0.0, 0.0) % level), GRID[i.typ])
      
  #if hasattr(level, "bridge_0_1"): draw.rectangle(( 0, 15,  4, 17), BRIDGE)
  #if hasattr(level, "bridge_2_1"): draw.rectangle((27, 15, 31, 17), BRIDGE)
  #if hasattr(level, "bridge_1_0"): draw.rectangle((15,  0, 17,  4), BRIDGE)
  #if hasattr(level, "bridge_1_2"): draw.rectangle((15, 27, 17, 31), BRIDGE)
  
  return image


if __name__ == "__main__":
  import balazar, balazar.globdef
  #image = map_for_level(Level.get_by_pos(1, 0))
  #image = make_map_image(1, -1, 4, 1)
  #image.show(command = "display")
  make_map(COUNTRIES["foret_pompon"])
  make_map(COUNTRIES["village"])
  
  
