/***************************************************************************
 *   Copyright (C) 2005 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/ailistmodel.h"
#include "boost/filesystem/operations.hpp"
#include "boost/filesystem/path.hpp"

using namespace Balder;

AIListModel::AIListModel(): numScripts(0)
{
	FindScripts();
}
AIListModel::~AIListModel()
{}

void AIListModel::FindScripts()
{
        // always show Human option as it disables any ai scripting so that a user may play.
	scriptnames.push_back("Human");
        ++numScripts;
        
        boost::filesystem::path script_path( "scripts/" );
	boost::filesystem::directory_iterator end_iter;
        for ( boost::filesystem::directory_iterator dir_itr( script_path ); dir_itr != end_iter; ++dir_itr ) {
                if ( !boost::filesystem::is_directory( *dir_itr ) ) {
                        // lets see if this file really is a script
                        const std::string script_ext = ".py";
                        std::string file_name = dir_itr->leaf();

                        int extpos = file_name.rfind(script_ext);
                        std::string file_ext = file_name;
                        file_ext.erase(0, extpos);

                        // if this file really is a AI script then display it in the selection list.
                        if (file_ext == script_ext) {
                                file_name.erase(extpos, file_name.size());
                                scriptnames.push_back(file_name);
                                ++numScripts;
                        }
                }
        }
}


/*!
    \fn Balder::AIListModel::FindScriptIndex(std::string scriptname)
 */
int Balder::AIListModel::FindScriptIndex(std::string scriptname)
{
    for (int i = 0; i < numScripts; ++i) {
    	if (!scriptname.compare(scriptnames[i])) return i;
    }
    return 0;
}
