<?php

#require_once('Properties.php');

class Editor {

var $footer;
var $header;
var $base;
var $prop;

function Editor(&$prop) {
	$this->prop = &$prop;
	$this->base = dirname(__FILE__) . '/Editor';
	$this->template = $this->base . '/template.php';
}

function handleRequest(&$page) {
	$this->page = &$page;
	if ($this->isRepeat()) {
		$this->error('That action as already been performed');
	}
	else {
		$action = get('eaction','edit');
		while(true) {
			$handler = 'do' . $action;
			if (method_exists($this,$handler)) {
				$action = $this->$handler($page);
				if ($action == 'edit')
					continue;
				else
					return $action;
			}
			else {
				die("editor action '$action' unknown");
				return '';
			}
		}
	}
	return '';
}

function doedit(&$page) {
	if (!isset($_SESSION['view_in_same_window']))
		$_SESSION['view_in_same_window'] = true;
	
	if ($page->path == '/.clipboard' || $page->path == '/.trash')
		return $this->doinfo($page);

	$page->fetch();
	if (isset($page->content))
		$this->text = htmlspecialchars($page->content);
	else	
		$this->text = '';
	$this->display('edit');
}

function doguide(&$page) {
	$this->display('guide', true);
}


function dosaveview(&$page) {
	$samewindow = get('view_in_same_window',false);
	$_SESSION['view_in_same_window'] = $samewindow;

	#debug($_SESSION);	
	$page->lock();
	$data = &getraw('data');
	$page->setContent($data);
	$page->commit();
	$page->unlock();
	if ($samewindow)
		return 'view';
	else
		return 'edit';
	
}

function dosaveedit(&$page) {
	$samewindow = get('view_in_same_window',false);
	$_SESSION['view_in_same_window'] = $samewindow;

	$page->lock();
	$data = &getraw('data');
	$page->setContent($data);
	$page->commit();
	$page->unlock();
	return 'edit';
}
 
function docancel(&$page) {
	return 'view';
}

function doprops(&$page) {
	$this->display('props');
	return '';
}

function doperms(&$page) {
	$this->display('perms');
	return '';
}

function doinfo(&$page) {
	$savevars = array('name','title','subject','type','dir','description','keywords');
	$name = '';
	if (get('clip'))
		return $this->doclip($page);
		
	$move = get('move');	
	$save = get('save');
	$attachcmd = get('attachcmd');
	
	if ($move) {
		$child = $page->child(get('child'));
		$order = $child->get('order');
		if ($move == 'up')
			$order--;
		if ($move == 'down')
			$order++;
		$child->set('order',$order);
	}
	elseif($save) {
		$name1 = $page->name;
		
		// get a clean copy of the old values, before we start
		// setting them. why? because setting the value of one property
		// can set the value of other properties automatically. we don't
		// want a moving target.
		$oldvalues = array();
		foreach ($_REQUEST as $prop => $value) {
			$oldvalues[$prop] = $page->get($prop);
		}
		
		foreach ($_REQUEST as $prop => $value) {
			$value = get($prop);
			if (in_array($prop, $savevars)) {
			    $oldvalue = $oldvalues[$prop];
				if ($value == 'false' && $oldvalue == false) {
					// do nothing
				}
				elseif ($value != $oldvalue) {
					$page->set($prop,$value);
				}
			}
		}
		$page->commit();
		if ($page->ok && $name1 != $page->name) {
			require_once('HttpUtil.php');
			http::redirect($page->absolutepath . "/?action=edit&eaction=info");
			return;
		}
		if (!$page->ok) {
			$this->error($page->error());
		}
	}
	elseif($attachcmd == 'upload') {
		$page->attach($_FILES['userfile']);
		if (!$page->ok) {
			$this->error($page->error());
		}
	}
	elseif($attachcmd == 'delete') {
		$checked = get('checked');
		if ($checked) {
			foreach($checked as $filename => $on) {
				$page->removeAttachment($filename);
			}
			if (!$page->ok)	$this->error($page->error());
		}
		else {
			$this->error("To delete an attachment, at least one file must be checked.");
		}
	}
	
	$this->display('info');
	return '';
}

// page clipboard functions
function doclip(&$page) {
	$action = get('clip');
	$checked = get('checked');
	$ps = &$page->ps; // page store
	
	$ps->mkdirectory('.trash');
	$ps->mkdirectory('.clipboard');
	
	if ($action == 'paste') {
		$clipboard = $ps->getPage('/.clipboard');
		$children = $clipboard->children();
		if (count($children)) {
			foreach($children as $child) {
				$child->setParent($page->path);
				if (!$child->ok)
					$this->error($child->error());
			}
		}
		else
			$this->error("To paste a page, at least one page must be in the clipboard.");

	}
	elseif ($action == 'cut') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->move("/.clipboard/" . basename($child->path));
				if (!$child->ok)
					$this->error($child->error());
			}
		}
		else
			$this->error("To cut a page, at least one page must be checked.");
	}
	elseif ($action == 'copy') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->duplicate("/.clipboard/" . basename($child->path));
				if (!$child->ok)
					$this->error($child->error());
			}
		}
		else
			$this->error("To copy a page, at least one page must be checked.");
	}
	elseif ($action == 'delete') {
		if ($checked) {
			foreach($checked as $childname => $on) {
				$child = $page->child($childname);
				$child->move("/.trash/" . basename($child->path));
				if (!$child->ok)
					$this->error($child->error());
			}
		}
		else
			$this->error("To delete a page, at least one page must be checked.");
	}
	elseif ($action == 'new') {
		$i=0;
		$name = "untitled" . $i++;
		while ($newpage = $page->child($name)) {
			if ($newpage->fnf) break;
			$name = "untitled" . $i++;
		}	
		$newpage = &$page->ps->newChild($page,$name);
		if (!$newpage->ok) {
			$this->error($newpage->error());
			return;
		}
		else {
			$newpage->set('mtime',time());
			$newpage->commit();
		}
	}
	elseif ($action == 'destroyall') {
		$children = $page->children();
		foreach($children as $child) {
			$child->destroy();
			if (!$child->ok)
				$this->error($child->error());
		}
	}

	$this->display('info');
	return '';
}

function doversions(&$page) {
	$this->display('versions');
	return '';
}

function doview(&$page) {
	return 'view';
}

function dopreview(&$page) {
	$this->display('preview');
	return '';
}

function dostyle(&$page) {
	$this->display('style',true);
}


function display($template,$raw=false) {
	require_once('editor/common.php');

	global $editor, $page, $ps, $nav, $prop;	
	$root = $prop->getGlobal('siteroot');
	$e = &$this;
	
	$action = $page->absolutepath . '/';
	$GLOBALS['root'] = $root;
	$GLOBALS['baseurl'] = $this->prop->getGlobal('liburl');
	ob_start();
		include($this->template($template));
		$content = &ob_get_contents();
	ob_end_clean();
	if ($raw)
		echo $content;
	else {
		$errors = errors();
		include($this->template('template'));
	}
}

function error($msg) {
	trigger_error($msg);
}

function template($name) {
	return dirname(__FILE__) . "/editor/$name.php";
}

function isRepeat() {
	$serial = get('serial',-1);
	return false;
}

} // end class

?>