<?php

require_once('filter.php');

define('LINE_FEED', chr(13));
define('LINE_BREAK', chr(10));
define('LINE_BR', 50);

define('SHADEOPEN','<table bgcolor="#FFF6DD" width="100%" cellpadding="4"><tr><td>');
define('SHADECLOSE','</td></tr></table>');
define('PROMPTOPEN', SHADEOPEN . "<pre>");
define('PROMPTCLOSE', "</pre>" . SHADECLOSE);

class text2html extends filter {

var $search = array();
var $replace = array();
var $quote=false; // if true, we quote the current text.
var $nobr=false; // if true, we don't break the *current* line
var $br=''; // prepended to each line we process. should be set
            // by the previous line, if the previous line should end with a br.
            // this gives the current line a chance to cancel the previous br.

var $bullets = array('placeholder');
var $bulletcount = 0;
var $closebullet;

var $pre=false;  // if true, we are in a preformatted block
var $pretext=''; // text buffer for the current formatted block
var $h1=0; // the various counts for the headers
var $h2=0;
var $h3=0;
var $h4=0;
var $outline=array(); // an outline of the headings
var $blockquote;
var $shade;
var $hangingbold;
var $hangingitalics;
var $nop;

function apply(&$content,&$page) {
	$lines = explode("\n", $content);	
	$content = '';
	foreach($lines as $line) {	
		$content .= $this->convertLine($line);
	}

	// tie up loose ends
	if ($this->bulletcount) {
		$content .= $this->bullet_end(0);
	}
	if ($this->blockquote) {
		$content .= "</blockquote>";
	}
	if ($this->pre) {
		$content .= $this->pre_end();
	}
	if ($this->shade) {
		$content .= "</div>\n";
	}
	
	$page->toc = $this->outline;
}

function text2html() {
	$this->setupTransforms();
}
	
function convertLine($line) {
	
	## handle preformatted block
	
	if ($this->pre) {
		if (!$this->singleton && preg_match("/^\s*(''|'\}|\]\])\s*$/",$line))  # if '' or '} or ]]
			return $this->pre_end();
		elseif ($this->singleton) {
			if (preg_match("/^\[ .*$/",$line)) 
				return $this->pre_line(substr($line,2)); // strip leading '['
			else
				return $this->pre_end() . $this->convertLine($line);
		}	
		else
			return $this->pre_line($line);
	}

	## handle empty line
	
	if ($this->isempty($line)) {
		$this->previousblank = true;
		if ($this->bulletcount) {
			$this->closebullet=true;
			return '';
		}
		elseif ($this->blockquote) {
			$this->blockquote=false;
			$this->br = '';
			return "</blockquote>\n";
		}
		elseif ($this->nop == true) {
			$this->nop = false;
			return '';
		}
		else {
			$this->br = '';
			return "<p></p>\n";
		}
	}

	## handle non-empty line
	
	## convert $line to $ret
	
	$ret = '';
		
	// if heading
	if (preg_match('/^\s*\*+\s+.+\s+\*+\s*$/',$line)) {
		$ret = $this->heading($line);
	}
	// if bullet (starts with # - or *)
	elseif (preg_match('/^(\s*)(#|-)\s(.*)/',$line,$matches)) {
		$this->closebullet=false;
		$indent = strlen($matches[1]);
		$type = $matches[2];
		$text = $matches[3];
		$current_bullet_indent = $this->bullets[$this->bulletcount]['indent'];
		if ($this->bulletcount==0)
			$ret .= $this->bullet_begin($type,$indent);
		elseif($current_bullet_indent < $indent)
			$ret .= $this->bullet_begin($type,$indent);
		elseif($current_bullet_indent > $indent)
			$ret .= $this->bullet_end($indent);
		$ret .= '<li>' . preg_replace(array('/^((.*)::)(.*)$/','/^((.*);;)(.*)$/'),array('<b>$2:</b>$3','<i>$2:</i>$3'),$text) . "\n";
	}
	// if indent 
	elseif (!$this->blockquote && $this->bulletcount==0 && preg_match('/^(\s+)/',$line,$matches)) {
		if ($this->previousblank) {
			$ret = "<blockquote>$line\n";
			$this->blockquote = true;
		}
		else {
#			$ret = "$line\n";
			$indent = strlen($matches[1]);
			$margin = 10 * $indent;
			$ret = "<div style=\"margin-left: ${margin}px;\">$line<br></div>\n";
			$this->br = '';
		}
	}
	
	// if shade begin {{
	elseif (preg_match('/^\s*\{\{\s*$/',$line)) {  
		$this->shade=true;
		$ret = "<div class=shade>\n";
		$this->nobr=true;
	}
	// if shade end }}
	elseif ($this->shade && preg_match('/^\s*\}\}\s*$/',$line)) {
		$this->shade=false;
		$ret = "</div>\n";
		$this->nobr=true;
	}
#	// if shade line {
#	elseif () {
#	
#	}
	// if pre begin ''
	elseif (preg_match("/^\s*''\s*$/",$line)) {
		$this->singleton = false;
		$ret = $this->pre_begin();
	}
	// if pre/shade begin [[ or {'
	elseif (preg_match("/^\s*(\{'|\[\[)\s*$/",$line)) {
		$this->singleton = false;
		$this->shade = true;
		$ret = $this->pre_begin(true);
	}
	// if pre/shade begin [
	elseif (preg_match("/^\[ .*$/",$line)) {
		$this->singleton = true;
		$ret = $this->pre_begin(true);
		$this->pre_line(substr($line,2));
	}


	// default
	else {
		$ret = "$line\n";
	}

	// global filter for stuff like urls
	$ret = preg_replace($this->search,$this->replace,$ret);
		
	## clean up
	
	if ($this->closebullet) {
		while($this->bulletcount) {
			$ret = $this->bullet_end(0) . $ret;
		}
	}

	## handle hanging bold and italics
	
	if ($this->hangingbold) {
		if (preg_match('/^.*\w\*[^\w]/',$ret))
			$ret = preg_replace('/\*([^\w])/','</b>$1',$ret);
		else 
			$ret = "</b>$ret";
		$this->hangingbold = false;
	}
	elseif (preg_match('/[^\w]\*\w.*$/',$ret)) {		
		$ret = preg_replace('/([^\w])\*/','$1<b>',$ret);
		$this->hangingbold = true;
	}

	if ($this->hangingitalics) {
		if (preg_match('/^.*\w_[^\w]/',$ret))
			$ret = preg_replace('/_([^\w])/','</i>$1',$ret);
		else 
			$ret = "</i>$ret";
		$this->hangingitalics = false;
	}
	elseif (preg_match('/[^\w]_\w.*$/',$ret)) {		
		$ret = preg_replace('/([^\w])_/','$1<i>',$ret);
		$this->hangingitalics = true;
	}
	
	## break short lines
	
	# apply br from previous line:
	$ret = $this->br . $ret;
	
	if ($this->nobr) {
		$this->nobr = false;
		$this->br = '';
	}
	else {
		$this->br = $this->breakline($ret);
	}
	$this->previousblank = false;
	return $ret;
}

function isempty($line) {
	return preg_match('/^\s*$/',$line);
}

function heading($line) {
	$this->nobr = true;
	$this->nop = true;
	$h1 = &$this->h1; $h2 = &$this->h2; $h3 = &$this->h3; $h4 = &$this->h4;
	
	// h1
	if (preg_match('/^\s*\*\*\*\*\s+(.+)\s+\*\*\*\*\s*$/',$line,$matches)) {
		$h1++;
		$h2=0;$h3=0;$h4=0;
		$this->outline[] = array('text'=>$matches[1],'level'=>1,'tag'=>"$h1.$h2.$h3");
		return "<a name=\"$h1.$h2.$h3\"></a><h1>$matches[1]</h1>\n";
	}
	// h2
	elseif (preg_match('/^\s*\*\*\*\s+(.+)\s+\*\*\*\s*$/',$line,$matches)) {
		$h2++;
		$h3=0;$h4=0;
		$this->outline[] = array('text'=>$matches[1],'level'=>2,'tag'=>"$h1.$h2.$h3");
		return "<a name=\"$h1.$h2.$h3\"></a><h2>$matches[1]</h2>\n";
	}
	// h3
	elseif (preg_match('/^\s*\*\*\s+(.+)\s+\*\*\s*$/',$line,$matches)) {
		$h3++;
		$h4=0;
		$this->outline[] = array('text'=>$matches[1],'level'=>3,'tag'=>"$h1.$h2.$h3");
		return "<a name=\"$h1.$h2.$h3\"></a><h3>$matches[1]</h3>\n";
	}
	// h4
	elseif (preg_match('/^\s*\*\s+([^\*]+)\s+\*\s*$/',$line,$matches)) {
		$h4++;
		$this->outline[] = array('text'=>$matches[1],'level'=>4,'tag'=>"$h1.$h2.$h3.$h4");
		return "<a name=\"$h1.$h2.$h3.$h4\"></a><h4>$matches[1]</h4>\n";
	}
	else
		die('error: could not parse header '. $line);
}

function bullet_begin($type,$indent) {
	$this->bulletcount++;
	$this->bullets[$this->bulletcount] = array(
		'type' => $type,
		'indent' => $indent
	);
	if ($type=='#') return "<ol>\n";
	else            return "<ul>\n";
}

// todo: back out of multiple levels at once.
function bullet_end($indent) {
	switch($this->bullets[$this->bulletcount]['type']) {
		case '-': $ret = "\n</ul>\n"; break;
		case '#': $ret = "\n</ol>\n"; break;
	}
	$this->bullets[$this->bulletcount] = null;
	$this->bulletcount--;
	return $ret;
}

function pre_begin($shade=false) {
	$this->pre=true;
	$this->pretext='';
	$this->nobr=true;
	if ($shade)
		return '<div class=shade><code>';
	else
		return '<div><code>';
}

function pre_end() {
	$text = htmlspecialchars($this->pretext);
	$text = str_replace(array(' ',"\n","--||"), array('&nbsp;',"<br>\n","&not;"),$text);
	$text .= "</code></div>\n";
	$this->pretext='';
	$this->pre=false;
	return $text;
}

function pre_line($line) {
	$this->pretext .= wordwrap($line, '80', "--||\n") . "\n";
	return '';
}

function setupTransforms() {
	$transform = array (
		'/([^\w])_(.*)_([^\w])/' => '$1<i>$2</i>$3',
		'/\*([^\s\*]+[^\*]*[^\s])\*/' => '<b>$1</b>',
		'/\[([^\|]*?)\]/' => '<a href="$1">$1</a>',
		'/\[(.*?)\|(.*?)\]/' => '<a href="$2">$1</a>',
		'/{([^\|]*?)}/' => '<a href="./?s=$1">$1</a>',
		'/{(.*?)\|(.*?)}/' => '<a href="./?s=$2">$1</a>',
		'/(^|\s)(.*?)@(.*?)/' => '$1$2<!-- -->@<!-- -->$3',
#		'/^\s*-{3,}/' => '<table border=0 cellpadding=0 cellspacing=0 width="100%" bgcolor=black><tr><td><img height=1 width=2></td></tr></table>                                                                  ',
		'/^\s*-{3,}\s*$/' => '<table border=0 cellpadding=0 cellspacing=0 width="100%" bgcolor=black><tr><td><img height=1 width=2></td></tr></table>                                                                  ',
		"!(^|[^/]|\s)((www\.)([-a-z0-9.]{2,}\.[a-z]{2,4}(:[0-9]+)?)((/([^\s]*[^\(\)\s.,\"'])?)?)((\?([^\s]*[^\s.,\"'])?)?))!i" => '$1<a href="http://$2">$2</a>',
		"!(^|[^\"]|\s)(((http(s?)|ftp)://)([-a-z0-9.]{2,}\.[a-z]{2,4}(:[0-9]+)?)((/([^\s]*[^\(\)\s.,\"'])?)?)((\?([^\s]*[^\s.,\"'])?)?))!i" => '$1<a href="$2">$6$8</a>',
	);
	$this->search = array_keys($transform);
	$this->replace = array_values($transform);
}

function breakline(&$html) {
	if (preg_match("/-\s*$/",$html)) {
		$html = preg_replace('/(.*)-\s*$/','$1',$html);
		return '';
	}
	elseif (preg_match("/~\s?$/",$html)) {
		$html = preg_replace('/(.*)~\s?$/','$1',$html);
		return '<br>';
	}
	else
	{
		$textlength = strlen(trim(preg_replace('/<.*?>/','',$html)));
		$htmllength = strlen(trim($html));
		if ($textlength == 0 && $htmllength != 0)
			return ''; // maybe just a line of html, so skip the br.
		elseif ($textlength < LINE_BR)
			return '<br>';
		else
			return '';
	}
}

} // end Class

?>