<?php 

/*******************************************
 * 
 * PageStore
 * An abstract super class for storing and retrieving pages
 * 
 ******************************************/

require_once('Properties.php');

#########################################################
# PageStoreFactory

class PageStoreFactory {
	function create($configstr,&$prop) {
		$directory = dirname(__FILE__) . "/pagestores";
		$args = explode(',',$configstr);
		$class = ucfirst($args[0]) . "PageStore";
		$file = "$directory/$class.php";
		if (!is_file($file))
			die(_("Could not find page storage backend:") . $args[0]);
		require_once($file);
		return new $class($prop);
	}
}

#########################################################
# PageStore

class PageStore {

var $urlRoot;
var $documentRoot;
var $prop;

function init(&$page) {}

function PageStore(&$prop) {
	$this->prop = &$prop;
	$this->urlRoot = preg_replace('#/$#','',$prop->getGlobal('siteroot')); 
	$this->documentRoot = preg_replace('#/$#','',$_SERVER['DOCUMENT_ROOT']);
}

/*
 * getPage
 * All page object creation is handled by this function.
 */
function &getPage($path='') {
	// normalize the path
	$path = $this->cleanpath($path);
	
	// before we create the page, we need to know what kind of
	// of page it is, ie what page subclass to use.
	// so we bootstrap the basic properties
	$basic = $this->loadbasic($this->urlRoot, $path);
	$this->prop->bootstrap($path,$basic); // cache the props we just loaded.
	if (isset($basic['type']))
		$type = $basic['type'];
	else
		$type = $this->prop->getGlobal('type');
	
	$type = preg_replace('/[^a-z]/', '', strtolower($type)); // safety check
	$type = ucfirst($type);
	if (!class_exists("Page$type")) {
		if (!is_file("pages/Page$type.php")) {
			die("page type $type is unknown");
			return;
		}
		require_once("pages/Page$type.php");
	}
	$pageclass = "Page$type";
	$page = new $pageclass();
	$page->ps = &$this;
	$page->prop = &$this->prop;
	$page->path = $path;
	$page->absolutepath = "$this->urlRoot$path";
	$this->init($page); // allows subclass of pagestore to add custom variables
	$page->init();      // allow the page to do any final setup.
	
	return $page;
}

/*
 * cleanpath($path)
 * returns a url path which has been normalized and cleaned up.
 */
function cleanpath($path=' none ') {
	if ($path == ' none ') {
		$path = $_SERVER['REQUEST_URI'];
	}
	$path = urldecode($path);
	$path = stripslashes($path);
		
	# start with /
	if (!preg_match("|^/|", $path))
		$path = "/$path";

	# remove:
	#  1. query string
	#  2. site root from url
	#  3. multiple '/'
	#  4. index.php 
	#  5. trailing /
	$root = $this->urlRoot;
	$path = preg_replace(
		array("'(\?.*)'", "'^$root'", "'/{2,}'", "'index.php'", "'/$'"),
		array('', '', '/', '', ''),
		$path
	);
	return $path;
}

/*
 * fetch(Page $page)
 * loads contents of $page into memory, stored in $page.
 * we also update any page variables which we discovered
 * in the process of loading the file.
 */
 
function &fetch(&$page) {}

/*
 * loadbasic(Page $page)
 * load contents of basic info for $page into
 * page object. this includes:
 * - title
 * - page name
 * - 
 
function loadbasic(&$page) {}

function loadprops(&$page) {}

/* 
 * saves content and properties which have changed
 * back to permanent storage
 */
 
function commit(&$page) {}

/*
 * creates a new page as child of $parent
 * returns $page.
 */
function &addChild(&$parent, $name, $type) {}

/*
 * removes a page from storage
 */
function deletePage(&$page) {}

/*
 * movePage(Page $from, Page $to)
 */
function &movePage(&$from, &$to) {}

/*
 * duplicatePage(Page $from, Page $to)
 */
function &duplicatePage(&$from, &$to) {}


function getNextPage($page) {}
function getPrevPage($page) {}
function getFirstChild($page) {}
function getChildren($page) {}

} // end class

return;
?>
