<?php

/****
 *
 * Renderer Class
 * Controls rendering of a page, static or dynamic.
 * 
 ****/	

require_once('Properties.php');
require_once('Page.php');

class Renderer {

var $prop;

function Renderer(&$prop) {
	$this->prop = &$prop;
}

function displayError($title, $contents) {
	$content = "<font color=red>Error:</font><br>$contents";
	$this->display($title, $content);
}

function display($title, &$content) {
	global $root, $decoratorurl, $nav, $ps, $robot, $static, $page;
	require_once(dirname(__FILE__) . '/decorators/common.php');
	$title = $this->prop->getGlobal('title-prefix') . $title;
	$decor = $this->getDecorator();
	$decoratorurl = $decor->url;
	$nav_hide = true;
	include($decor->template);
}

function renderPage(&$page,&$content,$decoratorname='') {
	global $root, $decoratorurl, $nav, $ps, $robot, $static;
	require_once(dirname(__FILE__) . '/decorators/common.php');
	if ($decoratorname == '')
		$decoratorname = $page->get('decorator');
	$decor = $this->getDecorator($decoratorname);
	$title = $page->get('title-prefix') . $page->get('title');

	$decoratorurl = $decor->url;
	header("Last-Modified: " . gmdate("D, d M Y H:i:s", $page->get('mtime')) . " GMT");
	include($decor->template);
}


/**
 style handler
 This function is called on ?action=style requests.
 it dumps the correct css file, setting the headers correctly
 for content type and caching. with d=<decoratorname> in the url,
 you can override the decorator property of the given page.
 **/
function style(&$page) {
	global $root, $decoratorurl, $nav, $ps, $robot, $static;

	// send mime type, this is a css file.
	header('Content-type: text/css');
	
	// send cache headers. we want the style page cached.
	$offset = 60*60*3; // 3 hours
	$expires = "Expires: " . gmdate("D, d M Y H:i:s", time() + $offset) . " GMT";
	header("Cache-Control: public");
	header($expires);
	
	// load the decorator
	require_once(dirname(__FILE__) . '/decorators/common.php');
	$decorator_name = get('d',$page->get('decorator'));
	$decor = $this->getDecorator($decorator_name);
	$decoratorurl = $decor->url;

	// set last modified
	$lastmod = "Last-Modified: " . gmdate("D, d M Y H:i:s", filemtime($decor->style)) . " GMT";
	header($lastmod);

	// run style.php
	include($decor->style);
}


function getDecorator($name = '') {
	$d = new Decorator();
	if ($name == '')
		$d->name = $this->prop->getGlobal('decorator');
	else
		$d->name = $name;
		
	// try possible dirs, until we find a decorator
	// this is kinda silly, we should just decide
	// where it must go.
	
	// map url => directory
	$docroot = $this->prop->getGlobal('sitedocroot');
	$urlroot = $this->prop->getGlobal('siteroot');
	$libfile = dirname(__FILE__);
	$liburl  = $this->prop->getGlobal('liburl');
	$candidates = array(
		"$urlroot/.decorators/$d->name"  => "$docroot/.decorators/$d->name",
		"$urlroot/$d->name"  => "$docroot/$d->name",
		"$urlroot/.bamboo/$d->name"  => "$docroot/.bamboo/$d->name",
		"$liburl/decorators/$d->name"  => "$libfile/decorators/$d->name",
	);
	foreach($candidates as $url => $dir) {
		if (is_dir($dir)) break;
	}
		 
	$d->url = $url;
	$d->template = "$dir/template.php";
	$d->style = "$dir/style.php";
	if (file_exists("$dir/index.php"))
		$d->index = "$dir/index.php";
	$d->error = "$dir/error.php";
	
	if (!file_exists($d->template) && $name != 'print')
		return $this->getDecorator('print');
	else
		return $d;
}

function displayFnf(&$page) {
	$d = $this->getDecorator();
	$fnfpath = $page->path;

	while($page->fnf) {
		$page = $page->parent();
	}
	$path = $page->path ? $page->path : '/';
	$newpagelink = alink($path . "?a=edit&ea=newedit&path=" . urlencode($fnfpath), _("Create this page"));
	
	if (is_file($d->error)) {
		ob_start();
		include($d->error);
		$content = &ob_get_contents();
		ob_end_clean();
	}
	else {
		$content = "<p>404 Page not found</p><p>The web page you seek<br />Cannot be located, but<br />Countless more exist.</p>";
		$content .= $newpagelink;
	}
	$this->display("File not found", $content);
}

} // end class

class Decorator {
	var $index;
	var $style;
	var $template;
	var $name;
	var $url;	
}

return;
?>
