<?php

require_once('filter.php');

class symbols extends filter {

function apply(&$content,&$page) {
	$content = preg_replace(
		array(
			"/^#toc\s*$/me",
			"/^#index list\s*$/me",
			"/^#index outline\s*$/me",
			"/^#index info\s*$/me",
			"/^#attachments\s*$/me",
			'/^#img\s+"?(.*?)"?\s+(.*?)(\s+.*)?$/me', 
			'/^#include\s+"?(.*?)"?\s*$/me', 
		),
		array(
			"\$this->toc(\$page->toc)",
			"\$this->filelist(\$page)",
			"\$this->outline(\$page)",
			"\$this->info(\$page)",
			"\$this->attachments(\$page)",
			'$this->insertimg("$1","$2","$3")',
			'$this->includepage($page,"$1")',
		),
		$content
	);
}

// generate table of contents 	
function toc($outline) {
	$levels = array(); $min = 5; $start = 0;
	foreach ($outline as $line) {
		$levels[$line['level']] += 1;
		$min = min($min,$line['level']);
	}
	if ($levels[$min] == 1) {
		if ($outline[0]['level'] == $min)
			$start = 1; // skip first if it is the only one of that level.
	}
	
	$html = "<!-- begin toc -->\n<ol class='toc'>\n";
	$html .= $this->toc_level($outline, $start);
	$html .= "</ol>\n<!-- end toc -->\n";
	return $html;
}

function toc_level(&$outline,$i=0) {
	if (!isset($outline[$i])) return;
	$html .= "<li class='toc'><a href='#".$outline[$i]['tag']."'>".$outline[$i]['text']."</a></li>\n";
	for($j=$i+1;$j<count($outline);$j++) {
		if ($outline[$j]['level'] <= $outline[$i]['level'])
			break;
		else
			$suboutline[] = $outline[$j];
	}	 
	if (count($suboutline)) {
		$html .= "<ol class='toc'>\n";
		$html .= $this->toc_level($suboutline,0);
		$html .= "</ol>\n";
	}
	$html .= $this->toc_level($outline,$j);
	return $html;
}

// generate a list of files
function filelist(&$page) {
	global $nav;
	$tree = $nav->getOpenTree($page);
	$ret = "<div class=filelist><ol>\n";
	foreach($tree as $entry) { 	
		if ($entry['level'] === 'push')
			$ret .= "<ol>\n";
		elseif ($entry['level'] === 'pop')
			$ret .= "</ol>\n";
		else {
			$link = alink($entry['path'] . '/',$entry['title']);
			if ($entry['selected']) $link = "<b>$link</b>";
			$ret .= "<li>$link</li>\n";
		}
	}
	$ret .= "</ol></div>\n";
	return $ret;
}

function outline(&$page) {
	global $nav,$ps;
	$ret = '';
	#$tree = $nav->getOpenTree($page);
	$tree = $page->children();
	foreach($tree as $p) {
		#$page = &$entry['page'];
		if ($p != null && !$p->fnf)
			$p->get('content');
		
		$links = array();
		if ($p->type == 'txt') {
			preg_match_all('/^\s*\*+\s+([^\*]+)\s*($|\*+\s*$)/m',$p->content,$matches);
			for($i=0; $i<count($matches[1]); $i++) {
				$links[$matches[1][$i]] = text_to_anchor($matches[1][$i]);
			}
		}
		elseif ($p->type == 'html') {
			preg_match_all("/^\w*<h[123]>(.*)</h[123]>/m", $p->content, $matches);
			$links[$matches[1][$i]] = text_to_anchor($matches[1][$i]);
		}
		$ret .= "<h2 class='outline'>$p->title</h2>";
		$ret .= "<ol>";
		foreach( $links as $text => $tag ) {
			$ret .= "<li>" . alink($p->path . "/#$tag", $text);
		}
		$ret .= "</ol>";
	}
	return $ret;
}

function insertimg($file, $align, $caption) {
	global $prop;
	if ($align == '' || $align == 'left')
		$style = "style='float:left'";
	elseif ($align == 'right')
		$style = "style='float:right'";
	elseif ($align == 'center')
		$style = "style='text-align:center'";
		
	$root = $prop->getGlobal('siteroot');
	#$file = preg_replace('"^/"','',$file);
	$ret = "<div $style class='photo'>";
	$ret .= "<img src=\"$root$file\" >";
	if ($caption) {
		$ret .= "<div class='caption'>$caption</div>";
	}
	$ret .= "</div>";
	
	return $ret;
}

function info(&$page) {
	$children = $page->children();
	$ret = '';
	foreach($children as $child) {
		if (!$child->get('visible')) continue;
		$ret .= "<dl class=index>\n";
		$ret .= "<dt>" . alink($child->path . '/',$child->get('title')) . "</dt>\n";
		$ret .= "<dd>" . $child->get('description') . "</dd>\n";
		$ret .= "</dl>\n";
	}
	return $ret;
}

function attachments(&$page) {
	$ainfos = $page->attachments();
	$ret = '';
	$ret .= "<table class=attachments>";
	foreach($ainfos as $info) {
		$ret .= "<tr><td>";
		$class = 'type-file';	
		$ret .= alink($page->path . "/$info[name]", $info['name'], "class=\"$class\" style=\"padding-left: 16px\"");
		$ret .= "</td><td>";
		$ret .= round($info['size'] / 1024,1) . 'K';
		$ret .= "</td><td>";
		$ret .= $info['type'];
		$ret .= "</td><td>";
		$ret .= date('M d Y g:i a',$info['mtime']);
		$ret .= "</td><td></tr>\n";
	}
	$ret .= "</table>";
	return $ret;
}

function includepage(&$page,$path) {
	global $auth, $renderer;
	
	
	$ps = $page->ps;
	if ($path == $page->path)
		return "\n<!-- #include [path] failed: you cannot include yourself -->\n";
	elseif ($path == '')
		return "\n<!-- #include [path] failed: no path -->\n";
	elseif ($path{0} == "/")
		$incpath = $path; // absolute
	else
		$incpath = $page->path . "/$path"; // relative
		
	$incpage = $ps->getPage($incpath);
	if ($incpage->fnf)
		return "\n<!-- #include $path failed: that page doesn't exist. -->\n";
	
	$username = $auth->username();
	if ($username == '') $username = "anonymous";
	if (!$incpage->may($username,"view")) {
		return "\n<!-- #include $path failed: you do not have permission to view $path. -->\n";
	}
	
	return $incpage->getDisplay();
}


} // end class

function get_file($file) {
    ob_start();
    readfile($file);
    $contents = ob_get_contents();
    ob_end_clean();
    return $contents;
}


/*

example usage:

ob_start();
readfile("data.html");
$file = ob_get_contents();
ob_end_clean();
$filter = new HtmlFilter();
$filter->insert_toc($file);
print $file;


*/

/*
not used, why is this here?
*/
class HtmlFilter {
	var $anchor_count;
	var $anchors;
	
	/*
     * inserts Table of Contents right in front of existing $html
     */
	function prepend_toc(&$html, $minheader=1, $maxheader=5) {
		$toc = $this->get_toc($html, $minheader, $maxheader);
		$html = $toc . $html;
	}

	/*
     * inserts Table of Contents right after
     * <body> tag.
     */
	function insert_toc(&$html, $minheader=1, $maxheader=5) {
		$toc = $this->get_toc($html, $minheader, $maxheader);
		$html = preg_replace('/<\\s*body.*?>/si',"\$0\n" . $toc, $html); 	
	}

	function get_toc(&$html, $minheader, $maxheader) {
		$this->anchor_count = 0;
		$this->anchors = array();

		// add <a name=blah> and get list of anchors
		$find = '/<h(['."$minheader-$maxheader".'])>(.*?)<\/h\d>/si';
		#$find = '/<h([1-5])>(.*?)<\/h\d>/si';
		$html = preg_replace_callback($find, array(&$this,'toc_callback'), $html);
		
		if (!count($this->anchors)) return "";

		// generate table of contents 
		$count = 0;
		$toc = "<ol class=toc>\n";
		for($i=0; $i<count($this->anchors); $i++) {
			$a = $this->anchors[$i];
			$toc .= "<li class=toc><a href=\"#$a[anchor]\">$a[text]</a></li>\n";
			$count++;
			if ( isset($this->anchors[$i+1]) ) {
				if ($a['level'] < $this->anchors[$i+1]['level'])
					$toc .= "<ol class=toc>";
				elseif ($a['level'] > $this->anchors[$i+1]['level'])
					$toc .= "</ol>";
			}
		}
		if ($count > 1) {
			$toc .= str_repeat("</ol>", (int)($this->anchors[$i-1]['level'])); // close all remaining open <ol>	
			return $toc;
		}
		else
			return '';
	}		
	
	/*
     * replaces <h1>hello</h1> with <a name=hello><h1>hello</h1>
     * and adds entry to list of anchors
     */
	function toc_callback($matches) {
		if ($matches[2] == '') return;
		$a = array();
		$a['text'] = $matches[2];
		$a['anchor'] = $this->anchor_count++;
		$a['level'] = $matches[1];
		array_push($this->anchors,$a);
		return '<a name="' . $a['anchor'] . '">' . $matches[0]; 
	}
}

?>
