/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>

#include "linklabel.h"
#include "appsettings.h"

#include "container.h"

/** AppSettings */

/** Define global variables : */
/* Global objects */
DebugWindow*         AppSettings::debugWindow   = 0;
QString              AppSettings::appPath       = 0;
Container*           AppSettings::mainContainer = 0;
ContainerSystemTray* AppSettings::tray          = 0;
KGlobalAccel*        AppSettings::globalAccel   = 0;
/* App settings */
bool AppSettings::m_tabsOnTop          = true;
bool AppSettings::m_useSystray         = true;
int  AppSettings::m_showAtStart        = 2;
bool AppSettings::m_wasShown           = true;
bool AppSettings::m_useCleverShowHide  = true;
bool AppSettings::m_hideOnClose        = true;
bool AppSettings::m_hideOnMinimize     = false;
bool AppSettings::m_hideOnEscape       = true;
bool AppSettings::m_showSystrayToolTip = true;
int  AppSettings::m_lastBasket         = 0;
int  AppSettings::m_dropTimeToShow     = 7;
bool AppSettings::m_instantToolTips    = true;
bool AppSettings::m_usePassivePopup    = true;
int  AppSettings::m_whereToCopy        = 2;

void AppSettings::loadConfig()
{
	LinkLook *defaultLocalLook = new LinkLook( false, true,  false, true,
	                                           kapp->palette().active().link(), QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultUrlLook   = new LinkLook( true,  false, false, true,
	                                           kapp->palette().active().link(), QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultNoUrlLook = new LinkLook( false,  false, true, true,
	                                           kapp->palette().active().link(), QColor("red"),
	                                           true, 48, true );

	loadLinkLook(LinkLook::localLook, "Local links look", defaultLocalLook);
	loadLinkLook(LinkLook::urlLook,   "Network links look", defaultUrlLook  );
	loadLinkLook(LinkLook::noUrlLook, "NoUrl links look", defaultNoUrlLook);

	KConfig *config = KGlobal::config();
	config->setGroup("Main window"); // TODO: Split with a "System tray icon" group !
	AppSettings::setTabsOnTop(          config->readBoolEntry("tabsOnTop",          true)  );
	AppSettings::setUseSystray(         config->readBoolEntry("useSystray",         true)  );
	AppSettings::setShowAtStart(        config->readNumEntry( "showAtStart",        2)     );
	AppSettings::setWasShown(           config->readBoolEntry("wasShown",           true)  );
	AppSettings::setUseCleverShowHide(  config->readBoolEntry("useCleverShowHide",  true)  );
	AppSettings::setHideOnClose(        config->readBoolEntry("hideOnClose",        true)  );
	AppSettings::setHideOnMinimize(     config->readBoolEntry("hideOnMinimize",     false) );
	AppSettings::setHideOnEscape(       config->readBoolEntry("hideOnEscape",       true)  );
	AppSettings::setShowSystrayToolTip( config->readBoolEntry("showSystrayToolTip", true)  );
	AppSettings::setLastBasket(         config->readNumEntry( "lastBasket",         0)     );
	AppSettings::setDropTimeToShow(     config->readNumEntry( "droptimetoshow",     7)     );
	AppSettings::setInstantToolTips(    config->readBoolEntry("instantToolTips",    true)  );
	AppSettings::setUsePassivePopup(    config->readBoolEntry("usePassivePopup",    true)  );
	AppSettings::setWhereToCopy(        config->readNumEntry( "wheretocopy",        2)     );
}

void AppSettings::saveConfig()
{
	saveLinkLook(LinkLook::localLook, "Local links look");
	saveLinkLook(LinkLook::urlLook,   "Network links look");
	saveLinkLook(LinkLook::noUrlLook, "NoUrl links look");

	KConfig *config = KGlobal::config();
	config->setGroup("Main window");
	config->writeEntry( "tabsOnTop",          AppSettings::tabsOnTop()          );
	config->writeEntry( "useSystray",         AppSettings::useSystray()         );
	config->writeEntry( "showAtStart",        AppSettings::showAtStart()        );
	config->writeEntry( "wasShown",           AppSettings::wasShown()           );
	config->writeEntry( "useCleverShowHide",  AppSettings::useCleverShowHide()  );
	config->writeEntry( "hideOnClose",        AppSettings::hideOnClose()        );
	config->writeEntry( "hideOnMinimize",     AppSettings::hideOnMinimize()     );
	config->writeEntry( "hideOnEscape",       AppSettings::hideOnEscape()       );
	config->writeEntry( "showSystrayToolTip", AppSettings::showSystrayToolTip() );
	config->writeEntry( "lastBasket",         AppSettings::lastBasket()         );
	config->writeEntry( "droptimetoshow",     AppSettings::dropTimeToShow()     );
	config->writeEntry( "instantToolTips",    AppSettings::instantToolTips()    );
	config->writeEntry( "usePassivePopup",    AppSettings::usePassivePopup()    );
	config->writeEntry( "wheretocopy",        AppSettings::whereToCopy()        );
}

void AppSettings::loadLinkLook(LinkLook* &look, const QString &name, LinkLook *defaultL)
{
	KConfig *config = KGlobal::config();
	config->setGroup(name);

	bool   underline  = config->readBoolEntry(     "underline",  defaultL->underline()  );
	bool   italic     = config->readBoolEntry(     "italic",     defaultL->italic()     );
	bool   bold       = config->readBoolEntry(     "bold",       defaultL->bold()       );
	bool   hoverUnder = config->readBoolEntry(     "hoverUnder", defaultL->hoverUnder() );
	QColor color      = config->readPropertyEntry( "color",      defaultL->color()      ).asColor();
	QColor hoverColor = config->readPropertyEntry( "hoverColor", defaultL->hoverColor() ).asColor();
	bool   showIcon   = config->readBoolEntry(     "showIcon",   defaultL->showIcon()   );
	int    iconSize   = config->readNumEntry(      "iconSize",   defaultL->iconSize()   );
	bool   onTopIcon  = config->readBoolEntry(     "onTopIcon",  defaultL->onTopIcon()  );

	if (look)
		delete look;//look->setLook( underline, italic, bold, hoverUnder, color, hoverColor, showIcon, iconSize, onTopIcon );
		            //else
	look = new LinkLook( underline, italic, bold, hoverUnder, color, hoverColor, showIcon, iconSize, onTopIcon );
}

void AppSettings::saveLinkLook(LinkLook *look, const QString &name)
{
	KConfig *config = KGlobal::config();
	config->setGroup(name);

	config->writeEntry( "underline",  look->underline()  );
	config->writeEntry( "italic",     look->italic()     );
	config->writeEntry( "bold",       look->bold()       );
	config->writeEntry( "hoverUnder", look->hoverUnder() );
	config->writeEntry( "color",      look->color()      );
	config->writeEntry( "hoverColor", look->hoverColor() );
	config->writeEntry( "showIcon",   look->showIcon()   );
	config->writeEntry( "iconSize",   look->iconSize()   );
	config->writeEntry( "onTopIcon",  look->onTopIcon()  );
}

/** AppSettingsDialog */

AppSettingsDialog::AppSettingsDialog(QWidget *parent)
 : KDialogBase(KDialogBase::IconList, i18n("Configure"),
               KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel, KDialogBase::Ok, parent)
{
	KIconLoader icol;

	QFrame *page1 = addPage( i18n("Main window"), QString::null,
	                         icol.loadIcon( "winprops", KIcon::NoGroup, KIcon::SizeMedium ) );
	QFrame *page2 = addPage( i18n("System tray icon"), QString::null,
	                         icol.loadIcon( "kicker", KIcon::NoGroup, KIcon::SizeMedium ) );
	QFrame *page3 = addPage( i18n("Links"), QString::null,
	                         icol.loadIcon( "appearance", KIcon::NoGroup, KIcon::SizeMedium ) );

	/* Main window page */
	QVBoxLayout *layout = new QVBoxLayout(page1, 0, 6);

	QHBoxLayout *hLay1 = new QHBoxLayout(0, 0, 6);
	m_tabsOnTop = new QComboBox(page1);
	m_tabsOnTop->insertItem(i18n("on top"));
	m_tabsOnTop->insertItem(i18n("on bottom"));
	m_tabsOnTop->setCurrentItem( (int)!AppSettings::tabsOnTop() );
	QLabel *label1 = new QLabel(m_tabsOnTop, i18n("Show &tabs (baskets list)"), page1);
	hLay1->addWidget(label1);
	hLay1->addWidget(m_tabsOnTop);
	hLay1->insertStretch(-1);
	layout->addLayout(hLay1);

	m_dropTimeToShow = new KIntNumInput(AppSettings::dropTimeToShow(), page1);
	m_dropTimeToShow->setRange(0, 600, 1, false);
	m_dropTimeToShow->setLabel(i18n("&When a drag occure on a tab (or the systray), "
	                                "show the basket (or the main window) after"), KNumInput::AlignVCenter);
	m_dropTimeToShow->setSuffix(i18n(/*"/10 sec."*/" tenths of seconds"));
	layout->addWidget(m_dropTimeToShow);

	m_instantToolTips = new QCheckBox(i18n("Show tooltips &instantaneously (including items annotations...)"), page1);
	m_instantToolTips->setChecked(AppSettings::instantToolTips());
	layout->addWidget(m_instantToolTips);

	m_usePassivePopup = new QCheckBox(i18n("Use &passive popup feebacks for actions "
	                                       "by global shortcut or system tray icon"), page1);
	m_usePassivePopup->setChecked(AppSettings::usePassivePopup());
	layout->addWidget(m_usePassivePopup);

	layout->insertStretch(-1);

	/* System tray icon page */
	QVBoxLayout *layout2 = new QVBoxLayout(page2, 0, 6);

	m_useSystray = new QCheckBox(i18n("&Use system tray icon :"), page2);
	m_useSystray->setSizePolicy( QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum, 0, 0, false) );
	layout2->addWidget(m_useSystray);
	// TODO: Use two 'categories' : "Behaviour" and "Feedbacks"

	QHBoxLayout *hLay2 = new QHBoxLayout(0, 0, 6);
	m_systray = new QWidget(page2);
	layout2->addLayout(hLay2);
	hLay2->insertSpacing(-1, 20);
	hLay2->addWidget(m_systray);
	QVBoxLayout *sysLay = new QVBoxLayout(m_systray, 0, 6);

	QHBoxLayout *hLay3 = new QHBoxLayout(0, 0, 6);
	m_showAtStart = new QComboBox(m_systray);
	m_showAtStart->insertItem(i18n("always show main window"));
	m_showAtStart->insertItem(i18n("always hide main window"));
	m_showAtStart->insertItem(i18n("restore main window if it was openned the last time"));
	m_showAtStart->setCurrentItem(AppSettings::showAtStart());
	QLabel *label2 = new QLabel(m_showAtStart, i18n("At &start,"), m_systray);
	hLay3->addWidget(label2);
	hLay3->addWidget(m_showAtStart);
	hLay3->insertStretch(-1);
	sysLay->addLayout(hLay3);

	m_useCleverShowHide = new QCheckBox(i18n("Use cle&ver show / hide window on systray click "
		"(raise window on top if it hasn't focus instead of hide it)"), m_systray);
	sysLay->addWidget(m_useCleverShowHide);
	m_hideOnClose = new QCheckBox(i18n("&Hide main window when close button is clicked "
		"(instead of quit application)"), m_systray);
	sysLay->addWidget(m_hideOnClose);
	m_hideOnMinimize = new QCheckBox(i18n("Hide main window when &minimize button is clicked "
		"(and remove it from taskbar)"), m_systray);
	sysLay->addWidget(m_hideOnMinimize);
	m_hideOnEscape = new QCheckBox(i18n("Hide main window on &Escape key press"), m_systray);
	sysLay->addWidget(m_hideOnEscape);
	m_showSystrayToolTip = new QCheckBox(i18n("Show system tray icon &tooltip"), m_systray);
	sysLay->addWidget(m_showSystrayToolTip);

	connect( m_useSystray, SIGNAL(toggled(bool)), this, SLOT(slotEnableSystray(bool)) );
	m_useSystray->setChecked(         AppSettings::useSystray()         );
	m_useCleverShowHide->setChecked(  AppSettings::useCleverShowHide()  );
	m_hideOnClose->setChecked(        AppSettings::hideOnClose()        );
	m_hideOnMinimize->setChecked(     AppSettings::hideOnMinimize()     );
	m_hideOnEscape->setChecked(       AppSettings::hideOnEscape()       );
	m_showSystrayToolTip->setChecked( AppSettings::showSystrayToolTip() );
	m_systray->setEnabled(            AppSettings::useSystray()         );

	sysLay->insertStretch(-1);

	/* Links page */
	QGridLayout *grid = new QGridLayout(page3, /*row,col*/2,2, 0, 6);
	QGroupBox *gb1 = new QGroupBox(1, Qt::Vertical, i18n("Look for &local links :"), page3);
	QGroupBox *gb2 = new QGroupBox(1, Qt::Vertical, i18n("Look for &network links :"), page3);
	QGroupBox *gb3 = new QGroupBox(1, Qt::Vertical, i18n("Look for links &without URL (launchers) :"), page3);
	grid->addWidget(gb1, 0, 0);
	grid->addWidget(gb2, 0, 1);
	grid->addWidget(gb3, 1, 0);
	m_localLC = new LinkLookEditWidget(LinkLook::localLook, gb1);
	m_urlLC   = new LinkLookEditWidget(LinkLook::urlLook,   gb2);
	m_noUrlLC = new LinkLookEditWidget(LinkLook::noUrlLook, gb3);
}

AppSettingsDialog::~AppSettingsDialog()
{
}

void AppSettingsDialog::slotEnableSystray(bool on)
{
	m_systray->setEnabled(on);
}

void AppSettingsDialog::slotApply()
{
	AppSettings::setTabsOnTop(                       ! m_tabsOnTop->currentItem()   );
	AppSettings::mainContainer->tabPlacementChanged( AppSettings::tabsOnTop()       ); // FIXME: in setTabsOnTop
	AppSettings::setDropTimeToShow(                  m_dropTimeToShow->value()      );
	AppSettings::setInstantToolTips(                 m_instantToolTips->isChecked() );
	AppSettings::setUsePassivePopup(                 m_usePassivePopup->isChecked() );

	if (AppSettings::useSystray() != m_useSystray->isChecked()) { // FIXME: Idem !
		AppSettings::setUseSystray( m_useSystray->isChecked() );
		if (AppSettings::useSystray())
			AppSettings::tray->show();
		else {
			AppSettings::tray->hide();
			AppSettings::mainContainer->show();
		}
	}

	AppSettings::setShowAtStart(        m_showAtStart->currentItem()      );
	AppSettings::setHideOnClose(        m_hideOnClose->isChecked()        );
	AppSettings::setHideOnMinimize(     m_hideOnMinimize->isChecked()     );
	AppSettings::setHideOnEscape(       m_hideOnEscape->isChecked()       );
	AppSettings::setShowSystrayToolTip( m_showSystrayToolTip->isChecked() );
	AppSettings::setUseCleverShowHide(  m_useCleverShowHide->isChecked()  );

	m_localLC->saveChanges();
	m_urlLC->saveChanges();
	m_noUrlLC->saveChanges();
	AppSettings::mainContainer->linkLookChanged();

	AppSettings::saveConfig();

	KDialogBase::slotApply();
}

void AppSettingsDialog::slotOk()
{
	slotApply();
	KDialogBase::slotOk();
}

#include "appsettings.moc"
