/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef BASKETPROPERTIESWIDGET_H
#define BASKETPROPERTIESWIDGET_H

#include <qwidget.h>
#include <kdialogbase.h>

class QLineEdit;
class QCheckBox;
class QComboBox;
class KColorButton;
class KIconButton;

class Basket;
class OnClickActionCombo;

/**The widget that hold main basket settings.
  *@author Sbastien Laot
  */

class BasketPropertiesWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesWidget();
  public slots:
	void saveChanges();
  protected slots:
	void emptyIcon();
  private:
	Basket       *m_basket;
	QLineEdit    *m_name;
	KIconButton  *m_icon;
	QCheckBox    *m_checkable;
	QCheckBox    *m_showAnnotations;
	QComboBox    *m_hAlign;
	QComboBox    *m_vAlign;
	QCheckBox    *m_useColor;
	KColorButton *m_color;
	QCheckBox    *m_useAltColor;
	KColorButton *m_altColor;
};

/**The widget that allow to edit basket add item policy settings.
  *@author Sbastien Laot
  */

class BasketPropertiesAddItemWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesAddItemWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesAddItemWidget();
  private slots:
	void systrayStackFromChanged(int);
  public slots:
	void saveChanges();
  private:
	Basket    *m_basket;
	QComboBox *m_newItemPlacement;
	QCheckBox *m_allowFreeDrop;
	QCheckBox *m_pasteSelAtCursorPos;
	QComboBox *m_systrayStackFrom;
	QWidget   *m_stackOptions;
	QCheckBox *m_deleteAfterSystrayDrag;
};

/**The widget that hold basket onClic default settings.
  *@author Sbastien Laot
  */

class BasketPropertiesOnClicWidget : public QWidget
{
  Q_OBJECT
  public:
	BasketPropertiesOnClicWidget(Basket *basket, QWidget *parent = 0, const char *name = 0);
	~BasketPropertiesOnClicWidget();
  public slots:
	void saveChanges();
	void showHelp();
	void configCopy();

  private:
	Basket             *m_basket;
	OnClickActionCombo *m_contentOnClickAction;
	OnClickActionCombo *m_fileOnClickAction;
	QCheckBox          *m_runOverrideClick;
};

/**The dialog that hold basket settings.
  *@author Sbastien Laot
  */

class BasketPropertiesDialog : public KDialogBase
{
  Q_OBJECT
  public:
	BasketPropertiesDialog(Basket *basket, QWidget *parent = 0);
	~BasketPropertiesDialog();
  protected slots:
	void slotApply();
	void slotOk();
  private:
	Basket                        *m_basket;
	BasketPropertiesWidget        *m_properties;
	BasketPropertiesAddItemWidget *m_addPolicy;
	BasketPropertiesOnClicWidget  *m_onClic;
};

#endif // BASKETPROPERTIESWIDGET_H
