/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMFACTORY_H
#define ITEMFACTORY_H

#include <qobject.h>
#include <kservice.h>

class QString;
class KURL;
class QPixmap;
class QColor;

class Basket;

/**Factory class to create (new, drop, past) or load BasketIem, and eventuelly save them (?)
  *@author Sbastien Laot
  */
namespace ItemFactory
{
	/** Functions to create a new item from a content */
	Item* createItemText(  const QString &text,    Basket *parent );
	Item* createItemHtml(  const QString &html,    Basket *parent );
	Item* createItemUrl(   const KURL    &url,     Basket *parent );
	Item* createItemImage( const QPixmap &image,   Basket *parent );
	Item* createItemColor( const QColor  &color,   Basket *parent );
	Item* createItem(      const QString &content, Basket *parent ); // Find automatically the type (from a text)
	/** Functions to create derived items from a content */
	Item* createItemLauncher( const QString &prog, KService::Ptr service, bool nameInAnnots, Basket *parent );
		// service help to guess title and icon
	Item* createItemUrlOrLauncher(const KURL &url, Basket *parent );
	/** Functions to create a new item from a drop or past event */
	Item* dropItem(QMimeSource *event, Basket *parent);
	/** Functions to load an item */
	/** Other useful functions */
	QString fileNameForNewItem(Basket *parent);
	QFont   fontForFontType(int type);
	QString titleForURL(const KURL &url);
	QString iconForURL(const KURL &url);
}

#endif // ITEMFACTORY_H
