/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>

#include <kuniqueapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kglobalaccel.h>

#include "container.h"
#include "appsettings.h"
#include "debugwindow.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

static const char *description =
	I18N_NOOP("BasKet for KDE 3\n"
		"\n"
		"This application provide as many baskets "
		"as you wish, and you can drop anything into its...\n"
		"It's a Drop Drawers clone ("
		"http://www.sigsoftware.com/dropdrawers/index.html) for KDE 3.\n"
		"Please see http://www.sebastien.laout.tuxfamily.org/basket/ "
		"for more informations and get new versions.");

static KCmdLineOptions options[] =
{
	{ "d", 0, 0 },
	{ "debug", I18N_NOOP("Show the debug window"), 0 },
	{ 0, 0, 0 }
};

/* Thanks to JuK for this Application class */
class Application : public KUniqueApplication
{
  public:
	Application() : KUniqueApplication(true, true, false) {}
	virtual ~Application() {}
	virtual int newInstance() {
		if(AppSettings::mainContainer)
			AppSettings::mainContainer->setActive(true);
		return KUniqueApplication::newInstance();
	}
};

int main(int argc, char *argv[])
{
	/* App initialization and settings loading */
	KAboutData aboutData( "basket", I18N_NOOP("BasKet"),
	                      VERSION, description, KAboutData::License_GPL_V2,
	                      "(c) 2003, Sbastien Laot", 0, 0,
	                      "http://www.sebastien.laout.tuxfamily.org/basket/" );
	aboutData.addAuthor("Sbastien Laot", 0, "sebastien.laout@tuxfamily.org");

	KCmdLineArgs::init(argc, argv, &aboutData);
	KCmdLineArgs::addCmdLineOptions(options);

	KUniqueApplication::addCmdLineOptions();
/*	if ( ! KUniqueApplication::start() ) { // will be forked : use "--nofork" run command parameter to debug
		fprintf(stderr, "BasKet is already running !\n");
		// TODO: Show old main window if hidden
		exit(0);
	}*/
	KUniqueApplication app;

	AppSettings::loadConfig();

	/* Debug window */
	AppSettings::debugWindow = new DebugWindow();
	if ( KCmdLineArgs::parsedArgs()->isSet("debug") )
		AppSettings::debugWindow->show();

	/* Main container */
	AppSettings::mainContainer = new Container();
	app.setMainWidget(AppSettings::mainContainer);
	app.mainWidget()->setCaption("BasKet");
	AppSettings::mainContainer->tabPlacementChanged(AppSettings::tabsOnTop());

	/* System tray */
	AppSettings::tray = new ContainerSystemTray(AppSettings::mainContainer);
	AppSettings::tray->setPixmap( kapp->iconLoader()->loadIcon("basket", KIcon::Toolbar, KIcon::SizeSmall) );
	if (AppSettings::useSystray()) {
		AppSettings::tray->show();
		if ( (AppSettings::showAtStart() == 0) || (AppSettings::showAtStart() == 2 && AppSettings::wasShown()) )
			AppSettings::mainContainer->show();
	} else
		AppSettings::mainContainer->show();

	/* Initialize global shortcuts */
	AppSettings::globalAccel = new KGlobalAccel(AppSettings::mainContainer);
	KGlobalAccel *globalAccel = AppSettings::globalAccel; // Better for the following lines
	globalAccel->insert( "global_show_hide_main_window", i18n("Show / hide main window"),
	                     i18n("Allow you to show main Window if it is hidden, and to hide it if it is shown."),
	                     Qt::CTRL+Qt::SHIFT+Qt::Key_W, Qt::CTRL+Qt::SHIFT+Qt::Key_W,
	                     AppSettings::mainContainer, SLOT(changeActive()),            true, true );
	globalAccel->insert( "global_new_item", i18n("Create new item in current basket"),
	                     i18n("Allow you to create a new item in the current basket without have to open main window."),
	                     Qt::CTRL+Qt::SHIFT+Qt::Key_A, Qt::CTRL+Qt::SHIFT+Qt::Key_A,
	                     AppSettings::mainContainer, SLOT(newItemInCurrentBasket()),  true, true );
	globalAccel->insert( "global_paste", i18n("Paste clipboard content in current basket"),
	                     i18n("Allow you to paste clipboard content in the current basket without have to open main window."),
	                     Qt::CTRL+Qt::SHIFT+Qt::Key_V, Qt::CTRL+Qt::SHIFT+Qt::Key_V,
	                     AppSettings::mainContainer, SLOT(pasteInCurrentBasket()),    true, true );
	globalAccel->insert( "global_paste_selection", i18n("Paste selection in current basket"),
	                     i18n("Allow you to paste clipboard selection in the current basket without have to open main window."),
	                     Qt::CTRL+Qt::SHIFT+Qt::Key_S, Qt::CTRL+Qt::SHIFT+Qt::Key_S,
	                     AppSettings::mainContainer, SLOT(pasteSelInCurrentBasket()), true, true );
	globalAccel->insert( "global_new_basket", i18n("Create a new basket"),
	                     i18n("Allow you to create a new basket without have to open main window (you then can use the other global shortcuts to add an item, paste clipboard or paste selection in this new basket)."),
	                     "", "",
	                     AppSettings::mainContainer, SLOT(askNewBasket()),            true, true );
	globalAccel->insert( "global_previous_basket", i18n("Go to previous basket"),
	                     i18n("Allow you to change current basket to the previous one without have to open main window."),
	                     "", "",
	                     AppSettings::mainContainer, SLOT(goToPreviousBasket()),      true, true );
	globalAccel->insert( "global_next_basket", i18n("Go to next basket"),
	                     i18n("Allow you to change current basket to the next one without have to open main window."),
	                     "", "",
	                     AppSettings::mainContainer, SLOT(goToNextBasket()),      true, true );
	globalAccel->readSettings();
	globalAccel->updateConnections();

	/* Go */
	int result = app.exec();
	AppSettings::saveConfig();
	return result;
}
