dnl Copyright (C) 1999 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_NETSNMP,
[
	ost_cv_netsnmp=false
	ost_cv_netsnmp_min_version=( 5 1 2 )
	NETSNMP_FLAGS=""
	NETSNMP_LIBS=""
	NETSNMP_PREFIX=""
	NETSNMP_MIBDIR=""
	AC_LANG_SAVE
	AC_LANG_CPLUSPLUS
	AC_ARG_WITH( net-snmp,
	             [--with-net-snmp=DIR     Net-SNMP subsystem],
	             [
			if test $withval != "yes"; then
				NETSNMP_PREFIX=$withval
			else
				NETSNMP_PREFIX="/usr"
			fi
	             ] )
	if test -n "$NETSNMP_PREFIX"; then
		AC_PATH_PROG( [ost_cv_netsnmp_cfg],
		              [net-snmp-config],
		              [$NETSNMP_PREFIX/bin:$NETSNMP_PREFIX/sbin:/usr/local/bin:/usr/local/sbin:$PATH] ) 

		if test -n "$ost_cv_netsnmp_cfg"; then
			AC_MSG_RESULT( [$ost_cv_netsnmp_cfg] )
		else
			AC_MSG_RESULT( [Net-SNMP (net-snmp-config) not found] )
		fi

		AC_MSG_CHECKING( [Net-SNMP version] )
		ost_cv_netsnmp_version=`$ost_cv_netsnmp_cfg --version`
		ost_cv_netsnmp_cur_version=$ost_cv_netsnmp_version
		ost_cv_netsnmp_cur_version=${ost_cv_netsnmp_cur_version//./ }
		ost_cv_netsnmp_cur_version=( $ost_cv_netsnmp_cur_version )
		ost_cv_ind=0
		for OST_CV_NUM in ${ost_cv_netsnmp_min_version[[@]]}; do
			if test ${ost_cv_netsnmp_cur_version[[$ost_cv_ind]]} -lt $OST_CV_NUM; then
				ost_cv_minver=${ost_cv_netsnmp_min_version[[*]]}
				ost_cv_minver=${ost_cv_minver// /.}
				AC_MSG_RESULT( [An older version of Net-SNMP was found. Version $ost_cv_minver or newer required] )
			fi
			if test ${ost_cv_netsnmp_cur_version[[$ost_cv_ind]]} -gt $OST_CV_NUM; then
				break
			fi

			ost_cv_ind=$((ost_cv_ind + 1 ))
		done
		AC_MSG_RESULT( [$ost_cv_netsnmp_version] )

		AC_MSG_CHECKING( [for Net-SNMP AgentX support] )
		ost_cv_netsnmp_modules=`$ost_cv_netsnmp_cfg --snmpd-module-list` 
		if test "$ost_cv_netsnmp_modules" != "${ost_cv_netsnmp_modules/agentx\/subagent/}"; then
			AC_MSG_RESULT( [yes] )
		else
			AC_MSG_RESULT( [no] )
		fi

		NETSNMP_FLAGS=`$ost_cv_netsnmp_cfg --base-cflags`
		NETSNMP_LIBS=`$ost_cv_netsnmp_cfg --agent-libs`
		NETSNMP_MIBDIR=$NETSNMP_PREFIX/share/snmp/mibs
		AC_DEFINE( HAVE_NETSNMP, 1, [Net-SNMP monitoring plugin] )
		ost_cv_netsnmp=true
	fi

	AC_LANG_RESTORE
	AC_SUBST( NETSNMP_FLAGS )
	AC_SUBST( NETSNMP_LIBS )
	AC_SUBST( NETSNMP_MIBDIR )
] )

dnl ACCONFIG TEMPLATE
dnl END ACCONFIG



