/* debug.h
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 *     Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 *
 * The bulk of this file was extracted from squid. The original
 * copyright statement follows.
 *
 * DEBUG: section 0     Debug Routines
 * AUTHOR: Harvest Derived
 * 
 * Extracted from:
 * SQUID Web Proxy Cache          http://www.squid-cache.org/
 * ----------------------------------------------------------
 *
 *  Squid is the result of efforts by numerous individuals from
 *  the Internet community; see the CONTRIBUTORS file for full
 *  details.   Many organizations have provided support for Squid's
 *  development; see the SPONSORS file for full details.  Squid is
 *  Copyrighted (C) 2001 by the Regents of the University of
 *  California; see the COPYRIGHT file for full details.  Squid
 *  incorporates software developed and/or copyrighted by other
 *  sources; see the CREDITS file for full details.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#ifndef   INCLUDE__LIBARCH__DEBUG_H
#define   INCLUDE__LIBARCH__DEBUG_H

#include "hackerlab/machine/types.h"

#define MAX_DEBUG_SECTIONS 10

extern int arch_debug_levels[MAX_DEBUG_SECTIONS];
extern int arch_debug_level;
extern void arch_db_print (char const * format, ...);
extern int opt_debug_stderr;
extern void arch_debug_init(void);

/**
 * \brief send a debug or progress statement
 * \param section what section in baz to use to decide whether
 * to emit this statement.
 * \param level how detailed this statement is. level 0 will always be
 * emitted, level 9 is unlikely to be emitted.
 * \param format a standard printfmt string
 * \param args arguments for the format string
 */
#define debug(SECTION, LEVEL, FORMAT, args...) \
   do { \
        if ((arch_debug_level = (LEVEL)) <= arch_debug_levels[SECTION]) { \
                arch_db_print (FORMAT, ##args); \
        } \
   } while (/*CONSTCOND*/ 0)

enum debug_sections {
  dbg_debug = 0,
  dbg_baz = 1,
  dbg_bzr = 2,
  dbg_archive = 3,
  dbg_ui = 4,
  dbg_archives = 5,
  dbg_invent = 6,
  dbg_builder = 7,
  dbg_annotate = 8,
  dbg_diff = 9,
  dbg_dav = 10,
  dbg_authinfo = 11,
  dbg_apply = 12,
  dbg_archive_pfs = 13,
  /* add new sections here */
};

#endif /* INCLUDE__LIBARCH__DEBUG_H */
