#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Star merge tests
# Copyright © 2004 Canonical Limited
#	Authors: Robert Collins <robert.collins@canonical.com>
# Copyright © 2004 Aaron Bentley
# Copyright © 2003 Colin Walters
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "merge"

begin_test "Merging when MINE's latest REFERENCE revision is older"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline--1.1
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
tla commit -d hello-world -s "meaningless commit"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline--1.2
tla get jane@example.com--2003/hello-world--mainline--1.1 hello-world11
tla merge -d hello-world11 --reference jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mainline--1.2
end_test 

begin_test "Merging with 'crossed merges'"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--crossed--1.0
tla branch jane@example.com--2003/hello-world--crossed--1.0 jane@example.com--2003/hello-world--crossed-other--1.0
tla get jane@example.com--2003/hello-world--crossed--1.0 base
tla get jane@example.com--2003/hello-world--crossed-other--1.0 other
cd other
touch 1
tla add 1
tla commit -s 'add 1'
cd ../base
echo "garh" > README
touch 2
tla add 2
tla commit -s 'add 2'
tla merge jane@example.com--2003/hello-world--crossed-other--1.0--patch-1
tla commit -s 'merge from other'
cd ../other
tla merge jane@example.com--2003/hello-world--crossed--1.0--patch-1
tla commit -s 'merge from base'
tla merge jane@example.com--2003/hello-world--crossed--1.0--patch-2
tla commit -s 'merge from base after cross'
end_test

begin_test "Merging with 'crossed merges' two way"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--crossed-t--1.0
tla branch jane@example.com--2003/hello-world--crossed-t--1.0 jane@example.com--2003/hello-world--crossed-t-other--1.0
tla get jane@example.com--2003/hello-world--crossed-t--1.0 base
tla get jane@example.com--2003/hello-world--crossed-t-other--1.0 other
cd other
touch 1
tla add 1
tla commit -s 'add 1'
cd ../base
echo "garh" > README
touch 2
tla add 2
tla commit -s 'add 2'
tla merge --two-way jane@example.com--2003/hello-world--crossed-t-other--1.0--patch-1
tla commit -s 'merge from other'
cd ../other
tla merge --two-way jane@example.com--2003/hello-world--crossed-t--1.0--patch-1
tla commit -s 'merge from base'
# should conflict on 
#A   .arch-ids/2.id
#A   2
#A   {arch}/hello-world/hello-world--crossed-t/hello-world--crossed-t--1.0/jane@example.com--2003/patch-log/patch-1
#A   {arch}/hello-world/hello-world--crossed-t/hello-world--crossed-t--1.0/jane@example.com--2003/patch-log/patch-2
#C   README
tla merge --two-way --star-merge jane@example.com--2003/hello-world--crossed-t--1.0--patch-2 > ../merge-output || test $? = 1
file_matches '^A[[:space:]]*.arch-ids/2.id' ../merge-output
file_matches '^A[[:space:]]*2' ../merge-output
file_matches '^A[[:space:]]*\{arch\}/hello-world/hello-world--crossed-t/hello-world--crossed-t--1.0/jane@example.com--2003/patch-log/patch-2' ../merge-output
file_matches '^C[[:space:]]*README' ../merge-output
cd ..
end_test

begin_test "mesh merge hunks"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mesh-hunks--1.0
tla branch jane@example.com--2003/hello-world--mesh-hunks--1.0 jane@example.com--2003/hello-world--mesh-hunks-1--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks-1--1.0 1
cd 1
echo "garh" >> README
tla commit -s 'change README'
cd ..
tla branch jane@example.com--2003/hello-world--mesh-hunks--1.0 jane@example.com--2003/hello-world--mesh-hunks-2--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks-2--1.0 2
cd 2
tla merge jane@example.com--2003/hello-world--mesh-hunks-1--1.0
tla commit -s 'merge from 1'
cd ..
tla get jane@example.com--2003/hello-world--mesh-hunks--1.0 main
cd main
tla merge jane@example.com--2003/hello-world--mesh-hunks-1--1.0
tla commit -s 'integrate 1'
tla merge jane@example.com--2003/hello-world--mesh-hunks-2--1.0 
tla commit -s 'integrate 2'
file_matches 'garh' README
cd ..
end_test

begin_test "mesh merge hunks 2"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mesh-hunks2--1.0
tla branch jane@example.com--2003/hello-world--mesh-hunks2--1.0 jane@example.com--2003/hello-world--mesh-hunks2-1--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks2-1--1.0 1
cd 1
echo "garh" >> README
tla commit -s 'change README'
cd ..
tla branch jane@example.com--2003/hello-world--mesh-hunks2--1.0 jane@example.com--2003/hello-world--mesh-hunks2-2--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks2-2--1.0 2
cd 2
tla merge  jane@example.com--2003/hello-world--mesh-hunks2-1--1.0
tla commit -s 'merge from 1'
echo "foo" >> README
tla commit -s 'change README in -2'
cd ..
tla get jane@example.com--2003/hello-world--mesh-hunks2--1.0 main
cd main
tla merge jane@example.com--2003/hello-world--mesh-hunks2-1--1.0
file_matches 'garh' README
tla commit -s 'integrate 1'
tla merge --show-merge-points jane@example.com--2003/hello-world--mesh-hunks2-2--1.0 > ../merge-points
file_matches 'base: jane@example.com--2003/hello-world--mesh-hunks2-1--1.0--patch-1' ../merge-points || test_fail "Wrong base selected"
file_matches 'other: jane@example.com--2003/hello-world--mesh-hunks2-2--1.0--patch-2' ../merge-points
file_matches 'this: jane@example.com--2003/hello-world--mesh-hunks2--1.0--patch-1' ../merge-points
tla merge jane@example.com--2003/hello-world--mesh-hunks2-2--1.0
file_matches 'garh' README
file_matches 'foo' README
tla commit -s 'integrate 2'
cd ..
end_test
clean_workdir

begin_test "mesh merge hunks 3 - uncommitted merge"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--mesh-hunks3--1.0
tla branch jane@example.com--2003/hello-world--mesh-hunks3--1.0 jane@example.com--2003/hello-world--mesh-hunks3-1--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks3-1--1.0 1
cd 1
echo "garh" >> README
tla commit -s 'change README'
cd ..
tla branch jane@example.com--2003/hello-world--mesh-hunks3--1.0 jane@example.com--2003/hello-world--mesh-hunks3-2--1.0
tla get jane@example.com--2003/hello-world--mesh-hunks3-2--1.0 2
cd 2
tla merge  jane@example.com--2003/hello-world--mesh-hunks3-1--1.0
tla commit -s 'merge from 1'
echo "foo" >> README
tla commit -s 'change README in -2'
cd ..
tla get jane@example.com--2003/hello-world--mesh-hunks3--1.0 main
cd main
tla merge jane@example.com--2003/hello-world--mesh-hunks3-1--1.0
file_matches 'garh' README
tla merge --show-merge-points jane@example.com--2003/hello-world--mesh-hunks3-2--1.0 > ../merge-points
file_matches 'base: jane@example.com--2003/hello-world--mesh-hunks3-1--1.0--patch-1' ../merge-points || test_fail "Wrong base selected"
file_matches 'other: jane@example.com--2003/hello-world--mesh-hunks3-2--1.0--patch-2' ../merge-points
file_matches 'this: jane@example.com--2003/hello-world--mesh-hunks3--1.0--base-0' ../merge-points
tla merge jane@example.com--2003/hello-world--mesh-hunks3-2--1.0
file_matches 'garh' README
file_matches 'foo' README
tla commit -s 'integrate 2'
cd ..
end_test

begin_test "merge chooses a base with a strict-subset of changelogs from this and other"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--merge-changelog-subset-to--1.0
tla get jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0 from
#setup a branch to pull from
cd from
touch file1
tla add file1
tla commit -s 'add file 1'
touch file2
tla add file2
tla commit -s 'add file 2'
cd ..
tla get jane@example.com--2003/hello-world--merge-changelog-subset-to--1.0 to
cd to
tla replay jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0--patch-2
tla commit -s 'cherry pick patch-2'
tla merge --show-merge-points jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0 > ../merge-points
file_matches 'base: jane@example.com--2003/hello-world--mainline--1.0--patch-1' ../merge-points || test_fail "Wrong base selected"
file_matches 'other: jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0--patch-2' ../merge-points
file_matches 'this: jane@example.com--2003/hello-world--merge-changelog-subset-to--1.0--patch-1' ../merge-points
tla merge jane@example.com--2003/hello-world--merge-changelog-subset-from--1.0
cd ..
end_test

begin_test "Merging using --three-way"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--three-way-merge--1.1
tla get jane@example.com--2003/hello-world--mainline--1.0 hello-world
echo GARBAGE > hello-world/README
tla commit -d hello-world -s "meaningless commit"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--three-way-merge--1.2
tla get jane@example.com--2003/hello-world--three-way-merge--1.1 hello-world11
tla star-merge --star-merge -d hello-world11 --reference jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--three-way-merge--1.2
end_test 

begin_test "three way merge of files that are unrecognized in base but are recognized and allowed in other"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--merge-unrecognised--1.0
tla get jane@example.com--2003/hello-world--merge-unrecognised--1.0 foo
cd foo
cp \{arch\}/=tagging-method ../tagging
echo "unrecognized ^afile$" >> \{arch\}/=tagging-method
tla commit -s 'make afile unrecognized'
cp ../tagging \{arch\}/=tagging-method
echo "foo" > afile
tla add afile
tla commit -s 'add afile'
cd ..
tla get jane@example.com--2003/hello-world--merge-unrecognised--1.0--patch-1 bar
cd bar
tla apply-delta --three-way jane@example.com--2003/hello-world--merge-unrecognised--1.0--patch-{1,2} 
tla lint
tla status 
end_test

begin_test "three way merge with duplicates adds of symlinks to the same target"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--double-add-symlink--1.0
tla get jane@example.com--2003/hello-world--double-add-symlink--1.0 foo
cd foo
ln -s foo bar
tla add bar
tla commit -s 'add symlink bar'
# this should be a no-op.
tla apply-delta --three-way jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--double-add-symlink--1.0
tla lint
tla status 
end_test

begin_test "three way merge with id of an existing file added to a different path"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--double-add-id-other-path--1.0
tla get jane@example.com--2003/hello-world--double-add-id-other-path--1.0 foo
cd foo
touch bar
tla add bar
tla commit -s 'add bar'
tla mv bar gam
# this should be a conflict on bar
# leaving bar and gam both present
tla apply-delta --three-way jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--double-add-id-other-path--1.0 && test_fail "merge did not conflict"
tla lint && test_fail "tree is lint clean after conflict"
tla status && test_fail "tree has no status errors after conflict"
end_test

clean_workdir

# tag: 6f36ba8a-51ff-4b18-a729-849b1e861781
