/***************************************************************************
                         -- preferences.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "preferences.h"
#include "qstringlist.h"
#include "qstylefactory.h"
#include "qcombobox.h"

/* 
 *  Constructs a FormPreferences which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
FormPreferences::FormPreferences( QWidget* parent,  const char* name, WFlags fl )
    : FormPreferencesBase( parent, name, fl )
{

	// clear out our dropdown and load it up with all possible styles
	// that exist on the system
	cbStyleDropdown->clear();

	QStringList styles = QStyleFactory::keys();
	styles.sort();
	for ( QStringList::Iterator it = styles.begin(); it != styles.end(); ++it ) {
		QString style = *it;
		cbStyleDropdown->insertItem( trUtf8( style ));
	}
}

/*  
 *  Destroys the object and frees any allocated resources
 */
FormPreferences::~FormPreferences()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void FormPreferences::modified()
{
	changed();
}

