/***************************************************************************
                         -- keybindings.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include <stdlib.h>
#include <fstream>
#include <qfile.h>
#include <qtextstream.h>

#include "keybindings.h"

extern "C" class keybindings *maker(const QDict<QString> args) {
	return new class keybindings(0, "Plugin_Keybindings", args);
}

keybindings::keybindings(QObject *p, const char *n, const QDict<QString> args) : Plugin(p, n) {

	if (QString* loadfile = args["loadfile"] ) {
		m_configfile = expandTilde(loadfile->latin1());
	} else {
		m_configfile = getenv("HOME");
		m_configfile.append("/.bbkeysrc");
	}

	bindings = NULL;
	TreeNode<QWidget> *t = new TreeNode<QWidget>;
	t->setObject(keysconf_form = new KeysConf());
	connect(keysconf_form, SIGNAL(changed()), this, SLOT(setIsModified()));
	tree->insert(t);
	delete t;
	load();
}

keybindings::~keybindings() {
	if (bindings) delete bindings;
}

void keybindings::load() {
	if (bindings == NULL) {
		// open the rc file
		QFile f(m_configfile);

		// initialize the bindings dictionary -- regardless of
		// whether or not we have anything to pre-fill it with
		bindings = new QDict<QString>(41, false);
		bindings->setAutoDelete(true);
	
		if (!f.open(IO_ReadOnly))
			return;

		QTextStream stream(&f);	// use a text stream
		QString strLine;	// one line of the rc file
		while (!stream.eof()) {	// until end of file...
			// get a line of text excluding '\n'
			strLine = stream.readLine().simplifyWhiteSpace();
			if (strLine.at(4) == '#' || !strLine.contains("WithModifier", false))
				continue;
		
			QString key, mods, action, cmd;
			int keyB, modsB, actionB, cmdB;
			int keyE, modsE, actionE, cmdE;

			keyB = strLine.find('(', 0, true);
			keyE = strLine.find(')', keyB, true);
			modsB = strLine.find('(', keyE, true);
			modsE = strLine.find(')', modsB, true);
			actionB = strLine.find('(', modsE, true);
			actionE = strLine.find(')', actionB, true);
			
			key = strLine.mid(keyB + 1, keyE - keyB - 1);

			if (key.contains("iso_left_tab", false))
				key = "Tab";

			mods = strLine.mid(modsB + 1, modsE - modsB - 1);
			action = strLine.mid(actionB + 1, actionE - actionB - 1);
			
			QString *keys = new QString;
			keys->append(mods);
			keys->append("+");
			keys->append(key);
			keys->replace(QRegExp("None\\+"), "");	// take the "None" out
			// play with modifiers so kaccel likes it... *sigh*
			keys->replace(QRegExp("Mod1"),"Alt");
			keys->replace(QRegExp("Mod4"),"Meta");
			keys->replace(QRegExp("Control"),"Ctrl");

			/* if we're supposed to have an execCommand and we do have
			* something to put into it                               */
			if (strLine.contains("ExecCommand", false)) {
				cmdB = strLine.find('(', actionE, true);
				cmdE = strLine.find(')', cmdB, true);
				if (cmdB && cmdE) {
					cmd = strLine.mid(cmdB + 1, cmdE - cmdB - 1);
					keys->append("|");
					keys->append(cmd);
				}
			}
			bindings->insert(action, keys);
		}
		f.close();
	}

	keysconf_form->populateList(bindings);
	setIsModified(false);

}

bool keybindings::save() {
	clearSaveResources();
	saveResourceText("# bbkeys config file, automagically generated by bbconf.\n\n");
	
	if (!keysconf_form)
		return false;
	QListViewItemIterator it( keysconf_form->listview );
	
	// refresh our dictionary with saved changes
	bindings->clear();
	
	for ( ; it.current(); ++it ) {
		QString keycombo=it.current()->text(1);
		QString command =it.current()->text(0);
		QString bbcmd   =it.current()->text(2);

		int last_plus=keycombo.findRev("+",-1);

		QString key = keycombo.mid(last_plus +1, 20);
		QString mods = (last_plus > 0) ? keycombo.mid(0,last_plus) : (QString) "None";

		// return modifiers to what they will be interpreted as in bbkeys
		mods.replace(QRegExp("Alt"),"Mod1");
		mods.replace(QRegExp("Meta"),"Mod4");
		mods.replace(QRegExp("Ctrl"),"Control");

		if ( keycombo.length() ) {
			// stuff to reload our dictionary
			QString *keyline = new QString(keycombo);
			if ( bbcmd.contains("ExecCommand", false) ) {
				keyline->append("|");
				keyline->append(command);
			}
			bindings->insert(bbcmd, keyline);

			// now write our rc-file
			QString line = "KeyToGrab(";
			line.append(key);
			line.append("), WithModifier(");
			line.append(mods);
			line.append("), WithAction(");
			line.append(bbcmd);
			line.append(")");
			if (  bbcmd.contains("ExecCommand", false) ) {
				line.append(", DoThis(");
				line.append(command);
				line.append(")");
			}
			saveResourceText(line);
		}
	}
	bool saved = savedb(m_configfile);
	setIsModified(!saved);
	return saved;
}
