/***************************************************************************
                         -- keyconf.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef KEYSCONF_H
#define KEYSCONF_H
#include "keyconf_base.h"
#include <qlistview.h>
#include <qdict.h>

struct KeysList {
	QListViewItem* lvitem;
	uint keycode;
};

class KeysConf : public KeysConfBase
{ 
	Q_OBJECT

public:
	KeysConf( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KeysConf();
	void populateList(QDict<QString>*);

signals:
	void changed();

protected slots:
	void itemSelected(QListViewItem*);
	void itemClicked(QListViewItem*);
	void itemDoubleClicked(QListViewItem*);
	void opt_nokeys_checked();
	void opt_customkey_checked();
	void modified();
	void capturedKey(uint);

protected:
	bool isKeyPresent(int kcode, bool warnuser = true );
	void setKey( int kCode );

private:
	QListViewItem *CommandAddItem;
	QList<KeysList> lKeys;
	bool grabbing;
};

#endif // KEYSCONF_H
