/***************************************************************************
                         -- my_kaccel.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
/*
 * This file was hacked mercilessly by vanRijn in order to just be able to
 * use the KKeyButton class *sheesh*.  All other code was removed, and
 * aside from some small changes to remove kde dependencies on
 * kde-stuffies, not much has changed here....
*/

/* This file is part of the KDE libraries
    Copyright (C) 1997 Mark Donohoe <donohoe@kde.org>
    Copyright (C) 1997-2000 Nicolas Hadacek <hadacek@kde.org>
    Copyright (C) 1998 Matthias Ettrich <ettrich@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef _KACCEL_H
#define _KACCEL_H

#define stricmp qstricmp

#include <qmap.h>
#include <qstring.h>
#include <qaccel.h>
#include "kckey.h"

class QPopupMenu;
class QObject;
class QWidget;

class KKey {
protected:
	uint	m_keyCombQt;
public:
	KKey()					{ m_keyCombQt = 0; }
	KKey( const KKey& k )			{ m_keyCombQt = k.m_keyCombQt; }
	KKey( uint keyCombQt )			{ m_keyCombQt = keyCombQt; }
	KKey( const XEvent * );
	KKey( const QKeyEvent * );
	KKey( const QString& );

	KKey& operator =( KKey k )		{ m_keyCombQt = k.m_keyCombQt; return *this; }
	KKey& operator =( uint keyCombQt )	{ m_keyCombQt = keyCombQt; return *this; }

	uint key() const		{ return m_keyCombQt; }
	uint sym() const		{ return m_keyCombQt & 0xffff; }
	uint mod() const		{ return m_keyCombQt & ~0xffff; }
	uint state() const		{ return mod() >> 18; }

	QString toString();
};

/**
 * Accelerator information, similar to an action.
 *
 * It is used internally by @ref KAccel.
 * @internal
 */
struct KKeyEntry {
 public:
    int aCurrentKeyCode;
    int aDefaultKeyCode;		// For keyboards with no meta key
    //int aDefaultKeyCode4;		// For keyboards with meta key (4 modifiers)
    int aConfigKeyCode;
    bool bConfigurable;
    bool bEnabled;
    int aAccelId;
    const QObject *receiver;
    const char *member;
    QString descr;
    int menuId;

    void operator=(const KKeyEntry& e);
    KKeyEntry();
    KKeyEntry(const KKeyEntry& e);
};

class KAccel : public QAccel
{
 Q_OBJECT

 public:

	/**
	 * Create a KAccel object with a parent widget and a name.
	 */
	KAccel( QWidget * parent, const char *name = 0 );

	static bool qtSupportsMetaKey();

	/**
	 * Retrieve the key code corresponding to the string @p sKey or
	 * zero if the string is not recognized.
	 *
	 * The string must be something like "Shift+A",
	 * "F1+Ctrl+Alt" or "Backspace" for example. That is, the string
	 * must consist of a key name plus a combination of
	 * the modifiers Shift, Ctrl and Alt.
	 *
	 * N.B.: @p sKey must @em not be @ref i18n()'d!
	 */
	static int stringToKey( const QString& sKey );

	/**
	 * Retrieve a string corresponding to the key code @p keyCode,
	  * which is empty if
	 * @p keyCode is not recognized or zero.
	 */
	static QString keyToString( int keyCode, bool i18_n = FALSE );

	// X11-Related Functions
	// I want to move these functions out of KAccel and into their own
	//  class ASAP.
	// Naming Proceedure:
	//  -CodeX	the index of the physical key pressed (keyboard dependent)
	//  -Sym-	key symbol. Either unicode (like 'A') or special key (like delete)
	//  -Mod-	contains bits for modifier flags
	//  -X		Formatted for/by the X sever
	//  -Qt		Formatted for/by Qt
	//  keyQt	Qt shortcut key value containing both Qt Sym and Qt Mod.
	//  keyEvent-	An X or Qt key event
	// Example:
	//  keyCodeXToKeyQt() converts the X11 key code & mod into a Qt shortcut key
	enum ModKeysIndex {
		ModShiftIndex, ModCapsLockIndex, ModCtrlIndex, ModAltIndex,
		ModNumLockIndex, ModModeSwitchIndex, ModMetaIndex, ModScrollLockIndex,
		MOD_KEYS
	};
	static void readModifierMapping();
	static uint stringToKey( const QString& keyStr, uchar *pKeyCodeX, uint *pKeySymX, uint *pKeyModX );
	static uint keyCodeXToKeySymX( uchar keyCodeX, uint keyModX );
	static void keyEventXToKeyX( const XEvent *pEvent, uchar *pKeyCodeX, uint *pKeySymX, uint *pKeyModX );
	static uint keyEventXToKeyQt( const XEvent *pEvent );
	static int keySymXIndex( uint keySym );
	static void keySymXMods( uint keySym, uint *pKeyModQt, uint *pKeyModX );
	static uint keyCodeXToKeyQt( uchar keyCodeX, uint keyModX );
	static uint keySymXToKeyQt( uint keySymX, uint keyModX );
	static void keyQtToKeyX( uint keyCombQt, uchar *pKeyCodeX, uint *pKeySymX, uint *pKeyModX );
	static uint keyEventQtToKeyQt( const QKeyEvent* );
	static QString keyCodeXToString( uchar keyCodeX, uint keyModX, bool bi18n );
	static QString keySymXToString( uint keySymX, uint keyModX, bool bi18n );

	// Return the keyModX containing just the bit set for the given modifier.
	static uint keyModXShift();		// ShiftMask
	static uint keyModXLock();		// LockMask
	static uint keyModXCtrl();		// ControlMask
	static uint keyModXAlt();		// Normally Mod1Mask
	static uint keyModXNumLock();		// Normally Mod2Mask
	static uint keyModXModeSwitch();	// Normally Mod3Mask
	static uint keyModXMeta();		// Normally Mod4Mask
	static uint keyModXScrollLock();	// Normally Mod5Mask

	// Return the keyMod mask containing the bits set for the modifiers
	//  which may be used in accelerator shortcuts.
	static uint accelModMaskQt();		// Normally Qt::SHIFT | Qt::CTRL | Qt::ALT | (Qt::ALT<<1)
	static uint accelModMaskX();		// Normally ShiftMask | ControlMask | Mod1Mask | Mod3Mask

	// Returns true if X has the Meta key assigned to a modifier bit
	static bool keyboardHasMetaKey();

signals:
	void keycodeChanged();

 protected:
	int aAvailableId;
	bool bEnabled;
	bool bGlobal;
	QString aGroup;

 private:
};

#endif
