/***************************************************************************
                         -- menuedit.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "menuedit.h"
#include <stdlib.h>
#include <iostream>
#include <qlineedit.h>

extern "C" class menuedit *maker(const QDict<QString> args) {
	return new class menuedit(0, "Plugin_Menuedit", args);
}

menuedit::menuedit(QObject *p, const char *n, const QDict<QString> args) : Plugin(p, n) {

	if (QString* loadfile = args["loadfile"] ) {
		m_configfile = expandTilde(loadfile->latin1());
	}
	if (!m_configfile.length()) {
		// get the menu file from the .blackboxrc file
		XrmDatabase db;
		QString blackboxrc;
		blackboxrc = getenv ("HOME");
		blackboxrc.append("/.blackboxrc");
	
		db = XrmGetFileDatabase( blackboxrc );
		if ( db ) {
			XrmValue value;
			char *value_type;
	
			if (XrmGetResource(db, "session.menuFile", "Session.MenuFile", 
					&value_type, &value)) {
				m_configfile = expandTilde((const char *) value.addr);
			} 
		}
	}
	// if we can't find a menu file for our user, let's create him one
	// when he saves his menu....
	if (!m_configfile.length()) {
		m_configfile = getenv("HOME");
		m_configfile.append("/.blackbox/blackboxmenu");
	}
  
	menu = 0;

	TreeNode<QWidget> *t = new TreeNode<QWidget>;
	t->setObject(menu_form = new MenuEditor());
	connect(menu_form, SIGNAL(changed()), this, SLOT(setIsModified()));
	tree->insert(t);
	delete t;
	load();
}

menuedit::~menuedit() {
	if (menu)
		delete menu;
}

void menuedit::load() {
	if (!menu) {
	//parse menu
		menu = new TreeNode<menuitem>;
		QFile *file = openfile();
		if (file) {
			readfile(file);
			file->close();
		}
		delete file;
	}
	menu_form->loadMenu(menu);

	setIsModified(false);
}

void menuedit::savebranch(TreeNode<menuitem> *node) {
	if(!node->next())
		return;
	while(node->next()) {
		node = node->next();
		menuitem *item = node->object();
		QString type = menuitem::typeToText(item->type());
		QString label = item->description();
		QString data = item->data();
		QString str;
		if ( item->type() == menuitem::end )
			str = str.sprintf("[%s]", (const char*)type);

		else if ( item->type() == menuitem::nop || 
	    		item->type() == menuitem::config || 
	    		item->type() == menuitem::reconfig || 
	    		item->type() == menuitem::workspaces || 
	    		item->type() == menuitem::stylesdir || 
	    		item->type() == menuitem::begin || 
	    		item->type() == menuitem::exit ) 

			str = str.sprintf("[%s] (%s)", 
				(const char*)type, (const char*)label);
		else
			str = str.sprintf("[%s] (%s) {%s}", 
				(const char*)type, (const char*)label, (const char*)data);

		// if we're on an [end] item, back our indent up by one
		if (item->type() == menuitem::end )  
			indent.remove(0,1);

		saveResourceText(indent+str);

		// now set our indentation up for the next item to be written
		if (item->type() == menuitem::begin ||
				item->type() == menuitem::submenu ) 
			indent.append("\t");

		if(item->type() == menuitem::submenu) {
			savebranch(node->child());
		}
	}
}

bool menuedit::save() {
	if (menu) {
		menu->clear();
		delete menu;
	}
	menu = new TreeNode<menuitem>;

	// get the information out of the widgets and also update 'menu' with the info
	QListViewItem *p = menu_form->menuList->firstChild();
	loadMenuFromEditor(p, menu);

	clearSaveResources();

	saveResourceText("# blackbox menu, configured with style by bbconf\n");
	saveResourceText("[begin] ("+menu_form->titleText->text()+")");

	indent = "\t";

	savebranch(menu);
	bool saved = false;
	if (!m_configfile.isNull())
		saved = savedb(m_configfile);

	setIsModified(!saved);

	return saved;
}

int menuedit::getLineType(QString *line) {
	if (line->isEmpty()) {
		return menuitem::blank;
	}
	if (line->startsWith("[begin]")) {
		line->remove(0,7);
		return menuitem::begin;
	}
	if (line->startsWith("[end]")) {
		line->remove(0,5);
		return menuitem::end;
	}
	if (line->startsWith("[nop]")) {
		line->remove(0,5);
		return menuitem::nop;
	}
	if (line->startsWith("[exec]")) {
		line->remove(0,6);
		return menuitem::exec;
	}
	if (line->startsWith("[exit]")) {
		line->remove(0,6);
		return menuitem::exit;
	}
	if (line->startsWith("[config]")) {
		line->remove(0,7);
		return menuitem::config;
	}
	if (line->startsWith("[include]")) {
		line->remove(0,9);
		return menuitem::include;
	}
	if (line->startsWith("[submenu]")) {
		line->remove(0,9);
		return menuitem::submenu;
	}
	if (line->startsWith("[restart]")) {
		line->remove(0,9);
		return menuitem::restart;
	}
	if (line->startsWith("[reconfig]")) {
		line->remove(0,10);
		return menuitem::reconfig;
	}
	if (line->startsWith("[style]")) {
		line->remove(0,7);
		return menuitem::style;
	}
	if (line->startsWith("[stylesdir]")) {
		line->remove(0,11);
		return menuitem::stylesdir;
	}
	if (line->startsWith("[stylesmenu]")) {
		line->remove(0,12);
		return menuitem::stylesmenu;
	}
	if (line->startsWith("[workspaces]")) {
		line->remove(0,12);
		return menuitem::workspaces;
	}
	return -1;
}

QString *menuedit::getLineData(QString *line) {
	QString *ret = new QString(*line);
	int datastart = ret->find("{");
	if (datastart < 0)
		return new QString("");
	ret->remove(0, datastart+1);
	int labelend = ret->find("}");
	ret->remove(labelend, ret->length());
	line->remove(0, labelend+1);
	return ret;
}

QString *menuedit::getLineLabel(QString *line) {
	QString *ret = new QString(*line);
	int datastart = ret->find("(");
	if (datastart < 0)
		return new QString("");
	ret->remove(0, datastart+1);
	int labelend = ret->find(")");
	ret->remove(labelend, ret->length());
	line->remove(0, labelend+1);
	return ret;
}

menuitem *menuedit::getMenuItem(QString *line) {
	int type = getLineType(line);
	QString *label = getLineLabel(line);
	QString *data = getLineData(line);
	if (type == -1)
		return 0;
	return new menuitem(label, data, (menuitem::types)type);
}

QFile *menuedit::openfile() {

	if (m_configfile != "") {
		// open the menu file
		QFile *file = new QFile(m_configfile);
		if (file->open(IO_ReadOnly))
			return file;
		delete file;
	}

	return 0;
}
	
void menuedit::readfile(QFile *file) {
	QTextStream *stream = new QTextStream(file);
	readmenu(stream, menu);
	delete stream;
}

void menuedit::readmenu(QTextStream *stream, TreeNode<menuitem> *node) {
	while (!stream->atEnd()) {
		QString line = stream->readLine();
		line = line.simplifyWhiteSpace();
		// cout << "line->" << line << "<-\n";
		if (line.startsWith("#"))	// comment
			continue;
		menuitem *item = getMenuItem(&line);
		if (item) {
			if(item->type() == menuitem::submenu) {
				/*
				printf("[submenu] (%s) {%s}\n", 
					(const char*)item->description(),
					(const char*)item->data() );
				*/
				TreeNode<menuitem> *nnode = new TreeNode<menuitem>;
				nnode->setObject(item);
				node = node->insert(nnode, false);
				readmenu(stream, node->child());
			} else if(item->type() == menuitem::blank) {
				delete item;
			} else {
				/*
				printf("[%s] (%s) {%s}\n", 
					(const char*)menuitem::typeToText(item->type()), 
					(const char*)item->description(), 
					(const char*)item->data() );
				*/
				TreeNode<menuitem> *nnode = new TreeNode<menuitem>;
				nnode->setObject(item);
				node = node->insert(nnode, false);
			}
		}
	}
}

void menuedit::loadMenuFromEditor(QListViewItem *p, TreeNode<menuitem> *node) {
	if (!p)
		return;
	while (p) {
		QString *desc = new QString(p->text(0));
		QString *data = new QString(p->text(2));
		bool ok;
		int iType = p->text(1).toInt(&ok);

		// if we have a submenu but no children, skip it
		if (iType == menuitem::submenu && (p->childCount() <= 0) ) {
			p = p->nextSibling();
			continue;
		}
		menuitem *item = new menuitem(desc, data, (menuitem::types) iType);

		/*
		printf("[%s] (%s) {%s}\n", 
			(const char*)menuitem::typeToText(item->type()), 
			(const char*)item->description(), 
			(const char*)item->data() );
		*/

		if (item) {
			TreeNode<menuitem> *nnode = new TreeNode<menuitem>;
			if (nnode) {
				nnode->setObject(item);
				node = node->insert(nnode, false);

				if(item->type() == menuitem::submenu ) {
					if (p->childCount() ) {
						p = p->firstChild();
						loadMenuFromEditor(p, node->child());
						p = p->parent();
					} 
				}
			}
		}
		p = p->nextSibling();

	}
	
	// add on the [end]
	menuitem *item = new menuitem(new QString(""),new QString(""), menuitem::end);
	if (item) {
		TreeNode<menuitem> *nnode = new TreeNode<menuitem>;
		nnode->setObject(item);
		node = node->insert(nnode, false);
	}
}
