/***************************************************************************
                         -- menuitem.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "menuitem.h"

menuitem::menuitem() {
	m_description = 0;
	m_data = 0;
	m_type = nop;
}

menuitem::menuitem(QString *description, QString *data, types type) {
	m_description = 0;
	m_data = 0;
	m_type = nop;
	if (description && data)
		set(description, data, type);
	else
		set(0, 0, nop);
}

menuitem::~menuitem() {
}
#include <stdio.h>
void menuitem::set(QString *description, QString *data, types type) {
	if (description && data) {
		m_type = type;
		if (m_description)
			delete m_description;
		m_description = new QString(*description);
		if (m_data)
			delete m_data;
		m_data = new QString(*data);
	}
	if (description)
		delete description;
	if (data)
		delete data;
}

QString menuitem::typeToText(const types type) {
	switch (type) {
	case nop:
		return "nop";
	case exec:
		return "exec";
	case style:
		return "style";
	case config:
		return "config";
	case include:
		return "include";
	case submenu:
		return "submenu";
	case stylesdir:
		return "stylesdir";
	case stylesmenu:
		return "stylesmenu";
	case restart:
		return "restart";
	case reconfig:
		return "reconfig";
	case workspaces:
		return "workspaces";
	case exit:
		return "exit";
	case blank:
		return "blank";
	case begin:
		return "begin";
	case end:
		return "end";
	default:
		return "unknown";
	}
}

