/***************************************************************************
                         -- font.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef FONT_HH
#define FONT_HH

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qcombobox.h>


class FontSelector : public QWidget {
	Q_OBJECT
public:
	FontSelector( QWidget *parent=0, const char *name=0 );
	~FontSelector();
	void setFont( QString f)      
	    { lineedit->setText( f ) ; lineedit->setCursorPosition(0);};
	void  setJustify (int i)      { justify->setCurrentItem( i ); } ;
	QString getFontString() const { return lineedit->text(); } ;
	QString getJustify() const    { return justify->currentText(); } ;


public slots:
	void doFontSelect();

protected slots:
	void modified();

signals:
	void changed();

private:
	QPushButton *button;
	QComboBox   *justify;
	QLineEdit		*lineedit;
};

#endif
