/***************************************************************************
                         -- tbwidg_textcolor.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "tbwidg_textcolor.h"
#include "color.h"
#include "font.h"
#include <qcombobox.h>

/* 
 *  Constructs a TWText which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
TWText::TWText( QWidget* parent,  const char* name, WFlags fl )
    : TWTextBase( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
TWText::~TWText()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void TWText::modified()
{
	changed();
}

void TWText::texture_changed(const QString& t)
{
	bool e = t.contains("Gradient") ? true : false;

	color_to->setEnabled(e);
	gradient->setEnabled(e);
}

void TWText::setFullTexture(QString& t)
{
	if ( t.contains ("parentrelative", false) ) {
		setTexture(PARENTRELATIVE);
	} else if ( t.contains ("solid", false) ) {
		setTexture(SOLID);
	} else {
		setTexture(GRADIENT);
	}

	if (t.contains("sunken",false)) {
		setTextureHeight(SUNKEN);
	} else if (t.contains("flat",false)) {
		setTextureHeight(FLAT);
	} else {
		setTextureHeight(RAISED);
	}

	if (t.contains("bevel1",false)) {
		setBevel(BEVEL1);
	} else {
		setBevel(BEVEL2);
	}

	if (t.contains("interlaced",false)) {
		setInterlaced(true);
	} else {
		setInterlaced(false);
	}

	if (t.contains( "horizontal",false))
		setGradient(HORIZONTAL);
	else if (t.contains( "vertical", false))
		setGradient(VERTICAL);
	else if (t.contains("crossDiagonal", false))
		setGradient(CROSSDIAGONAL);
	else if (t.contains("diagonal", false))
		setGradient(DIAGONAL);
	else if (t.contains("rectangle", false))
		setGradient(RECTANGLE);
	else if (t.contains("pyramid", false))
		setGradient(PYRAMID);
	else if (t.contains("pipeCross", false))
		setGradient(PIPECROSS);
	else if (t.contains("elliptic", false))
		setGradient(ELLIPTIC);

}

QString TWText::getFullTexture()
{
	QString s;
	
	QString s1 = getTextureHeight();
	QString s2 = getBevel();
	QString s3 = getTexture(); 
	QString s4 = getGradient();

	if ( s3.contains ("parentrelative", false) ) {
		s = "parentrelative";
	} else if ( s1.contains ("flat", false) ) {
		s.sprintf( "%s %s %s", 
				s1.latin1(), s3.latin1(), s4.latin1() );
	} else {
		s.sprintf( "%s %s %s %s", 
				s1.latin1(), s2.latin1(), s3.latin1(), s4.latin1() );
	} 
	
	if( getInterlaced() )
		s.append( " Interlaced" );

	return s;
}

