/***************************************************************************
                         -- win.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <qheader.h>
#include <qvariant.h>
#include <qdialog.h>
#include <qwidgetstack.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtextview.h>
#include "map.h"
#include "plugin.h"
class QVBoxLayout; 
class QHBoxLayout; 
class QListView;
class QListViewItem;
class QPushButton;

class MainWindow : public QWidget
{ 
	Q_OBJECT

public:
  MainWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~MainWindow();

  QPushButton *ButtonApply;
  QPushButton *ButtonReset;
  QPushButton *ButtonHelp;
  QListView *ListView1;
	QWidgetStack *WidgetStack1;

public slots:
	void setPlugins(QList<plugin>*, QString &start_plugin);
	void reset();
	bool apply();

protected slots:
  void changeFrame(QListViewItem*);
  void help();
	void promptSaveForget();
	bool showSaveFailed(QString);
	void widgetChanging(QWidget*);

protected:
	void closeEvent(QCloseEvent*);
  QHBoxLayout *LayoutButtons;
	QHBoxLayout *LayoutMain;
	QVBoxLayout *LayoutDialog;

private:
	void addChildren(TreeNode<QWidget>*, QListViewItem*, plugin*);
	void addPluginWidget(QWidget*, plugin*);
	bbc_map<QListViewItem*, TreeNode<QWidget>*> *listmap;
	bbc_map<QWidget*, plugin*> *pluginmap;
	plugin *visiblePlugin;
};

#endif // MAINWINDOW_H
