(**************************************************************************)
(*                                BELENIOS                                *)
(*                                                                        *)
(*  Copyright © 2012-2020 Inria                                           *)
(*                                                                        *)
(*  This program is free software: you can redistribute it and/or modify  *)
(*  it under the terms of the GNU Affero General Public License as        *)
(*  published by the Free Software Foundation, either version 3 of the    *)
(*  License, or (at your option) any later version, with the additional   *)
(*  exemption that compiling, linking, and/or using OpenSSL is allowed.   *)
(*                                                                        *)
(*  This program is distributed in the hope that it will be useful, but   *)
(*  WITHOUT ANY WARRANTY; without even the implied warranty of            *)
(*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *)
(*  Affero General Public License for more details.                       *)
(*                                                                        *)
(*  You should have received a copy of the GNU Affero General Public      *)
(*  License along with this program.  If not, see                         *)
(*  <http://www.gnu.org/licenses/>.                                       *)
(**************************************************************************)

let lang = "fr"
let start = "Commencer"
let advanced_mode = "Mode avancé"
let see_accepted_ballots = "Voir les bulletins acceptés"
let belenios_booth = "Isoloir Belenios"
let here = "ici"
let question_header = "Sélectionnez entre %d et %d réponse(s)"
let at_least = "Vous devez sélectionner au moins %d réponse(s)"
let at_most = "Vous devez sélectionner au plus %d réponse(s)"
let previous = "Précédent"
let next = "Suivant"
let nothing = "(rien)"
let enter_cred = "Veuillez entrer votre code de vote :"
let invalid_cred = "Code de vote invalide !"
let input_credential = "Saisie du code de vote"
let answer_to_questions = "Réponse aux questions"
let warning_0_255 = "Attention: le système accepte n'importe quel nombre entre 0 et 255 mais, selon les règles de l'élection, les bulletins invalides (score trop élevé ou candidats pas classés correctement) seront rejetés à la fin de l'élection."
let alert_0_255 = "La valeur doit être un entier entre 0 et 255."
let at_least_one_invalid = "Au moins une des réponses est incorrecte !"
let review_and_encrypt = "Récapitulatif et chiffrement"
let authenticate = "Authentification"
let confirm = "Confirmation"
let done_ = "Terminé"
let booth_step1 = "Étape 1/6 : Saisie du code de vote"
let booth_step2 = "Étape 2/6 : Réponse aux questions"
let booth_step3 = "Étape 3/6 : Récapitulatif et chiffrement"
let booth_step5 = "Étape 5/6 : Confirmation"
let booth_step6 = "Étape 6/6 : "
let input_your_credential = "Saisissez votre code de vote "
let wait_while_encrypted = "Veuillez patienter, le chiffrement de votre bulletin est en cours..."
let encrypting = "Chiffrement en cours..."
let restart = "Recommencer"
let successfully_encrypted = "Votre bulletin a été chiffré avec succès, "
let not_cast_yet = "mais n'a pas encore été déposé dans l'urne"
let qmark = " !"
let your_tracker_is = "Votre numéro de suivi est "
let we_invite_you_to_save_it = "Nous vous invitons à le sauvegarder afin de vérifier ultérieurement que votre vote est bien pris en compte"
let continue = "Continuer"
let election_uuid = "UUID de l'élection : "
let election_fingerprint = "Empreinte de l'élection : "
let i_am = "Je suis "
let and_ = " et "
let i_cast_my_vote = "je dépose mon bulletin dans l'urne"
let please_login_to_confirm = "Veuillez vous connecter pour confirmer votre vote"
let your_ballot_for = "Votre bulletin pour "
let has_been_received = " a été reçu, mais pas encore pris en compte. "
let nobody_can_see = "Note: votre bulletin est chiffré et personne ne peut voir son contenu."
let you_have_already_voted = "Note: vous avez déjà voté. Votre vote va être remplacé."
let go_back_to_election = "Retourner à la page d'accueil de l'élection"
let has_been_accepted = " a été accepté."
let you_can_check_its_presence = "Vous pouvez vérifier sa présence dans l'"
let ballot_box = "urne"
let anytime_during_the_election = " à tout moment pendant l'élection."
let confirmation_email = " Un e-mail de confirmation vous a été envoyé."
let thank_you_for_voting = "Merci pour votre participation !"
let is_rejected_because = " est refusé, parce que "
let fail = "ÉCHEC !"
let administer_elections = "Administrer des élections"
let administer_this_election = "Administrer cette élection"
let powered_by = "Propulsé par "
let get_the_source_code = "Obtenir le code source"
let audit_data = "Données d'audit : "
let parameters = "paramètres"
let public_credentials = "clés de vérification"
let ballots = "bulletins"
let election_server = "Serveur d'élections"
let accepted_ballots = "Bulletins acceptés"
let ballots_have_been_accepted_so_far = " bulletin(s) ont été accepté(s) jusqu'à présent."
let ballots_have_been_accepted = " bulletin(s) ont été accepté(s)."
let ballots_have_been_accepted_and = " bulletin(s) ont été accepté(s), et "
let have_been_tallied = " ont été compté(s)."
let username = "Nom d'utilisateur :"
let password = "Mot de passe :"
let login = "Se connecter"
let password_login = "Connexion par mot de passe"
let by_using_you_accept = "En utilisant ce site, vous acceptez notre "
let privacy_policy = "politique concernant les données personnelles"
let privacy_policy_short = "Politique de confidentialité"
let accept = "Accepter"
let not_yet_open = "Désolé, cette élection n'est pas encore ouverte"
let come_back_later = "Cette élection n'existe pas encore. Veuillez revenir plus tard."
let cookies_are_blocked = "Les cookies sont bloqués"
let please_enable_them = "Votre navigateur semble bloquer les cookies. Veuillez les activer."
let election_currently_closed = "Cette élection est actuellement fermée."
let election_closed_being_tallied = "L'élection est fermée et en cours de dépouillement."
let election_has_been_tallied = "Cette élection a été dépouillée."
let election_archived = "Cette élection est archivée."
let number_accepted_ballots = "Nombre de bulletins acceptés : "
let you_can_also_download = "Vous pouvez également télécharger le "
let result_with_crypto_proofs = "résultat avec les preuves cryptographiques"
let the_raw_results = "Les résultats bruts peuvent être consultés dans le "
let json_result = "résultat JSON"
let it_contains_all_clear = ". Il contient tous les bulletins soumis en clair, dans un ordre aléatoire. C'est à vous d'appliquer votre méthode de comptage favorite (par exemple Condorcet, STV, jugement majoritaire)."
let blank_vote = "Vote blanc"
let no_other_blank = "Vous ne pouvez pas sélectionner d'autres choix lors d'un vote blanc"
let it_will_open_in = "Elle ouvrira dans "
let the_election_will_close_in = "L'élection fermera dans "
let years = " année(s)"
let months = " mois"
let days = " jour(s)"
let hours = " heure(s)"
let minutes = " minute(s)"
let seconds = " seconde(s)"
let result_currently_not_public : ('a, 'b, 'c, 'd, 'e, 'f) format6 = "Le résultat de cette élection n'est actuellement pas public. Il le sera dans %s."


let mail_password_subject : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "Votre mot de passe pour l'élection %s"

let mail_password : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "Vous êtes enregistré(e) en tant qu'électeur(trice) pour l'élection

  %s

Veuillez trouver ci-dessous votre nom d'utilisateur et votre mot de
passe. Pour soumettre un bulletin, vous aurez également besoin d'un
code de vote, envoyé dans un e-mail séparé. Soyez attentif(ve), le mot
de passe et le code de vote se ressemblent mais jouent des rôles
différents. Le système vous demandera votre code de vote dès l'entrée
dans l'isoloir virtuel. Le nom d'utilisateur et le mot de passe sont
nécessaires lorsque votre bulletin est prêt à être soumis.

Nom d'utilisateur : %s
Mot de passe : %s
Page de l'élection : %s

Notez que vous pouvez voter plusieurs fois. Seul le dernier vote est
pris en compte.%s"


let mail_credential_subject : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "Votre code de vote pour l'élection %s"

let mail_credential : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "Vous êtes enregistré(e) en tant qu'électeur(trice) pour l'élection

  %s

%s

Code de vote : %s
Page de l'élection : %s

Notez que vous pouvez voter plusieurs fois. Seul le dernier vote est
pris en compte.%s"

let mail_credential_password =
"Veuillez trouver ci-dessous votre code de vote. Pour soumettre un
bulletin, vous aurez également besoin d'un mot de passe, envoyé dans
un e-mail séparé. Soyez attentif(ve), le mot de passe et le code de
vote se ressemblent mais jouent des rôles différents. Le système vous
demandera votre code de vote dès l'entrée dans l'isoloir virtuel. Le
nom d'utilisateur et le mot de passe sont nécessaires lorsque votre
bulletin est prêt à être soumis."

let mail_credential_cas =
"Veuillez trouver ci-dessous votre code de vote."

let mail_confirmation_subject : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "Votre vote pour l'élection %s"

let mail_confirmation : ('a, 'b, 'c, 'd, 'e, 'f) format6 =
  "%s,

Votre vote pour l'élection

  %s

a été enregistré. Votre numéro de suivi est

  %s%s


Vous pouvez vérifier sa présence dans l'urne, accessible au
  %s

Les résultats seront publiés sur la page de l'élection
  %s%s

-- \nBelenios"

let this_vote_replaces = "\n\nCe vote remplace le vote précédent."
let please_contact = "Pour obtenir plus d'informations, veuillez contacter :"

let error_Serialization : ('a, 'b, 'c, 'd, 'e, 'f) format6 = "votre bulletin a une erreur de syntaxe (%s)"
let error_ProofCheck = "certaines preuves sont invalides"
let error_ElectionClosed = "l'élection est fermée"
let error_MissingCredential = "un code de vote manque"
let error_InvalidCredential = "votre code de vote est invalide"
let error_RevoteNotAllowed = "vous n'êtes pas autorisé(e) à revoter"
let error_ReusedCredential = "votre code de vote a déjà été utilisé"
let error_WrongCredential = "vous n'êtes pas autorisé(e) à voter avec ce code de vote"
let error_UnauthorizedVoter = "vous n'êtes pas autorisé(e) a voter"
