/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_GenerateRandom()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_BYTE buf[20];
	CK_RV rv;

	printf("C_GenerateRandom\n");

	printf("  Cat 1\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_GenerateRandom(12345, buf, sizeof(buf)) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_GenerateRandom(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	session = getSessionInFirstSlot();

	if (p11->C_GenerateRandom(session, buf, sizeof(buf)) != CKR_OK) {
		printf("    ERR: C_GenerateRandom(2) didn't return CKR_OK\n");
		errors++;
	}

	if (p11->C_CloseSession(session) != CKR_OK) {
		printf("    ERR: C_CloseSesssion(3) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_GenerateRandom(session, buf, sizeof(buf)) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_GenerateRandom(3) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	printf("  Cat 2\n");

	session = getSessionInFirstSlot();

	if (p11->C_SeedRandom(session, buf, sizeof(buf)) != CKR_OK) {
		printf("    ERR: C_SeedRandom(1) didn't return CKR_OK\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_SeedRandom(session, buf, sizeof(buf)) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_SeedRandom(2) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
