// LongToObjectCollection.h: interface for the CLongToObjectCollection class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#ifndef __LONGTOOBJECTCOLLECTION__ 
#define __LONGTOOBJECTCOLLECTION__ 
 
#include "../../Include/Base/platform.h" 
 
#include "../../Include/Base/Object.h" 
 
class CLongToObjectCollection : public CObject 
{ 
    public: 
    	CLongToObjectCollection(); 
    	virtual ~CLongToObjectCollection(); 
     
    	void Add (long key, CObject *object);	// Add an Object 
    											// If the key already exist, the previous 
    											// Object reference is overwriten 
     
    	CObject *GetFirst (ULONG32 *firstPosition);	// If position == 0, no object found 
    												// return NULL; 
    	CObject *GetFirst (ULONG32 *firstPosition, long *key);	// If position == 0, no object found 
    												// return NULL; 

    	CObject *GetNext (ULONG32 *nextPosition);	// If position == 0, no more object 
    												// If return == NULL, no object found 
    	CObject *GetNext (ULONG32 *nextPosition, long *key);	// If position == 0, no more object 
    												// If return == NULL, no object found 
     
    	CObject *Lookup (long key);		// Get Object for a specific key 
     
    	BOOL Remove (long key);		// Remove based on key 
    	BOOL Remove (CObject *object);	// Remove based on Object 
    	BOOL RemoveAll (void);			// Remove all entries, but doesn't delete the Objects 
     
    	BOOL IsEmpty (void);			// Check if the collection is empty 
     
    	ULONG32 GetCount (void); 
     
    protected: 
     
    	struct __LongToObjectCollectionElement 
    	{ 
    		long key; 
    		CObject *object; 
    		ULONG32 position; 
    		struct __LongToObjectCollectionElement *next; 
    	}; 
     
    private: 
     
    	void **m_pPositionArray; //Begin with 100 positions, expanded when needed 
     
    	ULONG32 m_ul32MaxObject; 
    	ULONG32 m_ul32ObjectCount; 
     
    	__LongToObjectCollectionElement *m_pCollectionTop; 
    	__LongToObjectCollectionElement *m_pCollectionBottom; 
    }; 
     
#endif // __LONGTOOBJECTCOLLECTION__ 
