// Object.h: interface for the CObject class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#ifndef __OBJECT__ 
#define __OBJECT__ 
   
// platform specific declaration     
#include "../../Include/Base/platform.h" 
 
#ifdef _WIN32 
#include <windows.h> 
#include <stdio.h> 
#endif // _WIN32 

class CLoggerManager;
 
#define PASS_GET_OBJECTMANAGER CObjectManager::Instance();
 
       	typedef void* PASS_POSITION; 
     
        struct SerializedObject  
        { 
        	unsigned long nameSize; 
        	char *name; 
        	unsigned long typeSize; 
        	char *type; 
        	unsigned long serializedObjectSize; 
        	BYTE *serializedObject; 
        }; 
         
        class PASS_CLASS_OBJECT   
        { 
        public: 
        	CObject(); 
        	CObject(char *name, char *type); 
        	CObject(char *name); 
        	virtual ~CObject(); 

			void Init (void);
         
        	char *GetName (void); 
        	void SetName (char *); 
         
        	char *GetType (void); 
        	void SetType (char *); 
         
        	virtual CObject* Clone (void); 
        	virtual CObject* Copy (void); 
        	virtual BOOL Serialize (void); 
        	virtual BOOL UnSerialize (struct SerializedObject*); 
        	virtual struct SerializedObject* GetSerializedObject (void); 
         
        	virtual void Release(void); 
         
        	void SetID (unsigned long); 
        	unsigned long GetID (void); 
         
        	BOOL CanBeDeleted (void); 
         
        	void SetSerialMultiPass (void); 
        	void SetSerialMultiPassCount (void); 
        	void SetSerialMultiPassFill (void); 
        	void ResetSerialMultiPass (void); 
         
        	BOOL AddULongToSerialObject (unsigned long value,SerializedObject *anObject);
        	BOOL AddCharToSerialObject (char *value,SerializedObject *anObject);
        	BOOL AddBytesToSerialObject (BYTE *value,unsigned long size,SerializedObject *anObject);
        	char *GetCharFromSerialObject (SerializedObject *anObject);
        	unsigned long GetBytesFromSerialObject (BYTE **value,SerializedObject *anObject);
        	unsigned long GetULongFromSerialObject (SerializedObject *anObject);

			// Object debug and dump
			char *Description (void);
			void CreateDescription (void);

		protected:

			void AddToDescription (CObject *object, char *format, ...);

			void Trace (char *file, int line, unsigned long mask, char *format, ...);
         
        public: 
         
        	BOOL m_bCanBeDeleted;
         
        protected: 
         
        	struct SerializedObject* serializedObject; 
        	char *m_sName; 
        	char *m_sType; 
			char *m_szDescriptionBuffer;
         
        private: 
         
        	unsigned long ID; 
        	BOOL m_bSerialMultiPass; 
        	BOOL m_bSerialMultiPassCount; 
        	BOOL m_bSerialMultiPassFill; 
        	unsigned long m_bSerialMultiPassFillOffset; 
        	BOOL m_bSerialMultiPassObjectAllocated; 

			CLoggerManager *m_Logger;
        }; 
         
#endif // __OBJECT__
