    // ObjectStack.h: interface for the CObjectStack class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
    #ifndef __OBJECTSTACK__ 
    #define __OBJECTSTACK__ 
     
    #include "../../Include/Base/platform.h" 
  
  #include "../../Include/Base/Object.h" 
     
    class CObjectStack : public CObject   
    { 
    public: 
    	CObjectStack(); 
    	virtual ~CObjectStack(); 
     
    	void PutObject (CObject *anObject); 
    	BOOL IsObjectAvailable (void); 
    	CObject *GetObject (void); 
    	CObject *PeekObject (void); 
     
    protected: 

		PASS_SYNCH lock;     
		     
    	struct __ObjectStackElement  
    	{ 
    		CObject *object; 
    		__ObjectStackElement *next; 
    	}; 
     
    	__ObjectStackElement *m_StackTop; 
    	__ObjectStackElement *m_StackBottom; 
     
    	unsigned long m_ulMessageCount; 
    }; 
     
    #endif // __OBJECTSTACK__ 
