    // ConnectionSocket.h: interface for the CConnectionSocket class.
    //
    //////////////////////////////////////////////////////////////////////
    
#ifndef __CONNECTIONSOCKET_
#define __CONNECTIONSOCKET__
 
// Platform specific definitions
#include "../Base/platform.h"

#ifdef linux
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif //linux

#ifdef __SCO__
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
  #include <errno.h>
#endif // __SCO__

#ifdef __HPUX__
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif // __HPUX__

#include "../../Include/Base/Thread.h"

#ifdef PASS_SSL
    #include <openssl/ssl.h>
#endif //PASS_SSL
    
    class CMessageStack;
    class CConnection;
    class CServerSession;
	class CMessage;
    
    class CConnectionSocket : public CThread
    {
    public:
    	CConnectionSocket();
    	CConnectionSocket(int newConnFd, struct sockaddr_in newConnAddr);
    	virtual ~CConnectionSocket();
    
        struct sockaddr_in *GetSockAddr(void);

    	void PreRun (void);
    	void PostRun (void);
    
    	virtual void Tick (void);
    
    	void SetStack (CMessageStack *aStack);
    	void SetReceiveStack (CMessageStack *aStack);
    	void SetSendStack (CMessageStack *aStack);
    	void SetConnection (CConnection *aConnection);
    	void SetServerSession (CServerSession *aSession);

		void Close (void);
   
		int Readn (int fd, void *vptr, size_t n);
		int Writen (int fd,const void *vptr, int n);
 
#ifdef PASS_SSL
    	// SSL
    	void SetSecuredConnection (BOOL flag);
    	void SetSSLSSL (SSL* ssl);
    	void SetCertificateFile (char *file);
#endif //PASS_SSL

	protected:
		void ReadMessageFromSocket (void);
		BOOL SendSerializedObject (struct SerializedObject *anObject);

    private:
    
    	int m_NewConnFd;
    	struct sockaddr_in m_NewConnAddr;
    	BOOL m_bCloseFlag;
    	CMessageStack *m_ReceiveStack;
    	CMessageStack *m_SendStack;
		CMessage *m_CurrentMessage;

		BOOL m_bMessageReadError;
		BOOL m_bMessageReadOK;
		BOOL m_bSocketClosing;
    	int compt;
    	CConnection *m_ParentConnection;
    	CServerSession *m_ServerSession;
    
#ifdef PASS_SSL
    	// SSL
    	BOOL m_bSecuredConnection;
    	SSL*     m_SSLssl;
    	char *m_szCertificateFile;
#endif //PASS_SSL
    };
    
#endif // __CONNECTIONSOCKET__
