// Connection_Dual.h: interface for the CConnection_Dual class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __CONNECTION_DUAL__
#define __CONNECTION_DUAL__


// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Comm/Connection.h"

#ifdef PASS_SSL
#include <openssl/ssl.h>
#endif //PASS_SSL
        
class CMessage;
class CMessageStack;
class CConnectionSender;
class CConnectionSocket;
class CConnectionListener;
class CServerSession;
        
class CConnection_Dual : public CConnection
{
        public:
        	CConnection_Dual();
        	virtual ~CConnection_Dual();
        
        	void Tick (void);
        
        	void SetSendPort (unsigned short);
        	void SetServerIP (char *);
        	void SetBackIP (char *);
        	void SetServerName (char *);
        
        	void SetReceivePort (unsigned short);
        
        	BOOL StartSender (void);
        	BOOL StartReceiver (void);
        
        	BOOL StopSender (void);
        	BOOL StopReceiver (void);
        
        	BOOL Open (void);
        	BOOL Close (void);
        
        	BOOL SendObject (CObject *);
        	unsigned long SendMessage (CMessage *);
        
        	CMessageStack *GetReceiveStack (void);
        	CMessageStack *GetSendStack (void);
        
        	CConnectionSender *GetSender (void);
        
        	CMessage *GetMessageForID (unsigned long messageID);
        	CMessage *WaitMessageForID (unsigned long messageID);
        
        	BOOL IsReceiverStarted (void);
        	BOOL IsSenderStarted (void);
        
        	BOOL m_bOpenBackSent;
        	BOOL m_bCloseSent;
        	BOOL m_bServerConnection;
        
        	void SetSocket (CConnectionSocket *aSocket);
        	void SetSender (CConnectionSender *aSender);
        	void SetServerSession (CServerSession *aSession);

			BOOL SetConnectionParam (CStringToObjectCollection *param);
              
#ifdef PASS_SSL
        	// SSL
        	void SetSecuredConnection (BOOL flag);
        	void SetSSLCTX (SSL_CTX *ctx);
        	void SetCertificateFile (char *file);
        	char *GetCertificateFile (void);
        	void SetPrivateKeyFile (char *file);
#endif //PASS_SSL
                
	private:
	CMessage *_GetMessageForID (unsigned long messageID);
  
        protected:
        
        	unsigned short m_RemoteServerPort;
        	unsigned short m_ReceivePort;
        	char *m_RemoteServerName;
        	char *m_RemoteServerIP;
        	char *m_BackIP;
        
        	BOOL m_bReceiverStarted;
        	BOOL m_bSenderStarted;
                
 	   	    BOOL m_bConnectionOpened;
    
        	CMessageStack *m_ReceiveStack;
        	CMessageStack *m_SendStack;
        	CConnectionSender *sender;
        	CConnectionListener *receiver;
        	CConnectionSocket *socket;
        	CServerSession *m_ServerSession;
        
#ifdef PASS_SSL
        	// SSL
        	BOOL m_bSecuredConnection;
        	SSL_CTX* m_SSLctx;
        	SSL*     m_SSLssl;
        	char *m_szCertificateFile;
        	char *m_szPrivateKeyFile;        
#endif //PASS_SSL

		PASS_SYNCH lock; 

        private:
        
        	unsigned long m_ulMessageIDCounter;
			unsigned long m_WaitMessageTimeOut;
        };
        
#endif // __CONNECTION_DUAL__
