// DispatchMessage.h: interface for the CDispatchMessage class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __DISPATCHMESSAGE__
#define __DISPATCHMESSAGE__

#include "../../Include/Comm/Message.h"

class CStringToObjectCollection;

class CDispatchMessage : public CMessage  
{
public:
	CDispatchMessage(char *name);
	CDispatchMessage();
	virtual ~CDispatchMessage();

	void SetMessageType (char *type);
	char *GetMessageType (void);

    void AddValueForKey (char *key, char *value);
    void AddValueForKey (char *key, unsigned long value);
    void AddValueForKey (char *key, BYTE *value, unsigned long valueLength);

    BOOL GetValueForKey (char *key, char *value, unsigned long valueLength);
    BOOL GetValueForKey (char *key, unsigned long *value);
    BOOL GetValueForKey (char *key, BYTE *value, unsigned long valueLength);
    unsigned long GetLengthForKey (char *key);

    void AddValueForKeyInList (char *key, char *value, char *list);
    void AddValueForKeyInList (char *key, unsigned long value, char *list);
    void AddValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list);

    BOOL GetValueForKeyInList (char *key, char *value, unsigned long valueLength, char *list);
    BOOL GetValueForKeyInList (char *key, unsigned long *value, char *list);
    BOOL GetValueForKeyInList (char *key, BYTE *value, unsigned long valueLength, char *list);
    unsigned long GetLengthForKeyInList (char *key, char *list);

    BOOL Serialize (void);
    BOOL UnSerialize (struct SerializedObject* anObject);
    CObject *Clone (void);
    
protected:

	char *m_szMessageType;
    CStringToObjectCollection *m_Values;
    CStringToObjectCollection *m_Lists;
};

#endif // __DISPATCHMESSAGE__
