// DispatchMessageHandler.h: interface for the CDispatchMessageHandler class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __DISPATCHMESSAGEHANDLER__
#define __DISPATCHMESSAGEHANDLER__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Base/Thread.h"

class CDispatchMessage;

class CDispatchMessageHandler : public CThread  
{
public:
	CDispatchMessageHandler();
	CDispatchMessageHandler(char *name);
	virtual ~CDispatchMessageHandler();

    void SetMessage (CDispatchMessage* message);
	CDispatchMessage *GetMessage (void);

    void SetMessageNameHandled (char *name);
    char *GetMessageNameHandled (void);

    void SetMessageTypeHandled (char *type);
    char *GetMessageTypeHandled (void);

	void PreRun (void);
	void Run (void);
	void PostRun (void);

	virtual void PreExecute (void) = 0;
    virtual void Execute (void) = 0;
	virtual void PostExecute (void) = 0;

protected:

    CDispatchMessage *m_Message;
    char m_szMessageNameHandled[256];
	char m_szMessageTypeHandled[256];	
};

#endif // __DISPATCHMESSAGEHANDLER__
