// MessageDispatcherManager.h: interface for the CMessageDispatcherManager class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __MESSAGEDISPATCHERMANAGER__
#define __MESSAGEDISPATCHERMANAGER__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Base/Manager.h"

class CMessageDispatcher;
class CStringToObjectCollection;
class CDispatchMessage;

class CMessageDispatcherManager : public CManager  
{
public:
	CMessageDispatcherManager();
	virtual ~CMessageDispatcherManager();

	BOOL AddDispatcher (CMessageDispatcher *dispatcher);
	BOOL AddDispatcher (CMessageDispatcher *dispatcher, char *name);

	BOOL IsMessageHandled (CDispatchMessage *message);

	void AddMessage (CDispatchMessage *message);

protected:

	PASS_SYNCH lock;

	CStringToObjectCollection *m_DispatcherList;
};

#endif // __MESSAGEDISPATCHERMANAGER__
