    // MessageHandler.h: interface for the CMessageHandler class.
    //
    //////////////////////////////////////////////////////////////////////
    
#ifndef __MESSAGEHANDLER__
#define __MESSAGEHANDLER__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Base/Object.h"
    
class CMessage;
class CConnection;

class CMessageHandler : public CObject
{
public:
    CMessageHandler();
    CMessageHandler(char *name);
    virtual ~CMessageHandler();

    void SetMessage (CMessage* message);

    void SetMessageNameHandled (char *messageName);
    char *GetMessageNameHandled (void);

	void SetConnection (CConnection *connection);

    virtual void Execute (void) = 0;

protected:
    CMessage *m_Message;
  	CConnection *m_Connection;
    char *m_szMessageName;
};
    
#endif // __MESSAGEHANDLER__
