// Thread.cpp: implementation of the CThread class.  
//  
//////////////////////////////////////////////////////////////////////  
  
#include "../../Include/Base/Thread.h"  
  
#ifdef _WIN32  
#include <windows.h>  
#include <process.h>  
#endif // _WIN32  
  
#ifdef __BEOS__  
#include <OS.h>  
#endif // __BEOS__  
  
#ifdef linux  
#include <unistd.h>  
#include <stdio.h>  
#endif //linux  
  
#ifdef __SCO__  
#include <unistd.h>  
#include <stdio.h>  
#include <signal.h>  
#include <thread.h> 
#include <synch.h> 
#endif // __SCO__  
  
#ifdef __HPUX__  
#include <stdio.h>  
#include <unistd.h>
#endif // __HPUX__  
   
    //////////////////////////////////////////////////////////////////////  
    // Construction/Destruction  
    //////////////////////////////////////////////////////////////////////  
      
    CThread::CThread() : CObject ("Thread","Thread")  
    {  
#ifdef _WIN32  
    	m_hCloseEvent = NULL;  
    	m_hThread = NULL;  
#endif // _WIN32  
#ifdef linux  
  		m_hThread = 0;  
  		pthread_mutex_init (&m_InternalLock,0);  
  		m_CloseFlag = 0;
		pthread_attr_init (&m_attribute);
#endif //linux  
#ifdef __SCO__  
		m_hThread = 0;  
		mutex_init (&m_InternalLock,USYNC_THREAD,NULL);  
  		m_CloseFlag = 0;  
#endif //__SCO__  
#ifdef __BEOS__ 
		m_hThread = 0; 
		PASS_INITLOCK (&m_InternalLock);
  		m_CloseFlag = 0; 
#endif //__BEOS__ 
#ifdef __HPUX__  
  		m_hThread = 0;  
  		pthread_mutex_init (&m_InternalLock,0);  
  		m_CloseFlag = 0;  
#endif //__HPUX__  
  
    	m_dwTickTime = 0;  
    	m_bRunningFlag = FALSE;  
    }  
      
    CThread::CThread(char *name, char *type) : CObject (name,type)  
    {  
  #ifdef _WIN32  
    	m_hCloseEvent = NULL;  
    	m_hThread = NULL;  
  #endif // _WIN32  
  #ifdef linux  
  	m_hThread = 0;  
  	pthread_mutex_init (&m_InternalLock,0);  
  	m_CloseFlag = 0;  
	pthread_attr_init (&m_attribute);
#endif //linux  
#ifdef __SCO__  
		m_hThread = 0;  
		mutex_init (&m_InternalLock,USYNC_THREAD,NULL);  
  		m_CloseFlag = 0;  
#endif //__SCO__  
#ifdef __BEOS__ 
		m_hThread = 0; 
		PASS_INITLOCK (&m_InternalLock); 
  		m_CloseFlag = 0; 
#endif //__BEOS__ 
  #ifdef __HPUX__  
  	m_hThread = 0;  
  	pthread_mutex_init (&m_InternalLock,0);  
  	m_CloseFlag = 0;  
  #endif //__HPUX__  
    	m_dwTickTime = 0;  
    	m_bRunningFlag = FALSE;  
    }  
      
    CThread::~CThread()  
    {  
  #ifdef _WIN32  
    	if (m_hCloseEvent != NULL)  
    	{  
    		CloseHandle (m_hCloseEvent);  
    	}  
  #endif // _WIN32  
  #ifdef linux  
  	pthread_mutex_destroy (&m_InternalLock);
	pthread_attr_init (&m_attribute);
  #endif //linux  
#ifdef __SCO__  
	mutex_destroy (&m_InternalLock);  
#endif //__SCO__  
#ifdef __BEOS__ 
	PASS_DESTROYLOCK (&m_InternalLock); 
#endif //__BEOS__ 
  #ifdef __HPUX__  
  	pthread_mutex_destroy (&m_InternalLock);  
  #endif //__HPUX__  
    }  
      
    DWORD CThread::Start (void)  
    {  
    	DWORD dwRetCode = 0L; 
 
		// If thread already running, just return 0 
		if (m_bRunningFlag == TRUE) 
		{ 
			return 0L; 
		} 
       	m_bRunningFlag = TRUE;  
      
  #ifdef _WIN32  
    // Create the event that will signal the threads to close.  
        m_hCloseEvent = CreateEvent(NULL, TRUE, FALSE, NULL);  
    	  
    // Create the thread        
     	//m_hThread = (HANDLE) _beginthread (ThreadProc, 0, this);  
        DWORD dwThreadId = 0;
        m_hThread = ::CreateThread(NULL, 0, ThreadProc, this, 0, &dwThreadId);
  #endif // _WIN32  
  
  #ifdef linux  
  	// Create the thread  
	pthread_attr_setdetachstate (&m_attribute, PTHREAD_CREATE_DETACHED);
  	pthread_create( &m_hThread, &m_attribute, ThreadProc, this);  
  #endif //linux  
#ifdef __SCO__  
	// Create the thread  
	thr_create( NULL,0,ThreadProc,this,0,&m_hThread);  
#endif //__SCO__  
#ifdef __BEOS__
	m_hThread = spawn_thread (ThreadProc,NULL,B_NORMAL_PRIORITY,(void *)this);
#endif // __BEOS__
  #ifdef __HPUX__  
  	// Create the thread  
  	pthread_create( &m_hThread, 0, ThreadProc, this);  
  #endif //__HPUX__  
      
    	return dwRetCode;  
    }  
      
    DWORD CThread::Stop (void)  
    {  
    	DWORD dwRetCode = 0L;  
#ifdef _WIN32        
        if (m_hThread)  
    	{  
    		// Signal the event to close the worker threads.  
    		SetEvent(m_hCloseEvent);        
    	}  
#endif // _WIN32  
#ifdef linux  
  	if (m_hThread)  
  	{  
  		// Internal lock  
  		pthread_mutex_lock (&m_InternalLock);  
  		m_CloseFlag = 1;  
  		pthread_mutex_unlock (&m_InternalLock);  
  	}  
#endif //linux  
#ifdef __SCO__  
	if (m_hThread)  
	{  
		// Internal lock  
	  	mutex_lock (&m_InternalLock);  
		m_CloseFlag = 1;  
	  	mutex_unlock (&m_InternalLock);  
	}  
#endif //__SCO__  
#ifdef __BEOS__  
	if (m_hThread)  
	{  
		// Internal lock  
	  	PASS_LOCK (&m_InternalLock);  
		m_CloseFlag = 1;  
	  	PASS_UNLOCK (&m_InternalLock);  
	}  
#endif //__BEOS__  
#ifdef __HPUX__  
  	if (m_hThread)  
  	{  
  		// Internal lock  
  		pthread_mutex_lock (&m_InternalLock);  
  		m_CloseFlag = 1;  
  		pthread_mutex_unlock (&m_InternalLock);  
  	}  
#endif //__HPUX__  
      
    	return dwRetCode;  
    }  
      
    void CThread::Kill (void)  
    {  
#ifdef _WIN32
        if(m_hThread != NULL)
        {
    	    TerminateThread(m_hThread, 0);  
        }
#endif // _WIN32  
#ifdef linux  
	 	pthread_kill (m_hThread,0);  
#endif //linux  
#ifdef __SCO__  
	 	thr_kill (m_hThread,SIGQUIT);  
#endif // __SCO__  
#ifdef __BEOS__  
	 	kill_thread (m_hThread);
#endif // __BEOS__  
#ifdef __HPUX__  
	 	pthread_kill (m_hThread,0);  
#endif //__HPUX__  
    	m_bRunningFlag = FALSE;  
    	m_bCanBeDeleted = TRUE;  
#ifdef _WIN32  
        if(m_hCloseEvent != NULL)
        {
    	    CloseHandle (m_hCloseEvent);  
        }
    	m_hCloseEvent = NULL;  
    	m_hThread = NULL;  
#endif // _WIN32  
#ifdef linux  
 	m_hThread = 0;  
 	m_CloseFlag = 1;  
#endif //linux  
#ifdef __SCO__  
	m_hThread = 0;  
	m_CloseFlag = 1;  
#endif //__SCO__  
#ifdef __BEOS__  
	m_hThread = 0;  
	m_CloseFlag = 1;  
#endif //__BEOS__  
#ifdef __HPUX__  
 	m_hThread = 0;  
 	m_CloseFlag = 1;  
#endif //__HPUX__  
    }  
      
#ifdef _WIN32  
 DWORD CThread::ThreadProc (void *mySelf)  
#endif //_WIN32  
#ifdef linux  
 void *CThread::ThreadProc (void *mySelf)  
#endif //linux  
#ifdef __SCO__  
 void *CThread::ThreadProc (void *mySelf)  
#endif // __SCO__  
#ifdef __BEOS__  
 int32 CThread::ThreadProc (void *mySelf)  
#endif // __BEOS__  
#ifdef __HPUX__  
 void *CThread::ThreadProc (void *mySelf)  
#endif //__HPUX__  
    {  
#ifdef _WIN32  
    	CThread *pObject = static_cast<CThread *>(mySelf);  
#endif // _WIN32  
#ifdef linux  
    	CThread *pObject = static_cast<CThread *>(mySelf);  
#endif // linux  
#ifdef __SCO__  
    	CThread *pObject = (CThread *)(mySelf);  
#endif // __SCO__  
#ifdef __BEOS__  
    	CThread *pObject = (CThread *)(mySelf);  
#endif // __BEOS__  
#ifdef __HPUX__  
    	CThread *pObject = static_cast<CThread *>(mySelf);  
#endif // __HPUX__  

    	pObject->InternalHandler();  
		pObject->m_bRunningFlag = FALSE;
    	pObject->m_bCanBeDeleted = TRUE;  

#ifdef _WIN32  
 	return 0;  
#endif // _WIN32          
#ifdef linux  
 	return NULL;  
#endif // linux  
#ifdef __SCO__  
 	return NULL;  
#endif // __SCO__  
#ifdef __BEOS__  
 	return 0;  
#endif // __BEOS__  
#ifdef __HPUX__  
 	return NULL;  
#endif // __HPUX__  
    }  
      
    unsigned long CThread::InternalHandler (void)  
    {  
  	    DWORD dwStatus = 1;        
    	m_bRunningFlag = TRUE;  
  	  
#ifdef PASS_EXCEPTION  
    	try  
#endif // PASS_EXCEPTION  
    	{  
    		PreRun ();  
      
    		if (m_dwTickTime == 0)  
    		{  
    			Run ();  
    		}  
    		else  
    		{  
    			do  
    			{  
      
    				Tick ();  
#ifdef _WIN32
                    if(m_hCloseEvent != NULL)
                    {
    				    dwStatus = WaitForSingleObject(m_hCloseEvent, m_dwTickTime);  
                    }
                    else
                    {
                        dwStatus = WAIT_ABANDONED;
                    }

  			    } 
                while (dwStatus == WAIT_TIMEOUT); 
                DWORD dwDummy = dwStatus;
#else
				PASS_MILLISLEEP (m_dwTickTime);
#endif // _WIN32    
              
#ifdef linux  
 				pthread_mutex_lock (&m_InternalLock);  
  				if (m_CloseFlag == 1)  
  				{  
  					dwStatus = 0;  
  				}  
  				pthread_mutex_unlock (&m_InternalLock);  
    
  			} while (dwStatus == 1);  
#endif //linux  
  
#ifdef __SCO__  
 				mutex_lock (&m_InternalLock);  
  				if (m_CloseFlag == 1)  
  				{  
  					dwStatus = 0;  
  				}  
  				mutex_unlock (&m_InternalLock);  
    
  			} while (dwStatus == 1);  
#endif // __SCO__  
#ifdef __BEOS__  
 				PASS_LOCK (&m_InternalLock);  
  				if (m_CloseFlag == 1)  
  				{  
  					dwStatus = 0;  
  				}  
  				PASS_UNLOCK (&m_InternalLock);  
    
  			} while (dwStatus == 1);  
#endif // __BEOS__  
#ifdef __HPUX__  
 				pthread_mutex_lock (&m_InternalLock);  
  				if (m_CloseFlag == 1)  
  				{  
  					dwStatus = 0;  
  				}  
  				pthread_mutex_unlock (&m_InternalLock);  
    
  			} while (dwStatus == 1);  
#endif //__HPUX__  
  
#ifdef _WIN32  
	  		if (dwStatus != WAIT_OBJECT_0)  
    		{  
    			// Wait failed.  Shouldn't happen. 
                if(m_hCloseEvent != NULL)
                {
    				CloseHandle (m_hCloseEvent);  
                }
    			m_hCloseEvent = NULL;  
    			m_hThread = NULL;  
    	        m_bRunningFlag = FALSE;  
  				return GetLastError();  
    		}  
#endif // _WIN32  
    		}  
      
    		PostRun();  
    	}  
#ifdef PASS_EXCEPTION  
    	catch (...)  
#endif // PASS_EXCEPTION  
    	{  
    	    m_bRunningFlag = FALSE;  
#ifdef _WIN32  
            if(m_hCloseEvent != NULL)
            {
    		    CloseHandle (m_hCloseEvent);  
            }
    		m_hCloseEvent = NULL;  
    		m_hThread = NULL;  
  		    return 0;  
#endif // _WIN32  
#ifdef linux  
  		pthread_mutex_lock (&m_InternalLock);  
  		m_hThread = 0;  
  		pthread_mutex_unlock (&m_InternalLock);  
#endif //linux  
#ifdef __BEOS__  
  		PASS_LOCK (&m_InternalLock);  
  		m_hThread = 0;  
  		PASS_UNLOCK (&m_InternalLock);  
#endif //__BEOS__  
#ifdef __HPUX__  
  		pthread_mutex_lock (&m_InternalLock);  
  		m_hThread = 0;  
  		pthread_mutex_unlock (&m_InternalLock);  
  		//pthread_exit(0);  
#endif //__HPUX__  
        return 1;
    	}  
      
    	m_bRunningFlag = FALSE;  
  
#ifdef _WIN32  
        if(m_hCloseEvent != NULL)
        {
        	CloseHandle (m_hCloseEvent);  
        }
    	 m_hCloseEvent = NULL;  
    	 m_hThread = NULL;  
#endif // _WIN32  
  
#ifdef linux  
	  	pthread_mutex_lock (&m_InternalLock);  
  		m_hThread = 0;  
  		m_CloseFlag = 1;  
  		pthread_mutex_unlock (&m_InternalLock);  
#endif //linux  
  
#ifdef __SCO__  
	  	mutex_lock (&m_InternalLock);  
  		m_hThread = 0;  
  		m_CloseFlag = 1;  
  		mutex_unlock (&m_InternalLock);  
#endif // __SCO__  
#ifdef __BEOS__  
	  	PASS_LOCK (&m_InternalLock);  
  		m_hThread = 0;  
  		m_CloseFlag = 1;  
  		PASS_UNLOCK (&m_InternalLock);  
#endif // __BEOS__  
#ifdef __HPUX__  
	  	pthread_mutex_lock (&m_InternalLock);  
  		m_hThread = 0;  
  		m_CloseFlag = 1;  
  		pthread_mutex_unlock (&m_InternalLock);  
#endif //__HPUX__  
  
  
#ifdef _WIN32  
 	return 0;  
#endif // _WIN32  
#ifdef linux  
  	return 1;  
#endif // linux  
#ifdef __SCO__  
  	return 1;  
#endif // __SCO__  
#ifdef __BEOS__  
  	return 1;  
#endif // __BEOS__  
#ifdef __HPUX__  
  	return 1;  
#endif // __HPUX__  
    }  
      
    void CThread::SetTickTime (DWORD time)  
    {  
    	m_dwTickTime = time;  
    }  
      
    BOOL CThread::IsRunning (void)  
    {  
    	return m_bRunningFlag;  
    }  

#ifdef _WIN32  
    unsigned long CThread::GetThreadHandle (void)  
    {  
    	return (unsigned long)m_hThread;  
    }  
#endif // _WIN32  
      
    void CThread::Release (void)  
    {  
    	Stop ();  
    }  
      
    void CThread::PreRun (void)  
    {  
    }  
      
    void CThread::Run (void)  
    {  
    }  
      
    void CThread::Tick (void)  
    {  
    }  
      
    void CThread::PostRun (void)  
    {  
    }  
 
	void CThread::CreateDescription (void) 
	{ 
		CObject::CreateDescription(); 
 	} 
